/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;
import org.unbescape.css.CssEscape;
import org.unbescape.html.HtmlEscape;
import org.unbescape.javascript.JavaScriptEscape;
import org.unbescape.xml.XmlEscape;

public final class EscapedAttributeUtils {
    public static String escapeAttribute(TemplateMode templateMode, String input) {
        if (input == null) {
            return null;
        }
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        switch (templateMode) {
            case HTML: {
                return HtmlEscape.escapeHtml4Xml(input);
            }
            case XML: {
                return XmlEscape.escapeXml10Attribute(input);
            }
        }
        throw new TemplateProcessingException("Unrecognized template mode " + (Object)((Object)templateMode) + ". Cannot produce escaped attributes for this template mode.");
    }

    public static String unescapeAttribute(TemplateMode templateMode, String input) {
        if (input == null) {
            return null;
        }
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        switch (templateMode) {
            case HTML: 
            case TEXT: {
                return HtmlEscape.unescapeHtml(input);
            }
            case XML: {
                return XmlEscape.unescapeXml(input);
            }
            case JAVASCRIPT: {
                return JavaScriptEscape.unescapeJavaScript(input);
            }
            case CSS: {
                return CssEscape.unescapeCss(input);
            }
            case RAW: {
                return input;
            }
        }
        throw new TemplateProcessingException("Unrecognized template mode " + (Object)((Object)templateMode) + ". Cannot unescape attribute value for this template mode.");
    }

    private EscapedAttributeUtils() {
    }
}

