/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.FhirPublication;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.utils.NarrativeGenerator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.type.MeasureContext;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidatorHostContext;
import org.w3c.dom.Document;

public class MeasureValidator
extends BaseValidator {
    public MeasureValidator(IWorkerContext context, TimeTracker timeTracker) {
        super(context);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.timeTracker = timeTracker;
    }

    public void validateMeasure(ValidatorHostContext hostContext, List<ValidationMessage> errors, Element element, NodeStack stack) throws FHIRException {
        MeasureContext mctxt = new MeasureContext();
        List<Element> libs = element.getChildrenByName("library");
        for (Element lib : libs) {
            String ref = lib.isPrimitive() ? lib.primitiveValue() : lib.getChildValue("reference");
            if (Utilities.noString(ref)) continue;
            Library l = this.context.fetchResource(Library.class, ref);
            if (!this.hint(errors, ValidationMessage.IssueType.NOTFOUND, lib.line(), lib.col(), stack.getLiteralPath(), l != null, "MEASURE_M_LIB_UNKNOWN", ref)) continue;
            mctxt.seeLibrary(l);
        }
        List<Element> groups = element.getChildrenByName("group");
        if (this.warning(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), groups.size() > 0, "MEASURE_M_NO_GROUPS", new Object[0])) {
            int c = 0;
            for (Element group : groups) {
                NodeStack ns = stack.push(group, c, null, null);
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, group.line(), group.col(), ns.getLiteralPath(), groups.size() == 1 || group.hasChild("code"), "MEASURE_M_GROUP_CODE", new Object[0]);
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, group.line(), group.col(), ns.getLiteralPath(), group.hasChildren("population"), "MEASURE_M_GROUP_POP", new Object[0]);
                int c1 = 0;
                List<Element> pl = group.getChildrenByName("population");
                for (Element p : pl) {
                    NodeStack ns2 = ns.push(p, c1, null, null);
                    this.warning(errors, ValidationMessage.IssueType.REQUIRED, p.line(), p.col(), ns2.getLiteralPath(), pl.size() == 1 || p.hasChild("code"), "MEASURE_M_GROUP_POP_NO_CODE", new Object[0]);
                    ++c1;
                }
                c1 = 0;
                List<Element> stl = group.getChildrenByName("stratifier");
                for (Element st : stl) {
                    NodeStack ns2 = ns.push(st, c1, null, null);
                    this.warning(errors, ValidationMessage.IssueType.REQUIRED, st.line(), st.col(), ns2.getLiteralPath(), stl.size() == 1 || st.hasChild("code"), "MEASURE_M_GROUP_STRATA_NO_CODE", new Object[0]);
                    if (st.hasChild("criteria")) {
                        Element crit = st.getNamedChild("criteria");
                        NodeStack nsc = ns2.push(crit, -1, null, null);
                        this.validateMeasureCriteria(hostContext, errors, mctxt, crit, nsc);
                    }
                    int c2 = 0;
                    List<Element> cpl = group.getChildrenByName("component");
                    for (Element cp : cpl) {
                        NodeStack ns3 = ns2.push(cp, c2, null, null);
                        this.warning(errors, ValidationMessage.IssueType.REQUIRED, cp.line(), cp.col(), ns3.getLiteralPath(), cpl.size() == 1 || cp.hasChild("code"), "MEASURE_M_GROUP_STRATA_COMP_NO_CODE", new Object[0]);
                        if (cp.hasChild("criteria")) {
                            Element crit = cp.getNamedChild("criteria");
                            NodeStack nsc = ns3.push(crit, -1, null, null);
                            this.validateMeasureCriteria(hostContext, errors, mctxt, crit, nsc);
                        }
                        ++c2;
                    }
                    ++c1;
                }
                ++c;
            }
        }
    }

    private void validateMeasureCriteria(ValidatorHostContext hostContext, List<ValidationMessage> errors, MeasureContext mctxt, Element crit, NodeStack nsc) {
        String mimeType = crit.getChildValue("language");
        if (!Utilities.noString(mimeType)) {
            if ("text/cql".equals(mimeType)) {
                String cqlRef = crit.getChildValue("expression");
                Base lib = null;
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), mctxt.libraries().size() > 0, "MEASURE_M_CRITERIA_CQL_NO_LIB", new Object[0])) {
                    if (cqlRef.contains(".")) {
                        String name = cqlRef.substring(0, cqlRef.indexOf("."));
                        cqlRef = cqlRef.substring(cqlRef.indexOf(".") + 1);
                        for (Library l : mctxt.libraries()) {
                            if (!name.equals(l.getName()) || !this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), lib == null, "MEASURE_M_CRITERIA_CQL_LIB_DUPL", new Object[0])) continue;
                            lib = l;
                        }
                        this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), lib != null, "MEASURE_M_CRITERIA_CQL_LIB_NOT_FOUND", name);
                    } else if (this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), mctxt.libraries().size() == 1, "MEASURE_M_CRITERIA_CQL_ONLY_ONE_LIB", new Object[0])) {
                        lib = mctxt.libraries().get(0);
                    }
                }
                if (lib != null && this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), lib.hasUserData("validator.ELM"), "MEASURE_M_CRITERIA_CQL_NO_ELM", ((Library)lib).getUrl())) {
                    if (lib.getUserData("validator.ELM") instanceof String) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), false, "MEASURE_M_CRITERIA_CQL_ERROR", ((Library)lib).getUrl(), lib.getUserString("validator.ELM"));
                    } else if (lib.getUserData("validator.ELM") instanceof Document) {
                        org.w3c.dom.Element elm = ((Document)lib.getUserData("validator.ELM")).getDocumentElement();
                        if (this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), this.isValidElm(elm), "MEASURE_M_CRITERIA_CQL_ELM_NOT_VALID", ((Library)lib).getUrl(), cqlRef)) {
                            this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), this.hasCqlTarget(elm, cqlRef), "MEASURE_M_CRITERIA_CQL_NOT_FOUND", ((Library)lib).getUrl(), cqlRef);
                        }
                    }
                }
            } else if ("text/fhirpath".equals(mimeType)) {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, crit.line(), crit.col(), nsc.getLiteralPath(), false, "MEASURE_M_CRITERIA_UNKNOWN", mimeType);
            } else if ("application/x-fhir-query".equals(mimeType)) {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, crit.line(), crit.col(), nsc.getLiteralPath(), false, "MEASURE_M_CRITERIA_UNKNOWN", mimeType);
            } else {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, crit.line(), crit.col(), nsc.getLiteralPath(), false, "MEASURE_M_CRITERIA_UNKNOWN", mimeType);
            }
        }
    }

    private boolean isValidElm(org.w3c.dom.Element elm) {
        return elm != null && "library".equals(elm.getNodeName()) && "urn:hl7-org:elm:r1".equals(elm.getNamespaceURI());
    }

    private boolean hasCqlTarget(org.w3c.dom.Element element, String cqlRef) {
        org.w3c.dom.Element stmts = XMLUtil.getNamedChild(element, "statements");
        if (stmts != null) {
            for (org.w3c.dom.Element def : XMLUtil.getNamedChildren(stmts, "def")) {
                if (!cqlRef.equals(def.getAttribute("name"))) continue;
                return true;
            }
        }
        return false;
    }

    public void validateMeasureReport(ValidatorHostContext hostContext, List<ValidationMessage> errors, Element element, NodeStack stack) throws FHIRException {
        Element m3 = element.getNamedChild("measure");
        String measure = null;
        if (m3 != null) {
            if (StringUtils.isNotBlank(m3.getValue())) {
                measure = m3.getValue();
            } else if (StringUtils.isNotBlank(m3.getChildValue("reference"))) {
                measure = m3.getChildValue("reference");
            }
        }
        if (this.hint(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), measure != null, "Measure_MR_M_None")) {
            long t = System.nanoTime();
            Measure msrc = measure.startsWith("#") ? this.loadMeasure(element, measure.substring(1)) : this.context.fetchResource(Measure.class, measure);
            this.timeTracker.sd(t, System.nanoTime());
            if (this.warning(errors, ValidationMessage.IssueType.REQUIRED, m3.line(), m3.col(), stack.getLiteralPath(), msrc != null, "Measure_MR_M_NotFound", measure)) {
                boolean inComplete = !"complete".equals(element.getNamedChildValue("status"));
                MeasureContext mc = new MeasureContext(msrc, element);
                NodeStack ns = stack.push(m3, -1, m3.getProperty().getDefinition(), m3.getProperty().getDefinition());
                this.hint(errors, ValidationMessage.IssueType.BUSINESSRULE, m3.line(), m3.col(), ns.getLiteralPath(), Utilities.existsInList(mc.scoring(), "proportion", "ratio", "continuous-variable", "cohort"), "MEASURE_MR_M_SCORING_UNK");
                this.validateMeasureReportGroups(hostContext, mc, errors, element, stack, inComplete);
            }
        }
    }

    private Measure loadMeasure(Element resource, String id) throws FHIRException {
        try {
            for (Element contained : resource.getChildren("contained")) {
                if (!contained.getIdBase().equals(id)) continue;
                FhirPublication v = FhirPublication.fromCode(this.context.getVersion());
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                new org.hl7.fhir.r5.elementmodel.JsonParser(this.context).compose(contained, bs, IParser.OutputStyle.NORMAL, id);
                byte[] json = bs.toByteArray();
                switch (v) {
                    case DSTU1: {
                        throw new FHIRException(this.context.formatMessage("Unsupported_version_R1", new Object[0]));
                    }
                    case DSTU2: {
                        throw new FHIRException(this.context.formatMessage("Unsupported_version_R2", new Object[0]));
                    }
                    case DSTU2016May: {
                        throw new FHIRException(this.context.formatMessage("Unsupported_version_R2B", new Object[0]));
                    }
                    case STU3: {
                        Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(json);
                        org.hl7.fhir.r5.model.Resource r5 = VersionConvertor_30_50.convertResource(r3, false);
                        if (r5 instanceof Measure) {
                            return (Measure)r5;
                        }
                        return null;
                    }
                    case R4: {
                        org.hl7.fhir.r4.model.Resource r4 = new JsonParser().parse(json);
                        org.hl7.fhir.r5.model.Resource r5 = VersionConvertor_40_50.convertResource(r4);
                        if (r5 instanceof Measure) {
                            return (Measure)r5;
                        }
                        return null;
                    }
                    case R5: {
                        org.hl7.fhir.r5.model.Resource r5 = new org.hl7.fhir.r5.formats.JsonParser().parse(json);
                        if (r5 instanceof Measure) {
                            return (Measure)r5;
                        }
                        return null;
                    }
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new FHIRException(e);
        }
    }

    private void validateMeasureReportGroups(ValidatorHostContext hostContext, MeasureContext m3, List<ValidationMessage> errors, Element mr, NodeStack stack, boolean inProgress) {
        NarrativeGenerator gen = new NarrativeGenerator(null, null, this.context);
        ArrayList<Measure.MeasureGroupComponent> groups = new ArrayList<Measure.MeasureGroupComponent>();
        List<Element> glist = mr.getChildrenByName("group");
        if (glist.size() == 1 && m3.groups().size() == 1) {
            Element mrg = glist.get(0);
            NodeStack ns = stack.push(mrg, 0, mrg.getProperty().getDefinition(), mrg.getProperty().getDefinition());
            if (m3.groups().get(0).hasCode() && mrg.hasChild("code")) {
                CodeableConcept cc = ObjectConverter.readAsCodeableConcept(mrg.getNamedChild("code"));
                if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), this.hasUseableCode(cc), "MEASURE_MR_GRP_NO_USABLE_CODE", new Object[0])) {
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), cc.matches(m3.groups().get(0).getCode()), "MEASURE_MR_GRP_NO_WRONG_CODE", gen.gen(cc), gen.gen(m3.groups().get(0).getCode()));
                }
            }
            this.validateMeasureReportGroup(hostContext, m3, m3.groups().get(0), errors, mrg, ns, inProgress, gen);
        } else {
            int i = 0;
            for (Element mrg : glist) {
                NodeStack ns = stack.push(mrg, i, mrg.getProperty().getDefinition(), mrg.getProperty().getDefinition());
                CodeableConcept cc = ObjectConverter.readAsCodeableConcept(mrg.getNamedChild("code"));
                if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), cc != null, "MEASURE_MR_GRP_NO_CODE", new Object[0])) {
                    Measure.MeasureGroupComponent mg = this.getGroupForCode(cc, m3.measure());
                    if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), mg != null, "MEASURE_MR_GRP_UNK_CODE", new Object[0]) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), !groups.contains(mg), "MEASURE_MR_GRP_DUPL_CODE", new Object[0])) {
                        groups.add(mg);
                        this.validateMeasureReportGroup(hostContext, m3, mg, errors, mrg, ns, inProgress, gen);
                    }
                }
                ++i;
            }
            for (Measure.MeasureGroupComponent mg : m3.groups()) {
                if (groups.contains(mg)) continue;
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mr.line(), mr.col(), stack.getLiteralPath(), groups.contains(mg), "MEASURE_MR_GRP_MISSING_BY_CODE", gen.gen(mg.getCode()));
            }
        }
    }

    private void validateMeasureReportGroup(ValidatorHostContext hostContext, MeasureContext m3, Measure.MeasureGroupComponent mg, List<ValidationMessage> errors, Element mrg, NodeStack ns, boolean inProgress, NarrativeGenerator gen) {
        this.validateMeasureReportGroupPopulations(hostContext, m3, mg, errors, mrg, ns, inProgress, gen);
        this.validateScore(hostContext, m3, errors, mrg, ns, inProgress, gen);
        this.validateMeasureReportGroupStratifiers(hostContext, m3, mg, errors, mrg, ns, inProgress, gen);
    }

    private void validateScore(ValidatorHostContext hostContext, MeasureContext m3, List<ValidationMessage> errors, Element mrg, NodeStack stack, boolean inProgress, NarrativeGenerator gen) {
        Element ms = mrg.getNamedChild("measureScore");
        if ("data-collection".equals(m3.reportType())) {
            this.banned(errors, stack, ms, "MEASURE_MR_SCORE_PROHIBITED_RT", new Object[0]);
        } else if ("cohort".equals(m3.scoring())) {
            this.banned(errors, stack, ms, "MEASURE_MR_SCORE_PROHIBITED_MS", new Object[0]);
        } else if (Utilities.existsInList(m3.scoring(), "proportion", "ratio", "continuous-variable") && this.rule(errors, ValidationMessage.IssueType.REQUIRED, mrg.line(), mrg.col(), stack.getLiteralPath(), ms != null, "MEASURE_MR_SCORE_REQUIRED", m3.scoring())) {
            NodeStack ns = stack.push(ms, -1, ms.getProperty().getDefinition(), ms.getProperty().getDefinition());
            Element v = ms.getNamedChild("value");
            if ("proportion".equals(m3.scoring())) {
                this.banned(errors, ns, ms, "unit", "MEASURE_MR_SCORE_UNIT_PROHIBITED", "proportion");
                this.banned(errors, ns, ms, "system", "MEASURE_MR_SCORE_UNIT_PROHIBITED", "proportion");
                this.banned(errors, ns, ms, "code", "MEASURE_MR_SCORE_UNIT_PROHIBITED", "proportion");
                if (this.rule(errors, ValidationMessage.IssueType.REQUIRED, ms.line(), ms.col(), ns.getLiteralPath(), v != null, "MEASURE_MR_SCORE_VALUE_REQUIRED", new Object[0])) {
                    try {
                        BigDecimal dec = new BigDecimal(v.primitiveValue());
                        NodeStack nsv = ns.push(v, -1, v.getProperty().getDefinition(), v.getProperty().getDefinition());
                        this.rule(errors, ValidationMessage.IssueType.REQUIRED, v.line(), v.col(), nsv.getLiteralPath(), dec.compareTo(new BigDecimal(0)) >= 0 && dec.compareTo(new BigDecimal(1)) <= 0, "MEASURE_MR_SCORE_VALUE_INVALID_01", new Object[0]);
                    }
                    catch (Exception dec) {}
                }
            } else if ("ratio".equals(m3.scoring())) {
                if (this.rule(errors, ValidationMessage.IssueType.REQUIRED, ms.line(), ms.col(), ns.getLiteralPath(), v != null, "MEASURE_MR_SCORE_VALUE_REQUIRED", new Object[0])) {
                    Coding c;
                    Element unit = ms.getNamedChild("code");
                    Coding coding = c = m3.measure().hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-unit") ? (Coding)m3.measure().getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-unit").getValue() : null;
                    if (unit != null) {
                        if (c != null) {
                            NodeStack nsc = ns.push(unit, -1, unit.getProperty().getDefinition(), unit.getProperty().getDefinition());
                            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, unit.line(), unit.col(), nsc.getLiteralPath(), c.getCode().equals(unit.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getCode());
                            Element system = ms.getNamedChild("system");
                            if (system == null) {
                                NodeStack nss = system == null ? ns : ns.push(system, -1, system.getProperty().getDefinition(), system.getProperty().getDefinition());
                                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, system.line(), system.col(), nss.getLiteralPath(), c.getSystem().equals(system.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getSystem());
                            } else {
                                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, ms.line(), ms.col(), ns.getLiteralPath(), c.getSystem().equals(system.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getSystem());
                            }
                        }
                    } else if (c != null) {
                        this.rule(errors, ValidationMessage.IssueType.NOTFOUND, ms.line(), ms.col(), ns.getLiteralPath(), false, "MEASURE_MR_SCORE_FIXED", gen.gen(c));
                    } else {
                        this.warning(errors, ValidationMessage.IssueType.NOTFOUND, ms.line(), ms.col(), ns.getLiteralPath(), false, "MEASURE_MR_SCORE_UNIT_REQUIRED", "ratio");
                    }
                }
            } else if ("continuous-variable".equals(m3.scoring()) && this.rule(errors, ValidationMessage.IssueType.REQUIRED, ms.line(), ms.col(), ns.getLiteralPath(), v != null, "MEASURE_MR_SCORE_VALUE_REQUIRED", new Object[0])) {
                Coding c;
                Element unit = ms.getNamedChild("code");
                Coding coding = c = m3.measure().hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-unit") ? (Coding)m3.measure().getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-unit").getValue() : null;
                if (unit != null) {
                    if (c != null) {
                        NodeStack nsc = ns.push(unit, -1, unit.getProperty().getDefinition(), unit.getProperty().getDefinition());
                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, unit.line(), unit.col(), nsc.getLiteralPath(), c.getCode().equals(unit.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getCode());
                        Element system = ms.getNamedChild("system");
                        if (system == null) {
                            NodeStack nss = system == null ? ns : ns.push(system, -1, system.getProperty().getDefinition(), system.getProperty().getDefinition());
                            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, system.line(), system.col(), nss.getLiteralPath(), c.getSystem().equals(system.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getSystem());
                        } else {
                            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, ms.line(), ms.col(), ns.getLiteralPath(), c.getSystem().equals(system.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getSystem());
                        }
                    }
                } else if (c != null) {
                    this.rule(errors, ValidationMessage.IssueType.NOTFOUND, ms.line(), ms.col(), ns.getLiteralPath(), false, "MEASURE_MR_SCORE_FIXED", gen.gen(c));
                }
            }
        }
    }

    private void banned(List<ValidationMessage> errors, NodeStack stack, Element parent, String childName, String msgId, Object ... params) {
        Element child = parent.getNamedChild(childName);
        this.banned(errors, stack, child, msgId, params);
    }

    private void banned(List<ValidationMessage> errors, NodeStack stack, Element e, String msgId, Object ... params) {
        if (e != null) {
            NodeStack ns = stack.push(e, -1, e.getProperty().getDefinition(), e.getProperty().getDefinition());
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, e.line(), e.col(), ns.getLiteralPath(), false, msgId, params);
        }
    }

    private void validateMeasureReportGroupPopulations(ValidatorHostContext hostContext, MeasureContext m3, Measure.MeasureGroupComponent mg, List<ValidationMessage> errors, Element mrg, NodeStack stack, boolean inProgress, NarrativeGenerator gen) {
        ArrayList<Measure.MeasureGroupPopulationComponent> pops = new ArrayList<Measure.MeasureGroupPopulationComponent>();
        List<Element> plist = mrg.getChildrenByName("population");
        int i = 0;
        for (Element mrgp : plist) {
            NodeStack ns = stack.push(mrgp, i, mrgp.getProperty().getDefinition(), mrgp.getProperty().getDefinition());
            CodeableConcept cc = ObjectConverter.readAsCodeableConcept(mrgp.getNamedChild("code"));
            if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgp.line(), mrgp.col(), ns.getLiteralPath(), cc != null, "MEASURE_MR_GRP_POP_NO_CODE", new Object[0])) {
                Measure.MeasureGroupPopulationComponent mgp = this.getGroupPopForCode(cc, mg);
                if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), mgp != null, "MEASURE_MR_GRP_POP_UNK_CODE", new Object[0]) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), !pops.contains(mgp), "MEASURE_MR_GRP_POP_DUPL_CODE", new Object[0])) {
                    pops.add(mgp);
                    this.validateMeasureReportGroupPopulation(hostContext, m3, mgp, errors, mrgp, ns, inProgress);
                }
            }
            ++i;
        }
        for (Measure.MeasureGroupPopulationComponent mgp : mg.getPopulation()) {
            if (pops.contains(mgp) || mgp.getCode().hasCoding("http://terminology.hl7.org/CodeSystem/measure-population", "measure-observation")) continue;
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), stack.getLiteralPath(), pops.contains(mg), "MEASURE_MR_GRP_MISSING_BY_CODE", gen.gen(mgp.getCode()));
        }
    }

    private void validateMeasureReportGroupPopulation(ValidatorHostContext hostContext, MeasureContext m3, Measure.MeasureGroupPopulationComponent mgp, List<ValidationMessage> errors, Element mrgp, NodeStack ns, boolean inProgress) {
        List<Element> sr = mrgp.getChildrenByName("subjectResults");
        if ("subject-list".equals(m3.reportType())) {
            try {
                int c = Integer.parseInt(mrgp.getChildValue("count"));
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgp.line(), mrgp.col(), ns.getLiteralPath(), c == sr.size(), "MEASURE_MR_GRP_POP_COUNT_MISMATCH", c, sr.size());
            }
            catch (Exception exception) {}
        } else {
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgp.line(), mrgp.col(), ns.getLiteralPath(), sr.size() == 0, "MEASURE_MR_GRP_POP_NO_SUBJECTS", new Object[0]);
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgp.line(), mrgp.col(), ns.getLiteralPath(), mrgp.hasChild("count"), "MEASURE_MR_GRP_POP_NO_COUNT", new Object[0]);
        }
    }

    private void validateMeasureReportGroupStratifiers(ValidatorHostContext hostContext, MeasureContext m3, Measure.MeasureGroupComponent mg, List<ValidationMessage> errors, Element mrg, NodeStack stack, boolean inProgress, NarrativeGenerator gen) {
        ArrayList<Measure.MeasureGroupStratifierComponent> strats = new ArrayList<Measure.MeasureGroupStratifierComponent>();
        List<Element> slist = mrg.getChildrenByName("stratifier");
        int i = 0;
        for (Element mrgs : slist) {
            NodeStack ns = stack.push(mrgs, i, mrgs.getProperty().getDefinition(), mrgs.getProperty().getDefinition());
            CodeableConcept cc = ObjectConverter.readAsCodeableConcept(mrgs.getNamedChild("code"));
            if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgs.line(), mrgs.col(), ns.getLiteralPath(), cc != null, "MEASURE_MR_GRP_POP_NO_CODE", new Object[0])) {
                Measure.MeasureGroupStratifierComponent mgs = this.getGroupStratifierForCode(cc, mg);
                if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), mgs != null, "MEASURE_MR_GRP_POP_UNK_CODE", new Object[0]) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), !strats.contains(mgs), "MEASURE_MR_GRP_POP_DUPL_CODE", new Object[0])) {
                    strats.add(mgs);
                    this.validateMeasureReportGroupStratifier(hostContext, m3, mgs, errors, mrgs, ns, inProgress);
                }
            }
            ++i;
        }
        for (Measure.MeasureGroupStratifierComponent mgs : mg.getStratifier()) {
            if (strats.contains(mgs)) continue;
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), stack.getLiteralPath(), strats.contains(mg), "MEASURE_MR_GRP_MISSING_BY_CODE", gen.gen(mgs.getCode()));
        }
    }

    private void validateMeasureReportGroupStratifier(ValidatorHostContext hostContext, MeasureContext m3, Measure.MeasureGroupStratifierComponent mgs, List<ValidationMessage> errors, Element mrgs, NodeStack ns, boolean inProgress) {
    }

    private Measure.MeasureGroupStratifierComponent getGroupStratifierForCode(CodeableConcept cc, Measure.MeasureGroupComponent mg) {
        for (Measure.MeasureGroupStratifierComponent t : mg.getStratifier()) {
            if (!t.hasCode()) continue;
            for (Coding c : t.getCode().getCoding()) {
                if (!cc.hasCoding(c.getSystem(), c.getCode())) continue;
                return t;
            }
            if (cc.hasCoding() || t.getCode().hasCoding() || !cc.hasText() || !t.getCode().hasText() || !cc.getText().equals(t.getCode().getText())) continue;
            return t;
        }
        return null;
    }

    private boolean hasUseableCode(CodeableConcept cc) {
        for (Coding c : cc.getCoding()) {
            if (!c.hasSystem() || !c.hasCode()) continue;
            return true;
        }
        return false;
    }

    private Measure.MeasureGroupPopulationComponent getGroupPopForCode(CodeableConcept cc, Measure.MeasureGroupComponent mg) {
        for (Measure.MeasureGroupPopulationComponent t : mg.getPopulation()) {
            if (!t.hasCode()) continue;
            for (Coding c : t.getCode().getCoding()) {
                if (!cc.hasCoding(c.getSystem(), c.getCode())) continue;
                return t;
            }
        }
        return null;
    }

    private Measure.MeasureGroupComponent getGroupForCode(CodeableConcept cc, Measure m3) {
        for (Measure.MeasureGroupComponent t : m3.getGroup()) {
            if (!t.hasCode()) continue;
            for (Coding c : t.getCode().getCoding()) {
                if (!cc.hasCoding(c.getSystem(), c.getCode())) continue;
                return t;
            }
        }
        return null;
    }
}

