/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class CodeSystemValidator
extends BaseValidator {
    public CodeSystemValidator(IWorkerContext context, TimeTracker timeTracker) {
        super(context);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.timeTracker = timeTracker;
    }

    public void validateCodeSystem(List<ValidationMessage> errors, Element cs, NodeStack stack) {
        String url = cs.getNamedChildValue("url");
        String content = cs.getNamedChildValue("content");
        String vsu = cs.getNamedChildValue("valueSet");
        if (!Utilities.noString(vsu)) {
            ValueSet vs;
            this.hint(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), "complete".equals(content), "CODESYSTEM_CS_NO_VS_NOTCOMPLETE");
            try {
                vs = this.context.fetchResourceWithException(ValueSet.class, vsu);
            }
            catch (FHIRException e) {
                vs = null;
            }
            if (vs != null && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.hasCompose() && !vs.hasExpansion(), "CodeSystem_CS_VS_MisMatch", url, vsu) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.getCompose().getInclude().size() == 1, "CodeSystem_CS_VS_Invalid", url, vsu) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.getCompose().getInclude().get(0).getSystem().equals(url), "CodeSystem_CS_VS_WrongSystem", url, vsu, vs.getCompose().getInclude().get(0).getSystem())) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !vs.getCompose().getInclude().get(0).hasValueSet() && !vs.getCompose().getInclude().get(0).hasConcept() && !vs.getCompose().getInclude().get(0).hasFilter(), "CodeSystem_CS_VS_IncludeDetails", url, vsu);
            }
        }
    }
}

