/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.XmlParser;
import org.hl7.fhir.r5.formats.FormatUtilities;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.FHIRLexer;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.EnableWhenEvaluator;
import org.hl7.fhir.validation.instance.type.CodeSystemValidator;
import org.hl7.fhir.validation.instance.type.MeasureValidator;
import org.hl7.fhir.validation.instance.type.QuestionnaireValidator;
import org.hl7.fhir.validation.instance.utils.ChildIterator;
import org.hl7.fhir.validation.instance.utils.ElementInfo;
import org.hl7.fhir.validation.instance.utils.EntrySummary;
import org.hl7.fhir.validation.instance.utils.IndexedElement;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ResolvedReference;
import org.hl7.fhir.validation.instance.utils.ResourceValidationTracker;
import org.hl7.fhir.validation.instance.utils.ValidatorHostContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InstanceValidator
extends BaseValidator
implements IResourceValidator {
    private final String META = "meta";
    private final String ENTRY = "entry";
    private final String DOCUMENT = "document";
    private final String RESOURCE = "resource";
    private final String MESSAGE = "message";
    private final String ID = "id";
    private final String PATH_ARG = ":0";
    private final String FULL_URL = "fullUrl";
    private final String TYPE = "type";
    private final String BUNDLE = "Bundle";
    private final String LAST_UPDATED = "lastUpdated";
    private FHIRPathEngine fpe;
    private IResourceValidator.CheckDisplayOption checkDisplay;
    private boolean anyExtensionsAllowed;
    private boolean errorForUnknownProfiles;
    private boolean noInvariantChecks;
    private boolean noTerminologyChecks;
    private boolean hintAboutNonMustSupport;
    private boolean showMessagesFromReferences;
    private IResourceValidator.BestPracticeWarningLevel bpWarnings;
    private String validationLanguage;
    private boolean baseOnly;
    private List<String> extensionDomains = new ArrayList<String>();
    private IResourceValidator.IdStatus resourceIdRule;
    private boolean allowXsiLocation;
    private boolean suppressLoincSnomedMessages;
    private boolean noBindingMsgSuppressed;
    private boolean debug;
    private Map<String, org.hl7.fhir.r5.elementmodel.Element> fetchCache = new HashMap<String, org.hl7.fhir.r5.elementmodel.Element>();
    private HashMap<org.hl7.fhir.r5.elementmodel.Element, ResourceValidationTracker> resourceTracker = new HashMap();
    private IResourceValidator.IValidatorResourceFetcher fetcher;
    long time = 0L;
    private FHIRPathEngine.IEvaluationContext externalHostServices;
    private boolean noExtensibleWarnings;
    private String serverBase;
    private EnableWhenEvaluator myEnableWhenEvaluator = new EnableWhenEvaluator();
    private String executionId;
    private XVerExtensionManager xverManager;
    private IResourceValidator.IValidationProfileUsageTracker tracker;
    private ValidatorHostServices validatorServices;
    private boolean assumeValidRestReferences;
    private boolean allowExamples;
    private ProfileUtilities profileUtilities;
    public static final String URI_REGEX3 = "((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AllergyIntolerance|AdverseEvent|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BodySite|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition (aka Problem)|Consent|Contract|Coverage|DataElement|DetectedIssue|Device|DeviceComponent|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|EligibilityRequest|EligibilityResponse|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|ExpansionProfile|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingManifest|ImagingStudy|Immunization|ImmunizationRecommendation|ImplementationGuide|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationRequest|MedicationStatement|MessageDefinition|MessageHeader|NamingSystem|NutritionOrder|Observation|OperationDefinition|OperationOutcome|Organization|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|ProcedureRequest|ProcessRequest|ProcessResponse|Provenance|Questionnaire|QuestionnaireResponse|ReferralRequest|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|Sequence|ServiceDefinition|Slot|Specimen|StructureDefinition|StructureMap|Subscription|Substance|SupplyDelivery|SupplyRequest|Task|TestScript|TestReport|ValueSet|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    private static final String EXECUTED_CONSTRAINT_LIST = "validator.executed.invariant.list";
    private static final String EXECUTION_ID = "validator.execution.id";

    public InstanceValidator(IWorkerContext theContext, FHIRPathEngine.IEvaluationContext hostServices) {
        super(theContext);
        this.externalHostServices = hostServices;
        this.profileUtilities = new ProfileUtilities(theContext, null, null);
        this.fpe = new FHIRPathEngine(this.context);
        this.validatorServices = new ValidatorHostServices();
        this.fpe.setHostServices(this.validatorServices);
        if (theContext.getVersion().startsWith("3.0") || theContext.getVersion().startsWith("1.0")) {
            this.fpe.setLegacyMode(true);
        }
        this.source = ValidationMessage.Source.InstanceValidator;
    }

    @Override
    public boolean isNoExtensibleWarnings() {
        return this.noExtensibleWarnings;
    }

    @Override
    public IResourceValidator setNoExtensibleWarnings(boolean noExtensibleWarnings) {
        this.noExtensibleWarnings = noExtensibleWarnings;
        return this;
    }

    @Override
    public boolean isShowMessagesFromReferences() {
        return this.showMessagesFromReferences;
    }

    @Override
    public void setShowMessagesFromReferences(boolean showMessagesFromReferences) {
        this.showMessagesFromReferences = showMessagesFromReferences;
    }

    @Override
    public boolean isNoInvariantChecks() {
        return this.noInvariantChecks;
    }

    @Override
    public IResourceValidator setNoInvariantChecks(boolean value) {
        this.noInvariantChecks = value;
        return this;
    }

    @Override
    public IResourceValidator.IValidatorResourceFetcher getFetcher() {
        return this.fetcher;
    }

    @Override
    public IResourceValidator setFetcher(IResourceValidator.IValidatorResourceFetcher value) {
        this.fetcher = value;
        return this;
    }

    @Override
    public IResourceValidator.IValidationProfileUsageTracker getTracker() {
        return this.tracker;
    }

    @Override
    public IResourceValidator setTracker(IResourceValidator.IValidationProfileUsageTracker value) {
        this.tracker = value;
        return this;
    }

    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    public void setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
    }

    @Override
    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    @Override
    public void setAssumeValidRestReferences(boolean value) {
        this.assumeValidRestReferences = value;
    }

    @Override
    public boolean isAllowExamples() {
        return this.allowExamples;
    }

    @Override
    public void setAllowExamples(boolean value) {
        this.allowExamples = value;
    }

    private boolean allowUnknownExtension(String url) {
        if (this.allowExamples && (url.contains("example.org") || url.contains("acme.com")) || url.contains("nema.org") || url.startsWith("http://hl7.org/fhir/tools/StructureDefinition/") || url.equals("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression")) {
            return true;
        }
        for (String s2 : this.extensionDomains) {
            if (!url.startsWith(s2)) continue;
            return true;
        }
        return this.anyExtensionsAllowed;
    }

    private boolean isKnownExtension(String url) {
        if (this.allowExamples && (url.contains("example.org") || url.contains("acme.com")) || url.contains("nema.org") || url.startsWith("http://hl7.org/fhir/tools/StructureDefinition/") || url.equals("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression") || url.equals("http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.packageId")) {
            return true;
        }
        for (String s2 : this.extensionDomains) {
            if (!url.startsWith(s2)) continue;
            return true;
        }
        return false;
    }

    private void bpCheck(List<ValidationMessage> errors, ValidationMessage.IssueType invalid, int line, int col, String literalPath, boolean test, String message) {
        if (this.bpWarnings != null) {
            switch (this.bpWarnings) {
                case Error: {
                    this.rule(errors, invalid, line, col, literalPath, test, message, new Object[0]);
                    break;
                }
                case Warning: {
                    this.warning(errors, invalid, line, col, literalPath, test, message, new Object[0]);
                    break;
                }
                case Hint: {
                    this.hint(errors, invalid, line, col, literalPath, test, message);
                    break;
                }
            }
        }
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format) throws FHIRException {
        return this.validate(appContext, errors, stream, format, new ArrayList<StructureDefinition>());
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, stream, format, profiles);
    }

    private StructureDefinition getSpecifiedProfile(String profile) {
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, profile);
        if (sd == null) {
            throw new FHIRException(this.context.formatMessage("Unable_to_locate_the_profile__in_order_to_validate_against_it", profile));
        }
        return sd;
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        ParserBase parser = Manager.makeParser(this.context, format);
        if (parser instanceof XmlParser) {
            ((XmlParser)parser).setAllowXsiLocation(this.allowXsiLocation);
        }
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        try {
            e = parser.parse(stream);
        }
        catch (IOException e1) {
            throw new FHIRException(e1);
        }
        this.timeTracker.load(t, System.nanoTime());
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource) throws FHIRException {
        return this.validate(appContext, errors, resource, new ArrayList<StructureDefinition>());
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, resource, profiles);
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        long t = System.nanoTime();
        try {
            e = new ObjectConverter(this.context).convert(resource);
        }
        catch (IOException e1) {
            throw new FHIRException(e1);
        }
        this.timeTracker.load(t, System.nanoTime());
        this.validate(appContext, errors, e, profiles);
        return e;
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element) throws FHIRException {
        return this.validate(appContext, errors, element, new ArrayList<StructureDefinition>());
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, element, profiles);
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        try {
            e = parser.parse(element);
        }
        catch (IOException e1) {
            throw new FHIRException(e1);
        }
        this.timeTracker.load(t, System.nanoTime());
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document) throws FHIRException {
        return this.validate(appContext, errors, document, new ArrayList<StructureDefinition>());
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, document, profiles);
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        try {
            e = parser.parse(document);
        }
        catch (IOException e1) {
            throw new FHIRException(e1);
        }
        this.timeTracker.load(t, System.nanoTime());
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object) throws FHIRException {
        return this.validate(appContext, errors, object, new ArrayList<StructureDefinition>());
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, object, profiles);
    }

    @Override
    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object, List<StructureDefinition> profiles) throws FHIRException {
        JsonParser parser = new JsonParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        org.hl7.fhir.r5.elementmodel.Element e = parser.parse(object);
        this.timeTracker.load(t, System.nanoTime());
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    @Override
    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element) throws FHIRException {
        this.validate(appContext, errors, element, new ArrayList<StructureDefinition>());
    }

    @Override
    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        this.validate(appContext, errors, element, profiles);
    }

    @Override
    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, List<StructureDefinition> profiles) throws FHIRException {
        this.fetchCache.clear();
        this.fetchCache.put(element.fhirType() + "/" + element.getIdBase(), element);
        this.resourceTracker.clear();
        this.executionId = UUID.randomUUID().toString();
        this.baseOnly = profiles.isEmpty();
        long t = System.nanoTime();
        if (profiles == null || profiles.isEmpty()) {
            this.validateResource(new ValidatorHostContext(appContext, element), errors, element, element, null, this.resourceIdRule, new NodeStack(this.context, element, this.validationLanguage).resetIds());
        } else {
            for (StructureDefinition defn : profiles) {
                this.validateResource(new ValidatorHostContext(appContext, element), errors, element, element, defn, this.resourceIdRule, new NodeStack(this.context, element, this.validationLanguage).resetIds());
            }
        }
        if (this.hintAboutNonMustSupport) {
            this.checkElementUsage(errors, element, new NodeStack(this.context, element, this.validationLanguage));
        }
        this.timeTracker.overall(t, System.nanoTime());
    }

    private void checkElementUsage(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        String elementUsage = element.getUserString("elementSupported");
        this.hint(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), elementUsage == null || elementUsage.equals("Y"), "MustSupport_VAL_MustSupport", element.getName(), element.getProperty().getStructure().getUrl());
        if (element.hasChildren()) {
            String prevName = "";
            int elementCount = 0;
            for (org.hl7.fhir.r5.elementmodel.Element ce : element.getChildren()) {
                if (ce.getName().equals(prevName)) {
                    ++elementCount;
                } else {
                    elementCount = 1;
                    prevName = ce.getName();
                }
                this.checkElementUsage(errors, ce, stack.push(ce, elementCount, null, null));
            }
        }
    }

    private boolean check(String v1, String v2) {
        return v1 == null ? Utilities.noString(v1) : v1.equals(v2);
    }

    private void checkAddress(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Address fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), fixed.getUseElement(), fixedSource, "use", focus, pattern);
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), fixed.getTextElement(), fixedSource, "text", focus, pattern);
        this.checkFixedValue(errors, path + ".city", focus.getNamedChild("city"), fixed.getCityElement(), fixedSource, "city", focus, pattern);
        this.checkFixedValue(errors, path + ".state", focus.getNamedChild("state"), fixed.getStateElement(), fixedSource, "state", focus, pattern);
        this.checkFixedValue(errors, path + ".country", focus.getNamedChild("country"), fixed.getCountryElement(), fixedSource, "country", focus, pattern);
        this.checkFixedValue(errors, path + ".zip", focus.getNamedChild("zip"), fixed.getPostalCodeElement(), fixedSource, "postalCode", focus, pattern);
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> lines = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        focus.getNamedChildren("line", lines);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, lines.size() == fixed.getLine().size(), "Fixed_Type_Checks_DT_Address_Line", Integer.toString(fixed.getLine().size()), Integer.toString(lines.size()))) {
            for (int i = 0; i < lines.size(); ++i) {
                this.checkFixedValue(errors, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)lines.get(i), fixed.getLine().get(i), fixedSource, "coding", focus, pattern);
            }
        }
    }

    private void checkAttachment(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Attachment fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".contentType", focus.getNamedChild("contentType"), fixed.getContentTypeElement(), fixedSource, "contentType", focus, pattern);
        this.checkFixedValue(errors, path + ".language", focus.getNamedChild("language"), fixed.getLanguageElement(), fixedSource, "language", focus, pattern);
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), fixed.getDataElement(), fixedSource, "data", focus, pattern);
        this.checkFixedValue(errors, path + ".url", focus.getNamedChild("url"), fixed.getUrlElement(), fixedSource, "url", focus, pattern);
        this.checkFixedValue(errors, path + ".size", focus.getNamedChild("size"), fixed.getSizeElement(), fixedSource, "size", focus, pattern);
        this.checkFixedValue(errors, path + ".hash", focus.getNamedChild("hash"), fixed.getHashElement(), fixedSource, "hash", focus, pattern);
        this.checkFixedValue(errors, path + ".title", focus.getNamedChild("title"), fixed.getTitleElement(), fixedSource, "title", focus, pattern);
    }

    private boolean checkCode(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String path, String code, String system, String display, boolean checkDisplay, NodeStack stack) throws TerminologyServiceException {
        long t = System.nanoTime();
        boolean ss = this.context.supportsSystem(system);
        this.timeTracker.tx(t, System.nanoTime());
        if (ss) {
            t = System.nanoTime();
            IWorkerContext.ValidationResult s2 = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), system, code, checkDisplay ? display : null);
            this.timeTracker.tx(t, System.nanoTime());
            if (s2 == null) {
                return true;
            }
            if (s2.isOk()) {
                if (s2.getMessage() != null) {
                    this.txWarning(errors, s2.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s2 == null, s2.getMessage(), new Object[0]);
                }
                return true;
            }
            if (s2.getErrorClass() != null && s2.getErrorClass().isInfrastructure()) {
                this.txWarning(errors, s2.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s2 == null, s2.getMessage(), new Object[0]);
            } else if (s2.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                this.txHint(errors, s2.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s2 == null, s2.getMessage(), new Object[0]);
            } else if (s2.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                this.txWarning(errors, s2.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s2 == null, s2.getMessage(), new Object[0]);
            } else {
                return this.txRule(errors, s2.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s2 == null, "Terminology_PassThrough_TX_Message", s2.getMessage(), system, code);
            }
            return true;
        }
        if (system.startsWith("http://hl7.org/fhir")) {
            if (Utilities.existsInList(system, "http://hl7.org/fhir/sid/icd-10", "http://hl7.org/fhir/sid/cvx", "http://hl7.org/fhir/sid/icd-10", "http://hl7.org/fhir/sid/icd-10-cm", "http://hl7.org/fhir/sid/icd-9-cm", "http://hl7.org/fhir/sid/icd-9", "http://hl7.org/fhir/sid/ndc", "http://hl7.org/fhir/sid/srt")) {
                return true;
            }
            if (system.startsWith("http://hl7.org/fhir/test")) {
                return true;
            }
            CodeSystem cs = this.getCodeSystem(system);
            if (this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs != null, "Terminology_TX_System_Unknown", system)) {
                CodeSystem.ConceptDefinitionComponent def = this.getCodeDefinition(cs, code);
                if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, def != null, "Terminology_TX_Code_Unknown", system, code)) {
                    return this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, display == null || display.equals(def.getDisplay()), "Terminology_TX_Display_Wrong", def.getDisplay());
                }
            }
            return false;
        }
        if (this.context.isNoTerminologyServer() && Utilities.existsInList(system, "http://loinc.org", "http://unitsofmeasure.org", "http://hl7.org/fhir/sid/icd-9-cm", "http://snomed.info/sct", "http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return true;
        }
        if (this.startsWithButIsNot(system, "http://snomed.info/sct", "http://loinc.org", "http://unitsofmeasure.org", "http://www.nlm.nih.gov/research/umls/rxnorm")) {
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_System_Invalid", system);
            return false;
        }
        try {
            String ns;
            CodeSystem cs;
            if (this.context.fetchResourceWithException(ValueSet.class, system) != null) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_System_ValueSet", system);
            }
            boolean done = false;
            if (system.startsWith("https:") && system.length() > 7 && ((cs = this.getCodeSystem(ns = "http:" + system.substring(6))) != null || Utilities.existsInList(system, "https://loinc.org", "https://unitsofmeasure.org", "https://snomed.info/sct", "https://www.nlm.nih.gov/research/umls/rxnorm"))) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_SYSTEM_HTTPS", system);
                done = true;
            }
            this.hint(errors, ValidationMessage.IssueType.UNKNOWN, element.line(), element.col(), path, done, "Terminology_TX_System_NotKnown", system);
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean startsWithButIsNot(String system, String ... uri) {
        for (String s2 : uri) {
            if (system.equals(s2) || !system.startsWith(s2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasErrors(List<ValidationMessage> errors) {
        if (errors != null) {
            for (ValidationMessage vm : errors) {
                if (vm.getLevel() != ValidationMessage.IssueSeverity.FATAL && vm.getLevel() != ValidationMessage.IssueSeverity.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    private void checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, CodeableConcept fixed, String fixedSource, boolean pattern) {
        block7: {
            ArrayList<org.hl7.fhir.r5.elementmodel.Element> codings;
            block6: {
                this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), fixed.getTextElement(), fixedSource, "text", focus, pattern);
                codings = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
                focus.getNamedChildren("coding", codings);
                if (!pattern) break block6;
                if (!this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() >= fixed.getCoding().size(), "Terminology_TX_Coding_Count", Integer.toString(fixed.getCoding().size()), Integer.toString(codings.size()))) break block7;
                for (int i = 0; i < fixed.getCoding().size(); ++i) {
                    Coding fixedCoding = fixed.getCoding().get(i);
                    boolean found = false;
                    ArrayList allErrorsFixed = new ArrayList();
                    for (int j = 0; j < codings.size() && !found; ++j) {
                        ArrayList<ValidationMessage> errorsFixed = new ArrayList<ValidationMessage>();
                        this.checkFixedValue(errorsFixed, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)codings.get(j), fixedCoding, fixedSource, "coding", focus, pattern);
                        if (!this.hasErrors(errorsFixed)) {
                            found = true;
                            continue;
                        }
                        errorsFixed.stream().filter(t -> t.getLevel().ordinal() >= ValidationMessage.IssueSeverity.ERROR.ordinal()).forEach(t -> allErrorsFixed.add(t));
                    }
                    if (found) continue;
                    String message = "Expected CodeableConcept " + (pattern ? "pattern" : "fixed value") + " not found for system: " + fixedCoding.getSystemElement().asStringValue() + " code: " + fixedCoding.getCodeElement().asStringValue() + " display: " + fixedCoding.getDisplayElement().asStringValue();
                    if (fixedCoding.hasUserSelected()) {
                        message = message + " userSelected: " + fixedCoding.getUserSelected();
                    }
                    message = message + " - Issues: " + allErrorsFixed;
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, message, new Object[0]);
                }
                break block7;
            }
            if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() == fixed.getCoding().size(), "Terminology_TX_Coding_Count", Integer.toString(fixed.getCoding().size()), Integer.toString(codings.size()))) {
                for (int i = 0; i < codings.size(); ++i) {
                    this.checkFixedValue(errors, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)codings.get(i), fixed.getCoding().get(i), fixedSource, "coding", focus);
                }
            }
        }
    }

    private boolean checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, NodeStack stack) {
        boolean res = true;
        if (!this.noTerminologyChecks && theElementCntext != null && theElementCntext.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing", path)) {
                if (binding.hasValueSet()) {
                    ValueSet valueset = this.resolveBindingReference(profile, binding.getValueSet(), profile.getUrl());
                    if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(binding.getValueSet()))) {
                        try {
                            CodeableConcept cc = ObjectConverter.readAsCodeableConcept(element);
                            if (!cc.hasCoding()) {
                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSet", this.describeReference(binding.getValueSet()), valueset.getUrl());
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSetMax", this.describeReference(ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")), valueset.getUrl());
                                    } else {
                                        this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSet_Ext", this.describeReference(binding.getValueSet()), valueset.getUrl());
                                    }
                                }
                            } else {
                                long t = System.nanoTime();
                                boolean bindingsOk = true;
                                if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                    boolean atLeastOneSystemIsSupported = false;
                                    for (Coding nextCoding : cc.getCoding()) {
                                        String nextSystem = nextCoding.getSystem();
                                        if (!StringUtils.isNotBlank(nextSystem) || !this.context.supportsSystem(nextSystem)) continue;
                                        atLeastOneSystemIsSupported = true;
                                        break;
                                    }
                                    if (atLeastOneSystemIsSupported || binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                        IWorkerContext.ValidationResult vr = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()).checkValueSetOnly(), cc, valueset);
                                        if (!vr.isOk()) {
                                            bindingsOk = false;
                                            if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                    this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_1", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                    } else if (!this.noExtensibleWarnings) {
                                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_2", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                    }
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_3", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_1", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                    this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                }
                                                if (!this.noExtensibleWarnings) {
                                                    this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_2", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                                this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_3", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                            }
                                        } else if (vr.getMessage() != null) {
                                            res = false;
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                                        } else {
                                            res = false;
                                        }
                                    }
                                    if (bindingsOk) {
                                        for (Coding nextCoding : cc.getCoding()) {
                                            IWorkerContext.ValidationResult vr;
                                            if (!StringUtils.isNotBlank(nextCoding.getCode()) || !StringUtils.isNotBlank(nextCoding.getSystem()) || !this.context.supportsSystem(nextCoding.getSystem()) || (vr = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()).noCheckValueSetMembership(), nextCoding, valueset)).getSeverity() == null) continue;
                                            if (vr.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                                                this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                                                continue;
                                            }
                                            if (vr.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                                                this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                                                continue;
                                            }
                                            this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                                        }
                                    }
                                    this.timeTracker.tx(t, System.nanoTime());
                                }
                            }
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept", e.getMessage());
                        }
                    }
                } else if (binding.hasValueSet()) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_CantCheck");
                } else if (!this.noBindingMsgSuppressed) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                }
            }
        }
        return res;
    }

    private boolean checkTerminologyCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, NodeStack stack, StructureDefinition logical) {
        boolean res = true;
        if (!this.noTerminologyChecks && theElementCntext != null && theElementCntext.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing", path)) {
                if (binding.hasValueSet()) {
                    ValueSet valueset = this.resolveBindingReference(profile, binding.getValueSet(), profile.getUrl());
                    if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(binding.getValueSet()))) {
                        try {
                            CodeableConcept cc = this.convertToCodeableConcept(element, logical);
                            if (!cc.hasCoding()) {
                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "No code provided, and a code is required from the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl(), new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSetMax", this.describeReference(ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")), valueset.getUrl());
                                    } else {
                                        this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSet_Ext", this.describeReference(binding.getValueSet()), valueset.getUrl());
                                    }
                                }
                            } else {
                                long t = System.nanoTime();
                                boolean bindingsOk = true;
                                if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                    boolean atLeastOneSystemIsSupported = false;
                                    for (Coding nextCoding : cc.getCoding()) {
                                        String nextSystem = nextCoding.getSystem();
                                        if (!StringUtils.isNotBlank(nextSystem) || !this.context.supportsSystem(nextSystem)) continue;
                                        atLeastOneSystemIsSupported = true;
                                        break;
                                    }
                                    if (atLeastOneSystemIsSupported || binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                        IWorkerContext.ValidationResult vr = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), cc, valueset);
                                        if (!vr.isOk()) {
                                            bindingsOk = false;
                                            if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                    this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_1", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                    } else if (!this.noExtensibleWarnings) {
                                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_2", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                    }
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_3", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_1", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                    this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                }
                                                if (!this.noExtensibleWarnings) {
                                                    this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_2", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                                this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_3", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                            }
                                        } else if (vr.getMessage() != null) {
                                            res = false;
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                                        } else {
                                            res = false;
                                        }
                                    }
                                    if (bindingsOk) {
                                        for (Coding nextCoding : cc.getCoding()) {
                                            IWorkerContext.ValidationResult vr;
                                            String nextCode = nextCoding.getCode();
                                            String nextSystem = nextCoding.getSystem();
                                            if (!StringUtils.isNotBlank(nextCode) || !StringUtils.isNotBlank(nextSystem) || !this.context.supportsSystem(nextSystem) || (vr = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), nextSystem, nextCode, null)).isOk()) continue;
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_NotValid", nextCode, nextSystem);
                                        }
                                    }
                                    this.timeTracker.tx(t, System.nanoTime());
                                }
                            }
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept", e.getMessage());
                        }
                        if (this.getMapping("http://hl7.org/fhir/terminology-pattern", logical, logical.getSnapshot().getElementFirstRep()).contains("Coding")) {
                            this.checkTerminologyCoding(errors, path, element, profile, theElementCntext, true, true, stack, logical);
                        }
                    }
                } else if (binding.hasValueSet()) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_CantCheck");
                } else if (!this.noBindingMsgSuppressed) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                }
            }
        }
        return res;
    }

    private void checkTerminologyCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept, boolean checkDisplay, NodeStack stack, StructureDefinition logical) {
        block30: {
            Coding c = this.convertToCoding(element, logical);
            String code = c.getCode();
            String system = c.getSystem();
            String display = c.getDisplay();
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Terminology_TX_System_Relative", new Object[0]);
            if (system != null && code != null && !this.noTerminologyChecks) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !this.isValueSet(system), "Terminology_TX_System_ValueSet2", system);
                try {
                    if (!this.checkCode(errors, element, path, code, system, display, checkDisplay, stack) || theElementCntext == null || !theElementCntext.hasBinding()) break block30;
                    ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
                    if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing2", path)) break block30;
                    if (binding.hasValueSet()) {
                        ValueSet valueset = this.resolveBindingReference(profile, binding.getValueSet(), profile.getUrl());
                        if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(binding.getValueSet()))) break block30;
                        try {
                            long t = System.nanoTime();
                            IWorkerContext.ValidationResult vr = null;
                            if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                vr = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), c, valueset);
                            }
                            this.timeTracker.tx(t, System.nanoTime());
                            if (vr != null && !vr.isOk()) {
                                if (vr.IsNoService()) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoServer", new Object[0]);
                                } else if (vr.getErrorClass() != null && !vr.getErrorClass().isInfrastructure()) {
                                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_4", this.describeReference(binding.getValueSet(), valueset));
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                            this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                        } else if (!this.noExtensibleWarnings) {
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_5", this.describeReference(binding.getValueSet(), valueset));
                                        }
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_6", this.describeReference(binding.getValueSet(), valueset));
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_4", this.describeReference(binding.getValueSet(), valueset), vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : "");
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                    } else {
                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_5", this.describeReference(binding.getValueSet(), valueset), vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : "");
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_6", this.describeReference(binding.getValueSet(), valueset), vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : "");
                                }
                            }
                            break block30;
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding1", e.getMessage());
                        }
                        break block30;
                    }
                    if (binding.hasValueSet()) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_CantCheck");
                    } else if (!inCodeableConcept && !this.noBindingMsgSuppressed) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                    }
                }
                catch (Exception e) {
                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding2", e.getMessage(), e.toString());
                }
            }
        }
    }

    private CodeableConcept convertToCodeableConcept(org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition logical) {
        CodeableConcept res = new CodeableConcept();
        for (ElementDefinition ed : logical.getSnapshot().getElement()) {
            if (Utilities.charCount(ed.getPath(), '.') != 1) continue;
            List<String> maps = this.getMapping("http://hl7.org/fhir/terminology-pattern", logical, ed);
            for (String m3 : maps) {
                String name = this.tail(ed.getPath());
                ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
                element.getNamedChildren(name, list);
                if (list.isEmpty()) continue;
                if ("Coding.code".equals(m3)) {
                    res.getCodingFirstRep().setCode(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if ("Coding.system[fmt:OID]".equals(m3)) {
                    String oid = ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue();
                    String url = this.context.oid2Uri(oid);
                    if (url != null) {
                        res.getCodingFirstRep().setSystem(url);
                        continue;
                    }
                    res.getCodingFirstRep().setSystem("urn:oid:" + oid);
                    continue;
                }
                if ("Coding.version".equals(m3)) {
                    res.getCodingFirstRep().setVersion(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if ("Coding.display".equals(m3)) {
                    res.getCodingFirstRep().setDisplay(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if ("CodeableConcept.text".equals(m3)) {
                    res.setText(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if (!"CodeableConcept.coding".equals(m3)) continue;
                StructureDefinition c = this.context.fetchTypeDefinition(ed.getTypeFirstRep().getCode());
                for (org.hl7.fhir.r5.elementmodel.Element e : list) {
                    res.addCoding(this.convertToCoding(e, c));
                }
            }
        }
        return res;
    }

    private Coding convertToCoding(org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition logical) {
        Coding res = new Coding();
        for (ElementDefinition ed : logical.getSnapshot().getElement()) {
            if (Utilities.charCount(ed.getPath(), '.') != 1) continue;
            List<String> maps = this.getMapping("http://hl7.org/fhir/terminology-pattern", logical, ed);
            for (String m3 : maps) {
                String name = this.tail(ed.getPath());
                ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
                element.getNamedChildren(name, list);
                if (list.isEmpty()) continue;
                if ("Coding.code".equals(m3)) {
                    res.setCode(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if ("Coding.system[fmt:OID]".equals(m3)) {
                    String oid = ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue();
                    String url = this.context.oid2Uri(oid);
                    if (url != null) {
                        res.setSystem(url);
                        continue;
                    }
                    res.setSystem("urn:oid:" + oid);
                    continue;
                }
                if ("Coding.version".equals(m3)) {
                    res.setVersion(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if (!"Coding.display".equals(m3)) continue;
                res.setDisplay(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
            }
        }
        return res;
    }

    private void checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, CodeableConcept cc, NodeStack stack) {
        ValueSet valueset = this.resolveBindingReference(profile, maxVSUrl, profile.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(maxVSUrl))) {
            try {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), cc, valueset);
                this.timeTracker.tx(t, System.nanoTime());
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_7", this.describeReference(maxVSUrl), valueset.getUrl(), vr.getMessage());
                    } else {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_8", this.describeReference(maxVSUrl), valueset.getUrl(), this.ccSummary(cc));
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept_Max", e.getMessage());
            }
        }
    }

    private void checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, Coding c, NodeStack stack) {
        ValueSet valueset = this.resolveBindingReference(profile, maxVSUrl, profile.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(maxVSUrl))) {
            try {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), c, valueset);
                this.timeTracker.tx(t, System.nanoTime());
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_9", this.describeReference(maxVSUrl), valueset.getUrl(), vr.getMessage());
                    } else {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_10", this.describeReference(maxVSUrl), valueset.getUrl(), c.getSystem(), c.getCode());
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept_Max", e.getMessage());
            }
        }
    }

    private void checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, String value, NodeStack stack) {
        ValueSet valueset = this.resolveBindingReference(profile, maxVSUrl, profile.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(maxVSUrl))) {
            try {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), value, valueset);
                this.timeTracker.tx(t, System.nanoTime());
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_9", this.describeReference(maxVSUrl), valueset.getUrl(), vr.getMessage());
                    } else {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_11", this.describeReference(maxVSUrl), valueset.getUrl(), "), and a code from this value set is required) (code = " + value + "), (error = " + vr.getMessage() + ")");
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept_Max", e.getMessage());
            }
        }
    }

    private String ccSummary(CodeableConcept cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Coding c : cc.getCoding()) {
            b.append(c.getSystem() + "#" + c.getCode());
        }
        return b.toString();
    }

    private void checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Coding fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), fixed.getSystemElement(), fixedSource, "system", focus, pattern);
        this.checkFixedValue(errors, path + ".version", focus.getNamedChild("version"), fixed.getVersionElement(), fixedSource, "version", focus, pattern);
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), fixed.getCodeElement(), fixedSource, "code", focus, pattern);
        this.checkFixedValue(errors, path + ".display", focus.getNamedChild("display"), fixed.getDisplayElement(), fixedSource, "display", focus, pattern);
        this.checkFixedValue(errors, path + ".userSelected", focus.getNamedChild("userSelected"), fixed.getUserSelectedElement(), fixedSource, "userSelected", focus, pattern);
    }

    private void checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept, boolean checkDisplay, NodeStack stack) {
        block30: {
            String code = element.getNamedChildValue("code");
            String system = element.getNamedChildValue("system");
            String display = element.getNamedChildValue("display");
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Terminology_TX_System_Relative", new Object[0]);
            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, Utilities.noString(code) || !Utilities.noString(system), "TERMINOLOGY_TX_SYSTEM_NO_CODE", new Object[0]);
            if (system != null && code != null && !this.noTerminologyChecks) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !this.isValueSet(system), "Terminology_TX_System_ValueSet2", system);
                try {
                    if (!this.checkCode(errors, element, path, code, system, display, checkDisplay, stack) || theElementCntext == null || !theElementCntext.hasBinding()) break block30;
                    ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
                    if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing2", path)) break block30;
                    if (binding.hasValueSet()) {
                        ValueSet valueset = this.resolveBindingReference(profile, binding.getValueSet(), profile.getUrl());
                        if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(binding.getValueSet()))) break block30;
                        try {
                            Coding c = ObjectConverter.readAsCoding(element);
                            long t = System.nanoTime();
                            IWorkerContext.ValidationResult vr = null;
                            if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                vr = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), c, valueset);
                            }
                            this.timeTracker.tx(t, System.nanoTime());
                            if (vr != null && !vr.isOk()) {
                                if (vr.IsNoService()) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoServer", new Object[0]);
                                } else if (vr.getErrorClass() != null && !vr.getErrorClass().isInfrastructure()) {
                                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_4", this.describeReference(binding.getValueSet(), valueset));
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                            this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                        } else if (!this.noExtensibleWarnings) {
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_5", this.describeReference(binding.getValueSet(), valueset));
                                        }
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_6", this.describeReference(binding.getValueSet(), valueset));
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_12", this.describeReference(binding.getValueSet(), valueset), this.getErrorMessage(vr.getMessage()));
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                    } else {
                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_13", this.describeReference(binding.getValueSet(), valueset), this.getErrorMessage(vr.getMessage()));
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_14", this.describeReference(binding.getValueSet(), valueset), this.getErrorMessage(vr.getMessage()));
                                }
                            }
                            break block30;
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding1", e.getMessage());
                        }
                        break block30;
                    }
                    if (binding.hasValueSet()) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_CantCheck");
                    } else if (!inCodeableConcept && !this.noBindingMsgSuppressed) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                    }
                }
                catch (Exception e) {
                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding2", e.getMessage(), e.toString());
                }
            }
        }
    }

    private boolean isValueSet(String url) {
        try {
            ValueSet vs = this.context.fetchResourceWithException(ValueSet.class, url);
            return vs != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkContactPoint(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, ContactPoint fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), fixed.getSystemElement(), fixedSource, "system", focus, pattern);
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), fixed.getValueElement(), fixedSource, "value", focus, pattern);
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), fixed.getUseElement(), fixedSource, "use", focus, pattern);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), fixed.getPeriod(), fixedSource, "period", focus, pattern);
    }

    private StructureDefinition checkExtension(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element container, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition def, StructureDefinition profile, NodeStack stack, NodeStack containerStack, String extensionUrl) throws FHIRException {
        String url = element.getNamedChildValue("url");
        boolean isModifier = element.getName().equals("modifierExtension");
        long t = System.nanoTime();
        StructureDefinition ex = Utilities.isAbsoluteUrl(url) ? this.context.fetchResource(StructureDefinition.class, url) : null;
        this.timeTracker.sd(t, System.nanoTime());
        if (ex == null) {
            if (this.xverManager == null) {
                this.xverManager = new XVerExtensionManager(this.context);
            }
            if (this.xverManager.matchingUrl(url)) {
                switch (this.xverManager.status(url)) {
                    case BadVersion: {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_Invalid", url, this.xverManager.getVersion(url));
                        break;
                    }
                    case Unknown: {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_InvalidId", url, this.xverManager.getElementId(url));
                        break;
                    }
                    case Invalid: {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_NoChange", url, this.xverManager.getElementId(url));
                        break;
                    }
                    case Valid: {
                        ex = this.xverManager.makeDefinition(url);
                        this.context.generateSnapshot(ex);
                        this.context.cacheResource(ex);
                        break;
                    }
                    default: {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_Internal", url);
                        break;
                    }
                }
            } else if (extensionUrl != null && !this.isAbsolute(url)) {
                if (extensionUrl.equals(profile.getUrl())) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", this.hasExtensionSlice(profile, url), "Extension_EXT_SubExtension_Invalid", url, profile.getUrl());
                }
            } else if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.allowUnknownExtension(url), "Extension_EXT_Unknown_NotHere", url)) {
                this.hint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.isKnownExtension(url), "Extension_EXT_Unknown", url);
            }
        }
        if (ex != null) {
            this.trackUsage(ex, hostContext, element);
            if (def.getIsModifier()) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ex.getSnapshot().getElement().get(0).getIsModifier(), "Extension_EXT_Modifier_MismatchY", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !ex.getSnapshot().getElement().get(0).getIsModifier(), "Extension_EXT_Modifier_MismatchN", new Object[0]);
            }
            this.checkExtensionContext(errors, resource, container, ex, containerStack, hostContext);
            if (isModifier) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ex.getSnapshot().getElement().get(0).getIsModifier(), "Extension_EXT_Modifier_Y", url);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !ex.getSnapshot().getElement().get(0).getIsModifier(), "Extension_EXT_Modifier_N", url);
            }
            Set<String> allowedTypes = this.listExtensionTypes(ex);
            String actualType = this.getExtensionType(element);
            if (actualType == null) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, allowedTypes.isEmpty(), "Extension_EXT_Simple", url);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, allowedTypes.contains(actualType), "Extension_EXT_Type", url, allowedTypes.toString(), actualType);
            }
            this.validateElement(hostContext, errors, ex, ex.getSnapshot().getElement().get(0), null, null, resource, element, "Extension", stack, false, true, url);
        }
        return ex;
    }

    private boolean hasExtensionSlice(StructureDefinition profile, String sliceName) {
        for (ElementDefinition ed : profile.getSnapshot().getElement()) {
            if (!ed.getPath().equals("Extension.extension.url") || !ed.hasFixed() || !sliceName.equals(ed.getFixed().primitiveValue())) continue;
            return true;
        }
        return false;
    }

    private String getExtensionType(org.hl7.fhir.r5.elementmodel.Element element) {
        for (org.hl7.fhir.r5.elementmodel.Element e : element.getChildren()) {
            if (!e.getName().startsWith("value")) continue;
            String tn = e.getName().substring(5);
            String ltn = Utilities.uncapitalize(tn);
            if (this.isPrimitiveType(ltn)) {
                return ltn;
            }
            return tn;
        }
        return null;
    }

    private Set<String> listExtensionTypes(StructureDefinition ex) {
        ElementDefinition vd = null;
        for (ElementDefinition ed : ex.getSnapshot().getElement()) {
            if (!ed.getPath().startsWith("Extension.value")) continue;
            vd = ed;
            break;
        }
        HashSet<String> res = new HashSet<String>();
        if (vd != null && !"0".equals(vd.getMax())) {
            for (ElementDefinition.TypeRefComponent tr : vd.getType()) {
                res.add(tr.getWorkingCode());
            }
        }
        return res;
    }

    private boolean checkExtensionContext(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element container, StructureDefinition definition, NodeStack stack, ValidatorHostContext hostContext) {
        String extUrl = definition.getUrl();
        boolean ok = false;
        CommaSeparatedStringBuilder contexts = new CommaSeparatedStringBuilder();
        ArrayList<String> plist = new ArrayList<String>();
        plist.add(this.stripIndexes(stack.getLiteralPath()));
        for (String string : stack.getLogicalPaths()) {
            String p = this.stripIndexes(string);
            if (Utilities.existsInList(p, "ElementDefinition.example.value", "ElementDefinition.pattern", "ElementDefinition.fixed")) {
                return true;
            }
            plist.add(p);
        }
        block1: for (StructureDefinition.StructureDefinitionContextComponent structureDefinitionContextComponent : this.fixContexts(extUrl, definition.getContext())) {
            if (ok) break;
            if (structureDefinitionContextComponent.getType() == StructureDefinition.ExtensionContextType.ELEMENT) {
                String en = structureDefinitionContextComponent.getExpression();
                contexts.append("e:" + en);
                if (Utilities.existsInList(en, "Element", "Any")) {
                    ok = true;
                } else if (en.equals("Resource") && container.isResource()) {
                    ok = true;
                }
                block2: for (String p : plist) {
                    if (ok) continue block1;
                    if (p.equals(en)) {
                        ok = true;
                        continue;
                    }
                    String pn = p;
                    String pt = "";
                    if (p.contains(".")) {
                        pn = p.substring(0, p.indexOf("."));
                        pt = p.substring(p.indexOf("."));
                    }
                    StructureDefinition sd = this.context.fetchTypeDefinition(pn);
                    while (sd != null) {
                        if ((sd.getType() + pt).equals(en)) {
                            ok = true;
                            continue block2;
                        }
                        if (sd.getBaseDefinition() != null) {
                            sd = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
                            continue;
                        }
                        sd = null;
                    }
                }
                continue;
            }
            if (structureDefinitionContextComponent.getType() == StructureDefinition.ExtensionContextType.EXTENSION) {
                contexts.append("x:" + structureDefinitionContextComponent.getExpression());
                NodeStack estack = stack.getParent();
                if (estack == null || !estack.getElement().fhirType().equals("Extension")) continue;
                String ext = estack.getElement().getNamedChildValue("url");
                if (!structureDefinitionContextComponent.getExpression().equals(ext)) continue;
                ok = true;
                continue;
            }
            if (structureDefinitionContextComponent.getType() == StructureDefinition.ExtensionContextType.FHIRPATH) {
                contexts.append("p:" + structureDefinitionContextComponent.getExpression());
                List<Base> res = this.fpe.evaluate((Object)hostContext, resource, hostContext.getRootResource(), (Base)resource, this.fpe.parse(structureDefinitionContextComponent.getExpression()));
                if (!res.contains(container)) continue;
                ok = true;
                continue;
            }
            throw new Error(this.context.formatMessage("Unrecognised_extension_context_", structureDefinitionContextComponent.getTypeElement().asStringValue()));
        }
        if (!ok) {
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, "Extension_EXT_Context_Wrong", extUrl, contexts.toString(), ((Object)plist).toString());
            return false;
        }
        if (definition.hasContextInvariant()) {
            for (StringType stringType : definition.getContextInvariant()) {
                if (this.fpe.evaluateToBoolean((Object)hostContext, resource, hostContext.getRootResource(), (Base)container, this.fpe.parse((String)stringType.getValue()))) continue;
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, "Profile_EXT_Not_Here", extUrl, stringType.getValue());
                return false;
            }
        }
        return true;
    }

    private List<StructureDefinition.StructureDefinitionContextComponent> fixContexts(String extUrl, List<StructureDefinition.StructureDefinitionContextComponent> list) {
        ArrayList<StructureDefinition.StructureDefinitionContextComponent> res = new ArrayList<StructureDefinition.StructureDefinitionContextComponent>();
        for (StructureDefinition.StructureDefinitionContextComponent ctxt : list) {
            res.add(ctxt.copy());
        }
        if ("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type".equals(extUrl)) {
            list.get(0).setExpression("ElementDefinition.type");
        }
        if ("http://hl7.org/fhir/StructureDefinition/regex".equals(extUrl)) {
            list.get(1).setExpression("ElementDefinition.type");
        }
        if ("http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version".equals(extUrl)) {
            list.get(0).setExpression("Element");
        }
        return list;
    }

    private String stripIndexes(String path) {
        boolean skip = false;
        StringBuilder b = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (skip) {
                if (c != ']') continue;
                skip = false;
                continue;
            }
            if (c == '[') {
                skip = true;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private void checkFixedValue(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, org.hl7.fhir.r5.model.Element fixed, String fixedSource, String propName, org.hl7.fhir.r5.elementmodel.Element parent) {
        this.checkFixedValue(errors, path, focus, fixed, fixedSource, propName, parent, false);
    }

    private void checkFixedValue(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, org.hl7.fhir.r5.model.Element fixed, String fixedSource, String propName, org.hl7.fhir.r5.elementmodel.Element parent, boolean pattern) {
        if (fixed != null && !fixed.isEmpty() || focus != null) {
            if ((fixed == null || fixed.isEmpty()) && focus != null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, pattern, "Profile_VAL_NotAllowed", focus.getName(), pattern ? "pattern" : "fixed value");
            } else if (fixed != null && !fixed.isEmpty() && focus == null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, parent == null ? -1 : parent.line(), parent == null ? -1 : parent.col(), path, false, "Profile_VAL_MissingElement", propName, fixedSource);
            } else {
                String value = focus.primitiveValue();
                if (fixed instanceof BooleanType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((BooleanType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((BooleanType)fixed).asStringValue());
                } else if (fixed instanceof IntegerType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IntegerType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((IntegerType)fixed).asStringValue());
                } else if (fixed instanceof DecimalType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((DecimalType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((DecimalType)fixed).asStringValue());
                } else if (fixed instanceof Base64BinaryType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Base64BinaryType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((Base64BinaryType)fixed).asStringValue());
                } else if (fixed instanceof InstantType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((InstantType)fixed).getValue()).toString(), value), "_DT_Fixed_Wrong", value, ((InstantType)fixed).asStringValue());
                } else if (fixed instanceof CodeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((CodeType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((CodeType)fixed).getValue());
                } else if (fixed instanceof Enumeration) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Enumeration)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((Enumeration)fixed).asStringValue());
                } else if (fixed instanceof StringType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((StringType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((StringType)fixed).getValue());
                } else if (fixed instanceof UriType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UriType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((UriType)fixed).getValue());
                } else if (fixed instanceof DateType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateType)fixed).getValue()).toString(), value), "_DT_Fixed_Wrong", value, ((DateType)fixed).getValue());
                } else if (fixed instanceof DateTimeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateTimeType)fixed).getValue()).toString(), value), "_DT_Fixed_Wrong", value, ((DateTimeType)fixed).getValue());
                } else if (fixed instanceof OidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((OidType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((OidType)fixed).getValue());
                } else if (fixed instanceof UuidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UuidType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((UuidType)fixed).getValue());
                } else if (fixed instanceof IdType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IdType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((IdType)fixed).getValue());
                } else if (fixed instanceof Quantity) {
                    this.checkQuantity(errors, path, focus, (Quantity)fixed, fixedSource, pattern);
                } else if (fixed instanceof Address) {
                    this.checkAddress(errors, path, focus, (Address)fixed, fixedSource, pattern);
                } else if (fixed instanceof ContactPoint) {
                    this.checkContactPoint(errors, path, focus, (ContactPoint)fixed, fixedSource, pattern);
                } else if (fixed instanceof Attachment) {
                    this.checkAttachment(errors, path, focus, (Attachment)fixed, fixedSource, pattern);
                } else if (fixed instanceof Identifier) {
                    this.checkIdentifier(errors, path, focus, (Identifier)fixed, fixedSource, pattern);
                } else if (fixed instanceof Coding) {
                    this.checkCoding(errors, path, focus, (Coding)fixed, fixedSource, pattern);
                } else if (fixed instanceof HumanName) {
                    this.checkHumanName(errors, path, focus, (HumanName)fixed, fixedSource, pattern);
                } else if (fixed instanceof CodeableConcept) {
                    this.checkCodeableConcept(errors, path, focus, (CodeableConcept)fixed, fixedSource, pattern);
                } else if (fixed instanceof Timing) {
                    this.checkTiming(errors, path, focus, (Timing)fixed, fixedSource, pattern);
                } else if (fixed instanceof Period) {
                    this.checkPeriod(errors, path, focus, (Period)fixed, fixedSource, pattern);
                } else if (fixed instanceof Range) {
                    this.checkRange(errors, path, focus, (Range)fixed, fixedSource, pattern);
                } else if (fixed instanceof Ratio) {
                    this.checkRatio(errors, path, focus, (Ratio)fixed, fixedSource, pattern);
                } else if (fixed instanceof SampledData) {
                    this.checkSampledData(errors, path, focus, (SampledData)fixed, fixedSource, pattern);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, focus.line(), focus.col(), path, false, "Internal_INT_Bad_Type", fixed.getClass().getName());
                }
                ArrayList<org.hl7.fhir.r5.elementmodel.Element> extensions = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
                focus.getNamedChildren("extension", extensions);
                if (fixed.getExtension().size() == 0) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == 0, "Extension_EXT_Fixed_Banned", new Object[0]);
                } else if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == fixed.getExtension().size(), "Extension_EXT_Count_Mismatch", Integer.toString(fixed.getExtension().size()), Integer.toString(extensions.size()))) {
                    for (Extension e : fixed.getExtension()) {
                        org.hl7.fhir.r5.elementmodel.Element ex = this.getExtensionByUrl(extensions, e.getUrl());
                        if (!this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, ex != null, "Extension_EXT_Count_NotFound", e.getUrl())) continue;
                        this.checkFixedValue(errors, path, ex.getNamedChild("extension").getNamedChild("value"), e.getValue(), fixedSource, "extension.value", ex.getNamedChild("extension"));
                    }
                }
            }
        }
    }

    private void checkHumanName(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, HumanName fixed, String fixedSource, boolean pattern) {
        int i;
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), fixed.getUseElement(), fixedSource, "use", focus, pattern);
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), fixed.getTextElement(), fixedSource, "text", focus, pattern);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), fixed.getPeriod(), fixedSource, "period", focus, pattern);
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> parts = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        focus.getNamedChildren("family", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() > 0 == fixed.hasFamily(), "Fixed_Type_Checks_DT_Name_Family", fixed.hasFamily() ? "1" : "0", Integer.toString(parts.size()))) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".family", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), fixed.getFamilyElement(), fixedSource, "family", focus, pattern);
            }
        }
        focus.getNamedChildren("given", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getGiven().size(), "Fixed_Type_Checks_DT_Name_Given", Integer.toString(fixed.getGiven().size()), Integer.toString(parts.size()))) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".given", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), fixed.getGiven().get(i), fixedSource, "given", focus, pattern);
            }
        }
        focus.getNamedChildren("prefix", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getPrefix().size(), "Fixed_Type_Checks_DT_Name_Prefix", Integer.toString(fixed.getPrefix().size()), Integer.toString(parts.size()))) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".prefix", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), fixed.getPrefix().get(i), fixedSource, "prefix", focus, pattern);
            }
        }
        focus.getNamedChildren("suffix", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getSuffix().size(), "Fixed_Type_Checks_DT_Name_Suffix", Integer.toString(fixed.getSuffix().size()), Integer.toString(parts.size()))) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".suffix", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), fixed.getSuffix().get(i), fixedSource, "suffix", focus, pattern);
            }
        }
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition context) {
        String system = element.getNamedChildValue("system");
        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Type_Specific_Checks_DT_Identifier_System", new Object[0]);
        if ("urn:ietf:rfc:3986".equals(system)) {
            String value = element.getNamedChildValue("value");
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(value), "TYPE_SPECIFIC_CHECKS_DT_IDENTIFIER_IETF_SYSTEM_VALUE", new Object[0]);
        }
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Identifier fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), fixed.getUseElement(), fixedSource, "use", focus, pattern);
        this.checkFixedValue(errors, path + ".type", focus.getNamedChild("type"), fixed.getType(), fixedSource, "type", focus, pattern);
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), fixed.getSystemElement(), fixedSource, "system", focus, pattern);
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), fixed.getValueElement(), fixedSource, "value", focus, pattern);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), fixed.getPeriod(), fixedSource, "period", focus, pattern);
        this.checkFixedValue(errors, path + ".assigner", focus.getNamedChild("assigner"), fixed.getAssigner(), fixedSource, "assigner", focus, pattern);
    }

    private void checkPeriod(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Period fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".start", focus.getNamedChild("start"), fixed.getStartElement(), fixedSource, "start", focus, pattern);
        this.checkFixedValue(errors, path + ".end", focus.getNamedChild("end"), fixed.getEndElement(), fixedSource, "end", focus, pattern);
    }

    private void checkPrimitive(Object appContext, List<ValidationMessage> errors, String path, String type, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element e, StructureDefinition profile, NodeStack node) throws FHIRException {
        XhtmlNode xhtml;
        Object ds;
        Number v;
        String encoded;
        PrimitiveType ex3;
        Object url;
        if (StringUtils.isBlank(e.primitiveValue())) {
            if (e.primitiveValue() == null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Type_Specific_Checks_DT_Primitive_ValueExt", new Object[0]);
            } else if (e.primitiveValue().length() == 0) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Type_Specific_Checks_DT_Primitive_NotEmpty", new Object[0]);
            } else if (StringUtils.isWhitespace(e.primitiveValue())) {
                this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Type_Specific_Checks_DT_Primitive_WS", new Object[0]);
            }
            return;
        }
        String regex = context.getExtensionString("http://hl7.org/fhir/StructureDefinition/regex");
        if (regex != null) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches(regex), "Type_Specific_Checks_DT_Primitive_Regex", e.primitiveValue(), regex);
        }
        if (type.equals("boolean")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "true".equals(e.primitiveValue()) || "false".equals(e.primitiveValue()), "Type_Specific_Checks_DT_Boolean_Value", new Object[0]);
        }
        if (type.equals("uri") || type.equals("oid") || type.equals("uuid") || type.equals("url") || type.equals("canonical")) {
            url = e.primitiveValue();
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !((String)url).startsWith("oid:"), "Type_Specific_Checks_DT_URI_OID", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !((String)url).startsWith("uuid:"), "Type_Specific_Checks_DT_URI_UUID", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ((String)url).equals(((String)url).trim().replace(" ", "")) || "http://www.acme.com/identifiers/patient or urn:ietf:rfc:3986 if the Identifier.value itself is a full uri".equals(url), "Type_Specific_Checks_DT_URI_WS", url);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || ((String)url).length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
            if (type.equals("oid") && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ((String)url).startsWith("urn:oid:"), "Type_Specific_Checks_DT_OID_Start", new Object[0])) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isOid(((String)url).substring(8)), "Type_Specific_Checks_DT_OID_Valid", new Object[0]);
            }
            if (type.equals("uuid")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ((String)url).startsWith("urn:uuid:"), "Type_Specific_Checks_DT_UUID_Strat", new Object[0]);
                try {
                    UUID.fromString(((String)url).substring(8));
                }
                catch (Exception ex2) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_UUID_Vaid", ex2.getMessage());
                }
            }
            if (type.equals("canonical")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ((String)url).startsWith("#") || Utilities.isAbsoluteUrl((String)url), "TYPE_SPECIFIC_CHECKS_CANONICAL_ABSOLUTE", url);
            }
            if (this.fetcher != null) {
                boolean found;
                try {
                    found = this.isDefinitionURL((String)url) || this.allowExamples && (((String)url).contains("example.org") || ((String)url).contains("acme.com")) || ((String)url).startsWith("http://hl7.org/fhir/tools") || this.fetcher.resolveURL(appContext, path, (String)url);
                }
                catch (IOException e1) {
                    found = false;
                }
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, found, "Type_Specific_Checks_DT_URL_Resolve", url);
            }
        }
        if (type.equals("id") && !context.getPath().equals("ElementDefinition.id") && !VersionUtilities.versionsCompatible("1.4", this.context.getVersion())) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, FormatUtilities.isValidId(e.primitiveValue()), "Type_Specific_Checks_DT_ID_Valid", e.primitiveValue());
        }
        if (type.equalsIgnoreCase("string") && e.hasPrimitiveValue() && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || e.primitiveValue().length() > 0, "Type_Specific_Checks_DT_Primitive_NotEmpty", new Object[0])) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || e.primitiveValue().trim().equals(e.primitiveValue()), "Type_Specific_Checks_DT_String_WS", new Object[0]);
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().length() <= 0x100000, "Type_Specific_Checks_DT_String_Length", new Object[0])) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
            }
        }
        if (type.equals("dateTime")) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_Reasonable", e.primitiveValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?"), "Type_Specific_Checks_DT_DateTime_Valid", e.primitiveValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.hasTime(e.primitiveValue()) || this.hasTimeZone(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_TZ", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
            try {
                url = new DateTimeType(e.primitiveValue());
            }
            catch (Exception ex3) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_DateTime_Valid", ex3.getMessage());
            }
        }
        if (type.equals("time")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)"), "Type_Specific_Checks_DT_Time_Valid", new Object[0]);
            try {
                ex3 = new TimeType(e.primitiveValue());
            }
            catch (Exception ex4) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Time_Valid", ex4.getMessage());
            }
        }
        if (type.equals("date")) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_Reasonable", e.primitiveValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1]))?)?"), "Type_Specific_Checks_DT_Date_Valid", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
            try {
                ex3 = new DateType(e.primitiveValue());
            }
            catch (Exception ex5) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Date_Valid", ex5.getMessage());
            }
        }
        if (type.equals("base64Binary") && StringUtils.isNotBlank(encoded = e.primitiveValue())) {
            int charCount = 0;
            for (int i = 0; i < encoded.length(); ++i) {
                char nextChar = encoded.charAt(i);
                if (Character.isWhitespace(nextChar)) continue;
                if (Character.isLetterOrDigit(nextChar)) {
                    ++charCount;
                }
                if (nextChar != '/' && nextChar != '=' && nextChar != '+') continue;
                ++charCount;
            }
            if (charCount > 0 && charCount % 4 != 0) {
                String value = encoded.length() < 100 ? encoded : "(snip)";
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Base64_Valid", value);
            }
        }
        if ((type.equals("integer") || type.equals("unsignedInt") || type.equals("positiveInt")) && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isInteger(e.primitiveValue()), "Type_Specific_Checks_DT_Integer_Valid", e.primitiveValue())) {
            v = (int)new Integer(e.getValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxValueIntegerType() || !context.getMaxValueIntegerType().hasValue() || (Integer)context.getMaxValueIntegerType().getValue() >= (Integer)v, "Type_Specific_Checks_DT_Integer_GT", context.hasMaxValueIntegerType() ? context.getMaxValueIntegerType() : "");
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMinValueIntegerType() || !context.getMinValueIntegerType().hasValue() || (Integer)context.getMinValueIntegerType().getValue() <= (Integer)v, "Type_Specific_Checks_DT_Integer_LT", context.hasMinValueIntegerType() ? context.getMinValueIntegerType() : "");
            if (type.equals("unsignedInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, (Integer)v >= 0, "Type_Specific_Checks_DT_Integer_LT0", new Object[0]);
            }
            if (type.equals("positiveInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, (Integer)v > 0, "Type_Specific_Checks_DT_Integer_LT1", new Object[0]);
            }
        }
        if (type.equals("integer64") && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isLong(e.primitiveValue()), "Type_Specific_Checks_DT_Integer64_Valid", e.primitiveValue())) {
            v = (long)new Long(e.getValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxValueInteger64Type() || !context.getMaxValueInteger64Type().hasValue() || (Long)context.getMaxValueInteger64Type().getValue() >= (Long)v, "Type_Specific_Checks_DT_Integer_GT", context.hasMaxValueInteger64Type() ? context.getMaxValueInteger64Type() : "");
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMinValueInteger64Type() || !context.getMinValueInteger64Type().hasValue() || (Long)context.getMinValueInteger64Type().getValue() <= (Long)v, "Type_Specific_Checks_DT_Integer_LT", context.hasMinValueInteger64Type() ? context.getMinValueInteger64Type() : "");
            if (type.equals("unsignedInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, (Long)v >= 0L, "Type_Specific_Checks_DT_Integer_LT0", new Object[0]);
            }
            if (type.equals("positiveInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, (Long)v > 0L, "Type_Specific_Checks_DT_Integer_LT1", new Object[0]);
            }
        }
        if (type.equals("decimal") && e.primitiveValue() != null) {
            ds = Utilities.checkDecimal(e.primitiveValue(), true, false);
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ds == Utilities.DecimalStatus.OK || ds == Utilities.DecimalStatus.RANGE, "Type_Specific_Checks_DT_Decimal_Valid", e.primitiveValue())) {
                this.warning(errors, ValidationMessage.IssueType.VALUE, e.line(), e.col(), path, ds != Utilities.DecimalStatus.RANGE, "Type_Specific_Checks_DT_Decimal_Range", e.primitiveValue());
            }
        }
        if (type.equals("instant")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("-?[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))"), "Type_Specific_Checks_DT_DateTime_Regex", e.primitiveValue());
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_Reasonable", e.primitiveValue());
            try {
                ds = new InstantType(e.primitiveValue());
            }
            catch (Exception ex6) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Instant_Valid", ex6.getMessage());
            }
        }
        if (type.equals("code") && e.primitiveValue() != null) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.passesCodeWhitespaceRules(e.primitiveValue()), "Type_Specific_Checks_DT_Code_WS", e.primitiveValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
        }
        if (context.hasBinding() && e.primitiveValue() != null) {
            this.checkPrimitiveBinding(errors, path, type, context, e, profile, node);
        }
        if (type.equals("xhtml") && (xhtml = e.getXhtml()) != null) {
            String ns = xhtml.getNsDecl();
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "http://www.w3.org/1999/xhtml".equals(ns), "XHTML_XHTML_NS_InValid", ns, "http://www.w3.org/1999/xhtml");
            this.checkInnerNS(errors, e, path, xhtml.getChildNodes());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "div".equals(xhtml.getName()), "XHTML_XHTML_Name_Invalid", ns);
            this.checkInnerNames(errors, e, path, xhtml.getChildNodes());
            this.checkUrls(errors, e, path, xhtml.getChildNodes());
        }
        if (context.hasFixed()) {
            this.checkFixedValue(errors, path, e, context.getFixed(), profile.getUrl(), context.getSliceName(), null, false);
        }
        if (context.hasPattern()) {
            this.checkFixedValue(errors, path, e, context.getPattern(), profile.getUrl(), context.getSliceName(), null, true);
        }
    }

    private boolean isDefinitionURL(String url) {
        return Utilities.existsInList(url, "http://hl7.org/fhirpath/System.Boolean", "http://hl7.org/fhirpath/System.String", "http://hl7.org/fhirpath/System.Integer", "http://hl7.org/fhirpath/System.Decimal", "http://hl7.org/fhirpath/System.Date", "http://hl7.org/fhirpath/System.Time", "http://hl7.org/fhirpath/System.DateTime", "http://hl7.org/fhirpath/System.Quantity");
    }

    private void checkInnerNames(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list) {
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.existsInList(node.getName(), "p", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "a", "span", "b", "em", "i", "strong", "small", "big", "tt", "small", "dfn", "q", "var", "abbr", "acronym", "cite", "blockquote", "hr", "address", "bdo", "kbd", "q", "sub", "sup", "ul", "ol", "li", "dl", "dt", "dd", "pre", "table", "caption", "colgroup", "col", "thead", "tr", "tfoot", "tbody", "th", "td", "code", "samp", "img", "map", "area"), "XHTML_XHTML_Element_Illegal", node.getName());
            for (String an : node.getAttributes().keySet()) {
                boolean ok = an.startsWith("xmlns") || Utilities.existsInList(an, "title", "style", "class", "id", "lang", "xml:lang", "dir", "accesskey", "tabindex", "span", "width", "align", "valign", "char", "charoff", "abbr", "axis", "headers", "scope", "rowspan", "colspan") || Utilities.existsInList(node.getName() + "." + an, "a.href", "a.name", "img.src", "img.border", "div.xmlns", "blockquote.cite", "q.cite", "a.charset", "a.type", "a.name", "a.href", "a.hreflang", "a.rel", "a.rev", "a.shape", "a.coords", "img.src", "img.alt", "img.longdesc", "img.height", "img.width", "img.usemap", "img.ismap", "map.name", "area.shape", "area.coords", "area.href", "area.nohref", "area.alt", "table.summary", "table.width", "table.border", "table.frame", "table.rules", "table.cellspacing", "table.cellpadding", "pre.space", "td.nowrap");
                if (ok) continue;
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "XHTML_XHTML_Attribute_Illegal", an, node.getName());
            }
            this.checkInnerNames(errors, e, path, node.getChildNodes());
        }
    }

    private void checkUrls(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list) {
        for (XhtmlNode node : list) {
            String msg;
            if (node.getNodeType() != NodeType.Element) continue;
            if ("a".equals(node.getName())) {
                msg = this.checkValidUrl(node.getAttribute("href"));
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, msg == null, "XHTML_URL_INVALID", node.getAttribute("href"), msg);
            } else if ("img".equals(node.getName())) {
                msg = this.checkValidUrl(node.getAttribute("src"));
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, msg == null, "XHTML_URL_INVALID", node.getAttribute("src"), msg);
            }
            this.checkUrls(errors, e, path, node.getChildNodes());
        }
    }

    private String checkValidUrl(String value) {
        if (value == null) {
            return null;
        }
        if (Utilities.noString(value)) {
            return this.context.formatMessage("XHTML_URL_EMPTY", new Object[0]);
        }
        HashSet<Character> invalidChars = new HashSet<Character>();
        for (char ch : value.toCharArray()) {
            if (Character.isDigit(ch) || Character.isAlphabetic(ch) || Utilities.existsInList(ch, 59, 63, 58, 64, 38, 61, 43, 36, 46, 44, 47, 37, 45, 95, 126, 35, 91, 93, 33, 39, 40, 41, 42)) continue;
            invalidChars.add(Character.valueOf(ch));
        }
        if (invalidChars.isEmpty()) {
            return null;
        }
        return this.context.formatMessage("XHTML_URL_INVALID_CHARS", ((Object)invalidChars).toString());
    }

    private void checkInnerNS(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list) {
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            String ns = node.getNsDecl();
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ns == null || "http://www.w3.org/1999/xhtml".equals(ns), "XHTML_XHTML_NS_InValid", ns, "http://www.w3.org/1999/xhtml");
            this.checkInnerNS(errors, e, path, node.getChildNodes());
        }
    }

    private void checkPrimitiveBinding(List<ValidationMessage> errors, String path, String type, ElementDefinition elementContext, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, NodeStack stack) {
        if (!(element.hasPrimitiveValue() && ("code".equals(type) || "string".equals(type) || "uri".equals(type) || "url".equals(type) || "canonical".equals(type)))) {
            return;
        }
        if (this.noTerminologyChecks) {
            return;
        }
        String value = element.primitiveValue();
        ElementDefinition.ElementDefinitionBindingComponent binding = elementContext.getBinding();
        if (binding.hasValueSet()) {
            ValueSet vs = this.resolveBindingReference(profile, binding.getValueSet(), profile.getUrl());
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, vs != null, "Terminology_TX_ValueSet_NotFound2", this.describeReference(binding.getValueSet()))) {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = null;
                if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                    ValidationOptions options = new ValidationOptions(stack.getWorkingLang()).guessSystem();
                    vr = this.context.validateCode(options, value, vs);
                }
                this.timeTracker.tx(t, System.nanoTime());
                if (vr != null && !vr.isOk()) {
                    if (vr.IsNoService()) {
                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_15", value);
                    } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_16", value, this.describeReference(binding.getValueSet()), vs.getUrl(), this.getErrorMessage(vr.getMessage()));
                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                            this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), value, stack);
                        } else if (!this.noExtensibleWarnings) {
                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_17", value, this.describeReference(binding.getValueSet()), vs.getUrl(), this.getErrorMessage(vr.getMessage()));
                        }
                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_18", value, this.describeReference(binding.getValueSet()), vs.getUrl(), this.getErrorMessage(vr.getMessage()));
                    }
                }
            }
        } else if (!this.noBindingMsgSuppressed) {
            this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !type.equals("code"), "Terminology_TX_Binding_NoSource2");
        }
    }

    private void checkQuantity(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Quantity fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), fixed.getValueElement(), fixedSource, "value", focus, pattern);
        this.checkFixedValue(errors, path + ".comparator", focus.getNamedChild("comparator"), fixed.getComparatorElement(), fixedSource, "comparator", focus, pattern);
        this.checkFixedValue(errors, path + ".units", focus.getNamedChild("unit"), fixed.getUnitElement(), fixedSource, "units", focus, pattern);
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), fixed.getSystemElement(), fixedSource, "system", focus, pattern);
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), fixed.getCodeElement(), fixedSource, "code", focus, pattern);
    }

    private void checkRange(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Range fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".low", focus.getNamedChild("low"), fixed.getLow(), fixedSource, "low", focus, pattern);
        this.checkFixedValue(errors, path + ".high", focus.getNamedChild("high"), fixed.getHigh(), fixedSource, "high", focus, pattern);
    }

    private void checkRatio(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Ratio fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".numerator", focus.getNamedChild("numerator"), fixed.getNumerator(), fixedSource, "numerator", focus, pattern);
        this.checkFixedValue(errors, path + ".denominator", focus.getNamedChild("denominator"), fixed.getDenominator(), fixedSource, "denominator", focus, pattern);
    }

    private void checkReference(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition container, String parentType, NodeStack stack) throws FHIRException {
        IResourceValidator.ReferenceValidationPolicy pol;
        Reference reference = ObjectConverter.readAsReference(element);
        String ref = reference.getReference();
        if (Utilities.noString(ref)) {
            if (Utilities.noString(reference.getIdentifier().getSystem()) && Utilities.noString(reference.getIdentifier().getValue())) {
                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, !Utilities.noString(element.getNamedChildValue("display")), "Reference_REF_NoDisplay", new Object[0]);
            }
            return;
        }
        if (Utilities.existsInList(ref, "http://tools.ietf.org/html/bcp47")) {
            return;
        }
        ResolvedReference we = this.localResolve(ref, stack, errors, path, (org.hl7.fhir.r5.elementmodel.Element)hostContext.getAppContext(), element);
        String refType = ref.startsWith("#") ? "contained" : (we == null ? "remote" : "bundled");
        IResourceValidator.ReferenceValidationPolicy referenceValidationPolicy = refType.equals("contained") || refType.equals("bundled") ? IResourceValidator.ReferenceValidationPolicy.CHECK_VALID : (pol = this.fetcher == null ? IResourceValidator.ReferenceValidationPolicy.IGNORE : this.fetcher.validationPolicy(hostContext.getAppContext(), path, ref));
        if (pol.checkExists()) {
            if (we == null) {
                if (this.fetcher == null) {
                    if (!refType.equals("contained")) {
                        throw new FHIRException(this.context.formatMessage("Resource_resolution_services_not_provided", new Object[0]));
                    }
                } else {
                    org.hl7.fhir.r5.elementmodel.Element ext = null;
                    if (this.fetchCache.containsKey(ref)) {
                        ext = this.fetchCache.get(ref);
                    } else {
                        try {
                            ext = this.fetcher.fetch(hostContext.getAppContext(), ref);
                        }
                        catch (IOException e) {
                            throw new FHIRException(e);
                        }
                        if (ext != null) {
                            this.fetchCache.put(ref, ext);
                        }
                    }
                    we = ext == null ? null : this.makeExternalRef(ext, path);
                }
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.allowExamples && (ref.contains("example.org") || ref.contains("acme.com")) || we != null || pol == IResourceValidator.ReferenceValidationPolicy.CHECK_TYPE_IF_EXISTS, "Reference_REF_CantResolve", ref);
        }
        String ft = we != null ? we.getType() : this.tryParse(ref);
        if (reference.hasType()) {
            String tu = this.isAbsolute(reference.getType()) ? reference.getType() : "http://hl7.org/fhir/StructureDefinition/" + reference.getType();
            ElementDefinition.TypeRefComponent containerType = container.getType("Reference");
            if (!containerType.hasTargetProfile(tu) && !containerType.hasTargetProfile("http://hl7.org/fhir/StructureDefinition/Resource")) {
                boolean matchingResource = false;
                for (CanonicalType canonicalType : containerType.getTargetProfile()) {
                    StructureDefinition structureDefinition = this.resolveProfile(profile, canonicalType.asStringValue());
                    if (!("http://hl7.org/fhir/StructureDefinition/" + structureDefinition.getType()).equals(tu)) continue;
                    matchingResource = true;
                    break;
                }
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, matchingResource, "Reference_REF_WrongTarget", reference.getType(), container.getType("Reference").getTargetProfile());
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft == null || ft.equals(reference.getType()), "Reference_REF_BadTargetType", reference.getType(), ft);
        }
        if (we != null && pol.checkType() && this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft != null, "Reference_REF_NoType", new Object[0])) {
            boolean ok = false;
            ElementDefinition.TypeRefComponent type = this.getReferenceTypeRef(container.getType());
            if (type.hasTargetProfile() && !type.hasTargetProfile("http://hl7.org/fhir/StructureDefinition/Resource")) {
                HashSet<String> types = new HashSet<String>();
                ArrayList profiles = new ArrayList();
                for (UriType uriType : type.getTargetProfile()) {
                    StructureDefinition sd = this.resolveProfile(profile, (String)uriType.getValue());
                    if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, sd != null, "Reference_REF_CantResolveProfile", uriType.getValue())) continue;
                    types.add(sd.getType());
                    if (!ft.equals(sd.getType())) continue;
                    ok = true;
                    profiles.add(sd);
                }
                if (!pol.checkValid()) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, profiles.size() > 0, "Reference_REF_CantMatchType", ref, StringUtils.join("; ", type.getTargetProfile()));
                } else {
                    HashMap<StructureDefinition, ArrayList<ValidationMessage>> hashMap = new HashMap<StructureDefinition, ArrayList<ValidationMessage>>();
                    HashMap<StructureDefinition, ArrayList<ValidationMessage>> hashMap2 = new HashMap<StructureDefinition, ArrayList<ValidationMessage>>();
                    int goodCount = 0;
                    Iterator<Object> iterator = profiles.iterator();
                    while (iterator.hasNext()) {
                        StructureDefinition pr = (StructureDefinition)iterator.next();
                        ArrayList<ValidationMessage> profileErrors = new ArrayList<ValidationMessage>();
                        this.validateResource(we.hostContext(hostContext, pr), profileErrors, we.getResource(), we.getFocus(), pr, IResourceValidator.IdStatus.OPTIONAL, we.getStack().resetIds());
                        if (!this.hasErrors(profileErrors)) {
                            ++goodCount;
                            hashMap2.put(pr, profileErrors);
                            this.trackUsage(pr, hostContext, element);
                            continue;
                        }
                        hashMap.put(pr, profileErrors);
                    }
                    if (goodCount == 1) {
                        if (this.showMessagesFromReferences) {
                            for (ValidationMessage vm : (List)hashMap2.values().iterator().next()) {
                                if (errors.contains(vm)) continue;
                                errors.add(vm);
                            }
                        }
                    } else if (hashMap2.size() == 0) {
                        if (!this.isShowMessagesFromReferences()) {
                            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.areAllBaseProfiles(profiles), "Reference_REF_CantMatchChoice", ref, this.asList(type.getTargetProfile()));
                            for (StructureDefinition sd : hashMap.keySet()) {
                                this.slicingHint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.context.formatMessage("Details_for__matching_against_Profile_", ref, sd.getUrl()), this.errorSummaryForSlicingAsHtml((List)hashMap.get(sd)));
                            }
                        } else {
                            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, profiles.size() == 1, "Reference_REF_CantMatchChoice", ref, this.asList(type.getTargetProfile()));
                            for (List messages : hashMap.values()) {
                                for (ValidationMessage vm : messages) {
                                    if (errors.contains(vm)) continue;
                                    errors.add(vm);
                                }
                            }
                        }
                    } else if (!this.isShowMessagesFromReferences()) {
                        this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, "Reference_REF_MultipleMatches", ref, this.asListByUrl(hashMap2.keySet()));
                        for (StructureDefinition sd : hashMap.keySet()) {
                            this.slicingHint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.context.formatMessage("Details_for__matching_against_Profile_", ref, sd.getUrl()), this.errorSummaryForSlicingAsHtml((List)hashMap.get(sd)));
                        }
                    } else {
                        this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, "Reference_REF_MultipleMatches", ref, this.asListByUrl(hashMap2.keySet()));
                        for (List messages : hashMap2.values()) {
                            for (ValidationMessage vm : messages) {
                                if (errors.contains(vm)) continue;
                                errors.add(vm);
                            }
                        }
                    }
                }
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ok, "Reference_REF_BadTargetType", ft, ((Object)types).toString());
            }
            if (type.hasAggregation()) {
                boolean modeOk = false;
                for (Enumeration enumeration : type.getAggregation()) {
                    if (((ElementDefinition.AggregationMode)((Object)enumeration.getValue())).equals((Object)ElementDefinition.AggregationMode.CONTAINED) && refType.equals("contained")) {
                        modeOk = true;
                        continue;
                    }
                    if (((ElementDefinition.AggregationMode)((Object)enumeration.getValue())).equals((Object)ElementDefinition.AggregationMode.BUNDLED) && refType.equals("bundled")) {
                        modeOk = true;
                        continue;
                    }
                    if (!((ElementDefinition.AggregationMode)((Object)enumeration.getValue())).equals((Object)ElementDefinition.AggregationMode.REFERENCED) || !refType.equals("bundled") && !refType.equals("remote")) continue;
                    modeOk = true;
                }
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, modeOk, "Reference_REF_Aggregation", refType);
            }
        }
        if (we == null) {
            ElementDefinition.TypeRefComponent type = this.getReferenceTypeRef(container.getType());
            boolean okToRef = !type.hasAggregation() || type.hasAggregation(ElementDefinition.AggregationMode.REFERENCED);
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, okToRef, "Reference_REF_NotFound_Bundle", ref);
        }
        if (we == null && ft != null && this.assumeValidRestReferences) {
            ElementDefinition.TypeRefComponent type = this.getReferenceTypeRef(container.getType());
            HashSet<String> types = new HashSet<String>();
            for (CanonicalType tp : type.getTargetProfile()) {
                StructureDefinition structureDefinition = this.context.fetchResource(StructureDefinition.class, (String)tp.getValue());
                if (structureDefinition == null) continue;
                types.add(structureDefinition.getType());
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, types.isEmpty() || types.contains(ft), "Reference_REF_BadTargetType2", ft, ref, types);
        }
        if (pol == IResourceValidator.ReferenceValidationPolicy.CHECK_VALID) {
            // empty if block
        }
    }

    private String asListByUrl(Collection<StructureDefinition> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (StructureDefinition sd : list) {
            b.append(sd.getUrl());
        }
        return b.toString();
    }

    private String asList(Collection<CanonicalType> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (CanonicalType c : list) {
            b.append((String)c.getValue());
        }
        return b.toString();
    }

    private boolean areAllBaseProfiles(List<StructureDefinition> profiles) {
        for (StructureDefinition sd : profiles) {
            if (sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/")) continue;
            return false;
        }
        return true;
    }

    private String errorSummaryForSlicing(List<ValidationMessage> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValidationMessage vm : list) {
            if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR && vm.getLevel() != ValidationMessage.IssueSeverity.FATAL && !vm.isSlicingHint()) continue;
            b.append(vm.getLocation() + ": " + vm.getMessage());
        }
        return b.toString();
    }

    private String errorSummaryForSlicingAsHtml(List<ValidationMessage> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValidationMessage vm : list) {
            if (vm.isSlicingHint()) {
                b.append("<li>" + vm.getLocation() + ": " + vm.getSliceHtml() + "</li>");
                continue;
            }
            if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR && vm.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
            b.append("<li>" + vm.getLocation() + ": " + vm.getHtml() + "</li>");
        }
        return "<ul>" + b.toString() + "</ul>";
    }

    private ElementDefinition.TypeRefComponent getReferenceTypeRef(List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent tr : types) {
            if (!"Reference".equals(tr.getCode())) continue;
            return tr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkResourceType(String type) {
        long t = System.nanoTime();
        try {
            if (this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + type) != null) {
                String string = type;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.timeTracker.sd(t, System.nanoTime());
        }
    }

    private void checkSampledData(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, SampledData fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".origin", focus.getNamedChild("origin"), fixed.getOrigin(), fixedSource, "origin", focus, pattern);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), fixed.getPeriodElement(), fixedSource, "period", focus, pattern);
        this.checkFixedValue(errors, path + ".factor", focus.getNamedChild("factor"), fixed.getFactorElement(), fixedSource, "factor", focus, pattern);
        this.checkFixedValue(errors, path + ".lowerLimit", focus.getNamedChild("lowerLimit"), fixed.getLowerLimitElement(), fixedSource, "lowerLimit", focus, pattern);
        this.checkFixedValue(errors, path + ".upperLimit", focus.getNamedChild("upperLimit"), fixed.getUpperLimitElement(), fixedSource, "upperLimit", focus, pattern);
        this.checkFixedValue(errors, path + ".dimensions", focus.getNamedChild("dimensions"), fixed.getDimensionsElement(), fixedSource, "dimensions", focus, pattern);
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), fixed.getDataElement(), fixedSource, "data", focus, pattern);
    }

    private void checkTiming(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Timing fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".repeat", focus.getNamedChild("repeat"), fixed.getRepeat(), fixedSource, "value", focus, pattern);
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> events = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        focus.getNamedChildren("event", events);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, events.size() == fixed.getEvent().size(), "Bundle_MSG_Event_Count", Integer.toString(fixed.getEvent().size()), Integer.toString(events.size()))) {
            for (int i = 0; i < events.size(); ++i) {
                this.checkFixedValue(errors, path + ".event", (org.hl7.fhir.r5.elementmodel.Element)events.get(i), fixed.getEvent().get(i), fixedSource, "event", focus, pattern);
            }
        }
    }

    private boolean codeinExpansion(ValueSet.ValueSetExpansionContainsComponent cnt, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : cnt.getContains()) {
            if (code.equals(c.getCode()) && system.equals(c.getSystem().toString())) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean codeInExpansion(ValueSet vs, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            if (code.equals(c.getCode()) && (system == null || system.equals(c.getSystem()))) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private String describeReference(String reference, CanonicalResource target) {
        if (reference == null && target == null) {
            return "null";
        }
        if (reference == null) {
            return target.getUrl();
        }
        if (target == null) {
            return reference;
        }
        if (reference.equals(target.getUrl())) {
            return reference;
        }
        return reference + "(which actually refers to " + target.getUrl() + ")";
    }

    private String describeTypes(List<ElementDefinition.TypeRefComponent> types) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent t : types) {
            b.append(t.getWorkingCode());
        }
        return b.toString();
    }

    protected ElementDefinition findElement(StructureDefinition profile, String name) {
        for (ElementDefinition c : profile.getSnapshot().getElement()) {
            if (!c.getPath().equals(name)) continue;
            return c;
        }
        return null;
    }

    @Override
    public IResourceValidator.BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.bpWarnings;
    }

    @Override
    public IResourceValidator.CheckDisplayOption getCheckDisplay() {
        return this.checkDisplay;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem.ConceptDefinitionComponent c, String code) {
        if (code.equals(c.getCode())) {
            return c;
        }
        for (CodeSystem.ConceptDefinitionComponent g2 : c.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(g2, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(c, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private IndexedElement getContainedById(org.hl7.fhir.r5.elementmodel.Element container, String id) {
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> contained = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        container.getNamedChildren("contained", contained);
        for (int i = 0; i < contained.size(); ++i) {
            org.hl7.fhir.r5.elementmodel.Element we = (org.hl7.fhir.r5.elementmodel.Element)contained.get(i);
            if (!id.equals(we.getNamedChildValue("id"))) continue;
            return new IndexedElement(i, we, null);
        }
        return null;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    private List<ElementDefinition> getCriteriaForDiscriminator(String path, ElementDefinition element, String discriminator, StructureDefinition profile, boolean removeResolve) throws FHIRException {
        ArrayList<ElementDefinition> elements = new ArrayList<ElementDefinition>();
        if ("value".equals(discriminator) && element.hasFixed()) {
            elements.add(element);
            return elements;
        }
        if (removeResolve) {
            if (discriminator.equals("resolve()")) {
                elements.add(element);
                return elements;
            }
            if (discriminator.endsWith(".resolve()")) {
                discriminator = discriminator.substring(0, discriminator.length() - 10);
            }
        }
        ElementDefinition ed = null;
        ExpressionNode expr = this.fpe.parse(this.fixExpr(discriminator));
        long t2 = System.nanoTime();
        ed = this.fpe.evaluateDefinition(expr, profile, element);
        this.timeTracker.sd(t2, System.nanoTime());
        if (ed != null) {
            elements.add(ed);
        }
        for (ElementDefinition.TypeRefComponent type : element.getType()) {
            for (CanonicalType p : type.getProfile()) {
                String id = p.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element") ? p.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element") : null;
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)p.getValue());
                if (sd == null) {
                    throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_profile_", p));
                }
                profile = sd;
                if (id == null) {
                    element = sd.getSnapshot().getElementFirstRep();
                } else {
                    element = null;
                    for (ElementDefinition t : sd.getSnapshot().getElement()) {
                        if (!id.equals(t.getId())) continue;
                        element = t;
                    }
                    if (element == null) {
                        throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_element__in_profile_", id, p));
                    }
                }
                expr = this.fpe.parse(this.fixExpr(discriminator));
                t2 = System.nanoTime();
                ed = this.fpe.evaluateDefinition(expr, profile, element);
                this.timeTracker.sd(t2, System.nanoTime());
                if (ed == null) continue;
                elements.add(ed);
            }
        }
        return elements;
    }

    private org.hl7.fhir.r5.elementmodel.Element getExtensionByUrl(List<org.hl7.fhir.r5.elementmodel.Element> extensions, String urlSimple) {
        for (org.hl7.fhir.r5.elementmodel.Element e : extensions) {
            if (!urlSimple.equals(e.getNamedChildValue("url"))) continue;
            return e;
        }
        return null;
    }

    public List<String> getExtensionDomains() {
        return this.extensionDomains;
    }

    private IndexedElement getFromBundle(org.hl7.fhir.r5.elementmodel.Element bundle, String ref, String fullUrl, List<ValidationMessage> errors, String path, String type, boolean isTransaction) {
        String targetUrl = null;
        String version = "";
        String resourceType = null;
        if (ref.startsWith("http") || ref.startsWith("urn")) {
            if (ref.contains("/_history/")) {
                targetUrl = ref.substring(0, ref.indexOf("/_history/") - 1);
                version = ref.substring(ref.indexOf("/_history/") + 10);
            } else {
                targetUrl = ref;
            }
        } else {
            int i;
            String[] parts;
            if (fullUrl == null) {
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, Utilities.existsInList(type, "batch-response", "transaction-response") || path.startsWith("Bundle.signature"), "Bundle_BUNDLE_FullUrl_Missing", new Object[0]);
                return null;
            }
            if (ref.split("/").length != 2 && ref.split("/").length != 4) {
                if (isTransaction) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, path, this.isSearchUrl(ref), "Reference_REF_Format1", ref);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, path, false, "Reference_REF_Format2", ref);
                }
                return null;
            }
            String base = "";
            if (fullUrl.startsWith("urn")) {
                parts = fullUrl.split("\\:");
                for (i = 0; i < parts.length - 1; ++i) {
                    base = base + parts[i] + ":";
                }
            } else {
                parts = fullUrl.split("/");
                for (i = 0; i < parts.length - 2; ++i) {
                    base = base + parts[i] + "/";
                }
            }
            String id = null;
            if (ref.contains("/_history/")) {
                version = ref.substring(ref.indexOf("/_history/") + 10);
                String[] refBaseParts = ref.substring(0, ref.indexOf("/_history/")).split("/");
                resourceType = refBaseParts[0];
                id = refBaseParts[1];
            } else if (base.startsWith("urn")) {
                resourceType = ref.split("/")[0];
                id = ref.split("/")[1];
            } else {
                id = ref;
            }
            targetUrl = base + id;
        }
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> entries = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        bundle.getNamedChildren("entry", entries);
        org.hl7.fhir.r5.elementmodel.Element match = null;
        int matchIndex = -1;
        for (int i = 0; i < entries.size(); ++i) {
            org.hl7.fhir.r5.elementmodel.Element we = (org.hl7.fhir.r5.elementmodel.Element)entries.get(i);
            if (!targetUrl.equals(we.getChildValue("fullUrl"))) continue;
            org.hl7.fhir.r5.elementmodel.Element r = we.getNamedChild("resource");
            if (version.isEmpty()) {
                this.rule(errors, ValidationMessage.IssueType.FORBIDDEN, -1, -1, path, match == null, "Bundle_BUNDLE_MultipleMatches", ref);
                match = r;
                matchIndex = i;
                continue;
            }
            try {
                if (!version.equals(r.getChildren("meta").get(0).getChildValue("versionId"))) continue;
                this.rule(errors, ValidationMessage.IssueType.FORBIDDEN, -1, -1, path, match == null, "Bundle_BUNDLE_MultipleMatches", ref);
                match = r;
                matchIndex = i;
                continue;
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, r.getChildren("meta").size() == 1 && r.getChildren("meta").get(0).getChildValue("versionId") != null, "Bundle_BUNDLE_FullUrl_NeedVersion", targetUrl);
            }
        }
        if (match != null && resourceType != null) {
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, match.getType().equals(resourceType), "Reference_REF_ResourceType", ref, match.getType());
        }
        if (match == null) {
            this.warning(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, !ref.startsWith("urn"), "Bundle_BUNDLE_Not_Local", ref);
        }
        return match == null ? null : new IndexedElement(matchIndex, match, (org.hl7.fhir.r5.elementmodel.Element)entries.get(matchIndex));
    }

    private boolean isSearchUrl(String ref) {
        if (Utilities.noString(ref) || !ref.contains("?")) {
            return false;
        }
        String tn = ref.substring(0, ref.indexOf("?"));
        String q = ref.substring(ref.indexOf("?") + 1);
        if (!this.context.getResourceNames().contains(tn)) {
            return false;
        }
        return q.matches("([_a-zA-Z][_a-zA-Z0-9]*=[^=&]+)(&([_a-zA-Z][_a-zA-Z0-9]*=[^=&]+))*");
    }

    private StructureDefinition getProfileForType(String type, List<ElementDefinition.TypeRefComponent> list) {
        for (ElementDefinition.TypeRefComponent tr : list) {
            String url = tr.getWorkingCode();
            if (!Utilities.isAbsoluteUrl(url)) {
                url = "http://hl7.org/fhir/StructureDefinition/" + url;
            }
            long t = System.nanoTime();
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, url);
            this.timeTracker.sd(t, System.nanoTime());
            if (sd == null || !sd.getType().equals(type) && !sd.getUrl().equals(type) || !sd.hasSnapshot()) continue;
            return sd;
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element getValueForDiscriminator(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String discriminator, ElementDefinition criteria, NodeStack stack) throws FHIRException, IOException {
        String[] dlist;
        String p = stack.getLiteralPath() + "." + element.getName();
        org.hl7.fhir.r5.elementmodel.Element focus = element;
        for (String d : dlist = discriminator.split("\\.")) {
            if (focus.fhirType().equals("Reference") && d.equals("reference")) {
                String url = focus.getChildValue("reference");
                if (Utilities.noString(url)) {
                    throw new FHIRException(this.context.formatMessage("No_reference_resolving_discriminator__from_", discriminator, element.getProperty().getName()));
                }
                org.hl7.fhir.r5.elementmodel.Element target = this.resolve(appContext, url, stack, errors, p);
                if (target == null) {
                    throw new FHIRException(this.context.formatMessage("Unable_to_find_resource__at__resolving_discriminator__from_", url, d, discriminator, element.getProperty().getName()));
                }
                focus = target;
                continue;
            }
            if (d.equals("value") && focus.isPrimitive()) {
                return focus;
            }
            List<org.hl7.fhir.r5.elementmodel.Element> children = focus.getChildren(d);
            if (children.isEmpty()) {
                throw new FHIRException(this.context.formatMessage("Unable_to_find__resolving_discriminator__from_", d, discriminator, element.getProperty().getName()));
            }
            if (children.size() > 1) {
                throw new FHIRException(this.context.formatMessage("Found__items_for__resolving_discriminator__from_", Integer.toString(children.size()), d, discriminator, element.getProperty().getName()));
            }
            focus = children.get(0);
            p = p + "." + d;
        }
        return focus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeSystem getCodeSystem(String system) {
        long t = System.nanoTime();
        try {
            CodeSystem codeSystem = this.context.fetchCodeSystem(system);
            return codeSystem;
        }
        finally {
            this.timeTracker.tx(t, System.nanoTime());
        }
    }

    private boolean hasTime(String fmt) {
        return fmt.contains("T");
    }

    private boolean hasTimeZone(String fmt) {
        return fmt.length() > 10 && (fmt.substring(10).contains("-") || fmt.substring(10).contains("+") || fmt.substring(10).contains("Z"));
    }

    private boolean isAbsolute(String uri) {
        return Utilities.noString(uri) || uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("urn:uuid:") || uri.startsWith("urn:oid:") || uri.startsWith("urn:ietf:") || uri.startsWith("urn:iso:") || uri.startsWith("urn:iso-astm:") || uri.startsWith("mailto:") || this.isValidFHIRUrn(uri);
    }

    private boolean isValidFHIRUrn(String uri) {
        return uri.equals("urn:x-fhir:uk:id:nhs-number") || uri.startsWith("urn:");
    }

    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    @Override
    public boolean isErrorForUnknownProfiles() {
        return this.errorForUnknownProfiles;
    }

    @Override
    public void setErrorForUnknownProfiles(boolean errorForUnknownProfiles) {
        this.errorForUnknownProfiles = errorForUnknownProfiles;
    }

    private boolean isParametersEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && (InstanceValidator.pathEntryHasName(parts[parts.length - 2], "parameter") || InstanceValidator.pathEntryHasName(parts[parts.length - 2], "part"));
    }

    private boolean isBundleEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && InstanceValidator.pathEntryHasName(parts[parts.length - 2], "entry");
    }

    private boolean isBundleOutcome(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("outcome") && InstanceValidator.pathEntryHasName(parts[parts.length - 2], "response");
    }

    private static boolean pathEntryHasName(String thePathEntry, String theName) {
        if (thePathEntry.equals(theName)) {
            return true;
        }
        return thePathEntry.length() >= theName.length() + 3 && thePathEntry.startsWith(theName) && thePathEntry.charAt(theName.length()) == '[';
    }

    public boolean isPrimitiveType(String code) {
        StructureDefinition sd = this.context.fetchTypeDefinition(code);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    private String getErrorMessage(String message) {
        return message != null ? " (error message = " + message + ")" : "";
    }

    public boolean isSuppressLoincSnomedMessages() {
        return this.suppressLoincSnomedMessages;
    }

    private boolean nameMatches(String name, String tail) {
        if (tail.endsWith("[x]")) {
            return name.startsWith(tail.substring(0, tail.length() - 3));
        }
        return name.equals(tail);
    }

    private boolean passesCodeWhitespaceRules(String v) {
        if (!v.trim().equals(v)) {
            return false;
        }
        boolean lastWasSpace = true;
        for (char c : v.toCharArray()) {
            if (c == ' ') {
                if (lastWasSpace) {
                    return false;
                }
                lastWasSpace = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                return false;
            }
            lastWasSpace = false;
        }
        return true;
    }

    private ResolvedReference localResolve(String ref, NodeStack stack, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element hostContext, org.hl7.fhir.r5.elementmodel.Element source) {
        String type;
        if (ref.startsWith("#")) {
            while (stack != null && stack.getElement() != null) {
                IndexedElement res;
                if (stack.getElement().getProperty().isResource() && (res = this.getContainedById(stack.getElement(), ref.substring(1))) != null) {
                    ResolvedReference rr = new ResolvedReference();
                    rr.setResource(stack.getElement());
                    rr.setFocus(res.getMatch());
                    rr.setExternal(false);
                    rr.setStack(stack.push(res.getMatch(), res.getIndex(), res.getMatch().getProperty().getDefinition(), res.getMatch().getProperty().getDefinition()));
                    rr.getStack().qualifyPath(".ofType(" + stack.getElement().fhirType() + ")");
                    return rr;
                }
                if (stack.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY) {
                    return null;
                }
                stack = stack.getParent();
            }
            return null;
        }
        String fullUrl = null;
        while (stack != null && stack.getElement() != null) {
            if (stack.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY && fullUrl == null && stack.getParent() != null && stack.getParent().getElement().getName().equals("entry")) {
                type = stack.getParent().getParent().getElement().getChildValue("type");
                fullUrl = stack.getParent().getElement().getChildValue("fullUrl");
                if (fullUrl == null) {
                    this.rule(errors, ValidationMessage.IssueType.REQUIRED, stack.getParent().getElement().line(), stack.getParent().getElement().col(), stack.getParent().getLiteralPath(), Utilities.existsInList(type, "batch-response", "transaction-response") || fullUrl != null, "Bundle_BUNDLE_Entry_NoFullUrl", new Object[0]);
                }
            }
            if ("Bundle".equals(stack.getElement().getType())) {
                type = stack.getElement().getChildValue("type");
                IndexedElement res = this.getFromBundle(stack.getElement(), ref, fullUrl, errors, path, type, "transaction".equals(type));
                if (res == null) {
                    return null;
                }
                ResolvedReference rr = new ResolvedReference();
                rr.setResource(res.getMatch());
                rr.setFocus(res.getMatch());
                rr.setExternal(false);
                rr.setStack(stack.push(res.getEntry(), res.getIndex(), res.getEntry().getProperty().getDefinition(), res.getEntry().getProperty().getDefinition()).push(res.getMatch(), -1, res.getMatch().getProperty().getDefinition(), res.getMatch().getProperty().getDefinition()));
                rr.getStack().qualifyPath(".ofType(" + rr.getResource().fhirType() + ")");
                return rr;
            }
            stack = stack.getParent();
        }
        if (hostContext != null && "Bundle".equals(hostContext.fhirType())) {
            type = hostContext.getChildValue("type");
            org.hl7.fhir.r5.elementmodel.Element entry = this.getEntryForSource(hostContext, source);
            fullUrl = entry.getChildValue("fullUrl");
            IndexedElement res = this.getFromBundle(hostContext, ref, fullUrl, errors, path, type, "transaction".equals(type));
            if (res == null) {
                return null;
            }
            ResolvedReference rr = new ResolvedReference();
            rr.setResource(res.getMatch());
            rr.setFocus(res.getMatch());
            rr.setExternal(false);
            rr.setStack(new NodeStack(this.context, hostContext, this.validationLanguage).push(res.getEntry(), res.getIndex(), res.getEntry().getProperty().getDefinition(), res.getEntry().getProperty().getDefinition()).push(res.getMatch(), -1, res.getMatch().getProperty().getDefinition(), res.getMatch().getProperty().getDefinition()));
            rr.getStack().qualifyPath(".ofType(" + rr.getResource().fhirType() + ")");
            return rr;
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element getEntryForSource(org.hl7.fhir.r5.elementmodel.Element bundle, org.hl7.fhir.r5.elementmodel.Element element) {
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> entries = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        bundle.getNamedChildren("entry", entries);
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            if (!entry.hasDescendant(element)) continue;
            return entry;
        }
        return null;
    }

    private ResolvedReference makeExternalRef(org.hl7.fhir.r5.elementmodel.Element external, String path) {
        ResolvedReference res = new ResolvedReference();
        res.setResource(external);
        res.setFocus(external);
        res.setExternal(true);
        res.setStack(new NodeStack(this.context, external, path, this.validationLanguage));
        return res;
    }

    private org.hl7.fhir.r5.elementmodel.Element resolve(Object appContext, String ref, NodeStack stack, List<ValidationMessage> errors, String path) throws IOException, FHIRException {
        org.hl7.fhir.r5.elementmodel.Element local = this.localResolve(ref, stack, errors, path, null, null).getFocus();
        if (local != null) {
            return local;
        }
        if (this.fetcher == null) {
            return null;
        }
        if (this.fetchCache.containsKey(ref)) {
            return this.fetchCache.get(ref);
        }
        org.hl7.fhir.r5.elementmodel.Element res = this.fetcher.fetch(appContext, ref);
        this.fetchCache.put(ref, res);
        return res;
    }

    private org.hl7.fhir.r5.elementmodel.Element resolveInBundle(List<org.hl7.fhir.r5.elementmodel.Element> entries, String ref, String fullUrl, String type, String id) {
        String[] parts;
        if (Utilities.isAbsoluteUrl(ref)) {
            for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
                String fu = entry.getNamedChildValue("fullUrl");
                if (!ref.equals(fu)) continue;
                return entry;
            }
            return null;
        }
        String u = null;
        if (fullUrl != null && fullUrl.endsWith(type + "/" + id)) {
            u = fullUrl.substring(0, fullUrl.length() - (type + "/" + id).length()) + ref;
        }
        if ((parts = ref.split("\\/")).length >= 2) {
            String t = parts[0];
            String i = parts[1];
            for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
                org.hl7.fhir.r5.elementmodel.Element resource;
                String fu = entry.getNamedChildValue("fullUrl");
                if (fu != null && fu.equals(u)) {
                    return entry;
                }
                if (u != null || (resource = entry.getNamedChild("resource")) == null) continue;
                String et = resource.getType();
                String eid = resource.getNamedChildValue("id");
                if (!t.equals(et) || !i.equals(eid)) continue;
                return entry;
            }
        }
        return null;
    }

    private ElementDefinition resolveNameReference(StructureDefinition.StructureDefinitionSnapshotComponent snapshot, String contentReference) {
        for (ElementDefinition ed : snapshot.getElement()) {
            if (!contentReference.equals("#" + ed.getId())) continue;
            return ed;
        }
        return null;
    }

    private StructureDefinition resolveProfile(StructureDefinition profile, String pr) {
        if (pr.startsWith("#")) {
            for (Resource r : profile.getContained()) {
                if (!r.getId().equals(pr.substring(1)) || !(r instanceof StructureDefinition)) continue;
                return (StructureDefinition)r;
            }
            return null;
        }
        long t = System.nanoTime();
        StructureDefinition fr = this.context.fetchResource(StructureDefinition.class, pr);
        this.timeTracker.sd(t, System.nanoTime());
        return fr;
    }

    private ElementDefinition resolveType(String type, List<ElementDefinition.TypeRefComponent> list) {
        for (ElementDefinition.TypeRefComponent tr : list) {
            String url = tr.getWorkingCode();
            if (!Utilities.isAbsoluteUrl(url)) {
                url = "http://hl7.org/fhir/StructureDefinition/" + url;
            }
            long t = System.nanoTime();
            StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, url);
            this.timeTracker.sd(t, System.nanoTime());
            if (sd == null || !sd.getType().equals(type) && !sd.getUrl().equals(type) || !sd.hasSnapshot()) continue;
            return sd.getSnapshot().getElement().get(0);
        }
        return null;
    }

    public void setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
    }

    @Override
    public IResourceValidator setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel value) {
        this.bpWarnings = value;
        return this;
    }

    @Override
    public void setCheckDisplay(IResourceValidator.CheckDisplayOption checkDisplay) {
        this.checkDisplay = checkDisplay;
    }

    public void setSuppressLoincSnomedMessages(boolean suppressLoincSnomedMessages) {
        this.suppressLoincSnomedMessages = suppressLoincSnomedMessages;
    }

    @Override
    public IResourceValidator.IdStatus getResourceIdRule() {
        return this.resourceIdRule;
    }

    @Override
    public void setResourceIdRule(IResourceValidator.IdStatus resourceIdRule) {
        this.resourceIdRule = resourceIdRule;
    }

    public boolean isAllowXsiLocation() {
        return this.allowXsiLocation;
    }

    public void setAllowXsiLocation(boolean allowXsiLocation) {
        this.allowXsiLocation = allowXsiLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sliceMatches(ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element, String path, ElementDefinition slicer, ElementDefinition ed, StructureDefinition profile, List<ValidationMessage> errors, List<ValidationMessage> sliceInfo, NodeStack stack) throws DefinitionException, FHIRException {
        ValidatorHostContext shc;
        boolean pass;
        if (!slicer.getSlicing().hasDiscriminator()) {
            return false;
        }
        ExpressionNode n = (ExpressionNode)ed.getUserData("slice.expression.cache");
        if (n == null) {
            long t = System.nanoTime();
            StringBuilder expression = new StringBuilder("true");
            boolean anyFound = false;
            HashSet<String> discriminators = new HashSet<String>();
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent s2 : slicer.getSlicing().getDiscriminator()) {
                String discriminator = s2.getPath();
                discriminators.add(discriminator);
                List<ElementDefinition> criteriaElements = this.getCriteriaForDiscriminator(path, ed, discriminator, profile, s2.getType() == ElementDefinition.DiscriminatorType.PROFILE);
                boolean found = false;
                for (ElementDefinition criteriaElement : criteriaElements) {
                    found = true;
                    if (s2.getType() == ElementDefinition.DiscriminatorType.TYPE) {
                        String type = null;
                        if (!criteriaElement.getPath().contains("[") && discriminator.contains("[")) {
                            discriminator = discriminator.substring(0, discriminator.indexOf(91));
                            String lastNode = this.tail(discriminator);
                            type = this.tail(criteriaElement.getPath()).substring(lastNode.length());
                            type = type.substring(0, 1).toLowerCase() + type.substring(1);
                        } else if (!criteriaElement.hasType() || criteriaElement.getType().size() == 1) {
                            if (discriminator.contains("[")) {
                                discriminator = discriminator.substring(0, discriminator.indexOf(91));
                            }
                            if (criteriaElement.hasType()) {
                                type = criteriaElement.getType().get(0).getWorkingCode();
                            } else {
                                if (criteriaElement.getPath().contains(".")) throw new DefinitionException(this.context.formatMessage("Discriminator__is_based_on_type_but_slice__in__has_no_types", discriminator, ed.getId(), profile.getUrl()));
                                type = criteriaElement.getPath();
                            }
                        } else {
                            if (criteriaElement.getType().size() <= 1) throw new DefinitionException(this.context.formatMessage("Discriminator__is_based_on_type_but_slice__in__has_no_types", discriminator, ed.getId(), profile.getUrl()));
                            throw new DefinitionException(this.context.formatMessage("Discriminator__is_based_on_type_but_slice__in__has_multiple_types_", discriminator, ed.getId(), profile.getUrl(), criteriaElement.typeSummary()));
                        }
                        if (discriminator.isEmpty()) {
                            expression.append(" and $this is " + type);
                        } else {
                            expression.append(" and " + discriminator + " is " + type);
                        }
                    } else if (s2.getType() == ElementDefinition.DiscriminatorType.PROFILE) {
                        List<CanonicalType> list;
                        if (criteriaElement.getType().size() == 0) {
                            throw new DefinitionException(this.context.formatMessage("Profile_based_discriminators_must_have_a_type__in_profile_", criteriaElement.getId(), profile.getUrl()));
                        }
                        if (criteriaElement.getType().size() != 1) {
                            throw new DefinitionException(this.context.formatMessage("Profile_based_discriminators_must_have_only_one_type__in_profile_", criteriaElement.getId(), profile.getUrl()));
                        }
                        List<CanonicalType> list2 = list = discriminator.endsWith(".resolve()") || discriminator.equals("resolve()") ? criteriaElement.getType().get(0).getTargetProfile() : criteriaElement.getType().get(0).getProfile();
                        if (list.size() == 0) {
                            throw new DefinitionException(this.context.formatMessage("Profile_based_discriminators_must_have_a_type_with_a_profile__in_profile_", criteriaElement.getId(), profile.getUrl()));
                        }
                        if (list.size() > 1) {
                            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" or ");
                            for (CanonicalType c : list) {
                                b.append(discriminator + ".conformsTo('" + (String)c.getValue() + "')");
                            }
                            expression.append(" and (" + b + ")");
                        } else {
                            expression.append(" and " + discriminator + ".conformsTo('" + (String)list.get(0).getValue() + "')");
                        }
                    } else if (s2.getType() == ElementDefinition.DiscriminatorType.EXISTS) {
                        if (criteriaElement.hasMin() && criteriaElement.getMin() >= 1) {
                            expression.append(" and (" + discriminator + ".exists())");
                        } else {
                            if (!criteriaElement.hasMax() || !criteriaElement.getMax().equals("0")) throw new FHIRException(this.context.formatMessage("Discriminator__is_based_on_element_existence_but_slice__neither_sets_min1_or_max0", discriminator, ed.getId()));
                            expression.append(" and (" + discriminator + ".exists().not())");
                        }
                    } else if (criteriaElement.hasFixed()) {
                        this.buildFixedExpression(ed, expression, discriminator, criteriaElement);
                    } else if (criteriaElement.hasPattern()) {
                        this.buildPattternExpression(ed, expression, discriminator, criteriaElement);
                    } else if (criteriaElement.hasBinding() && criteriaElement.getBinding().hasStrength() && criteriaElement.getBinding().getStrength().equals((Object)Enumerations.BindingStrength.REQUIRED) && criteriaElement.getBinding().hasValueSet()) {
                        expression.append(" and (" + discriminator + " memberOf '" + criteriaElement.getBinding().getValueSet() + "')");
                    } else {
                        found = false;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) continue;
                anyFound = true;
            }
            if (!anyFound) {
                if (slicer.getSlicing().getDiscriminator().size() <= 1) throw new DefinitionException(this.context.formatMessage("Could_not_match_discriminator__for_slice__in_profile___the_discriminator__does_not_have_fixed_value_binding_or_existence_assertions", discriminators, ed.getId(), profile.getUrl(), discriminators));
                throw new DefinitionException(this.context.formatMessage("Could_not_match_any_discriminators__for_slice__in_profile___None_of_the_discriminator__have_fixed_value_binding_or_existence_assertions", discriminators, ed.getId(), profile.getUrl(), discriminators));
            }
            try {
                n = this.fpe.parse(this.fixExpr(expression.toString()));
            }
            catch (FHIRLexer.FHIRLexerException e) {
                throw new FHIRException(this.context.formatMessage("Problem_processing_expression__in_profile__path__", expression, profile.getUrl(), path, e.getMessage()));
            }
            this.timeTracker.fpe(t, System.nanoTime());
            ed.setUserData("slice.expression.cache", n);
        }
        if (pass = this.evaluateSlicingExpression(shc = hostContext.forSlicing(), element, path, profile, n)) return pass;
        this.slicingHint(sliceInfo, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.context.formatMessage("Does_not_match_slice_", ed.getSliceName()), "discriminator = " + Utilities.escapeXml(n.toString()));
        for (String url : shc.getSliceRecords().keySet()) {
            this.slicingHint(sliceInfo, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.context.formatMessage("Details_for__matching_against_Profile_", stack.getLiteralPath(), url), this.context.formatMessage("Profile__does_not_match_for__because_of_the_following_profile_issues__", url, stack.getLiteralPath(), this.errorSummaryForSlicingAsHtml(shc.getSliceRecords().get(url))));
        }
        return pass;
    }

    public boolean evaluateSlicingExpression(ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element, String path, StructureDefinition profile, ExpressionNode n) throws FHIRException {
        boolean ok;
        try {
            long t = System.nanoTime();
            ok = this.fpe.evaluateToBoolean((Object)hostContext.forProfile(profile), hostContext.getResource(), hostContext.getRootResource(), (Base)element, n);
            this.timeTracker.fpe(t, System.nanoTime());
            String msg = this.fpe.forLog();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new FHIRException(this.context.formatMessage("Problem_evaluating_slicing_expression_for_element_in_profile__path__fhirPath___", profile.getUrl(), path, n, ex.getMessage()));
        }
        return ok;
    }

    private void buildPattternExpression(ElementDefinition ed, StringBuilder expression, String discriminator, ElementDefinition criteriaElement) throws DefinitionException {
        DataType pattern = criteriaElement.getPattern();
        if (pattern instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)pattern;
            expression.append(" and ");
            this.buildCodeableConceptExpression(ed, expression, discriminator, cc);
        } else if (pattern instanceof Coding) {
            Coding c = (Coding)pattern;
            expression.append(" and ");
            this.buildCodingExpression(ed, expression, discriminator, c);
        } else if (pattern instanceof Identifier) {
            Identifier ii = (Identifier)pattern;
            expression.append(" and ");
            this.buildIdentifierExpression(ed, expression, discriminator, ii);
        } else {
            throw new DefinitionException(this.context.formatMessage("Unsupported_fixed_pattern_type_for_discriminator_for_slice__", discriminator, ed.getId(), pattern.getClass().getName()));
        }
    }

    private void buildIdentifierExpression(ElementDefinition ed, StringBuilder expression, String discriminator, Identifier ii) throws DefinitionException {
        if (ii.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_Identifier_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", discriminator, ed.getId()));
        }
        boolean first = true;
        expression.append(discriminator + ".where(");
        if (ii.hasSystem()) {
            first = false;
            expression.append("system = '" + ii.getSystem() + "'");
        }
        if (ii.hasValue()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("value = '" + ii.getValue() + "'");
        }
        if (ii.hasUse()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("use = '" + (Object)((Object)ii.getUse()) + "'");
        }
        if (ii.hasType()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            this.buildCodeableConceptExpression(ed, expression, "type", ii.getType());
        }
        expression.append(").exists()");
    }

    private void buildCodeableConceptExpression(ElementDefinition ed, StringBuilder expression, String discriminator, CodeableConcept cc) throws DefinitionException {
        if (cc.hasText()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__using_text__for_discriminator_for_slice_", discriminator, ed.getId()));
        }
        if (!cc.hasCoding()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__must_have_at_least_one_coding__for_discriminator_for_slice_", discriminator, ed.getId()));
        }
        if (cc.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", discriminator, ed.getId()));
        }
        boolean firstCoding = true;
        for (Coding c : cc.getCoding()) {
            if (c.hasExtension()) {
                throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", discriminator, ed.getId()));
            }
            if (firstCoding) {
                firstCoding = false;
            } else {
                expression.append(" and ");
            }
            expression.append(discriminator + ".coding.where(");
            boolean first = true;
            if (c.hasSystem()) {
                first = false;
                expression.append("system = '" + c.getSystem() + "'");
            }
            if (c.hasVersion()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("version = '" + c.getVersion() + "'");
            }
            if (c.hasCode()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("code = '" + c.getCode() + "'");
            }
            if (c.hasDisplay()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("display = '" + c.getDisplay() + "'");
            }
            expression.append(").exists()");
        }
    }

    private void buildCodingExpression(ElementDefinition ed, StringBuilder expression, String discriminator, Coding c) throws DefinitionException {
        if (c.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", discriminator, ed.getId()));
        }
        expression.append(discriminator + ".where(");
        boolean first = true;
        if (c.hasSystem()) {
            first = false;
            expression.append("system = '" + c.getSystem() + "'");
        }
        if (c.hasVersion()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("version = '" + c.getVersion() + "'");
        }
        if (c.hasCode()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("code = '" + c.getCode() + "'");
        }
        if (c.hasDisplay()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("display = '" + c.getDisplay() + "'");
        }
        expression.append(").exists()");
    }

    private void buildFixedExpression(ElementDefinition ed, StringBuilder expression, String discriminator, ElementDefinition criteriaElement) throws DefinitionException {
        DataType fixed = criteriaElement.getFixed();
        if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            expression.append(" and ");
            this.buildCodeableConceptExpression(ed, expression, discriminator, cc);
        } else if (fixed instanceof Identifier) {
            Identifier ii = (Identifier)fixed;
            expression.append(" and ");
            this.buildIdentifierExpression(ed, expression, discriminator, ii);
        } else if (fixed instanceof Coding) {
            Coding c = (Coding)fixed;
            expression.append(" and ");
            this.buildCodingExpression(ed, expression, discriminator, c);
        } else {
            expression.append(" and (");
            if (fixed instanceof StringType) {
                Gson gson = new Gson();
                String json = gson.toJson((StringType)fixed);
                String escapedString = json.substring(json.indexOf(":") + 2);
                escapedString = escapedString.substring(0, escapedString.indexOf(",\"myStringValue") - 1);
                expression.append("'" + escapedString + "'");
            } else if (fixed instanceof UriType) {
                expression.append("'" + ((UriType)fixed).asStringValue() + "'");
            } else if (fixed instanceof IntegerType) {
                expression.append(((IntegerType)fixed).asStringValue());
            } else if (fixed instanceof DecimalType) {
                expression.append(((IntegerType)fixed).asStringValue());
            } else if (fixed instanceof BooleanType) {
                expression.append(((BooleanType)fixed).asStringValue());
            } else {
                throw new DefinitionException(this.context.formatMessage("Unsupported_fixed_value_type_for_discriminator_for_slice__", discriminator, ed.getId(), fixed.getClass().getName()));
            }
            expression.append(" in " + discriminator + ")");
        }
    }

    private void start(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, NodeStack stack) throws FHIRException {
        this.checkLang(resource, stack);
        if ("Bundle".equals(element.fhirType())) {
            this.resolveBundleReferences(element, new ArrayList<org.hl7.fhir.r5.elementmodel.Element>());
        }
        this.startInner(hostContext, errors, resource, element, defn, stack, hostContext.isCheckSpecials());
        org.hl7.fhir.r5.elementmodel.Element meta = element.getNamedChild("meta");
        if (meta != null) {
            ArrayList<org.hl7.fhir.r5.elementmodel.Element> profiles = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
            meta.getNamedChildren("profile", profiles);
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element profile : profiles) {
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, profile.primitiveValue());
                if (!defn.getUrl().equals(profile.primitiveValue()) && this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", sd != null, "Validation_VAL_Profile_Unknown", profile.primitiveValue())) {
                    stack.resetIds();
                    this.startInner(hostContext, errors, resource, element, sd, stack, false);
                }
                ++i;
            }
        }
    }

    private void resolveBundleReferences(org.hl7.fhir.r5.elementmodel.Element element, List<org.hl7.fhir.r5.elementmodel.Element> bundles) {
        if (!element.hasUserData("validator.bundle.resolved")) {
            element.setUserData("validator.bundle.resolved", true);
            ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
            list.addAll(bundles);
            list.add(0, element);
            List<org.hl7.fhir.r5.elementmodel.Element> entries = element.getChildrenByName("entry");
            for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
                String fu = entry.getChildValue("fullUrl");
                org.hl7.fhir.r5.elementmodel.Element r = entry.getNamedChild("resource");
                if (r == null) continue;
                this.resolveBundleReferencesInResource(list, r, fu);
            }
        }
    }

    private void resolveBundleReferencesInResource(List<org.hl7.fhir.r5.elementmodel.Element> bundles, org.hl7.fhir.r5.elementmodel.Element r, String fu) {
        r.setUserData("validator.bundle.resolution-resource", null);
        if ("Bundle".equals(r.fhirType())) {
            this.resolveBundleReferences(r, bundles);
        } else {
            for (org.hl7.fhir.r5.elementmodel.Element child : r.getChildren()) {
                this.resolveBundleReferencesForElement(bundles, r, fu, child);
            }
        }
    }

    private void resolveBundleReferencesForElement(List<org.hl7.fhir.r5.elementmodel.Element> bundles, org.hl7.fhir.r5.elementmodel.Element resource, String fu, org.hl7.fhir.r5.elementmodel.Element element) {
        if ("Reference".equals(element.fhirType())) {
            String ref = element.getChildValue("reference");
            if (!Utilities.noString(ref)) {
                for (org.hl7.fhir.r5.elementmodel.Element bundle : bundles) {
                    List<org.hl7.fhir.r5.elementmodel.Element> entries = bundle.getChildren("entry");
                    org.hl7.fhir.r5.elementmodel.Element tgt = this.resolveInBundle(entries, ref, fu, resource.fhirType(), resource.getIdBase());
                    if (tgt == null) continue;
                    element.setUserData("validator.bundle.resolution", tgt.getNamedChild("resource"));
                    return;
                }
                element.setUserData("validator.bundle.resolution-failed", ref);
            }
        } else {
            element.setUserData("validator.bundle.resolution-noref", null);
            for (org.hl7.fhir.r5.elementmodel.Element child : element.getChildren()) {
                this.resolveBundleReferencesForElement(bundles, resource, fu, child);
            }
        }
    }

    public void startInner(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, NodeStack stack, boolean checkSpecials) {
        ResourceValidationTracker resTracker = this.getResourceTracker(element);
        List<ValidationMessage> cachedErrors = resTracker.getOutcomes(defn);
        if (cachedErrors != null) {
            for (ValidationMessage vm : cachedErrors) {
                if (errors.contains(vm)) continue;
                errors.add(vm);
            }
            return;
        }
        if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), defn.hasSnapshot(), "Validation_VAL_Profile_NoSnapshot", new Object[0])) {
            ArrayList<ValidationMessage> localErrors = new ArrayList<ValidationMessage>();
            resTracker.startValidating(defn);
            this.trackUsage(defn, hostContext, element);
            this.validateElement(hostContext, localErrors, defn, defn.getSnapshot().getElement().get(0), null, null, resource, element, element.getName(), stack, false, true, null);
            resTracker.storeOutcomes(defn, localErrors);
            for (ValidationMessage vm : localErrors) {
                if (errors.contains(vm)) continue;
                errors.add(vm);
            }
        }
        if (checkSpecials) {
            this.checkSpecials(hostContext, errors, element, stack, checkSpecials);
            this.validateResourceRules(errors, element, stack);
        }
    }

    public void checkSpecials(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean checkSpecials) {
        if (element.getType().equals("Bundle")) {
            this.validateBundle(errors, element, stack, checkSpecials);
        } else if (element.getType().equals("Observation")) {
            this.validateObservation(errors, element, stack);
        } else if (element.getType().equals("Questionnaire")) {
            new QuestionnaireValidator(this.context, this.myEnableWhenEvaluator, this.fpe, this.timeTracker).validateQuestionannaire(errors, element, element, stack);
        } else if (element.getType().equals("QuestionnaireResponse")) {
            new QuestionnaireValidator(this.context, this.myEnableWhenEvaluator, this.fpe, this.timeTracker).validateQuestionannaireResponse(hostContext, errors, element, stack);
        } else if (element.getType().equals("Measure")) {
            new MeasureValidator(this.context, this.timeTracker).validateMeasure(hostContext, errors, element, stack);
        } else if (element.getType().equals("MeasureReport")) {
            new MeasureValidator(this.context, this.timeTracker).validateMeasureReport(hostContext, errors, element, stack);
        } else if (element.getType().equals("CapabilityStatement")) {
            this.validateCapabilityStatement(errors, element, stack);
        } else if (element.getType().equals("CodeSystem")) {
            new CodeSystemValidator(this.context, this.timeTracker).validateCodeSystem(errors, element, stack);
        }
    }

    private ResourceValidationTracker getResourceTracker(org.hl7.fhir.r5.elementmodel.Element element) {
        ResourceValidationTracker res = this.resourceTracker.get(element);
        if (res == null) {
            res = new ResourceValidationTracker();
            this.resourceTracker.put(element, res);
        }
        return res;
    }

    private void checkLang(org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack) {
        String lang = resource.getNamedChildValue("language");
        if (!Utilities.noString(lang)) {
            stack.setWorkingLang(lang);
        }
    }

    private void validateResourceRules(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        org.hl7.fhir.r5.elementmodel.Element meta;
        String lang = element.getNamedChildValue("language");
        org.hl7.fhir.r5.elementmodel.Element text = element.getNamedChild("text");
        if (text != null) {
            org.hl7.fhir.r5.elementmodel.Element div = text.getNamedChild("div");
            if (lang != null && div != null) {
                XhtmlNode xhtml = div.getXhtml();
                String l = xhtml.getAttribute("lang");
                String xl = xhtml.getAttribute("xml:lang");
                if (l == null && xl == null) {
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Missing1", new Object[0]);
                } else {
                    if (l == null) {
                        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Missing2", new Object[0]);
                    } else if (!l.equals(lang)) {
                        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Different1", lang, l);
                    }
                    if (xl == null) {
                        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Missing3", new Object[0]);
                    } else if (!xl.equals(lang)) {
                        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Different2", lang, xl);
                    }
                }
            }
        }
        if ((meta = element.getNamedChild("meta")) != null) {
            HashSet<String> tags = new HashSet<String>();
            ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
            meta.getNamedChildren("security", list);
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element e : list) {
                String s2 = e.getNamedChildValue("system") + "#" + e.getNamedChildValue("code");
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, e.line(), e.col(), stack.getLiteralPath() + ".meta.profile[" + Integer.toString(i) + "]", !tags.contains(s2), "Meta_RES_Security_Duplicate", s2);
                tags.add(s2);
                ++i;
            }
        }
    }

    private void validateCapabilityStatement(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element cs, NodeStack stack) {
        int iRest = 0;
        for (org.hl7.fhir.r5.elementmodel.Element rest : cs.getChildrenByName("rest")) {
            int iResource = 0;
            for (org.hl7.fhir.r5.elementmodel.Element resource : rest.getChildrenByName("resource")) {
                int iSP = 0;
                for (org.hl7.fhir.r5.elementmodel.Element searchParam : resource.getChildrenByName("searchParam")) {
                    SearchParameter sp;
                    String ref = searchParam.getChildValue("definition");
                    String type = searchParam.getChildValue("type");
                    if (!Utilities.noString(ref) && (sp = this.context.fetchResource(SearchParameter.class, ref)) != null) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, searchParam.line(), searchParam.col(), stack.getLiteralPath() + ".rest[" + iRest + "].resource[" + iResource + "].searchParam[" + iSP + "]", sp.getType().toCode().equals(type), "CapabalityStatement_CS_SP_WrongType", sp.getUrl(), sp.getType().toCode(), type);
                    }
                    ++iSP;
                }
                ++iResource;
            }
            ++iRest;
        }
    }

    private void validateBundle(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, NodeStack stack, boolean checkSpecials) {
        String id;
        String fullUrl;
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> entries = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        bundle.getNamedChildren("entry", entries);
        String type = bundle.getNamedChildValue("type");
        type = StringUtils.defaultString(type);
        if (entries.size() == 0) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !type.equals("document") && !type.equals("message"), "Bundle_BUNDLE_Entry_NoFirst");
        } else {
            org.hl7.fhir.r5.elementmodel.Element resource;
            org.hl7.fhir.r5.elementmodel.Element firstEntry = (org.hl7.fhir.r5.elementmodel.Element)entries.get(0);
            NodeStack firstStack = stack.push(firstEntry, 1, null, null);
            fullUrl = firstEntry.getNamedChildValue("fullUrl");
            if (type.equals("document")) {
                resource = firstEntry.getNamedChild("resource");
                id = resource.getNamedChildValue("id");
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "Bundle_BUNDLE_Entry_NoFirstResource", new Object[0])) {
                    this.validateDocument(errors, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id);
                }
                if (!VersionUtilities.isThisOrLater(Enumerations.FHIRVersion._4_0_1.getDisplay(), bundle.getProperty().getStructure().getFhirVersion().getDisplay())) {
                    this.handleSpecialCaseForLastUpdated(bundle, errors, stack);
                }
                this.checkAllInterlinked(errors, entries, stack, bundle, true);
            }
            if (type.equals("message")) {
                resource = firstEntry.getNamedChild("resource");
                id = resource.getNamedChildValue("id");
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "Bundle_BUNDLE_Entry_NoFirstResource", new Object[0])) {
                    this.validateMessage(errors, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id);
                }
                this.checkAllInterlinked(errors, entries, stack, bundle, VersionUtilities.isR5Ver(this.context.getVersion()));
            }
        }
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            fullUrl = entry.getNamedChildValue("fullUrl");
            String url = this.getCanonicalURLForEntry(entry);
            id = this.getIdForEntry(entry);
            if (url == null) continue;
            if (!(!url.equals(fullUrl) || url.matches(this.uriRegexForVersion()) && url.endsWith("/" + id) || this.isV3orV2Url(url))) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), false, "Bundle_BUNDLE_Entry_MismatchIdUrl", url, fullUrl, id);
            }
            this.rule(errors, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), !url.equals(fullUrl) || this.serverBase == null || url.equals(Utilities.pathURL(this.serverBase, entry.getNamedChild("resource").fhirType(), id)), "Bundle_BUNDLE_Entry_Canonical", url, fullUrl);
        }
    }

    private void handleSpecialCaseForLastUpdated(org.hl7.fhir.r5.elementmodel.Element bundle, List<ValidationMessage> errors, NodeStack stack) {
        boolean ok = bundle.hasChild("meta") && bundle.getNamedChild("meta").hasChild("lastUpdated") && bundle.getNamedChild("meta").getNamedChild("lastUpdated").hasValue();
        this.rule(errors, ValidationMessage.IssueType.REQUIRED, stack.getLiteralPath(), ok, "Bundle_Document_Date_Missing", "Bundle_Document_Date_Missing_html");
    }

    private boolean isV3orV2Url(String url) {
        return url.startsWith("http://hl7.org/fhir/v3/") || url.startsWith("http://hl7.org/fhir/v2/");
    }

    private String uriRegexForVersion() {
        if (VersionUtilities.isR3Ver(this.context.getVersion())) {
            return URI_REGEX3;
        }
        return "((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CapabilityStatement2|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseIssue|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceFocus|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationUsage|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    }

    private String getCanonicalURLForEntry(org.hl7.fhir.r5.elementmodel.Element entry) {
        org.hl7.fhir.r5.elementmodel.Element e = entry.getNamedChild("resource");
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("url");
    }

    private String getIdForEntry(org.hl7.fhir.r5.elementmodel.Element entry) {
        org.hl7.fhir.r5.elementmodel.Element e = entry.getNamedChild("resource");
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("id");
    }

    private void validateResourceIds(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, NodeStack stack) {
        int i = 1;
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            String id;
            String fullUrl = entry.getNamedChildValue("fullUrl");
            org.hl7.fhir.r5.elementmodel.Element resource = entry.getNamedChild("resource");
            String string = id = resource != null ? resource.getNamedChildValue("id") : null;
            if (id != null && fullUrl != null) {
                String urlId = null;
                if (fullUrl.startsWith("https://") || fullUrl.startsWith("http://")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(47) + 1);
                } else if (fullUrl.startsWith("urn:uuid") || fullUrl.startsWith("urn:oid")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(58) + 1);
                }
                this.rule(errors, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + i + "]"), urlId.equals(id), "Bundle_BUNDLE_Entry_IdUrlMismatch", id, fullUrl);
            }
            ++i;
        }
    }

    private void checkAllInterlinked(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, NodeStack stack, org.hl7.fhir.r5.elementmodel.Element bundle, boolean isError) {
        boolean foundRevLinks;
        ArrayList<EntrySummary> entryList = new ArrayList<EntrySummary>();
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            org.hl7.fhir.r5.elementmodel.Element r = entry.getNamedChild("resource");
            if (r == null) continue;
            entryList.add(new EntrySummary(entry, r));
        }
        for (EntrySummary e : entryList) {
            Set<String> references = this.findReferences(e.getEntry());
            Iterator<String> iterator = references.iterator();
            while (iterator.hasNext()) {
                EntrySummary t;
                String ref = iterator.next();
                org.hl7.fhir.r5.elementmodel.Element tgt = this.resolveInBundle(entries, ref, e.getEntry().getChildValue("fullUrl"), e.getResource().fhirType(), e.getResource().getIdBase());
                if (tgt == null || (t = this.entryForTarget(entryList, tgt)) == null) continue;
                e.getTargets().add(t);
            }
        }
        HashSet<EntrySummary> visited = new HashSet<EntrySummary>();
        this.visitLinked(visited, (EntrySummary)entryList.get(0));
        do {
            foundRevLinks = false;
            for (EntrySummary e : entryList) {
                if (visited.contains(e)) continue;
                boolean add = false;
                for (EntrySummary t : e.getTargets()) {
                    if (!visited.contains(t)) continue;
                    add = true;
                }
                if (!add) continue;
                foundRevLinks = true;
                this.visitLinked(visited, e);
            }
        } while (foundRevLinks);
        int i = 0;
        for (EntrySummary e : entryList) {
            org.hl7.fhir.r5.elementmodel.Element entry = e.getEntry();
            if (isError) {
                this.rule(errors, ValidationMessage.IssueType.INFORMATIONAL, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + (i + 1) + ']'), visited.contains(e), "Bundle_BUNDLE_Entry_Orphan", entry.getChildValue("fullUrl") != null ? "'" + entry.getChildValue("fullUrl") + "'" : "");
            } else {
                this.warning(errors, ValidationMessage.IssueType.INFORMATIONAL, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + (i + 1) + ']'), visited.contains(e), "Bundle_BUNDLE_Entry_Orphan", entry.getChildValue("fullUrl") != null ? "'" + entry.getChildValue("fullUrl") + "'" : "");
            }
            ++i;
        }
    }

    private EntrySummary entryForTarget(List<EntrySummary> entryList, org.hl7.fhir.r5.elementmodel.Element tgt) {
        for (EntrySummary e : entryList) {
            if (e.getEntry() != tgt) continue;
            return e;
        }
        return null;
    }

    private void visitLinked(Set<EntrySummary> visited, EntrySummary t) {
        if (!visited.contains(t)) {
            visited.add(t);
            for (EntrySummary e : t.getTargets()) {
                this.visitLinked(visited, e);
            }
        }
    }

    private void followResourceLinks(org.hl7.fhir.r5.elementmodel.Element entry, Map<String, org.hl7.fhir.r5.elementmodel.Element> visitedResources, Map<org.hl7.fhir.r5.elementmodel.Element, org.hl7.fhir.r5.elementmodel.Element> candidateEntries, List<org.hl7.fhir.r5.elementmodel.Element> candidateResources, List<ValidationMessage> errors, NodeStack stack) {
        this.followResourceLinks(entry, visitedResources, candidateEntries, candidateResources, errors, stack, 0);
    }

    private void followResourceLinks(org.hl7.fhir.r5.elementmodel.Element entry, Map<String, org.hl7.fhir.r5.elementmodel.Element> visitedResources, Map<org.hl7.fhir.r5.elementmodel.Element, org.hl7.fhir.r5.elementmodel.Element> candidateEntries, List<org.hl7.fhir.r5.elementmodel.Element> candidateResources, List<ValidationMessage> errors, NodeStack stack, int depth) {
        org.hl7.fhir.r5.elementmodel.Element resource = entry.getNamedChild("resource");
        if (visitedResources.containsValue(resource)) {
            return;
        }
        visitedResources.put(entry.getNamedChildValue("fullUrl"), resource);
        String type = null;
        Set<String> references = this.findReferences(resource);
        for (String reference : references) {
            IndexedElement r = this.getFromBundle(stack.getElement(), reference, entry.getChildValue("fullUrl"), new ArrayList<ValidationMessage>(), stack.addToLiteralPath("entry[" + candidateResources.indexOf(resource) + "]"), type, "transaction".equals(stack.getElement().getChildValue("type")));
            if (r == null || visitedResources.containsValue(r.getMatch())) continue;
            this.followResourceLinks(candidateEntries.get(r.getMatch()), visitedResources, candidateEntries, candidateResources, errors, stack, depth + 1);
        }
    }

    private Set<String> findReferences(org.hl7.fhir.r5.elementmodel.Element start) {
        HashSet<String> references = new HashSet<String>();
        this.findReferences(start, references);
        return references;
    }

    private void findReferences(org.hl7.fhir.r5.elementmodel.Element start, Set<String> references) {
        for (org.hl7.fhir.r5.elementmodel.Element child : start.getChildren()) {
            String ref;
            if (child.getType().equals("Reference") && (ref = child.getChildValue("reference")) != null && !ref.startsWith("#")) {
                references.add(ref);
            }
            if ((child.getType().equals("url") || child.getType().equals("uri") || child.getType().equals("canonical")) && (ref = child.primitiveValue()) != null && !ref.startsWith("#")) {
                references.add(ref);
            }
            this.findReferences(child, references);
        }
    }

    private void validateBundleReference(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element ref, String name, NodeStack stack, String fullUrl, String type, String id) {
        String reference = null;
        try {
            reference = ref.getNamedChildValue("reference");
        }
        catch (Error error) {
            // empty catch block
        }
        if (ref != null && !Utilities.noString(reference) && !reference.startsWith("#")) {
            org.hl7.fhir.r5.elementmodel.Element target = this.resolveInBundle(entries, reference, fullUrl, type, id);
            this.rule(errors, ValidationMessage.IssueType.INVALID, ref.line(), ref.col(), stack.addToLiteralPath("reference"), target != null, "Bundle_BUNDLE_Entry_NotFound", reference, name);
        }
    }

    private void validateContains(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, ElementDefinition child, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, IResourceValidator.IdStatus idstatus) throws FHIRException {
        String resourceName = element.getType();
        ElementDefinition.TypeRefComponent trr = null;
        for (ElementDefinition.TypeRefComponent tr : child.getType()) {
            if (!tr.getCode().equals("Resource")) continue;
            trr = tr;
            break;
        }
        stack.qualifyPath(".ofType(" + resourceName + ")");
        if (trr == null) {
            this.rule(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), false, "Bundle_BUNDLE_Entry_Type", resourceName);
        } else if (this.isValidResourceType(resourceName, trr)) {
            long t = System.nanoTime();
            StructureDefinition structureDefinition = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
            this.timeTracker.sd(t, System.nanoTime());
            ValidatorHostContext hc = null;
            if (element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY || element.getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME || element.getSpecial() == Element.SpecialElement.PARAMETER) {
                resource = element;
                hc = hostContext.forEntry(element);
            } else {
                hc = hostContext.forContained(element);
            }
            this.trackUsage(structureDefinition, hostContext, element);
            stack.resetIds();
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), structureDefinition != null, "Bundle_BUNDLE_Entry_NoProfile", resourceName)) {
                this.validateResource(hc, errors, resource, element, structureDefinition, idstatus, stack);
            }
        } else {
            ArrayList<String> types = new ArrayList<String>();
            for (UriType uriType : trr.getProfile()) {
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)uriType.getValue());
                if (sd == null || types.contains(sd.getType())) continue;
                types.add(sd.getType());
            }
            if (types.size() == 1) {
                this.rule(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), false, "Bundle_BUNDLE_Entry_Type2", resourceName, types.get(0));
            } else {
                this.rule(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), false, "Bundle_BUNDLE_Entry_Type3", resourceName, types);
            }
        }
    }

    private boolean isValidResourceType(String type, ElementDefinition.TypeRefComponent def) {
        if (!def.hasProfile()) {
            return true;
        }
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        for (UriType uriType : def.getProfile()) {
            StructureDefinition sdt = this.context.fetchResource(StructureDefinition.class, (String)uriType.getValue());
            if (sdt == null) continue;
            list.add(sdt);
        }
        StructureDefinition sdt = this.context.fetchTypeDefinition(type);
        while (sdt != null) {
            if (def.getWorkingCode().equals("Resource")) {
                for (StructureDefinition sd : list) {
                    if (sd.getUrl().equals(sdt.getUrl())) {
                        return true;
                    }
                    if (!sd.getType().equals(sdt.getType())) continue;
                    return true;
                }
            }
            sdt = this.context.fetchResource(StructureDefinition.class, sdt.getBaseDefinition());
        }
        return false;
    }

    private void validateDocument(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element composition, NodeStack stack, String fullUrl, String id) {
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, composition.line(), composition.col(), stack.getLiteralPath(), composition.getType().equals("Composition"), "Bundle_BUNDLE_Entry_Document", new Object[0])) {
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, false, "subject", "Composition");
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, true, "author", "Composition");
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, false, "encounter", "Composition");
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, false, "custodian", "Composition");
            this.validateDocumentSubReference(errors, entries, composition, stack, fullUrl, id, "Composition", "attester", false, "party");
            this.validateDocumentSubReference(errors, entries, composition, stack, fullUrl, id, "Composition", "event", true, "detail");
            this.validateSections(errors, entries, composition, stack, fullUrl, id);
        }
    }

    public void validateDocumentSubReference(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element composition, NodeStack stack, String fullUrl, String id, String title, String parent, boolean repeats, String propName) {
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        composition.getNamedChildren(parent, list);
        int i = 1;
        for (org.hl7.fhir.r5.elementmodel.Element elem : list) {
            this.validateDocumentReference(errors, entries, elem, stack.push(elem, i, null, null), fullUrl, id, repeats, propName, title + "." + parent);
            ++i;
        }
    }

    public void validateDocumentReference(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element composition, NodeStack stack, String fullUrl, String id, boolean repeats, String propName, String title) {
        if (repeats) {
            ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
            composition.getNamedChildren(propName, list);
            int i = 1;
            for (org.hl7.fhir.r5.elementmodel.Element elem : list) {
                this.validateBundleReference(errors, entries, elem, title + "." + propName, stack.push(elem, i, null, null), fullUrl, "Composition", id);
                ++i;
            }
        } else {
            org.hl7.fhir.r5.elementmodel.Element elem = composition.getNamedChild(propName);
            if (elem != null) {
                this.validateBundleReference(errors, entries, elem, title + "." + propName, stack.push(elem, -1, null, null), fullUrl, "Composition", id);
            }
        }
    }

    private void validateElement(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, StructureDefinition cprofile, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext, String extensionUrl) throws FHIRException {
        List<ElementDefinition> childDefinitions;
        String id = element.getChildValue("id");
        if (!Utilities.noString(id)) {
            if (stack.getIds().containsKey(id) && stack.getIds().get(id) != element) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), false, "DUPLICATE_ID", id);
            }
            if (!stack.isResetPoint()) {
                stack.getIds().put(id, element);
            }
        }
        if (definition.getPath().equals("StructureDefinition.snapshot")) {
            stack.resetIds();
        }
        this.checkInvariants(hostContext, errors, profile, definition, resource, element, stack, false);
        if (definition.getFixed() != null) {
            this.checkFixedValue(errors, stack.getLiteralPath(), element, definition.getFixed(), profile.getUrl(), definition.getSliceName(), null);
        }
        if ((childDefinitions = this.profileUtilities.getChildMap(profile, definition)).isEmpty()) {
            if (actualType == null) {
                return;
            }
            childDefinitions = this.getActualTypeChildren(hostContext, element, actualType);
        } else if (definition.getType().size() > 1) {
            if (actualType == null) {
                return;
            }
            List<ElementDefinition> typeChildDefinitions = this.getActualTypeChildren(hostContext, element, actualType);
            this.mergeChildLists(childDefinitions, typeChildDefinitions, definition.getPath(), actualType);
        }
        List<ElementInfo> children = this.listChildren(element, stack);
        List<String> problematicPaths = this.assignChildren(hostContext, errors, profile, resource, stack, childDefinitions, children);
        this.checkCardinalities(errors, profile, element, stack, childDefinitions, children, problematicPaths);
        for (ElementInfo ei : children) {
            this.checkChild(hostContext, errors, profile, definition, resource, element, actualType, stack, inCodeableConcept, checkDisplayInContext, ei, extensionUrl);
        }
    }

    private void mergeChildLists(List<ElementDefinition> master, List<ElementDefinition> additional, String masterPath, String typePath) {
        for (ElementDefinition ed : additional) {
            boolean inMaster = false;
            for (ElementDefinition t : master) {
                String tp = masterPath + ed.getPath().substring(typePath.length());
                if (!t.getPath().equals(tp)) continue;
                inMaster = true;
            }
            if (inMaster) continue;
            master.add(ed);
        }
    }

    public List<ElementDefinition> getActualTypeChildren(ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element, String actualType) {
        StructureDefinition dt = null;
        dt = this.isAbsolute(actualType) ? this.context.fetchResource(StructureDefinition.class, actualType) : this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + actualType);
        if (dt == null) {
            throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_actual_type_", actualType));
        }
        this.trackUsage(dt, hostContext, element);
        List<ElementDefinition> childDefinitions = this.profileUtilities.getChildMap(dt, dt.getSnapshot().getElement().get(0));
        return childDefinitions;
    }

    public void checkChild(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext, ElementInfo ei, String extensionUrl) throws FHIRException, DefinitionException {
        ArrayList<String> profiles = new ArrayList<String>();
        if (ei.definition != null) {
            String prefix;
            String type = null;
            ElementDefinition typeDefn = null;
            this.checkMustSupport(profile, ei);
            if (!(ei.definition.getType().size() != 1 || "*".equals(ei.definition.getType().get(0).getWorkingCode()) || "Element".equals(ei.definition.getType().get(0).getWorkingCode()) || "BackboneElement".equals(ei.definition.getType().get(0).getWorkingCode()))) {
                type = ei.definition.getType().get(0).getWorkingCode();
                if (ei.definition.getType().get(0).hasProfile()) {
                    for (CanonicalType canonicalType : ei.definition.getType().get(0).getProfile()) {
                        profiles.add((String)canonicalType.getValue());
                    }
                }
            } else if (ei.definition.getType().size() == 1 && "*".equals(ei.definition.getType().get(0).getWorkingCode())) {
                prefix = this.tail(ei.definition.getPath());
                assert (prefix.endsWith("[x]"));
                type = ei.getName().substring(prefix.length() - 3);
                if (this.isPrimitiveType(type)) {
                    type = Utilities.uncapitalize(type);
                }
                if (ei.definition.getType().get(0).hasProfile()) {
                    for (CanonicalType p : ei.definition.getType().get(0).getProfile()) {
                        profiles.add((String)p.getValue());
                    }
                }
            } else if (ei.definition.getType().size() > 1) {
                prefix = this.tail(ei.definition.getPath());
                assert (this.typesAreAllReference(ei.definition.getType()) || ei.definition.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR) || prefix.endsWith("[x]")) : prefix;
                if (ei.definition.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
                    type = ei.getElement().getType();
                } else {
                    prefix = prefix.substring(0, prefix.length() - 3);
                    for (ElementDefinition.TypeRefComponent t : ei.definition.getType()) {
                        if (!(prefix + Utilities.capitalize(t.getWorkingCode())).equals(ei.getName())) continue;
                        type = t.getWorkingCode();
                        if (!t.hasProfile() || type.equals("Reference")) continue;
                        profiles.add((String)t.getProfile().get(0).getValue());
                    }
                }
                if (type == null) {
                    ElementDefinition.TypeRefComponent typeRefComponent = ei.definition.getType().get(0);
                    if (typeRefComponent.getWorkingCode().equals("Reference")) {
                        type = "Reference";
                    } else {
                        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), false, "Validation_VAL_Profile_NoType", ei.getName(), this.describeTypes(ei.definition.getType()));
                    }
                }
            } else if (ei.definition.getContentReference() != null) {
                typeDefn = this.resolveNameReference(profile.getSnapshot(), ei.definition.getContentReference());
            } else if (ei.definition.getType().size() == 1 && ("Element".equals(ei.definition.getType().get(0).getWorkingCode()) || "BackboneElement".equals(ei.definition.getType().get(0).getWorkingCode())) && ei.definition.getType().get(0).hasProfile()) {
                CanonicalType pu = ei.definition.getType().get(0).getProfile().get(0);
                if (pu.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element")) {
                    profiles.add((String)pu.getValue() + "#" + pu.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element"));
                } else {
                    profiles.add((String)pu.getValue());
                }
            }
            if (type != null && type.startsWith("@")) {
                ei.definition = this.findElement(profile, type.substring(1));
                type = null;
            }
            NodeStack localStack = stack.push(ei.getElement(), ei.count, ei.definition, type == null ? typeDefn : this.resolveType(type, ei.definition.getType()));
            if (this.debug) {
                System.out.println("  check " + localStack.getLiteralPath() + " against " + ei.getDefinition().getId() + " in profile " + profile.getUrl());
            }
            String string = localStack.getLiteralPath();
            String eiPath = ei.getPath();
            assert (eiPath.equals(string)) : "ei.path: " + ei.getPath() + "  -  localStack.getLiteralPath: " + string;
            boolean thisIsCodeableConcept = false;
            String thisExtension = null;
            boolean checkDisplay = true;
            this.checkInvariants(hostContext, errors, profile, ei.definition, resource, ei.getElement(), localStack, true);
            ei.getElement().markValidation(profile, ei.definition);
            boolean elementValidated = false;
            if (type != null) {
                StructureDefinition defn;
                if (this.isPrimitiveType(type)) {
                    this.checkPrimitive(hostContext, errors, ei.getPath(), type, ei.definition, ei.getElement(), profile, stack);
                } else {
                    if (ei.definition.hasFixed()) {
                        this.checkFixedValue(errors, ei.getPath(), ei.getElement(), ei.definition.getFixed(), profile.getUrl(), ei.definition.getSliceName(), null);
                    }
                    if (ei.definition.hasPattern()) {
                        this.checkFixedValue(errors, ei.getPath(), ei.getElement(), ei.definition.getPattern(), profile.getUrl(), ei.definition.getSliceName(), null, true);
                    }
                }
                if (type.equals("Identifier")) {
                    this.checkIdentifier(errors, ei.getPath(), ei.getElement(), ei.definition);
                } else if (type.equals("Coding")) {
                    this.checkCoding(errors, ei.getPath(), ei.getElement(), profile, ei.definition, inCodeableConcept, checkDisplayInContext, stack);
                } else if (type.equals("CodeableConcept")) {
                    checkDisplay = this.checkCodeableConcept(errors, ei.getPath(), ei.getElement(), profile, ei.definition, stack);
                    thisIsCodeableConcept = true;
                } else if (type.equals("Reference")) {
                    this.checkReference(hostContext, errors, ei.getPath(), ei.getElement(), profile, ei.definition, actualType, localStack);
                } else if (type.equals("Extension")) {
                    org.hl7.fhir.r5.elementmodel.Element eurl = ei.getElement().getNamedChild("url");
                    if (this.rule(errors, ValidationMessage.IssueType.INVALID, ei.getPath(), eurl != null, "Extension_EXT_Url_NotFound")) {
                        String url;
                        thisExtension = url = eurl.primitiveValue();
                        if (this.rule(errors, ValidationMessage.IssueType.INVALID, ei.getPath(), !Utilities.noString(url), "Extension_EXT_Url_NotFound") && this.rule(errors, ValidationMessage.IssueType.INVALID, ei.getPath(), extensionUrl != null || Utilities.isAbsoluteUrl(url), "Extension_EXT_URL_Absolute")) {
                            this.checkExtension(hostContext, errors, ei.getPath(), resource, element, ei.getElement(), ei.definition, profile, localStack, stack, extensionUrl);
                        }
                    }
                } else if (type.equals("Resource")) {
                    this.validateContains(hostContext, errors, ei.getPath(), ei.definition, definition, resource, ei.getElement(), localStack, this.idStatusForEntry(element, ei));
                    elementValidated = true;
                } else if (Utilities.isAbsoluteUrl(type) && (defn = this.context.fetchTypeDefinition(type)) != null && this.hasMapping("http://hl7.org/fhir/terminology-pattern", defn, defn.getSnapshot().getElementFirstRep())) {
                    List<String> txtype = this.getMapping("http://hl7.org/fhir/terminology-pattern", defn, defn.getSnapshot().getElementFirstRep());
                    if (txtype.contains("CodeableConcept")) {
                        this.checkTerminologyCodeableConcept(errors, ei.getPath(), ei.getElement(), profile, ei.definition, stack, defn);
                        thisIsCodeableConcept = true;
                    } else if (txtype.contains("Coding")) {
                        this.checkTerminologyCoding(errors, ei.getPath(), ei.getElement(), profile, ei.definition, inCodeableConcept, checkDisplayInContext, stack, defn);
                    }
                }
            } else if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), ei.definition != null, "Validation_VAL_Content_Unknown", ei.getName())) {
                this.validateElement(hostContext, errors, profile, ei.definition, null, null, resource, ei.getElement(), type, localStack, false, true, null);
            }
            StructureDefinition p = null;
            String tail = null;
            if (profiles.isEmpty()) {
                if (type != null) {
                    p = this.getProfileForType(type, ei.definition.getType());
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), p != null, "Validation_VAL_NoType", type);
                }
            } else if (profiles.size() == 1) {
                String url = (String)profiles.get(0);
                if (url.contains("#")) {
                    tail = url.substring(url.indexOf("#") + 1);
                    url = url.substring(0, url.indexOf("#"));
                }
                p = this.context.fetchResource(StructureDefinition.class, url);
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), p != null, "Validation_VAL_Unknown_Profile", profiles.get(0));
            } else {
                elementValidated = true;
                HashMap<String, ArrayList<ValidationMessage>> goodProfiles = new HashMap<String, ArrayList<ValidationMessage>>();
                HashMap<String, ArrayList<ValidationMessage>> badProfiles = new HashMap<String, ArrayList<ValidationMessage>>();
                Iterator<Object> iterator = profiles.iterator();
                while (iterator.hasNext()) {
                    String typeProfile;
                    String url = typeProfile = (String)iterator.next();
                    tail = null;
                    if (url.contains("#")) {
                        tail = url.substring(url.indexOf("#") + 1);
                        url = url.substring(0, url.indexOf("#"));
                    }
                    p = this.context.fetchResource(StructureDefinition.class, typeProfile);
                    if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), p != null, "Validation_VAL_Unknown_Profile", typeProfile)) continue;
                    ArrayList<ValidationMessage> profileErrors = new ArrayList<ValidationMessage>();
                    this.validateElement(hostContext, profileErrors, p, this.getElementByTail(p, tail), profile, ei.definition, resource, ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension);
                    if (this.hasErrors(profileErrors)) {
                        badProfiles.put(typeProfile, profileErrors);
                        continue;
                    }
                    goodProfiles.put(typeProfile, profileErrors);
                }
                if (goodProfiles.size() == 1) {
                    errors.addAll((Collection)goodProfiles.values().iterator().next());
                } else if (goodProfiles.size() == 0) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), false, "Validation_VAL_Profile_NoMatch", StringUtils.join("; ", profiles));
                    for (String m3 : badProfiles.keySet()) {
                        p = this.context.fetchResource(StructureDefinition.class, m3);
                        for (ValidationMessage message : (List)badProfiles.get(m3)) {
                            message.setMessage(message.getMessage() + " (validating against " + p.getUrl() + (p.hasVersion() ? "|" + p.getVersion() : "") + " [" + p.getName() + "])");
                            errors.add(message);
                        }
                    }
                } else {
                    this.warning(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), false, "Validation_VAL_Profile_MultipleMatches", StringUtils.join("; ", goodProfiles.keySet()));
                    for (String m3 : goodProfiles.keySet()) {
                        p = this.context.fetchResource(StructureDefinition.class, m3);
                        for (ValidationMessage message : (List)goodProfiles.get(m3)) {
                            message.setMessage(message.getMessage() + " (validating against " + p.getUrl() + (p.hasVersion() ? "|" + p.getVersion() : "") + " [" + p.getName() + "])");
                            errors.add(message);
                        }
                    }
                }
            }
            if (p != null) {
                String nextPath;
                int index;
                this.trackUsage(p, hostContext, element);
                if (!elementValidated) {
                    if (ei.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY || ei.getElement().getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME || ei.getElement().getSpecial() == Element.SpecialElement.PARAMETER) {
                        this.validateElement(hostContext, errors, p, this.getElementByTail(p, tail), profile, ei.definition, ei.getElement(), ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension);
                    } else {
                        this.validateElement(hostContext, errors, p, this.getElementByTail(p, tail), profile, ei.definition, resource, ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension);
                    }
                }
                if ((index = profile.getSnapshot().getElement().indexOf(ei.definition)) < profile.getSnapshot().getElement().size() - 1 && !(nextPath = profile.getSnapshot().getElement().get(index + 1).getPath()).equals(ei.definition.getPath()) && nextPath.startsWith(ei.definition.getPath())) {
                    this.validateElement(hostContext, errors, profile, ei.definition, null, null, resource, ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension);
                }
            }
        }
    }

    private void trackUsage(StructureDefinition profile, ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element) {
        if (this.tracker != null) {
            this.tracker.recordProfileUsage(profile, hostContext.getAppContext(), element);
        }
    }

    private boolean hasMapping(String url, StructureDefinition defn, ElementDefinition elem) {
        String id = null;
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : defn.getMapping()) {
            if (!url.equals(structureDefinitionMappingComponent.getUri())) continue;
            id = structureDefinitionMappingComponent.getIdentity();
            break;
        }
        if (id != null) {
            for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : elem.getMapping()) {
                if (!id.equals(elementDefinitionMappingComponent.getIdentity())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getMapping(String url, StructureDefinition defn, ElementDefinition elem) {
        ArrayList<String> res = new ArrayList<String>();
        String id = null;
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : defn.getMapping()) {
            if (!url.equals(structureDefinitionMappingComponent.getUri())) continue;
            id = structureDefinitionMappingComponent.getIdentity();
            break;
        }
        if (id != null) {
            for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : elem.getMapping()) {
                if (!id.equals(elementDefinitionMappingComponent.getIdentity())) continue;
                res.add(elementDefinitionMappingComponent.getMap());
            }
        }
        return res;
    }

    public void checkMustSupport(StructureDefinition profile, ElementInfo ei) {
        String elementSupported;
        String usesMustSupport = profile.getUserString("usesMustSupport");
        if (usesMustSupport == null) {
            usesMustSupport = "N";
            for (ElementDefinition pe : profile.getSnapshot().getElement()) {
                if (!pe.getMustSupport()) continue;
                usesMustSupport = "Y";
                break;
            }
            profile.setUserData("usesMustSupport", usesMustSupport);
        }
        if (usesMustSupport.equals("Y") && ((elementSupported = ei.getElement().getUserString("elementSupported")) == null || ei.definition.getMustSupport()) && ei.definition.getMustSupport()) {
            ei.getElement().setUserData("elementSupported", "Y");
        }
    }

    public void checkCardinalities(List<ValidationMessage> errors, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, List<ElementDefinition> childDefinitions, List<ElementInfo> children, List<String> problematicPaths) throws DefinitionException {
        for (ElementDefinition ed : childDefinitions) {
            if (!ed.getRepresentation().isEmpty()) continue;
            int count = 0;
            List<ElementDefinition> slices = null;
            if (ed.hasSlicing()) {
                slices = this.profileUtilities.getSliceList(profile, ed);
            }
            block1: for (ElementInfo ei : children) {
                if (ei.definition == ed) {
                    ++count;
                    continue;
                }
                if (slices == null) continue;
                for (ElementDefinition sed : slices) {
                    if (ei.definition != sed) continue;
                    ++count;
                    continue block1;
                }
            }
            String location = "Profile " + profile.getUrl() + ", Element '" + stack.getLiteralPath() + "." + this.tail(ed.getPath()) + (ed.hasSliceName() ? "[" + ed.getSliceName() + (ed.hasLabel() ? " (" + ed.getLabel() + ")" : "") + "]" : "") + "'";
            if (ed.getMin() > 0) {
                if (problematicPaths.contains(ed.getPath())) {
                    this.hint(errors, ValidationMessage.IssueType.NOTSUPPORTED, element.line(), element.col(), stack.getLiteralPath(), count >= ed.getMin(), "Validation_VAL_Profile_NoCheckMin", location, Integer.toString(ed.getMin()));
                } else {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), count >= ed.getMin(), "Validation_VAL_Profile_Minimum", location, Integer.toString(ed.getMin()), Integer.toString(count));
                }
            }
            if (!ed.hasMax() || ed.getMax().equals("*")) continue;
            if (problematicPaths.contains(ed.getPath())) {
                this.hint(errors, ValidationMessage.IssueType.NOTSUPPORTED, element.line(), element.col(), stack.getLiteralPath(), count <= Integer.parseInt(ed.getMax()), "Validation_VAL_Profile_NoCheckMax", location, ed.getMax());
                continue;
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), count <= Integer.parseInt(ed.getMax()), "Validation_VAL_Profile_Maximum", location, ed.getMax(), Integer.toString(count));
        }
    }

    public List<String> assignChildren(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack, List<ElementDefinition> childDefinitions, List<ElementInfo> children) throws DefinitionException {
        ElementDefinition slicer = null;
        boolean unsupportedSlicing = false;
        ArrayList<String> problematicPaths = new ArrayList<String>();
        String slicingPath = null;
        int sliceOffset = 0;
        for (int i = 0; i < childDefinitions.size(); ++i) {
            ElementDefinition ed = childDefinitions.get(i);
            boolean childUnsupportedSlicing = false;
            boolean process = true;
            if (ed.hasSlicing() && !ed.getSlicing().getOrdered()) {
                slicingPath = ed.getPath();
            } else if (!(slicingPath != null && ed.getPath().equals(slicingPath) || slicingPath == null || ed.getPath().startsWith(slicingPath))) {
                slicingPath = null;
            }
            if (ed.hasSlicing()) {
                if (slicer != null && slicer.getPath().equals(ed.getPath())) {
                    Object errorContext = "profile " + profile.getUrl();
                    if (!resource.getChildValue("id").isEmpty()) {
                        errorContext = (String)errorContext + "; instance " + resource.getChildValue("id");
                    }
                    throw new DefinitionException(this.context.formatMessage("Slice_encountered_midway_through_set_path___id___", slicer.getPath(), slicer.getId(), errorContext));
                }
                slicer = ed;
                process = false;
                sliceOffset = i;
            } else if (slicer != null && !slicer.getPath().equals(ed.getPath())) {
                slicer = null;
            }
            for (ElementInfo ei : children) {
                if (ei.sliceInfo == null) {
                    ei.sliceInfo = new ArrayList<ValidationMessage>();
                }
                unsupportedSlicing = this.matchSlice(hostContext, errors, ei.sliceInfo, profile, stack, slicer, unsupportedSlicing, problematicPaths, sliceOffset, i, ed, childUnsupportedSlicing, ei);
            }
        }
        int last = -1;
        int lastSlice = -1;
        for (ElementInfo ei : children) {
            String sliceInfo = "";
            if (slicer != null) {
                sliceInfo = " (slice: " + slicer.getPath() + ")";
            }
            if (!unsupportedSlicing) {
                if (ei.additionalSlice && ei.definition != null) {
                    if (ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.OPEN) || ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.OPENATEND)) {
                        this.slicingHint(errors, ValidationMessage.IssueType.INFORMATIONAL, ei.line(), ei.col(), ei.getPath(), false, this.context.formatMessage("This_element_does_not_match_any_known_slice_", profile == null ? "" : " defined in the profile " + profile.getUrl()), this.context.formatMessage("This_element_does_not_match_any_known_slice_", profile == null ? "" : "defined_in_the_profile" + profile.getUrl()) + this.errorSummaryForSlicingAsHtml(ei.sliceInfo));
                    } else if (ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.CLOSED)) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), false, "Validation_VAL_Profile_NotSlice", profile == null ? "" : " defined in the profile " + profile.getUrl(), this.errorSummaryForSlicing(ei.sliceInfo));
                    }
                } else if (!profile.getAbstract()) {
                    this.rule(errors, ValidationMessage.IssueType.NOTSUPPORTED, ei.line(), ei.col(), ei.getPath(), ei.definition != null, "Validation_VAL_Profile_NotAllowed", profile.getUrl());
                }
            }
            boolean isXmlAttr = false;
            if (ei.definition != null) {
                for (Enumeration<ElementDefinition.PropertyRepresentation> r : ei.definition.getRepresentation()) {
                    if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLATTR) continue;
                    isXmlAttr = true;
                    break;
                }
            }
            if (!ToolingExtensions.readBoolExtension(profile, "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order")) {
                boolean ok = ei.definition == null || ei.index >= last || isXmlAttr;
                this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), ok, "Validation_VAL_Profile_OutOfOrder", profile.getUrl(), ei.getName());
            }
            if (ei.slice != null && ei.index == last && ei.slice.getSlicing().getOrdered()) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), ei.definition == null || ei.sliceindex >= lastSlice || isXmlAttr, "Validation_VAL_Profile_SliceOrder", profile.getUrl(), ei.getName());
            }
            if (ei.definition == null || !isXmlAttr) {
                last = ei.index;
            }
            if (ei.slice != null) {
                lastSlice = ei.sliceindex;
                continue;
            }
            lastSlice = -1;
        }
        return problematicPaths;
    }

    public List<ElementInfo> listChildren(org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        ArrayList<ElementInfo> children = new ArrayList<ElementInfo>();
        ChildIterator iter = new ChildIterator(this, stack.getLiteralPath(), element);
        while (iter.next()) {
            children.add(new ElementInfo(iter.name(), iter.element(), iter.path(), iter.count()));
        }
        return children;
    }

    public void checkInvariants(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean onlyNonInherited) throws FHIRException {
        this.checkInvariants(hostContext, errors, stack.getLiteralPath(), profile, definition, null, null, resource, element, onlyNonInherited);
    }

    public boolean matchSlice(ValidatorHostContext hostContext, List<ValidationMessage> errors, List<ValidationMessage> sliceInfo, StructureDefinition profile, NodeStack stack, ElementDefinition slicer, boolean unsupportedSlicing, List<String> problematicPaths, int sliceOffset, int i, ElementDefinition ed, boolean childUnsupportedSlicing, ElementInfo ei) {
        boolean match = false;
        if (slicer == null || slicer == ed) {
            match = this.nameMatches(ei.getName(), this.tail(ed.getPath()));
        } else if (this.nameMatches(ei.getName(), this.tail(ed.getPath()))) {
            try {
                match = this.sliceMatches(hostContext, ei.getElement(), ei.getPath(), slicer, ed, profile, errors, sliceInfo, stack);
                if (match) {
                    ei.slice = slicer;
                    ei.additionalSlice = false;
                } else if (ei.slice == null) {
                    ei.additionalSlice = true;
                }
            }
            catch (FHIRException e) {
                this.rule(errors, ValidationMessage.IssueType.PROCESSING, ei.line(), ei.col(), ei.getPath(), false, e.getMessage(), new Object[0]);
                unsupportedSlicing = true;
                childUnsupportedSlicing = true;
            }
        }
        if (match) {
            boolean isOk = ei.definition == null || ei.definition == slicer || ei.definition.getPath().endsWith("[x]") && ed.getPath().startsWith(ei.definition.getPath().replace("[x]", ""));
            Object[] objectArray = new Object[3];
            objectArray[0] = profile.getUrl();
            objectArray[1] = ei.definition == null || !ei.definition.hasSliceName() ? "" : ei.definition.getSliceName();
            Object object = objectArray[2] = ed.hasSliceName() ? ed.getSliceName() : "";
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), isOk, "Validation_VAL_Profile_MatchMultiple", objectArray)) {
                ei.definition = ed;
                if (ei.slice == null) {
                    ei.index = i;
                } else {
                    ei.index = sliceOffset;
                    ei.sliceindex = i - (sliceOffset + 1);
                }
            }
        } else if (childUnsupportedSlicing) {
            problematicPaths.add(ed.getPath());
        }
        return unsupportedSlicing;
    }

    private ElementDefinition getElementByTail(StructureDefinition p, String tail) throws DefinitionException {
        if (tail == null) {
            return p.getSnapshot().getElement().get(0);
        }
        for (ElementDefinition t : p.getSnapshot().getElement()) {
            if (!tail.equals(t.getId())) continue;
            return t;
        }
        throw new DefinitionException(this.context.formatMessage("Unable_to_find_element_with_id_", tail));
    }

    private IResourceValidator.IdStatus idStatusForEntry(org.hl7.fhir.r5.elementmodel.Element ep, ElementInfo ei) {
        if (this.isBundleEntry(ei.getPath())) {
            org.hl7.fhir.r5.elementmodel.Element req = ep.getNamedChild("request");
            org.hl7.fhir.r5.elementmodel.Element resp = ep.getNamedChild("response");
            org.hl7.fhir.r5.elementmodel.Element fullUrl = ep.getNamedChild("fullUrl");
            org.hl7.fhir.r5.elementmodel.Element method = null;
            org.hl7.fhir.r5.elementmodel.Element url = null;
            if (req != null) {
                method = req.getNamedChild("method");
                url = req.getNamedChild("url");
            }
            if (resp != null) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (method == null) {
                if (fullUrl == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                if (fullUrl.primitiveValue().startsWith("urn:uuid:") || fullUrl.primitiveValue().startsWith("urn:oid:")) {
                    return IResourceValidator.IdStatus.OPTIONAL;
                }
                return IResourceValidator.IdStatus.REQUIRED;
            }
            String s2 = method.primitiveValue();
            if (s2.equals("PUT")) {
                if (url == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (s2.equals("POST")) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        if (this.isParametersEntry(ei.getPath()) || this.isBundleOutcome(ei.getPath())) {
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        return IResourceValidator.IdStatus.REQUIRED;
    }

    private void checkInvariants(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, StructureDefinition profile, ElementDefinition ed, String typename, String typeProfile, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, boolean onlyNonInherited) throws FHIRException, FHIRException {
        if (this.noInvariantChecks) {
            return;
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
            HashSet<String> invList;
            if (!inv.hasExpression() || onlyNonInherited && inv.hasSource() && (this.isInheritedProfile(profile, inv.getSource()) || this.isInheritedProfile(ed.getType(), inv.getSource()))) continue;
            HashSet<String> hashSet = invList = this.executionId.equals(element.getUserString(EXECUTION_ID)) ? (HashSet<String>)element.getUserData(EXECUTED_CONSTRAINT_LIST) : null;
            if (invList == null) {
                invList = new HashSet<String>();
                element.setUserData(EXECUTED_CONSTRAINT_LIST, invList);
                element.setUserData(EXECUTION_ID, this.executionId);
            }
            if (invList.contains(inv.getKey())) continue;
            invList.add(inv.getKey());
            this.checkInvariant(hostContext, errors, path, profile, resource, element, inv);
        }
    }

    private boolean isInheritedProfile(List<ElementDefinition.TypeRefComponent> types, String source) {
        for (ElementDefinition.TypeRefComponent type : types) {
            for (CanonicalType c : type.getProfile()) {
                StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, c.asStringValue());
                if (sd == null) continue;
                if (sd.getUrl().equals(source)) {
                    return true;
                }
                if (!this.isInheritedProfile(sd, source)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInheritedProfile(StructureDefinition profile, String source) {
        if (source.equals(profile.getUrl())) {
            return false;
        }
        while (profile != null) {
            if ((profile = this.context.fetchResource(StructureDefinition.class, profile.getBaseDefinition())) == null || !source.equals(profile.getUrl())) continue;
            return true;
        }
        return false;
    }

    public void checkInvariant(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition.ElementDefinitionConstraintComponent inv) throws FHIRException {
        String msg;
        boolean ok;
        ExpressionNode n;
        if (this.debug) {
            System.out.println("inv " + inv.getKey() + " on " + path + " in " + resource.fhirType() + " {{ " + inv.getExpression() + " }}");
        }
        if ((n = (ExpressionNode)inv.getUserData("validator.expression.cache")) == null) {
            long t = System.nanoTime();
            try {
                n = this.fpe.parse(this.fixExpr(inv.getExpression()));
            }
            catch (FHIRLexer.FHIRLexerException e) {
                throw new FHIRException(this.context.formatMessage("Problem_processing_expression__in_profile__path__", inv.getExpression(), profile.getUrl(), path, e.getMessage()));
            }
            this.timeTracker.fpe(t, System.nanoTime());
            inv.setUserData("validator.expression.cache", n);
        }
        try {
            long t = System.nanoTime();
            ok = this.fpe.evaluateToBoolean((Object)hostContext, resource, hostContext.getRootResource(), (Base)element, n);
            this.timeTracker.fpe(t, System.nanoTime());
            msg = this.fpe.forLog();
        }
        catch (Exception ex) {
            ok = false;
            msg = ex.getMessage();
        }
        if (!ok) {
            if (!Utilities.noString(msg)) {
                msg = " (" + msg + ")";
            }
            if (this.debug) {
                System.out.println("  failed! " + msg);
            }
            if (inv.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice") && ToolingExtensions.readBooleanExtension(inv, "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice").booleanValue()) {
                if (this.bpWarnings == IResourceValidator.BestPracticeWarningLevel.Hint) {
                    this.hint(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]");
                } else if (this.bpWarnings == IResourceValidator.BestPracticeWarningLevel.Warning) {
                    this.warning(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]", new Object[0]);
                } else if (this.bpWarnings == IResourceValidator.BestPracticeWarningLevel.Error) {
                    this.rule(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]", new Object[0]);
                }
            } else if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.ERROR) {
                this.rule(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]", new Object[0]);
            } else if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.WARNING) {
                this.warning(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.line(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]", new Object[0]);
            }
        }
    }

    private void validateMessage(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element messageHeader, NodeStack stack, String fullUrl, String id) {
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, messageHeader.line(), messageHeader.col(), stack.getLiteralPath(), messageHeader.getType().equals("MessageHeader"), "Validation_BUNDLE_Message", new Object[0])) {
            List<org.hl7.fhir.r5.elementmodel.Element> elements = messageHeader.getChildren("focus");
            for (org.hl7.fhir.r5.elementmodel.Element elem : elements) {
                this.validateBundleReference(errors, entries, elem, "MessageHeader Data", stack.push(elem, -1, null, null), fullUrl, "MessageHeader", id);
            }
        }
    }

    private void validateObservation(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("subject") != null, "All_observations_should_have_a_subject");
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> performers = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        element.getNamedChildren("performer", performers);
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), performers.size() > 0, "All_observations_should_have_a_performer");
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("effectiveDateTime") != null || element.getNamedChild("effectivePeriod") != null, "All_observations_should_have_an_effectiveDateTime_or_an_effectivePeriod");
    }

    private void validateResource(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, IResourceValidator.IdStatus idstatus, NodeStack stack) throws FHIRException {
        NodeStack first;
        String type;
        assert (stack != null);
        assert (resource != null);
        boolean ok = true;
        String resourceName = element.getType();
        if (defn == null) {
            long t = System.nanoTime();
            defn = element.getProperty().getStructure();
            if (defn == null) {
                defn = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
            }
            this.timeTracker.sd(t, System.nanoTime());
            ok = this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.addToLiteralPath(resourceName), defn != null, "Validation_VAL_Profile_NoDefinition", resourceName);
        }
        String string = type = defn.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL ? defn.getId() : defn.getType();
        if (!type.equals(resourceName) && resourceName.equals("Bundle") && (first = this.getFirstEntry(stack)) != null && first.getElement().getType().equals(type)) {
            element = first.getElement();
            stack = first;
            resourceName = element.getType();
            idstatus = IResourceValidator.IdStatus.OPTIONAL;
        }
        if (ok = this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, stack.getLiteralPath(), type.equals(resourceName), "Validation_VAL_Profile_WrongType", type, resourceName)) {
            if (idstatus == IResourceValidator.IdStatus.REQUIRED && element.getNamedChild("id") == null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource_RES_ID_Missing", new Object[0]);
            } else if (idstatus == IResourceValidator.IdStatus.PROHIBITED && element.getNamedChild("id") != null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource_RES_ID_Prohibited", new Object[0]);
            }
            this.start(hostContext, errors, element, element, defn, stack);
        }
    }

    private NodeStack getFirstEntry(NodeStack bundle) {
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        bundle.getElement().getNamedChildren("entry", list);
        if (list.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.elementmodel.Element resource = ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getNamedChild("resource");
        if (resource == null) {
            return null;
        }
        NodeStack entry = bundle.push((org.hl7.fhir.r5.elementmodel.Element)list.get(0), 0, ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getProperty().getDefinition(), ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getProperty().getDefinition());
        return entry.push(resource, -1, resource.getProperty().getDefinition(), this.context.fetchTypeDefinition(resource.fhirType()).getSnapshot().getElementFirstRep());
    }

    private void validateSections(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element focus, NodeStack stack, String fullUrl, String id) {
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> sections = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        focus.getNamedChildren("section", sections);
        int i = 1;
        for (org.hl7.fhir.r5.elementmodel.Element section : sections) {
            NodeStack localStack = stack.push(section, i, null, null);
            this.validateDocumentReference(errors, entries, section, stack, fullUrl, id, false, "author", "Section");
            this.validateDocumentReference(errors, entries, section, stack, fullUrl, id, false, "focus", "Section");
            ArrayList<org.hl7.fhir.r5.elementmodel.Element> sectionEntries = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
            section.getNamedChildren("entry", sectionEntries);
            int j = 1;
            for (org.hl7.fhir.r5.elementmodel.Element sectionEntry : sectionEntries) {
                NodeStack localStack2 = localStack.push(sectionEntry, j, null, null);
                this.validateBundleReference(errors, entries, sectionEntry, "Section Entry", localStack2, fullUrl, "Composition", id);
                ++j;
            }
            this.validateSections(errors, entries, section, localStack, fullUrl, id);
            ++i;
        }
    }

    private boolean valueMatchesCriteria(org.hl7.fhir.r5.elementmodel.Element value, ElementDefinition criteria, StructureDefinition profile) throws FHIRException {
        if (criteria.hasFixed()) {
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            this.checkFixedValue(msgs, "{virtual}", value, criteria.getFixed(), profile.getUrl(), "value", null);
            return msgs.size() == 0;
        }
        if (criteria.hasBinding() && criteria.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && criteria.getBinding().hasValueSet()) {
            throw new FHIRException(this.context.formatMessage("Unable_to_resolve_slice_matching__slice_matching_by_value_set_not_done", new Object[0]));
        }
        throw new FHIRException(this.context.formatMessage("Unable_to_resolve_slice_matching__no_fixed_value_or_required_value_set", new Object[0]));
    }

    private boolean yearIsValid(String v) {
        if (v == null) {
            return false;
        }
        try {
            int i = Integer.parseInt(v.substring(0, Math.min(4, v.length())));
            return i >= 1800 && i <= this.thisYear() + 80;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int thisYear() {
        return Calendar.getInstance().get(1);
    }

    public String reportTimes() {
        String s2 = String.format("Times (ms): overall = %d, tx = %d, sd = %d, load = %d, fpe = %d", this.timeTracker.getOverall() / 1000000L, this.timeTracker.getTxTime() / 1000000L, this.timeTracker.getSdTime() / 1000000L, this.timeTracker.getLoadTime() / 1000000L, this.timeTracker.getFpeTime() / 1000000L);
        this.timeTracker.reset();
        return s2;
    }

    @Override
    public boolean isNoBindingMsgSuppressed() {
        return this.noBindingMsgSuppressed;
    }

    @Override
    public IResourceValidator setNoBindingMsgSuppressed(boolean noBindingMsgSuppressed) {
        this.noBindingMsgSuppressed = noBindingMsgSuppressed;
        return this;
    }

    @Override
    public boolean isNoTerminologyChecks() {
        return this.noTerminologyChecks;
    }

    @Override
    public IResourceValidator setNoTerminologyChecks(boolean noTerminologyChecks) {
        this.noTerminologyChecks = noTerminologyChecks;
        return this;
    }

    public void checkAllInvariants() {
        for (StructureDefinition sd : this.context.allStructures()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                    if (!inv.hasExpression()) continue;
                    try {
                        ExpressionNode n = (ExpressionNode)inv.getUserData("validator.expression.cache");
                        if (n == null) {
                            n = this.fpe.parse(this.fixExpr(inv.getExpression()));
                            inv.setUserData("validator.expression.cache", n);
                        }
                        this.fpe.check(null, sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE ? sd.getType() : "DomainResource", ed.getPath(), n);
                    }
                    catch (Exception e) {
                        System.out.println("Error processing structure [" + sd.getId() + "] path " + ed.getPath() + ":" + inv.getKey() + " ('" + inv.getExpression() + "'): " + e.getMessage());
                    }
                }
            }
        }
    }

    private String fixExpr(String expr) {
        if ("probability is decimal implies (probability as decimal) <= 100".equals(expr)) {
            return "probablility.empty() or ((probability is decimal) implies ((probability as decimal) <= 100))";
        }
        if ("enableWhen.count() > 2 implies enableBehavior.exists()".equals(expr)) {
            return "enableWhen.count() >= 2 implies enableBehavior.exists()";
        }
        if ("(component.empty() and hasMember.empty()) implies (dataAbsentReason or value)".equals(expr)) {
            return "(component.empty() and hasMember.empty()) implies (dataAbsentReason.exists() or value.exists())";
        }
        if ("isModifier implies isModifierReason.exists()".equals(expr)) {
            return "(isModifier.exists() and isModifier) implies isModifierReason.exists()";
        }
        if ("(%resource.kind = 'logical' or element.first().path.startsWith(%resource.type)) and (element.tail().not() or  element.tail().all(path.startsWith(%resource.differential.element.first().path.replaceMatches('\\\\..*','')&'.')))".equals(expr)) {
            return "(%resource.kind = 'logical' or element.first().path.startsWith(%resource.type)) and (element.tail().empty() or  element.tail().all(path.startsWith(%resource.differential.element.first().path.replaceMatches('\\\\..*','')&'.')))";
        }
        if ("differential.element.all(id) and differential.element.id.trace('ids').isDistinct()".equals(expr)) {
            return "differential.element.all(id.exists()) and differential.element.id.trace('ids').isDistinct()";
        }
        if ("snapshot.element.all(id) and snapshot.element.id.trace('ids').isDistinct()".equals(expr)) {
            return "snapshot.element.all(id.exists()) and snapshot.element.id.trace('ids').isDistinct()";
        }
        if ("(code or value.empty()) and (system.empty() or system = 'urn:iso:std:iso:4217')".equals(expr)) {
            return "(code.exists() or value.empty()) and (system.empty() or system = 'urn:iso:std:iso:4217')";
        }
        if ("value.empty() or code!=component.code".equals(expr)) {
            return "value.empty() or (code in component.code).not()";
        }
        if ("(code or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)".equals(expr)) {
            return "(code.exists() or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)";
        }
        if ("element.all(definition and min and max)".equals(expr)) {
            return "element.all(definition.exists() and min.exists() and max.exists())";
        }
        if ("telecom or endpoint".equals(expr)) {
            return "telecom.exists() or endpoint.exists()";
        }
        if ("(code or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)".equals(expr)) {
            return "(code.exists() or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)";
        }
        if ("searchType implies type = 'string'".equals(expr)) {
            return "searchType.exists() implies type = 'string'";
        }
        if ("abatement.empty() or (abatement as boolean).not()  or clinicalStatus='resolved' or clinicalStatus='remission' or clinicalStatus='inactive'".equals(expr)) {
            return "abatement.empty() or (abatement is boolean).not() or (abatement as boolean).not() or (clinicalStatus = 'resolved') or (clinicalStatus = 'remission') or (clinicalStatus = 'inactive')";
        }
        if ("(component.empty() and related.empty()) implies (dataAbsentReason or value)".equals(expr)) {
            return "(component.empty() and related.empty()) implies (dataAbsentReason.exists() or value.exists())";
        }
        if ("".equals(expr)) {
            return "";
        }
        return expr;
    }

    public FHIRPathEngine.IEvaluationContext getExternalHostServices() {
        return this.externalHostServices;
    }

    public String getValidationLanguage() {
        return this.validationLanguage;
    }

    public void setValidationLanguage(String validationLanguage) {
        this.validationLanguage = validationLanguage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private String tryParse(String ref) {
        String[] parts = ref.split("\\/");
        switch (parts.length) {
            case 1: {
                return null;
            }
            case 2: {
                return this.checkResourceType(parts[0]);
            }
        }
        if (parts[parts.length - 2].equals("_history")) {
            return this.checkResourceType(parts[parts.length - 4]);
        }
        return this.checkResourceType(parts[parts.length - 2]);
    }

    private boolean typesAreAllReference(List<ElementDefinition.TypeRefComponent> theType) {
        for (ElementDefinition.TypeRefComponent typeRefComponent : theType) {
            if (typeRefComponent.getCode().equals("Reference")) continue;
            return false;
        }
        return true;
    }

    private class ValidatorHostServices
    implements FHIRPathEngine.IEvaluationContext {
        private ValidatorHostServices() {
        }

        @Override
        public Base resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveConstant(c.getAppContext(), name, beforeContext);
            }
            return null;
        }

        @Override
        public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveConstantType(c.getAppContext(), name);
            }
            return null;
        }

        @Override
        public boolean log(String argument, List<Base> focus) {
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.log(argument, focus);
            }
            return false;
        }

        @Override
        public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicesresolveFunction_", functionName));
        }

        @Override
        public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicescheckFunction", new Object[0]));
        }

        @Override
        public List<Base> executeFunction(Object appContext, String functionName, List<List<Base>> parameters) {
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicesexecuteFunction", new Object[0]));
        }

        @Override
        public Base resolveReference(Object appContext, String url, Base refContext) throws FHIRException {
            org.hl7.fhir.r5.elementmodel.Element bnd;
            Base res;
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (refContext != null && refContext.hasUserData("validator.bundle.resolution")) {
                return (Base)refContext.getUserData("validator.bundle.resolution");
            }
            if (c.getAppContext() instanceof org.hl7.fhir.r5.elementmodel.Element && (res = this.resolveInBundle(url, bnd = (org.hl7.fhir.r5.elementmodel.Element)c.getAppContext())) != null) {
                return res;
            }
            Base res2 = this.resolveInBundle(url, c.getResource());
            if (res2 != null) {
                return res2;
            }
            res2 = this.resolveInBundle(url, c.getContainer());
            if (res2 != null) {
                return res2;
            }
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveReference(c.getAppContext(), url, refContext);
            }
            if (InstanceValidator.this.fetcher != null) {
                try {
                    return InstanceValidator.this.fetcher.fetch(c.getAppContext(), url);
                }
                catch (IOException e) {
                    throw new FHIRException(e);
                }
            }
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet__resolve__locally_2", url));
        }

        public Base resolveInBundle(String url, org.hl7.fhir.r5.elementmodel.Element bnd) {
            if (bnd == null) {
                return null;
            }
            if (bnd.fhirType().equals("Bundle")) {
                for (org.hl7.fhir.r5.elementmodel.Element be : bnd.getChildrenByName("entry")) {
                    org.hl7.fhir.r5.elementmodel.Element res = be.getNamedChild("resource");
                    if (res == null) continue;
                    String fullUrl = be.getChildValue("fullUrl");
                    String rt = res.fhirType();
                    String id = res.getChildValue("id");
                    if (url.equals(fullUrl)) {
                        return res;
                    }
                    if (!url.equals(rt + "/" + id)) continue;
                    return res;
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
            org.hl7.fhir.r5.elementmodel.Element e;
            ValidatorHostContext ctxt = (ValidatorHostContext)appContext;
            StructureDefinition sd = InstanceValidator.this.context.fetchResource(StructureDefinition.class, url);
            if (sd == null) {
                throw new FHIRException(InstanceValidator.this.context.formatMessage("Unable_to_resolve_", url));
            }
            InstanceValidator self = InstanceValidator.this;
            ArrayList valerrors = new ArrayList();
            if (item instanceof Resource) {
                try {
                    e = new ObjectConverter(InstanceValidator.this.context).convert((Resource)item);
                    self.validateResource(new ValidatorHostContext(ctxt.getAppContext(), e), valerrors, e, e, sd, IResourceValidator.IdStatus.OPTIONAL, new NodeStack(InstanceValidator.this.context, e, InstanceValidator.this.validationLanguage));
                }
                catch (IOException e1) {
                    throw new FHIRException(e1);
                }
            } else {
                if (!(item instanceof org.hl7.fhir.r5.elementmodel.Element)) throw new NotImplementedException(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicesconformsToProfile_when_item_is_not_an_element", new Object[0]));
                e = (org.hl7.fhir.r5.elementmodel.Element)item;
                if (!e.isResource()) throw new FHIRException(InstanceValidator.this.context.formatMessage("Not_supported_yet", new Object[0]));
                self.validateResource(new ValidatorHostContext(ctxt.getAppContext(), e), valerrors, e, e, sd, IResourceValidator.IdStatus.OPTIONAL, new NodeStack(InstanceValidator.this.context, e, InstanceValidator.this.validationLanguage));
            }
            boolean ok = true;
            ArrayList<ValidationMessage> record = new ArrayList<ValidationMessage>();
            for (ValidationMessage v : valerrors) {
                boolean bl = ok = ok && !v.getLevel().isError();
                if (!v.getLevel().isError() && !v.isSlicingHint()) continue;
                record.add(v);
            }
            if (ok || record.isEmpty()) return ok;
            ctxt.sliceNotes(url, record);
            return ok;
        }

        @Override
        public ValueSet resolveValueSet(Object appContext, String url) {
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (c.getProfile() != null && url.startsWith("#")) {
                for (Resource r : c.getProfile().getContained()) {
                    if (!r.getId().equals(url.substring(1))) continue;
                    if (r instanceof ValueSet) {
                        return (ValueSet)r;
                    }
                    throw new FHIRException(InstanceValidator.this.context.formatMessage("Reference__refers_to_a__not_a_ValueSet", url, r.fhirType()));
                }
                return null;
            }
            return InstanceValidator.this.context.fetchResource(ValueSet.class, url);
        }
    }
}

