/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;

public abstract class I18nBase {
    private Locale locale;
    private ResourceBundle i18Nmessages;

    public Locale getLocale() {
        if (Objects.nonNull(this.locale)) {
            return this.locale;
        }
        return Locale.US;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setValidationMessageLanguage(this.getLocale());
    }

    public String formatMessage(String theMessage, Object ... theMessageArguments) {
        String message = theMessage;
        if (Objects.nonNull(this.i18Nmessages) && this.i18Nmessages.containsKey(theMessage)) {
            message = Objects.nonNull(theMessageArguments) && theMessageArguments.length > 0 ? MessageFormat.format(this.i18Nmessages.getString(theMessage), theMessageArguments) : this.i18Nmessages.getString(theMessage);
        }
        return message;
    }

    public void setValidationMessageLanguage(Locale locale) {
        this.i18Nmessages = ResourceBundle.getBundle("Messages", locale);
    }
}

