/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.cache;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.cache.NpmPackage;
import org.hl7.fhir.utilities.cache.PackageClient;
import org.hl7.fhir.utilities.json.JSONUtil;

public class PackageCacheManager {
    private static final String PRIMARY_SERVER = "http://packages.fhir.org";
    private static final String SECONDARY_SERVER = "http://packages2.fhir.org/packages";
    public static final String PACKAGE_REGEX = "^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+$";
    public static final String PACKAGE_VERSION_REGEX = "^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+\\#[a-z0-9\\-\\_]+(\\.[a-z0-9\\-\\_]+)*$";
    private static final String CACHE_VERSION = "3";
    private String cacheFolder;
    private boolean progress = true;
    private List<NpmPackage> temporaryPackages = new ArrayList<NpmPackage>();
    private boolean buildLoaded = false;
    private Map<String, String> ciList = new HashMap<String, String>();
    private JsonArray buildInfo;

    public PackageCacheManager(boolean userMode, int toolsVersion) throws IOException {
        this.cacheFolder = userMode ? Utilities.path(System.getProperty("user.home"), ".fhir", "packages") : Utilities.path("var", "lib", ".fhir", "packages");
        if (!new File(this.cacheFolder).exists()) {
            Utilities.createDirectory(this.cacheFolder);
        }
        if (!new File(Utilities.path(this.cacheFolder, "packages.ini")).exists()) {
            TextFile.stringToFile("[cache]\r\nversion=3\r\n\r\n[urls]\r\n\r\n[local]\r\n\r\n", Utilities.path(this.cacheFolder, "packages.ini"), false);
        }
        this.createIniFile();
    }

    public void loadFromFolder(String packagesFolder) throws IOException {
        File[] files = new File(packagesFolder).listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().endsWith(".tgz")) continue;
                this.temporaryPackages.add(NpmPackage.fromPackage(new FileInputStream(f)));
            }
        }
    }

    public String getFolder() {
        return this.cacheFolder;
    }

    private static String userDir() throws IOException {
        return Utilities.path(System.getProperty("user.home"), ".fhir", "packages");
    }

    private List<String> sorted(String[] keys) {
        ArrayList<String> names = new ArrayList<String>();
        for (String s2 : keys) {
            names.add(s2);
        }
        Collections.sort(names);
        return names;
    }

    private NpmPackage loadPackageInfo(String path) throws IOException {
        NpmPackage pi = NpmPackage.fromFolder(path);
        return pi;
    }

    private JsonObject fetchJson(String source) throws IOException {
        URL url = new URL(source);
        URLConnection c = url.openConnection();
        return (JsonObject)new JsonParser().parse(TextFile.streamToString(c.getInputStream()));
    }

    private void clearCache() throws IOException {
        for (File f : new File(this.cacheFolder).listFiles()) {
            if (f.isDirectory()) {
                Utilities.clearDirectory(f.getAbsolutePath(), new String[0]);
                FileUtils.deleteDirectory(f);
                continue;
            }
            if (f.getName().equals("packages.ini")) continue;
            FileUtils.forceDelete(f);
        }
        IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
        ini.removeSection("packages");
        ini.save();
    }

    private void createIniFile() throws IOException {
        IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
        boolean save = false;
        String v = ini.getStringProperty("cache", "version");
        if (!CACHE_VERSION.equals(v)) {
            this.clearCache();
            ini.setStringProperty("cache", "version", CACHE_VERSION, null);
            save = true;
        }
    }

    private void checkValidVersionString(String version, String id) {
        if (Utilities.noString(version)) {
            throw new FHIRException("Cannot add package " + id + " to the package cache - a version must be provided");
        }
        if (version.startsWith("file:")) {
            throw new FHIRException("Cannot add package " + id + " to the package cache - the version '" + version + "' is illegal in this context");
        }
        for (char ch : version.toCharArray()) {
            if (Character.isAlphabetic(ch) || Character.isDigit(ch) || Utilities.existsInList(ch, 46, 45)) continue;
            throw new FHIRException("Cannot add package " + id + " to the package cache - the version '" + version + "' is illegal (ch '" + ch + "'");
        }
    }

    private String getPackageId(String canonical, String server) throws IOException {
        PackageClient pc = new PackageClient(server);
        List<PackageClient.PackageInfo> res = pc.search(null, canonical, null, false);
        if (res.size() == 0) {
            return null;
        }
        for (PackageClient.PackageInfo pi : res) {
            if (!canonical.equals(pi.getCanonical())) continue;
            return pi.getId();
        }
        return res.get(0).getId();
    }

    private String getPackageUrl(String packageId, String server) throws IOException {
        PackageClient pc = new PackageClient(server);
        List<PackageClient.PackageInfo> res = pc.search(packageId, null, null, false);
        if (res.size() == 0) {
            return null;
        }
        return res.get(0).getUrl();
    }

    private void listSpecs(Map<String, String> specList, String server) throws IOException {
        PackageClient pc = new PackageClient(server);
        List<PackageClient.PackageInfo> matches = pc.search(null, null, null, false);
        for (PackageClient.PackageInfo m3 : matches) {
            if (specList.containsKey(m3.getId())) continue;
            specList.put(m3.getId(), m3.getUrl());
        }
    }

    private InputStreamWithSrc loadFromPackageServer(String id, String v) {
        InputStream stream;
        if ("4.4.0".equals(v)) {
            v = "4.2.0";
        }
        PackageClient pc = new PackageClient(PRIMARY_SERVER);
        String u = null;
        try {
            if (Utilities.noString(v)) {
                v = pc.getLatestVersion(id);
            }
            stream = pc.fetch(id, v);
            u = pc.url(id, v);
        }
        catch (IOException e) {
            pc = new PackageClient(SECONDARY_SERVER);
            try {
                if (Utilities.noString(v)) {
                    v = pc.getLatestVersion(id);
                }
                stream = pc.fetch(id, v);
                u = pc.url(id, v);
            }
            catch (IOException e1) {
                return this.fetchTheOldWay(id, v);
            }
        }
        return new InputStreamWithSrc(stream, pc.url(id, v), v);
    }

    public String getLatestVersion(String id) throws IOException {
        PackageClient pc = new PackageClient(PRIMARY_SERVER);
        try {
            return pc.getLatestVersion(id);
        }
        catch (IOException e) {
            pc = new PackageClient(SECONDARY_SERVER);
            try {
                return pc.getLatestVersion(id);
            }
            catch (IOException e1) {
                return this.fetchVersionTheOldWay(id);
            }
        }
    }

    private NpmPackage loadPackageFromFile(String id, String folder) throws IOException {
        File f = new File(Utilities.path(folder, id));
        if (!f.exists()) {
            throw new FHIRException("Package '" + id + "  not found in folder " + folder);
        }
        if (!f.isDirectory()) {
            throw new FHIRException("File for '" + id + "  found in folder " + folder + ", not a folder");
        }
        File fp = new File(Utilities.path(folder, id, "package", "package.json"));
        if (!fp.exists()) {
            throw new FHIRException("Package '" + id + "  found in folder " + folder + ", but does not contain a package.json file in /package");
        }
        return NpmPackage.fromFolder(f.getAbsolutePath());
    }

    public void clear() throws IOException {
        this.clearCache();
    }

    public void removePackage(String id, String ver) throws IOException {
        String f = Utilities.path(this.cacheFolder, id + "#" + ver);
        File ff = new File(f);
        if (ff.exists()) {
            Utilities.clearDirectory(f, new String[0]);
            IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
            ini.removeProperty("packages", id + "#" + ver);
            ini.save();
            ff.delete();
        }
    }

    public NpmPackage loadPackageFromCacheOnly(String id) throws IOException {
        return this.loadPackageFromCacheOnly(id, null);
    }

    public NpmPackage loadPackageFromCacheOnly(String id, String version) throws IOException {
        if (!Utilities.noString(version) && version.startsWith("file:")) {
            return this.loadPackageFromFile(id, version.substring(5));
        }
        for (NpmPackage p : this.temporaryPackages) {
            if (p.name().equals(id) && ("current".equals(version) || "dev".equals(version) || p.version().equals(version))) {
                return p;
            }
            if (!p.name().equals(id) || !Utilities.noString(version)) continue;
            return p;
        }
        for (String f : this.sorted(new File(this.cacheFolder).list())) {
            if (!f.equals(id + "#" + version) && (!Utilities.noString(version) || !f.startsWith(id + "#"))) continue;
            return this.loadPackageInfo(Utilities.path(this.cacheFolder, f));
        }
        if ("dev".equals(version)) {
            return this.loadPackageFromCacheOnly(id, "current");
        }
        return null;
    }

    public NpmPackage addPackageToCache(String id, String version, InputStream tgz, String sourceDesc) throws IOException {
        this.checkValidVersionString(version, id);
        if (this.progress) {
            System.out.println("Installing " + id + "#" + (version == null ? "?" : version) + " to the package cache");
            System.out.print("  Fetching:");
        }
        NpmPackage npm = NpmPackage.fromPackage(tgz, sourceDesc, true);
        if (this.progress) {
            System.out.println();
            System.out.print("  Installing: ");
        }
        if (!(npm.name() != null && id != null && id.equals(npm.name()) || id.equals("hl7.fhir.r5.core"))) {
            throw new IOException("Attempt to import a mis-identified package. Expected " + id + ", got " + npm.name());
        }
        if (version == null) {
            version = npm.version();
        }
        String packRoot = Utilities.path(this.cacheFolder, id + "#" + version);
        try {
            Utilities.createDirectory(packRoot);
            Utilities.clearDirectory(packRoot, new String[0]);
            int i = 0;
            int c = 0;
            int size = 0;
            for (Map.Entry<String, NpmPackage.NpmPackageFolder> e : npm.getFolders().entrySet()) {
                String dir;
                String string = dir = e.getKey().equals("package") ? Utilities.path(packRoot, "package") : Utilities.path(packRoot, "package", e.getKey());
                if (!new File(dir).exists()) {
                    Utilities.createDirectory(dir);
                }
                for (Map.Entry<String, byte[]> fe : e.getValue().getContent().entrySet()) {
                    String fn = Utilities.path(dir, fe.getKey());
                    byte[] cnt = fe.getValue();
                    TextFile.bytesToFile(cnt, fn);
                    size += cnt.length;
                    if (!this.progress || ++i % 50 != 0) continue;
                    System.out.print(".");
                    if (++c != 120) continue;
                    System.out.println("");
                    System.out.print("  ");
                    c = 2;
                }
            }
            IniFile ini = new IniFile(Utilities.path(this.cacheFolder, "packages.ini"));
            ini.setTimeStampFormat("yyyyMMddhhmmss");
            ini.setTimestampProperty("packages", id + "#" + version, Timestamp.from(Instant.now()), null);
            ini.setIntegerProperty("package-sizes", id + "#" + version, size, null);
            ini.save();
            if (this.progress) {
                System.out.println(" done.");
            }
            NpmPackage pck = this.loadPackageInfo(packRoot);
            if (!id.equals(JSONUtil.str(npm.getNpm(), "name")) || !version.equals(JSONUtil.str(npm.getNpm(), "version"))) {
                if (!id.equals(JSONUtil.str(npm.getNpm(), "name"))) {
                    npm.getNpm().addProperty("original-name", JSONUtil.str(npm.getNpm(), "name"));
                    npm.getNpm().remove("name");
                    npm.getNpm().addProperty("name", id);
                }
                if (!version.equals(JSONUtil.str(npm.getNpm(), "version"))) {
                    npm.getNpm().addProperty("original-version", JSONUtil.str(npm.getNpm(), "version"));
                    npm.getNpm().remove("version");
                    npm.getNpm().addProperty("version", version);
                }
                TextFile.stringToFile(new GsonBuilder().setPrettyPrinting().create().toJson(npm.getNpm()), Utilities.path(this.cacheFolder, id + "#" + version, "package", "package.json"), false);
            }
            return pck;
        }
        catch (Exception e) {
            try {
                Utilities.clearDirectory(packRoot, new String[0]);
                new File(packRoot).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public String getPackageId(String canonical) throws IOException {
        String result = null;
        if (result == null) {
            result = this.getPackageId(canonical, PRIMARY_SERVER);
        }
        if (result == null) {
            result = this.getPackageId(canonical, SECONDARY_SERVER);
        }
        if (result == null) {
            result = this.getPackageIdFromBuildList(canonical);
        }
        return result;
    }

    public String getPackageUrl(String packageId) throws IOException {
        String result = null;
        NpmPackage npm = this.loadPackageFromCacheOnly(packageId);
        if (npm != null) {
            return npm.canonical();
        }
        if (result == null) {
            this.getPackageUrl(packageId, PRIMARY_SERVER);
        }
        if (result == null) {
            result = this.getPackageUrl(packageId, SECONDARY_SERVER);
        }
        if (result == null) {
            result = this.getPackageUrlFromBuildList(packageId);
        }
        return result;
    }

    public void listAllIds(Map<String, String> specList) throws IOException {
        for (NpmPackage p : this.temporaryPackages) {
            specList.put(p.name(), p.canonical());
        }
        this.listSpecs(specList, PRIMARY_SERVER);
        this.listSpecs(specList, SECONDARY_SERVER);
        this.addCIBuildSpecs(specList);
    }

    public NpmPackage loadPackage(String id, String v) throws FHIRException, IOException {
        if (!Utilities.noString(v) && v.startsWith("file:")) {
            return this.loadPackageFromFile(id, v.substring(5));
        }
        NpmPackage p = this.loadPackageFromCacheOnly(id, v);
        if (p != null) {
            if ("current".equals(v)) {
                p = this.checkCurrency(id, p);
            }
            if (p != null) {
                return p;
            }
        }
        if ("dev".equals(v)) {
            p = this.loadPackageFromCacheOnly(id, "current");
            if ((p = this.checkCurrency(id, p)) != null) {
                return p;
            }
            v = "current";
        }
        InputStreamWithSrc source = "current".equals(v) ? this.loadFromCIBuild(id) : this.loadFromPackageServer(id, v);
        return this.addPackageToCache(id, v == null ? source.version : v, source.stream, source.url);
    }

    private InputStream fetchFromUrlSpecific(String source, boolean optional) throws FHIRException {
        try {
            URL url = new URL(source);
            URLConnection c = url.openConnection();
            return c.getInputStream();
        }
        catch (Exception e) {
            if (optional) {
                return null;
            }
            throw new FHIRException(e.getMessage(), e);
        }
    }

    private InputStreamWithSrc loadFromCIBuild(String id) throws IOException {
        this.checkBuildLoaded();
        if (this.ciList.containsKey(id)) {
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL(this.ciList.get(id), "package.tgz"), false);
            return new InputStreamWithSrc(stream, Utilities.pathURL(this.ciList.get(id), "package.tgz"), "current");
        }
        if (id.startsWith("hl7.fhir.r5")) {
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL("http://hl7.org/fhir/2020Feb", id + ".tgz"), false);
            return new InputStreamWithSrc(stream, Utilities.pathURL("http://hl7.org/fhir/2020Feb", id + ".tgz"), "current");
        }
        throw new FHIRException("The package '" + id + "' has not entry on the current build server");
    }

    private String getPackageIdFromBuildList(String canonical) throws IOException {
        this.checkBuildLoaded();
        if (this.buildInfo != null) {
            JsonObject o;
            for (JsonElement n : this.buildInfo) {
                o = (JsonObject)n;
                if (!canonical.equals(JSONUtil.str(o, "url"))) continue;
                return JSONUtil.str(o, "package-id");
            }
            for (JsonElement n : this.buildInfo) {
                o = (JsonObject)n;
                if (!JSONUtil.str(o, "url").startsWith(canonical + "/ImplementationGuide/")) continue;
                return JSONUtil.str(o, "package-id");
            }
        }
        return null;
    }

    private String getPackageUrlFromBuildList(String packageId) throws IOException {
        this.checkBuildLoaded();
        for (JsonElement n : this.buildInfo) {
            JsonObject o = (JsonObject)n;
            if (!packageId.equals(JSONUtil.str(o, "package-id"))) continue;
            return JSONUtil.str(o, "url");
        }
        return null;
    }

    private void addCIBuildSpecs(Map<String, String> specList) throws IOException {
        this.checkBuildLoaded();
        for (JsonElement n : this.buildInfo) {
            JsonObject o = (JsonObject)n;
            if (specList.containsKey(JSONUtil.str(o, "package-id"))) continue;
            specList.put(JSONUtil.str(o, "package-id"), JSONUtil.str(o, "url"));
        }
    }

    private NpmPackage checkCurrency(String id, NpmPackage p) throws IOException {
        this.checkBuildLoaded();
        try {
            String url = this.ciList.get(id);
            JsonObject json = this.fetchJson(Utilities.pathURL(url, "package.manifest.json"));
            String currDate = JSONUtil.str(json, "date");
            String packDate = p.date();
            if (!currDate.equals(packDate)) {
                return null;
            }
            return p;
        }
        catch (Exception e) {
            return p;
        }
    }

    private boolean checkBuildLoaded() {
        if (this.buildLoaded) {
            return true;
        }
        try {
            this.loadFromBuildServer();
        }
        catch (Exception e) {
            System.out.println("Error connecting to build server - running without build (" + e.getMessage() + ")");
        }
        return false;
    }

    private void loadFromBuildServer() throws IOException {
        URL url = new URL("https://build.fhir.org/ig/qas.json?nocache=" + System.currentTimeMillis());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        InputStream json = connection.getInputStream();
        this.buildInfo = (JsonArray)new JsonParser().parse(TextFile.streamToString(json));
        ArrayList<BuildRecord> builds = new ArrayList<BuildRecord>();
        for (JsonElement n : this.buildInfo) {
            JsonObject o = (JsonObject)n;
            if (!o.has("url") || !o.has("package-id") || !o.get("package-id").getAsString().contains(".")) continue;
            String u = o.get("url").getAsString();
            if (u.contains("/ImplementationGuide/")) {
                u = u.substring(0, u.indexOf("/ImplementationGuide/"));
            }
            builds.add(new BuildRecord(u, o.get("package-id").getAsString(), this.getRepo(o.get("repo").getAsString()), this.readDate(o.get("date").getAsString())));
        }
        Collections.sort(builds, new BuildRecordSorter());
        for (BuildRecord bld : builds) {
            if (this.ciList.containsKey(bld.getPackageId())) continue;
            this.ciList.put(bld.getPackageId(), "https://build.fhir.org/ig/" + bld.getRepo());
        }
        this.buildLoaded = true;
    }

    private String getRepo(String path) {
        String[] p = path.split("\\/");
        return p[0] + "/" + p[1];
    }

    private Date readDate(String s2) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM, yyyy HH:mm:ss Z", new Locale("en", "US"));
        try {
            return sdf.parse(s2);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    private InputStreamWithSrc fetchTheOldWay(String id, String v) {
        JsonObject json;
        String pu;
        String url = this.getUrlForPackage(id);
        if (url == null) {
            try {
                url = this.getPackageUrlFromBuildList(id);
            }
            catch (Exception e) {
                url = null;
            }
        }
        if (url == null) {
            throw new FHIRException("Unable to resolve package id " + id + "#" + v);
        }
        if (url.contains("/ImplementationGuide/")) {
            url = url.substring(0, url.indexOf("/ImplementationGuide/"));
        }
        String aurl = pu = Utilities.pathURL(url, "package-list.json");
        try {
            json = this.fetchJson(pu);
        }
        catch (Exception e) {
            String pv = Utilities.pathURL(url, v, "package.tgz");
            try {
                aurl = pv;
                InputStreamWithSrc src = new InputStreamWithSrc(this.fetchFromUrlSpecific(pv, true), pv, v);
                return src;
            }
            catch (Exception e1) {
                throw new FHIRException("Error fetching package directly (" + pv + "), or fetching package list for " + id + " from " + pu + ": " + e1.getMessage(), e1);
            }
        }
        if (!id.equals(JSONUtil.str(json, "package-id"))) {
            throw new FHIRException("Package ids do not match in " + pu + ": " + id + " vs " + JSONUtil.str(json, "package-id"));
        }
        for (JsonElement e : json.getAsJsonArray("list")) {
            JsonObject vo = (JsonObject)e;
            if (!v.equals(JSONUtil.str(vo, "version"))) continue;
            aurl = Utilities.pathURL(JSONUtil.str(vo, "path"), "package.tgz");
            String u = Utilities.pathURL(JSONUtil.str(vo, "path"), "package.tgz");
            return new InputStreamWithSrc(this.fetchFromUrlSpecific(u, true), u, v);
        }
        return null;
    }

    private String fetchVersionTheOldWay(String id) throws IOException {
        String url = this.getUrlForPackage(id);
        if (url == null) {
            try {
                url = this.getPackageUrlFromBuildList(id);
            }
            catch (Exception e) {
                url = null;
            }
        }
        if (url == null) {
            throw new FHIRException("Unable to resolve package id " + id);
        }
        String pu = Utilities.pathURL(url, "package-list.json");
        JsonObject json = this.fetchJson(pu);
        if (!id.equals(JSONUtil.str(json, "package-id"))) {
            throw new FHIRException("Package ids do not match in " + pu + ": " + id + " vs " + JSONUtil.str(json, "package-id"));
        }
        for (JsonElement e : json.getAsJsonArray("list")) {
            JsonObject vo = (JsonObject)e;
            if (!JSONUtil.bool(vo, "current")) continue;
            return JSONUtil.str(vo, "version");
        }
        return null;
    }

    private String getUrlForPackage(String id) {
        if ("hl7.fhir.xver-extensions".equals(id)) {
            return "http://fhir.org/packages/hl7.fhir.xver-extensions";
        }
        return null;
    }

    public class PackageEntry {
        private byte[] bytes;
        private String name;

        public PackageEntry(String name) {
            this.name = name;
        }

        public PackageEntry(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }
    }

    public class VersionHistory {
        private String id;
        private String canonical;
        private String current;
        private Map<String, String> versions = new HashMap<String, String>();

        public String getCanonical() {
            return this.canonical;
        }

        public String getCurrent() {
            return this.current;
        }

        public Map<String, String> getVersions() {
            return this.versions;
        }

        public String getId() {
            return this.id;
        }
    }

    public static interface INetworkServices {
        public InputStream resolvePackage(String var1, String var2);
    }

    public class BuildRecord {
        private String url;
        private String packageId;
        private String repo;
        private Date date;

        public BuildRecord(String url, String packageId, String repo, Date date) {
            this.url = url;
            this.packageId = packageId;
            this.repo = repo;
            this.date = date;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPackageId() {
            return this.packageId;
        }

        public String getRepo() {
            return this.repo;
        }

        public Date getDate() {
            return this.date;
        }
    }

    public class BuildRecordSorter
    implements Comparator<BuildRecord> {
        @Override
        public int compare(BuildRecord arg0, BuildRecord arg1) {
            return arg1.date.compareTo(arg0.date);
        }
    }

    public class InputStreamWithSrc {
        public InputStream stream;
        public String url;
        public String version;

        public InputStreamWithSrc(InputStream stream, String url, String version) {
            this.stream = stream;
            this.url = url;
            this.version = version;
        }
    }
}

