/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.CodeSystemRenderer;
import org.hl7.fhir.r5.renderers.ConceptMapRenderer;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.ValueSetRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.INarrativeGenerator;
import org.hl7.fhir.r5.utils.LiquidEngine;
import org.hl7.fhir.r5.utils.ResourceUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XmlGenerator;
import org.w3c.dom.Element;

public class NarrativeGenerator
implements INarrativeGenerator {
    private Bundle bundle;
    private String definitionsTarget;
    private String corePath;
    private String destDir;
    private String snomedEdition;
    private ProfileUtilities.ProfileKnowledgeProvider pkp;
    private MarkDownProcessor markdown = new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK);
    private ITypeParser parser;
    private ILiquidTemplateProvider templateProvider;
    private FHIRPathEngine.IEvaluationContext services;
    private String prefix;
    private IWorkerContext context;
    private String basePath;
    private String tooCostlyNoteEmpty;
    private String tooCostlyNoteNotEmpty;
    private String tooCostlyNoteEmptyDependent;
    private String tooCostlyNoteNotEmptyDependent;
    private IReferenceResolver resolver;
    private int headerLevelContext;
    private boolean pretty;
    private boolean canonicalUrlsAsLinks;
    private ValidationOptions terminologyServiceOptions = new ValidationOptions();
    private boolean noSlowLookup;
    private List<String> codeSystemPropList = new ArrayList<String>();
    private ProfileUtilities profileUtilities;
    private XVerExtensionManager xverManager;

    public boolean generate(Bundle b, boolean evenIfAlreadyHasNarrative, Set<String> outputTracker) throws EOperationOutcome, FHIRException, IOException {
        boolean res = false;
        this.bundle = b;
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            if (!be.hasResource() || !(be.getResource() instanceof DomainResource)) continue;
            DomainResource dr = (DomainResource)be.getResource();
            if (!evenIfAlreadyHasNarrative && dr.getText().hasDiv()) continue;
            res = this.generate(new Resolver.ResourceContext(b, dr), dr, outputTracker) || res;
        }
        return res;
    }

    public boolean generate(DomainResource r) throws EOperationOutcome, FHIRException, IOException {
        return this.generate(null, r, new HashSet<String>());
    }

    public boolean generate(DomainResource r, Set<String> outputTracker) throws EOperationOutcome, FHIRException, IOException {
        return this.generate(null, r, outputTracker);
    }

    public boolean generate(Resolver.ResourceContext rcontext, DomainResource r, Set<String> outputTracker) throws EOperationOutcome, FHIRException, IOException {
        String liquidTemplate;
        if (rcontext == null) {
            rcontext = new Resolver.ResourceContext(null, r);
        }
        if (this.templateProvider != null && (liquidTemplate = this.templateProvider.findTemplate(rcontext, r)) != null) {
            return this.generateByLiquid(rcontext, r, liquidTemplate, outputTracker);
        }
        if (r instanceof ConceptMap) {
            return this.generate(rcontext, (ConceptMap)r);
        }
        if (r instanceof ValueSet) {
            return this.generate(rcontext, (ValueSet)r, true);
        }
        if (r instanceof CodeSystem) {
            return this.generate(rcontext, (CodeSystem)r, true, null);
        }
        if (r instanceof OperationOutcome) {
            return this.generate(rcontext, (OperationOutcome)r);
        }
        if (r instanceof CapabilityStatement) {
            return this.generate(rcontext, (CapabilityStatement)r);
        }
        if (r instanceof CompartmentDefinition) {
            return this.generate(rcontext, (CompartmentDefinition)r);
        }
        if (r instanceof OperationDefinition) {
            return this.generate(rcontext, (OperationDefinition)r);
        }
        if (r instanceof StructureDefinition) {
            return this.generate(rcontext, (StructureDefinition)r, outputTracker);
        }
        if (r instanceof List) {
            return this.generate(rcontext, (ListResource)r);
        }
        if (r instanceof ImplementationGuide) {
            return this.generate(rcontext, (ImplementationGuide)r);
        }
        if (r instanceof Provenance) {
            return this.generate(rcontext, new ResourceWrapperDirect(r), (Provenance)r);
        }
        if (r instanceof DiagnosticReport) {
            this.inject(r, this.generateDiagnosticReport(new ResourceWrapperDirect(r)), Narrative.NarrativeStatus.GENERATED);
            return true;
        }
        StructureDefinition p = null;
        if (r.hasMeta()) {
            for (UriType uriType : r.getMeta().getProfile()) {
                if (p != null) continue;
                p = this.context.fetchResource(StructureDefinition.class, (String)uriType.getValue());
            }
        }
        if (p == null) {
            p = this.context.fetchResource(StructureDefinition.class, r.getResourceType().toString());
        }
        if (p == null) {
            p = this.context.fetchTypeDefinition(r.getResourceType().toString().toLowerCase());
        }
        if (p != null) {
            return this.generateByProfile(rcontext, p, true);
        }
        return false;
    }

    private boolean generateByLiquid(Resolver.ResourceContext rcontext, DomainResource r, String liquidTemplate, Set<String> outputTracker) {
        XhtmlNode x;
        LiquidEngine engine = new LiquidEngine(this.context, this.services);
        try {
            LiquidEngine.LiquidDocument doc = engine.parse(liquidTemplate, "template");
            String html = engine.evaluate(doc, r, rcontext);
            x = new XhtmlParser().parseFragment(html);
            if (!x.getName().equals("div")) {
                throw new FHIRException("Error in template: Root element is not 'div'");
            }
        }
        catch (IOException | FHIRException e) {
            x = new XhtmlNode(NodeType.Element, "div");
            x.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(r, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public NarrativeGenerator(String prefix, String basePath, IWorkerContext context) {
        this.prefix = prefix;
        this.context = context;
        this.basePath = basePath;
        this.init();
    }

    public NarrativeGenerator setLiquidServices(ILiquidTemplateProvider templateProvider, FHIRPathEngine.IEvaluationContext services) {
        this.templateProvider = templateProvider;
        this.services = services;
        return this;
    }

    public Base parseType(String xml, String type) throws IOException, FHIRException {
        if (this.parser != null) {
            return this.parser.parseType(xml, type);
        }
        return new XmlParser().parseAnyType(xml, type);
    }

    public NarrativeGenerator(String prefix, String basePath, IWorkerContext context, IReferenceResolver resolver) {
        this.prefix = prefix;
        this.context = context;
        this.basePath = basePath;
        this.resolver = resolver;
        this.init();
    }

    private void init() {
        this.profileUtilities = new ProfileUtilities(this.context, null, null);
    }

    public int getHeaderLevelContext() {
        return this.headerLevelContext;
    }

    public NarrativeGenerator setHeaderLevelContext(int headerLevelContext) {
        this.headerLevelContext = headerLevelContext;
        return this;
    }

    public String getTooCostlyNoteEmpty() {
        return this.tooCostlyNoteEmpty;
    }

    public NarrativeGenerator setTooCostlyNoteEmpty(String tooCostlyNoteEmpty) {
        this.tooCostlyNoteEmpty = tooCostlyNoteEmpty;
        return this;
    }

    public String getTooCostlyNoteNotEmpty() {
        return this.tooCostlyNoteNotEmpty;
    }

    public NarrativeGenerator setTooCostlyNoteNotEmpty(String tooCostlyNoteNotEmpty) {
        this.tooCostlyNoteNotEmpty = tooCostlyNoteNotEmpty;
        return this;
    }

    public String getTooCostlyNoteEmptyDependent() {
        return this.tooCostlyNoteEmptyDependent;
    }

    public void setTooCostlyNoteEmptyDependent(String tooCostlyNoteEmptyDependent) {
        this.tooCostlyNoteEmptyDependent = tooCostlyNoteEmptyDependent;
    }

    public String getTooCostlyNoteNotEmptyDependent() {
        return this.tooCostlyNoteNotEmptyDependent;
    }

    public void setTooCostlyNoteNotEmptyDependent(String tooCostlyNoteNotEmptyDependent) {
        this.tooCostlyNoteNotEmptyDependent = tooCostlyNoteNotEmptyDependent;
    }

    public String generate(Element doc) throws IOException, FHIRException {
        return this.generate(null, doc);
    }

    public String generate(Resolver.ResourceContext rcontext, Element doc) throws IOException, FHIRException {
        if (rcontext == null) {
            rcontext = new Resolver.ResourceContext(null, doc);
        }
        String rt = "http://hl7.org/fhir/StructureDefinition/" + doc.getNodeName();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, rt);
        return this.generateByProfile(doc, p, true);
    }

    public String generate(org.hl7.fhir.r5.elementmodel.Element er, boolean showCodeDetails, ITypeParser parser) throws IOException, FHIRException, EOperationOutcome {
        return this.generate(null, er, showCodeDetails, parser);
    }

    public String generate(Resolver.ResourceContext rcontext, org.hl7.fhir.r5.elementmodel.Element er, boolean showCodeDetails, ITypeParser parser) throws IOException, FHIRException, EOperationOutcome {
        if (rcontext == null) {
            rcontext = new Resolver.ResourceContext(null, er);
        }
        this.parser = parser;
        ResourceWrapperMetaElement resw = new ResourceWrapperMetaElement(er);
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        if ("List".equals(resw.getName())) {
            this.generateList(x, resw);
        } else {
            x.para().b().tx("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
            try {
                BaseWrapperMetaElement base = new BaseWrapperMetaElement(er, null, er.getProperty().getStructure(), er.getProperty().getDefinition());
                base.children();
                this.generateByProfile(resw, er.getProperty().getStructure(), base, er.getProperty().getStructure().getSnapshot().getElement(), er.getProperty().getDefinition(), base.children, x, er.fhirType(), showCodeDetails, 0, rcontext);
            }
            catch (Exception e) {
                e.printStackTrace();
                x.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
            }
        }
        this.inject(er, x, Narrative.NarrativeStatus.GENERATED);
        return new XhtmlComposer(true, this.pretty).compose(x);
    }

    private boolean generateByProfile(Resolver.ResourceContext rc, StructureDefinition profile, boolean showCodeDetails) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.para().b().tx("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(rc.getResourceResource(), profile, rc.getResourceResource(), profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), rc.getResourceResource().getResourceType().toString()), x, rc.getResourceResource().getResourceType().toString(), showCodeDetails, rc);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(rc.getResourceResource(), x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    private String generateByProfile(Element er, StructureDefinition profile, boolean showCodeDetails) throws IOException, FHIRException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.para().b().tx("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(er, profile, er, profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), er.getLocalName()), x, er.getLocalName(), showCodeDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.para().b().style("color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(er, x, Narrative.NarrativeStatus.GENERATED);
        String b = new XhtmlComposer(true, this.pretty).compose(x);
        return b;
    }

    private void generateByProfile(Element eres, StructureDefinition profile, Element ee, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        ResourceWrapperElement resw = new ResourceWrapperElement(eres, profile);
        BaseWrapperElement base = new BaseWrapperElement(ee, null, profile, profile.getSnapshot().getElement().get(0));
        this.generateByProfile(resw, profile, base, allElements, defn, children, x, path, showCodeDetails, 0, null);
    }

    private void generateByProfile(Resource res, StructureDefinition profile, Base e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails, Resolver.ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        this.generateByProfile(new ResourceWrapperDirect(res), profile, new BaseWrapperDirect(e), allElements, defn, children, x, path, showCodeDetails, 0, rc);
    }

    private void generateByProfile(ResourceWrapper res, StructureDefinition profile, BaseWrapper e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails, int indent, Resolver.ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        if (children.isEmpty()) {
            this.renderLeaf(res, e, defn, x, false, showCodeDetails, this.readDisplayHints(defn), path, indent, rc);
        } else {
            for (PropertyWrapper p : this.splitExtensions(profile, e.children())) {
                ElementDefinition child;
                if (!p.hasValues() || (child = this.getElementDefinition(children, path + "." + p.getName(), p)) == null) continue;
                Map<String, String> displayHints = this.readDisplayHints(child);
                if (this.exemptFromRendering(child)) continue;
                List<ElementDefinition> grandChildren = this.getChildrenForPath(allElements, path + "." + p.getName());
                this.filterGrandChildren(grandChildren, path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || child == null) continue;
                if (this.isPrimitive(child)) {
                    XhtmlNode para = x.para();
                    String name = p.getName();
                    if (name.endsWith("[x]")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    if (!showCodeDetails && this.isDefaultValue(displayHints, p.getValues())) continue;
                    para.b().addText(name);
                    para.tx(": ");
                    if (this.renderAsList(child) && p.getValues().size() > 1) {
                        XhtmlNode list = x.ul();
                        for (BaseWrapper v : p.getValues()) {
                            this.renderLeaf(res, v, child, list.li(), false, showCodeDetails, displayHints, path, indent, rc);
                        }
                        continue;
                    }
                    boolean first = true;
                    for (BaseWrapper v : p.getValues()) {
                        if (first) {
                            first = false;
                        } else {
                            para.tx(", ");
                        }
                        this.renderLeaf(res, v, child, para, false, showCodeDetails, displayHints, path, indent, rc);
                    }
                    continue;
                }
                if (this.canDoTable(path, p, grandChildren)) {
                    x.addTag(this.getHeader()).addText(Utilities.capitalize(Utilities.camelCase(Utilities.pluralizeMe(p.getName()))));
                    XhtmlNode tbl = x.table("grid");
                    XhtmlNode tr = tbl.tr();
                    tr.td().tx("-");
                    this.addColumnHeadings(tr, grandChildren);
                    for (BaseWrapper v : p.getValues()) {
                        if (v == null) continue;
                        tr = tbl.tr();
                        tr.td().tx("*");
                        this.addColumnValues(res, tr, grandChildren, v, showCodeDetails, displayHints, path, indent, rc);
                    }
                    continue;
                }
                for (BaseWrapper v : p.getValues()) {
                    if (v == null) continue;
                    XhtmlNode bq = x.addTag("blockquote");
                    bq.para().b().addText(p.getName());
                    this.generateByProfile(res, profile, v, allElements, child, grandChildren, bq, path + "." + p.getName(), showCodeDetails, indent + 1, rc);
                }
            }
        }
    }

    private String getHeader() {
        int i;
        for (i = 3; i <= this.headerLevelContext; ++i) {
        }
        if (i > 6) {
            i = 6;
        }
        return "h" + Integer.toString(i);
    }

    private void filterGrandChildren(List<ElementDefinition> grandChildren, String string, PropertyWrapper prop) {
        ArrayList<ElementDefinition> toRemove = new ArrayList<ElementDefinition>();
        toRemove.addAll(grandChildren);
        for (BaseWrapper b : prop.getValues()) {
            ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
            for (ElementDefinition ed : toRemove) {
                PropertyWrapper p = b.getChildByName(this.tail(ed.getPath()));
                if (p == null || !p.hasValues()) continue;
                list.add(ed);
            }
            toRemove.removeAll(list);
        }
        grandChildren.removeAll(toRemove);
    }

    private List<PropertyWrapper> splitExtensions(StructureDefinition profile, List<PropertyWrapper> children) throws UnsupportedEncodingException, IOException, FHIRException {
        ArrayList<PropertyWrapper> results = new ArrayList<PropertyWrapper>();
        HashMap map = new HashMap();
        for (PropertyWrapper p : children) {
            if (p.getName().equals("extension") || p.getName().equals("modifierExtension")) {
                if (!p.hasValues()) continue;
                for (BaseWrapper v : p.getValues()) {
                    Extension ex = (Extension)v.getBase();
                    String url = ex.getUrl();
                    StructureDefinition ed = this.context.fetchResource(StructureDefinition.class, url);
                    if (ed == null) {
                        if (this.xverManager == null) {
                            this.xverManager = new XVerExtensionManager(this.context);
                        }
                        if (this.xverManager.matchingUrl(url) && this.xverManager.status(url) == XVerExtensionManager.XVerExtensionStatus.Valid) {
                            ed = this.xverManager.makeDefinition(url);
                            this.context.generateSnapshot(ed);
                            this.context.cacheResource(ed);
                        }
                    }
                    if (p.getName().equals("modifierExtension") && ed == null) {
                        throw new DefinitionException("Unknown modifier extension " + url);
                    }
                    PropertyWrapper pe = (PropertyWrapper)map.get(p.getName() + "[" + url + "]");
                    if (pe == null) {
                        if (ed == null) {
                            if (url.startsWith("http://hl7.org/fhir") && !url.startsWith("http://hl7.org/fhir/us")) {
                                throw new DefinitionException("unknown extension " + url);
                            }
                            pe = new PropertyWrapperDirect(new Property(p.getName() + "[" + url + "]", p.getTypeCode(), p.getDefinition(), p.getMinCardinality(), p.getMaxCardinality(), ex));
                        } else {
                            ElementDefinition def = ed.getSnapshot().getElement().get(0);
                            pe = new PropertyWrapperDirect(new Property(p.getName() + "[" + url + "]", "Extension", def.getDefinition(), def.getMin(), def.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(def.getMax()), ex));
                            ((PropertyWrapperDirect)pe).wrapped.setStructure(ed);
                        }
                        results.add(pe);
                        continue;
                    }
                    pe.getValues().add(v);
                }
                continue;
            }
            results.add(p);
        }
        return results;
    }

    private boolean isDefaultValue(Map<String, String> displayHints, List<BaseWrapper> list) throws UnsupportedEncodingException, IOException, FHIRException {
        if (list.size() != 1) {
            return false;
        }
        if (list.get(0).getBase() instanceof PrimitiveType) {
            return this.isDefault(displayHints, (PrimitiveType)list.get(0).getBase());
        }
        return false;
    }

    private boolean isDefault(Map<String, String> displayHints, PrimitiveType primitiveType) {
        String v = primitiveType.asStringValue();
        return !Utilities.noString(v) && displayHints.containsKey("default") && v.equals(displayHints.get("default"));
    }

    private boolean exemptFromRendering(ElementDefinition child) {
        if (child == null) {
            return false;
        }
        if ("Composition.subject".equals(child.getPath())) {
            return true;
        }
        return "Composition.section".equals(child.getPath());
    }

    private boolean renderAsList(ElementDefinition child) {
        String t;
        return child.getType().size() == 1 && ((t = child.getType().get(0).getWorkingCode()).equals("Address") || t.equals("Reference"));
    }

    private void addColumnHeadings(XhtmlNode tr, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            tr.td().b().addText(Utilities.capitalize(this.tail(e.getPath())));
        }
    }

    private void addColumnValues(ResourceWrapper res, XhtmlNode tr, List<ElementDefinition> grandChildren, BaseWrapper v, boolean showCodeDetails, Map<String, String> displayHints, String path, int indent, Resolver.ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        for (ElementDefinition e : grandChildren) {
            PropertyWrapper p = v.getChildByName(e.getPath().substring(e.getPath().lastIndexOf(".") + 1));
            if (p == null || p.getValues().size() == 0 || p.getValues().get(0) == null) {
                tr.td().tx(" ");
                continue;
            }
            this.renderLeaf(res, p.getValues().get(0), e, tr.td(), false, showCodeDetails, displayHints, path, indent, rc);
        }
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private boolean canDoTable(String path, PropertyWrapper p, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            List<PropertyWrapper> values = this.getValues(path, p, e);
            if (values.size() <= 1 && this.isPrimitive(e) && this.canCollapse(e)) continue;
            return false;
        }
        return true;
    }

    private List<PropertyWrapper> getValues(String path, PropertyWrapper p, ElementDefinition e) {
        ArrayList<PropertyWrapper> res = new ArrayList<PropertyWrapper>();
        for (BaseWrapper v : p.getValues()) {
            for (PropertyWrapper g2 : v.children()) {
                if (!(path + "." + p.getName() + "." + g2.getName()).equals(e.getPath())) continue;
                res.add(p);
            }
        }
        return res;
    }

    private boolean canCollapse(ElementDefinition e) {
        return !e.getType().isEmpty();
    }

    private boolean isPrimitive(ElementDefinition e) {
        if (e.getType().isEmpty()) {
            return false;
        }
        return e.getType().size() != 1 || !this.isBase(e.getType().get(0).getWorkingCode());
    }

    private boolean isBase(String code) {
        return code.equals("Element") || code.equals("BackboneElement");
    }

    private ElementDefinition getElementDefinition(List<ElementDefinition> elements, String path, PropertyWrapper p) {
        for (ElementDefinition element : elements) {
            if (!element.getPath().equals(path)) continue;
            return element;
        }
        if (path.endsWith("\"]") && p.getStructure() != null) {
            return p.getStructure().getSnapshot().getElement().get(0);
        }
        return null;
    }

    private void renderLeaf(ResourceWrapper res, BaseWrapper ew, ElementDefinition defn, XhtmlNode x, boolean title, boolean showCodeDetails, Map<String, String> displayHints, String path, int indent, Resolver.ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return;
        }
        Base e = ew.getBase();
        if (e instanceof StringType) {
            x.addText((String)((StringType)e).getValue());
        } else if (e instanceof CodeType) {
            x.addText((String)((CodeType)e).getValue());
        } else if (e instanceof IdType) {
            x.addText(((IdType)e).getValue());
        } else {
            if (e instanceof Extension) {
                return;
            }
            if (e instanceof InstantType) {
                x.addText(((InstantType)e).toHumanDisplay());
            } else if (e instanceof DateTimeType) {
                this.renderDateTime(x, e);
            } else if (e instanceof Base64BinaryType) {
                x.addText(new Base64().encodeAsString(((Base64BinaryType)e).getValue()));
            } else if (e instanceof DateType) {
                x.addText(((DateType)e).toHumanDisplay());
            } else if (e instanceof Enumeration) {
                Object ev = ((Enumeration)e).getValue();
                x.addText(ev == null ? "" : ev.toString());
            } else if (e instanceof BooleanType) {
                x.addText(((Boolean)((BooleanType)e).getValue()).toString());
            } else if (e instanceof CodeableConcept) {
                this.renderCodeableConcept((CodeableConcept)e, x, showCodeDetails);
            } else if (e instanceof Coding) {
                this.renderCoding((Coding)e, x, showCodeDetails);
            } else if (e instanceof Annotation) {
                this.renderAnnotation((Annotation)e, x);
            } else if (e instanceof Identifier) {
                this.renderIdentifier((Identifier)e, x);
            } else if (e instanceof IntegerType) {
                x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
            } else if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
            } else if (e instanceof HumanName) {
                this.renderHumanName((HumanName)e, x);
            } else if (e instanceof SampledData) {
                this.renderSampledData((SampledData)e, x);
            } else if (e instanceof Address) {
                this.renderAddress((Address)e, x);
            } else if (e instanceof ContactPoint) {
                this.renderContactPoint((ContactPoint)e, x);
            } else if (e instanceof ContactDetail) {
                ContactDetail cd2 = (ContactDetail)e;
                if (cd2.hasName()) {
                    x.tx(cd2.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : cd2.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        x.tx(",");
                    }
                    this.renderContactPoint(c, x);
                }
            } else if (e instanceof UriType) {
                this.renderUri((UriType)e, x, defn.getPath(), rc != null && rc.getResourceResource() != null ? rc.getResourceResource().getId() : null);
            } else if (e instanceof Timing) {
                this.renderTiming((Timing)e, x);
            } else if (e instanceof Range) {
                this.renderRange((Range)e, x);
            } else if (e instanceof Quantity) {
                this.renderQuantity((Quantity)e, x, showCodeDetails);
            } else if (e instanceof Ratio) {
                this.renderQuantity(((Ratio)e).getNumerator(), x, showCodeDetails);
                x.tx("/");
                this.renderQuantity(((Ratio)e).getDenominator(), x, showCodeDetails);
            } else if (e instanceof Period) {
                Period p = (Period)e;
                this.renderPeriod(x, p);
            } else if (e instanceof Reference) {
                Reference r = (Reference)e;
                this.renderReference(rc, res, x, r);
            } else {
                if (e instanceof Resource) {
                    return;
                }
                if (e instanceof ElementDefinition) {
                    x.tx("todo-bundle");
                } else if (!(e == null || e instanceof Attachment || e instanceof Narrative || e instanceof Meta)) {
                    StructureDefinition sd = this.context.fetchTypeDefinition(e.fhirType());
                    if (sd == null) {
                        throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet, and no structure found");
                    }
                    this.generateByProfile(res, sd, ew, sd.getSnapshot().getElement(), sd.getSnapshot().getElementFirstRep(), this.getChildrenForPath(sd.getSnapshot().getElement(), sd.getSnapshot().getElementFirstRep().getPath()), x, path, showCodeDetails, indent + 1, rc);
                }
            }
        }
    }

    public void renderReference(Resolver.ResourceContext rc, ResourceWrapper res, XhtmlNode x, Reference r) throws UnsupportedEncodingException, IOException {
        XhtmlNode c = x;
        ResourceWithReference tr = null;
        if (r.hasReferenceElement()) {
            tr = this.resolveReference(res, r.getReference(), rc);
            if (!r.getReference().startsWith("#")) {
                c = tr != null && tr.getReference() != null ? x.ah(tr.getReference()) : x.ah(r.getReference());
            }
        }
        if (r.hasDisplayElement()) {
            c.addText(r.getDisplay());
            if (tr != null && tr.getResource() != null) {
                c.tx(". Generated Summary: ");
                this.generateResourceSummary(c, tr.getResource(), true, r.getReference().startsWith("#"), rc);
            }
        } else if (tr != null && tr.getResource() != null) {
            this.generateResourceSummary(c, tr.getResource(), r.getReference().startsWith("#"), r.getReference().startsWith("#"), rc);
        } else {
            c.addText(r.getReference());
        }
    }

    public void renderDateTime(XhtmlNode x, Base e) {
        if (e.hasPrimitiveValue()) {
            x.addText(((DateTimeType)e).toHumanDisplay());
        }
    }

    public void renderPeriod(XhtmlNode x, Period p) {
        x.addText(!p.hasStart() ? "??" : p.getStartElement().toHumanDisplay());
        x.tx(" --> ");
        x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
    }

    private boolean displayLeaf(ResourceWrapper res, BaseWrapper ew, ElementDefinition defn, XhtmlNode x, String name, boolean showCodeDetails, Resolver.ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return false;
        }
        Base e = ew.getBase();
        if (e == null) {
            return false;
        }
        Map<String, String> displayHints = this.readDisplayHints(defn);
        if (name.endsWith("[x]")) {
            name = name.substring(0, name.length() - 3);
        }
        if (!showCodeDetails && e instanceof PrimitiveType && this.isDefault(displayHints, (PrimitiveType)e)) {
            return false;
        }
        if (e instanceof StringType) {
            x.addText(name + ": " + (String)((StringType)e).getValue());
            return true;
        }
        if (e instanceof CodeType) {
            x.addText(name + ": " + (String)((CodeType)e).getValue());
            return true;
        }
        if (e instanceof IdType) {
            x.addText(name + ": " + ((IdType)e).getValue());
            return true;
        }
        if (e instanceof UriType) {
            x.addText(name + ": " + (String)((UriType)e).getValue());
            return true;
        }
        if (e instanceof DateTimeType) {
            x.addText(name + ": " + ((DateTimeType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof InstantType) {
            x.addText(name + ": " + ((InstantType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Extension) {
            return false;
        }
        if (e instanceof DateType) {
            x.addText(name + ": " + ((DateType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Enumeration) {
            x.addText(((Enum)((Enumeration)e).getValue()).toString());
            return true;
        }
        if (e instanceof BooleanType) {
            if (((Boolean)((BooleanType)e).getValue()).booleanValue()) {
                x.addText(name);
                return true;
            }
        } else {
            if (e instanceof CodeableConcept) {
                this.renderCodeableConcept((CodeableConcept)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Coding) {
                this.renderCoding((Coding)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Annotation) {
                this.renderAnnotation((Annotation)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof IntegerType) {
                x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
                return true;
            }
            if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
                return true;
            }
            if (e instanceof Identifier) {
                this.renderIdentifier((Identifier)e, x);
                return true;
            }
            if (e instanceof HumanName) {
                this.renderHumanName((HumanName)e, x);
                return true;
            }
            if (e instanceof SampledData) {
                this.renderSampledData((SampledData)e, x);
                return true;
            }
            if (e instanceof Address) {
                this.renderAddress((Address)e, x);
                return true;
            }
            if (e instanceof ContactPoint) {
                this.renderContactPoint((ContactPoint)e, x);
                return true;
            }
            if (e instanceof Timing) {
                this.renderTiming((Timing)e, x);
                return true;
            }
            if (e instanceof Quantity) {
                this.renderQuantity((Quantity)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Ratio) {
                this.renderQuantity(((Ratio)e).getNumerator(), x, showCodeDetails);
                x.tx("/");
                this.renderQuantity(((Ratio)e).getDenominator(), x, showCodeDetails);
                return true;
            }
            if (e instanceof Period) {
                Period p = (Period)e;
                x.addText(name + ": ");
                x.addText(!p.hasStart() ? "?ngen-2?" : p.getStartElement().toHumanDisplay());
                x.tx(" --> ");
                x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
                return true;
            }
            if (e instanceof Reference) {
                Reference r = (Reference)e;
                if (r.hasDisplayElement()) {
                    x.addText(r.getDisplay());
                } else if (r.hasReferenceElement()) {
                    ResourceWithReference tr = this.resolveReference(res, r.getReference(), rc);
                    x.addText(tr == null ? r.getReference() : "?ngen-3");
                } else {
                    x.tx("?ngen-4?");
                }
                return true;
            }
            if (e instanceof Narrative) {
                return false;
            }
            if (e instanceof Resource) {
                return false;
            }
            if (e instanceof ContactDetail) {
                ContactDetail cd2 = (ContactDetail)e;
                if (cd2.hasName()) {
                    x.tx(cd2.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : cd2.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        x.tx(",");
                    }
                    this.renderContactPoint(c, x);
                }
                return true;
            }
            if (e instanceof Range) {
                return false;
            }
            if (e instanceof Meta) {
                return false;
            }
            if (e instanceof Dosage) {
                return false;
            }
            if (e instanceof Signature) {
                return false;
            }
            if (e instanceof UsageContext) {
                return false;
            }
            if (e instanceof RelatedArtifact) {
                return false;
            }
            if (e instanceof ElementDefinition) {
                return false;
            }
            if (e instanceof Base64BinaryType) {
                return false;
            }
            if (!(e instanceof Attachment)) {
                throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet");
            }
        }
        return false;
    }

    private Map<String, String> readDisplayHints(ElementDefinition defn) throws DefinitionException {
        String displayHint;
        HashMap<String, String> hints = new HashMap<String, String>();
        if (defn != null && !Utilities.noString(displayHint = ToolingExtensions.getDisplayHint(defn))) {
            String[] list;
            for (String item : list = displayHint.split(";")) {
                String[] parts = item.split(":");
                if (parts.length != 2) {
                    throw new DefinitionException("error reading display hint: '" + displayHint + "'");
                }
                hints.put(parts[0].trim(), parts[1].trim());
            }
        }
        return hints;
    }

    public static String displayPeriod(Period p) {
        String s2 = !p.hasStart() ? "?ngen-5?" : p.getStartElement().toHumanDisplay();
        s2 = s2 + " --> ";
        return s2 + (!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
    }

    private void generateResourceSummary(XhtmlNode x, ResourceWrapper res, boolean textAlready, boolean showCodeDetails, Resolver.ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        String path;
        StructureDefinition profile;
        if (!textAlready) {
            XhtmlNode div = res.getNarrative();
            if (div != null) {
                if (div.allChildrenAreText()) {
                    x.getChildNodes().addAll(div.getChildNodes());
                }
                if (div.getChildNodes().size() == 1 && div.getChildNodes().get(0).allChildrenAreText()) {
                    x.getChildNodes().addAll(div.getChildNodes().get(0).getChildNodes());
                }
            }
            x.tx("Generated Summary: ");
        }
        if ((profile = this.context.fetchResource(StructureDefinition.class, path = res.getName())) == null) {
            x.tx("unknown resource " + path);
        } else {
            boolean firstElement = true;
            boolean last = false;
            for (PropertyWrapper p : res.children()) {
                ElementDefinition child = this.getElementDefinition(profile.getSnapshot().getElement(), path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || p.getValues().get(0) == null || child == null || !this.isPrimitive(child) || !this.includeInSummary(child)) continue;
                if (firstElement) {
                    firstElement = false;
                } else if (last) {
                    x.tx("; ");
                }
                boolean first = true;
                last = false;
                for (BaseWrapper v : p.getValues()) {
                    if (first) {
                        first = false;
                    } else if (last) {
                        x.tx(", ");
                    }
                    last = this.displayLeaf(res, v, child, x, p.getName(), showCodeDetails, rc) || last;
                }
            }
        }
    }

    private boolean includeInSummary(ElementDefinition child) {
        String t;
        if (child.getIsModifier()) {
            return true;
        }
        if (child.getMustSupport()) {
            return true;
        }
        return child.getType().size() != 1 || !(t = child.getType().get(0).getWorkingCode()).equals("Address") && !t.equals("Contact") && !t.equals("Reference") && !t.equals("Uri") && !t.equals("Url") && !t.equals("Canonical");
    }

    private ResourceWithReference resolveReference(ResourceWrapper res, String url, Resolver.ResourceContext rc) {
        Object ae;
        if (url == null) {
            return null;
        }
        if (url.startsWith("#")) {
            for (ResourceWrapper r : res.getContained()) {
                if (!r.getId().equals(url.substring(1))) continue;
                return new ResourceWithReference(null, r);
            }
            return null;
        }
        if (rc != null) {
            Bundle.BundleEntryComponent bundleResource = rc.resolve(url);
            if (bundleResource != null) {
                String bundleUrl = "#" + bundleResource.getResource().getResourceType().name().toLowerCase() + "_" + bundleResource.getResource().getId();
                return new ResourceWithReference(bundleUrl, new ResourceWrapperDirect(bundleResource.getResource()));
            }
            org.hl7.fhir.r5.elementmodel.Element bundleElement = rc.resolveElement(url);
            if (bundleElement != null) {
                String bundleUrl = null;
                bundleUrl = bundleElement.getNamedChild("resource").getChildValue("id") != null ? "#" + bundleElement.fhirType().toLowerCase() + "_" + bundleElement.getNamedChild("resource").getChildValue("id") : "#" + this.fullUrlToAnchor(bundleElement.getChildValue("fullUrl"));
                return new ResourceWithReference(bundleUrl, new ResourceWrapperMetaElement(bundleElement));
            }
        }
        if ((ae = this.context.fetchResource(null, url)) != null) {
            return new ResourceWithReference(url, new ResourceWrapperDirect((Resource)ae));
        }
        if (this.resolver != null) {
            return this.resolver.resolve(url);
        }
        return null;
    }

    private String fullUrlToAnchor(String url) {
        return url.replace(":", "").replace("/", "_");
    }

    private void renderCodeableConcept(CodeableConcept cc, XhtmlNode x, boolean showCodeDetails) {
        if (cc.isEmpty()) {
            return;
        }
        String s2 = cc.getText();
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s2 = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCodeElement() && c.hasSystemElement() && !Utilities.noString(s2 = this.lookupCode(c.getSystem(), c.getCode()))) break;
            }
        }
        if (Utilities.noString(s2)) {
            s2 = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        if (showCodeDetails) {
            x.addText(s2 + " ");
            XhtmlNode sp = x.span("background: LightGoldenRodYellow", null);
            sp.tx("(Details ");
            boolean first = true;
            for (Coding c : cc.getCoding()) {
                if (first) {
                    sp.tx(": ");
                    first = false;
                } else {
                    sp.tx("; ");
                }
                sp.tx("{" + TerminologyRenderer.describeSystem(c.getSystem()) + " code '" + c.getCode() + "' = '" + this.lookupCode(c.getSystem(), c.getCode()) + (c.hasDisplay() ? "', given as '" + c.getDisplay() + "'}" : ""));
            }
            sp.tx(")");
        } else {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Coding c : cc.getCoding()) {
                if (!c.hasCodeElement() || !c.hasSystemElement()) continue;
                b.append("{" + c.getSystem() + " " + c.getCode() + "}");
            }
            x.span(null, "Codes: " + b.toString()).addText(s2);
        }
    }

    private void renderAnnotation(Annotation a, XhtmlNode x, boolean showCodeDetails) throws FHIRException {
        StringBuilder s2 = new StringBuilder();
        if (a.hasAuthor()) {
            s2.append("Author: ");
            if (a.hasAuthorReference()) {
                s2.append(a.getAuthorReference().getReference());
            } else if (a.hasAuthorStringType()) {
                s2.append((String)a.getAuthorStringType().getValue());
            }
        }
        if (a.hasTimeElement()) {
            if (s2.length() > 0) {
                s2.append("; ");
            }
            s2.append("Made: ").append(a.getTimeElement().toHumanDisplay());
        }
        if (a.hasText()) {
            if (s2.length() > 0) {
                s2.append("; ");
            }
            s2.append("Annotation: ").append(a.getText());
        }
        x.addText(s2.toString());
    }

    public String describeCoding(List<Coding> list, boolean showCodeDetails) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Coding c : list) {
            b.append(this.describeCoding(c, showCodeDetails));
        }
        return b.toString();
    }

    public String describeCoding(Coding c, boolean showCodeDetails) {
        String s2 = "";
        if (c.hasDisplayElement()) {
            s2 = c.getDisplay();
        }
        if (Utilities.noString(s2)) {
            s2 = this.lookupCode(c.getSystem(), c.getCode());
        }
        if (Utilities.noString(s2)) {
            s2 = c.getCode();
        }
        if (showCodeDetails) {
            return s2 + " (Details: " + TerminologyRenderer.describeSystem(c.getSystem()) + " code " + c.getCode() + " = '" + this.lookupCode(c.getSystem(), c.getCode()) + "', stated as '" + c.getDisplay() + "')";
        }
        return "<span title=\"{" + c.getSystem() + " " + c.getCode() + "}\">" + Utilities.escapeXml(s2) + "</span>";
    }

    private void renderCoding(Coding c, XhtmlNode x, boolean showCodeDetails) {
        String s2 = "";
        if (c.hasDisplayElement()) {
            s2 = c.getDisplay();
        }
        if (Utilities.noString(s2)) {
            s2 = this.lookupCode(c.getSystem(), c.getCode());
        }
        if (Utilities.noString(s2)) {
            s2 = c.getCode();
        }
        if (showCodeDetails) {
            x.addText(s2 + " (Details: " + TerminologyRenderer.describeSystem(c.getSystem()) + " code " + c.getCode() + " = '" + this.lookupCode(c.getSystem(), c.getCode()) + "', stated as '" + c.getDisplay() + "')");
        } else {
            x.span(null, "{" + c.getSystem() + " " + c.getCode() + "}").addText(s2);
        }
    }

    private String lookupCode(String system, String code) {
        IWorkerContext.ValidationResult t = this.context.validateCode(this.terminologyServiceOptions, system, code, null);
        if (t != null && t.getDisplay() != null) {
            return t.getDisplay();
        }
        return code;
    }

    private CodeSystem.ConceptDefinitionComponent findCode(String code, List<CodeSystem.ConceptDefinitionComponent> list) {
        for (CodeSystem.ConceptDefinitionComponent t : list) {
            if (code.equals(t.getCode())) {
                return t;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCode(code, t.getConcept());
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public String displayCodeableConcept(CodeableConcept cc) {
        String s2 = cc.getText();
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s2 = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCode() && c.hasSystem() && !Utilities.noString(s2 = this.lookupCode(c.getSystem(), c.getCode()))) break;
            }
        }
        if (Utilities.noString(s2)) {
            s2 = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        return s2;
    }

    private void renderIdentifier(Identifier ii, XhtmlNode x) {
        x.addText(this.displayIdentifier(ii));
    }

    private void renderTiming(Timing s2, XhtmlNode x) throws FHIRException {
        x.addText(this.displayTiming(s2));
    }

    private void renderQuantity(Quantity q, XhtmlNode x, boolean showCodeDetails) {
        if (q.hasComparator()) {
            x.addText(q.getComparator().toCode());
        }
        x.addText(q.getValue().toString());
        if (q.hasUnit()) {
            x.tx(" " + q.getUnit());
        } else if (q.hasCode()) {
            x.tx(" " + q.getCode());
        }
        if (showCodeDetails && q.hasCode()) {
            x.span("background: LightGoldenRodYellow", null).tx(" (Details: " + TerminologyRenderer.describeSystem(q.getSystem()) + " code " + q.getCode() + " = '" + this.lookupCode(q.getSystem(), q.getCode()) + "')");
        }
    }

    private void renderRange(Range q, XhtmlNode x) {
        if (q.hasLow()) {
            x.addText(q.getLow().getValue().toString());
        } else {
            x.tx("?");
        }
        x.tx("-");
        if (q.hasHigh()) {
            x.addText(q.getHigh().getValue().toString());
        } else {
            x.tx("?");
        }
        if (q.getLow().hasUnit()) {
            x.tx(" " + q.getLow().getUnit());
        }
    }

    public String displayRange(Range q) {
        StringBuilder b = new StringBuilder();
        if (q.hasLow()) {
            b.append(q.getLow().getValue().toString());
        } else {
            b.append("?");
        }
        b.append("-");
        if (q.hasHigh()) {
            b.append(q.getHigh().getValue().toString());
        } else {
            b.append("?");
        }
        if (q.getLow().hasUnit()) {
            b.append(" " + q.getLow().getUnit());
        }
        return b.toString();
    }

    private void renderHumanName(HumanName name, XhtmlNode x) {
        x.addText(NarrativeGenerator.displayHumanName(name));
    }

    private void renderAnnotation(Annotation annot, XhtmlNode x) {
        x.addText(annot.getText());
    }

    private void renderAddress(Address address, XhtmlNode x) {
        x.addText(this.displayAddress(address));
    }

    private void renderContactPoint(ContactPoint contact, XhtmlNode x) {
        x.addText(NarrativeGenerator.displayContactPoint(contact));
    }

    private void renderUri(XhtmlNode x, UriType uri) {
        if (((String)uri.getValue()).startsWith("mailto:")) {
            x.ah((String)uri.getValue()).addText(((String)uri.getValue()).substring(7));
        } else {
            x.ah((String)uri.getValue()).addText((String)uri.getValue());
        }
    }

    private void renderUri(UriType uri, XhtmlNode x, String path, String id) {
        String url = (String)uri.getValue();
        if (this.isCanonical(path)) {
            CanonicalResource mr = (CanonicalResource)this.context.fetchResource(null, url);
            if (mr != null) {
                if (path.startsWith(mr.fhirType() + ".") && mr.getId().equals(id)) {
                    url = null;
                } else if (mr.hasUserData("path")) {
                    url = mr.getUserString("path");
                }
            } else if (!this.canonicalUrlsAsLinks) {
                url = null;
            }
        }
        if (url == null) {
            x.b().tx((String)uri.getValue());
        } else if (((String)uri.getValue()).startsWith("mailto:")) {
            x.ah((String)uri.getValue()).addText(((String)uri.getValue()).substring(7));
        } else {
            x.ah((String)uri.getValue()).addText((String)uri.getValue());
        }
    }

    private boolean isCanonical(String path) {
        if (!path.endsWith(".url")) {
            return false;
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(path.substring(0, path.length() - 4));
        if (sd == null) {
            return false;
        }
        if (Utilities.existsInList(path.substring(0, path.length() - 4), "CapabilityStatement", "StructureDefinition", "ImplementationGuide", "SearchParameter", "MessageDefinition", "OperationDefinition", "CompartmentDefinition", "StructureMap", "GraphDefinition", "ExampleScenario", "CodeSystem", "ValueSet", "ConceptMap", "NamingSystem", "TerminologyCapabilities")) {
            return true;
        }
        return sd.getBaseDefinitionElement().hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-codegen-super");
    }

    private void renderSampledData(SampledData sampledData, XhtmlNode x) {
        x.addText(this.displaySampledData(sampledData));
    }

    private String displaySampledData(SampledData s2) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s2.hasOrigin()) {
            b.append("Origin: " + this.displayQuantity(s2.getOrigin()));
        }
        if (s2.hasPeriod()) {
            b.append("Period: " + s2.getPeriod().toString());
        }
        if (s2.hasFactor()) {
            b.append("Factor: " + s2.getFactor().toString());
        }
        if (s2.hasLowerLimit()) {
            b.append("Lower: " + s2.getLowerLimit().toString());
        }
        if (s2.hasUpperLimit()) {
            b.append("Upper: " + s2.getUpperLimit().toString());
        }
        if (s2.hasDimensions()) {
            b.append("Dimensions: " + s2.getDimensions());
        }
        if (s2.hasData()) {
            b.append("Data: " + s2.getData());
        }
        return b.toString();
    }

    private String displayQuantity(Quantity q) {
        StringBuilder s2 = new StringBuilder();
        s2.append("(system = '").append(TerminologyRenderer.describeSystem(q.getSystem())).append("' code ").append(q.getCode()).append(" = '").append(this.lookupCode(q.getSystem(), q.getCode())).append("')");
        return s2.toString();
    }

    private String displayTiming(Timing s2) throws FHIRException {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s2.hasCode()) {
            b.append("Code: " + this.displayCodeableConcept(s2.getCode()));
        }
        if (s2.getEvent().size() > 0) {
            CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
            for (DateTimeType p : s2.getEvent()) {
                c.append(p.toHumanDisplay());
            }
            b.append("Events: " + c.toString());
        }
        if (s2.hasRepeat()) {
            String st;
            Timing.TimingRepeatComponent rep = s2.getRepeat();
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasStart()) {
                b.append("Starting " + rep.getBoundsPeriod().getStartElement().toHumanDisplay());
            }
            if (rep.hasCount()) {
                b.append("Count " + Integer.toString(rep.getCount()) + " times");
            }
            if (rep.hasDuration()) {
                b.append("Duration " + rep.getDuration().toPlainString() + this.displayTimeUnits(rep.getPeriodUnit()));
            }
            if (rep.hasWhen()) {
                st = "";
                if (rep.hasOffset()) {
                    st = Integer.toString(rep.getOffset()) + "min ";
                }
                b.append("Do " + st);
                for (Enumeration<Timing.EventTiming> wh : rep.getWhen()) {
                    b.append(this.displayEventCode((Timing.EventTiming)((Object)wh.getValue())));
                }
            } else {
                st = "";
                if (!rep.hasFrequency() || !rep.hasFrequencyMax() && rep.getFrequency() == 1) {
                    st = "Once";
                } else {
                    st = Integer.toString(rep.getFrequency());
                    if (rep.hasFrequencyMax()) {
                        st = st + "-" + Integer.toString(rep.getFrequency());
                    }
                }
                if (rep.hasPeriod()) {
                    st = st + " per " + rep.getPeriod().toPlainString();
                    if (rep.hasPeriodMax()) {
                        st = st + "-" + rep.getPeriodMax().toPlainString();
                    }
                    st = st + " " + this.displayTimeUnits(rep.getPeriodUnit());
                }
                b.append("Do " + st);
            }
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasEnd()) {
                b.append("Until " + rep.getBoundsPeriod().getEndElement().toHumanDisplay());
            }
        }
        return b.toString();
    }

    private String displayEventCode(Timing.EventTiming when) {
        switch (when) {
            case C: {
                return "at meals";
            }
            case CD: {
                return "at lunch";
            }
            case CM: {
                return "at breakfast";
            }
            case CV: {
                return "at dinner";
            }
            case AC: {
                return "before meals";
            }
            case ACD: {
                return "before lunch";
            }
            case ACM: {
                return "before breakfast";
            }
            case ACV: {
                return "before dinner";
            }
            case HS: {
                return "before sleeping";
            }
            case PC: {
                return "after meals";
            }
            case PCD: {
                return "after lunch";
            }
            case PCM: {
                return "after breakfast";
            }
            case PCV: {
                return "after dinner";
            }
            case WAKE: {
                return "after waking";
            }
        }
        return "?ngen-6?";
    }

    private String displayTimeUnits(Timing.UnitsOfTime units) {
        if (units == null) {
            return "?ngen-7?";
        }
        switch (units) {
            case A: {
                return "years";
            }
            case D: {
                return "days";
            }
            case H: {
                return "hours";
            }
            case MIN: {
                return "minutes";
            }
            case MO: {
                return "months";
            }
            case S: {
                return "seconds";
            }
            case WK: {
                return "weeks";
            }
        }
        return "?ngen-8?";
    }

    public static String displayHumanName(HumanName name) {
        StringBuilder s2 = new StringBuilder();
        if (name.hasText()) {
            s2.append(name.getText());
        } else {
            for (StringType p : name.getGiven()) {
                s2.append((String)p.getValue());
                s2.append(" ");
            }
            if (name.hasFamily()) {
                s2.append(name.getFamily());
                s2.append(" ");
            }
        }
        if (name.hasUse() && name.getUse() != HumanName.NameUse.USUAL) {
            s2.append("(" + name.getUse().toString() + ")");
        }
        return s2.toString();
    }

    private String displayAddress(Address address) {
        StringBuilder s2 = new StringBuilder();
        if (address.hasText()) {
            s2.append(address.getText());
        } else {
            for (StringType p : address.getLine()) {
                s2.append((String)p.getValue());
                s2.append(" ");
            }
            if (address.hasCity()) {
                s2.append(address.getCity());
                s2.append(" ");
            }
            if (address.hasState()) {
                s2.append(address.getState());
                s2.append(" ");
            }
            if (address.hasPostalCode()) {
                s2.append(address.getPostalCode());
                s2.append(" ");
            }
            if (address.hasCountry()) {
                s2.append(address.getCountry());
                s2.append(" ");
            }
        }
        if (address.hasUse()) {
            s2.append("(" + address.getUse().toString() + ")");
        }
        return s2.toString();
    }

    public static String displayContactPoint(ContactPoint contact) {
        StringBuilder s2 = new StringBuilder();
        s2.append(NarrativeGenerator.describeSystem(contact.getSystem()));
        if (Utilities.noString(contact.getValue())) {
            s2.append("-unknown-");
        } else {
            s2.append(contact.getValue());
        }
        if (contact.hasUse()) {
            s2.append("(" + contact.getUse().toString() + ")");
        }
        return s2.toString();
    }

    private static String describeSystem(ContactPoint.ContactPointSystem system) {
        if (system == null) {
            return "";
        }
        switch (system) {
            case PHONE: {
                return "ph: ";
            }
            case FAX: {
                return "fax: ";
            }
        }
        return "";
    }

    private String displayIdentifier(Identifier ii) {
        String s2;
        String string = s2 = Utilities.noString(ii.getValue()) ? "?ngen-9?" : ii.getValue();
        if (ii.hasType()) {
            if (ii.getType().hasText()) {
                s2 = ii.getType().getText() + " = " + s2;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasDisplay()) {
                s2 = ii.getType().getCoding().get(0).getDisplay() + " = " + s2;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasCode()) {
                s2 = this.lookupCode(ii.getType().getCoding().get(0).getSystem(), ii.getType().getCoding().get(0).getCode()) + " = " + s2;
            }
        }
        if (ii.hasUse()) {
            s2 = s2 + " (" + ii.getUse().toString() + ")";
        }
        return s2;
    }

    private List<ElementDefinition> getChildrenForPath(List<ElementDefinition> elements, String path) throws DefinitionException {
        for (ElementDefinition e : elements) {
            if (!e.getPath().equals(path) || !e.hasContentReference()) continue;
            String ref = e.getContentReference();
            ElementDefinition t = null;
            for (ElementDefinition e1 : elements) {
                if (!ref.equals("#" + e1.getId())) continue;
                t = e1;
            }
            if (t == null) {
                throw new DefinitionException("Unable to resolve content reference " + ref + " trying to resolve " + path);
            }
            path = t.getPath();
            break;
        }
        ArrayList<ElementDefinition> results = new ArrayList<ElementDefinition>();
        for (ElementDefinition e : elements) {
            if (!e.getPath().startsWith(path + ".") || e.getPath().substring(path.length() + 1).contains(".")) continue;
            results.add(e);
        }
        return results;
    }

    public boolean generate(Resolver.ResourceContext rcontext, ConceptMap cm) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        ConceptMapRenderer renderer = new ConceptMapRenderer(new RenderingContext(this.context, this.markdown, this.terminologyServiceOptions, this.prefix, null, RenderingContext.ResourceRendererMode.RESOURCE), rcontext);
        boolean res = renderer.render(x, cm);
        this.inject(cm, x, Narrative.NarrativeStatus.GENERATED);
        return res;
    }

    private void inject(DomainResource r, XhtmlNode x, Narrative.NarrativeStatus status) {
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        if (r.hasLanguage()) {
            x.setAttribute("lang", r.getLanguage());
            x.setAttribute("xml:lang", r.getLanguage());
        }
        if (!r.hasText() || !r.getText().hasDiv() || r.getText().getDiv().getChildNodes().isEmpty()) {
            r.setText(new Narrative());
            r.getText().setDiv(x);
            r.getText().setStatus(status);
        } else {
            XhtmlNode n = r.getText().getDiv();
            n.hr();
            n.getChildNodes().addAll(x.getChildNodes());
        }
    }

    public Element getNarrative(Element er) {
        Element txt = XMLUtil.getNamedChild(er, "text");
        if (txt == null) {
            return null;
        }
        return XMLUtil.getNamedChild(txt, "div");
    }

    public void inject(Element er, XhtmlNode x, Narrative.NarrativeStatus status) {
        Element st;
        Element txt;
        Element le;
        String l;
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        String string = l = (le = XMLUtil.getNamedChild(er, "language")) == null ? null : le.getAttribute("value");
        if (!Utilities.noString(l)) {
            x.setAttribute("lang", l);
            x.setAttribute("xml:lang", l);
        }
        if ((txt = XMLUtil.getNamedChild(er, "text")) == null) {
            txt = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "text");
            Element n = XMLUtil.getFirstChild(er);
            while (n != null && (n.getNodeName().equals("id") || n.getNodeName().equals("meta") || n.getNodeName().equals("implicitRules") || n.getNodeName().equals("language"))) {
                n = XMLUtil.getNextSibling(n);
            }
            if (n == null) {
                er.appendChild(txt);
            } else {
                er.insertBefore(txt, n);
            }
        }
        if ((st = XMLUtil.getNamedChild(txt, "status")) == null) {
            st = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "status");
            Element n = XMLUtil.getFirstChild(txt);
            if (n == null) {
                txt.appendChild(st);
            } else {
                txt.insertBefore(st, n);
            }
        }
        st.setAttribute("value", status.toCode());
        Element div = XMLUtil.getNamedChild(txt, "div");
        if (div == null) {
            div = er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "div");
            div.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            txt.appendChild(div);
        }
        if (div.hasChildNodes()) {
            div.appendChild(er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "hr"));
        }
        new XhtmlComposer(true, this.pretty).compose(div, x);
    }

    public void inject(org.hl7.fhir.r5.elementmodel.Element er, XhtmlNode x, Narrative.NarrativeStatus status) throws IOException, FHIRException {
        org.hl7.fhir.r5.elementmodel.Element st;
        org.hl7.fhir.r5.elementmodel.Element txt;
        String l;
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        if (!Utilities.noString(l = er.getChildValue("language"))) {
            x.setAttribute("lang", l);
            x.setAttribute("xml:lang", l);
        }
        if ((txt = er.getNamedChild("text")) == null) {
            int i;
            txt = new org.hl7.fhir.r5.elementmodel.Element("text", er.getProperty().getChild(null, "text"));
            for (i = 0; i < er.getChildren().size() && (er.getChildren().get(i).getName().equals("id") || er.getChildren().get(i).getName().equals("meta") || er.getChildren().get(i).getName().equals("implicitRules") || er.getChildren().get(i).getName().equals("language")); ++i) {
            }
            if (i >= er.getChildren().size()) {
                er.getChildren().add(txt);
            } else {
                er.getChildren().add(i, txt);
            }
        }
        if ((st = txt.getNamedChild("status")) == null) {
            st = new org.hl7.fhir.r5.elementmodel.Element("status", txt.getProperty().getChild(null, "status"));
            txt.getChildren().add(0, st);
        }
        st.setValue(status.toCode());
        org.hl7.fhir.r5.elementmodel.Element div = txt.getNamedChild("div");
        if (div == null) {
            div = new org.hl7.fhir.r5.elementmodel.Element("div", txt.getProperty().getChild(null, "div"));
            txt.getChildren().add(div);
            div.setValue(new XhtmlComposer(true, this.pretty).compose(x));
        }
        div.setValue(x.toString());
        div.setXhtml(x);
    }

    public boolean generate(Resolver.ResourceContext rcontext, CodeSystem cs, boolean header, String lang) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        CodeSystemRenderer renderer = new CodeSystemRenderer(new RenderingContext(this.context, this.markdown, this.terminologyServiceOptions, this.prefix, lang, RenderingContext.ResourceRendererMode.RESOURCE), rcontext);
        renderer.getCodeSystemPropList().addAll(this.getCodeSystemPropList());
        renderer.getContext().setHeaderLevelContext(this.headerLevelContext);
        renderer.getContext().setTerminologyServiceOptions(this.terminologyServiceOptions);
        boolean hasExtensions = renderer.render(x, cs, header);
        this.inject(cs, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public boolean generate(Resolver.ResourceContext rcontext, ValueSet vs, boolean header) throws FHIRException, IOException {
        this.generate(rcontext, vs, null, header);
        return true;
    }

    public void generate(Resolver.ResourceContext rcontext, ValueSet vs, ValueSet src, boolean header) throws FHIRException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        ValueSetRenderer renderer = new ValueSetRenderer(new RenderingContext(this.context, this.markdown, this.terminologyServiceOptions, this.prefix, null, RenderingContext.ResourceRendererMode.RESOURCE), rcontext);
        renderer.getContext().setTooCostlyNoteEmpty(this.tooCostlyNoteEmpty);
        renderer.getContext().setTooCostlyNoteNotEmpty(this.tooCostlyNoteNotEmpty);
        renderer.getContext().setTooCostlyNoteEmptyDependent(this.tooCostlyNoteEmptyDependent);
        renderer.getContext().setTooCostlyNoteNotEmptyDependent(this.tooCostlyNoteNotEmptyDependent);
        renderer.setNoSlowLookup(this.noSlowLookup);
        renderer.getContext().setHeaderLevelContext(this.headerLevelContext);
        renderer.getContext().setTerminologyServiceOptions(this.terminologyServiceOptions);
        boolean hasExtensions = renderer.render(x, vs, header);
        this.inject(vs, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    public boolean generate(Resolver.ResourceContext rcontext, OperationOutcome op) throws DefinitionException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasSource = false;
        boolean success = true;
        for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
            success = success && i.getSeverity() == OperationOutcome.IssueSeverity.INFORMATION;
            hasSource = hasSource || ExtensionHelper.hasExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
        }
        if (success) {
            x.para().tx("All OK");
        }
        if (op.getIssue().size() > 0) {
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx("Severity");
            tr.td().b().tx("Location");
            tr.td().b().tx("Code");
            tr.td().b().tx("Details");
            tr.td().b().tx("Diagnostics");
            if (hasSource) {
                tr.td().b().tx("Source");
            }
            for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
                tr = tbl.tr();
                tr.td().addText(i.getSeverity().toString());
                XhtmlNode td = tr.td();
                boolean d = false;
                for (StringType s2 : i.getLocation()) {
                    if (d) {
                        td.tx(", ");
                    } else {
                        d = true;
                    }
                    td.addText((String)s2.getValue());
                }
                tr.td().addText(i.getCode().getDisplay());
                tr.td().addText(this.gen(i.getDetails()));
                this.smartAddText(tr.td(), i.getDiagnostics());
                if (!hasSource) continue;
                Extension ext = ExtensionHelper.getExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
                tr.td().addText(ext == null ? "" : this.gen(ext));
            }
        }
        this.inject(op, x, hasSource ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public String genType(DataType type) throws DefinitionException {
        if (type instanceof Coding) {
            return this.gen((Coding)type);
        }
        if (type instanceof CodeableConcept) {
            return this.displayCodeableConcept((CodeableConcept)type);
        }
        if (type instanceof Quantity) {
            return this.displayQuantity((Quantity)type);
        }
        if (type instanceof Range) {
            return this.displayRange((Range)type);
        }
        return null;
    }

    private String gen(Extension extension) throws DefinitionException {
        if (extension.getValue() instanceof CodeType) {
            return (String)((CodeType)extension.getValue()).getValue();
        }
        if (extension.getValue() instanceof Coding) {
            return this.gen((Coding)extension.getValue());
        }
        throw new DefinitionException("Unhandled type " + extension.getValue().getClass().getName());
    }

    public String gen(Reference ref) {
        if (ref == null) {
            return null;
        }
        if (ref.hasDisplay()) {
            return ref.getDisplay();
        }
        if (ref.hasReference()) {
            return ref.getReference();
        }
        if (ref.hasIdentifier()) {
            return this.displayIdentifier(ref.getIdentifier());
        }
        return "?ngen-15?";
    }

    public String gen(CodeableConcept code) {
        if (code == null) {
            return null;
        }
        if (code.hasText()) {
            return code.getText();
        }
        if (code.hasCoding()) {
            return this.gen(code.getCoding().get(0));
        }
        return null;
    }

    public String gen(Coding code) {
        if (code == null) {
            return null;
        }
        if (code.hasDisplayElement()) {
            return code.getDisplay();
        }
        if (code.hasCodeElement()) {
            return code.getCode();
        }
        return null;
    }

    public boolean generate(Resolver.ResourceContext rcontext, StructureDefinition sd, Set<String> outputTracker) throws EOperationOutcome, FHIRException, IOException {
        ProfileUtilities pu = new ProfileUtilities(this.context, null, this.pkp);
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.getChildNodes().add(pu.generateTable(this.definitionsTarget, sd, true, this.destDir, false, sd.getId(), false, this.corePath, "", false, false, outputTracker, false));
        this.inject(sd, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public boolean generate(Resolver.ResourceContext rcontext, ListResource list) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        if (list.hasTitle()) {
            x.h2().tx(list.getTitle());
        }
        XhtmlNode t = x.table("clstu");
        XhtmlNode tr = t.tr();
        if (list.hasDate()) {
            tr.td().tx("Date: " + list.getDate().toLocaleString());
        }
        if (list.hasMode()) {
            tr.td().tx("Mode: " + list.getMode().getDisplay());
        }
        if (list.hasStatus()) {
            tr.td().tx("Status: " + list.getStatus().getDisplay());
        }
        if (list.hasCode()) {
            tr.td().tx("Code: " + this.gen(list.getCode()));
        }
        tr = t.tr();
        if (list.hasSubject()) {
            this.shortForRef(tr.td().tx("Subject: "), list.getSubject());
        }
        if (list.hasEncounter()) {
            this.shortForRef(tr.td().tx("Encounter: "), list.getEncounter());
        }
        if (list.hasSource()) {
            this.shortForRef(tr.td().tx("Source: "), list.getEncounter());
        }
        if (list.hasOrderedBy()) {
            tr.td().tx("Order: " + this.gen(list.getOrderedBy()));
        }
        for (Annotation a : list.getNote()) {
            this.renderAnnotation(a, x);
        }
        boolean flag = false;
        boolean deleted = false;
        boolean date = false;
        for (ListResource.ListResourceEntryComponent e : list.getEntry()) {
            flag = flag || e.hasFlag();
            deleted = deleted || e.hasDeleted();
            date = date || e.hasDate();
        }
        t = x.table("grid");
        tr = t.tr().style("backgound-color: #eeeeee");
        tr.td().b().tx("Items");
        if (date) {
            tr.td().tx("Date");
        }
        if (flag) {
            tr.td().tx("Flag");
        }
        if (deleted) {
            tr.td().tx("Deleted");
        }
        for (ListResource.ListResourceEntryComponent e : list.getEntry()) {
            tr = t.tr();
            this.shortForRef(tr.td(), e.getItem());
            if (date) {
                tr.td().tx(e.hasDate() ? e.getDate().toLocaleString() : "");
            }
            if (flag) {
                tr.td().tx(e.hasFlag() ? this.gen(e.getFlag()) : "");
            }
            if (!deleted) continue;
            tr.td().tx(e.hasDeleted() ? Boolean.toString(e.getDeleted()) : "");
        }
        this.inject(list, x, Narrative.NarrativeStatus.GENERATED);
        return false;
    }

    public boolean generateList(XhtmlNode x, ResourceWrapper list) throws EOperationOutcome, FHIRException, IOException {
        if (list.has("title")) {
            x.h2().tx(list.get("title").primitiveValue());
        }
        XhtmlNode t = x.table("clstu");
        XhtmlNode tr = t.tr();
        XhtmlNode td = tr.td();
        if (list.has("date")) {
            td.tx("Date: " + list.get("date").dateTimeValue().toHumanDisplay());
        }
        if (list.has("mode")) {
            td.tx("Mode: " + list.get("mode").primitiveValue());
        }
        if (list.has("status")) {
            td.tx("Status: " + list.get("status").primitiveValue());
        }
        if (list.has("code")) {
            td.tx("Code: " + this.genCC(list.get("code")));
        }
        tr = t.tr();
        if (list.has("subject")) {
            td.tx("Subject: ");
            this.shortForRef(td, list.get("subject"));
        }
        if (list.has("encounter")) {
            this.shortForRef(td.tx("Encounter: "), list.get("encounter"));
        }
        if (list.has("source")) {
            td.tx("Source: ");
            this.shortForRef(td, list.get("encounter"));
        }
        if (list.has("orderedBy")) {
            td.tx("Order: " + this.genCC(list.get("orderedBy")));
        }
        boolean flag = false;
        boolean deleted = false;
        boolean date = false;
        for (BaseWrapper e : list.children("entry")) {
            flag = flag || e.has("flag");
            deleted = deleted || e.has("deleted");
            date = date || e.has("date");
        }
        t = x.table("grid");
        tr = t.tr().style("backgound-color: #eeeeee");
        td.b().tx("Items");
        if (date) {
            td.tx("Date");
        }
        if (flag) {
            td.tx("Flag");
        }
        if (deleted) {
            td.tx("Deleted");
        }
        for (BaseWrapper e : list.children("entry")) {
            tr = t.tr();
            this.shortForRef(td, e.get("item"));
            if (date) {
                td.tx(e.has("date") ? e.get("date").dateTimeValue().toHumanDisplay() : "");
            }
            if (flag) {
                td.tx(e.has("flag") ? this.genCC(e.get("flag")) : "");
            }
            if (!deleted) continue;
            td.tx(e.has("deleted") ? e.get("deleted").primitiveValue() : "");
        }
        return false;
    }

    private String genCC(Base base) {
        if (base instanceof org.hl7.fhir.r5.elementmodel.Element) {
            CodeableConcept cc = ObjectConverter.readAsCodeableConcept((org.hl7.fhir.r5.elementmodel.Element)base);
            return this.gen(cc);
        }
        if (base instanceof CodeableConcept) {
            return this.gen((CodeableConcept)base);
        }
        return "todo";
    }

    private void shortForRef(XhtmlNode x, Reference ref) {
        ResourceWithReference r = this.resolver.resolve(ref.getReference());
        if (r == null) {
            x.tx(this.gen(ref));
        } else {
            r.resource.display(x.ah(r.reference));
        }
    }

    private XhtmlNode shortForRef(XhtmlNode x, Base ref) {
        if (ref == null) {
            x.tx("(null)");
        } else {
            String disp;
            String string = disp = ref.getChildByName("display") != null && ref.getChildByName("display").hasValues() ? ref.getChildByName("display").getValues().get(0).primitiveValue() : null;
            if (ref.getChildByName("reference").hasValues()) {
                String url = ref.getChildByName("reference").getValues().get(0).primitiveValue();
                ResourceWithReference r = this.resolver.resolve(url);
                if (r == null) {
                    if (disp == null) {
                        disp = url;
                    }
                    x.tx(disp);
                } else {
                    r.resource.display(x.ah(r.reference));
                }
            } else if (disp != null) {
                x.tx(disp);
            } else {
                x.tx("?ngen-16?");
            }
        }
        return x;
    }

    public boolean generate(Resolver.ResourceContext rcontext, ImplementationGuide ig) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.h2().addText(ig.getName());
        x.para().tx("The official URL for this implementation guide is: ");
        x.pre().tx(ig.getUrl());
        this.addMarkdown(x, ig.getDescription());
        this.inject(ig, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public boolean generate(Resolver.ResourceContext rcontext, OperationDefinition opd) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.h2().addText(opd.getName());
        x.para().addText(Utilities.capitalize(opd.getKind().toString()) + ": " + opd.getName());
        x.para().tx("The official URL for this operation definition is: ");
        x.pre().tx(opd.getUrl());
        this.addMarkdown(x, opd.getDescription());
        if (opd.getSystem()) {
            x.para().tx("URL: [base]/$" + opd.getCode());
        }
        for (CodeType c : opd.getResource()) {
            if (opd.getType()) {
                x.para().tx("URL: [base]/" + (String)c.getValue() + "/$" + opd.getCode());
            }
            if (!opd.getInstance()) continue;
            x.para().tx("URL: [base]/" + (String)c.getValue() + "/[id]/$" + opd.getCode());
        }
        x.para().tx("Parameters");
        XhtmlNode tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx("Use");
        tr.td().b().tx("Name");
        tr.td().b().tx("Cardinality");
        tr.td().b().tx("Type");
        tr.td().b().tx("Binding");
        tr.td().b().tx("Documentation");
        for (OperationDefinition.OperationDefinitionParameterComponent p : opd.getParameter()) {
            this.genOpParam(rcontext, tbl, "", p);
        }
        this.addMarkdown(x, opd.getComment());
        this.inject(opd, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    private void genOpParam(Resolver.ResourceContext rcontext, XhtmlNode tbl, String path, OperationDefinition.OperationDefinitionParameterComponent p) throws EOperationOutcome, FHIRException, IOException {
        StructureDefinition sd;
        XhtmlNode tr = tbl.tr();
        tr.td().addText(p.getUse().toString());
        tr.td().addText(path + p.getName());
        tr.td().addText(Integer.toString(p.getMin()) + ".." + p.getMax());
        XhtmlNode td = tr.td();
        StructureDefinition structureDefinition = sd = p.getType() != null ? this.context.fetchTypeDefinition(p.getType().toCode()) : null;
        if (sd == null) {
            td.tx(p.hasType() ? p.getType().toCode() : "");
        } else if (sd.getAbstract() && p.hasExtension("http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type")) {
            boolean first = true;
            for (Extension ex : p.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(" | ");
                }
                String s2 = ex.getValue().primitiveValue();
                StructureDefinition sdt = this.context.fetchTypeDefinition(s2);
                if (sdt == null) {
                    td.tx(p.hasType() ? p.getType().toCode() : "");
                    continue;
                }
                td.ah(sdt.getUserString("path")).tx(s2);
            }
        } else {
            td.ah(sd.getUserString("path")).tx(p.hasType() ? p.getType().toCode() : "");
        }
        if (p.hasSearchType()) {
            td.br();
            td.tx("(");
            td.ah(this.corePath == null ? "search.html#" + p.getSearchType().toCode() : Utilities.pathURL(this.corePath, "search.html#" + p.getSearchType().toCode())).tx(p.getSearchType().toCode());
            td.tx(")");
        }
        td = tr.td();
        if (p.hasBinding() && p.getBinding().hasValueSet()) {
            this.AddVsRef(rcontext, p.getBinding().getValueSet(), td);
            td.tx(" (" + p.getBinding().getStrength().getDisplay() + ")");
        }
        this.addMarkdown(tr.td(), p.getDocumentation());
        if (!p.hasType()) {
            for (OperationDefinition.OperationDefinitionParameterComponent pp : p.getPart()) {
                this.genOpParam(rcontext, tbl, path + p.getName() + ".", pp);
            }
        }
    }

    protected void AddVsRef(Resolver.ResourceContext rcontext, String value, XhtmlNode li) {
        Bundle.BundleEntryComponent be;
        Resource res = null;
        if (rcontext != null && (be = rcontext.resolve(value)) != null) {
            res = be.getResource();
        }
        if (res != null && !(res instanceof CanonicalResource)) {
            li.addText(value);
            return;
        }
        CanonicalResource vs = (CanonicalResource)res;
        if (vs == null) {
            vs = this.context.fetchResource(ValueSet.class, value);
        }
        if (vs == null) {
            vs = this.context.fetchResource(StructureDefinition.class, value);
        }
        if (vs == null) {
            vs = this.context.fetchResource(Questionnaire.class, value);
        }
        if (vs != null) {
            String ref = (String)vs.getUserData("path");
            XhtmlNode a = li.ah((ref = this.adjustForPath(ref)) == null ? "?ngen-11?" : ref.replace("\\", "/"));
            a.addText(value);
        } else {
            CodeSystem cs = this.context.fetchCodeSystem(value);
            if (cs != null) {
                String ref = (String)cs.getUserData("path");
                XhtmlNode a = li.ah((ref = this.adjustForPath(ref)) == null ? "?ngen-12?" : ref.replace("\\", "/"));
                a.addText(value);
            } else if (value.equals("http://snomed.info/sct") || value.equals("http://snomed.info/id")) {
                XhtmlNode a = li.ah(value);
                a.tx("SNOMED-CT");
            } else {
                if (value.startsWith("http://hl7.org") && !Utilities.existsInList(value, "http://hl7.org/fhir/sid/icd-10-us")) {
                    System.out.println("Unable to resolve value set " + value);
                }
                li.addText(value);
            }
        }
    }

    private String adjustForPath(String ref) {
        if (this.prefix == null) {
            return ref;
        }
        return this.prefix + ref;
    }

    private void addMarkdown(XhtmlNode x, String text) throws FHIRFormatError, IOException, DefinitionException {
        if (text != null) {
            XhtmlDocument m3;
            while (text.contains("[[[")) {
                String left = text.substring(0, text.indexOf("[[["));
                String link = text.substring(text.indexOf("[[[") + 3, text.indexOf("]]]"));
                String right = text.substring(text.indexOf("]]]") + 3);
                String url = link;
                String[] parts = link.split("\\#");
                StructureDefinition p = this.context.fetchResource(StructureDefinition.class, parts[0]);
                if (p == null) {
                    p = this.context.fetchTypeDefinition(parts[0]);
                }
                if (p == null) {
                    p = this.context.fetchResource(StructureDefinition.class, link);
                }
                if (p != null) {
                    url = p.getUserString("path");
                    if (url == null) {
                        url = p.getUserString("filename");
                    }
                } else {
                    throw new DefinitionException("Unable to resolve markdown link " + link);
                }
                text = left + "[" + link + "](" + url + ")" + right;
            }
            String s2 = this.markdown.process(Utilities.escapeXml(text), "narrative generator");
            XhtmlParser p = new XhtmlParser();
            try {
                m3 = p.parse("<div>" + s2 + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), e);
            }
            x.getChildNodes().addAll(m3.getChildNodes());
        }
    }

    public boolean generate(Resolver.ResourceContext rcontext, CompartmentDefinition cpd) {
        StringBuilder in = new StringBuilder();
        StringBuilder out = new StringBuilder();
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent cc : cpd.getResource()) {
            CommaSeparatedStringBuilder rules = new CommaSeparatedStringBuilder();
            if (!cc.hasParam()) {
                out.append(" <li><a href=\"").append(cc.getCode().toLowerCase()).append(".html\">").append(cc.getCode()).append("</a></li>\r\n");
                continue;
            }
            if (rules.equals("{def}")) continue;
            for (StringType p : cc.getParam()) {
                rules.append(p.asStringValue());
            }
            in.append(" <tr><td><a href=\"").append(cc.getCode().toLowerCase()).append(".html\">").append(cc.getCode()).append("</a></td><td>").append(rules.toString()).append("</td></tr>\r\n");
        }
        try {
            XhtmlNode x = new XhtmlParser().parseFragment("<div><p>\r\nThe following resources may be in this compartment:\r\n</p>\r\n<table class=\"grid\">\r\n <tr><td><b>Resource</b></td><td><b>Inclusion Criteria</b></td></tr>\r\n" + in.toString() + "</table>\r\n<p>\r\nA resource is in this compartment if the nominated search parameter (or chain) refers to the patient resource that defines the compartment.\r\n</p>\r\n<p>\r\n\r\n</p>\r\n<p>\r\nThe following resources are never in this compartment:\r\n</p>\r\n<ul>\r\n" + out.toString() + "</ul></div>\r\n");
            this.inject(cpd, x, Narrative.NarrativeStatus.GENERATED);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean generate(Resolver.ResourceContext rcontext, CapabilityStatement conf) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.h2().addText(conf.getName());
        this.addMarkdown(x, conf.getDescription());
        if (conf.getRest().size() > 0) {
            CapabilityStatement.CapabilityStatementRestComponent rest = conf.getRest().get(0);
            XhtmlNode t = x.table(null);
            this.addTableRow(t, "Mode", rest.getMode().toString());
            this.addTableRow(t, "Description", rest.getDocumentation());
            this.addTableRow(t, "Transaction", this.showOp(rest, CapabilityStatement.SystemRestfulInteraction.TRANSACTION));
            this.addTableRow(t, "System History", this.showOp(rest, CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM));
            this.addTableRow(t, "System Search", this.showOp(rest, CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM));
            boolean hasVRead = false;
            boolean hasPatch = false;
            boolean hasDelete = false;
            boolean hasHistory = false;
            boolean hasUpdates = false;
            for (CapabilityStatement.CapabilityStatementRestResourceComponent r : rest.getResource()) {
                hasVRead = hasVRead || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.VREAD);
                hasPatch = hasPatch || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.PATCH);
                hasDelete = hasDelete || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.DELETE);
                hasHistory = hasHistory || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                hasUpdates = hasUpdates || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
            }
            t = x.table(null);
            XhtmlNode tr = t.tr();
            tr.th().b().tx("Resource Type");
            tr.th().b().tx("Profile");
            tr.th().b().attribute("title", "GET a resource (read interaction)").tx("Read");
            if (hasVRead) {
                tr.th().b().attribute("title", "GET past versions of resources (vread interaction)").tx("V-Read");
            }
            tr.th().b().attribute("title", "GET all set of resources of the type (search interaction)").tx("Search");
            tr.th().b().attribute("title", "PUT a new resource version (update interaction)").tx("Update");
            if (hasPatch) {
                tr.th().b().attribute("title", "PATCH a new resource version (patch interaction)").tx("Patch");
            }
            tr.th().b().attribute("title", "POST a new resource (create interaction)").tx("Create");
            if (hasDelete) {
                tr.th().b().attribute("title", "DELETE a resource (delete interaction)").tx("Delete");
            }
            if (hasUpdates) {
                tr.th().b().attribute("title", "GET changes to a resource (history interaction on instance)").tx("Updates");
            }
            if (hasHistory) {
                tr.th().b().attribute("title", "GET changes for all resources of the type (history interaction on type)").tx("History");
            }
            for (CapabilityStatement.CapabilityStatementRestResourceComponent r : rest.getResource()) {
                tr = t.tr();
                tr.td().addText(r.getType());
                if (r.hasProfile()) {
                    tr.td().ah(this.prefix + r.getProfile()).addText(r.getProfile());
                }
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.READ));
                if (hasVRead) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.VREAD));
                }
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE));
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.UPDATE));
                if (hasPatch) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.PATCH));
                }
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.CREATE));
                if (hasDelete) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.DELETE));
                }
                if (hasUpdates) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE));
                }
                if (!hasHistory) continue;
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE));
            }
        }
        this.inject(conf, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    private boolean hasOp(CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.TypeRestfulInteraction on) {
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return true;
        }
        return false;
    }

    private String showOp(CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.TypeRestfulInteraction on) {
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private String showOp(CapabilityStatement.CapabilityStatementRestComponent r, CapabilityStatement.SystemRestfulInteraction on) {
        for (CapabilityStatement.SystemInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private void addTableRow(XhtmlNode t, String name, String value) {
        XhtmlNode tr = t.tr();
        tr.td().addText(name);
        tr.td().addText(value);
    }

    public XhtmlNode generateDocumentNarrative(Bundle feed) {
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        Composition comp = (Composition)feed.getEntry().get(0).getResource();
        root.getChildNodes().add(comp.getText().getDiv());
        Resource subject = ResourceUtilities.getById(feed, null, comp.getSubject().getReference());
        if (subject != null && subject instanceof DomainResource) {
            root.hr();
            root.getChildNodes().add(((DomainResource)subject).getText().getDiv());
        }
        List<Composition.SectionComponent> sections = comp.getSection();
        this.renderSections(feed, root, sections, 1);
        return root;
    }

    private void renderSections(Bundle feed, XhtmlNode node, List<Composition.SectionComponent> sections, int level) {
        for (Composition.SectionComponent section : sections) {
            node.hr();
            if (!section.hasTitleElement()) continue;
            node.addTag("h" + Integer.toString(level)).addText(section.getTitle());
        }
    }

    public XhtmlNode generateDiagnosticReport(ResourceWrapper dr) {
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode h2 = root.h2();
        this.displayCodeableConcept(h2, this.getProperty(dr, "code").value());
        h2.tx(" ");
        PropertyWrapper pw = this.getProperty(dr, "category");
        if (this.valued(pw)) {
            h2.tx("(");
            this.displayCodeableConcept(h2, pw.value());
            h2.tx(") ");
        }
        this.displayDate(h2, this.getProperty(dr, "issued").value());
        XhtmlNode tbl = root.table("grid");
        XhtmlNode tr = tbl.tr();
        XhtmlNode tdl = tr.td();
        XhtmlNode tdr = tr.td();
        this.populateSubjectSummary(tdl, this.getProperty(dr, "subject").value());
        tdr.b().tx("Report Details");
        tdr.br();
        pw = this.getProperty(dr, "perfomer");
        if (this.valued(pw)) {
            tdr.addText(this.pluralise("Performer", pw.getValues().size()) + ":");
            for (BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.displayReference(tdr, v);
            }
            tdr.br();
        }
        if (this.valued(pw = this.getProperty(dr, "identifier"))) {
            tdr.addText(this.pluralise("Identifier", pw.getValues().size()) + ":");
            for (BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.displayIdentifier(tdr, v);
            }
            tdr.br();
        }
        if (this.valued(pw = this.getProperty(dr, "request"))) {
            tdr.addText(this.pluralise("Request", pw.getValues().size()) + ":");
            for (BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.displayReferenceId(tdr, v);
            }
            tdr.br();
        }
        if (this.valued(pw = this.getProperty(dr, "result"))) {
            List<ObservationNode> observations = this.fetchObservations(pw.getValues());
            this.buildObservationsTable(root, observations);
        }
        if (this.valued(pw = this.getProperty(dr, "conclusion"))) {
            this.displayText(root.para(), pw.value());
        }
        if (this.valued(pw = this.getProperty(dr, "result"))) {
            XhtmlNode p = root.para();
            p.b().tx("Coded Diagnoses :");
            for (BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.displayCodeableConcept(tdr, v);
            }
        }
        return root;
    }

    private void buildObservationsTable(XhtmlNode root, List<ObservationNode> observations) {
        XhtmlNode tbl = root.table("none");
        for (ObservationNode o : observations) {
            this.addObservationToTable(tbl, o, 0);
        }
    }

    private void addObservationToTable(XhtmlNode tbl, ObservationNode o, int i) {
        XhtmlNode tr = tbl.tr();
        if (o.obs == null) {
            XhtmlNode td = tr.td().colspan("6");
            td.i().tx("This Observation could not be resolved");
        } else {
            this.addObservationToTable(tr, o.obs, i);
        }
        for (ObservationNode c : o.contained) {
            this.addObservationToTable(tbl, c, i + 1);
        }
    }

    private void addObservationToTable(XhtmlNode tr, ResourceWrapper obs, int i) {
        XhtmlNode td = tr.td();
        PropertyWrapper pw = this.getProperty(obs, "result");
        if (this.valued(pw)) {
            this.displayCodeableConcept(td, pw.value());
        }
        if (this.valued(pw = this.getProperty(obs, "bodySite"))) {
            td.tx(" (");
            this.displayCodeableConcept(td, pw.value());
            td.tx(")");
        }
        td = tr.td();
        pw = this.getProperty(obs, "value[x]");
        if (this.valued(pw)) {
            if (pw.getTypeCode().equals("CodeableConcept")) {
                this.displayCodeableConcept(td, pw.value());
            } else if (pw.getTypeCode().equals("string")) {
                this.displayText(td, pw.value());
            } else {
                td.addText(pw.getTypeCode() + " not rendered yet");
            }
        }
        td = tr.td();
        td.tx("to do");
        td = tr.td();
        td.tx("to do");
        td = tr.td();
        td.tx("to do");
        td = tr.td();
        td.tx("to do");
    }

    private boolean valued(PropertyWrapper pw) {
        return pw != null && pw.hasValues();
    }

    private void displayText(XhtmlNode c, BaseWrapper v) {
        c.addText(v.toString());
    }

    private String pluralise(String name, int size) {
        return size == 1 ? name : name + "s";
    }

    private void displayIdentifier(XhtmlNode c, BaseWrapper v) {
        String hint = "";
        PropertyWrapper pw = v.getChildByName("type");
        if (this.valued(pw)) {
            hint = this.genCC(pw.value());
        } else {
            pw = v.getChildByName("system");
            if (this.valued(pw)) {
                hint = pw.value().toString();
            }
        }
        this.displayText(c.span(null, hint), v.getChildByName("value").value());
    }

    private String genCoding(BaseWrapper value) {
        PropertyWrapper pw = value.getChildByName("display");
        if (this.valued(pw)) {
            return pw.value().toString();
        }
        pw = value.getChildByName("code");
        if (this.valued(pw)) {
            return pw.value().toString();
        }
        return "";
    }

    private String genCC(BaseWrapper value) {
        PropertyWrapper pw = value.getChildByName("text");
        if (this.valued(pw)) {
            return pw.value().toString();
        }
        pw = value.getChildByName("coding");
        if (this.valued(pw)) {
            return this.genCoding(pw.getValues().get(0));
        }
        return "";
    }

    private void displayReference(XhtmlNode c, BaseWrapper v) {
        c.tx("to do");
    }

    private void displayDate(XhtmlNode c, BaseWrapper baseWrapper) {
        c.tx("to do");
    }

    private void displayCodeableConcept(XhtmlNode c, BaseWrapper property) {
        c.tx("to do");
    }

    private void displayReferenceId(XhtmlNode c, BaseWrapper v) {
        c.tx("to do");
    }

    private PropertyWrapper getProperty(ResourceWrapper res, String name) {
        for (PropertyWrapper t : res.children()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    private void populateSubjectSummary(XhtmlNode container, BaseWrapper subject) {
        ResourceWrapper r = this.fetchResource(subject);
        if (r == null) {
            container.tx("Unable to get Patient Details");
        } else if (r.getName().equals("Patient")) {
            this.generatePatientSummary(container, r);
        } else {
            container.tx("Not done yet");
        }
    }

    private void generatePatientSummary(XhtmlNode c, ResourceWrapper r) {
        c.tx("to do");
    }

    private ResourceWrapper fetchResource(BaseWrapper subject) {
        if (this.resolver == null) {
            return null;
        }
        String url = subject.getChildByName("reference").value().toString();
        ResourceWithReference rr = this.resolver.resolve(url);
        return rr == null ? null : rr.resource;
    }

    private List<ObservationNode> fetchObservations(List<BaseWrapper> list) {
        return new ArrayList<ObservationNode>();
    }

    public XhtmlNode renderBundle(Bundle b) throws FHIRException {
        if (b.getType() == Bundle.BundleType.DOCUMENT) {
            if (!(b.hasEntry() && b.getEntryFirstRep().hasResource() && b.getEntryFirstRep().getResource() instanceof Composition)) {
                throw new FHIRException("Invalid document - first entry is not a Composition");
            }
            Composition dr = (Composition)b.getEntryFirstRep().getResource();
            return dr.getText().getDiv();
        }
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        root.para().addText("Bundle " + b.getId() + " of type " + b.getType().toCode());
        int i = 0;
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            DomainResource dr;
            ++i;
            if (be.hasFullUrl()) {
                root.an(this.makeInternalLink(be.getFullUrl()));
            }
            if (be.hasResource() && be.getResource().hasId()) {
                root.an(be.getResource().getResourceType().name().toLowerCase() + "_" + be.getResource().getId());
            }
            root.hr();
            root.para().addText("Entry " + Integer.toString(i) + (be.hasFullUrl() ? " - Full URL = " + be.getFullUrl() : ""));
            if (be.hasRequest()) {
                this.renderRequest(root, be.getRequest());
            }
            if (be.hasSearch()) {
                this.renderSearch(root, be.getSearch());
            }
            if (be.hasResponse()) {
                this.renderResponse(root, be.getResponse());
            }
            if (!be.hasResource()) continue;
            root.para().addText("Resource " + be.getResource().fhirType() + ":");
            if (!be.hasResource() || !(be.getResource() instanceof DomainResource) || !(dr = (DomainResource)be.getResource()).getText().hasDiv()) continue;
            root.blockquote().getChildNodes().addAll(this.checkInternalLinks(b, dr.getText().getDiv().getChildNodes()));
        }
        return root;
    }

    private List<XhtmlNode> checkInternalLinks(Bundle b, List<XhtmlNode> childNodes) {
        this.scanNodesForInternalLinks(b, childNodes);
        return childNodes;
    }

    private void scanNodesForInternalLinks(Bundle b, List<XhtmlNode> nodes) {
        for (XhtmlNode n : nodes) {
            if ("a".equals(n.getName()) && n.hasAttribute("href")) {
                this.scanInternalLink(b, n);
            }
            this.scanNodesForInternalLinks(b, n.getChildNodes());
        }
    }

    private void scanInternalLink(Bundle b, XhtmlNode n) {
        boolean fix = false;
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            if (!be.hasFullUrl() || !be.getFullUrl().equals(n.getAttribute("href"))) continue;
            fix = true;
        }
        if (fix) {
            n.setAttribute("href", "#" + this.makeInternalLink(n.getAttribute("href")));
        }
    }

    private String makeInternalLink(String fullUrl) {
        return fullUrl.replace(":", "-");
    }

    private void renderSearch(XhtmlNode root, Bundle.BundleEntrySearchComponent search) {
        StringBuilder b = new StringBuilder();
        b.append("Search: ");
        if (search.hasMode()) {
            b.append("mode = " + search.getMode().toCode());
        }
        if (search.hasScore()) {
            if (search.hasMode()) {
                b.append(",");
            }
            b.append("score = " + search.getScore());
        }
        root.para().addText(b.toString());
    }

    private void renderResponse(XhtmlNode root, Bundle.BundleEntryResponseComponent response) {
        root.para().addText("Request:");
        StringBuilder b = new StringBuilder();
        b.append(response.getStatus() + "\r\n");
        if (response.hasLocation()) {
            b.append("Location: " + response.getLocation() + "\r\n");
        }
        if (response.hasEtag()) {
            b.append("E-Tag: " + response.getEtag() + "\r\n");
        }
        if (response.hasLastModified()) {
            b.append("LastModified: " + response.getEtag() + "\r\n");
        }
        root.pre().addText(b.toString());
    }

    private void renderRequest(XhtmlNode root, Bundle.BundleEntryRequestComponent request) {
        root.para().addText("Response:");
        StringBuilder b = new StringBuilder();
        b.append((Object)((Object)request.getMethod()) + " " + request.getUrl() + "\r\n");
        if (request.hasIfNoneMatch()) {
            b.append("If-None-Match: " + request.getIfNoneMatch() + "\r\n");
        }
        if (request.hasIfModifiedSince()) {
            b.append("If-Modified-Since: " + request.getIfModifiedSince() + "\r\n");
        }
        if (request.hasIfMatch()) {
            b.append("If-Match: " + request.getIfMatch() + "\r\n");
        }
        if (request.hasIfNoneExist()) {
            b.append("If-None-Exist: " + request.getIfNoneExist() + "\r\n");
        }
        root.pre().addText(b.toString());
    }

    public XhtmlNode renderBundle(org.hl7.fhir.r5.elementmodel.Element element) throws FHIRException {
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        for (Base b : element.listChildrenByName("entry")) {
            org.hl7.fhir.r5.elementmodel.Element be = (org.hl7.fhir.r5.elementmodel.Element)b;
            org.hl7.fhir.r5.elementmodel.Element r = be.getNamedChild("resource");
            if (r == null) continue;
            if (r.getChildValue("id") != null) {
                root.an(r.getChildValue("id"));
            } else if (be.getChildValue("fullUrl") != null) {
                root.an(this.fullUrlToAnchor(be.getChildValue("fullUrl")));
            }
            XhtmlNode c = this.getHtmlForResource(r);
            if (c != null) {
                root.getChildNodes().addAll(c.getChildNodes());
            }
            root.hr();
        }
        return root;
    }

    private XhtmlNode getHtmlForResource(org.hl7.fhir.r5.elementmodel.Element element) {
        org.hl7.fhir.r5.elementmodel.Element text = element.getNamedChild("text");
        if (text == null) {
            return null;
        }
        org.hl7.fhir.r5.elementmodel.Element div = text.getNamedChild("div");
        if (div == null) {
            return null;
        }
        return div.getXhtml();
    }

    public String getDefinitionsTarget() {
        return this.definitionsTarget;
    }

    public void setDefinitionsTarget(String definitionsTarget) {
        this.definitionsTarget = definitionsTarget;
    }

    public String getCorePath() {
        return this.corePath;
    }

    public void setCorePath(String corePath) {
        this.corePath = corePath;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public ProfileUtilities.ProfileKnowledgeProvider getPkp() {
        return this.pkp;
    }

    public NarrativeGenerator setPkp(ProfileUtilities.ProfileKnowledgeProvider pkp) {
        this.pkp = pkp;
        return this;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public NarrativeGenerator setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public boolean isCanonicalUrlsAsLinks() {
        return this.canonicalUrlsAsLinks;
    }

    @Override
    public void setCanonicalUrlsAsLinks(boolean canonicalUrlsAsLinks) {
        this.canonicalUrlsAsLinks = canonicalUrlsAsLinks;
    }

    public String getSnomedEdition() {
        return this.snomedEdition;
    }

    public NarrativeGenerator setSnomedEdition(String snomedEdition) {
        this.snomedEdition = snomedEdition;
        return this;
    }

    public ValidationOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public void setTerminologyServiceOptions(ValidationOptions terminologyServiceOptions) {
        this.terminologyServiceOptions = terminologyServiceOptions;
    }

    public boolean isNoSlowLookup() {
        return this.noSlowLookup;
    }

    public void setNoSlowLookup(boolean noSlowLookup) {
        this.noSlowLookup = noSlowLookup;
    }

    public List<String> getCodeSystemPropList() {
        return this.codeSystemPropList;
    }

    public void displayEncounter(XhtmlNode x, Encounter wrapped) {
        throw new Error("Not done yet");
    }

    public void displayPatient(XhtmlNode x, Patient wrapped) {
        throw new Error("Not done yet");
    }

    private void smartAddText(XhtmlNode p, String text) {
        if (text == null) {
            return;
        }
        String[] lines = text.split("\\r\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                p.br();
            }
            p.addText(lines[i]);
        }
    }

    private boolean generate(Resolver.ResourceContext rcontext, ResourceWrapper res, Provenance r) throws UnsupportedEncodingException, IOException {
        XhtmlNode tr;
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasExtensions = false;
        if (!r.getTarget().isEmpty()) {
            if (r.getTarget().size() == 1) {
                XhtmlNode p = x.para();
                p.tx("This provenance relates to ");
                this.renderReference(rcontext, res, p, r.getTargetFirstRep());
            } else {
                x.para().tx("This provenance relates to:");
                XhtmlNode ul = x.ul();
                for (Reference ref : r.getTarget()) {
                    this.renderReference(rcontext, res, ul.li(), r.getTargetFirstRep());
                }
            }
        }
        x.para().tx("Summary");
        XhtmlNode t = x.table("grid");
        if (r.hasOccurred()) {
            tr = t.tr();
            tr.td().tx("Occurrence");
            if (r.hasOccurredPeriod()) {
                this.renderPeriod(tr.td(), r.getOccurredPeriod());
            } else {
                this.renderDateTime(tr.td(), r.getOccurredDateTimeType());
            }
        }
        if (r.hasRecorded()) {
            tr = t.tr();
            tr.td().tx("Recorded");
            tr.td().addText(r.getRecordedElement().toHumanDisplay());
        }
        if (r.hasPolicy()) {
            tr = t.tr();
            tr.td().tx("Policy");
            if (r.getPolicy().size() == 1) {
                this.renderUri(tr.td(), r.getPolicy().get(0));
            } else {
                XhtmlNode ul = tr.td().ul();
                for (UriType u : r.getPolicy()) {
                    this.renderUri(ul.li(), u);
                }
            }
        }
        if (r.hasLocation()) {
            tr = t.tr();
            tr.td().tx("Location");
            this.renderReference(rcontext, res, tr.td(), r.getLocation());
        }
        if (r.hasActivity()) {
            tr = t.tr();
            tr.td().tx("Activity");
            this.renderCodeableConcept(r.getActivity(), tr.td(), false);
        }
        boolean hasType = false;
        boolean hasRole = false;
        boolean hasOnBehalfOf = false;
        for (Provenance.ProvenanceAgentComponent a : r.getAgent()) {
            hasType = hasType || a.hasType();
            hasRole = hasRole || a.hasRole();
            hasOnBehalfOf = hasOnBehalfOf || a.hasOnBehalfOf();
        }
        x.para().tx("Agents");
        t = x.table("grid");
        tr = t.tr();
        if (hasType) {
            tr.td().b().tx("type");
        }
        if (hasRole) {
            tr.td().b().tx("role");
        }
        tr.td().b().tx("who");
        if (hasOnBehalfOf) {
            tr.td().b().tx("onBehalfOf");
        }
        for (Provenance.ProvenanceAgentComponent a : r.getAgent()) {
            tr = t.tr();
            if (hasType) {
                if (a.hasType()) {
                    this.renderCodeableConcept(a.getType(), tr.td(), false);
                } else {
                    tr.td();
                }
            }
            if (hasRole) {
                if (a.hasRole()) {
                    if (a.getRole().size() == 1) {
                        this.renderCodeableConcept(a.getType(), tr.td(), false);
                    } else {
                        XhtmlNode ul = tr.td().ul();
                        for (CodeableConcept cc : a.getRole()) {
                            this.renderCodeableConcept(cc, ul.li(), false);
                        }
                    }
                } else {
                    tr.td();
                }
            }
            if (a.hasWho()) {
                this.renderReference(rcontext, res, tr.td(), a.getWho());
            } else {
                tr.td();
            }
            if (!hasOnBehalfOf) continue;
            if (a.hasOnBehalfOf()) {
                this.renderReference(rcontext, res, tr.td(), a.getOnBehalfOf());
                continue;
            }
            tr.td();
        }
        this.inject(r, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
        return hasExtensions;
    }

    public class ObservationNode {
        private String ref;
        private ResourceWrapper obs;
        private List<ObservationNode> contained = new ArrayList<ObservationNode>();
    }

    public static class ResourceWithReference {
        private String reference;
        private ResourceWrapper resource;

        public ResourceWithReference(String reference, ResourceWrapper resource) {
            this.reference = reference;
            this.resource = resource;
        }

        public String getReference() {
            return this.reference;
        }

        public ResourceWrapper getResource() {
            return this.resource;
        }
    }

    public class ResourceWrapperDirect
    extends WrapperBaseImpl
    implements ResourceWrapper {
        private Resource wrapped;

        public ResourceWrapperDirect(Resource wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public List<ResourceWrapper> getContained() {
            ArrayList<ResourceWrapper> list = new ArrayList<ResourceWrapper>();
            if (this.wrapped instanceof DomainResource) {
                DomainResource dr = (DomainResource)this.wrapped;
                for (Resource c : dr.getContained()) {
                    list.add(new ResourceWrapperDirect(c));
                }
            }
            return list;
        }

        @Override
        public String getId() {
            return this.wrapped.getId();
        }

        @Override
        public XhtmlNode getNarrative() {
            DomainResource dr;
            if (this.wrapped instanceof DomainResource && (dr = (DomainResource)this.wrapped).hasText() && dr.getText().hasDiv()) {
                return dr.getText().getDiv();
            }
            return null;
        }

        @Override
        public String getName() {
            return this.wrapped.getResourceType().toString();
        }

        @Override
        public List<PropertyWrapper> children() {
            ArrayList<PropertyWrapper> list = new ArrayList<PropertyWrapper>();
            if (this.wrapped.children() != null) {
                for (Property c : this.wrapped.children()) {
                    list.add(new PropertyWrapperDirect(c));
                }
            }
            return list;
        }

        @Override
        public void display(XhtmlNode x) {
            if (this.wrapped instanceof CanonicalResource) {
                x.tx(((CanonicalResource)this.wrapped).present());
            } else if (this.wrapped instanceof Patient) {
                NarrativeGenerator.this.displayPatient(x, (Patient)this.wrapped);
            } else if (this.wrapped instanceof Encounter) {
                NarrativeGenerator.this.displayEncounter(x, (Encounter)this.wrapped);
            }
        }
    }

    private class BaseWrapperDirect
    extends WrapperBaseImpl
    implements BaseWrapper {
        private Base wrapped;
        private List<PropertyWrapper> list;

        private BaseWrapperDirect(Base wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public Base getBase() {
            return this.wrapped;
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.list = new ArrayList<PropertyWrapper>();
                for (Property p : this.wrapped.children()) {
                    this.list.add(new PropertyWrapperDirect(p));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            Property p = this.wrapped.getChildByName(name);
            if (p == null) {
                return null;
            }
            return new PropertyWrapperDirect(p);
        }
    }

    private class PropertyWrapperDirect
    implements PropertyWrapper {
        private Property wrapped;
        private List<BaseWrapper> list;

        private PropertyWrapperDirect(Property wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        @Override
        public boolean hasValues() {
            return this.wrapped.hasValues();
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (Base b : this.wrapped.getValues()) {
                    this.list.add(b == null ? null : new BaseWrapperDirect(b));
                }
            }
            return this.list;
        }

        @Override
        public String getTypeCode() {
            return this.wrapped.getTypeCode();
        }

        @Override
        public String getDefinition() {
            return this.wrapped.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public int getMaxCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public StructureDefinition getStructure() {
            return this.wrapped.getStructure();
        }

        @Override
        public BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }

        public String toString() {
            return "#." + this.wrapped.toString();
        }
    }

    private class ResourceWrapperElement
    extends WrapperBaseImpl
    implements ResourceWrapper {
        private Element wrapped;
        private StructureDefinition definition;
        private List<ResourceWrapper> list;
        private List<PropertyWrapper> list2;

        public ResourceWrapperElement(Element wrapped, StructureDefinition definition) {
            this.wrapped = wrapped;
            this.definition = definition;
        }

        @Override
        public List<ResourceWrapper> getContained() {
            if (this.list == null) {
                ArrayList<Element> children = new ArrayList<Element>();
                XMLUtil.getNamedChildren(this.wrapped, "contained", children);
                this.list = new ArrayList<ResourceWrapper>();
                for (Element e : children) {
                    Element c = XMLUtil.getFirstChild(e);
                    this.list.add(new ResourceWrapperElement(c, NarrativeGenerator.this.context.fetchTypeDefinition(c.getNodeName())));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return XMLUtil.getNamedChildValue(this.wrapped, "id");
        }

        @Override
        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException {
            Element txt = XMLUtil.getNamedChild(this.wrapped, "text");
            if (txt == null) {
                return null;
            }
            Element div = XMLUtil.getNamedChild(txt, "div");
            if (div == null) {
                return null;
            }
            try {
                return new XhtmlParser().parse(new XmlGenerator().generate(div), "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), e);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), e);
            }
        }

        @Override
        public String getName() {
            return this.wrapped.getNodeName();
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = NarrativeGenerator.this.profileUtilities.getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard(this.wrapped, NarrativeGenerator.this.tail(child.getPath()), elements);
                    this.list2.add(new PropertyWrapperElement(this.definition, child, elements));
                }
            }
            return this.list2;
        }

        @Override
        public void display(XhtmlNode x) {
            throw new Error("Not done yet");
        }
    }

    private class PropertyWrapperMetaElement
    implements PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<org.hl7.fhir.r5.elementmodel.Element> values;
        private List<BaseWrapper> list;

        public PropertyWrapperMetaElement(StructureDefinition structure, ElementDefinition definition, List<org.hl7.fhir.r5.elementmodel.Element> values) {
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return NarrativeGenerator.this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (org.hl7.fhir.r5.elementmodel.Element e : this.values) {
                    this.list.add(new BaseWrapperMetaElement(e, e.fhirType(), this.structure, this.definition));
                }
            }
            return this.list;
        }

        @Override
        public String getTypeCode() {
            return this.definition.typeSummary();
        }

        @Override
        public String getDefinition() {
            return this.definition.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            return this.definition.getMin();
        }

        @Override
        public int getMaxCardinality() {
            return "*".equals(this.definition.getMax()) ? Integer.MAX_VALUE : Integer.valueOf(this.definition.getMax());
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }

        @Override
        public BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }
    }

    public class ResourceWrapperMetaElement
    extends WrapperBaseImpl
    implements ResourceWrapper {
        private org.hl7.fhir.r5.elementmodel.Element wrapped;
        private List<ResourceWrapper> list;
        private List<PropertyWrapper> list2;
        private StructureDefinition definition;

        public ResourceWrapperMetaElement(org.hl7.fhir.r5.elementmodel.Element wrapped) {
            this.wrapped = wrapped;
            this.definition = wrapped.getProperty().getStructure();
        }

        @Override
        public List<ResourceWrapper> getContained() {
            if (this.list == null) {
                List<org.hl7.fhir.r5.elementmodel.Element> children = this.wrapped.getChildrenByName("contained");
                this.list = new ArrayList<ResourceWrapper>();
                for (org.hl7.fhir.r5.elementmodel.Element e : children) {
                    this.list.add(new ResourceWrapperMetaElement(e));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return this.wrapped.getNamedChildValue("id");
        }

        @Override
        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException {
            org.hl7.fhir.r5.elementmodel.Element txt = this.wrapped.getNamedChild("text");
            if (txt == null) {
                return null;
            }
            org.hl7.fhir.r5.elementmodel.Element div = txt.getNamedChild("div");
            if (div == null) {
                return null;
            }
            return div.getXhtml();
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = NarrativeGenerator.this.profileUtilities.getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<org.hl7.fhir.r5.elementmodel.Element> elements = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
                    if (child.getPath().endsWith("[x]")) {
                        this.wrapped.getNamedChildrenWithWildcard(NarrativeGenerator.this.tail(child.getPath()), elements);
                    } else {
                        this.wrapped.getNamedChildren(NarrativeGenerator.this.tail(child.getPath()), elements);
                    }
                    this.list2.add(new PropertyWrapperMetaElement(this.definition, child, elements));
                }
            }
            return this.list2;
        }

        @Override
        public void display(XhtmlNode x) {
            if (this.wrapped.hasChild("title") && this.wrapped.getChildValue("title") != null) {
                x.tx(this.wrapped.getChildValue("title"));
            } else if (this.wrapped.hasChild("name") && this.wrapped.getChildValue("name") != null) {
                x.tx(this.wrapped.getChildValue("name"));
            } else {
                x.tx("?ngen-1?");
            }
        }
    }

    private class BaseWrapperMetaElement
    extends WrapperBaseImpl
    implements BaseWrapper {
        private org.hl7.fhir.r5.elementmodel.Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<PropertyWrapper> list;

        public BaseWrapperMetaElement(org.hl7.fhir.r5.elementmodel.Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            if (this.element.hasElementProperty()) {
                return null;
            }
            ByteArrayOutputStream xml = new ByteArrayOutputStream();
            try {
                new org.hl7.fhir.r5.elementmodel.XmlParser(NarrativeGenerator.this.context).compose(this.element, xml, IParser.OutputStyle.PRETTY, null);
            }
            catch (Exception e) {
                throw new FHIRException(e.getMessage(), e);
            }
            return NarrativeGenerator.this.parseType(xml.toString(), this.type);
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.children = NarrativeGenerator.this.profileUtilities.getChildList(this.structure, this.definition);
                this.list = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<org.hl7.fhir.r5.elementmodel.Element> elements = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
                    String name = NarrativeGenerator.this.tail(child.getPath());
                    if (name.endsWith("[x]")) {
                        this.element.getNamedChildrenWithWildcard(name, elements);
                    } else {
                        this.element.getNamedChildren(name, elements);
                    }
                    this.list.add(new PropertyWrapperMetaElement(this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }
    }

    private class PropertyWrapperElement
    implements PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<Element> values;
        private List<BaseWrapper> list;

        public PropertyWrapperElement(StructureDefinition structure, ElementDefinition definition, List<Element> values) {
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return NarrativeGenerator.this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (Element e : this.values) {
                    this.list.add(new BaseWrapperElement(e, this.determineType(e), this.structure, this.definition));
                }
            }
            return this.list;
        }

        private String determineType(Element e) {
            if (this.definition.getType().isEmpty()) {
                return null;
            }
            if (this.definition.getType().size() == 1) {
                if (this.definition.getType().get(0).getWorkingCode().equals("Element") || this.definition.getType().get(0).getWorkingCode().equals("BackboneElement")) {
                    return null;
                }
                return this.definition.getType().get(0).getWorkingCode();
            }
            String t = e.getNodeName().substring(NarrativeGenerator.this.tail(this.definition.getPath()).length() - 3);
            if (this.isPrimitive(Utilities.uncapitalize(t))) {
                return Utilities.uncapitalize(t);
            }
            return t;
        }

        private boolean isPrimitive(String code) {
            StructureDefinition sd = NarrativeGenerator.this.context.fetchTypeDefinition(code);
            return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
        }

        @Override
        public String getTypeCode() {
            if (this.definition == null || this.definition.getType().size() != 1) {
                throw new Error("not handled");
            }
            return this.definition.getType().get(0).getWorkingCode();
        }

        @Override
        public String getDefinition() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getMin();
        }

        @Override
        public int getMaxCardinality() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(this.definition.getMax());
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }

        @Override
        public BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }
    }

    private class BaseWrapperElement
    extends WrapperBaseImpl
    implements BaseWrapper {
        private Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<PropertyWrapper> list;

        public BaseWrapperElement(Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            String xml;
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            try {
                xml = new XmlGenerator().generate(this.element);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), e);
            }
            return NarrativeGenerator.this.parseType(xml, this.type);
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.children = NarrativeGenerator.this.profileUtilities.getChildList(this.structure, this.definition);
                this.list = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard(this.element, NarrativeGenerator.this.tail(child.getPath()), elements);
                    this.list.add(new PropertyWrapperElement(this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }
    }

    private abstract class WrapperBaseImpl
    implements WrapperBase {
        private WrapperBaseImpl() {
        }

        @Override
        public boolean has(String name) {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p.hasValues();
            }
            return false;
        }

        @Override
        public Base get(String name) throws UnsupportedEncodingException, FHIRException, IOException {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                if (p.hasValues()) {
                    return p.getValues().get(0).getBase();
                }
                return null;
            }
            return null;
        }

        @Override
        public List<BaseWrapper> children(String name) throws UnsupportedEncodingException, FHIRException, IOException {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                ArrayList<BaseWrapper> res = new ArrayList<BaseWrapper>();
                for (BaseWrapper b : p.getValues()) {
                    res.add(b);
                }
                return res;
            }
            return null;
        }
    }

    private static interface BaseWrapper
    extends WrapperBase {
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException;

        public PropertyWrapper getChildByName(String var1);
    }

    private static interface ResourceWrapper
    extends WrapperBase {
        public List<ResourceWrapper> getContained();

        public String getId();

        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException;

        public String getName();

        public void display(XhtmlNode var1);
    }

    private static interface WrapperBase {
        public boolean has(String var1);

        public Base get(String var1) throws UnsupportedEncodingException, FHIRException, IOException;

        public List<BaseWrapper> children(String var1) throws UnsupportedEncodingException, FHIRException, IOException;

        public List<PropertyWrapper> children();
    }

    private static interface PropertyWrapper {
        public String getName();

        public boolean hasValues();

        public List<BaseWrapper> getValues();

        public String getTypeCode();

        public String getDefinition();

        public int getMinCardinality();

        public int getMaxCardinality();

        public StructureDefinition getStructure();

        public BaseWrapper value();
    }

    public static interface IReferenceResolver {
        public ResourceWithReference resolve(String var1);
    }

    public static interface ITypeParser {
        public Base parseType(String var1, String var2) throws FHIRFormatError, IOException, FHIRException;
    }

    public static interface ILiquidTemplateProvider {
        public String findTemplate(Resolver.ResourceContext var1, DomainResource var2);
    }
}

