/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class RenderingContext {
    protected IWorkerContext worker;
    protected MarkDownProcessor markdown;
    protected String lang;
    protected String prefix;
    protected ValidationOptions terminologyServiceOptions;
    protected ProfileUtilities profileUtilities;
    private boolean canonicalUrlsAsLinks;
    protected ResourceRendererMode mode;
    private Resolver.IReferenceResolver resolver;
    private int headerLevelContext;
    private String tooCostlyNoteEmpty;
    private String tooCostlyNoteNotEmpty;
    private String tooCostlyNoteEmptyDependent;
    private String tooCostlyNoteNotEmptyDependent;

    public RenderingContext(IWorkerContext worker, MarkDownProcessor markdown, ValidationOptions terminologyServiceOptions, String prefix, String lang, ResourceRendererMode mode) {
        this.worker = worker;
        this.markdown = markdown;
        this.lang = lang;
        this.prefix = prefix;
        this.mode = mode;
        this.terminologyServiceOptions = terminologyServiceOptions;
        this.profileUtilities = new ProfileUtilities(worker, null, null);
    }

    public IWorkerContext getContext() {
        return this.worker;
    }

    public ProfileUtilities getProfileUtilities() {
        return this.profileUtilities;
    }

    public IWorkerContext getWorker() {
        return this.worker;
    }

    public boolean isCanonicalUrlsAsLinks() {
        return this.canonicalUrlsAsLinks;
    }

    public void setCanonicalUrlsAsLinks(boolean canonicalUrlsAsLinks) {
        this.canonicalUrlsAsLinks = canonicalUrlsAsLinks;
    }

    public MarkDownProcessor getMarkdown() {
        return this.markdown;
    }

    public String getLang() {
        return this.lang;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ValidationOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public String getTooCostlyNoteEmpty() {
        return this.tooCostlyNoteEmpty;
    }

    public void setTooCostlyNoteEmpty(String tooCostlyNoteEmpty) {
        this.tooCostlyNoteEmpty = tooCostlyNoteEmpty;
    }

    public String getTooCostlyNoteNotEmpty() {
        return this.tooCostlyNoteNotEmpty;
    }

    public void setTooCostlyNoteNotEmpty(String tooCostlyNoteNotEmpty) {
        this.tooCostlyNoteNotEmpty = tooCostlyNoteNotEmpty;
    }

    public String getTooCostlyNoteEmptyDependent() {
        return this.tooCostlyNoteEmptyDependent;
    }

    public void setTooCostlyNoteEmptyDependent(String tooCostlyNoteEmptyDependent) {
        this.tooCostlyNoteEmptyDependent = tooCostlyNoteEmptyDependent;
    }

    public String getTooCostlyNoteNotEmptyDependent() {
        return this.tooCostlyNoteNotEmptyDependent;
    }

    public void setTooCostlyNoteNotEmptyDependent(String tooCostlyNoteNotEmptyDependent) {
        this.tooCostlyNoteNotEmptyDependent = tooCostlyNoteNotEmptyDependent;
    }

    public int getHeaderLevelContext() {
        return this.headerLevelContext;
    }

    public void setHeaderLevelContext(int headerLevelContext) {
        this.headerLevelContext = headerLevelContext;
    }

    public Resolver.IReferenceResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver.IReferenceResolver resolver) {
        this.resolver = resolver;
    }

    public void setTerminologyServiceOptions(ValidationOptions terminologyServiceOptions) {
        this.terminologyServiceOptions = terminologyServiceOptions;
    }

    public static enum ResourceRendererMode {
        RESOURCE,
        IG;

    }
}

