/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.ProfileDrivenRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.DirectWrappers;
import org.hl7.fhir.r5.renderers.utils.ElementWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class ResourceRenderer
extends DataRenderer {
    protected Resolver.ResourceContext rcontext;
    protected XVerExtensionManager xverManager;

    public ResourceRenderer(RenderingContext context) {
        super(context);
    }

    public ResourceRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context);
        this.rcontext = rcontext;
    }

    public void render(DomainResource r) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode x;
        boolean hasExtensions = this.render(x = new XhtmlNode(NodeType.Element, "div"), r);
        this.inject(r, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    public abstract boolean render(XhtmlNode var1, DomainResource var2) throws FHIRFormatError, DefinitionException, IOException;

    public void describe(XhtmlNode x, DomainResource r) throws UnsupportedEncodingException, IOException {
        x.tx(this.display(r));
    }

    public abstract String display(DomainResource var1) throws UnsupportedEncodingException, IOException;

    protected void inject(DomainResource r, XhtmlNode x, Narrative.NarrativeStatus status) {
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        if (r.hasLanguage()) {
            x.setAttribute("lang", r.getLanguage());
            x.setAttribute("xml:lang", r.getLanguage());
        }
        if (!r.hasText() || !r.getText().hasDiv() || r.getText().getDiv().getChildNodes().isEmpty()) {
            r.setText(new Narrative());
            r.getText().setDiv(x);
            r.getText().setStatus(status);
        } else {
            XhtmlNode n = r.getText().getDiv();
            n.hr();
            n.getChildNodes().addAll(x.getChildNodes());
        }
    }

    public void renderReference(Resource res, XhtmlNode x, Reference r) throws UnsupportedEncodingException, IOException {
        DirectWrappers.ResourceWrapperDirect rw = new DirectWrappers.ResourceWrapperDirect(this, res);
        this.renderReference(rw, x, r);
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, Reference r) throws UnsupportedEncodingException, IOException {
        XhtmlNode c = x;
        Resolver.ResourceWithReference tr = null;
        if (r.hasReferenceElement()) {
            tr = this.resolveReference(rw, r.getReference());
            if (!r.getReference().startsWith("#")) {
                c = tr != null && tr.getReference() != null ? x.ah(tr.getReference()) : x.ah(r.getReference());
            }
        }
        if (r.hasDisplayElement()) {
            c.addText(r.getDisplay());
            if (tr != null && tr.getResource() != null) {
                c.tx(". Generated Summary: ");
                new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), true, r.getReference().startsWith("#"));
            }
        } else if (tr != null && tr.getResource() != null) {
            new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), r.getReference().startsWith("#"), r.getReference().startsWith("#"));
        } else {
            c.addText(r.getReference());
        }
    }

    protected Resolver.ResourceWithReference resolveReference(BaseWrappers.ResourceWrapper res, String url) {
        Object ae;
        if (url == null) {
            return null;
        }
        if (url.startsWith("#")) {
            for (BaseWrappers.ResourceWrapper r : res.getContained()) {
                if (!r.getId().equals(url.substring(1))) continue;
                return new Resolver.ResourceWithReference(null, r);
            }
            return null;
        }
        if (this.rcontext != null) {
            Bundle.BundleEntryComponent bundleResource = this.rcontext.resolve(url);
            if (bundleResource != null) {
                String bundleUrl = "#" + bundleResource.getResource().getResourceType().name().toLowerCase() + "_" + bundleResource.getResource().getId();
                return new Resolver.ResourceWithReference(bundleUrl, new DirectWrappers.ResourceWrapperDirect(this, bundleResource.getResource()));
            }
            Element bundleElement = this.rcontext.resolveElement(url);
            if (bundleElement != null) {
                String bundleUrl = null;
                bundleUrl = bundleElement.getNamedChild("resource").getChildValue("id") != null ? "#" + bundleElement.fhirType().toLowerCase() + "_" + bundleElement.getNamedChild("resource").getChildValue("id") : "#" + this.fullUrlToAnchor(bundleElement.getChildValue("fullUrl"));
                return new Resolver.ResourceWithReference(bundleUrl, new ElementWrappers.ResourceWrapperMetaElement(this, bundleElement));
            }
        }
        if ((ae = this.getContext().getWorker().fetchResource(null, url)) != null) {
            return new Resolver.ResourceWithReference(url, new DirectWrappers.ResourceWrapperDirect(this, (Resource)ae));
        }
        if (this.context.getResolver() != null) {
            return this.context.getResolver().resolve(url);
        }
        return null;
    }

    private String fullUrlToAnchor(String url) {
        return url.replace(":", "").replace("/", "_");
    }

    protected void generateCopyright(XhtmlNode x, CanonicalResource cs) {
        XhtmlNode p = x.para();
        p.b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Copyright Statement:", this.context.getLang()));
        this.smartAddText(p, " " + cs.getCopyright());
    }

    public String displayReference(Resource res, Reference r) throws UnsupportedEncodingException, IOException {
        return "todo";
    }

    public Base parseType(String string, String type) {
        return null;
    }
}

