/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.CodeSystemRenderer;
import org.hl7.fhir.r5.renderers.ConceptMapRenderer;
import org.hl7.fhir.r5.renderers.EncounterRenderer;
import org.hl7.fhir.r5.renderers.PatientRenderer;
import org.hl7.fhir.r5.renderers.ProfileDrivenRenderer;
import org.hl7.fhir.r5.renderers.ProvenanceRenderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.ValueSetRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;

public class RendererFactory {
    public static ResourceRenderer factory(String resourceName, RenderingContext context) {
        if ("CodeSystem".equals(resourceName)) {
            return new CodeSystemRenderer(context);
        }
        if ("ValueSet".equals(resourceName)) {
            return new ValueSetRenderer(context);
        }
        if ("ConceptMap".equals(resourceName)) {
            return new ConceptMapRenderer(context);
        }
        if ("Patient".equals(resourceName)) {
            return new PatientRenderer(context);
        }
        if ("Encounter".equals(resourceName)) {
            return new EncounterRenderer(context);
        }
        if ("Provenance".equals(resourceName)) {
            return new ProvenanceRenderer(context);
        }
        return new ProfileDrivenRenderer(context);
    }

    public static ResourceRenderer factory(Resource resource, RenderingContext context) {
        return RendererFactory.factory(resource.fhirType(), context);
    }
}

