/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class DataRenderer {
    protected RenderingContext context;

    public DataRenderer(RenderingContext context) {
        this.context = context;
    }

    protected void addMarkdown(XhtmlNode x, String text) throws FHIRFormatError, IOException, DefinitionException {
        if (text != null) {
            XhtmlDocument m3;
            while (text.contains("[[[")) {
                String left = text.substring(0, text.indexOf("[[["));
                String link = text.substring(text.indexOf("[[[") + 3, text.indexOf("]]]"));
                String right = text.substring(text.indexOf("]]]") + 3);
                String url = link;
                String[] parts = link.split("\\#");
                StructureDefinition p = this.getContext().getWorker().fetchResource(StructureDefinition.class, parts[0]);
                if (p == null) {
                    p = this.getContext().getWorker().fetchTypeDefinition(parts[0]);
                }
                if (p == null) {
                    p = this.getContext().getWorker().fetchResource(StructureDefinition.class, link);
                }
                if (p != null) {
                    url = p.getUserString("path");
                    if (url == null) {
                        url = p.getUserString("filename");
                    }
                } else {
                    throw new DefinitionException("Unable to resolve markdown link " + link);
                }
                text = left + "[" + link + "](" + url + ")" + right;
            }
            String s2 = this.getContext().getMarkdown().process(Utilities.escapeXml(text), "narrative generator");
            XhtmlParser p = new XhtmlParser();
            try {
                m3 = p.parse("<div>" + s2 + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), e);
            }
            x.getChildNodes().addAll(m3.getChildNodes());
        }
    }

    protected void smartAddText(XhtmlNode p, String text) {
        if (text == null) {
            return;
        }
        String[] lines = text.split("\\r\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                p.br();
            }
            p.addText(lines[i]);
        }
    }

    public static String describeSystem(String system) {
        if (system == null) {
            return "[not stated]";
        }
        if (system.equals("http://loinc.org")) {
            return "LOINC";
        }
        if (system.startsWith("http://snomed.info")) {
            return "SNOMED CT";
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return "RxNorm";
        }
        if (system.equals("http://hl7.org/fhir/sid/icd-9")) {
            return "ICD-9";
        }
        if (system.equals("http://dicom.nema.org/resources/ontology/DCM")) {
            return "DICOM";
        }
        if (system.equals("http://unitsofmeasure.org")) {
            return "UCUM";
        }
        return system;
    }

    protected String makeAnchor(String codeSystem, String code) {
        String s2 = codeSystem + '-' + code;
        StringBuilder b = new StringBuilder();
        for (char c : s2.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '.') {
                b.append(c);
                continue;
            }
            b.append('-');
        }
        return b.toString();
    }

    private String lookupCode(String system, String code) {
        IWorkerContext.ValidationResult t = this.getContext().getWorker().validateCode(this.getContext().getTerminologyServiceOptions(), system, code, null);
        if (t != null && t.getDisplay() != null) {
            return t.getDisplay();
        }
        return code;
    }

    protected String describeLang(String lang) {
        ValueSet v = this.getContext().getWorker().fetchResource(ValueSet.class, "http://hl7.org/fhir/ValueSet/languages");
        if (v != null) {
            ValueSet.ConceptReferenceComponent l = null;
            for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                if (!cc.getCode().equals(lang)) continue;
                l = cc;
            }
            if (l == null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                    if (!cc.getCode().equals(lang) && !cc.getCode().startsWith(lang + "-")) continue;
                    l = cc;
                }
            }
            if (l != null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                String en = l.getDisplay();
                String nativelang = null;
                for (ValueSet.ConceptReferenceDesignationComponent cd2 : l.getDesignation()) {
                    if (!cd2.getLanguage().equals(lang)) continue;
                    nativelang = cd2.getValue();
                }
                if (nativelang == null) {
                    return en + " (" + lang + ")";
                }
                return nativelang + " (" + en + ", " + lang + ")";
            }
        }
        return lang;
    }

    private boolean isCanonical(String path) {
        if (!path.endsWith(".url")) {
            return false;
        }
        StructureDefinition sd = this.getContext().getWorker().fetchTypeDefinition(path.substring(0, path.length() - 4));
        if (sd == null) {
            return false;
        }
        if (Utilities.existsInList(path.substring(0, path.length() - 4), "CapabilityStatement", "StructureDefinition", "ImplementationGuide", "SearchParameter", "MessageDefinition", "OperationDefinition", "CompartmentDefinition", "StructureMap", "GraphDefinition", "ExampleScenario", "CodeSystem", "ValueSet", "ConceptMap", "NamingSystem", "TerminologyCapabilities")) {
            return true;
        }
        return sd.getBaseDefinitionElement().hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-codegen-super");
    }

    public static String display(IWorkerContext context, DataType type) {
        return new DataRenderer(new RenderingContext(context, null, null, "", null, RenderingContext.ResourceRendererMode.RESOURCE)).display(type);
    }

    public String display(DataType type) {
        return null;
    }

    public void render(XhtmlNode x, DataType type) {
    }

    public void renderDateTime(XhtmlNode x, Base e) {
        if (e.hasPrimitiveValue()) {
            x.addText(((DateTimeType)e).toHumanDisplay());
        }
    }

    protected void renderUri(XhtmlNode x, UriType uri) {
        if (((String)uri.getValue()).startsWith("mailto:")) {
            x.ah((String)uri.getValue()).addText(((String)uri.getValue()).substring(7));
        } else {
            x.ah((String)uri.getValue()).addText((String)uri.getValue());
        }
    }

    protected void renderUri(XhtmlNode x, UriType uri, String path, String id) {
        String url = (String)uri.getValue();
        if (this.isCanonical(path)) {
            CanonicalResource mr = (CanonicalResource)this.getContext().getWorker().fetchResource(null, url);
            if (mr != null) {
                if (path.startsWith(mr.fhirType() + ".") && mr.getId().equals(id)) {
                    url = null;
                } else if (mr.hasUserData("path")) {
                    url = mr.getUserString("path");
                }
            } else if (!this.getContext().isCanonicalUrlsAsLinks()) {
                url = null;
            }
        }
        if (url == null) {
            x.b().tx((String)uri.getValue());
        } else if (((String)uri.getValue()).startsWith("mailto:")) {
            x.ah((String)uri.getValue()).addText(((String)uri.getValue()).substring(7));
        } else {
            x.ah((String)uri.getValue()).addText((String)uri.getValue());
        }
    }

    protected void renderAnnotation(XhtmlNode x, Annotation annot) {
        this.renderAnnotation(x, annot, false);
    }

    protected void renderAnnotation(XhtmlNode x, Annotation a, boolean showCodeDetails) throws FHIRException {
        StringBuilder s2 = new StringBuilder();
        if (a.hasAuthor()) {
            s2.append("Author: ");
            if (a.hasAuthorReference()) {
                s2.append(a.getAuthorReference().getReference());
            } else if (a.hasAuthorStringType()) {
                s2.append((String)a.getAuthorStringType().getValue());
            }
        }
        if (a.hasTimeElement()) {
            if (s2.length() > 0) {
                s2.append("; ");
            }
            s2.append("Made: ").append(a.getTimeElement().toHumanDisplay());
        }
        if (a.hasText()) {
            if (s2.length() > 0) {
                s2.append("; ");
            }
            s2.append("Annotation: ").append(a.getText());
        }
        x.addText(s2.toString());
    }

    protected void renderCoding(XhtmlNode x, Coding c) {
        this.renderCoding(x, c, false);
    }

    protected void renderCoding(XhtmlNode x, Coding c, boolean showCodeDetails) {
        String s2 = "";
        if (c.hasDisplayElement()) {
            s2 = c.getDisplay();
        }
        if (Utilities.noString(s2)) {
            s2 = this.lookupCode(c.getSystem(), c.getCode());
        }
        if (Utilities.noString(s2)) {
            s2 = c.getCode();
        }
        if (showCodeDetails) {
            x.addText(s2 + " (Details: " + TerminologyRenderer.describeSystem(c.getSystem()) + " code " + c.getCode() + " = '" + this.lookupCode(c.getSystem(), c.getCode()) + "', stated as '" + c.getDisplay() + "')");
        } else {
            x.span(null, "{" + c.getSystem() + " " + c.getCode() + "}").addText(s2);
        }
    }

    public String displayCodeableConcept(CodeableConcept cc) {
        String s2 = cc.getText();
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s2 = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCode() && c.hasSystem() && !Utilities.noString(s2 = this.lookupCode(c.getSystem(), c.getCode()))) break;
            }
        }
        if (Utilities.noString(s2)) {
            s2 = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        return s2;
    }

    protected void renderCodeableConcept(XhtmlNode x, CodeableConcept cc) {
        this.renderCodeableConcept(x, cc, false);
    }

    protected void renderCodeableConcept(XhtmlNode x, CodeableConcept cc, boolean showCodeDetails) {
        if (cc.isEmpty()) {
            return;
        }
        String s2 = cc.getText();
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s2 = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString(s2)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCodeElement() && c.hasSystemElement() && !Utilities.noString(s2 = this.lookupCode(c.getSystem(), c.getCode()))) break;
            }
        }
        if (Utilities.noString(s2)) {
            s2 = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        if (showCodeDetails) {
            x.addText(s2 + " ");
            XhtmlNode sp = x.span("background: LightGoldenRodYellow", null);
            sp.tx("(Details ");
            boolean first = true;
            for (Coding c : cc.getCoding()) {
                if (first) {
                    sp.tx(": ");
                    first = false;
                } else {
                    sp.tx("; ");
                }
                sp.tx("{" + TerminologyRenderer.describeSystem(c.getSystem()) + " code '" + c.getCode() + "' = '" + this.lookupCode(c.getSystem(), c.getCode()) + (c.hasDisplay() ? "', given as '" + c.getDisplay() + "'}" : ""));
            }
            sp.tx(")");
        } else {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Coding c : cc.getCoding()) {
                if (!c.hasCodeElement() || !c.hasSystemElement()) continue;
                b.append("{" + c.getSystem() + " " + c.getCode() + "}");
            }
            x.span(null, "Codes: " + b.toString()).addText(s2);
        }
    }

    private String displayIdentifier(Identifier ii) {
        String s2;
        String string = s2 = Utilities.noString(ii.getValue()) ? "?ngen-9?" : ii.getValue();
        if (ii.hasType()) {
            if (ii.getType().hasText()) {
                s2 = ii.getType().getText() + " = " + s2;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasDisplay()) {
                s2 = ii.getType().getCoding().get(0).getDisplay() + " = " + s2;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasCode()) {
                s2 = this.lookupCode(ii.getType().getCoding().get(0).getSystem(), ii.getType().getCoding().get(0).getCode()) + " = " + s2;
            }
        }
        if (ii.hasUse()) {
            s2 = s2 + " (" + ii.getUse().toString() + ")";
        }
        return s2;
    }

    protected void renderIdentifier(XhtmlNode x, Identifier ii) {
        x.addText(this.displayIdentifier(ii));
    }

    public static String displayHumanName(HumanName name) {
        StringBuilder s2 = new StringBuilder();
        if (name.hasText()) {
            s2.append(name.getText());
        } else {
            for (StringType p : name.getGiven()) {
                s2.append((String)p.getValue());
                s2.append(" ");
            }
            if (name.hasFamily()) {
                s2.append(name.getFamily());
                s2.append(" ");
            }
        }
        if (name.hasUse() && name.getUse() != HumanName.NameUse.USUAL) {
            s2.append("(" + name.getUse().toString() + ")");
        }
        return s2.toString();
    }

    protected void renderHumanName(XhtmlNode x, HumanName name) {
        x.addText(DataRenderer.displayHumanName(name));
    }

    private String displayAddress(Address address) {
        StringBuilder s2 = new StringBuilder();
        if (address.hasText()) {
            s2.append(address.getText());
        } else {
            for (StringType p : address.getLine()) {
                s2.append((String)p.getValue());
                s2.append(" ");
            }
            if (address.hasCity()) {
                s2.append(address.getCity());
                s2.append(" ");
            }
            if (address.hasState()) {
                s2.append(address.getState());
                s2.append(" ");
            }
            if (address.hasPostalCode()) {
                s2.append(address.getPostalCode());
                s2.append(" ");
            }
            if (address.hasCountry()) {
                s2.append(address.getCountry());
                s2.append(" ");
            }
        }
        if (address.hasUse()) {
            s2.append("(" + address.getUse().toString() + ")");
        }
        return s2.toString();
    }

    protected void renderAddress(XhtmlNode x, Address address) {
        x.addText(this.displayAddress(address));
    }

    public static String displayContactPoint(ContactPoint contact) {
        StringBuilder s2 = new StringBuilder();
        s2.append(DataRenderer.describeSystem(contact.getSystem()));
        if (Utilities.noString(contact.getValue())) {
            s2.append("-unknown-");
        } else {
            s2.append(contact.getValue());
        }
        if (contact.hasUse()) {
            s2.append("(" + contact.getUse().toString() + ")");
        }
        return s2.toString();
    }

    protected void renderContactPoint(XhtmlNode x, ContactPoint contact) {
        x.addText(DataRenderer.displayContactPoint(contact));
    }

    protected void addTelecom(XhtmlNode p, ContactPoint c) {
        if (c.getSystem() == ContactPoint.ContactPointSystem.PHONE) {
            p.tx("Phone: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.FAX) {
            p.tx("Fax: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.EMAIL) {
            p.ah("mailto:" + c.getValue()).addText(c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.URL) {
            if (c.getValue().length() > 30) {
                p.ah(c.getValue()).addText(c.getValue().substring(0, 30) + "...");
            } else {
                p.ah(c.getValue()).addText(c.getValue());
            }
        }
    }

    private static String describeSystem(ContactPoint.ContactPointSystem system) {
        if (system == null) {
            return "";
        }
        switch (system) {
            case PHONE: {
                return "ph: ";
            }
            case FAX: {
                return "fax: ";
            }
        }
        return "";
    }

    protected String displayQuantity(Quantity q) {
        StringBuilder s2 = new StringBuilder();
        s2.append("(system = '").append(TerminologyRenderer.describeSystem(q.getSystem())).append("' code ").append(q.getCode()).append(" = '").append(this.lookupCode(q.getSystem(), q.getCode())).append("')");
        return s2.toString();
    }

    protected void renderQuantity(XhtmlNode x, Quantity q) {
        this.renderQuantity(x, q, false);
    }

    protected void renderQuantity(XhtmlNode x, Quantity q, boolean showCodeDetails) {
        if (q.hasComparator()) {
            x.addText(q.getComparator().toCode());
        }
        x.addText(q.getValue().toString());
        if (q.hasUnit()) {
            x.tx(" " + q.getUnit());
        } else if (q.hasCode()) {
            x.tx(" " + q.getCode());
        }
        if (showCodeDetails && q.hasCode()) {
            x.span("background: LightGoldenRodYellow", null).tx(" (Details: " + TerminologyRenderer.describeSystem(q.getSystem()) + " code " + q.getCode() + " = '" + this.lookupCode(q.getSystem(), q.getCode()) + "')");
        }
    }

    public String displayRange(Range q) {
        StringBuilder b = new StringBuilder();
        if (q.hasLow()) {
            b.append(q.getLow().getValue().toString());
        } else {
            b.append("?");
        }
        b.append("-");
        if (q.hasHigh()) {
            b.append(q.getHigh().getValue().toString());
        } else {
            b.append("?");
        }
        if (q.getLow().hasUnit()) {
            b.append(" " + q.getLow().getUnit());
        }
        return b.toString();
    }

    protected void renderRange(XhtmlNode x, Range q) {
        if (q.hasLow()) {
            x.addText(q.getLow().getValue().toString());
        } else {
            x.tx("?");
        }
        x.tx("-");
        if (q.hasHigh()) {
            x.addText(q.getHigh().getValue().toString());
        } else {
            x.tx("?");
        }
        if (q.getLow().hasUnit()) {
            x.tx(" " + q.getLow().getUnit());
        }
    }

    public static String displayPeriod(Period p) {
        String s2 = !p.hasStart() ? "?ngen-5?" : p.getStartElement().toHumanDisplay();
        s2 = s2 + " --> ";
        return s2 + (!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
    }

    public void renderPeriod(XhtmlNode x, Period p) {
        x.addText(!p.hasStart() ? "??" : p.getStartElement().toHumanDisplay());
        x.tx(" --> ");
        x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
    }

    private String displayTiming(Timing s2) throws FHIRException {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s2.hasCode()) {
            b.append("Code: " + this.displayCodeableConcept(s2.getCode()));
        }
        if (s2.getEvent().size() > 0) {
            CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
            for (DateTimeType p : s2.getEvent()) {
                c.append(p.toHumanDisplay());
            }
            b.append("Events: " + c.toString());
        }
        if (s2.hasRepeat()) {
            String st;
            Timing.TimingRepeatComponent rep = s2.getRepeat();
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasStart()) {
                b.append("Starting " + rep.getBoundsPeriod().getStartElement().toHumanDisplay());
            }
            if (rep.hasCount()) {
                b.append("Count " + Integer.toString(rep.getCount()) + " times");
            }
            if (rep.hasDuration()) {
                b.append("Duration " + rep.getDuration().toPlainString() + this.displayTimeUnits(rep.getPeriodUnit()));
            }
            if (rep.hasWhen()) {
                st = "";
                if (rep.hasOffset()) {
                    st = Integer.toString(rep.getOffset()) + "min ";
                }
                b.append("Do " + st);
                for (Enumeration<Timing.EventTiming> wh : rep.getWhen()) {
                    b.append(this.displayEventCode((Timing.EventTiming)((Object)wh.getValue())));
                }
            } else {
                st = "";
                if (!rep.hasFrequency() || !rep.hasFrequencyMax() && rep.getFrequency() == 1) {
                    st = "Once";
                } else {
                    st = Integer.toString(rep.getFrequency());
                    if (rep.hasFrequencyMax()) {
                        st = st + "-" + Integer.toString(rep.getFrequency());
                    }
                }
                if (rep.hasPeriod()) {
                    st = st + " per " + rep.getPeriod().toPlainString();
                    if (rep.hasPeriodMax()) {
                        st = st + "-" + rep.getPeriodMax().toPlainString();
                    }
                    st = st + " " + this.displayTimeUnits(rep.getPeriodUnit());
                }
                b.append("Do " + st);
            }
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasEnd()) {
                b.append("Until " + rep.getBoundsPeriod().getEndElement().toHumanDisplay());
            }
        }
        return b.toString();
    }

    private String displayEventCode(Timing.EventTiming when) {
        switch (when) {
            case C: {
                return "at meals";
            }
            case CD: {
                return "at lunch";
            }
            case CM: {
                return "at breakfast";
            }
            case CV: {
                return "at dinner";
            }
            case AC: {
                return "before meals";
            }
            case ACD: {
                return "before lunch";
            }
            case ACM: {
                return "before breakfast";
            }
            case ACV: {
                return "before dinner";
            }
            case HS: {
                return "before sleeping";
            }
            case PC: {
                return "after meals";
            }
            case PCD: {
                return "after lunch";
            }
            case PCM: {
                return "after breakfast";
            }
            case PCV: {
                return "after dinner";
            }
            case WAKE: {
                return "after waking";
            }
        }
        return "?ngen-6?";
    }

    private String displayTimeUnits(Timing.UnitsOfTime units) {
        if (units == null) {
            return "?ngen-7?";
        }
        switch (units) {
            case A: {
                return "years";
            }
            case D: {
                return "days";
            }
            case H: {
                return "hours";
            }
            case MIN: {
                return "minutes";
            }
            case MO: {
                return "months";
            }
            case S: {
                return "seconds";
            }
            case WK: {
                return "weeks";
            }
        }
        return "?ngen-8?";
    }

    protected void renderTiming(XhtmlNode x, Timing s2) throws FHIRException {
        x.addText(this.displayTiming(s2));
    }

    private String displaySampledData(SampledData s2) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s2.hasOrigin()) {
            b.append("Origin: " + this.displayQuantity(s2.getOrigin()));
        }
        if (s2.hasPeriod()) {
            b.append("Period: " + s2.getPeriod().toString());
        }
        if (s2.hasFactor()) {
            b.append("Factor: " + s2.getFactor().toString());
        }
        if (s2.hasLowerLimit()) {
            b.append("Lower: " + s2.getLowerLimit().toString());
        }
        if (s2.hasUpperLimit()) {
            b.append("Upper: " + s2.getUpperLimit().toString());
        }
        if (s2.hasDimensions()) {
            b.append("Dimensions: " + s2.getDimensions());
        }
        if (s2.hasData()) {
            b.append("Data: " + s2.getData());
        }
        return b.toString();
    }

    protected void renderSampledData(XhtmlNode x, SampledData sampledData) {
        x.addText(this.displaySampledData(sampledData));
    }

    public RenderingContext getContext() {
        return this.context;
    }
}

