/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="SubscriptionStatus", profile="http://hl7.org/fhir/StructureDefinition/SubscriptionStatus")
public class SubscriptionStatus
extends DomainResource {
    @Child(name="notificationType", type={CodeType.class}, order=0, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="handshake | heartbeat | event-notification", formalDefinition="The type of event being conveyed with this notificaiton.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-notification-type")
    protected Enumeration<SubscriptionNotificationType> notificationType;
    @Child(name="eventsSinceSubscriptionStart", type={Integer64Type.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Events since the Subscription was created", formalDefinition="The total number of actual events which have been generated since the Subscription was created (inclusive of this notification) - regardless of how many have been successfully communicated.  This number is NOT incremented for handshake and heartbeat notifications.")
    protected Integer64Type eventsSinceSubscriptionStart;
    @Child(name="eventsInNotification", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Events in this notification", formalDefinition="The total number of actual events represented within this notification.  For handshake and heartbeat notifications, this will be zero or not present.  For event-notifications, this number may be one or more, depending on server batching.")
    protected IntegerType eventsInNotification;
    @Child(name="subscription", type={Subscription.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to the Subscription responsible for this notification", formalDefinition="The reference to the Subscription which generated this notification.")
    protected Reference subscription;
    @Child(name="status", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="requested | active | error | off", formalDefinition="The status of the subscription, which marks the server state for managing the subscription.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subscription-state")
    protected Enumeration<Enumerations.SubscriptionState> status;
    @Child(name="topic", type={SubscriptionTopic.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to the SubscriptionTopic this notification relates to", formalDefinition="The reference to the SubscriptionTopic for the Subscription which generated this notification.")
    protected Reference topic;
    private static final long serialVersionUID = -1378030794L;

    public SubscriptionStatus() {
    }

    public SubscriptionStatus(SubscriptionNotificationType notificationType, Reference subscription, Reference topic) {
        this.setNotificationType(notificationType);
        this.setSubscription(subscription);
        this.setTopic(topic);
    }

    public Enumeration<SubscriptionNotificationType> getNotificationTypeElement() {
        if (this.notificationType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.notificationType");
            }
            if (Configuration.doAutoCreate()) {
                this.notificationType = new Enumeration<SubscriptionNotificationType>(new SubscriptionNotificationTypeEnumFactory());
            }
        }
        return this.notificationType;
    }

    public boolean hasNotificationTypeElement() {
        return this.notificationType != null && !this.notificationType.isEmpty();
    }

    public boolean hasNotificationType() {
        return this.notificationType != null && !this.notificationType.isEmpty();
    }

    public SubscriptionStatus setNotificationTypeElement(Enumeration<SubscriptionNotificationType> value) {
        this.notificationType = value;
        return this;
    }

    public SubscriptionNotificationType getNotificationType() {
        return this.notificationType == null ? null : (SubscriptionNotificationType)((Object)this.notificationType.getValue());
    }

    public SubscriptionStatus setNotificationType(SubscriptionNotificationType value) {
        if (this.notificationType == null) {
            this.notificationType = new Enumeration<SubscriptionNotificationType>(new SubscriptionNotificationTypeEnumFactory());
        }
        this.notificationType.setValue((Object)value);
        return this;
    }

    public Integer64Type getEventsSinceSubscriptionStartElement() {
        if (this.eventsSinceSubscriptionStart == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.eventsSinceSubscriptionStart");
            }
            if (Configuration.doAutoCreate()) {
                this.eventsSinceSubscriptionStart = new Integer64Type();
            }
        }
        return this.eventsSinceSubscriptionStart;
    }

    public boolean hasEventsSinceSubscriptionStartElement() {
        return this.eventsSinceSubscriptionStart != null && !this.eventsSinceSubscriptionStart.isEmpty();
    }

    public boolean hasEventsSinceSubscriptionStart() {
        return this.eventsSinceSubscriptionStart != null && !this.eventsSinceSubscriptionStart.isEmpty();
    }

    public SubscriptionStatus setEventsSinceSubscriptionStartElement(Integer64Type value) {
        this.eventsSinceSubscriptionStart = value;
        return this;
    }

    public long getEventsSinceSubscriptionStart() {
        return this.eventsSinceSubscriptionStart == null || this.eventsSinceSubscriptionStart.isEmpty() ? 0L : (Long)this.eventsSinceSubscriptionStart.getValue();
    }

    public SubscriptionStatus setEventsSinceSubscriptionStart(long value) {
        this.eventsSinceSubscriptionStart = new Integer64Type();
        this.eventsSinceSubscriptionStart.setValue((Object)value);
        return this;
    }

    public IntegerType getEventsInNotificationElement() {
        if (this.eventsInNotification == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.eventsInNotification");
            }
            if (Configuration.doAutoCreate()) {
                this.eventsInNotification = new IntegerType();
            }
        }
        return this.eventsInNotification;
    }

    public boolean hasEventsInNotificationElement() {
        return this.eventsInNotification != null && !this.eventsInNotification.isEmpty();
    }

    public boolean hasEventsInNotification() {
        return this.eventsInNotification != null && !this.eventsInNotification.isEmpty();
    }

    public SubscriptionStatus setEventsInNotificationElement(IntegerType value) {
        this.eventsInNotification = value;
        return this;
    }

    public int getEventsInNotification() {
        return this.eventsInNotification == null || this.eventsInNotification.isEmpty() ? 0 : (Integer)this.eventsInNotification.getValue();
    }

    public SubscriptionStatus setEventsInNotification(int value) {
        if (this.eventsInNotification == null) {
            this.eventsInNotification = new IntegerType();
        }
        this.eventsInNotification.setValue((Object)value);
        return this;
    }

    public Reference getSubscription() {
        if (this.subscription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.subscription");
            }
            if (Configuration.doAutoCreate()) {
                this.subscription = new Reference();
            }
        }
        return this.subscription;
    }

    public boolean hasSubscription() {
        return this.subscription != null && !this.subscription.isEmpty();
    }

    public SubscriptionStatus setSubscription(Reference value) {
        this.subscription = value;
        return this;
    }

    public Enumeration<Enumerations.SubscriptionState> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.SubscriptionState>(new Enumerations.SubscriptionStateEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SubscriptionStatus setStatusElement(Enumeration<Enumerations.SubscriptionState> value) {
        this.status = value;
        return this;
    }

    public Enumerations.SubscriptionState getStatus() {
        return this.status == null ? null : (Enumerations.SubscriptionState)((Object)this.status.getValue());
    }

    public SubscriptionStatus setStatus(Enumerations.SubscriptionState value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<Enumerations.SubscriptionState>(new Enumerations.SubscriptionStateEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getTopic() {
        if (this.topic == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubscriptionStatus.topic");
            }
            if (Configuration.doAutoCreate()) {
                this.topic = new Reference();
            }
        }
        return this.topic;
    }

    public boolean hasTopic() {
        return this.topic != null && !this.topic.isEmpty();
    }

    public SubscriptionStatus setTopic(Reference value) {
        this.topic = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("notificationType", "code", "The type of event being conveyed with this notificaiton.", 0, 1, this.notificationType));
        children.add(new Property("eventsSinceSubscriptionStart", "integer64", "The total number of actual events which have been generated since the Subscription was created (inclusive of this notification) - regardless of how many have been successfully communicated.  This number is NOT incremented for handshake and heartbeat notifications.", 0, 1, this.eventsSinceSubscriptionStart));
        children.add(new Property("eventsInNotification", "integer", "The total number of actual events represented within this notification.  For handshake and heartbeat notifications, this will be zero or not present.  For event-notifications, this number may be one or more, depending on server batching.", 0, 1, this.eventsInNotification));
        children.add(new Property("subscription", "Reference(Subscription)", "The reference to the Subscription which generated this notification.", 0, 1, this.subscription));
        children.add(new Property("status", "code", "The status of the subscription, which marks the server state for managing the subscription.", 0, 1, this.status));
        children.add(new Property("topic", "Reference(SubscriptionTopic)", "The reference to the SubscriptionTopic for the Subscription which generated this notification.", 0, 1, this.topic));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1611538117: {
                return new Property("notificationType", "code", "The type of event being conveyed with this notificaiton.", 0, 1, this.notificationType);
            }
            case 304566692: {
                return new Property("eventsSinceSubscriptionStart", "integer64", "The total number of actual events which have been generated since the Subscription was created (inclusive of this notification) - regardless of how many have been successfully communicated.  This number is NOT incremented for handshake and heartbeat notifications.", 0, 1, this.eventsSinceSubscriptionStart);
            }
            case 191408169: {
                return new Property("eventsInNotification", "integer", "The total number of actual events represented within this notification.  For handshake and heartbeat notifications, this will be zero or not present.  For event-notifications, this number may be one or more, depending on server batching.", 0, 1, this.eventsInNotification);
            }
            case 341203229: {
                return new Property("subscription", "Reference(Subscription)", "The reference to the Subscription which generated this notification.", 0, 1, this.subscription);
            }
            case -892481550: {
                return new Property("status", "code", "The status of the subscription, which marks the server state for managing the subscription.", 0, 1, this.status);
            }
            case 110546223: {
                return new Property("topic", "Reference(SubscriptionTopic)", "The reference to the SubscriptionTopic for the Subscription which generated this notification.", 0, 1, this.topic);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1611538117: {
                Base[] baseArray;
                if (this.notificationType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.notificationType;
                }
                return baseArray;
            }
            case 304566692: {
                Base[] baseArray;
                if (this.eventsSinceSubscriptionStart == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.eventsSinceSubscriptionStart;
                }
                return baseArray;
            }
            case 191408169: {
                Base[] baseArray;
                if (this.eventsInNotification == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.eventsInNotification;
                }
                return baseArray;
            }
            case 341203229: {
                Base[] baseArray;
                if (this.subscription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subscription;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case 110546223: {
                Base[] baseArray;
                if (this.topic == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.topic;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1611538117: {
                value = new SubscriptionNotificationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.notificationType = value;
                return value;
            }
            case 304566692: {
                this.eventsSinceSubscriptionStart = TypeConvertor.castToInteger64(value);
                return value;
            }
            case 191408169: {
                this.eventsInNotification = TypeConvertor.castToInteger(value);
                return value;
            }
            case 341203229: {
                this.subscription = TypeConvertor.castToReference(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.SubscriptionStateEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 110546223: {
                this.topic = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("notificationType")) {
            value = new SubscriptionNotificationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.notificationType = value;
        } else if (name.equals("eventsSinceSubscriptionStart")) {
            this.eventsSinceSubscriptionStart = TypeConvertor.castToInteger64(value);
        } else if (name.equals("eventsInNotification")) {
            this.eventsInNotification = TypeConvertor.castToInteger(value);
        } else if (name.equals("subscription")) {
            this.subscription = TypeConvertor.castToReference(value);
        } else if (name.equals("status")) {
            value = new Enumerations.SubscriptionStateEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("topic")) {
            this.topic = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1611538117: {
                return this.getNotificationTypeElement();
            }
            case 304566692: {
                return this.getEventsSinceSubscriptionStartElement();
            }
            case 191408169: {
                return this.getEventsInNotificationElement();
            }
            case 341203229: {
                return this.getSubscription();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 110546223: {
                return this.getTopic();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1611538117: {
                return new String[]{"code"};
            }
            case 304566692: {
                return new String[]{"integer64"};
            }
            case 191408169: {
                return new String[]{"integer"};
            }
            case 341203229: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 110546223: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("notificationType")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.notificationType");
        }
        if (name.equals("eventsSinceSubscriptionStart")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.eventsSinceSubscriptionStart");
        }
        if (name.equals("eventsInNotification")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.eventsInNotification");
        }
        if (name.equals("subscription")) {
            this.subscription = new Reference();
            return this.subscription;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubscriptionStatus.status");
        }
        if (name.equals("topic")) {
            this.topic = new Reference();
            return this.topic;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubscriptionStatus";
    }

    @Override
    public SubscriptionStatus copy() {
        SubscriptionStatus dst = new SubscriptionStatus();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SubscriptionStatus dst) {
        super.copyValues(dst);
        dst.notificationType = this.notificationType == null ? null : this.notificationType.copy();
        dst.eventsSinceSubscriptionStart = this.eventsSinceSubscriptionStart == null ? null : this.eventsSinceSubscriptionStart.copy();
        dst.eventsInNotification = this.eventsInNotification == null ? null : this.eventsInNotification.copy();
        dst.subscription = this.subscription == null ? null : this.subscription.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.topic = this.topic == null ? null : this.topic.copy();
    }

    protected SubscriptionStatus typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionStatus)) {
            return false;
        }
        SubscriptionStatus o = (SubscriptionStatus)other_;
        return SubscriptionStatus.compareDeep(this.notificationType, o.notificationType, true) && SubscriptionStatus.compareDeep(this.eventsSinceSubscriptionStart, o.eventsSinceSubscriptionStart, true) && SubscriptionStatus.compareDeep(this.eventsInNotification, o.eventsInNotification, true) && SubscriptionStatus.compareDeep(this.subscription, o.subscription, true) && SubscriptionStatus.compareDeep(this.status, o.status, true) && SubscriptionStatus.compareDeep(this.topic, o.topic, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubscriptionStatus)) {
            return false;
        }
        SubscriptionStatus o = (SubscriptionStatus)other_;
        return SubscriptionStatus.compareValues(this.notificationType, o.notificationType, true) && SubscriptionStatus.compareValues(this.eventsSinceSubscriptionStart, o.eventsSinceSubscriptionStart, true) && SubscriptionStatus.compareValues(this.eventsInNotification, o.eventsInNotification, true) && SubscriptionStatus.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.notificationType, this.eventsSinceSubscriptionStart, this.eventsInNotification, this.subscription, this.status, this.topic);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubscriptionStatus;
    }

    public static class SubscriptionNotificationTypeEnumFactory
    implements EnumFactory<SubscriptionNotificationType> {
        @Override
        public SubscriptionNotificationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("handshake".equals(codeString)) {
                return SubscriptionNotificationType.HANDSHAKE;
            }
            if ("heartbeat".equals(codeString)) {
                return SubscriptionNotificationType.HEARTBEAT;
            }
            if ("event-notification".equals(codeString)) {
                return SubscriptionNotificationType.EVENTNOTIFICATION;
            }
            throw new IllegalArgumentException("Unknown SubscriptionNotificationType code '" + codeString + "'");
        }

        public Enumeration<SubscriptionNotificationType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SubscriptionNotificationType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("handshake".equals(codeString)) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.HANDSHAKE);
            }
            if ("heartbeat".equals(codeString)) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.HEARTBEAT);
            }
            if ("event-notification".equals(codeString)) {
                return new Enumeration<SubscriptionNotificationType>(this, SubscriptionNotificationType.EVENTNOTIFICATION);
            }
            throw new FHIRException("Unknown SubscriptionNotificationType code '" + codeString + "'");
        }

        @Override
        public String toCode(SubscriptionNotificationType code) {
            if (code == SubscriptionNotificationType.HANDSHAKE) {
                return "handshake";
            }
            if (code == SubscriptionNotificationType.HEARTBEAT) {
                return "heartbeat";
            }
            if (code == SubscriptionNotificationType.EVENTNOTIFICATION) {
                return "event-notification";
            }
            return "?";
        }

        @Override
        public String toSystem(SubscriptionNotificationType code) {
            return code.getSystem();
        }
    }

    public static enum SubscriptionNotificationType {
        HANDSHAKE,
        HEARTBEAT,
        EVENTNOTIFICATION,
        NULL;


        public static SubscriptionNotificationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("handshake".equals(codeString)) {
                return HANDSHAKE;
            }
            if ("heartbeat".equals(codeString)) {
                return HEARTBEAT;
            }
            if ("event-notification".equals(codeString)) {
                return EVENTNOTIFICATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SubscriptionNotificationType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HANDSHAKE: {
                    return "handshake";
                }
                case HEARTBEAT: {
                    return "heartbeat";
                }
                case EVENTNOTIFICATION: {
                    return "event-notification";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HANDSHAKE: {
                    return "http://hl7.org/fhir/subscription-notification-type";
                }
                case HEARTBEAT: {
                    return "http://hl7.org/fhir/subscription-notification-type";
                }
                case EVENTNOTIFICATION: {
                    return "http://hl7.org/fhir/subscription-notification-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HANDSHAKE: {
                    return "The notification is being sent as part of the setup or verification of a communications channel.";
                }
                case HEARTBEAT: {
                    return "The notification is being sent because there has not been a notification generated over an extended period of time.";
                }
                case EVENTNOTIFICATION: {
                    return "The notification is being sent due to an event for the subscriber.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HANDSHAKE: {
                    return "Handshake";
                }
                case HEARTBEAT: {
                    return "Heartbeat";
                }
                case EVENTNOTIFICATION: {
                    return "Event Notification";
                }
            }
            return "?";
        }
    }
}

