/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ResearchSubject", profile="http://hl7.org/fhir/StructureDefinition/ResearchSubject")
public class ResearchSubject
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for research subject in a study", formalDefinition="Identifiers assigned to this research subject for a study.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="candidate | eligible | follow-up | ineligible | not-registered | off-study | on-study | on-study-intervention | on-study-observation | pending-on-study | potential-candidate | screening | withdrawn", formalDefinition="The current state of the subject.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-status")
    protected Enumeration<ResearchSubjectStatus> status;
    @Child(name="progress", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Subject status", formalDefinition="The current state (status) of the subject and resons for status change where appropriate.")
    protected List<ResearchSubjectProgressComponent> progress;
    @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end of participation", formalDefinition="The dates the subject began and ended their participation in the study.")
    protected Period period;
    @Child(name="study", type={ResearchStudy.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Study subject is part of", formalDefinition="Reference to the study the subject is participating in.")
    protected Reference study;
    @Child(name="individual", type={Patient.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is part of study", formalDefinition="The record of the person or animal who is involved in the study.")
    protected Reference individual;
    @Child(name="assignedArm", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What path should be followed", formalDefinition="The name of the arm in the study the subject is expected to follow as part of this study.")
    protected StringType assignedArm;
    @Child(name="actualArm", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What path was followed", formalDefinition="The name of the arm in the study the subject actually followed as part of this study.")
    protected StringType actualArm;
    @Child(name="consent", type={Consent.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Agreement to participate in study", formalDefinition="A record of the patient's informed agreement to participate in the study.")
    protected Reference consent;
    private static final long serialVersionUID = 2110072351L;
    @SearchParamDefinition(name="date", path="ResearchSubject.period", description="Start and end of participation", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ResearchSubject.identifier", description="Business Identifier for research subject in a study", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="individual", path="ResearchSubject.individual", description="Who is part of study", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_INDIVIDUAL = "individual";
    public static final ReferenceClientParam INDIVIDUAL = new ReferenceClientParam("individual");
    public static final Include INCLUDE_INDIVIDUAL = new Include("ResearchSubject:individual").toLocked();
    @SearchParamDefinition(name="patient", path="ResearchSubject.individual", description="Who is part of study", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ResearchSubject:patient").toLocked();
    @SearchParamDefinition(name="state", path="ResearchSubject.progress.state", description="candidate | eligible | follow-up | ineligible | not-registered | off-study | on-study | on-study-intervention | on-study-observation | pending-on-study | potential-candidate | screening | withdrawn", type="token")
    public static final String SP_STATE = "state";
    public static final TokenClientParam STATE = new TokenClientParam("state");
    @SearchParamDefinition(name="status", path="ResearchSubject.status", description="candidate | eligible | follow-up | ineligible | not-registered | off-study | on-study | on-study-intervention | on-study-observation | pending-on-study | potential-candidate | screening | withdrawn", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="study", path="ResearchSubject.study", description="Study subject is part of", type="reference", target={ResearchStudy.class})
    public static final String SP_STUDY = "study";
    public static final ReferenceClientParam STUDY = new ReferenceClientParam("study");
    public static final Include INCLUDE_STUDY = new Include("ResearchSubject:study").toLocked();

    public ResearchSubject() {
    }

    public ResearchSubject(ResearchSubjectStatus status, Reference study, Reference individual) {
        this.setStatus(status);
        this.setStudy(study);
        this.setIndividual(individual);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ResearchSubject setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ResearchSubject addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ResearchSubjectStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ResearchSubjectStatus>(new ResearchSubjectStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ResearchSubject setStatusElement(Enumeration<ResearchSubjectStatus> value) {
        this.status = value;
        return this;
    }

    public ResearchSubjectStatus getStatus() {
        return this.status == null ? null : (ResearchSubjectStatus)((Object)this.status.getValue());
    }

    public ResearchSubject setStatus(ResearchSubjectStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ResearchSubjectStatus>(new ResearchSubjectStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<ResearchSubjectProgressComponent> getProgress() {
        if (this.progress == null) {
            this.progress = new ArrayList<ResearchSubjectProgressComponent>();
        }
        return this.progress;
    }

    public ResearchSubject setProgress(List<ResearchSubjectProgressComponent> theProgress) {
        this.progress = theProgress;
        return this;
    }

    public boolean hasProgress() {
        if (this.progress == null) {
            return false;
        }
        for (ResearchSubjectProgressComponent item : this.progress) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchSubjectProgressComponent addProgress() {
        ResearchSubjectProgressComponent t = new ResearchSubjectProgressComponent();
        if (this.progress == null) {
            this.progress = new ArrayList<ResearchSubjectProgressComponent>();
        }
        this.progress.add(t);
        return t;
    }

    public ResearchSubject addProgress(ResearchSubjectProgressComponent t) {
        if (t == null) {
            return this;
        }
        if (this.progress == null) {
            this.progress = new ArrayList<ResearchSubjectProgressComponent>();
        }
        this.progress.add(t);
        return this;
    }

    public ResearchSubjectProgressComponent getProgressFirstRep() {
        if (this.getProgress().isEmpty()) {
            this.addProgress();
        }
        return this.getProgress().get(0);
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ResearchSubject setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getStudy() {
        if (this.study == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.study");
            }
            if (Configuration.doAutoCreate()) {
                this.study = new Reference();
            }
        }
        return this.study;
    }

    public boolean hasStudy() {
        return this.study != null && !this.study.isEmpty();
    }

    public ResearchSubject setStudy(Reference value) {
        this.study = value;
        return this;
    }

    public Reference getIndividual() {
        if (this.individual == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.individual");
            }
            if (Configuration.doAutoCreate()) {
                this.individual = new Reference();
            }
        }
        return this.individual;
    }

    public boolean hasIndividual() {
        return this.individual != null && !this.individual.isEmpty();
    }

    public ResearchSubject setIndividual(Reference value) {
        this.individual = value;
        return this;
    }

    public StringType getAssignedArmElement() {
        if (this.assignedArm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.assignedArm");
            }
            if (Configuration.doAutoCreate()) {
                this.assignedArm = new StringType();
            }
        }
        return this.assignedArm;
    }

    public boolean hasAssignedArmElement() {
        return this.assignedArm != null && !this.assignedArm.isEmpty();
    }

    public boolean hasAssignedArm() {
        return this.assignedArm != null && !this.assignedArm.isEmpty();
    }

    public ResearchSubject setAssignedArmElement(StringType value) {
        this.assignedArm = value;
        return this;
    }

    public String getAssignedArm() {
        return this.assignedArm == null ? null : (String)this.assignedArm.getValue();
    }

    public ResearchSubject setAssignedArm(String value) {
        if (Utilities.noString(value)) {
            this.assignedArm = null;
        } else {
            if (this.assignedArm == null) {
                this.assignedArm = new StringType();
            }
            this.assignedArm.setValue(value);
        }
        return this;
    }

    public StringType getActualArmElement() {
        if (this.actualArm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.actualArm");
            }
            if (Configuration.doAutoCreate()) {
                this.actualArm = new StringType();
            }
        }
        return this.actualArm;
    }

    public boolean hasActualArmElement() {
        return this.actualArm != null && !this.actualArm.isEmpty();
    }

    public boolean hasActualArm() {
        return this.actualArm != null && !this.actualArm.isEmpty();
    }

    public ResearchSubject setActualArmElement(StringType value) {
        this.actualArm = value;
        return this;
    }

    public String getActualArm() {
        return this.actualArm == null ? null : (String)this.actualArm.getValue();
    }

    public ResearchSubject setActualArm(String value) {
        if (Utilities.noString(value)) {
            this.actualArm = null;
        } else {
            if (this.actualArm == null) {
                this.actualArm = new StringType();
            }
            this.actualArm.setValue(value);
        }
        return this;
    }

    public Reference getConsent() {
        if (this.consent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.consent");
            }
            if (Configuration.doAutoCreate()) {
                this.consent = new Reference();
            }
        }
        return this.consent;
    }

    public boolean hasConsent() {
        return this.consent != null && !this.consent.isEmpty();
    }

    public ResearchSubject setConsent(Reference value) {
        this.consent = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research subject for a study.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The current state of the subject.", 0, 1, this.status));
        children.add(new Property("progress", "", "The current state (status) of the subject and resons for status change where appropriate.", 0, Integer.MAX_VALUE, this.progress));
        children.add(new Property("period", "Period", "The dates the subject began and ended their participation in the study.", 0, 1, this.period));
        children.add(new Property(SP_STUDY, "Reference(ResearchStudy)", "Reference to the study the subject is participating in.", 0, 1, this.study));
        children.add(new Property(SP_INDIVIDUAL, "Reference(Patient)", "The record of the person or animal who is involved in the study.", 0, 1, this.individual));
        children.add(new Property("assignedArm", "string", "The name of the arm in the study the subject is expected to follow as part of this study.", 0, 1, this.assignedArm));
        children.add(new Property("actualArm", "string", "The name of the arm in the study the subject actually followed as part of this study.", 0, 1, this.actualArm));
        children.add(new Property("consent", "Reference(Consent)", "A record of the patient's informed agreement to participate in the study.", 0, 1, this.consent));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research subject for a study.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the subject.", 0, 1, this.status);
            }
            case -1001078227: {
                return new Property("progress", "", "The current state (status) of the subject and resons for status change where appropriate.", 0, Integer.MAX_VALUE, this.progress);
            }
            case -991726143: {
                return new Property("period", "Period", "The dates the subject began and ended their participation in the study.", 0, 1, this.period);
            }
            case 109776329: {
                return new Property(SP_STUDY, "Reference(ResearchStudy)", "Reference to the study the subject is participating in.", 0, 1, this.study);
            }
            case -46292327: {
                return new Property(SP_INDIVIDUAL, "Reference(Patient)", "The record of the person or animal who is involved in the study.", 0, 1, this.individual);
            }
            case 1741912494: {
                return new Property("assignedArm", "string", "The name of the arm in the study the subject is expected to follow as part of this study.", 0, 1, this.assignedArm);
            }
            case 528827886: {
                return new Property("actualArm", "string", "The name of the arm in the study the subject actually followed as part of this study.", 0, 1, this.actualArm);
            }
            case 951500826: {
                return new Property("consent", "Reference(Consent)", "A record of the patient's informed agreement to participate in the study.", 0, 1, this.consent);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1001078227: {
                return this.progress == null ? new Base[]{} : this.progress.toArray(new Base[this.progress.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.period;
                }
                return baseArray;
            }
            case 109776329: {
                Base[] baseArray;
                if (this.study == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.study;
                }
                return baseArray;
            }
            case -46292327: {
                Base[] baseArray;
                if (this.individual == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.individual;
                }
                return baseArray;
            }
            case 1741912494: {
                Base[] baseArray;
                if (this.assignedArm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.assignedArm;
                }
                return baseArray;
            }
            case 528827886: {
                Base[] baseArray;
                if (this.actualArm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.actualArm;
                }
                return baseArray;
            }
            case 951500826: {
                Base[] baseArray;
                if (this.consent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.consent;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ResearchSubjectStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1001078227: {
                this.getProgress().add((ResearchSubjectProgressComponent)((Object)value));
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 109776329: {
                this.study = TypeConvertor.castToReference(value);
                return value;
            }
            case -46292327: {
                this.individual = TypeConvertor.castToReference(value);
                return value;
            }
            case 1741912494: {
                this.assignedArm = TypeConvertor.castToString(value);
                return value;
            }
            case 528827886: {
                this.actualArm = TypeConvertor.castToString(value);
                return value;
            }
            case 951500826: {
                this.consent = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ResearchSubjectStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("progress")) {
            this.getProgress().add((ResearchSubjectProgressComponent)((Object)value));
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_STUDY)) {
            this.study = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_INDIVIDUAL)) {
            this.individual = TypeConvertor.castToReference(value);
        } else if (name.equals("assignedArm")) {
            this.assignedArm = TypeConvertor.castToString(value);
        } else if (name.equals("actualArm")) {
            this.actualArm = TypeConvertor.castToString(value);
        } else if (name.equals("consent")) {
            this.consent = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1001078227: {
                return this.addProgress();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 109776329: {
                return this.getStudy();
            }
            case -46292327: {
                return this.getIndividual();
            }
            case 1741912494: {
                return this.getAssignedArmElement();
            }
            case 528827886: {
                return this.getActualArmElement();
            }
            case 951500826: {
                return this.getConsent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1001078227: {
                return new String[0];
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 109776329: {
                return new String[]{"Reference"};
            }
            case -46292327: {
                return new String[]{"Reference"};
            }
            case 1741912494: {
                return new String[]{"string"};
            }
            case 528827886: {
                return new String[]{"string"};
            }
            case 951500826: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.status");
        }
        if (name.equals("progress")) {
            return this.addProgress();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_STUDY)) {
            this.study = new Reference();
            return this.study;
        }
        if (name.equals(SP_INDIVIDUAL)) {
            this.individual = new Reference();
            return this.individual;
        }
        if (name.equals("assignedArm")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.assignedArm");
        }
        if (name.equals("actualArm")) {
            throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.actualArm");
        }
        if (name.equals("consent")) {
            this.consent = new Reference();
            return this.consent;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ResearchSubject";
    }

    @Override
    public ResearchSubject copy() {
        ResearchSubject dst = new ResearchSubject();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ResearchSubject dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<ResearchSubjectStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.progress != null) {
            dst.progress = new ArrayList<ResearchSubjectProgressComponent>();
            for (ResearchSubjectProgressComponent researchSubjectProgressComponent : this.progress) {
                dst.progress.add(researchSubjectProgressComponent.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        dst.study = this.study == null ? null : this.study.copy();
        dst.individual = this.individual == null ? null : this.individual.copy();
        dst.assignedArm = this.assignedArm == null ? null : this.assignedArm.copy();
        dst.actualArm = this.actualArm == null ? null : this.actualArm.copy();
        dst.consent = this.consent == null ? null : this.consent.copy();
    }

    protected ResearchSubject typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchSubject)) {
            return false;
        }
        ResearchSubject o = (ResearchSubject)other_;
        return ResearchSubject.compareDeep(this.identifier, o.identifier, true) && ResearchSubject.compareDeep(this.status, o.status, true) && ResearchSubject.compareDeep(this.progress, o.progress, true) && ResearchSubject.compareDeep(this.period, o.period, true) && ResearchSubject.compareDeep(this.study, o.study, true) && ResearchSubject.compareDeep(this.individual, o.individual, true) && ResearchSubject.compareDeep(this.assignedArm, o.assignedArm, true) && ResearchSubject.compareDeep(this.actualArm, o.actualArm, true) && ResearchSubject.compareDeep(this.consent, o.consent, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchSubject)) {
            return false;
        }
        ResearchSubject o = (ResearchSubject)other_;
        return ResearchSubject.compareValues(this.status, o.status, true) && ResearchSubject.compareValues(this.assignedArm, o.assignedArm, true) && ResearchSubject.compareValues(this.actualArm, o.actualArm, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.progress, this.period, this.study, this.individual, this.assignedArm, this.actualArm, this.consent);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ResearchSubject;
    }

    @Block
    public static class ResearchSubjectProgressComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of state that is being described", formalDefinition="Identifies the aspect of the subject's journey that the state refers to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-state-type")
        protected CodeableConcept type;
        @Child(name="state", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="candidate | eligible | follow-up | ineligible | not-registered | off-study | on-study | on-study-intervention | on-study-observation | pending-on-study | potential-candidate | screening | withdrawn", formalDefinition="The current state of the subject.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-state")
        protected CodeableConcept state;
        @Child(name="milestone", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="SignedUp | Screened | Randomized", formalDefinition="The milestones the subject has passed through.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-milestone")
        protected CodeableConcept milestone;
        @Child(name="reason", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="State change reason", formalDefinition="The reason for the state change.  If coded it should follow the formal subject state model.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/state-change-reason")
        protected CodeableConcept reason;
        @Child(name="startDate", type={DateTimeType.class}, order=5, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="State change date", formalDefinition="The date when the change in status occurred.")
        protected DateTimeType startDate;
        private static final long serialVersionUID = -29864900L;

        public ResearchSubjectProgressComponent() {
        }

        public ResearchSubjectProgressComponent(Date startDate) {
            this.setStartDate(startDate);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ResearchSubjectProgressComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getState() {
            if (this.state == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.state");
                }
                if (Configuration.doAutoCreate()) {
                    this.state = new CodeableConcept();
                }
            }
            return this.state;
        }

        public boolean hasState() {
            return this.state != null && !this.state.isEmpty();
        }

        public ResearchSubjectProgressComponent setState(CodeableConcept value) {
            this.state = value;
            return this;
        }

        public CodeableConcept getMilestone() {
            if (this.milestone == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.milestone");
                }
                if (Configuration.doAutoCreate()) {
                    this.milestone = new CodeableConcept();
                }
            }
            return this.milestone;
        }

        public boolean hasMilestone() {
            return this.milestone != null && !this.milestone.isEmpty();
        }

        public ResearchSubjectProgressComponent setMilestone(CodeableConcept value) {
            this.milestone = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public ResearchSubjectProgressComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        public DateTimeType getStartDateElement() {
            if (this.startDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.startDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.startDate = new DateTimeType();
                }
            }
            return this.startDate;
        }

        public boolean hasStartDateElement() {
            return this.startDate != null && !this.startDate.isEmpty();
        }

        public boolean hasStartDate() {
            return this.startDate != null && !this.startDate.isEmpty();
        }

        public ResearchSubjectProgressComponent setStartDateElement(DateTimeType value) {
            this.startDate = value;
            return this;
        }

        public Date getStartDate() {
            return this.startDate == null ? null : (Date)this.startDate.getValue();
        }

        public ResearchSubjectProgressComponent setStartDate(Date value) {
            if (this.startDate == null) {
                this.startDate = new DateTimeType();
            }
            this.startDate.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Identifies the aspect of the subject's journey that the state refers to.", 0, 1, this.type));
            children.add(new Property(ResearchSubject.SP_STATE, "CodeableConcept", "The current state of the subject.", 0, 1, this.state));
            children.add(new Property("milestone", "CodeableConcept", "The milestones the subject has passed through.", 0, 1, this.milestone));
            children.add(new Property("reason", "CodeableConcept", "The reason for the state change.  If coded it should follow the formal subject state model.", 0, 1, this.reason));
            children.add(new Property("startDate", "dateTime", "The date when the change in status occurred.", 0, 1, this.startDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Identifies the aspect of the subject's journey that the state refers to.", 0, 1, this.type);
                }
                case 109757585: {
                    return new Property(ResearchSubject.SP_STATE, "CodeableConcept", "The current state of the subject.", 0, 1, this.state);
                }
                case -1065084560: {
                    return new Property("milestone", "CodeableConcept", "The milestones the subject has passed through.", 0, 1, this.milestone);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "The reason for the state change.  If coded it should follow the formal subject state model.", 0, 1, this.reason);
                }
                case -2129778896: {
                    return new Property("startDate", "dateTime", "The date when the change in status occurred.", 0, 1, this.startDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 109757585: {
                    Base[] baseArray;
                    if (this.state == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.state;
                    }
                    return baseArray;
                }
                case -1065084560: {
                    Base[] baseArray;
                    if (this.milestone == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.milestone;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.reason;
                    }
                    return baseArray;
                }
                case -2129778896: {
                    Base[] baseArray;
                    if (this.startDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.startDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 109757585: {
                    this.state = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1065084560: {
                    this.milestone = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.reason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2129778896: {
                    this.startDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(ResearchSubject.SP_STATE)) {
                this.state = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("milestone")) {
                this.milestone = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("startDate")) {
                this.startDate = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 109757585: {
                    return this.getState();
                }
                case -1065084560: {
                    return this.getMilestone();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -2129778896: {
                    return this.getStartDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 109757585: {
                    return new String[]{"CodeableConcept"};
                }
                case -1065084560: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case -2129778896: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(ResearchSubject.SP_STATE)) {
                this.state = new CodeableConcept();
                return this.state;
            }
            if (name.equals("milestone")) {
                this.milestone = new CodeableConcept();
                return this.milestone;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            if (name.equals("startDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type ResearchSubject.progress.startDate");
            }
            return super.addChild(name);
        }

        @Override
        public ResearchSubjectProgressComponent copy() {
            ResearchSubjectProgressComponent dst = new ResearchSubjectProgressComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchSubjectProgressComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.state = this.state == null ? null : this.state.copy();
            dst.milestone = this.milestone == null ? null : this.milestone.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.startDate = this.startDate == null ? null : this.startDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchSubjectProgressComponent)) {
                return false;
            }
            ResearchSubjectProgressComponent o = (ResearchSubjectProgressComponent)other_;
            return ResearchSubjectProgressComponent.compareDeep(this.type, o.type, true) && ResearchSubjectProgressComponent.compareDeep(this.state, o.state, true) && ResearchSubjectProgressComponent.compareDeep(this.milestone, o.milestone, true) && ResearchSubjectProgressComponent.compareDeep(this.reason, o.reason, true) && ResearchSubjectProgressComponent.compareDeep(this.startDate, o.startDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchSubjectProgressComponent)) {
                return false;
            }
            ResearchSubjectProgressComponent o = (ResearchSubjectProgressComponent)other_;
            return ResearchSubjectProgressComponent.compareValues(this.startDate, o.startDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.state, this.milestone, this.reason, this.startDate);
        }

        @Override
        public String fhirType() {
            return "ResearchSubject.progress";
        }
    }

    public static class ResearchSubjectStatusEnumFactory
    implements EnumFactory<ResearchSubjectStatus> {
        @Override
        public ResearchSubjectStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("candidate".equals(codeString)) {
                return ResearchSubjectStatus.CANDIDATE;
            }
            if ("eligible".equals(codeString)) {
                return ResearchSubjectStatus.ELIGIBLE;
            }
            if ("follow-up".equals(codeString)) {
                return ResearchSubjectStatus.FOLLOWUP;
            }
            if ("ineligible".equals(codeString)) {
                return ResearchSubjectStatus.INELIGIBLE;
            }
            if ("not-registered".equals(codeString)) {
                return ResearchSubjectStatus.NOTREGISTERED;
            }
            if ("off-study".equals(codeString)) {
                return ResearchSubjectStatus.OFFSTUDY;
            }
            if ("on-study".equals(codeString)) {
                return ResearchSubjectStatus.ONSTUDY;
            }
            if ("on-study-intervention".equals(codeString)) {
                return ResearchSubjectStatus.ONSTUDYINTERVENTION;
            }
            if ("on-study-observation".equals(codeString)) {
                return ResearchSubjectStatus.ONSTUDYOBSERVATION;
            }
            if ("pending-on-study".equals(codeString)) {
                return ResearchSubjectStatus.PENDINGONSTUDY;
            }
            if ("potential-candidate".equals(codeString)) {
                return ResearchSubjectStatus.POTENTIALCANDIDATE;
            }
            if ("screening".equals(codeString)) {
                return ResearchSubjectStatus.SCREENING;
            }
            if ("withdrawn".equals(codeString)) {
                return ResearchSubjectStatus.WITHDRAWN;
            }
            throw new IllegalArgumentException("Unknown ResearchSubjectStatus code '" + codeString + "'");
        }

        public Enumeration<ResearchSubjectStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ResearchSubjectStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("candidate".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.CANDIDATE);
            }
            if ("eligible".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.ELIGIBLE);
            }
            if ("follow-up".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.FOLLOWUP);
            }
            if ("ineligible".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.INELIGIBLE);
            }
            if ("not-registered".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.NOTREGISTERED);
            }
            if ("off-study".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.OFFSTUDY);
            }
            if ("on-study".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.ONSTUDY);
            }
            if ("on-study-intervention".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.ONSTUDYINTERVENTION);
            }
            if ("on-study-observation".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.ONSTUDYOBSERVATION);
            }
            if ("pending-on-study".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.PENDINGONSTUDY);
            }
            if ("potential-candidate".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.POTENTIALCANDIDATE);
            }
            if ("screening".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.SCREENING);
            }
            if ("withdrawn".equals(codeString)) {
                return new Enumeration<ResearchSubjectStatus>(this, ResearchSubjectStatus.WITHDRAWN);
            }
            throw new FHIRException("Unknown ResearchSubjectStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ResearchSubjectStatus code) {
            if (code == ResearchSubjectStatus.CANDIDATE) {
                return "candidate";
            }
            if (code == ResearchSubjectStatus.ELIGIBLE) {
                return "eligible";
            }
            if (code == ResearchSubjectStatus.FOLLOWUP) {
                return "follow-up";
            }
            if (code == ResearchSubjectStatus.INELIGIBLE) {
                return "ineligible";
            }
            if (code == ResearchSubjectStatus.NOTREGISTERED) {
                return "not-registered";
            }
            if (code == ResearchSubjectStatus.OFFSTUDY) {
                return "off-study";
            }
            if (code == ResearchSubjectStatus.ONSTUDY) {
                return "on-study";
            }
            if (code == ResearchSubjectStatus.ONSTUDYINTERVENTION) {
                return "on-study-intervention";
            }
            if (code == ResearchSubjectStatus.ONSTUDYOBSERVATION) {
                return "on-study-observation";
            }
            if (code == ResearchSubjectStatus.PENDINGONSTUDY) {
                return "pending-on-study";
            }
            if (code == ResearchSubjectStatus.POTENTIALCANDIDATE) {
                return "potential-candidate";
            }
            if (code == ResearchSubjectStatus.SCREENING) {
                return "screening";
            }
            if (code == ResearchSubjectStatus.WITHDRAWN) {
                return "withdrawn";
            }
            return "?";
        }

        @Override
        public String toSystem(ResearchSubjectStatus code) {
            return code.getSystem();
        }
    }

    public static enum ResearchSubjectStatus {
        CANDIDATE,
        ELIGIBLE,
        FOLLOWUP,
        INELIGIBLE,
        NOTREGISTERED,
        OFFSTUDY,
        ONSTUDY,
        ONSTUDYINTERVENTION,
        ONSTUDYOBSERVATION,
        PENDINGONSTUDY,
        POTENTIALCANDIDATE,
        SCREENING,
        WITHDRAWN,
        NULL;


        public static ResearchSubjectStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("candidate".equals(codeString)) {
                return CANDIDATE;
            }
            if ("eligible".equals(codeString)) {
                return ELIGIBLE;
            }
            if ("follow-up".equals(codeString)) {
                return FOLLOWUP;
            }
            if ("ineligible".equals(codeString)) {
                return INELIGIBLE;
            }
            if ("not-registered".equals(codeString)) {
                return NOTREGISTERED;
            }
            if ("off-study".equals(codeString)) {
                return OFFSTUDY;
            }
            if ("on-study".equals(codeString)) {
                return ONSTUDY;
            }
            if ("on-study-intervention".equals(codeString)) {
                return ONSTUDYINTERVENTION;
            }
            if ("on-study-observation".equals(codeString)) {
                return ONSTUDYOBSERVATION;
            }
            if ("pending-on-study".equals(codeString)) {
                return PENDINGONSTUDY;
            }
            if ("potential-candidate".equals(codeString)) {
                return POTENTIALCANDIDATE;
            }
            if ("screening".equals(codeString)) {
                return SCREENING;
            }
            if ("withdrawn".equals(codeString)) {
                return WITHDRAWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ResearchSubjectStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CANDIDATE: {
                    return "candidate";
                }
                case ELIGIBLE: {
                    return "eligible";
                }
                case FOLLOWUP: {
                    return "follow-up";
                }
                case INELIGIBLE: {
                    return "ineligible";
                }
                case NOTREGISTERED: {
                    return "not-registered";
                }
                case OFFSTUDY: {
                    return "off-study";
                }
                case ONSTUDY: {
                    return "on-study";
                }
                case ONSTUDYINTERVENTION: {
                    return "on-study-intervention";
                }
                case ONSTUDYOBSERVATION: {
                    return "on-study-observation";
                }
                case PENDINGONSTUDY: {
                    return "pending-on-study";
                }
                case POTENTIALCANDIDATE: {
                    return "potential-candidate";
                }
                case SCREENING: {
                    return "screening";
                }
                case WITHDRAWN: {
                    return "withdrawn";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CANDIDATE: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case ELIGIBLE: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case FOLLOWUP: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case INELIGIBLE: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case NOTREGISTERED: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case OFFSTUDY: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case ONSTUDY: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case ONSTUDYINTERVENTION: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case ONSTUDYOBSERVATION: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case PENDINGONSTUDY: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case POTENTIALCANDIDATE: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case SCREENING: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
                case WITHDRAWN: {
                    return "http://hl7.org/fhir/research-subject-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CANDIDATE: {
                    return "An identified person that can be considered for inclusion in a study.";
                }
                case ELIGIBLE: {
                    return "A person that has met the eligibility criteria for inclusion in a study.";
                }
                case FOLLOWUP: {
                    return "A person is no longer receiving study intervention and/or being evaluated with tests and procedures according to the protocol, but they are being monitored on a protocol-prescribed schedule.";
                }
                case INELIGIBLE: {
                    return "A person who did not meet one or more criteria required for participation in a study is considered to have failed screening or\nis ineligible for the study.";
                }
                case NOTREGISTERED: {
                    return "A person for whom registration was not completed.";
                }
                case OFFSTUDY: {
                    return "A person that has ended their participation on a study either because their treatment/observation is complete or through not\nresponding, withdrawal, non-compliance and/or adverse event.";
                }
                case ONSTUDY: {
                    return "A person that is enrolled or registered on a study.";
                }
                case ONSTUDYINTERVENTION: {
                    return "The person is receiving the treatment or participating in an activity (e.g. yoga, diet, etc.) that the study is evaluating.";
                }
                case ONSTUDYOBSERVATION: {
                    return "The subject is being evaluated via tests and assessments according to the study calendar, but is not receiving any intervention. Note that this state is study-dependent and might not exist in all studies.  A synonym for this is \"short-term follow-up\".";
                }
                case PENDINGONSTUDY: {
                    return "A person is pre-registered for a study.";
                }
                case POTENTIALCANDIDATE: {
                    return "A person that is potentially eligible for participation in the study.";
                }
                case SCREENING: {
                    return "A person who is being evaluated for eligibility for a study.";
                }
                case WITHDRAWN: {
                    return "The person has withdrawn their participation in the study before registration.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CANDIDATE: {
                    return "Candidate";
                }
                case ELIGIBLE: {
                    return "Eligible";
                }
                case FOLLOWUP: {
                    return "Follow-up";
                }
                case INELIGIBLE: {
                    return "Ineligible";
                }
                case NOTREGISTERED: {
                    return "Not Registered";
                }
                case OFFSTUDY: {
                    return "Off-study";
                }
                case ONSTUDY: {
                    return "On-study";
                }
                case ONSTUDYINTERVENTION: {
                    return "On-study-intervention";
                }
                case ONSTUDYOBSERVATION: {
                    return "On-study-observation";
                }
                case PENDINGONSTUDY: {
                    return "Pending on-study";
                }
                case POTENTIALCANDIDATE: {
                    return "Potential Candidate";
                }
                case SCREENING: {
                    return "Screening";
                }
                case WITHDRAWN: {
                    return "Withdrawn";
                }
            }
            return "?";
        }
    }
}

