/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CatalogEntry;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUseStatement;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceFocus;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImmunizationRecommendation", profile="http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation")
public class ImmunizationRecommendation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="A unique identifier assigned to this particular recommendation record.")
    protected List<Identifier> identifier;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who this profile is for", formalDefinition="The patient the recommendation(s) are for.")
    protected Reference patient;
    @Child(name="date", type={DateTimeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date recommendation(s) created", formalDefinition="The date the immunization recommendation(s) were created.")
    protected DateTimeType date;
    @Child(name="authority", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who is responsible for protocol", formalDefinition="Indicates the authority who published the protocol (e.g. ACIP).")
    protected Reference authority;
    @Child(name="recommendation", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Vaccine administration recommendations", formalDefinition="Vaccine administration recommendations.")
    protected List<ImmunizationRecommendationRecommendationComponent> recommendation;
    private static final long serialVersionUID = 534427937L;
    @SearchParamDefinition(name="date", path="ImmunizationRecommendation.date", description="Date recommendation(s) created", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ImmunizationRecommendation.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="information", path="ImmunizationRecommendation.recommendation.supportingPatientInformation", description="Patient observations supporting recommendation", type="reference", target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUseStatement.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceFocus.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_INFORMATION = "information";
    public static final ReferenceClientParam INFORMATION = new ReferenceClientParam("information");
    public static final Include INCLUDE_INFORMATION = new Include("ImmunizationRecommendation:information").toLocked();
    @SearchParamDefinition(name="patient", path="ImmunizationRecommendation.patient", description="Who this profile is for", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImmunizationRecommendation:patient").toLocked();
    @SearchParamDefinition(name="status", path="ImmunizationRecommendation.recommendation.forecastStatus", description="Vaccine recommendation status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="support", path="ImmunizationRecommendation.recommendation.supportingImmunization", description="Past immunizations supporting recommendation", type="reference", target={Immunization.class, ImmunizationEvaluation.class})
    public static final String SP_SUPPORT = "support";
    public static final ReferenceClientParam SUPPORT = new ReferenceClientParam("support");
    public static final Include INCLUDE_SUPPORT = new Include("ImmunizationRecommendation:support").toLocked();
    @SearchParamDefinition(name="target-disease", path="ImmunizationRecommendation.recommendation.targetDisease", description="Disease to be immunized against", type="token")
    public static final String SP_TARGET_DISEASE = "target-disease";
    public static final TokenClientParam TARGET_DISEASE = new TokenClientParam("target-disease");
    @SearchParamDefinition(name="vaccine-type", path="ImmunizationRecommendation.recommendation.vaccineCode", description="Vaccine  or vaccine group recommendation applies to", type="token")
    public static final String SP_VACCINE_TYPE = "vaccine-type";
    public static final TokenClientParam VACCINE_TYPE = new TokenClientParam("vaccine-type");

    public ImmunizationRecommendation() {
    }

    public ImmunizationRecommendation(Reference patient, Date date, ImmunizationRecommendationRecommendationComponent recommendation) {
        this.setPatient(patient);
        this.setDate(date);
        this.addRecommendation(recommendation);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ImmunizationRecommendation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ImmunizationRecommendation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImmunizationRecommendation setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ImmunizationRecommendation setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ImmunizationRecommendation setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    public Reference getAuthority() {
        if (this.authority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImmunizationRecommendation.authority");
            }
            if (Configuration.doAutoCreate()) {
                this.authority = new Reference();
            }
        }
        return this.authority;
    }

    public boolean hasAuthority() {
        return this.authority != null && !this.authority.isEmpty();
    }

    public ImmunizationRecommendation setAuthority(Reference value) {
        this.authority = value;
        return this;
    }

    public List<ImmunizationRecommendationRecommendationComponent> getRecommendation() {
        if (this.recommendation == null) {
            this.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        }
        return this.recommendation;
    }

    public ImmunizationRecommendation setRecommendation(List<ImmunizationRecommendationRecommendationComponent> theRecommendation) {
        this.recommendation = theRecommendation;
        return this;
    }

    public boolean hasRecommendation() {
        if (this.recommendation == null) {
            return false;
        }
        for (ImmunizationRecommendationRecommendationComponent item : this.recommendation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImmunizationRecommendationRecommendationComponent addRecommendation() {
        ImmunizationRecommendationRecommendationComponent t = new ImmunizationRecommendationRecommendationComponent();
        if (this.recommendation == null) {
            this.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        }
        this.recommendation.add(t);
        return t;
    }

    public ImmunizationRecommendation addRecommendation(ImmunizationRecommendationRecommendationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.recommendation == null) {
            this.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
        }
        this.recommendation.add(t);
        return this;
    }

    public ImmunizationRecommendationRecommendationComponent getRecommendationFirstRep() {
        if (this.getRecommendation().isEmpty()) {
            this.addRecommendation();
        }
        return this.getRecommendation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this particular recommendation record.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient the recommendation(s) are for.", 0, 1, this.patient));
        children.add(new Property(SP_DATE, "dateTime", "The date the immunization recommendation(s) were created.", 0, 1, this.date));
        children.add(new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol (e.g. ACIP).", 0, 1, this.authority));
        children.add(new Property("recommendation", "", "Vaccine administration recommendations.", 0, Integer.MAX_VALUE, this.recommendation));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this particular recommendation record.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient the recommendation(s) are for.", 0, 1, this.patient);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date the immunization recommendation(s) were created.", 0, 1, this.date);
            }
            case 1475610435: {
                return new Property("authority", "Reference(Organization)", "Indicates the authority who published the protocol (e.g. ACIP).", 0, 1, this.authority);
            }
            case -1028636743: {
                return new Property("recommendation", "", "Vaccine administration recommendations.", 0, Integer.MAX_VALUE, this.recommendation);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.patient;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.date;
                }
                return baseArray;
            }
            case 1475610435: {
                Base[] baseArray;
                if (this.authority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.authority;
                }
                return baseArray;
            }
            case -1028636743: {
                return this.recommendation == null ? new Base[]{} : this.recommendation.toArray(new Base[this.recommendation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1475610435: {
                this.authority = TypeConvertor.castToReference(value);
                return value;
            }
            case -1028636743: {
                this.getRecommendation().add((ImmunizationRecommendationRecommendationComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("authority")) {
            this.authority = TypeConvertor.castToReference(value);
        } else if (name.equals("recommendation")) {
            this.getRecommendation().add((ImmunizationRecommendationRecommendationComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1475610435: {
                return this.getAuthority();
            }
            case -1028636743: {
                return this.addRecommendation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1475610435: {
                return new String[]{"Reference"};
            }
            case -1028636743: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.date");
        }
        if (name.equals("authority")) {
            this.authority = new Reference();
            return this.authority;
        }
        if (name.equals("recommendation")) {
            return this.addRecommendation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImmunizationRecommendation";
    }

    @Override
    public ImmunizationRecommendation copy() {
        ImmunizationRecommendation dst = new ImmunizationRecommendation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ImmunizationRecommendation dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.date = this.date == null ? null : this.date.copy();
        Reference reference = dst.authority = this.authority == null ? null : this.authority.copy();
        if (this.recommendation != null) {
            dst.recommendation = new ArrayList<ImmunizationRecommendationRecommendationComponent>();
            for (ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent : this.recommendation) {
                dst.recommendation.add(immunizationRecommendationRecommendationComponent.copy());
            }
        }
    }

    protected ImmunizationRecommendation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImmunizationRecommendation)) {
            return false;
        }
        ImmunizationRecommendation o = (ImmunizationRecommendation)other_;
        return ImmunizationRecommendation.compareDeep(this.identifier, o.identifier, true) && ImmunizationRecommendation.compareDeep(this.patient, o.patient, true) && ImmunizationRecommendation.compareDeep(this.date, o.date, true) && ImmunizationRecommendation.compareDeep(this.authority, o.authority, true) && ImmunizationRecommendation.compareDeep(this.recommendation, o.recommendation, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImmunizationRecommendation)) {
            return false;
        }
        ImmunizationRecommendation o = (ImmunizationRecommendation)other_;
        return ImmunizationRecommendation.compareValues(this.date, o.date, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.patient, this.date, this.authority, this.recommendation);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImmunizationRecommendation;
    }

    @Block
    public static class ImmunizationRecommendationRecommendationDateCriterionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of date", formalDefinition="Date classification of recommendation.  For example, earliest date to give, latest date to give, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-date-criterion")
        protected CodeableConcept code;
        @Child(name="value", type={DateTimeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recommended date", formalDefinition="The date whose meaning is specified by dateCriterion.code.")
        protected DateTimeType value;
        private static final long serialVersionUID = 1036994566L;

        public ImmunizationRecommendationRecommendationDateCriterionComponent() {
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent(CodeableConcept code, Date value) {
            this.setCode(code);
            this.setValue(value);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationDateCriterionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DateTimeType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationDateCriterionComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DateTimeType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setValueElement(DateTimeType value) {
            this.value = value;
            return this;
        }

        public Date getValue() {
            return this.value == null ? null : (Date)this.value.getValue();
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent setValue(Date value) {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Date classification of recommendation.  For example, earliest date to give, latest date to give, etc.", 0, 1, this.code));
            children.add(new Property("value", "dateTime", "The date whose meaning is specified by dateCriterion.code.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Date classification of recommendation.  For example, earliest date to give, latest date to give, etc.", 0, 1, this.code);
                }
                case 111972721: {
                    return new Property("value", "dateTime", "The date whose meaning is specified by dateCriterion.code.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.recommendation.dateCriterion.value");
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationRecommendationRecommendationDateCriterionComponent copy() {
            ImmunizationRecommendationRecommendationDateCriterionComponent dst = new ImmunizationRecommendationRecommendationDateCriterionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImmunizationRecommendationRecommendationDateCriterionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationRecommendationRecommendationDateCriterionComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationDateCriterionComponent o = (ImmunizationRecommendationRecommendationDateCriterionComponent)other_;
            return ImmunizationRecommendationRecommendationDateCriterionComponent.compareDeep(this.code, o.code, true) && ImmunizationRecommendationRecommendationDateCriterionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationRecommendationRecommendationDateCriterionComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationDateCriterionComponent o = (ImmunizationRecommendationRecommendationDateCriterionComponent)other_;
            return ImmunizationRecommendationRecommendationDateCriterionComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.value);
        }

        @Override
        public String fhirType() {
            return "ImmunizationRecommendation.recommendation.dateCriterion";
        }
    }

    @Block
    public static class ImmunizationRecommendationRecommendationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="vaccineCode", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Vaccine  or vaccine group recommendation applies to", formalDefinition="Vaccine(s) or vaccine group that pertain to the recommendation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/vaccine-code")
        protected List<CodeableConcept> vaccineCode;
        @Child(name="targetDisease", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Disease to be immunized against", formalDefinition="The targeted disease for the recommendation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-target-disease")
        protected List<CodeableConcept> targetDisease;
        @Child(name="contraindicatedVaccineCode", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Vaccine which is contraindicated to fulfill the recommendation", formalDefinition="Vaccine(s) which should not be used to fulfill the recommendation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/vaccine-code")
        protected List<CodeableConcept> contraindicatedVaccineCode;
        @Child(name="forecastStatus", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=true, summary=true)
        @Description(shortDefinition="Vaccine recommendation status", formalDefinition="Indicates the patient status with respect to the path to immunity for the target disease.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-status")
        protected CodeableConcept forecastStatus;
        @Child(name="forecastReason", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Vaccine administration status reason", formalDefinition="The reason for the assigned forecast status.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-reason")
        protected List<CodeableConcept> forecastReason;
        @Child(name="dateCriterion", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dates governing proposed immunization", formalDefinition="Vaccine date recommendations.  For example, earliest date to administer, latest date to administer, etc.")
        protected List<ImmunizationRecommendationRecommendationDateCriterionComponent> dateCriterion;
        @Child(name="description", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Protocol details", formalDefinition="Contains the description about the protocol under which the vaccine was administered.")
        protected StringType description;
        @Child(name="series", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of vaccination series", formalDefinition="One possible path to achieve presumed immunity against a disease - within the context of an authority.")
        protected StringType series;
        @Child(name="doseNumber", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Recommended dose number within series", formalDefinition="Nominal position of the recommended dose in a series as determined by the evaluation and forecasting process (e.g. dose 2 is the next recommended dose).")
        protected StringType doseNumber;
        @Child(name="seriesDoses", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recommended number of doses for immunity", formalDefinition="The recommended number of doses to achieve immunity as determined by the evaluation and forecasting process.")
        protected StringType seriesDoses;
        @Child(name="supportingImmunization", type={Immunization.class, ImmunizationEvaluation.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Past immunizations supporting recommendation", formalDefinition="Immunization event history and/or evaluation that supports the status and recommendation.")
        protected List<Reference> supportingImmunization;
        @Child(name="supportingPatientInformation", type={Reference.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Patient observations supporting recommendation", formalDefinition="Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.")
        protected List<Reference> supportingPatientInformation;
        private static final long serialVersionUID = 1333936348L;

        public ImmunizationRecommendationRecommendationComponent() {
        }

        public ImmunizationRecommendationRecommendationComponent(CodeableConcept forecastStatus) {
            this.setForecastStatus(forecastStatus);
        }

        public List<CodeableConcept> getVaccineCode() {
            if (this.vaccineCode == null) {
                this.vaccineCode = new ArrayList<CodeableConcept>();
            }
            return this.vaccineCode;
        }

        public ImmunizationRecommendationRecommendationComponent setVaccineCode(List<CodeableConcept> theVaccineCode) {
            this.vaccineCode = theVaccineCode;
            return this;
        }

        public boolean hasVaccineCode() {
            if (this.vaccineCode == null) {
                return false;
            }
            for (CodeableConcept item : this.vaccineCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addVaccineCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.vaccineCode == null) {
                this.vaccineCode = new ArrayList<CodeableConcept>();
            }
            this.vaccineCode.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addVaccineCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.vaccineCode == null) {
                this.vaccineCode = new ArrayList<CodeableConcept>();
            }
            this.vaccineCode.add(t);
            return this;
        }

        public CodeableConcept getVaccineCodeFirstRep() {
            if (this.getVaccineCode().isEmpty()) {
                this.addVaccineCode();
            }
            return this.getVaccineCode().get(0);
        }

        public List<CodeableConcept> getTargetDisease() {
            if (this.targetDisease == null) {
                this.targetDisease = new ArrayList<CodeableConcept>();
            }
            return this.targetDisease;
        }

        public ImmunizationRecommendationRecommendationComponent setTargetDisease(List<CodeableConcept> theTargetDisease) {
            this.targetDisease = theTargetDisease;
            return this;
        }

        public boolean hasTargetDisease() {
            if (this.targetDisease == null) {
                return false;
            }
            for (CodeableConcept item : this.targetDisease) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addTargetDisease() {
            CodeableConcept t = new CodeableConcept();
            if (this.targetDisease == null) {
                this.targetDisease = new ArrayList<CodeableConcept>();
            }
            this.targetDisease.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addTargetDisease(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.targetDisease == null) {
                this.targetDisease = new ArrayList<CodeableConcept>();
            }
            this.targetDisease.add(t);
            return this;
        }

        public CodeableConcept getTargetDiseaseFirstRep() {
            if (this.getTargetDisease().isEmpty()) {
                this.addTargetDisease();
            }
            return this.getTargetDisease().get(0);
        }

        public List<CodeableConcept> getContraindicatedVaccineCode() {
            if (this.contraindicatedVaccineCode == null) {
                this.contraindicatedVaccineCode = new ArrayList<CodeableConcept>();
            }
            return this.contraindicatedVaccineCode;
        }

        public ImmunizationRecommendationRecommendationComponent setContraindicatedVaccineCode(List<CodeableConcept> theContraindicatedVaccineCode) {
            this.contraindicatedVaccineCode = theContraindicatedVaccineCode;
            return this;
        }

        public boolean hasContraindicatedVaccineCode() {
            if (this.contraindicatedVaccineCode == null) {
                return false;
            }
            for (CodeableConcept item : this.contraindicatedVaccineCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addContraindicatedVaccineCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.contraindicatedVaccineCode == null) {
                this.contraindicatedVaccineCode = new ArrayList<CodeableConcept>();
            }
            this.contraindicatedVaccineCode.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addContraindicatedVaccineCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.contraindicatedVaccineCode == null) {
                this.contraindicatedVaccineCode = new ArrayList<CodeableConcept>();
            }
            this.contraindicatedVaccineCode.add(t);
            return this;
        }

        public CodeableConcept getContraindicatedVaccineCodeFirstRep() {
            if (this.getContraindicatedVaccineCode().isEmpty()) {
                this.addContraindicatedVaccineCode();
            }
            return this.getContraindicatedVaccineCode().get(0);
        }

        public CodeableConcept getForecastStatus() {
            if (this.forecastStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.forecastStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.forecastStatus = new CodeableConcept();
                }
            }
            return this.forecastStatus;
        }

        public boolean hasForecastStatus() {
            return this.forecastStatus != null && !this.forecastStatus.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setForecastStatus(CodeableConcept value) {
            this.forecastStatus = value;
            return this;
        }

        public List<CodeableConcept> getForecastReason() {
            if (this.forecastReason == null) {
                this.forecastReason = new ArrayList<CodeableConcept>();
            }
            return this.forecastReason;
        }

        public ImmunizationRecommendationRecommendationComponent setForecastReason(List<CodeableConcept> theForecastReason) {
            this.forecastReason = theForecastReason;
            return this;
        }

        public boolean hasForecastReason() {
            if (this.forecastReason == null) {
                return false;
            }
            for (CodeableConcept item : this.forecastReason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addForecastReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.forecastReason == null) {
                this.forecastReason = new ArrayList<CodeableConcept>();
            }
            this.forecastReason.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addForecastReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.forecastReason == null) {
                this.forecastReason = new ArrayList<CodeableConcept>();
            }
            this.forecastReason.add(t);
            return this;
        }

        public CodeableConcept getForecastReasonFirstRep() {
            if (this.getForecastReason().isEmpty()) {
                this.addForecastReason();
            }
            return this.getForecastReason().get(0);
        }

        public List<ImmunizationRecommendationRecommendationDateCriterionComponent> getDateCriterion() {
            if (this.dateCriterion == null) {
                this.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            }
            return this.dateCriterion;
        }

        public ImmunizationRecommendationRecommendationComponent setDateCriterion(List<ImmunizationRecommendationRecommendationDateCriterionComponent> theDateCriterion) {
            this.dateCriterion = theDateCriterion;
            return this;
        }

        public boolean hasDateCriterion() {
            if (this.dateCriterion == null) {
                return false;
            }
            for (ImmunizationRecommendationRecommendationDateCriterionComponent item : this.dateCriterion) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent addDateCriterion() {
            ImmunizationRecommendationRecommendationDateCriterionComponent t = new ImmunizationRecommendationRecommendationDateCriterionComponent();
            if (this.dateCriterion == null) {
                this.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            }
            this.dateCriterion.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addDateCriterion(ImmunizationRecommendationRecommendationDateCriterionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dateCriterion == null) {
                this.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
            }
            this.dateCriterion.add(t);
            return this;
        }

        public ImmunizationRecommendationRecommendationDateCriterionComponent getDateCriterionFirstRep() {
            if (this.getDateCriterion().isEmpty()) {
                this.addDateCriterion();
            }
            return this.getDateCriterion().get(0);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImmunizationRecommendationRecommendationComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getSeriesElement() {
            if (this.series == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.series");
                }
                if (Configuration.doAutoCreate()) {
                    this.series = new StringType();
                }
            }
            return this.series;
        }

        public boolean hasSeriesElement() {
            return this.series != null && !this.series.isEmpty();
        }

        public boolean hasSeries() {
            return this.series != null && !this.series.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setSeriesElement(StringType value) {
            this.series = value;
            return this;
        }

        public String getSeries() {
            return this.series == null ? null : (String)this.series.getValue();
        }

        public ImmunizationRecommendationRecommendationComponent setSeries(String value) {
            if (Utilities.noString(value)) {
                this.series = null;
            } else {
                if (this.series == null) {
                    this.series = new StringType();
                }
                this.series.setValue(value);
            }
            return this;
        }

        public StringType getDoseNumberElement() {
            if (this.doseNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.doseNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.doseNumber = new StringType();
                }
            }
            return this.doseNumber;
        }

        public boolean hasDoseNumberElement() {
            return this.doseNumber != null && !this.doseNumber.isEmpty();
        }

        public boolean hasDoseNumber() {
            return this.doseNumber != null && !this.doseNumber.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setDoseNumberElement(StringType value) {
            this.doseNumber = value;
            return this;
        }

        public String getDoseNumber() {
            return this.doseNumber == null ? null : (String)this.doseNumber.getValue();
        }

        public ImmunizationRecommendationRecommendationComponent setDoseNumber(String value) {
            if (Utilities.noString(value)) {
                this.doseNumber = null;
            } else {
                if (this.doseNumber == null) {
                    this.doseNumber = new StringType();
                }
                this.doseNumber.setValue(value);
            }
            return this;
        }

        public StringType getSeriesDosesElement() {
            if (this.seriesDoses == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImmunizationRecommendationRecommendationComponent.seriesDoses");
                }
                if (Configuration.doAutoCreate()) {
                    this.seriesDoses = new StringType();
                }
            }
            return this.seriesDoses;
        }

        public boolean hasSeriesDosesElement() {
            return this.seriesDoses != null && !this.seriesDoses.isEmpty();
        }

        public boolean hasSeriesDoses() {
            return this.seriesDoses != null && !this.seriesDoses.isEmpty();
        }

        public ImmunizationRecommendationRecommendationComponent setSeriesDosesElement(StringType value) {
            this.seriesDoses = value;
            return this;
        }

        public String getSeriesDoses() {
            return this.seriesDoses == null ? null : (String)this.seriesDoses.getValue();
        }

        public ImmunizationRecommendationRecommendationComponent setSeriesDoses(String value) {
            if (Utilities.noString(value)) {
                this.seriesDoses = null;
            } else {
                if (this.seriesDoses == null) {
                    this.seriesDoses = new StringType();
                }
                this.seriesDoses.setValue(value);
            }
            return this;
        }

        public List<Reference> getSupportingImmunization() {
            if (this.supportingImmunization == null) {
                this.supportingImmunization = new ArrayList<Reference>();
            }
            return this.supportingImmunization;
        }

        public ImmunizationRecommendationRecommendationComponent setSupportingImmunization(List<Reference> theSupportingImmunization) {
            this.supportingImmunization = theSupportingImmunization;
            return this;
        }

        public boolean hasSupportingImmunization() {
            if (this.supportingImmunization == null) {
                return false;
            }
            for (Reference item : this.supportingImmunization) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSupportingImmunization() {
            Reference t = new Reference();
            if (this.supportingImmunization == null) {
                this.supportingImmunization = new ArrayList<Reference>();
            }
            this.supportingImmunization.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addSupportingImmunization(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.supportingImmunization == null) {
                this.supportingImmunization = new ArrayList<Reference>();
            }
            this.supportingImmunization.add(t);
            return this;
        }

        public Reference getSupportingImmunizationFirstRep() {
            if (this.getSupportingImmunization().isEmpty()) {
                this.addSupportingImmunization();
            }
            return this.getSupportingImmunization().get(0);
        }

        public List<Reference> getSupportingPatientInformation() {
            if (this.supportingPatientInformation == null) {
                this.supportingPatientInformation = new ArrayList<Reference>();
            }
            return this.supportingPatientInformation;
        }

        public ImmunizationRecommendationRecommendationComponent setSupportingPatientInformation(List<Reference> theSupportingPatientInformation) {
            this.supportingPatientInformation = theSupportingPatientInformation;
            return this;
        }

        public boolean hasSupportingPatientInformation() {
            if (this.supportingPatientInformation == null) {
                return false;
            }
            for (Reference item : this.supportingPatientInformation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSupportingPatientInformation() {
            Reference t = new Reference();
            if (this.supportingPatientInformation == null) {
                this.supportingPatientInformation = new ArrayList<Reference>();
            }
            this.supportingPatientInformation.add(t);
            return t;
        }

        public ImmunizationRecommendationRecommendationComponent addSupportingPatientInformation(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.supportingPatientInformation == null) {
                this.supportingPatientInformation = new ArrayList<Reference>();
            }
            this.supportingPatientInformation.add(t);
            return this;
        }

        public Reference getSupportingPatientInformationFirstRep() {
            if (this.getSupportingPatientInformation().isEmpty()) {
                this.addSupportingPatientInformation();
            }
            return this.getSupportingPatientInformation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("vaccineCode", "CodeableConcept", "Vaccine(s) or vaccine group that pertain to the recommendation.", 0, Integer.MAX_VALUE, this.vaccineCode));
            children.add(new Property("targetDisease", "CodeableConcept", "The targeted disease for the recommendation.", 0, Integer.MAX_VALUE, this.targetDisease));
            children.add(new Property("contraindicatedVaccineCode", "CodeableConcept", "Vaccine(s) which should not be used to fulfill the recommendation.", 0, Integer.MAX_VALUE, this.contraindicatedVaccineCode));
            children.add(new Property("forecastStatus", "CodeableConcept", "Indicates the patient status with respect to the path to immunity for the target disease.", 0, 1, this.forecastStatus));
            children.add(new Property("forecastReason", "CodeableConcept", "The reason for the assigned forecast status.", 0, Integer.MAX_VALUE, this.forecastReason));
            children.add(new Property("dateCriterion", "", "Vaccine date recommendations.  For example, earliest date to administer, latest date to administer, etc.", 0, Integer.MAX_VALUE, this.dateCriterion));
            children.add(new Property("description", "string", "Contains the description about the protocol under which the vaccine was administered.", 0, 1, this.description));
            children.add(new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, 1, this.series));
            children.add(new Property("doseNumber", "string", "Nominal position of the recommended dose in a series as determined by the evaluation and forecasting process (e.g. dose 2 is the next recommended dose).", 0, 1, this.doseNumber));
            children.add(new Property("seriesDoses", "string", "The recommended number of doses to achieve immunity as determined by the evaluation and forecasting process.", 0, 1, this.seriesDoses));
            children.add(new Property("supportingImmunization", "Reference(Immunization|ImmunizationEvaluation)", "Immunization event history and/or evaluation that supports the status and recommendation.", 0, Integer.MAX_VALUE, this.supportingImmunization));
            children.add(new Property("supportingPatientInformation", "Reference(Any)", "Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.", 0, Integer.MAX_VALUE, this.supportingPatientInformation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 664556354: {
                    return new Property("vaccineCode", "CodeableConcept", "Vaccine(s) or vaccine group that pertain to the recommendation.", 0, Integer.MAX_VALUE, this.vaccineCode);
                }
                case -319593813: {
                    return new Property("targetDisease", "CodeableConcept", "The targeted disease for the recommendation.", 0, Integer.MAX_VALUE, this.targetDisease);
                }
                case 571105240: {
                    return new Property("contraindicatedVaccineCode", "CodeableConcept", "Vaccine(s) which should not be used to fulfill the recommendation.", 0, Integer.MAX_VALUE, this.contraindicatedVaccineCode);
                }
                case 1904598477: {
                    return new Property("forecastStatus", "CodeableConcept", "Indicates the patient status with respect to the path to immunity for the target disease.", 0, 1, this.forecastStatus);
                }
                case 1862115359: {
                    return new Property("forecastReason", "CodeableConcept", "The reason for the assigned forecast status.", 0, Integer.MAX_VALUE, this.forecastReason);
                }
                case 2087518867: {
                    return new Property("dateCriterion", "", "Vaccine date recommendations.  For example, earliest date to administer, latest date to administer, etc.", 0, Integer.MAX_VALUE, this.dateCriterion);
                }
                case -1724546052: {
                    return new Property("description", "string", "Contains the description about the protocol under which the vaccine was administered.", 0, 1, this.description);
                }
                case -905838985: {
                    return new Property("series", "string", "One possible path to achieve presumed immunity against a disease - within the context of an authority.", 0, 1, this.series);
                }
                case -887709242: {
                    return new Property("doseNumber", "string", "Nominal position of the recommended dose in a series as determined by the evaluation and forecasting process (e.g. dose 2 is the next recommended dose).", 0, 1, this.doseNumber);
                }
                case -1936727105: {
                    return new Property("seriesDoses", "string", "The recommended number of doses to achieve immunity as determined by the evaluation and forecasting process.", 0, 1, this.seriesDoses);
                }
                case 1171592021: {
                    return new Property("supportingImmunization", "Reference(Immunization|ImmunizationEvaluation)", "Immunization event history and/or evaluation that supports the status and recommendation.", 0, Integer.MAX_VALUE, this.supportingImmunization);
                }
                case -1234160646: {
                    return new Property("supportingPatientInformation", "Reference(Any)", "Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.", 0, Integer.MAX_VALUE, this.supportingPatientInformation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 664556354: {
                    return this.vaccineCode == null ? new Base[]{} : this.vaccineCode.toArray(new Base[this.vaccineCode.size()]);
                }
                case -319593813: {
                    return this.targetDisease == null ? new Base[]{} : this.targetDisease.toArray(new Base[this.targetDisease.size()]);
                }
                case 571105240: {
                    return this.contraindicatedVaccineCode == null ? new Base[]{} : this.contraindicatedVaccineCode.toArray(new Base[this.contraindicatedVaccineCode.size()]);
                }
                case 1904598477: {
                    Base[] baseArray;
                    if (this.forecastStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.forecastStatus;
                    }
                    return baseArray;
                }
                case 1862115359: {
                    return this.forecastReason == null ? new Base[]{} : this.forecastReason.toArray(new Base[this.forecastReason.size()]);
                }
                case 2087518867: {
                    return this.dateCriterion == null ? new Base[]{} : this.dateCriterion.toArray(new Base[this.dateCriterion.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -905838985: {
                    Base[] baseArray;
                    if (this.series == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.series;
                    }
                    return baseArray;
                }
                case -887709242: {
                    Base[] baseArray;
                    if (this.doseNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.doseNumber;
                    }
                    return baseArray;
                }
                case -1936727105: {
                    Base[] baseArray;
                    if (this.seriesDoses == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.seriesDoses;
                    }
                    return baseArray;
                }
                case 1171592021: {
                    return this.supportingImmunization == null ? new Base[]{} : this.supportingImmunization.toArray(new Base[this.supportingImmunization.size()]);
                }
                case -1234160646: {
                    return this.supportingPatientInformation == null ? new Base[]{} : this.supportingPatientInformation.toArray(new Base[this.supportingPatientInformation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 664556354: {
                    this.getVaccineCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -319593813: {
                    this.getTargetDisease().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 571105240: {
                    this.getContraindicatedVaccineCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1904598477: {
                    this.forecastStatus = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1862115359: {
                    this.getForecastReason().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 2087518867: {
                    this.getDateCriterion().add((ImmunizationRecommendationRecommendationDateCriterionComponent)value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -905838985: {
                    this.series = TypeConvertor.castToString(value);
                    return value;
                }
                case -887709242: {
                    this.doseNumber = TypeConvertor.castToString(value);
                    return value;
                }
                case -1936727105: {
                    this.seriesDoses = TypeConvertor.castToString(value);
                    return value;
                }
                case 1171592021: {
                    this.getSupportingImmunization().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -1234160646: {
                    this.getSupportingPatientInformation().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("vaccineCode")) {
                this.getVaccineCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("targetDisease")) {
                this.getTargetDisease().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("contraindicatedVaccineCode")) {
                this.getContraindicatedVaccineCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("forecastStatus")) {
                this.forecastStatus = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("forecastReason")) {
                this.getForecastReason().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("dateCriterion")) {
                this.getDateCriterion().add((ImmunizationRecommendationRecommendationDateCriterionComponent)value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("series")) {
                this.series = TypeConvertor.castToString(value);
            } else if (name.equals("doseNumber")) {
                this.doseNumber = TypeConvertor.castToString(value);
            } else if (name.equals("seriesDoses")) {
                this.seriesDoses = TypeConvertor.castToString(value);
            } else if (name.equals("supportingImmunization")) {
                this.getSupportingImmunization().add(TypeConvertor.castToReference(value));
            } else if (name.equals("supportingPatientInformation")) {
                this.getSupportingPatientInformation().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 664556354: {
                    return this.addVaccineCode();
                }
                case -319593813: {
                    return this.addTargetDisease();
                }
                case 571105240: {
                    return this.addContraindicatedVaccineCode();
                }
                case 1904598477: {
                    return this.getForecastStatus();
                }
                case 1862115359: {
                    return this.addForecastReason();
                }
                case 2087518867: {
                    return this.addDateCriterion();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -905838985: {
                    return this.getSeriesElement();
                }
                case -887709242: {
                    return this.getDoseNumberElement();
                }
                case -1936727105: {
                    return this.getSeriesDosesElement();
                }
                case 1171592021: {
                    return this.addSupportingImmunization();
                }
                case -1234160646: {
                    return this.addSupportingPatientInformation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 664556354: {
                    return new String[]{"CodeableConcept"};
                }
                case -319593813: {
                    return new String[]{"CodeableConcept"};
                }
                case 571105240: {
                    return new String[]{"CodeableConcept"};
                }
                case 1904598477: {
                    return new String[]{"CodeableConcept"};
                }
                case 1862115359: {
                    return new String[]{"CodeableConcept"};
                }
                case 2087518867: {
                    return new String[0];
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -905838985: {
                    return new String[]{"string"};
                }
                case -887709242: {
                    return new String[]{"string"};
                }
                case -1936727105: {
                    return new String[]{"string"};
                }
                case 1171592021: {
                    return new String[]{"Reference"};
                }
                case -1234160646: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("vaccineCode")) {
                return this.addVaccineCode();
            }
            if (name.equals("targetDisease")) {
                return this.addTargetDisease();
            }
            if (name.equals("contraindicatedVaccineCode")) {
                return this.addContraindicatedVaccineCode();
            }
            if (name.equals("forecastStatus")) {
                this.forecastStatus = new CodeableConcept();
                return this.forecastStatus;
            }
            if (name.equals("forecastReason")) {
                return this.addForecastReason();
            }
            if (name.equals("dateCriterion")) {
                return this.addDateCriterion();
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.recommendation.description");
            }
            if (name.equals("series")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.recommendation.series");
            }
            if (name.equals("doseNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.recommendation.doseNumber");
            }
            if (name.equals("seriesDoses")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImmunizationRecommendation.recommendation.seriesDoses");
            }
            if (name.equals("supportingImmunization")) {
                return this.addSupportingImmunization();
            }
            if (name.equals("supportingPatientInformation")) {
                return this.addSupportingPatientInformation();
            }
            return super.addChild(name);
        }

        @Override
        public ImmunizationRecommendationRecommendationComponent copy() {
            ImmunizationRecommendationRecommendationComponent dst = new ImmunizationRecommendationRecommendationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImmunizationRecommendationRecommendationComponent dst) {
            super.copyValues(dst);
            if (this.vaccineCode != null) {
                dst.vaccineCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.vaccineCode) {
                    dst.vaccineCode.add(codeableConcept.copy());
                }
            }
            if (this.targetDisease != null) {
                dst.targetDisease = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.targetDisease) {
                    dst.targetDisease.add(codeableConcept.copy());
                }
            }
            if (this.contraindicatedVaccineCode != null) {
                dst.contraindicatedVaccineCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.contraindicatedVaccineCode) {
                    dst.contraindicatedVaccineCode.add(codeableConcept.copy());
                }
            }
            CodeableConcept codeableConcept = dst.forecastStatus = this.forecastStatus == null ? null : this.forecastStatus.copy();
            if (this.forecastReason != null) {
                dst.forecastReason = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.forecastReason) {
                    dst.forecastReason.add(codeableConcept2.copy());
                }
            }
            if (this.dateCriterion != null) {
                dst.dateCriterion = new ArrayList<ImmunizationRecommendationRecommendationDateCriterionComponent>();
                for (ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent : this.dateCriterion) {
                    dst.dateCriterion.add(immunizationRecommendationRecommendationDateCriterionComponent.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.series = this.series == null ? null : this.series.copy();
            dst.doseNumber = this.doseNumber == null ? null : this.doseNumber.copy();
            StringType stringType = dst.seriesDoses = this.seriesDoses == null ? null : this.seriesDoses.copy();
            if (this.supportingImmunization != null) {
                dst.supportingImmunization = new ArrayList<Reference>();
                for (Reference reference : this.supportingImmunization) {
                    dst.supportingImmunization.add(reference.copy());
                }
            }
            if (this.supportingPatientInformation != null) {
                dst.supportingPatientInformation = new ArrayList<Reference>();
                for (Reference reference : this.supportingPatientInformation) {
                    dst.supportingPatientInformation.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationRecommendationRecommendationComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationComponent o = (ImmunizationRecommendationRecommendationComponent)other_;
            return ImmunizationRecommendationRecommendationComponent.compareDeep(this.vaccineCode, o.vaccineCode, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.targetDisease, o.targetDisease, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.contraindicatedVaccineCode, o.contraindicatedVaccineCode, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.forecastStatus, o.forecastStatus, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.forecastReason, o.forecastReason, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.dateCriterion, o.dateCriterion, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.description, o.description, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.series, o.series, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.doseNumber, o.doseNumber, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.seriesDoses, o.seriesDoses, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.supportingImmunization, o.supportingImmunization, true) && ImmunizationRecommendationRecommendationComponent.compareDeep(this.supportingPatientInformation, o.supportingPatientInformation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImmunizationRecommendationRecommendationComponent)) {
                return false;
            }
            ImmunizationRecommendationRecommendationComponent o = (ImmunizationRecommendationRecommendationComponent)other_;
            return ImmunizationRecommendationRecommendationComponent.compareValues(this.description, o.description, true) && ImmunizationRecommendationRecommendationComponent.compareValues(this.series, o.series, true) && ImmunizationRecommendationRecommendationComponent.compareValues(this.doseNumber, o.doseNumber, true) && ImmunizationRecommendationRecommendationComponent.compareValues(this.seriesDoses, o.seriesDoses, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.vaccineCode, this.targetDisease, this.contraindicatedVaccineCode, this.forecastStatus, this.forecastReason, this.dateCriterion, this.description, this.series, this.doseNumber, this.seriesDoses, this.supportingImmunization, this.supportingPatientInformation);
        }

        @Override
        public String fhirType() {
            return "ImmunizationRecommendation.recommendation";
        }
    }
}

