/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.UUID;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class Factory {
    public static IdType newId(String value) {
        if (value == null) {
            return null;
        }
        IdType res = new IdType();
        res.setValue(value);
        return res;
    }

    public static StringType newString_(String value) {
        if (value == null) {
            return null;
        }
        StringType res = new StringType();
        res.setValue(value);
        return res;
    }

    public static UriType newUri(String value) throws URISyntaxException {
        if (value == null) {
            return null;
        }
        UriType res = new UriType();
        res.setValue(value);
        return res;
    }

    public static UrlType newUrl(String value) throws URISyntaxException {
        if (value == null) {
            return null;
        }
        UrlType res = new UrlType();
        res.setValue(value);
        return res;
    }

    public static CanonicalType newCanonical(String value) throws URISyntaxException {
        if (value == null) {
            return null;
        }
        CanonicalType res = new CanonicalType();
        res.setValue(value);
        return res;
    }

    public static DateTimeType newDateTime(String value) throws ParseException {
        if (value == null) {
            return null;
        }
        return new DateTimeType(value);
    }

    public static DateType newDate(String value) throws ParseException {
        if (value == null) {
            return null;
        }
        return new DateType(value);
    }

    public static CodeType newCode(String value) {
        if (value == null) {
            return null;
        }
        CodeType res = new CodeType();
        res.setValue(value);
        return res;
    }

    public static IntegerType newInteger(int value) {
        IntegerType res = new IntegerType();
        res.setValue((Object)value);
        return res;
    }

    public static IntegerType newInteger(Integer value) {
        if (value == null) {
            return null;
        }
        IntegerType res = new IntegerType();
        res.setValue(value);
        return res;
    }

    public static BooleanType newBoolean(boolean value) {
        BooleanType res = new BooleanType();
        res.setValue((Object)value);
        return res;
    }

    public static ContactPoint newContactPoint(ContactPoint.ContactPointSystem system, String value) {
        ContactPoint res = new ContactPoint();
        res.setSystem(system);
        res.setValue(value);
        return res;
    }

    public static Extension newExtension(String uri, DataType value, boolean evenIfNull) {
        if (!evenIfNull && (value == null || value.isEmpty())) {
            return null;
        }
        Extension e = new Extension();
        e.setUrl(uri);
        e.setValue(value);
        return e;
    }

    public static CodeableConcept newCodeableConcept(String code, String system, String display) {
        CodeableConcept cc = new CodeableConcept();
        Coding c = new Coding();
        c.setCode(code);
        c.setSystem(system);
        c.setDisplay(display);
        cc.getCoding().add(c);
        return cc;
    }

    public static Reference makeReference(String url) {
        Reference rr = new Reference();
        rr.setReference(url);
        return rr;
    }

    public static Narrative newNarrative(Narrative.NarrativeStatus status, String html) throws IOException, FHIRException {
        Narrative n = new Narrative();
        n.setStatus(status);
        try {
            n.setDiv(new XhtmlParser().parseFragment("<div>" + Utilities.escapeXml(html) + "</div>"));
        }
        catch (FHIRException e) {
            throw new FHIRException(e.getMessage(), e);
        }
        return n;
    }

    public static Coding makeCoding(String code) throws FHIRException {
        String[] parts = code.split("\\|");
        Coding c = new Coding();
        if (parts.length == 2) {
            c.setSystem(parts[0]);
            c.setCode(parts[1]);
        } else if (parts.length == 3) {
            c.setSystem(parts[0]);
            c.setCode(parts[1]);
            c.setDisplay(parts[2]);
        } else {
            throw new FHIRException("Unable to understand the code '" + code + "'. Use the format system|code(|display)");
        }
        return c;
    }

    public static Reference makeReference(String url, String text) {
        Reference rr = new Reference();
        rr.setReference(url);
        if (!Utilities.noString(text)) {
            rr.setDisplay(text);
        }
        return rr;
    }

    public static String createUUID() {
        return "urn:uuid:" + UUID.randomUUID().toString().toLowerCase();
    }

    public DataType create(String name) throws FHIRException {
        if (name.equals("boolean")) {
            return new BooleanType();
        }
        if (name.equals("integer")) {
            return new IntegerType();
        }
        if (name.equals("integer64")) {
            return new Integer64Type();
        }
        if (name.equals("decimal")) {
            return new DecimalType();
        }
        if (name.equals("base64Binary")) {
            return new Base64BinaryType();
        }
        if (name.equals("instant")) {
            return new InstantType();
        }
        if (name.equals("string")) {
            return new StringType();
        }
        if (name.equals("uri")) {
            return new UriType();
        }
        if (name.equals("url")) {
            return new UrlType();
        }
        if (name.equals("canonical")) {
            return new CanonicalType();
        }
        if (name.equals("date")) {
            return new DateType();
        }
        if (name.equals("dateTime")) {
            return new DateTimeType();
        }
        if (name.equals("time")) {
            return new TimeType();
        }
        if (name.equals("code")) {
            return new CodeType();
        }
        if (name.equals("oid")) {
            return new OidType();
        }
        if (name.equals("id")) {
            return new IdType();
        }
        if (name.equals("unsignedInt")) {
            return new UnsignedIntType();
        }
        if (name.equals("positiveInt")) {
            return new PositiveIntType();
        }
        if (name.equals("markdown")) {
            return new MarkdownType();
        }
        if (name.equals("Annotation")) {
            return new Annotation();
        }
        if (name.equals("Attachment")) {
            return new Attachment();
        }
        if (name.equals("Identifier")) {
            return new Identifier();
        }
        if (name.equals("CodeableConcept")) {
            return new CodeableConcept();
        }
        if (name.equals("Coding")) {
            return new Coding();
        }
        if (name.equals("Quantity")) {
            return new Quantity();
        }
        if (name.equals("Range")) {
            return new Range();
        }
        if (name.equals("Period")) {
            return new Period();
        }
        if (name.equals("Ratio")) {
            return new Ratio();
        }
        if (name.equals("SampledData")) {
            return new SampledData();
        }
        if (name.equals("Signature")) {
            return new Signature();
        }
        if (name.equals("HumanName")) {
            return new HumanName();
        }
        if (name.equals("Address")) {
            return new Address();
        }
        if (name.equals("ContactPoint")) {
            return new ContactPoint();
        }
        if (name.equals("Timing")) {
            return new Timing();
        }
        if (name.equals("Reference")) {
            return new Reference();
        }
        if (name.equals("Meta")) {
            return new Meta();
        }
        throw new FHIRException("Unknown data type name " + name);
    }
}

