/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CoverageEligibilityResponse", profile="http://hl7.org/fhir/StructureDefinition/CoverageEligibilityResponse")
public class CoverageEligibilityResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier for coverage eligiblity request", formalDefinition="A unique identifier assigned to this coverage eligiblity request.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<Enumerations.FinancialResourceStatusCodes> status;
    @Child(name="purpose", type={CodeType.class}, order=2, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="auth-requirements | benefits | discovery | validation", formalDefinition="Code to specify whether requesting: prior authorization requirements for some service categories or billing codes; benefits for coverages specified or discovered; discovery and return of coverages for the patient; and/or validation that the specified coverage is in-force at the date/period specified or 'now' if not specified.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/eligibilityresponse-purpose")
    protected List<Enumeration<EligibilityResponsePurpose>> purpose;
    @Child(name="patient", type={Patient.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Intended recipient of products and services", formalDefinition="The party who is the beneficiary of the supplied coverage and for whom eligibility is sought.")
    protected Reference patient;
    @Child(name="serviced", type={DateType.class, Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Estimated date or dates of service", formalDefinition="The date or dates when the enclosed suite of services were performed or completed.")
    protected DataType serviced;
    @Child(name="created", type={DateTimeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Response creation date", formalDefinition="The date this resource was created.")
    protected DateTimeType created;
    @Child(name="requestor", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Party responsible for the request", formalDefinition="The provider which is responsible for the request.")
    protected Reference requestor;
    @Child(name="request", type={CoverageEligibilityRequest.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Eligibility request reference", formalDefinition="Reference to the original request resource.")
    protected Reference request;
    @Child(name="outcome", type={CodeType.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="queued | complete | error | partial", formalDefinition="The outcome of the request processing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome")
    protected Enumeration<Enumerations.ClaimProcessingCodes> outcome;
    @Child(name="disposition", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition Message", formalDefinition="A human readable description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="insurer", type={Organization.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Coverage issuer", formalDefinition="The Insurer who issued the coverage in question and is the author of the response.")
    protected Reference insurer;
    @Child(name="insurance", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Patient insurance information", formalDefinition="Financial instruments for reimbursement for the health care products and services.")
    protected List<InsuranceComponent> insurance;
    @Child(name="preAuthRef", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Preauthorization reference", formalDefinition="A reference from the Insurer to which these services pertain to be used on further communication and as proof that the request occurred.")
    protected StringType preAuthRef;
    @Child(name="form", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed form identifier", formalDefinition="A code for the form to be used for printing the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/forms")
    protected CodeableConcept form;
    @Child(name="error", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing errors", formalDefinition="Errors encountered during the processing of the request.")
    protected List<ErrorsComponent> error;
    private static final long serialVersionUID = 1048956296L;
    @SearchParamDefinition(name="created", path="CoverageEligibilityResponse.created", description="The creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="disposition", path="CoverageEligibilityResponse.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");
    @SearchParamDefinition(name="identifier", path="CoverageEligibilityResponse.identifier", description="The business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="insurer", path="CoverageEligibilityResponse.insurer", description="The organization which generated this resource", type="reference", target={Organization.class})
    public static final String SP_INSURER = "insurer";
    public static final ReferenceClientParam INSURER = new ReferenceClientParam("insurer");
    public static final Include INCLUDE_INSURER = new Include("CoverageEligibilityResponse:insurer").toLocked();
    @SearchParamDefinition(name="outcome", path="CoverageEligibilityResponse.outcome", description="The processing outcome", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="patient", path="CoverageEligibilityResponse.patient", description="The reference to the patient", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("CoverageEligibilityResponse:patient").toLocked();
    @SearchParamDefinition(name="request", path="CoverageEligibilityResponse.request", description="The EligibilityRequest reference", type="reference", target={CoverageEligibilityRequest.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("CoverageEligibilityResponse:request").toLocked();
    @SearchParamDefinition(name="requestor", path="CoverageEligibilityResponse.requestor", description="The EligibilityRequest provider", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_REQUESTOR = "requestor";
    public static final ReferenceClientParam REQUESTOR = new ReferenceClientParam("requestor");
    public static final Include INCLUDE_REQUESTOR = new Include("CoverageEligibilityResponse:requestor").toLocked();
    @SearchParamDefinition(name="status", path="CoverageEligibilityResponse.status", description="The EligibilityRequest status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public CoverageEligibilityResponse() {
    }

    public CoverageEligibilityResponse(Enumerations.FinancialResourceStatusCodes status, EligibilityResponsePurpose purpose, Reference patient, Date created, Reference request, Enumerations.ClaimProcessingCodes outcome, Reference insurer) {
        this.setStatus(status);
        this.addPurpose(purpose);
        this.setPatient(patient);
        this.setCreated(created);
        this.setRequest(request);
        this.setOutcome(outcome);
        this.setInsurer(insurer);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CoverageEligibilityResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CoverageEligibilityResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.FinancialResourceStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CoverageEligibilityResponse setStatusElement(Enumeration<Enumerations.FinancialResourceStatusCodes> value) {
        this.status = value;
        return this;
    }

    public Enumerations.FinancialResourceStatusCodes getStatus() {
        return this.status == null ? null : (Enumerations.FinancialResourceStatusCodes)((Object)this.status.getValue());
    }

    public CoverageEligibilityResponse setStatus(Enumerations.FinancialResourceStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<Enumeration<EligibilityResponsePurpose>> getPurpose() {
        if (this.purpose == null) {
            this.purpose = new ArrayList<Enumeration<EligibilityResponsePurpose>>();
        }
        return this.purpose;
    }

    public CoverageEligibilityResponse setPurpose(List<Enumeration<EligibilityResponsePurpose>> thePurpose) {
        this.purpose = thePurpose;
        return this;
    }

    public boolean hasPurpose() {
        if (this.purpose == null) {
            return false;
        }
        for (Enumeration<EligibilityResponsePurpose> item : this.purpose) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<EligibilityResponsePurpose> addPurposeElement() {
        Enumeration<EligibilityResponsePurpose> t = new Enumeration<EligibilityResponsePurpose>(new EligibilityResponsePurposeEnumFactory());
        if (this.purpose == null) {
            this.purpose = new ArrayList<Enumeration<EligibilityResponsePurpose>>();
        }
        this.purpose.add(t);
        return t;
    }

    public CoverageEligibilityResponse addPurpose(EligibilityResponsePurpose value) {
        Enumeration<EligibilityResponsePurpose> t = new Enumeration<EligibilityResponsePurpose>(new EligibilityResponsePurposeEnumFactory());
        t.setValue((Object)value);
        if (this.purpose == null) {
            this.purpose = new ArrayList<Enumeration<EligibilityResponsePurpose>>();
        }
        this.purpose.add(t);
        return this;
    }

    public boolean hasPurpose(EligibilityResponsePurpose value) {
        if (this.purpose == null) {
            return false;
        }
        for (Enumeration<EligibilityResponsePurpose> v : this.purpose) {
            if (!((EligibilityResponsePurpose)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public CoverageEligibilityResponse setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public DataType getServiced() {
        return this.serviced;
    }

    public DateType getServicedDateType() throws FHIRException {
        if (this.serviced == null) {
            this.serviced = new DateType();
        }
        if (!(this.serviced instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
        }
        return (DateType)this.serviced;
    }

    public boolean hasServicedDateType() {
        return this != null && this.serviced instanceof DateType;
    }

    public Period getServicedPeriod() throws FHIRException {
        if (this.serviced == null) {
            this.serviced = new Period();
        }
        if (!(this.serviced instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
        }
        return (Period)this.serviced;
    }

    public boolean hasServicedPeriod() {
        return this != null && this.serviced instanceof Period;
    }

    public boolean hasServiced() {
        return this.serviced != null && !this.serviced.isEmpty();
    }

    public CoverageEligibilityResponse setServiced(DataType value) {
        if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
            throw new Error("Not the right type for CoverageEligibilityResponse.serviced[x]: " + value.fhirType());
        }
        this.serviced = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public CoverageEligibilityResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public CoverageEligibilityResponse setCreated(Date value) {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        this.created.setValue(value);
        return this;
    }

    public Reference getRequestor() {
        if (this.requestor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.requestor");
            }
            if (Configuration.doAutoCreate()) {
                this.requestor = new Reference();
            }
        }
        return this.requestor;
    }

    public boolean hasRequestor() {
        return this.requestor != null && !this.requestor.isEmpty();
    }

    public CoverageEligibilityResponse setRequestor(Reference value) {
        this.requestor = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public CoverageEligibilityResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Enumeration<Enumerations.ClaimProcessingCodes> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<Enumerations.ClaimProcessingCodes>(new Enumerations.ClaimProcessingCodesEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public CoverageEligibilityResponse setOutcomeElement(Enumeration<Enumerations.ClaimProcessingCodes> value) {
        this.outcome = value;
        return this;
    }

    public Enumerations.ClaimProcessingCodes getOutcome() {
        return this.outcome == null ? null : (Enumerations.ClaimProcessingCodes)((Object)this.outcome.getValue());
    }

    public CoverageEligibilityResponse setOutcome(Enumerations.ClaimProcessingCodes value) {
        if (this.outcome == null) {
            this.outcome = new Enumeration<Enumerations.ClaimProcessingCodes>(new Enumerations.ClaimProcessingCodesEnumFactory());
        }
        this.outcome.setValue((Object)value);
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public CoverageEligibilityResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public CoverageEligibilityResponse setDisposition(String value) {
        if (Utilities.noString(value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public CoverageEligibilityResponse setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public List<InsuranceComponent> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        return this.insurance;
    }

    public CoverageEligibilityResponse setInsurance(List<InsuranceComponent> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (InsuranceComponent item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsuranceComponent addInsurance() {
        InsuranceComponent t = new InsuranceComponent();
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return t;
    }

    public CoverageEligibilityResponse addInsurance(InsuranceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return this;
    }

    public InsuranceComponent getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public StringType getPreAuthRefElement() {
        if (this.preAuthRef == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.preAuthRef");
            }
            if (Configuration.doAutoCreate()) {
                this.preAuthRef = new StringType();
            }
        }
        return this.preAuthRef;
    }

    public boolean hasPreAuthRefElement() {
        return this.preAuthRef != null && !this.preAuthRef.isEmpty();
    }

    public boolean hasPreAuthRef() {
        return this.preAuthRef != null && !this.preAuthRef.isEmpty();
    }

    public CoverageEligibilityResponse setPreAuthRefElement(StringType value) {
        this.preAuthRef = value;
        return this;
    }

    public String getPreAuthRef() {
        return this.preAuthRef == null ? null : (String)this.preAuthRef.getValue();
    }

    public CoverageEligibilityResponse setPreAuthRef(String value) {
        if (Utilities.noString(value)) {
            this.preAuthRef = null;
        } else {
            if (this.preAuthRef == null) {
                this.preAuthRef = new StringType();
            }
            this.preAuthRef.setValue(value);
        }
        return this;
    }

    public CodeableConcept getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CoverageEligibilityResponse.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new CodeableConcept();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public CoverageEligibilityResponse setForm(CodeableConcept value) {
        this.form = value;
        return this;
    }

    public List<ErrorsComponent> getError() {
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        return this.error;
    }

    public CoverageEligibilityResponse setError(List<ErrorsComponent> theError) {
        this.error = theError;
        return this;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (ErrorsComponent item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ErrorsComponent addError() {
        ErrorsComponent t = new ErrorsComponent();
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        this.error.add(t);
        return t;
    }

    public CoverageEligibilityResponse addError(ErrorsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        this.error.add(t);
        return this;
    }

    public ErrorsComponent getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            this.addError();
        }
        return this.getError().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this coverage eligiblity request.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("purpose", "code", "Code to specify whether requesting: prior authorization requirements for some service categories or billing codes; benefits for coverages specified or discovered; discovery and return of coverages for the patient; and/or validation that the specified coverage is in-force at the date/period specified or 'now' if not specified.", 0, Integer.MAX_VALUE, this.purpose));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The party who is the beneficiary of the supplied coverage and for whom eligibility is sought.", 0, 1, this.patient));
        children.add(new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced));
        children.add(new Property(SP_CREATED, "dateTime", "The date this resource was created.", 0, 1, this.created));
        children.add(new Property(SP_REQUESTOR, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the request.", 0, 1, this.requestor));
        children.add(new Property(SP_REQUEST, "Reference(CoverageEligibilityRequest)", "Reference to the original request resource.", 0, 1, this.request));
        children.add(new Property(SP_OUTCOME, "code", "The outcome of the request processing.", 0, 1, this.outcome));
        children.add(new Property(SP_DISPOSITION, "string", "A human readable description of the status of the adjudication.", 0, 1, this.disposition));
        children.add(new Property(SP_INSURER, "Reference(Organization)", "The Insurer who issued the coverage in question and is the author of the response.", 0, 1, this.insurer));
        children.add(new Property("insurance", "", "Financial instruments for reimbursement for the health care products and services.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("preAuthRef", "string", "A reference from the Insurer to which these services pertain to be used on further communication and as proof that the request occurred.", 0, 1, this.preAuthRef));
        children.add(new Property("form", "CodeableConcept", "A code for the form to be used for printing the content.", 0, 1, this.form));
        children.add(new Property("error", "", "Errors encountered during the processing of the request.", 0, Integer.MAX_VALUE, this.error));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this coverage eligiblity request.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case -220463842: {
                return new Property("purpose", "code", "Code to specify whether requesting: prior authorization requirements for some service categories or billing codes; benefits for coverages specified or discovered; discovery and return of coverages for the patient; and/or validation that the specified coverage is in-force at the date/period specified or 'now' if not specified.", 0, Integer.MAX_VALUE, this.purpose);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The party who is the beneficiary of the supplied coverage and for whom eligibility is sought.", 0, 1, this.patient);
            }
            case -1927922223: {
                return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
            }
            case 1379209295: {
                return new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
            }
            case 363246749: {
                return new Property("serviced[x]", "date", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
            }
            case 1534966512: {
                return new Property("serviced[x]", "Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, 1, this.serviced);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date this resource was created.", 0, 1, this.created);
            }
            case 693934258: {
                return new Property(SP_REQUESTOR, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the request.", 0, 1, this.requestor);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(CoverageEligibilityRequest)", "Reference to the original request resource.", 0, 1, this.request);
            }
            case -1106507950: {
                return new Property(SP_OUTCOME, "code", "The outcome of the request processing.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property(SP_DISPOSITION, "string", "A human readable description of the status of the adjudication.", 0, 1, this.disposition);
            }
            case 1957615864: {
                return new Property(SP_INSURER, "Reference(Organization)", "The Insurer who issued the coverage in question and is the author of the response.", 0, 1, this.insurer);
            }
            case 73049818: {
                return new Property("insurance", "", "Financial instruments for reimbursement for the health care products and services.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case 522246568: {
                return new Property("preAuthRef", "string", "A reference from the Insurer to which these services pertain to be used on further communication and as proof that the request occurred.", 0, 1, this.preAuthRef);
            }
            case 3148996: {
                return new Property("form", "CodeableConcept", "A code for the form to be used for printing the content.", 0, 1, this.form);
            }
            case 96784904: {
                return new Property("error", "", "Errors encountered during the processing of the request.", 0, Integer.MAX_VALUE, this.error);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -220463842: {
                return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case 1379209295: {
                Base[] baseArray;
                if (this.serviced == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.serviced;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.created;
                }
                return baseArray;
            }
            case 693934258: {
                Base[] baseArray;
                if (this.requestor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.requestor;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.disposition;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.insurer;
                }
                return baseArray;
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case 522246568: {
                Base[] baseArray;
                if (this.preAuthRef == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.preAuthRef;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.form;
                }
                return baseArray;
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -220463842: {
                value = new EligibilityResponsePurposeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getPurpose().add(value);
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1379209295: {
                this.serviced = TypeConvertor.castToType(value);
                return value;
            }
            case 1028554472: {
                this.created = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 693934258: {
                this.requestor = TypeConvertor.castToReference(value);
                return value;
            }
            case 1095692943: {
                this.request = TypeConvertor.castToReference(value);
                return value;
            }
            case -1106507950: {
                value = new Enumerations.ClaimProcessingCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 583380919: {
                this.disposition = TypeConvertor.castToString(value);
                return value;
            }
            case 1957615864: {
                this.insurer = TypeConvertor.castToReference(value);
                return value;
            }
            case 73049818: {
                this.getInsurance().add((InsuranceComponent)((Object)value));
                return value;
            }
            case 522246568: {
                this.preAuthRef = TypeConvertor.castToString(value);
                return value;
            }
            case 3148996: {
                this.form = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 96784904: {
                this.getError().add((ErrorsComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("purpose")) {
            value = new EligibilityResponsePurposeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.getPurpose().add(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals("serviced[x]")) {
            this.serviced = TypeConvertor.castToType(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_REQUESTOR)) {
            this.requestor = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_REQUEST)) {
            this.request = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_OUTCOME)) {
            value = new Enumerations.ClaimProcessingCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.outcome = value;
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = TypeConvertor.castToString(value);
        } else if (name.equals(SP_INSURER)) {
            this.insurer = TypeConvertor.castToReference(value);
        } else if (name.equals("insurance")) {
            this.getInsurance().add((InsuranceComponent)((Object)value));
        } else if (name.equals("preAuthRef")) {
            this.preAuthRef = TypeConvertor.castToString(value);
        } else if (name.equals("form")) {
            this.form = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("error")) {
            this.getError().add((ErrorsComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -220463842: {
                return this.addPurposeElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1927922223: {
                return this.getServiced();
            }
            case 1379209295: {
                return this.getServiced();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 693934258: {
                return this.getRequestor();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case 522246568: {
                return this.getPreAuthRefElement();
            }
            case 3148996: {
                return this.getForm();
            }
            case 96784904: {
                return this.addError();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -220463842: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1379209295: {
                return new String[]{"date", "Period"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 693934258: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case 73049818: {
                return new String[0];
            }
            case 522246568: {
                return new String[]{"string"};
            }
            case 3148996: {
                return new String[]{"CodeableConcept"};
            }
            case 96784904: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.status");
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.purpose");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("servicedDate")) {
            this.serviced = new DateType();
            return this.serviced;
        }
        if (name.equals("servicedPeriod")) {
            this.serviced = new Period();
            return this.serviced;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.created");
        }
        if (name.equals(SP_REQUESTOR)) {
            this.requestor = new Reference();
            return this.requestor;
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_OUTCOME)) {
            throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.outcome");
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.disposition");
        }
        if (name.equals(SP_INSURER)) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("preAuthRef")) {
            throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.preAuthRef");
        }
        if (name.equals("form")) {
            this.form = new CodeableConcept();
            return this.form;
        }
        if (name.equals("error")) {
            return this.addError();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CoverageEligibilityResponse";
    }

    @Override
    public CoverageEligibilityResponse copy() {
        CoverageEligibilityResponse dst = new CoverageEligibilityResponse();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CoverageEligibilityResponse dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<Enumerations.FinancialResourceStatusCodes> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.purpose != null) {
            dst.purpose = new ArrayList<Enumeration<EligibilityResponsePurpose>>();
            for (Enumeration enumeration2 : this.purpose) {
                dst.purpose.add((Enumeration<EligibilityResponsePurpose>)enumeration2.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.serviced = this.serviced == null ? null : this.serviced.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.requestor = this.requestor == null ? null : this.requestor.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        Reference reference = dst.insurer = this.insurer == null ? null : this.insurer.copy();
        if (this.insurance != null) {
            dst.insurance = new ArrayList<InsuranceComponent>();
            for (InsuranceComponent insuranceComponent : this.insurance) {
                dst.insurance.add(insuranceComponent.copy());
            }
        }
        dst.preAuthRef = this.preAuthRef == null ? null : this.preAuthRef.copy();
        CodeableConcept codeableConcept = dst.form = this.form == null ? null : this.form.copy();
        if (this.error != null) {
            dst.error = new ArrayList<ErrorsComponent>();
            for (ErrorsComponent errorsComponent : this.error) {
                dst.error.add(errorsComponent.copy());
            }
        }
    }

    protected CoverageEligibilityResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CoverageEligibilityResponse)) {
            return false;
        }
        CoverageEligibilityResponse o = (CoverageEligibilityResponse)other_;
        return CoverageEligibilityResponse.compareDeep(this.identifier, o.identifier, true) && CoverageEligibilityResponse.compareDeep(this.status, o.status, true) && CoverageEligibilityResponse.compareDeep(this.purpose, o.purpose, true) && CoverageEligibilityResponse.compareDeep(this.patient, o.patient, true) && CoverageEligibilityResponse.compareDeep(this.serviced, o.serviced, true) && CoverageEligibilityResponse.compareDeep(this.created, o.created, true) && CoverageEligibilityResponse.compareDeep(this.requestor, o.requestor, true) && CoverageEligibilityResponse.compareDeep(this.request, o.request, true) && CoverageEligibilityResponse.compareDeep(this.outcome, o.outcome, true) && CoverageEligibilityResponse.compareDeep(this.disposition, o.disposition, true) && CoverageEligibilityResponse.compareDeep(this.insurer, o.insurer, true) && CoverageEligibilityResponse.compareDeep(this.insurance, o.insurance, true) && CoverageEligibilityResponse.compareDeep(this.preAuthRef, o.preAuthRef, true) && CoverageEligibilityResponse.compareDeep(this.form, o.form, true) && CoverageEligibilityResponse.compareDeep(this.error, o.error, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CoverageEligibilityResponse)) {
            return false;
        }
        CoverageEligibilityResponse o = (CoverageEligibilityResponse)other_;
        return CoverageEligibilityResponse.compareValues(this.status, o.status, true) && CoverageEligibilityResponse.compareValues(this.purpose, o.purpose, true) && CoverageEligibilityResponse.compareValues(this.created, o.created, true) && CoverageEligibilityResponse.compareValues(this.outcome, o.outcome, true) && CoverageEligibilityResponse.compareValues(this.disposition, o.disposition, true) && CoverageEligibilityResponse.compareValues(this.preAuthRef, o.preAuthRef, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.purpose, this.patient, this.serviced, this.created, this.requestor, this.request, this.outcome, this.disposition, this.insurer, this.insurance, this.preAuthRef, this.form, this.error);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CoverageEligibilityResponse;
    }

    @Block
    public static class ErrorsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Error code detailing processing issues", formalDefinition="An error code,from a specified code system, which details why the eligibility check could not be performed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-error")
        protected CodeableConcept code;
        private static final long serialVersionUID = -1048343046L;

        public ErrorsComponent() {
        }

        public ErrorsComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ErrorsComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "An error code,from a specified code system, which details why the eligibility check could not be performed.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "An error code,from a specified code system, which details why the eligibility check could not be performed.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("code")) {
                return super.setProperty(name, value);
            }
            this.code = TypeConvertor.castToCodeableConcept(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ErrorsComponent copy() {
            ErrorsComponent dst = new ErrorsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ErrorsComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ErrorsComponent)) {
                return false;
            }
            ErrorsComponent o = (ErrorsComponent)other_;
            return ErrorsComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ErrorsComponent)) {
                return false;
            }
            ErrorsComponent o = (ErrorsComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code);
        }

        @Override
        public String fhirType() {
            return "CoverageEligibilityResponse.error";
        }
    }

    @Block
    public static class BenefitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit classification", formalDefinition="Classification of benefit being provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-type")
        protected CodeableConcept type;
        @Child(name="allowed", type={UnsignedIntType.class, StringType.class, Money.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits allowed", formalDefinition="The quantity of the benefit which is permitted under the coverage.")
        protected DataType allowed;
        @Child(name="used", type={UnsignedIntType.class, StringType.class, Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits used", formalDefinition="The quantity of the benefit which have been consumed to date.")
        protected DataType used;
        private static final long serialVersionUID = 1900247614L;

        public BenefitComponent() {
        }

        public BenefitComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public BenefitComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getAllowed() {
            return this.allowed;
        }

        public UnsignedIntType getAllowedUnsignedIntType() throws FHIRException {
            if (this.allowed == null) {
                this.allowed = new UnsignedIntType();
            }
            if (!(this.allowed instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.allowed;
        }

        public boolean hasAllowedUnsignedIntType() {
            return this != null && this.allowed instanceof UnsignedIntType;
        }

        public StringType getAllowedStringType() throws FHIRException {
            if (this.allowed == null) {
                this.allowed = new StringType();
            }
            if (!(this.allowed instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (StringType)this.allowed;
        }

        public boolean hasAllowedStringType() {
            return this != null && this.allowed instanceof StringType;
        }

        public Money getAllowedMoney() throws FHIRException {
            if (this.allowed == null) {
                this.allowed = new Money();
            }
            if (!(this.allowed instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (Money)this.allowed;
        }

        public boolean hasAllowedMoney() {
            return this != null && this.allowed instanceof Money;
        }

        public boolean hasAllowed() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public BenefitComponent setAllowed(DataType value) {
            if (!(value == null || value instanceof UnsignedIntType || value instanceof StringType || value instanceof Money)) {
                throw new Error("Not the right type for CoverageEligibilityResponse.insurance.item.benefit.allowed[x]: " + value.fhirType());
            }
            this.allowed = value;
            return this;
        }

        public DataType getUsed() {
            return this.used;
        }

        public UnsignedIntType getUsedUnsignedIntType() throws FHIRException {
            if (this.used == null) {
                this.used = new UnsignedIntType();
            }
            if (!(this.used instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.used.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.used;
        }

        public boolean hasUsedUnsignedIntType() {
            return this != null && this.used instanceof UnsignedIntType;
        }

        public StringType getUsedStringType() throws FHIRException {
            if (this.used == null) {
                this.used = new StringType();
            }
            if (!(this.used instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.used.getClass().getName() + " was encountered");
            }
            return (StringType)this.used;
        }

        public boolean hasUsedStringType() {
            return this != null && this.used instanceof StringType;
        }

        public Money getUsedMoney() throws FHIRException {
            if (this.used == null) {
                this.used = new Money();
            }
            if (!(this.used instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.used.getClass().getName() + " was encountered");
            }
            return (Money)this.used;
        }

        public boolean hasUsedMoney() {
            return this != null && this.used instanceof Money;
        }

        public boolean hasUsed() {
            return this.used != null && !this.used.isEmpty();
        }

        public BenefitComponent setUsed(DataType value) {
            if (!(value == null || value instanceof UnsignedIntType || value instanceof StringType || value instanceof Money)) {
                throw new Error("Not the right type for CoverageEligibilityResponse.insurance.item.benefit.used[x]: " + value.fhirType());
            }
            this.used = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Classification of benefit being provided.", 0, 1, this.type));
            children.add(new Property("allowed[x]", "unsignedInt|string|Money", "The quantity of the benefit which is permitted under the coverage.", 0, 1, this.allowed));
            children.add(new Property("used[x]", "unsignedInt|string|Money", "The quantity of the benefit which have been consumed to date.", 0, 1, this.used));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Classification of benefit being provided.", 0, 1, this.type);
                }
                case -1336663592: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "The quantity of the benefit which is permitted under the coverage.", 0, 1, this.allowed);
                }
                case -911343192: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "The quantity of the benefit which is permitted under the coverage.", 0, 1, this.allowed);
                }
                case 1668802034: {
                    return new Property("allowed[x]", "unsignedInt", "The quantity of the benefit which is permitted under the coverage.", 0, 1, this.allowed);
                }
                case -2135265319: {
                    return new Property("allowed[x]", "string", "The quantity of the benefit which is permitted under the coverage.", 0, 1, this.allowed);
                }
                case -351668232: {
                    return new Property("allowed[x]", "Money", "The quantity of the benefit which is permitted under the coverage.", 0, 1, this.allowed);
                }
                case -147553373: {
                    return new Property("used[x]", "unsignedInt|string|Money", "The quantity of the benefit which have been consumed to date.", 0, 1, this.used);
                }
                case 3599293: {
                    return new Property("used[x]", "unsignedInt|string|Money", "The quantity of the benefit which have been consumed to date.", 0, 1, this.used);
                }
                case 1252740285: {
                    return new Property("used[x]", "unsignedInt", "The quantity of the benefit which have been consumed to date.", 0, 1, this.used);
                }
                case 2051978798: {
                    return new Property("used[x]", "string", "The quantity of the benefit which have been consumed to date.", 0, 1, this.used);
                }
                case -78048509: {
                    return new Property("used[x]", "Money", "The quantity of the benefit which have been consumed to date.", 0, 1, this.used);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -911343192: {
                    Base[] baseArray;
                    if (this.allowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.allowed;
                    }
                    return baseArray;
                }
                case 3599293: {
                    Base[] baseArray;
                    if (this.used == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.used;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -911343192: {
                    this.allowed = TypeConvertor.castToType(value);
                    return value;
                }
                case 3599293: {
                    this.used = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("allowed[x]")) {
                this.allowed = TypeConvertor.castToType(value);
            } else if (name.equals("used[x]")) {
                this.used = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1336663592: {
                    return this.getAllowed();
                }
                case -911343192: {
                    return this.getAllowed();
                }
                case -147553373: {
                    return this.getUsed();
                }
                case 3599293: {
                    return this.getUsed();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -911343192: {
                    return new String[]{"unsignedInt", "string", "Money"};
                }
                case 3599293: {
                    return new String[]{"unsignedInt", "string", "Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("allowedUnsignedInt")) {
                this.allowed = new UnsignedIntType();
                return this.allowed;
            }
            if (name.equals("allowedString")) {
                this.allowed = new StringType();
                return this.allowed;
            }
            if (name.equals("allowedMoney")) {
                this.allowed = new Money();
                return this.allowed;
            }
            if (name.equals("usedUnsignedInt")) {
                this.used = new UnsignedIntType();
                return this.used;
            }
            if (name.equals("usedString")) {
                this.used = new StringType();
                return this.used;
            }
            if (name.equals("usedMoney")) {
                this.used = new Money();
                return this.used;
            }
            return super.addChild(name);
        }

        @Override
        public BenefitComponent copy() {
            BenefitComponent dst = new BenefitComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BenefitComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.allowed = this.allowed == null ? null : this.allowed.copy();
            dst.used = this.used == null ? null : this.used.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other_;
            return BenefitComponent.compareDeep(this.type, o.type, true) && BenefitComponent.compareDeep(this.allowed, o.allowed, true) && BenefitComponent.compareDeep(this.used, o.used, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.allowed, this.used);
        }

        @Override
        public String fhirType() {
            return "CoverageEligibilityResponse.insurance.item.benefit";
        }
    }

    @Block
    public static class ItemsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit classification", formalDefinition="Code to identify the general type of benefits under which products and services are provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="productOrService", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing, service, product, or drug code", formalDefinition="This contains the product, service, drug or other billing code for the item.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrService;
        @Child(name="modifier", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Product or service billing modifiers", formalDefinition="Item typification or modifiers codes to convey additional context for the product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="provider", type={Practitioner.class, PractitionerRole.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Performing practitioner", formalDefinition="The practitioner who is eligible for the provision of the product or service.")
        protected Reference provider;
        @Child(name="excluded", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Excluded from the plan", formalDefinition="True if the indicated class of service is excluded from the plan, missing or False indicates the product or service is included in the coverage.")
        protected BooleanType excluded;
        @Child(name="name", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short name for the benefit", formalDefinition="A short name or tag for the benefit.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the benefit or services covered", formalDefinition="A richer description of the benefit or services covered.")
        protected StringType description;
        @Child(name="network", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="In or out of network", formalDefinition="Is a flag to indicate whether the benefits refer to in-network providers or out-of-network providers.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-network")
        protected CodeableConcept network;
        @Child(name="unit", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual or family", formalDefinition="Indicates if the benefits apply to an individual or to the family.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-unit")
        protected CodeableConcept unit;
        @Child(name="term", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Annual or lifetime", formalDefinition="The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual visits'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-term")
        protected CodeableConcept term;
        @Child(name="benefit", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit Summary", formalDefinition="Benefits used to date.")
        protected List<BenefitComponent> benefit;
        @Child(name="authorizationRequired", type={BooleanType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Authorization required flag", formalDefinition="A boolean flag indicating whether a preauthorization is required prior to actual service delivery.")
        protected BooleanType authorizationRequired;
        @Child(name="authorizationSupporting", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Type of required supporting materials", formalDefinition="Codes or comments regarding information or actions associated with the preauthorization.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/coverageeligibilityresponse-ex-auth-support")
        protected List<CodeableConcept> authorizationSupporting;
        @Child(name="authorizationUrl", type={UriType.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Preauthorization requirements endpoint", formalDefinition="A web location for obtaining requirements or descriptive information regarding the preauthorization.")
        protected UriType authorizationUrl;
        private static final long serialVersionUID = 1706159945L;

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ItemsComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getProductOrService() {
            if (this.productOrService == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.productOrService");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrService = new CodeableConcept();
                }
            }
            return this.productOrService;
        }

        public boolean hasProductOrService() {
            return this.productOrService != null && !this.productOrService.isEmpty();
        }

        public ItemsComponent setProductOrService(CodeableConcept value) {
            this.productOrService = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public ItemsComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public ItemsComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public Reference getProvider() {
            if (this.provider == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.provider");
                }
                if (Configuration.doAutoCreate()) {
                    this.provider = new Reference();
                }
            }
            return this.provider;
        }

        public boolean hasProvider() {
            return this.provider != null && !this.provider.isEmpty();
        }

        public ItemsComponent setProvider(Reference value) {
            this.provider = value;
            return this;
        }

        public BooleanType getExcludedElement() {
            if (this.excluded == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.excluded");
                }
                if (Configuration.doAutoCreate()) {
                    this.excluded = new BooleanType();
                }
            }
            return this.excluded;
        }

        public boolean hasExcludedElement() {
            return this.excluded != null && !this.excluded.isEmpty();
        }

        public boolean hasExcluded() {
            return this.excluded != null && !this.excluded.isEmpty();
        }

        public ItemsComponent setExcludedElement(BooleanType value) {
            this.excluded = value;
            return this;
        }

        public boolean getExcluded() {
            return this.excluded == null || this.excluded.isEmpty() ? false : (Boolean)this.excluded.getValue();
        }

        public ItemsComponent setExcluded(boolean value) {
            if (this.excluded == null) {
                this.excluded = new BooleanType();
            }
            this.excluded.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ItemsComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ItemsComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ItemsComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ItemsComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getNetwork() {
            if (this.network == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.network");
                }
                if (Configuration.doAutoCreate()) {
                    this.network = new CodeableConcept();
                }
            }
            return this.network;
        }

        public boolean hasNetwork() {
            return this.network != null && !this.network.isEmpty();
        }

        public ItemsComponent setNetwork(CodeableConcept value) {
            this.network = value;
            return this;
        }

        public CodeableConcept getUnit() {
            if (this.unit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.unit");
                }
                if (Configuration.doAutoCreate()) {
                    this.unit = new CodeableConcept();
                }
            }
            return this.unit;
        }

        public boolean hasUnit() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public ItemsComponent setUnit(CodeableConcept value) {
            this.unit = value;
            return this;
        }

        public CodeableConcept getTerm() {
            if (this.term == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.term");
                }
                if (Configuration.doAutoCreate()) {
                    this.term = new CodeableConcept();
                }
            }
            return this.term;
        }

        public boolean hasTerm() {
            return this.term != null && !this.term.isEmpty();
        }

        public ItemsComponent setTerm(CodeableConcept value) {
            this.term = value;
            return this;
        }

        public List<BenefitComponent> getBenefit() {
            if (this.benefit == null) {
                this.benefit = new ArrayList<BenefitComponent>();
            }
            return this.benefit;
        }

        public ItemsComponent setBenefit(List<BenefitComponent> theBenefit) {
            this.benefit = theBenefit;
            return this;
        }

        public boolean hasBenefit() {
            if (this.benefit == null) {
                return false;
            }
            for (BenefitComponent item : this.benefit) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BenefitComponent addBenefit() {
            BenefitComponent t = new BenefitComponent();
            if (this.benefit == null) {
                this.benefit = new ArrayList<BenefitComponent>();
            }
            this.benefit.add(t);
            return t;
        }

        public ItemsComponent addBenefit(BenefitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.benefit == null) {
                this.benefit = new ArrayList<BenefitComponent>();
            }
            this.benefit.add(t);
            return this;
        }

        public BenefitComponent getBenefitFirstRep() {
            if (this.getBenefit().isEmpty()) {
                this.addBenefit();
            }
            return this.getBenefit().get(0);
        }

        public BooleanType getAuthorizationRequiredElement() {
            if (this.authorizationRequired == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.authorizationRequired");
                }
                if (Configuration.doAutoCreate()) {
                    this.authorizationRequired = new BooleanType();
                }
            }
            return this.authorizationRequired;
        }

        public boolean hasAuthorizationRequiredElement() {
            return this.authorizationRequired != null && !this.authorizationRequired.isEmpty();
        }

        public boolean hasAuthorizationRequired() {
            return this.authorizationRequired != null && !this.authorizationRequired.isEmpty();
        }

        public ItemsComponent setAuthorizationRequiredElement(BooleanType value) {
            this.authorizationRequired = value;
            return this;
        }

        public boolean getAuthorizationRequired() {
            return this.authorizationRequired == null || this.authorizationRequired.isEmpty() ? false : (Boolean)this.authorizationRequired.getValue();
        }

        public ItemsComponent setAuthorizationRequired(boolean value) {
            if (this.authorizationRequired == null) {
                this.authorizationRequired = new BooleanType();
            }
            this.authorizationRequired.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getAuthorizationSupporting() {
            if (this.authorizationSupporting == null) {
                this.authorizationSupporting = new ArrayList<CodeableConcept>();
            }
            return this.authorizationSupporting;
        }

        public ItemsComponent setAuthorizationSupporting(List<CodeableConcept> theAuthorizationSupporting) {
            this.authorizationSupporting = theAuthorizationSupporting;
            return this;
        }

        public boolean hasAuthorizationSupporting() {
            if (this.authorizationSupporting == null) {
                return false;
            }
            for (CodeableConcept item : this.authorizationSupporting) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAuthorizationSupporting() {
            CodeableConcept t = new CodeableConcept();
            if (this.authorizationSupporting == null) {
                this.authorizationSupporting = new ArrayList<CodeableConcept>();
            }
            this.authorizationSupporting.add(t);
            return t;
        }

        public ItemsComponent addAuthorizationSupporting(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.authorizationSupporting == null) {
                this.authorizationSupporting = new ArrayList<CodeableConcept>();
            }
            this.authorizationSupporting.add(t);
            return this;
        }

        public CodeableConcept getAuthorizationSupportingFirstRep() {
            if (this.getAuthorizationSupporting().isEmpty()) {
                this.addAuthorizationSupporting();
            }
            return this.getAuthorizationSupporting().get(0);
        }

        public UriType getAuthorizationUrlElement() {
            if (this.authorizationUrl == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.authorizationUrl");
                }
                if (Configuration.doAutoCreate()) {
                    this.authorizationUrl = new UriType();
                }
            }
            return this.authorizationUrl;
        }

        public boolean hasAuthorizationUrlElement() {
            return this.authorizationUrl != null && !this.authorizationUrl.isEmpty();
        }

        public boolean hasAuthorizationUrl() {
            return this.authorizationUrl != null && !this.authorizationUrl.isEmpty();
        }

        public ItemsComponent setAuthorizationUrlElement(UriType value) {
            this.authorizationUrl = value;
            return this;
        }

        public String getAuthorizationUrl() {
            return this.authorizationUrl == null ? null : (String)this.authorizationUrl.getValue();
        }

        public ItemsComponent setAuthorizationUrl(String value) {
            if (Utilities.noString(value)) {
                this.authorizationUrl = null;
            } else {
                if (this.authorizationUrl == null) {
                    this.authorizationUrl = new UriType();
                }
                this.authorizationUrl.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category));
            children.add(new Property("productOrService", "CodeableConcept", "This contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("provider", "Reference(Practitioner|PractitionerRole)", "The practitioner who is eligible for the provision of the product or service.", 0, 1, this.provider));
            children.add(new Property("excluded", "boolean", "True if the indicated class of service is excluded from the plan, missing or False indicates the product or service is included in the coverage.", 0, 1, this.excluded));
            children.add(new Property("name", "string", "A short name or tag for the benefit.", 0, 1, this.name));
            children.add(new Property("description", "string", "A richer description of the benefit or services covered.", 0, 1, this.description));
            children.add(new Property("network", "CodeableConcept", "Is a flag to indicate whether the benefits refer to in-network providers or out-of-network providers.", 0, 1, this.network));
            children.add(new Property("unit", "CodeableConcept", "Indicates if the benefits apply to an individual or to the family.", 0, 1, this.unit));
            children.add(new Property("term", "CodeableConcept", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual visits'.", 0, 1, this.term));
            children.add(new Property("benefit", "", "Benefits used to date.", 0, Integer.MAX_VALUE, this.benefit));
            children.add(new Property("authorizationRequired", "boolean", "A boolean flag indicating whether a preauthorization is required prior to actual service delivery.", 0, 1, this.authorizationRequired));
            children.add(new Property("authorizationSupporting", "CodeableConcept", "Codes or comments regarding information or actions associated with the preauthorization.", 0, Integer.MAX_VALUE, this.authorizationSupporting));
            children.add(new Property("authorizationUrl", "uri", "A web location for obtaining requirements or descriptive information regarding the preauthorization.", 0, 1, this.authorizationUrl));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category);
                }
                case 1957227299: {
                    return new Property("productOrService", "CodeableConcept", "This contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case -987494927: {
                    return new Property("provider", "Reference(Practitioner|PractitionerRole)", "The practitioner who is eligible for the provision of the product or service.", 0, 1, this.provider);
                }
                case 1994055114: {
                    return new Property("excluded", "boolean", "True if the indicated class of service is excluded from the plan, missing or False indicates the product or service is included in the coverage.", 0, 1, this.excluded);
                }
                case 3373707: {
                    return new Property("name", "string", "A short name or tag for the benefit.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "string", "A richer description of the benefit or services covered.", 0, 1, this.description);
                }
                case 1843485230: {
                    return new Property("network", "CodeableConcept", "Is a flag to indicate whether the benefits refer to in-network providers or out-of-network providers.", 0, 1, this.network);
                }
                case 3594628: {
                    return new Property("unit", "CodeableConcept", "Indicates if the benefits apply to an individual or to the family.", 0, 1, this.unit);
                }
                case 3556460: {
                    return new Property("term", "CodeableConcept", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual visits'.", 0, 1, this.term);
                }
                case -222710633: {
                    return new Property("benefit", "", "Benefits used to date.", 0, Integer.MAX_VALUE, this.benefit);
                }
                case 374204216: {
                    return new Property("authorizationRequired", "boolean", "A boolean flag indicating whether a preauthorization is required prior to actual service delivery.", 0, 1, this.authorizationRequired);
                }
                case -1931146484: {
                    return new Property("authorizationSupporting", "CodeableConcept", "Codes or comments regarding information or actions associated with the preauthorization.", 0, Integer.MAX_VALUE, this.authorizationSupporting);
                }
                case 1409445430: {
                    return new Property("authorizationUrl", "uri", "A web location for obtaining requirements or descriptive information regarding the preauthorization.", 0, 1, this.authorizationUrl);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 1957227299: {
                    Base[] baseArray;
                    if (this.productOrService == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.productOrService;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case -987494927: {
                    Base[] baseArray;
                    if (this.provider == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.provider;
                    }
                    return baseArray;
                }
                case 1994055114: {
                    Base[] baseArray;
                    if (this.excluded == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.excluded;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.description;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    Base[] baseArray;
                    if (this.network == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.network;
                    }
                    return baseArray;
                }
                case 3594628: {
                    Base[] baseArray;
                    if (this.unit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.unit;
                    }
                    return baseArray;
                }
                case 3556460: {
                    Base[] baseArray;
                    if (this.term == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.term;
                    }
                    return baseArray;
                }
                case -222710633: {
                    return this.benefit == null ? new Base[]{} : this.benefit.toArray(new Base[this.benefit.size()]);
                }
                case 374204216: {
                    Base[] baseArray;
                    if (this.authorizationRequired == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.authorizationRequired;
                    }
                    return baseArray;
                }
                case -1931146484: {
                    return this.authorizationSupporting == null ? new Base[]{} : this.authorizationSupporting.toArray(new Base[this.authorizationSupporting.size()]);
                }
                case 1409445430: {
                    Base[] baseArray;
                    if (this.authorizationUrl == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.authorizationUrl;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1957227299: {
                    this.productOrService = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -987494927: {
                    this.provider = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1994055114: {
                    this.excluded = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 1843485230: {
                    this.network = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3594628: {
                    this.unit = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3556460: {
                    this.term = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -222710633: {
                    this.getBenefit().add((BenefitComponent)value);
                    return value;
                }
                case 374204216: {
                    this.authorizationRequired = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1931146484: {
                    this.getAuthorizationSupporting().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1409445430: {
                    this.authorizationUrl = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("productOrService")) {
                this.productOrService = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("provider")) {
                this.provider = TypeConvertor.castToReference(value);
            } else if (name.equals("excluded")) {
                this.excluded = TypeConvertor.castToBoolean(value);
            } else if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("network")) {
                this.network = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("unit")) {
                this.unit = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("term")) {
                this.term = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("benefit")) {
                this.getBenefit().add((BenefitComponent)value);
            } else if (name.equals("authorizationRequired")) {
                this.authorizationRequired = TypeConvertor.castToBoolean(value);
            } else if (name.equals("authorizationSupporting")) {
                this.getAuthorizationSupporting().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("authorizationUrl")) {
                this.authorizationUrl = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 1957227299: {
                    return this.getProductOrService();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case -987494927: {
                    return this.getProvider();
                }
                case 1994055114: {
                    return this.getExcludedElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 1843485230: {
                    return this.getNetwork();
                }
                case 3594628: {
                    return this.getUnit();
                }
                case 3556460: {
                    return this.getTerm();
                }
                case -222710633: {
                    return this.addBenefit();
                }
                case 374204216: {
                    return this.getAuthorizationRequiredElement();
                }
                case -1931146484: {
                    return this.addAuthorizationSupporting();
                }
                case 1409445430: {
                    return this.getAuthorizationUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1957227299: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case -987494927: {
                    return new String[]{"Reference"};
                }
                case 1994055114: {
                    return new String[]{"boolean"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 1843485230: {
                    return new String[]{"CodeableConcept"};
                }
                case 3594628: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556460: {
                    return new String[]{"CodeableConcept"};
                }
                case -222710633: {
                    return new String[0];
                }
                case 374204216: {
                    return new String[]{"boolean"};
                }
                case -1931146484: {
                    return new String[]{"CodeableConcept"};
                }
                case 1409445430: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("productOrService")) {
                this.productOrService = new CodeableConcept();
                return this.productOrService;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("provider")) {
                this.provider = new Reference();
                return this.provider;
            }
            if (name.equals("excluded")) {
                throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.insurance.item.excluded");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.insurance.item.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.insurance.item.description");
            }
            if (name.equals("network")) {
                this.network = new CodeableConcept();
                return this.network;
            }
            if (name.equals("unit")) {
                this.unit = new CodeableConcept();
                return this.unit;
            }
            if (name.equals("term")) {
                this.term = new CodeableConcept();
                return this.term;
            }
            if (name.equals("benefit")) {
                return this.addBenefit();
            }
            if (name.equals("authorizationRequired")) {
                throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.insurance.item.authorizationRequired");
            }
            if (name.equals("authorizationSupporting")) {
                return this.addAuthorizationSupporting();
            }
            if (name.equals("authorizationUrl")) {
                throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.insurance.item.authorizationUrl");
            }
            return super.addChild(name);
        }

        @Override
        public ItemsComponent copy() {
            ItemsComponent dst = new ItemsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ItemsComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.productOrService = this.productOrService == null ? null : this.productOrService.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            dst.provider = this.provider == null ? null : this.provider.copy();
            dst.excluded = this.excluded == null ? null : this.excluded.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.network = this.network == null ? null : this.network.copy();
            dst.unit = this.unit == null ? null : this.unit.copy();
            CodeableConcept codeableConcept3 = dst.term = this.term == null ? null : this.term.copy();
            if (this.benefit != null) {
                dst.benefit = new ArrayList<BenefitComponent>();
                for (BenefitComponent benefitComponent : this.benefit) {
                    dst.benefit.add(benefitComponent.copy());
                }
            }
            BooleanType booleanType = dst.authorizationRequired = this.authorizationRequired == null ? null : this.authorizationRequired.copy();
            if (this.authorizationSupporting != null) {
                dst.authorizationSupporting = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept4 : this.authorizationSupporting) {
                    dst.authorizationSupporting.add(codeableConcept4.copy());
                }
            }
            dst.authorizationUrl = this.authorizationUrl == null ? null : this.authorizationUrl.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other_;
            return ItemsComponent.compareDeep(this.category, o.category, true) && ItemsComponent.compareDeep(this.productOrService, o.productOrService, true) && ItemsComponent.compareDeep(this.modifier, o.modifier, true) && ItemsComponent.compareDeep(this.provider, o.provider, true) && ItemsComponent.compareDeep(this.excluded, o.excluded, true) && ItemsComponent.compareDeep(this.name, o.name, true) && ItemsComponent.compareDeep(this.description, o.description, true) && ItemsComponent.compareDeep(this.network, o.network, true) && ItemsComponent.compareDeep(this.unit, o.unit, true) && ItemsComponent.compareDeep(this.term, o.term, true) && ItemsComponent.compareDeep(this.benefit, o.benefit, true) && ItemsComponent.compareDeep(this.authorizationRequired, o.authorizationRequired, true) && ItemsComponent.compareDeep(this.authorizationSupporting, o.authorizationSupporting, true) && ItemsComponent.compareDeep(this.authorizationUrl, o.authorizationUrl, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other_;
            return ItemsComponent.compareValues(this.excluded, o.excluded, true) && ItemsComponent.compareValues(this.name, o.name, true) && ItemsComponent.compareValues(this.description, o.description, true) && ItemsComponent.compareValues(this.authorizationRequired, o.authorizationRequired, true) && ItemsComponent.compareValues(this.authorizationUrl, o.authorizationUrl, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.category, this.productOrService, this.modifier, this.provider, this.excluded, this.name, this.description, this.network, this.unit, this.term, this.benefit, this.authorizationRequired, this.authorizationSupporting, this.authorizationUrl);
        }

        @Override
        public String fhirType() {
            return "CoverageEligibilityResponse.insurance.item";
        }
    }

    @Block
    public static class InsuranceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="coverage", type={Coverage.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.")
        protected Reference coverage;
        @Child(name="inforce", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Coverage inforce indicator", formalDefinition="Flag indicating if the coverage provided is inforce currently if no service date(s) specified or for the whole duration of the service dates.")
        protected BooleanType inforce;
        @Child(name="benefitPeriod", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the benefits are applicable", formalDefinition="The term of the benefits documented in this response.")
        protected Period benefitPeriod;
        @Child(name="item", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits and authorization details", formalDefinition="Benefits and optionally current balances, and authorization details by category or service.")
        protected List<ItemsComponent> item;
        private static final long serialVersionUID = 1473928476L;

        public InsuranceComponent() {
        }

        public InsuranceComponent(Reference coverage) {
            this.setCoverage(coverage);
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public InsuranceComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public BooleanType getInforceElement() {
            if (this.inforce == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.inforce");
                }
                if (Configuration.doAutoCreate()) {
                    this.inforce = new BooleanType();
                }
            }
            return this.inforce;
        }

        public boolean hasInforceElement() {
            return this.inforce != null && !this.inforce.isEmpty();
        }

        public boolean hasInforce() {
            return this.inforce != null && !this.inforce.isEmpty();
        }

        public InsuranceComponent setInforceElement(BooleanType value) {
            this.inforce = value;
            return this;
        }

        public boolean getInforce() {
            return this.inforce == null || this.inforce.isEmpty() ? false : (Boolean)this.inforce.getValue();
        }

        public InsuranceComponent setInforce(boolean value) {
            if (this.inforce == null) {
                this.inforce = new BooleanType();
            }
            this.inforce.setValue((Object)value);
            return this;
        }

        public Period getBenefitPeriod() {
            if (this.benefitPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.benefitPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.benefitPeriod = new Period();
                }
            }
            return this.benefitPeriod;
        }

        public boolean hasBenefitPeriod() {
            return this.benefitPeriod != null && !this.benefitPeriod.isEmpty();
        }

        public InsuranceComponent setBenefitPeriod(Period value) {
            this.benefitPeriod = value;
            return this;
        }

        public List<ItemsComponent> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<ItemsComponent>();
            }
            return this.item;
        }

        public InsuranceComponent setItem(List<ItemsComponent> theItem) {
            this.item = theItem;
            return this;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (ItemsComponent item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ItemsComponent addItem() {
            ItemsComponent t = new ItemsComponent();
            if (this.item == null) {
                this.item = new ArrayList<ItemsComponent>();
            }
            this.item.add(t);
            return t;
        }

        public InsuranceComponent addItem(ItemsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<ItemsComponent>();
            }
            this.item.add(t);
            return this;
        }

        public ItemsComponent getItemFirstRep() {
            if (this.getItem().isEmpty()) {
                this.addItem();
            }
            return this.getItem().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("coverage", "Reference(Coverage)", "Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.", 0, 1, this.coverage));
            children.add(new Property("inforce", "boolean", "Flag indicating if the coverage provided is inforce currently if no service date(s) specified or for the whole duration of the service dates.", 0, 1, this.inforce));
            children.add(new Property("benefitPeriod", "Period", "The term of the benefits documented in this response.", 0, 1, this.benefitPeriod));
            children.add(new Property("item", "", "Benefits and optionally current balances, and authorization details by category or service.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.", 0, 1, this.coverage);
                }
                case 1945431270: {
                    return new Property("inforce", "boolean", "Flag indicating if the coverage provided is inforce currently if no service date(s) specified or for the whole duration of the service dates.", 0, 1, this.inforce);
                }
                case -407369416: {
                    return new Property("benefitPeriod", "Period", "The term of the benefits documented in this response.", 0, 1, this.benefitPeriod);
                }
                case 3242771: {
                    return new Property("item", "", "Benefits and optionally current balances, and authorization details by category or service.", 0, Integer.MAX_VALUE, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.coverage;
                    }
                    return baseArray;
                }
                case 1945431270: {
                    Base[] baseArray;
                    if (this.inforce == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.inforce;
                    }
                    return baseArray;
                }
                case -407369416: {
                    Base[] baseArray;
                    if (this.benefitPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.benefitPeriod;
                    }
                    return baseArray;
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    this.coverage = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1945431270: {
                    this.inforce = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -407369416: {
                    this.benefitPeriod = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 3242771: {
                    this.getItem().add((ItemsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("coverage")) {
                this.coverage = TypeConvertor.castToReference(value);
            } else if (name.equals("inforce")) {
                this.inforce = TypeConvertor.castToBoolean(value);
            } else if (name.equals("benefitPeriod")) {
                this.benefitPeriod = TypeConvertor.castToPeriod(value);
            } else if (name.equals("item")) {
                this.getItem().add((ItemsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    return this.getCoverage();
                }
                case 1945431270: {
                    return this.getInforceElement();
                }
                case -407369416: {
                    return this.getBenefitPeriod();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case 1945431270: {
                    return new String[]{"boolean"};
                }
                case -407369416: {
                    return new String[]{"Period"};
                }
                case 3242771: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("inforce")) {
                throw new FHIRException("Cannot call addChild on a primitive type CoverageEligibilityResponse.insurance.inforce");
            }
            if (name.equals("benefitPeriod")) {
                this.benefitPeriod = new Period();
                return this.benefitPeriod;
            }
            if (name.equals("item")) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public InsuranceComponent copy() {
            InsuranceComponent dst = new InsuranceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InsuranceComponent dst) {
            super.copyValues(dst);
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            dst.inforce = this.inforce == null ? null : this.inforce.copy();
            Period period = dst.benefitPeriod = this.benefitPeriod == null ? null : this.benefitPeriod.copy();
            if (this.item != null) {
                dst.item = new ArrayList<ItemsComponent>();
                for (ItemsComponent i : this.item) {
                    dst.item.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareDeep(this.coverage, o.coverage, true) && InsuranceComponent.compareDeep(this.inforce, o.inforce, true) && InsuranceComponent.compareDeep(this.benefitPeriod, o.benefitPeriod, true) && InsuranceComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareValues(this.inforce, o.inforce, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.coverage, this.inforce, this.benefitPeriod, this.item);
        }

        @Override
        public String fhirType() {
            return "CoverageEligibilityResponse.insurance";
        }
    }

    public static class EligibilityResponsePurposeEnumFactory
    implements EnumFactory<EligibilityResponsePurpose> {
        @Override
        public EligibilityResponsePurpose fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("auth-requirements".equals(codeString)) {
                return EligibilityResponsePurpose.AUTHREQUIREMENTS;
            }
            if ("benefits".equals(codeString)) {
                return EligibilityResponsePurpose.BENEFITS;
            }
            if ("discovery".equals(codeString)) {
                return EligibilityResponsePurpose.DISCOVERY;
            }
            if ("validation".equals(codeString)) {
                return EligibilityResponsePurpose.VALIDATION;
            }
            throw new IllegalArgumentException("Unknown EligibilityResponsePurpose code '" + codeString + "'");
        }

        public Enumeration<EligibilityResponsePurpose> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EligibilityResponsePurpose>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("auth-requirements".equals(codeString)) {
                return new Enumeration<EligibilityResponsePurpose>(this, EligibilityResponsePurpose.AUTHREQUIREMENTS);
            }
            if ("benefits".equals(codeString)) {
                return new Enumeration<EligibilityResponsePurpose>(this, EligibilityResponsePurpose.BENEFITS);
            }
            if ("discovery".equals(codeString)) {
                return new Enumeration<EligibilityResponsePurpose>(this, EligibilityResponsePurpose.DISCOVERY);
            }
            if ("validation".equals(codeString)) {
                return new Enumeration<EligibilityResponsePurpose>(this, EligibilityResponsePurpose.VALIDATION);
            }
            throw new FHIRException("Unknown EligibilityResponsePurpose code '" + codeString + "'");
        }

        @Override
        public String toCode(EligibilityResponsePurpose code) {
            if (code == EligibilityResponsePurpose.AUTHREQUIREMENTS) {
                return "auth-requirements";
            }
            if (code == EligibilityResponsePurpose.BENEFITS) {
                return "benefits";
            }
            if (code == EligibilityResponsePurpose.DISCOVERY) {
                return "discovery";
            }
            if (code == EligibilityResponsePurpose.VALIDATION) {
                return "validation";
            }
            return "?";
        }

        @Override
        public String toSystem(EligibilityResponsePurpose code) {
            return code.getSystem();
        }
    }

    public static enum EligibilityResponsePurpose {
        AUTHREQUIREMENTS,
        BENEFITS,
        DISCOVERY,
        VALIDATION,
        NULL;


        public static EligibilityResponsePurpose fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("auth-requirements".equals(codeString)) {
                return AUTHREQUIREMENTS;
            }
            if ("benefits".equals(codeString)) {
                return BENEFITS;
            }
            if ("discovery".equals(codeString)) {
                return DISCOVERY;
            }
            if ("validation".equals(codeString)) {
                return VALIDATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EligibilityResponsePurpose code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AUTHREQUIREMENTS: {
                    return "auth-requirements";
                }
                case BENEFITS: {
                    return "benefits";
                }
                case DISCOVERY: {
                    return "discovery";
                }
                case VALIDATION: {
                    return "validation";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AUTHREQUIREMENTS: {
                    return "http://hl7.org/fhir/eligibilityresponse-purpose";
                }
                case BENEFITS: {
                    return "http://hl7.org/fhir/eligibilityresponse-purpose";
                }
                case DISCOVERY: {
                    return "http://hl7.org/fhir/eligibilityresponse-purpose";
                }
                case VALIDATION: {
                    return "http://hl7.org/fhir/eligibilityresponse-purpose";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AUTHREQUIREMENTS: {
                    return "The prior authorization requirements for the listed, or discovered if specified, converages for the categories of service and/or specifed biling codes are requested.";
                }
                case BENEFITS: {
                    return "The plan benefits and optionally benefits consumed  for the listed, or discovered if specified, converages are requested.";
                }
                case DISCOVERY: {
                    return "The insurer is requested to report on any coverages which they are aware of in addition to any specifed.";
                }
                case VALIDATION: {
                    return "A check that the specified coverages are in-force is requested.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AUTHREQUIREMENTS: {
                    return "Coverage auth-requirements";
                }
                case BENEFITS: {
                    return "Coverage benefits";
                }
                case DISCOVERY: {
                    return "Coverage Discovery";
                }
                case VALIDATION: {
                    return "Coverage Validation";
                }
            }
            return "?";
        }
    }
}

