/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Citation", profile="http://hl7.org/fhir/StructureDefinition/Citation")
public class Citation
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this citation, represented as a globally unique URI", formalDefinition="An absolute URI that is used to identify this citation when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of this summary", formalDefinition="The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this summary. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="useContext", type={UsageContext.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Use context", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate citation instances.")
    protected List<UsageContext> useContext;
    @Child(name="identifier", type={Identifier.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="May include DOI, PMID, PMCID, etc.", formalDefinition="A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance. May include DOI, PMID, PMCID, etc.")
    protected List<Identifier> identifier;
    @Child(name="relatedIdentifier", type={Identifier.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="May include trial registry identifiers", formalDefinition="May include trial registry identifiers.")
    protected List<Identifier> relatedIdentifier;
    @Child(name="dateCited", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date Cited", formalDefinition="Date Cited.")
    protected DateTimeType dateCited;
    @Child(name="variantCitation", type={}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Variant citation", formalDefinition="Variant citation.")
    protected CitationVariantCitationComponent variantCitation;
    @Child(name="publishingModel", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identify the medium/media in which the cited article is published, eg print, electronic or print-electronic", formalDefinition="Identify the medium/media in which the cited article is published, eg print, electronic or print-electronic.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publishing-model-type")
    protected CodeableConcept publishingModel;
    @Child(name="journal", type={}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Contains identifiers and classifiers for the journal cited", formalDefinition="Contains identifiers and classifiers for the journal cited.")
    protected CitationJournalComponent journal;
    @Child(name="articleTitle", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Full title of the article", formalDefinition="Full title of the article.")
    protected MarkdownType articleTitle;
    @Child(name="alternativeTitle", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for variant titles, such as translations", formalDefinition="Used for variant titles, such as translations.")
    protected List<CitationAlternativeTitleComponent> alternativeTitle;
    @Child(name="pagination", type={}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates the inclusive pages for the article cited", formalDefinition="Indicates the inclusive pages for the article cited.")
    protected CitationPaginationComponent pagination;
    @Child(name="articleUrl", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for any URL for the article cited", formalDefinition="Used for any URL for the article cited.")
    protected List<CitationArticleUrlComponent> articleUrl;
    @Child(name="abstract", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Abstract text", formalDefinition="Abstract text, may include structured labels.")
    protected MarkdownType abstract_;
    @Child(name="abstractCopyright", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Abstract copyright", formalDefinition="Copyright information for the abstract text.")
    protected MarkdownType abstractCopyright;
    @Child(name="alternativeAbstract", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for variant abstracts, such as translations", formalDefinition="Used for variant abstracts, such as translations.")
    protected List<CitationAlternativeAbstractComponent> alternativeAbstract;
    @Child(name="authorList", type={}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Personal and collective author names", formalDefinition="Personal and collective author names.")
    protected CitationAuthorListComponent authorList;
    @Child(name="authorString", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used to record a display of the author list without separate coding for each author", formalDefinition="Used to record a display of the author list without separate coding for each author.")
    protected List<CitationAuthorStringComponent> authorString;
    @Child(name="contributorList", type={}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Personal and collective contributor names", formalDefinition="Personal and collective contributor names.")
    protected CitationContributorListComponent contributorList;
    @Child(name="articleLanguage", type={CodeableConcept.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The language in which the article is published", formalDefinition="The language in which the article is published.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
    protected CodeableConcept articleLanguage;
    @Child(name="alternativeForm", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used to represent alternative forms of the article that are not separate citations", formalDefinition="Used to represent alternative forms of the article that are not separate citations.")
    protected List<CitationAlternativeFormComponent> alternativeForm;
    @Child(name="classifier", type={CodeableConcept.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for many classifiers including PublicationType, CitationSubset, MeshHeading, Chemical", formalDefinition="Used for many classifiers including PublicationType, CitationSubset, MeshHeading, Chemical.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-classifier")
    protected List<CodeableConcept> classifier;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Link or citation to artifact associated with the summary", formalDefinition="Used for referencing EvidenceReport resource.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="note", type={Annotation.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for general notes and annotations not coded elsewhere", formalDefinition="Used for general notes and annotations not coded elsewhere.")
    protected List<Annotation> note;
    @Child(name="medlinePubMed", type={}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="These elements are items with values assigned by MEDLINE or PubMed management", formalDefinition="These elements are items with values assigned by MEDLINE or PubMed management.")
    protected CitationMedlinePubMedComponent medlinePubMed;
    private static final long serialVersionUID = 1796797816L;
    @SearchParamDefinition(name="context-quantity", path="(Citation.useContext.value as Quantity) | (Citation.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the citation", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="Citation.useContext", description="A use context type and quantity- or range-based value assigned to the citation", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="Citation.useContext", description="A use context type and value assigned to the citation", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="Citation.useContext.code", description="A type of use context assigned to the citation", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(Citation.useContext.value as CodeableConcept)", description="A use context assigned to the citation", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="identifier", path="Citation.identifier", description="External identifier for the citation", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="Citation.status", description="The current status of the citation", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="url", path="Citation.url", description="The uri that identifies the citation", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="Citation.version", description="The business version of the citation", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public Citation() {
    }

    public Citation(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public Citation setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public Citation setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public Citation setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public Citation setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public Citation setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public Citation setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public Citation setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public Citation addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public Citation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public Citation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Identifier> getRelatedIdentifier() {
        if (this.relatedIdentifier == null) {
            this.relatedIdentifier = new ArrayList<Identifier>();
        }
        return this.relatedIdentifier;
    }

    public Citation setRelatedIdentifier(List<Identifier> theRelatedIdentifier) {
        this.relatedIdentifier = theRelatedIdentifier;
        return this;
    }

    public boolean hasRelatedIdentifier() {
        if (this.relatedIdentifier == null) {
            return false;
        }
        for (Identifier item : this.relatedIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addRelatedIdentifier() {
        Identifier t = new Identifier();
        if (this.relatedIdentifier == null) {
            this.relatedIdentifier = new ArrayList<Identifier>();
        }
        this.relatedIdentifier.add(t);
        return t;
    }

    public Citation addRelatedIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.relatedIdentifier == null) {
            this.relatedIdentifier = new ArrayList<Identifier>();
        }
        this.relatedIdentifier.add(t);
        return this;
    }

    public Identifier getRelatedIdentifierFirstRep() {
        if (this.getRelatedIdentifier().isEmpty()) {
            this.addRelatedIdentifier();
        }
        return this.getRelatedIdentifier().get(0);
    }

    public DateTimeType getDateCitedElement() {
        if (this.dateCited == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.dateCited");
            }
            if (Configuration.doAutoCreate()) {
                this.dateCited = new DateTimeType();
            }
        }
        return this.dateCited;
    }

    public boolean hasDateCitedElement() {
        return this.dateCited != null && !this.dateCited.isEmpty();
    }

    public boolean hasDateCited() {
        return this.dateCited != null && !this.dateCited.isEmpty();
    }

    public Citation setDateCitedElement(DateTimeType value) {
        this.dateCited = value;
        return this;
    }

    public Date getDateCited() {
        return this.dateCited == null ? null : (Date)this.dateCited.getValue();
    }

    public Citation setDateCited(Date value) {
        if (value == null) {
            this.dateCited = null;
        } else {
            if (this.dateCited == null) {
                this.dateCited = new DateTimeType();
            }
            this.dateCited.setValue(value);
        }
        return this;
    }

    public CitationVariantCitationComponent getVariantCitation() {
        if (this.variantCitation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.variantCitation");
            }
            if (Configuration.doAutoCreate()) {
                this.variantCitation = new CitationVariantCitationComponent();
            }
        }
        return this.variantCitation;
    }

    public boolean hasVariantCitation() {
        return this.variantCitation != null && !this.variantCitation.isEmpty();
    }

    public Citation setVariantCitation(CitationVariantCitationComponent value) {
        this.variantCitation = value;
        return this;
    }

    public CodeableConcept getPublishingModel() {
        if (this.publishingModel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.publishingModel");
            }
            if (Configuration.doAutoCreate()) {
                this.publishingModel = new CodeableConcept();
            }
        }
        return this.publishingModel;
    }

    public boolean hasPublishingModel() {
        return this.publishingModel != null && !this.publishingModel.isEmpty();
    }

    public Citation setPublishingModel(CodeableConcept value) {
        this.publishingModel = value;
        return this;
    }

    public CitationJournalComponent getJournal() {
        if (this.journal == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.journal");
            }
            if (Configuration.doAutoCreate()) {
                this.journal = new CitationJournalComponent();
            }
        }
        return this.journal;
    }

    public boolean hasJournal() {
        return this.journal != null && !this.journal.isEmpty();
    }

    public Citation setJournal(CitationJournalComponent value) {
        this.journal = value;
        return this;
    }

    public MarkdownType getArticleTitleElement() {
        if (this.articleTitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.articleTitle");
            }
            if (Configuration.doAutoCreate()) {
                this.articleTitle = new MarkdownType();
            }
        }
        return this.articleTitle;
    }

    public boolean hasArticleTitleElement() {
        return this.articleTitle != null && !this.articleTitle.isEmpty();
    }

    public boolean hasArticleTitle() {
        return this.articleTitle != null && !this.articleTitle.isEmpty();
    }

    public Citation setArticleTitleElement(MarkdownType value) {
        this.articleTitle = value;
        return this;
    }

    public String getArticleTitle() {
        return this.articleTitle == null ? null : (String)this.articleTitle.getValue();
    }

    public Citation setArticleTitle(String value) {
        if (value == null) {
            this.articleTitle = null;
        } else {
            if (this.articleTitle == null) {
                this.articleTitle = new MarkdownType();
            }
            this.articleTitle.setValue(value);
        }
        return this;
    }

    public List<CitationAlternativeTitleComponent> getAlternativeTitle() {
        if (this.alternativeTitle == null) {
            this.alternativeTitle = new ArrayList<CitationAlternativeTitleComponent>();
        }
        return this.alternativeTitle;
    }

    public Citation setAlternativeTitle(List<CitationAlternativeTitleComponent> theAlternativeTitle) {
        this.alternativeTitle = theAlternativeTitle;
        return this;
    }

    public boolean hasAlternativeTitle() {
        if (this.alternativeTitle == null) {
            return false;
        }
        for (CitationAlternativeTitleComponent item : this.alternativeTitle) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationAlternativeTitleComponent addAlternativeTitle() {
        CitationAlternativeTitleComponent t = new CitationAlternativeTitleComponent();
        if (this.alternativeTitle == null) {
            this.alternativeTitle = new ArrayList<CitationAlternativeTitleComponent>();
        }
        this.alternativeTitle.add(t);
        return t;
    }

    public Citation addAlternativeTitle(CitationAlternativeTitleComponent t) {
        if (t == null) {
            return this;
        }
        if (this.alternativeTitle == null) {
            this.alternativeTitle = new ArrayList<CitationAlternativeTitleComponent>();
        }
        this.alternativeTitle.add(t);
        return this;
    }

    public CitationAlternativeTitleComponent getAlternativeTitleFirstRep() {
        if (this.getAlternativeTitle().isEmpty()) {
            this.addAlternativeTitle();
        }
        return this.getAlternativeTitle().get(0);
    }

    public CitationPaginationComponent getPagination() {
        if (this.pagination == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.pagination");
            }
            if (Configuration.doAutoCreate()) {
                this.pagination = new CitationPaginationComponent();
            }
        }
        return this.pagination;
    }

    public boolean hasPagination() {
        return this.pagination != null && !this.pagination.isEmpty();
    }

    public Citation setPagination(CitationPaginationComponent value) {
        this.pagination = value;
        return this;
    }

    public List<CitationArticleUrlComponent> getArticleUrl() {
        if (this.articleUrl == null) {
            this.articleUrl = new ArrayList<CitationArticleUrlComponent>();
        }
        return this.articleUrl;
    }

    public Citation setArticleUrl(List<CitationArticleUrlComponent> theArticleUrl) {
        this.articleUrl = theArticleUrl;
        return this;
    }

    public boolean hasArticleUrl() {
        if (this.articleUrl == null) {
            return false;
        }
        for (CitationArticleUrlComponent item : this.articleUrl) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationArticleUrlComponent addArticleUrl() {
        CitationArticleUrlComponent t = new CitationArticleUrlComponent();
        if (this.articleUrl == null) {
            this.articleUrl = new ArrayList<CitationArticleUrlComponent>();
        }
        this.articleUrl.add(t);
        return t;
    }

    public Citation addArticleUrl(CitationArticleUrlComponent t) {
        if (t == null) {
            return this;
        }
        if (this.articleUrl == null) {
            this.articleUrl = new ArrayList<CitationArticleUrlComponent>();
        }
        this.articleUrl.add(t);
        return this;
    }

    public CitationArticleUrlComponent getArticleUrlFirstRep() {
        if (this.getArticleUrl().isEmpty()) {
            this.addArticleUrl();
        }
        return this.getArticleUrl().get(0);
    }

    public MarkdownType getAbstractElement() {
        if (this.abstract_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.abstract_");
            }
            if (Configuration.doAutoCreate()) {
                this.abstract_ = new MarkdownType();
            }
        }
        return this.abstract_;
    }

    public boolean hasAbstractElement() {
        return this.abstract_ != null && !this.abstract_.isEmpty();
    }

    public boolean hasAbstract() {
        return this.abstract_ != null && !this.abstract_.isEmpty();
    }

    public Citation setAbstractElement(MarkdownType value) {
        this.abstract_ = value;
        return this;
    }

    public String getAbstract() {
        return this.abstract_ == null ? null : (String)this.abstract_.getValue();
    }

    public Citation setAbstract(String value) {
        if (value == null) {
            this.abstract_ = null;
        } else {
            if (this.abstract_ == null) {
                this.abstract_ = new MarkdownType();
            }
            this.abstract_.setValue(value);
        }
        return this;
    }

    public MarkdownType getAbstractCopyrightElement() {
        if (this.abstractCopyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.abstractCopyright");
            }
            if (Configuration.doAutoCreate()) {
                this.abstractCopyright = new MarkdownType();
            }
        }
        return this.abstractCopyright;
    }

    public boolean hasAbstractCopyrightElement() {
        return this.abstractCopyright != null && !this.abstractCopyright.isEmpty();
    }

    public boolean hasAbstractCopyright() {
        return this.abstractCopyright != null && !this.abstractCopyright.isEmpty();
    }

    public Citation setAbstractCopyrightElement(MarkdownType value) {
        this.abstractCopyright = value;
        return this;
    }

    public String getAbstractCopyright() {
        return this.abstractCopyright == null ? null : (String)this.abstractCopyright.getValue();
    }

    public Citation setAbstractCopyright(String value) {
        if (value == null) {
            this.abstractCopyright = null;
        } else {
            if (this.abstractCopyright == null) {
                this.abstractCopyright = new MarkdownType();
            }
            this.abstractCopyright.setValue(value);
        }
        return this;
    }

    public List<CitationAlternativeAbstractComponent> getAlternativeAbstract() {
        if (this.alternativeAbstract == null) {
            this.alternativeAbstract = new ArrayList<CitationAlternativeAbstractComponent>();
        }
        return this.alternativeAbstract;
    }

    public Citation setAlternativeAbstract(List<CitationAlternativeAbstractComponent> theAlternativeAbstract) {
        this.alternativeAbstract = theAlternativeAbstract;
        return this;
    }

    public boolean hasAlternativeAbstract() {
        if (this.alternativeAbstract == null) {
            return false;
        }
        for (CitationAlternativeAbstractComponent item : this.alternativeAbstract) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationAlternativeAbstractComponent addAlternativeAbstract() {
        CitationAlternativeAbstractComponent t = new CitationAlternativeAbstractComponent();
        if (this.alternativeAbstract == null) {
            this.alternativeAbstract = new ArrayList<CitationAlternativeAbstractComponent>();
        }
        this.alternativeAbstract.add(t);
        return t;
    }

    public Citation addAlternativeAbstract(CitationAlternativeAbstractComponent t) {
        if (t == null) {
            return this;
        }
        if (this.alternativeAbstract == null) {
            this.alternativeAbstract = new ArrayList<CitationAlternativeAbstractComponent>();
        }
        this.alternativeAbstract.add(t);
        return this;
    }

    public CitationAlternativeAbstractComponent getAlternativeAbstractFirstRep() {
        if (this.getAlternativeAbstract().isEmpty()) {
            this.addAlternativeAbstract();
        }
        return this.getAlternativeAbstract().get(0);
    }

    public CitationAuthorListComponent getAuthorList() {
        if (this.authorList == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.authorList");
            }
            if (Configuration.doAutoCreate()) {
                this.authorList = new CitationAuthorListComponent();
            }
        }
        return this.authorList;
    }

    public boolean hasAuthorList() {
        return this.authorList != null && !this.authorList.isEmpty();
    }

    public Citation setAuthorList(CitationAuthorListComponent value) {
        this.authorList = value;
        return this;
    }

    public List<CitationAuthorStringComponent> getAuthorString() {
        if (this.authorString == null) {
            this.authorString = new ArrayList<CitationAuthorStringComponent>();
        }
        return this.authorString;
    }

    public Citation setAuthorString(List<CitationAuthorStringComponent> theAuthorString) {
        this.authorString = theAuthorString;
        return this;
    }

    public boolean hasAuthorString() {
        if (this.authorString == null) {
            return false;
        }
        for (CitationAuthorStringComponent item : this.authorString) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationAuthorStringComponent addAuthorString() {
        CitationAuthorStringComponent t = new CitationAuthorStringComponent();
        if (this.authorString == null) {
            this.authorString = new ArrayList<CitationAuthorStringComponent>();
        }
        this.authorString.add(t);
        return t;
    }

    public Citation addAuthorString(CitationAuthorStringComponent t) {
        if (t == null) {
            return this;
        }
        if (this.authorString == null) {
            this.authorString = new ArrayList<CitationAuthorStringComponent>();
        }
        this.authorString.add(t);
        return this;
    }

    public CitationAuthorStringComponent getAuthorStringFirstRep() {
        if (this.getAuthorString().isEmpty()) {
            this.addAuthorString();
        }
        return this.getAuthorString().get(0);
    }

    public CitationContributorListComponent getContributorList() {
        if (this.contributorList == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.contributorList");
            }
            if (Configuration.doAutoCreate()) {
                this.contributorList = new CitationContributorListComponent();
            }
        }
        return this.contributorList;
    }

    public boolean hasContributorList() {
        return this.contributorList != null && !this.contributorList.isEmpty();
    }

    public Citation setContributorList(CitationContributorListComponent value) {
        this.contributorList = value;
        return this;
    }

    public CodeableConcept getArticleLanguage() {
        if (this.articleLanguage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.articleLanguage");
            }
            if (Configuration.doAutoCreate()) {
                this.articleLanguage = new CodeableConcept();
            }
        }
        return this.articleLanguage;
    }

    public boolean hasArticleLanguage() {
        return this.articleLanguage != null && !this.articleLanguage.isEmpty();
    }

    public Citation setArticleLanguage(CodeableConcept value) {
        this.articleLanguage = value;
        return this;
    }

    public List<CitationAlternativeFormComponent> getAlternativeForm() {
        if (this.alternativeForm == null) {
            this.alternativeForm = new ArrayList<CitationAlternativeFormComponent>();
        }
        return this.alternativeForm;
    }

    public Citation setAlternativeForm(List<CitationAlternativeFormComponent> theAlternativeForm) {
        this.alternativeForm = theAlternativeForm;
        return this;
    }

    public boolean hasAlternativeForm() {
        if (this.alternativeForm == null) {
            return false;
        }
        for (CitationAlternativeFormComponent item : this.alternativeForm) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CitationAlternativeFormComponent addAlternativeForm() {
        CitationAlternativeFormComponent t = new CitationAlternativeFormComponent();
        if (this.alternativeForm == null) {
            this.alternativeForm = new ArrayList<CitationAlternativeFormComponent>();
        }
        this.alternativeForm.add(t);
        return t;
    }

    public Citation addAlternativeForm(CitationAlternativeFormComponent t) {
        if (t == null) {
            return this;
        }
        if (this.alternativeForm == null) {
            this.alternativeForm = new ArrayList<CitationAlternativeFormComponent>();
        }
        this.alternativeForm.add(t);
        return this;
    }

    public CitationAlternativeFormComponent getAlternativeFormFirstRep() {
        if (this.getAlternativeForm().isEmpty()) {
            this.addAlternativeForm();
        }
        return this.getAlternativeForm().get(0);
    }

    public List<CodeableConcept> getClassifier() {
        if (this.classifier == null) {
            this.classifier = new ArrayList<CodeableConcept>();
        }
        return this.classifier;
    }

    public Citation setClassifier(List<CodeableConcept> theClassifier) {
        this.classifier = theClassifier;
        return this;
    }

    public boolean hasClassifier() {
        if (this.classifier == null) {
            return false;
        }
        for (CodeableConcept item : this.classifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addClassifier() {
        CodeableConcept t = new CodeableConcept();
        if (this.classifier == null) {
            this.classifier = new ArrayList<CodeableConcept>();
        }
        this.classifier.add(t);
        return t;
    }

    public Citation addClassifier(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.classifier == null) {
            this.classifier = new ArrayList<CodeableConcept>();
        }
        this.classifier.add(t);
        return this;
    }

    public CodeableConcept getClassifierFirstRep() {
        if (this.getClassifier().isEmpty()) {
            this.addClassifier();
        }
        return this.getClassifier().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public Citation setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public Citation addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Citation setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Citation addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public CitationMedlinePubMedComponent getMedlinePubMed() {
        if (this.medlinePubMed == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Citation.medlinePubMed");
            }
            if (Configuration.doAutoCreate()) {
                this.medlinePubMed = new CitationMedlinePubMedComponent();
            }
        }
        return this.medlinePubMed;
    }

    public boolean hasMedlinePubMed() {
        return this.medlinePubMed != null && !this.medlinePubMed.isEmpty();
    }

    public Citation setMedlinePubMed(CitationMedlinePubMedComponent value) {
        this.medlinePubMed = value;
        return this;
    }

    @Override
    public int getNameMax() {
        return 0;
    }

    @Override
    public StringType getNameElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"name\"");
    }

    @Override
    public boolean hasNameElement() {
        return false;
    }

    @Override
    public boolean hasName() {
        return false;
    }

    @Override
    public Citation setNameElement(StringType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"name\"");
    }

    @Override
    public String getName() {
        throw new Error("The resource type \"Citation\" does not implement the property \"name\"");
    }

    @Override
    public Citation setName(String value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"name\"");
    }

    @Override
    public int getTitleMax() {
        return 0;
    }

    @Override
    public StringType getTitleElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"title\"");
    }

    @Override
    public boolean hasTitleElement() {
        return false;
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public Citation setTitleElement(StringType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"title\"");
    }

    @Override
    public String getTitle() {
        throw new Error("The resource type \"Citation\" does not implement the property \"title\"");
    }

    @Override
    public Citation setTitle(String value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"title\"");
    }

    @Override
    public int getExperimentalMax() {
        return 0;
    }

    @Override
    public BooleanType getExperimentalElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"experimental\"");
    }

    @Override
    public boolean hasExperimentalElement() {
        return false;
    }

    @Override
    public boolean hasExperimental() {
        return false;
    }

    @Override
    public Citation setExperimentalElement(BooleanType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"experimental\"");
    }

    @Override
    public boolean getExperimental() {
        throw new Error("The resource type \"Citation\" does not implement the property \"experimental\"");
    }

    @Override
    public Citation setExperimental(boolean value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"experimental\"");
    }

    @Override
    public int getDateMax() {
        return 0;
    }

    @Override
    public DateTimeType getDateElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"date\"");
    }

    @Override
    public boolean hasDateElement() {
        return false;
    }

    @Override
    public boolean hasDate() {
        return false;
    }

    @Override
    public Citation setDateElement(DateTimeType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"date\"");
    }

    @Override
    public Date getDate() {
        throw new Error("The resource type \"Citation\" does not implement the property \"date\"");
    }

    @Override
    public Citation setDate(Date value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"date\"");
    }

    @Override
    public int getPublisherMax() {
        return 0;
    }

    @Override
    public StringType getPublisherElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"publisher\"");
    }

    @Override
    public boolean hasPublisherElement() {
        return false;
    }

    @Override
    public boolean hasPublisher() {
        return false;
    }

    @Override
    public Citation setPublisherElement(StringType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"publisher\"");
    }

    @Override
    public String getPublisher() {
        throw new Error("The resource type \"Citation\" does not implement the property \"publisher\"");
    }

    @Override
    public Citation setPublisher(String value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"publisher\"");
    }

    @Override
    public int getContactMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getContact() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public Citation setContact(List<ContactDetail> theContact) {
        throw new Error("The resource type \"Citation\" does not implement the property \"contact\"");
    }

    @Override
    public boolean hasContact() {
        return false;
    }

    @Override
    public ContactDetail addContact() {
        throw new Error("The resource type \"Citation\" does not implement the property \"contact\"");
    }

    @Override
    public Citation addContact(ContactDetail t) {
        throw new Error("The resource type \"Citation\" does not implement the property \"contact\"");
    }

    @Override
    public ContactDetail getContactFirstRep() {
        throw new Error("The resource type \"Citation\" does not implement the property \"contact\"");
    }

    @Override
    public int getDescriptionMax() {
        return 0;
    }

    @Override
    public MarkdownType getDescriptionElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"description\"");
    }

    @Override
    public boolean hasDescriptionElement() {
        return false;
    }

    @Override
    public boolean hasDescription() {
        return false;
    }

    @Override
    public Citation setDescriptionElement(MarkdownType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"description\"");
    }

    @Override
    public String getDescription() {
        throw new Error("The resource type \"Citation\" does not implement the property \"description\"");
    }

    @Override
    public Citation setDescription(String value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"description\"");
    }

    @Override
    public int getJurisdictionMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public Citation setJurisdiction(List<CodeableConcept> theJurisdiction) {
        throw new Error("The resource type \"Citation\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public boolean hasJurisdiction() {
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        throw new Error("The resource type \"Citation\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public Citation addJurisdiction(CodeableConcept t) {
        throw new Error("The resource type \"Citation\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        throw new Error("The resource type \"Citation\" does not implement the property \"jurisdiction\"");
    }

    @Override
    public int getPurposeMax() {
        return 0;
    }

    @Override
    public MarkdownType getPurposeElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"purpose\"");
    }

    @Override
    public boolean hasPurposeElement() {
        return false;
    }

    @Override
    public boolean hasPurpose() {
        return false;
    }

    @Override
    public Citation setPurposeElement(MarkdownType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"purpose\"");
    }

    @Override
    public String getPurpose() {
        throw new Error("The resource type \"Citation\" does not implement the property \"purpose\"");
    }

    @Override
    public Citation setPurpose(String value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"purpose\"");
    }

    @Override
    public int getCopyrightMax() {
        return 0;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"copyright\"");
    }

    @Override
    public boolean hasCopyrightElement() {
        return false;
    }

    @Override
    public boolean hasCopyright() {
        return false;
    }

    @Override
    public Citation setCopyrightElement(MarkdownType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"copyright\"");
    }

    @Override
    public String getCopyright() {
        throw new Error("The resource type \"Citation\" does not implement the property \"copyright\"");
    }

    @Override
    public Citation setCopyright(String value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"copyright\"");
    }

    @Override
    public int getApprovalDateMax() {
        return 0;
    }

    @Override
    public DateType getApprovalDateElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"approvalDate\"");
    }

    @Override
    public boolean hasApprovalDateElement() {
        return false;
    }

    @Override
    public boolean hasApprovalDate() {
        return false;
    }

    @Override
    public Citation setApprovalDateElement(DateType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"approvalDate\"");
    }

    @Override
    public Date getApprovalDate() {
        throw new Error("The resource type \"Citation\" does not implement the property \"approvalDate\"");
    }

    @Override
    public Citation setApprovalDate(Date value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"approvalDate\"");
    }

    @Override
    public int getLastReviewDateMax() {
        return 0;
    }

    @Override
    public DateType getLastReviewDateElement() {
        throw new Error("The resource type \"Citation\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return false;
    }

    @Override
    public boolean hasLastReviewDate() {
        return false;
    }

    @Override
    public Citation setLastReviewDateElement(DateType value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public Date getLastReviewDate() {
        throw new Error("The resource type \"Citation\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public Citation setLastReviewDate(Date value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public int getEffectivePeriodMax() {
        return 0;
    }

    @Override
    public Period getEffectivePeriod() {
        throw new Error("The resource type \"Citation\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public boolean hasEffectivePeriod() {
        return false;
    }

    @Override
    public Citation setEffectivePeriod(Period value) {
        throw new Error("The resource type \"Citation\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this citation when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate citation instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance. May include DOI, PMID, PMCID, etc.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("relatedIdentifier", "Identifier", "May include trial registry identifiers.", 0, Integer.MAX_VALUE, this.relatedIdentifier));
        children.add(new Property("dateCited", "dateTime", "Date Cited.", 0, 1, this.dateCited));
        children.add(new Property("variantCitation", "", "Variant citation.", 0, 1, this.variantCitation));
        children.add(new Property("publishingModel", "CodeableConcept", "Identify the medium/media in which the cited article is published, eg print, electronic or print-electronic.", 0, 1, this.publishingModel));
        children.add(new Property("journal", "", "Contains identifiers and classifiers for the journal cited.", 0, 1, this.journal));
        children.add(new Property("articleTitle", "markdown", "Full title of the article.", 0, 1, this.articleTitle));
        children.add(new Property("alternativeTitle", "", "Used for variant titles, such as translations.", 0, Integer.MAX_VALUE, this.alternativeTitle));
        children.add(new Property("pagination", "", "Indicates the inclusive pages for the article cited.", 0, 1, this.pagination));
        children.add(new Property("articleUrl", "", "Used for any URL for the article cited.", 0, Integer.MAX_VALUE, this.articleUrl));
        children.add(new Property("abstract", "markdown", "Abstract text, may include structured labels.", 0, 1, this.abstract_));
        children.add(new Property("abstractCopyright", "markdown", "Copyright information for the abstract text.", 0, 1, this.abstractCopyright));
        children.add(new Property("alternativeAbstract", "", "Used for variant abstracts, such as translations.", 0, Integer.MAX_VALUE, this.alternativeAbstract));
        children.add(new Property("authorList", "", "Personal and collective author names.", 0, 1, this.authorList));
        children.add(new Property("authorString", "", "Used to record a display of the author list without separate coding for each author.", 0, Integer.MAX_VALUE, this.authorString));
        children.add(new Property("contributorList", "", "Personal and collective contributor names.", 0, 1, this.contributorList));
        children.add(new Property("articleLanguage", "CodeableConcept", "The language in which the article is published.", 0, 1, this.articleLanguage));
        children.add(new Property("alternativeForm", "", "Used to represent alternative forms of the article that are not separate citations.", 0, Integer.MAX_VALUE, this.alternativeForm));
        children.add(new Property("classifier", "CodeableConcept", "Used for many classifiers including PublicationType, CitationSubset, MeshHeading, Chemical.", 0, Integer.MAX_VALUE, this.classifier));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Used for referencing EvidenceReport resource.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("medlinePubMed", "", "These elements are items with values assigned by MEDLINE or PubMed management.", 0, 1, this.medlinePubMed));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this citation when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this summary is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the summary is stored on different servers.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the summary when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the summary author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this summary. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate citation instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this summary when it is represented in other formats, or referenced in a specification, model, design or an instance. May include DOI, PMID, PMCID, etc.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1007604940: {
                return new Property("relatedIdentifier", "Identifier", "May include trial registry identifiers.", 0, Integer.MAX_VALUE, this.relatedIdentifier);
            }
            case -275034401: {
                return new Property("dateCited", "dateTime", "Date Cited.", 0, 1, this.dateCited);
            }
            case -1653134708: {
                return new Property("variantCitation", "", "Variant citation.", 0, 1, this.variantCitation);
            }
            case 747318902: {
                return new Property("publishingModel", "CodeableConcept", "Identify the medium/media in which the cited article is published, eg print, electronic or print-electronic.", 0, 1, this.publishingModel);
            }
            case -1419464905: {
                return new Property("journal", "", "Contains identifiers and classifiers for the journal cited.", 0, 1, this.journal);
            }
            case -404746494: {
                return new Property("articleTitle", "markdown", "Full title of the article.", 0, 1, this.articleTitle);
            }
            case -1478308181: {
                return new Property("alternativeTitle", "", "Used for variant titles, such as translations.", 0, Integer.MAX_VALUE, this.alternativeTitle);
            }
            case 1297692570: {
                return new Property("pagination", "", "Indicates the inclusive pages for the article cited.", 0, 1, this.pagination);
            }
            case 0x9D4D499: {
                return new Property("articleUrl", "", "Used for any URL for the article cited.", 0, Integer.MAX_VALUE, this.articleUrl);
            }
            case 1732898850: {
                return new Property("abstract", "markdown", "Abstract text, may include structured labels.", 0, 1, this.abstract_);
            }
            case -656627259: {
                return new Property("abstractCopyright", "markdown", "Copyright information for the abstract text.", 0, 1, this.abstractCopyright);
            }
            case -376340753: {
                return new Property("alternativeAbstract", "", "Used for variant abstracts, such as translations.", 0, Integer.MAX_VALUE, this.alternativeAbstract);
            }
            case -1501591351: {
                return new Property("authorList", "", "Personal and collective author names.", 0, 1, this.authorList);
            }
            case 290249084: {
                return new Property("authorString", "", "Used to record a display of the author list without separate coding for each author.", 0, Integer.MAX_VALUE, this.authorString);
            }
            case 537567257: {
                return new Property("contributorList", "", "Personal and collective contributor names.", 0, 1, this.contributorList);
            }
            case -1573097874: {
                return new Property("articleLanguage", "CodeableConcept", "The language in which the article is published.", 0, 1, this.articleLanguage);
            }
            case 2030111249: {
                return new Property("alternativeForm", "", "Used to represent alternative forms of the article that are not separate citations.", 0, Integer.MAX_VALUE, this.alternativeForm);
            }
            case -281470431: {
                return new Property("classifier", "CodeableConcept", "Used for many classifiers including PublicationType, CitationSubset, MeshHeading, Chemical.", 0, Integer.MAX_VALUE, this.classifier);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Used for referencing EvidenceReport resource.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Used for general notes and annotations not coded elsewhere.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1342445201: {
                return new Property("medlinePubMed", "", "These elements are items with values assigned by MEDLINE or PubMed management.", 0, 1, this.medlinePubMed);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1007604940: {
                return this.relatedIdentifier == null ? new Base[]{} : this.relatedIdentifier.toArray(new Base[this.relatedIdentifier.size()]);
            }
            case -275034401: {
                Base[] baseArray;
                if (this.dateCited == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.dateCited;
                }
                return baseArray;
            }
            case -1653134708: {
                Base[] baseArray;
                if (this.variantCitation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.variantCitation;
                }
                return baseArray;
            }
            case 747318902: {
                Base[] baseArray;
                if (this.publishingModel == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.publishingModel;
                }
                return baseArray;
            }
            case -1419464905: {
                Base[] baseArray;
                if (this.journal == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.journal;
                }
                return baseArray;
            }
            case -404746494: {
                Base[] baseArray;
                if (this.articleTitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.articleTitle;
                }
                return baseArray;
            }
            case -1478308181: {
                return this.alternativeTitle == null ? new Base[]{} : this.alternativeTitle.toArray(new Base[this.alternativeTitle.size()]);
            }
            case 1297692570: {
                Base[] baseArray;
                if (this.pagination == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.pagination;
                }
                return baseArray;
            }
            case 0x9D4D499: {
                return this.articleUrl == null ? new Base[]{} : this.articleUrl.toArray(new Base[this.articleUrl.size()]);
            }
            case 1732898850: {
                Base[] baseArray;
                if (this.abstract_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.abstract_;
                }
                return baseArray;
            }
            case -656627259: {
                Base[] baseArray;
                if (this.abstractCopyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.abstractCopyright;
                }
                return baseArray;
            }
            case -376340753: {
                return this.alternativeAbstract == null ? new Base[]{} : this.alternativeAbstract.toArray(new Base[this.alternativeAbstract.size()]);
            }
            case -1501591351: {
                Base[] baseArray;
                if (this.authorList == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.authorList;
                }
                return baseArray;
            }
            case 290249084: {
                return this.authorString == null ? new Base[]{} : this.authorString.toArray(new Base[this.authorString.size()]);
            }
            case 537567257: {
                Base[] baseArray;
                if (this.contributorList == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.contributorList;
                }
                return baseArray;
            }
            case -1573097874: {
                Base[] baseArray;
                if (this.articleLanguage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.articleLanguage;
                }
                return baseArray;
            }
            case 2030111249: {
                return this.alternativeForm == null ? new Base[]{} : this.alternativeForm.toArray(new Base[this.alternativeForm.size()]);
            }
            case -281470431: {
                return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1342445201: {
                Base[] baseArray;
                if (this.medlinePubMed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.medlinePubMed;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1007604940: {
                this.getRelatedIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -275034401: {
                this.dateCited = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1653134708: {
                this.variantCitation = (CitationVariantCitationComponent)((Object)value);
                return value;
            }
            case 747318902: {
                this.publishingModel = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1419464905: {
                this.journal = (CitationJournalComponent)((Object)value);
                return value;
            }
            case -404746494: {
                this.articleTitle = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1478308181: {
                this.getAlternativeTitle().add((CitationAlternativeTitleComponent)((Object)value));
                return value;
            }
            case 1297692570: {
                this.pagination = (CitationPaginationComponent)((Object)value);
                return value;
            }
            case 0x9D4D499: {
                this.getArticleUrl().add((CitationArticleUrlComponent)((Object)value));
                return value;
            }
            case 1732898850: {
                this.abstract_ = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -656627259: {
                this.abstractCopyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -376340753: {
                this.getAlternativeAbstract().add((CitationAlternativeAbstractComponent)((Object)value));
                return value;
            }
            case -1501591351: {
                this.authorList = (CitationAuthorListComponent)((Object)value);
                return value;
            }
            case 290249084: {
                this.getAuthorString().add((CitationAuthorStringComponent)((Object)value));
                return value;
            }
            case 537567257: {
                this.contributorList = (CitationContributorListComponent)((Object)value);
                return value;
            }
            case -1573097874: {
                this.articleLanguage = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 2030111249: {
                this.getAlternativeForm().add((CitationAlternativeFormComponent)((Object)value));
                return value;
            }
            case -281470431: {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1342445201: {
                this.medlinePubMed = (CitationMedlinePubMedComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("relatedIdentifier")) {
            this.getRelatedIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("dateCited")) {
            this.dateCited = TypeConvertor.castToDateTime(value);
        } else if (name.equals("variantCitation")) {
            this.variantCitation = (CitationVariantCitationComponent)((Object)value);
        } else if (name.equals("publishingModel")) {
            this.publishingModel = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("journal")) {
            this.journal = (CitationJournalComponent)((Object)value);
        } else if (name.equals("articleTitle")) {
            this.articleTitle = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("alternativeTitle")) {
            this.getAlternativeTitle().add((CitationAlternativeTitleComponent)((Object)value));
        } else if (name.equals("pagination")) {
            this.pagination = (CitationPaginationComponent)((Object)value);
        } else if (name.equals("articleUrl")) {
            this.getArticleUrl().add((CitationArticleUrlComponent)((Object)value));
        } else if (name.equals("abstract")) {
            this.abstract_ = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("abstractCopyright")) {
            this.abstractCopyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("alternativeAbstract")) {
            this.getAlternativeAbstract().add((CitationAlternativeAbstractComponent)((Object)value));
        } else if (name.equals("authorList")) {
            this.authorList = (CitationAuthorListComponent)((Object)value);
        } else if (name.equals("authorString")) {
            this.getAuthorString().add((CitationAuthorStringComponent)((Object)value));
        } else if (name.equals("contributorList")) {
            this.contributorList = (CitationContributorListComponent)((Object)value);
        } else if (name.equals("articleLanguage")) {
            this.articleLanguage = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("alternativeForm")) {
            this.getAlternativeForm().add((CitationAlternativeFormComponent)((Object)value));
        } else if (name.equals("classifier")) {
            this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("medlinePubMed")) {
            this.medlinePubMed = (CitationMedlinePubMedComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1007604940: {
                return this.addRelatedIdentifier();
            }
            case -275034401: {
                return this.getDateCitedElement();
            }
            case -1653134708: {
                return this.getVariantCitation();
            }
            case 747318902: {
                return this.getPublishingModel();
            }
            case -1419464905: {
                return this.getJournal();
            }
            case -404746494: {
                return this.getArticleTitleElement();
            }
            case -1478308181: {
                return this.addAlternativeTitle();
            }
            case 1297692570: {
                return this.getPagination();
            }
            case 0x9D4D499: {
                return this.addArticleUrl();
            }
            case 1732898850: {
                return this.getAbstractElement();
            }
            case -656627259: {
                return this.getAbstractCopyrightElement();
            }
            case -376340753: {
                return this.addAlternativeAbstract();
            }
            case -1501591351: {
                return this.getAuthorList();
            }
            case 290249084: {
                return this.addAuthorString();
            }
            case 537567257: {
                return this.getContributorList();
            }
            case -1573097874: {
                return this.getArticleLanguage();
            }
            case 2030111249: {
                return this.addAlternativeForm();
            }
            case -281470431: {
                return this.addClassifier();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1342445201: {
                return this.getMedlinePubMed();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1007604940: {
                return new String[]{"Identifier"};
            }
            case -275034401: {
                return new String[]{"dateTime"};
            }
            case -1653134708: {
                return new String[0];
            }
            case 747318902: {
                return new String[]{"CodeableConcept"};
            }
            case -1419464905: {
                return new String[0];
            }
            case -404746494: {
                return new String[]{"markdown"};
            }
            case -1478308181: {
                return new String[0];
            }
            case 1297692570: {
                return new String[0];
            }
            case 0x9D4D499: {
                return new String[0];
            }
            case 1732898850: {
                return new String[]{"markdown"};
            }
            case -656627259: {
                return new String[]{"markdown"};
            }
            case -376340753: {
                return new String[0];
            }
            case -1501591351: {
                return new String[0];
            }
            case 290249084: {
                return new String[0];
            }
            case 537567257: {
                return new String[0];
            }
            case -1573097874: {
                return new String[]{"CodeableConcept"};
            }
            case 2030111249: {
                return new String[0];
            }
            case -281470431: {
                return new String[]{"CodeableConcept"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1342445201: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.version");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.status");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("relatedIdentifier")) {
            return this.addRelatedIdentifier();
        }
        if (name.equals("dateCited")) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.dateCited");
        }
        if (name.equals("variantCitation")) {
            this.variantCitation = new CitationVariantCitationComponent();
            return this.variantCitation;
        }
        if (name.equals("publishingModel")) {
            this.publishingModel = new CodeableConcept();
            return this.publishingModel;
        }
        if (name.equals("journal")) {
            this.journal = new CitationJournalComponent();
            return this.journal;
        }
        if (name.equals("articleTitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.articleTitle");
        }
        if (name.equals("alternativeTitle")) {
            return this.addAlternativeTitle();
        }
        if (name.equals("pagination")) {
            this.pagination = new CitationPaginationComponent();
            return this.pagination;
        }
        if (name.equals("articleUrl")) {
            return this.addArticleUrl();
        }
        if (name.equals("abstract")) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.abstract");
        }
        if (name.equals("abstractCopyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type Citation.abstractCopyright");
        }
        if (name.equals("alternativeAbstract")) {
            return this.addAlternativeAbstract();
        }
        if (name.equals("authorList")) {
            this.authorList = new CitationAuthorListComponent();
            return this.authorList;
        }
        if (name.equals("authorString")) {
            return this.addAuthorString();
        }
        if (name.equals("contributorList")) {
            this.contributorList = new CitationContributorListComponent();
            return this.contributorList;
        }
        if (name.equals("articleLanguage")) {
            this.articleLanguage = new CodeableConcept();
            return this.articleLanguage;
        }
        if (name.equals("alternativeForm")) {
            return this.addAlternativeForm();
        }
        if (name.equals("classifier")) {
            return this.addClassifier();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("medlinePubMed")) {
            this.medlinePubMed = new CitationMedlinePubMedComponent();
            return this.medlinePubMed;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Citation";
    }

    @Override
    public Citation copy() {
        Citation dst = new Citation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Citation dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        Enumeration<Enumerations.PublicationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.relatedIdentifier != null) {
            dst.relatedIdentifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.relatedIdentifier) {
                dst.relatedIdentifier.add(identifier.copy());
            }
        }
        dst.dateCited = this.dateCited == null ? null : this.dateCited.copy();
        dst.variantCitation = this.variantCitation == null ? null : this.variantCitation.copy();
        dst.publishingModel = this.publishingModel == null ? null : this.publishingModel.copy();
        dst.journal = this.journal == null ? null : this.journal.copy();
        MarkdownType markdownType = dst.articleTitle = this.articleTitle == null ? null : this.articleTitle.copy();
        if (this.alternativeTitle != null) {
            dst.alternativeTitle = new ArrayList<CitationAlternativeTitleComponent>();
            for (CitationAlternativeTitleComponent citationAlternativeTitleComponent : this.alternativeTitle) {
                dst.alternativeTitle.add(citationAlternativeTitleComponent.copy());
            }
        }
        CitationPaginationComponent citationPaginationComponent = dst.pagination = this.pagination == null ? null : this.pagination.copy();
        if (this.articleUrl != null) {
            dst.articleUrl = new ArrayList<CitationArticleUrlComponent>();
            for (CitationArticleUrlComponent citationArticleUrlComponent : this.articleUrl) {
                dst.articleUrl.add(citationArticleUrlComponent.copy());
            }
        }
        dst.abstract_ = this.abstract_ == null ? null : this.abstract_.copy();
        MarkdownType markdownType2 = dst.abstractCopyright = this.abstractCopyright == null ? null : this.abstractCopyright.copy();
        if (this.alternativeAbstract != null) {
            dst.alternativeAbstract = new ArrayList<CitationAlternativeAbstractComponent>();
            for (CitationAlternativeAbstractComponent citationAlternativeAbstractComponent : this.alternativeAbstract) {
                dst.alternativeAbstract.add(citationAlternativeAbstractComponent.copy());
            }
        }
        CitationAuthorListComponent citationAuthorListComponent = dst.authorList = this.authorList == null ? null : this.authorList.copy();
        if (this.authorString != null) {
            dst.authorString = new ArrayList<CitationAuthorStringComponent>();
            for (CitationAuthorStringComponent citationAuthorStringComponent : this.authorString) {
                dst.authorString.add(citationAuthorStringComponent.copy());
            }
        }
        dst.contributorList = this.contributorList == null ? null : this.contributorList.copy();
        CodeableConcept codeableConcept = dst.articleLanguage = this.articleLanguage == null ? null : this.articleLanguage.copy();
        if (this.alternativeForm != null) {
            dst.alternativeForm = new ArrayList<CitationAlternativeFormComponent>();
            for (CitationAlternativeFormComponent citationAlternativeFormComponent : this.alternativeForm) {
                dst.alternativeForm.add(citationAlternativeFormComponent.copy());
            }
        }
        if (this.classifier != null) {
            dst.classifier = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.classifier) {
                dst.classifier.add(codeableConcept2.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.medlinePubMed = this.medlinePubMed == null ? null : this.medlinePubMed.copy();
    }

    protected Citation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Citation)) {
            return false;
        }
        Citation o = (Citation)other_;
        return Citation.compareDeep(this.url, o.url, true) && Citation.compareDeep(this.version, o.version, true) && Citation.compareDeep(this.status, o.status, true) && Citation.compareDeep(this.useContext, o.useContext, true) && Citation.compareDeep(this.identifier, o.identifier, true) && Citation.compareDeep(this.relatedIdentifier, o.relatedIdentifier, true) && Citation.compareDeep(this.dateCited, o.dateCited, true) && Citation.compareDeep(this.variantCitation, o.variantCitation, true) && Citation.compareDeep(this.publishingModel, o.publishingModel, true) && Citation.compareDeep(this.journal, o.journal, true) && Citation.compareDeep(this.articleTitle, o.articleTitle, true) && Citation.compareDeep(this.alternativeTitle, o.alternativeTitle, true) && Citation.compareDeep(this.pagination, o.pagination, true) && Citation.compareDeep(this.articleUrl, o.articleUrl, true) && Citation.compareDeep(this.abstract_, o.abstract_, true) && Citation.compareDeep(this.abstractCopyright, o.abstractCopyright, true) && Citation.compareDeep(this.alternativeAbstract, o.alternativeAbstract, true) && Citation.compareDeep(this.authorList, o.authorList, true) && Citation.compareDeep(this.authorString, o.authorString, true) && Citation.compareDeep(this.contributorList, o.contributorList, true) && Citation.compareDeep(this.articleLanguage, o.articleLanguage, true) && Citation.compareDeep(this.alternativeForm, o.alternativeForm, true) && Citation.compareDeep(this.classifier, o.classifier, true) && Citation.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && Citation.compareDeep(this.note, o.note, true) && Citation.compareDeep(this.medlinePubMed, o.medlinePubMed, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Citation)) {
            return false;
        }
        Citation o = (Citation)other_;
        return Citation.compareValues(this.url, o.url, true) && Citation.compareValues(this.version, o.version, true) && Citation.compareValues(this.status, o.status, true) && Citation.compareValues(this.dateCited, o.dateCited, true) && Citation.compareValues(this.articleTitle, o.articleTitle, true) && Citation.compareValues(this.abstract_, o.abstract_, true) && Citation.compareValues(this.abstractCopyright, o.abstractCopyright, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.url, this.version, this.status, this.useContext, this.identifier, this.relatedIdentifier, this.dateCited, this.variantCitation, this.publishingModel, this.journal, this.articleTitle, this.alternativeTitle, this.pagination, this.articleUrl, this.abstract_, this.abstractCopyright, this.alternativeAbstract, this.authorList, this.authorString, this.contributorList, this.articleLanguage, this.alternativeForm, this.classifier, this.relatedArtifact, this.note, this.medlinePubMed);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Citation;
    }

    @Block
    public static class CitationMedlinePubMedRelatedArticleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="citationReference", type={Citation.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Citation Resource for related article", formalDefinition="Citation Resource for related article.")
        protected Reference citationReference;
        @Child(name="citationMarkdown", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Citation string for related article", formalDefinition="Citation string for related article.")
        protected MarkdownType citationMarkdown;
        @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier for related article", formalDefinition="Identifier for related article.")
        protected List<Identifier> identifier;
        private static final long serialVersionUID = -704722480L;

        public Reference getCitationReference() {
            if (this.citationReference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedRelatedArticleComponent.citationReference");
                }
                if (Configuration.doAutoCreate()) {
                    this.citationReference = new Reference();
                }
            }
            return this.citationReference;
        }

        public boolean hasCitationReference() {
            return this.citationReference != null && !this.citationReference.isEmpty();
        }

        public CitationMedlinePubMedRelatedArticleComponent setCitationReference(Reference value) {
            this.citationReference = value;
            return this;
        }

        public MarkdownType getCitationMarkdownElement() {
            if (this.citationMarkdown == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedRelatedArticleComponent.citationMarkdown");
                }
                if (Configuration.doAutoCreate()) {
                    this.citationMarkdown = new MarkdownType();
                }
            }
            return this.citationMarkdown;
        }

        public boolean hasCitationMarkdownElement() {
            return this.citationMarkdown != null && !this.citationMarkdown.isEmpty();
        }

        public boolean hasCitationMarkdown() {
            return this.citationMarkdown != null && !this.citationMarkdown.isEmpty();
        }

        public CitationMedlinePubMedRelatedArticleComponent setCitationMarkdownElement(MarkdownType value) {
            this.citationMarkdown = value;
            return this;
        }

        public String getCitationMarkdown() {
            return this.citationMarkdown == null ? null : (String)this.citationMarkdown.getValue();
        }

        public CitationMedlinePubMedRelatedArticleComponent setCitationMarkdown(String value) {
            if (value == null) {
                this.citationMarkdown = null;
            } else {
                if (this.citationMarkdown == null) {
                    this.citationMarkdown = new MarkdownType();
                }
                this.citationMarkdown.setValue(value);
            }
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationMedlinePubMedRelatedArticleComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationMedlinePubMedRelatedArticleComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("citationReference", "Reference(Citation)", "Citation Resource for related article.", 0, 1, this.citationReference));
            children.add(new Property("citationMarkdown", "markdown", "Citation string for related article.", 0, 1, this.citationMarkdown));
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Identifier for related article.", 0, Integer.MAX_VALUE, this.identifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 87795748: {
                    return new Property("citationReference", "Reference(Citation)", "Citation Resource for related article.", 0, 1, this.citationReference);
                }
                case 279614710: {
                    return new Property("citationMarkdown", "markdown", "Citation string for related article.", 0, 1, this.citationMarkdown);
                }
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Identifier for related article.", 0, Integer.MAX_VALUE, this.identifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 87795748: {
                    Base[] baseArray;
                    if (this.citationReference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.citationReference;
                    }
                    return baseArray;
                }
                case 279614710: {
                    Base[] baseArray;
                    if (this.citationMarkdown == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.citationMarkdown;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 87795748: {
                    this.citationReference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 279614710: {
                    this.citationMarkdown = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("citationReference")) {
                this.citationReference = TypeConvertor.castToReference(value);
            } else if (name.equals("citationMarkdown")) {
                this.citationMarkdown = TypeConvertor.castToMarkdown(value);
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 87795748: {
                    return this.getCitationReference();
                }
                case 279614710: {
                    return this.getCitationMarkdownElement();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 87795748: {
                    return new String[]{"Reference"};
                }
                case 279614710: {
                    return new String[]{"markdown"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("citationReference")) {
                this.citationReference = new Reference();
                return this.citationReference;
            }
            if (name.equals("citationMarkdown")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.medlinePubMed.relatedArticle.citationMarkdown");
            }
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            return super.addChild(name);
        }

        @Override
        public CitationMedlinePubMedRelatedArticleComponent copy() {
            CitationMedlinePubMedRelatedArticleComponent dst = new CitationMedlinePubMedRelatedArticleComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationMedlinePubMedRelatedArticleComponent dst) {
            super.copyValues(dst);
            dst.citationReference = this.citationReference == null ? null : this.citationReference.copy();
            MarkdownType markdownType = dst.citationMarkdown = this.citationMarkdown == null ? null : this.citationMarkdown.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationMedlinePubMedRelatedArticleComponent)) {
                return false;
            }
            CitationMedlinePubMedRelatedArticleComponent o = (CitationMedlinePubMedRelatedArticleComponent)other_;
            return CitationMedlinePubMedRelatedArticleComponent.compareDeep(this.citationReference, o.citationReference, true) && CitationMedlinePubMedRelatedArticleComponent.compareDeep(this.citationMarkdown, o.citationMarkdown, true) && CitationMedlinePubMedRelatedArticleComponent.compareDeep(this.identifier, o.identifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationMedlinePubMedRelatedArticleComponent)) {
                return false;
            }
            CitationMedlinePubMedRelatedArticleComponent o = (CitationMedlinePubMedRelatedArticleComponent)other_;
            return CitationMedlinePubMedRelatedArticleComponent.compareValues(this.citationMarkdown, o.citationMarkdown, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.citationReference, this.citationMarkdown, this.identifier);
        }

        @Override
        public String fhirType() {
            return "Citation.medlinePubMed.relatedArticle";
        }
    }

    @Block
    public static class CitationMedlinePubMedPubMedPubDateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="publicationState", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="PubMed Publication Status", formalDefinition="PubMed Publication Status.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/pubmed-pubstatus")
        protected CodeableConcept publicationState;
        @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="PubMed Publication Date", formalDefinition="PubMed Publication Date.")
        protected DateTimeType date;
        private static final long serialVersionUID = 1620940147L;

        public CodeableConcept getPublicationState() {
            if (this.publicationState == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedPubMedPubDateComponent.publicationState");
                }
                if (Configuration.doAutoCreate()) {
                    this.publicationState = new CodeableConcept();
                }
            }
            return this.publicationState;
        }

        public boolean hasPublicationState() {
            return this.publicationState != null && !this.publicationState.isEmpty();
        }

        public CitationMedlinePubMedPubMedPubDateComponent setPublicationState(CodeableConcept value) {
            this.publicationState = value;
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedPubMedPubDateComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public CitationMedlinePubMedPubMedPubDateComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public CitationMedlinePubMedPubMedPubDateComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("publicationState", "CodeableConcept", "PubMed Publication Status.", 0, 1, this.publicationState));
            children.add(new Property("date", "dateTime", "PubMed Publication Date.", 0, 1, this.date));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1642680891: {
                    return new Property("publicationState", "CodeableConcept", "PubMed Publication Status.", 0, 1, this.publicationState);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "PubMed Publication Date.", 0, 1, this.date);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1642680891: {
                    Base[] baseArray;
                    if (this.publicationState == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.publicationState;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.date;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1642680891: {
                    this.publicationState = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("publicationState")) {
                this.publicationState = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1642680891: {
                    return this.getPublicationState();
                }
                case 3076014: {
                    return this.getDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1642680891: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("publicationState")) {
                this.publicationState = new CodeableConcept();
                return this.publicationState;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.medlinePubMed.pubMedPubDate.date");
            }
            return super.addChild(name);
        }

        @Override
        public CitationMedlinePubMedPubMedPubDateComponent copy() {
            CitationMedlinePubMedPubMedPubDateComponent dst = new CitationMedlinePubMedPubMedPubDateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationMedlinePubMedPubMedPubDateComponent dst) {
            super.copyValues(dst);
            dst.publicationState = this.publicationState == null ? null : this.publicationState.copy();
            dst.date = this.date == null ? null : this.date.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationMedlinePubMedPubMedPubDateComponent)) {
                return false;
            }
            CitationMedlinePubMedPubMedPubDateComponent o = (CitationMedlinePubMedPubMedPubDateComponent)other_;
            return CitationMedlinePubMedPubMedPubDateComponent.compareDeep(this.publicationState, o.publicationState, true) && CitationMedlinePubMedPubMedPubDateComponent.compareDeep(this.date, o.date, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationMedlinePubMedPubMedPubDateComponent)) {
                return false;
            }
            CitationMedlinePubMedPubMedPubDateComponent o = (CitationMedlinePubMedPubMedPubDateComponent)other_;
            return CitationMedlinePubMedPubMedPubDateComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.publicationState, this.date);
        }

        @Override
        public String fhirType() {
            return "Citation.medlinePubMed.pubMedPubDate";
        }
    }

    @Block
    public static class CitationMedlinePubMedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="medlineState", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Completed | In-Process | PubMed-not-MEDLINE | In-Data-Review | Publisher | MEDLINE | OLDMEDLINE", formalDefinition="Used for status.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medline-pubmed-status")
        protected CodeableConcept medlineState;
        @Child(name="owner", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="NLM | NASA | PIP | KIE | HSR | HMD | SIS | NOTNLM", formalDefinition="Used for owner.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medline-pubmed-owner")
        protected CodeableConcept owner;
        @Child(name="pmid", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="PubMed ID", formalDefinition="PubMed ID.")
        protected PositiveIntType pmid;
        @Child(name="pmidVersion", type={PositiveIntType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="PubMed ID Version", formalDefinition="PubMed ID Version.")
        protected PositiveIntType pmidVersion;
        @Child(name="dateCreated", type={DateType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Creation date", formalDefinition="Creation date.")
        protected DateType dateCreated;
        @Child(name="dateCompleted", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Completion date", formalDefinition="Completion date.")
        protected DateType dateCompleted;
        @Child(name="dateRevised", type={DateType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revision date", formalDefinition="Revision date.")
        protected DateType dateRevised;
        @Child(name="pubMedPubDate", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subcomponent of certainty", formalDefinition="Subcomponent of certainty.")
        protected List<CitationMedlinePubMedPubMedPubDateComponent> pubMedPubDate;
        @Child(name="publicationState", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Publication Status", formalDefinition="Publication Status.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/pubmed-pubstatus")
        protected CodeableConcept publicationState;
        @Child(name="relatedArticle", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Related article", formalDefinition="Related article.")
        protected List<CitationMedlinePubMedRelatedArticleComponent> relatedArticle;
        private static final long serialVersionUID = -455295099L;

        public CodeableConcept getMedlineState() {
            if (this.medlineState == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedComponent.medlineState");
                }
                if (Configuration.doAutoCreate()) {
                    this.medlineState = new CodeableConcept();
                }
            }
            return this.medlineState;
        }

        public boolean hasMedlineState() {
            return this.medlineState != null && !this.medlineState.isEmpty();
        }

        public CitationMedlinePubMedComponent setMedlineState(CodeableConcept value) {
            this.medlineState = value;
            return this;
        }

        public CodeableConcept getOwner() {
            if (this.owner == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedComponent.owner");
                }
                if (Configuration.doAutoCreate()) {
                    this.owner = new CodeableConcept();
                }
            }
            return this.owner;
        }

        public boolean hasOwner() {
            return this.owner != null && !this.owner.isEmpty();
        }

        public CitationMedlinePubMedComponent setOwner(CodeableConcept value) {
            this.owner = value;
            return this;
        }

        public PositiveIntType getPmidElement() {
            if (this.pmid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedComponent.pmid");
                }
                if (Configuration.doAutoCreate()) {
                    this.pmid = new PositiveIntType();
                }
            }
            return this.pmid;
        }

        public boolean hasPmidElement() {
            return this.pmid != null && !this.pmid.isEmpty();
        }

        public boolean hasPmid() {
            return this.pmid != null && !this.pmid.isEmpty();
        }

        public CitationMedlinePubMedComponent setPmidElement(PositiveIntType value) {
            this.pmid = value;
            return this;
        }

        public int getPmid() {
            return this.pmid == null || this.pmid.isEmpty() ? 0 : (Integer)this.pmid.getValue();
        }

        public CitationMedlinePubMedComponent setPmid(int value) {
            if (this.pmid == null) {
                this.pmid = new PositiveIntType();
            }
            this.pmid.setValue((Object)value);
            return this;
        }

        public PositiveIntType getPmidVersionElement() {
            if (this.pmidVersion == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedComponent.pmidVersion");
                }
                if (Configuration.doAutoCreate()) {
                    this.pmidVersion = new PositiveIntType();
                }
            }
            return this.pmidVersion;
        }

        public boolean hasPmidVersionElement() {
            return this.pmidVersion != null && !this.pmidVersion.isEmpty();
        }

        public boolean hasPmidVersion() {
            return this.pmidVersion != null && !this.pmidVersion.isEmpty();
        }

        public CitationMedlinePubMedComponent setPmidVersionElement(PositiveIntType value) {
            this.pmidVersion = value;
            return this;
        }

        public int getPmidVersion() {
            return this.pmidVersion == null || this.pmidVersion.isEmpty() ? 0 : (Integer)this.pmidVersion.getValue();
        }

        public CitationMedlinePubMedComponent setPmidVersion(int value) {
            if (this.pmidVersion == null) {
                this.pmidVersion = new PositiveIntType();
            }
            this.pmidVersion.setValue((Object)value);
            return this;
        }

        public DateType getDateCreatedElement() {
            if (this.dateCreated == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedComponent.dateCreated");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateCreated = new DateType();
                }
            }
            return this.dateCreated;
        }

        public boolean hasDateCreatedElement() {
            return this.dateCreated != null && !this.dateCreated.isEmpty();
        }

        public boolean hasDateCreated() {
            return this.dateCreated != null && !this.dateCreated.isEmpty();
        }

        public CitationMedlinePubMedComponent setDateCreatedElement(DateType value) {
            this.dateCreated = value;
            return this;
        }

        public Date getDateCreated() {
            return this.dateCreated == null ? null : (Date)this.dateCreated.getValue();
        }

        public CitationMedlinePubMedComponent setDateCreated(Date value) {
            if (value == null) {
                this.dateCreated = null;
            } else {
                if (this.dateCreated == null) {
                    this.dateCreated = new DateType();
                }
                this.dateCreated.setValue(value);
            }
            return this;
        }

        public DateType getDateCompletedElement() {
            if (this.dateCompleted == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedComponent.dateCompleted");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateCompleted = new DateType();
                }
            }
            return this.dateCompleted;
        }

        public boolean hasDateCompletedElement() {
            return this.dateCompleted != null && !this.dateCompleted.isEmpty();
        }

        public boolean hasDateCompleted() {
            return this.dateCompleted != null && !this.dateCompleted.isEmpty();
        }

        public CitationMedlinePubMedComponent setDateCompletedElement(DateType value) {
            this.dateCompleted = value;
            return this;
        }

        public Date getDateCompleted() {
            return this.dateCompleted == null ? null : (Date)this.dateCompleted.getValue();
        }

        public CitationMedlinePubMedComponent setDateCompleted(Date value) {
            if (value == null) {
                this.dateCompleted = null;
            } else {
                if (this.dateCompleted == null) {
                    this.dateCompleted = new DateType();
                }
                this.dateCompleted.setValue(value);
            }
            return this;
        }

        public DateType getDateRevisedElement() {
            if (this.dateRevised == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedComponent.dateRevised");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateRevised = new DateType();
                }
            }
            return this.dateRevised;
        }

        public boolean hasDateRevisedElement() {
            return this.dateRevised != null && !this.dateRevised.isEmpty();
        }

        public boolean hasDateRevised() {
            return this.dateRevised != null && !this.dateRevised.isEmpty();
        }

        public CitationMedlinePubMedComponent setDateRevisedElement(DateType value) {
            this.dateRevised = value;
            return this;
        }

        public Date getDateRevised() {
            return this.dateRevised == null ? null : (Date)this.dateRevised.getValue();
        }

        public CitationMedlinePubMedComponent setDateRevised(Date value) {
            if (value == null) {
                this.dateRevised = null;
            } else {
                if (this.dateRevised == null) {
                    this.dateRevised = new DateType();
                }
                this.dateRevised.setValue(value);
            }
            return this;
        }

        public List<CitationMedlinePubMedPubMedPubDateComponent> getPubMedPubDate() {
            if (this.pubMedPubDate == null) {
                this.pubMedPubDate = new ArrayList<CitationMedlinePubMedPubMedPubDateComponent>();
            }
            return this.pubMedPubDate;
        }

        public CitationMedlinePubMedComponent setPubMedPubDate(List<CitationMedlinePubMedPubMedPubDateComponent> thePubMedPubDate) {
            this.pubMedPubDate = thePubMedPubDate;
            return this;
        }

        public boolean hasPubMedPubDate() {
            if (this.pubMedPubDate == null) {
                return false;
            }
            for (CitationMedlinePubMedPubMedPubDateComponent item : this.pubMedPubDate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationMedlinePubMedPubMedPubDateComponent addPubMedPubDate() {
            CitationMedlinePubMedPubMedPubDateComponent t = new CitationMedlinePubMedPubMedPubDateComponent();
            if (this.pubMedPubDate == null) {
                this.pubMedPubDate = new ArrayList<CitationMedlinePubMedPubMedPubDateComponent>();
            }
            this.pubMedPubDate.add(t);
            return t;
        }

        public CitationMedlinePubMedComponent addPubMedPubDate(CitationMedlinePubMedPubMedPubDateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.pubMedPubDate == null) {
                this.pubMedPubDate = new ArrayList<CitationMedlinePubMedPubMedPubDateComponent>();
            }
            this.pubMedPubDate.add(t);
            return this;
        }

        public CitationMedlinePubMedPubMedPubDateComponent getPubMedPubDateFirstRep() {
            if (this.getPubMedPubDate().isEmpty()) {
                this.addPubMedPubDate();
            }
            return this.getPubMedPubDate().get(0);
        }

        public CodeableConcept getPublicationState() {
            if (this.publicationState == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationMedlinePubMedComponent.publicationState");
                }
                if (Configuration.doAutoCreate()) {
                    this.publicationState = new CodeableConcept();
                }
            }
            return this.publicationState;
        }

        public boolean hasPublicationState() {
            return this.publicationState != null && !this.publicationState.isEmpty();
        }

        public CitationMedlinePubMedComponent setPublicationState(CodeableConcept value) {
            this.publicationState = value;
            return this;
        }

        public List<CitationMedlinePubMedRelatedArticleComponent> getRelatedArticle() {
            if (this.relatedArticle == null) {
                this.relatedArticle = new ArrayList<CitationMedlinePubMedRelatedArticleComponent>();
            }
            return this.relatedArticle;
        }

        public CitationMedlinePubMedComponent setRelatedArticle(List<CitationMedlinePubMedRelatedArticleComponent> theRelatedArticle) {
            this.relatedArticle = theRelatedArticle;
            return this;
        }

        public boolean hasRelatedArticle() {
            if (this.relatedArticle == null) {
                return false;
            }
            for (CitationMedlinePubMedRelatedArticleComponent item : this.relatedArticle) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationMedlinePubMedRelatedArticleComponent addRelatedArticle() {
            CitationMedlinePubMedRelatedArticleComponent t = new CitationMedlinePubMedRelatedArticleComponent();
            if (this.relatedArticle == null) {
                this.relatedArticle = new ArrayList<CitationMedlinePubMedRelatedArticleComponent>();
            }
            this.relatedArticle.add(t);
            return t;
        }

        public CitationMedlinePubMedComponent addRelatedArticle(CitationMedlinePubMedRelatedArticleComponent t) {
            if (t == null) {
                return this;
            }
            if (this.relatedArticle == null) {
                this.relatedArticle = new ArrayList<CitationMedlinePubMedRelatedArticleComponent>();
            }
            this.relatedArticle.add(t);
            return this;
        }

        public CitationMedlinePubMedRelatedArticleComponent getRelatedArticleFirstRep() {
            if (this.getRelatedArticle().isEmpty()) {
                this.addRelatedArticle();
            }
            return this.getRelatedArticle().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("medlineState", "CodeableConcept", "Used for status.", 0, 1, this.medlineState));
            children.add(new Property("owner", "CodeableConcept", "Used for owner.", 0, 1, this.owner));
            children.add(new Property("pmid", "positiveInt", "PubMed ID.", 0, 1, this.pmid));
            children.add(new Property("pmidVersion", "positiveInt", "PubMed ID Version.", 0, 1, this.pmidVersion));
            children.add(new Property("dateCreated", "date", "Creation date.", 0, 1, this.dateCreated));
            children.add(new Property("dateCompleted", "date", "Completion date.", 0, 1, this.dateCompleted));
            children.add(new Property("dateRevised", "date", "Revision date.", 0, 1, this.dateRevised));
            children.add(new Property("pubMedPubDate", "", "Subcomponent of certainty.", 0, Integer.MAX_VALUE, this.pubMedPubDate));
            children.add(new Property("publicationState", "CodeableConcept", "Publication Status.", 0, 1, this.publicationState));
            children.add(new Property("relatedArticle", "", "Related article.", 0, Integer.MAX_VALUE, this.relatedArticle));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 97983665: {
                    return new Property("medlineState", "CodeableConcept", "Used for status.", 0, 1, this.medlineState);
                }
                case 106164915: {
                    return new Property("owner", "CodeableConcept", "Used for owner.", 0, 1, this.owner);
                }
                case 3444696: {
                    return new Property("pmid", "positiveInt", "PubMed ID.", 0, 1, this.pmid);
                }
                case 59253216: {
                    return new Property("pmidVersion", "positiveInt", "PubMed ID Version.", 0, 1, this.pmidVersion);
                }
                case -2071345318: {
                    return new Property("dateCreated", "date", "Creation date.", 0, 1, this.dateCreated);
                }
                case 300673597: {
                    return new Property("dateCompleted", "date", "Completion date.", 0, 1, this.dateCompleted);
                }
                case -1999933730: {
                    return new Property("dateRevised", "date", "Revision date.", 0, 1, this.dateRevised);
                }
                case -1086645316: {
                    return new Property("pubMedPubDate", "", "Subcomponent of certainty.", 0, Integer.MAX_VALUE, this.pubMedPubDate);
                }
                case -1642680891: {
                    return new Property("publicationState", "CodeableConcept", "Publication Status.", 0, 1, this.publicationState);
                }
                case 1406980683: {
                    return new Property("relatedArticle", "", "Related article.", 0, Integer.MAX_VALUE, this.relatedArticle);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 97983665: {
                    Base[] baseArray;
                    if (this.medlineState == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.medlineState;
                    }
                    return baseArray;
                }
                case 106164915: {
                    Base[] baseArray;
                    if (this.owner == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.owner;
                    }
                    return baseArray;
                }
                case 3444696: {
                    Base[] baseArray;
                    if (this.pmid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.pmid;
                    }
                    return baseArray;
                }
                case 59253216: {
                    Base[] baseArray;
                    if (this.pmidVersion == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.pmidVersion;
                    }
                    return baseArray;
                }
                case -2071345318: {
                    Base[] baseArray;
                    if (this.dateCreated == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.dateCreated;
                    }
                    return baseArray;
                }
                case 300673597: {
                    Base[] baseArray;
                    if (this.dateCompleted == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.dateCompleted;
                    }
                    return baseArray;
                }
                case -1999933730: {
                    Base[] baseArray;
                    if (this.dateRevised == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.dateRevised;
                    }
                    return baseArray;
                }
                case -1086645316: {
                    return this.pubMedPubDate == null ? new Base[]{} : this.pubMedPubDate.toArray(new Base[this.pubMedPubDate.size()]);
                }
                case -1642680891: {
                    Base[] baseArray;
                    if (this.publicationState == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.publicationState;
                    }
                    return baseArray;
                }
                case 1406980683: {
                    return this.relatedArticle == null ? new Base[]{} : this.relatedArticle.toArray(new Base[this.relatedArticle.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 97983665: {
                    this.medlineState = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 106164915: {
                    this.owner = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3444696: {
                    this.pmid = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 59253216: {
                    this.pmidVersion = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case -2071345318: {
                    this.dateCreated = TypeConvertor.castToDate(value);
                    return value;
                }
                case 300673597: {
                    this.dateCompleted = TypeConvertor.castToDate(value);
                    return value;
                }
                case -1999933730: {
                    this.dateRevised = TypeConvertor.castToDate(value);
                    return value;
                }
                case -1086645316: {
                    this.getPubMedPubDate().add((CitationMedlinePubMedPubMedPubDateComponent)value);
                    return value;
                }
                case -1642680891: {
                    this.publicationState = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1406980683: {
                    this.getRelatedArticle().add((CitationMedlinePubMedRelatedArticleComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("medlineState")) {
                this.medlineState = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("owner")) {
                this.owner = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("pmid")) {
                this.pmid = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("pmidVersion")) {
                this.pmidVersion = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("dateCreated")) {
                this.dateCreated = TypeConvertor.castToDate(value);
            } else if (name.equals("dateCompleted")) {
                this.dateCompleted = TypeConvertor.castToDate(value);
            } else if (name.equals("dateRevised")) {
                this.dateRevised = TypeConvertor.castToDate(value);
            } else if (name.equals("pubMedPubDate")) {
                this.getPubMedPubDate().add((CitationMedlinePubMedPubMedPubDateComponent)value);
            } else if (name.equals("publicationState")) {
                this.publicationState = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("relatedArticle")) {
                this.getRelatedArticle().add((CitationMedlinePubMedRelatedArticleComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97983665: {
                    return this.getMedlineState();
                }
                case 106164915: {
                    return this.getOwner();
                }
                case 3444696: {
                    return this.getPmidElement();
                }
                case 59253216: {
                    return this.getPmidVersionElement();
                }
                case -2071345318: {
                    return this.getDateCreatedElement();
                }
                case 300673597: {
                    return this.getDateCompletedElement();
                }
                case -1999933730: {
                    return this.getDateRevisedElement();
                }
                case -1086645316: {
                    return this.addPubMedPubDate();
                }
                case -1642680891: {
                    return this.getPublicationState();
                }
                case 1406980683: {
                    return this.addRelatedArticle();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97983665: {
                    return new String[]{"CodeableConcept"};
                }
                case 106164915: {
                    return new String[]{"CodeableConcept"};
                }
                case 3444696: {
                    return new String[]{"positiveInt"};
                }
                case 59253216: {
                    return new String[]{"positiveInt"};
                }
                case -2071345318: {
                    return new String[]{"date"};
                }
                case 300673597: {
                    return new String[]{"date"};
                }
                case -1999933730: {
                    return new String[]{"date"};
                }
                case -1086645316: {
                    return new String[0];
                }
                case -1642680891: {
                    return new String[]{"CodeableConcept"};
                }
                case 1406980683: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("medlineState")) {
                this.medlineState = new CodeableConcept();
                return this.medlineState;
            }
            if (name.equals("owner")) {
                this.owner = new CodeableConcept();
                return this.owner;
            }
            if (name.equals("pmid")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.medlinePubMed.pmid");
            }
            if (name.equals("pmidVersion")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.medlinePubMed.pmidVersion");
            }
            if (name.equals("dateCreated")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.medlinePubMed.dateCreated");
            }
            if (name.equals("dateCompleted")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.medlinePubMed.dateCompleted");
            }
            if (name.equals("dateRevised")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.medlinePubMed.dateRevised");
            }
            if (name.equals("pubMedPubDate")) {
                return this.addPubMedPubDate();
            }
            if (name.equals("publicationState")) {
                this.publicationState = new CodeableConcept();
                return this.publicationState;
            }
            if (name.equals("relatedArticle")) {
                return this.addRelatedArticle();
            }
            return super.addChild(name);
        }

        @Override
        public CitationMedlinePubMedComponent copy() {
            CitationMedlinePubMedComponent dst = new CitationMedlinePubMedComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationMedlinePubMedComponent dst) {
            super.copyValues(dst);
            dst.medlineState = this.medlineState == null ? null : this.medlineState.copy();
            dst.owner = this.owner == null ? null : this.owner.copy();
            dst.pmid = this.pmid == null ? null : this.pmid.copy();
            dst.pmidVersion = this.pmidVersion == null ? null : this.pmidVersion.copy();
            dst.dateCreated = this.dateCreated == null ? null : this.dateCreated.copy();
            dst.dateCompleted = this.dateCompleted == null ? null : this.dateCompleted.copy();
            DateType dateType = dst.dateRevised = this.dateRevised == null ? null : this.dateRevised.copy();
            if (this.pubMedPubDate != null) {
                dst.pubMedPubDate = new ArrayList<CitationMedlinePubMedPubMedPubDateComponent>();
                for (CitationMedlinePubMedPubMedPubDateComponent citationMedlinePubMedPubMedPubDateComponent : this.pubMedPubDate) {
                    dst.pubMedPubDate.add(citationMedlinePubMedPubMedPubDateComponent.copy());
                }
            }
            CodeableConcept codeableConcept = dst.publicationState = this.publicationState == null ? null : this.publicationState.copy();
            if (this.relatedArticle != null) {
                dst.relatedArticle = new ArrayList<CitationMedlinePubMedRelatedArticleComponent>();
                for (CitationMedlinePubMedRelatedArticleComponent citationMedlinePubMedRelatedArticleComponent : this.relatedArticle) {
                    dst.relatedArticle.add(citationMedlinePubMedRelatedArticleComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationMedlinePubMedComponent)) {
                return false;
            }
            CitationMedlinePubMedComponent o = (CitationMedlinePubMedComponent)other_;
            return CitationMedlinePubMedComponent.compareDeep(this.medlineState, o.medlineState, true) && CitationMedlinePubMedComponent.compareDeep(this.owner, o.owner, true) && CitationMedlinePubMedComponent.compareDeep(this.pmid, o.pmid, true) && CitationMedlinePubMedComponent.compareDeep(this.pmidVersion, o.pmidVersion, true) && CitationMedlinePubMedComponent.compareDeep(this.dateCreated, o.dateCreated, true) && CitationMedlinePubMedComponent.compareDeep(this.dateCompleted, o.dateCompleted, true) && CitationMedlinePubMedComponent.compareDeep(this.dateRevised, o.dateRevised, true) && CitationMedlinePubMedComponent.compareDeep(this.pubMedPubDate, o.pubMedPubDate, true) && CitationMedlinePubMedComponent.compareDeep(this.publicationState, o.publicationState, true) && CitationMedlinePubMedComponent.compareDeep(this.relatedArticle, o.relatedArticle, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationMedlinePubMedComponent)) {
                return false;
            }
            CitationMedlinePubMedComponent o = (CitationMedlinePubMedComponent)other_;
            return CitationMedlinePubMedComponent.compareValues(this.pmid, o.pmid, true) && CitationMedlinePubMedComponent.compareValues(this.pmidVersion, o.pmidVersion, true) && CitationMedlinePubMedComponent.compareValues(this.dateCreated, o.dateCreated, true) && CitationMedlinePubMedComponent.compareValues(this.dateCompleted, o.dateCompleted, true) && CitationMedlinePubMedComponent.compareValues(this.dateRevised, o.dateRevised, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.medlineState, this.owner, this.pmid, this.pmidVersion, this.dateCreated, this.dateCompleted, this.dateRevised, this.pubMedPubDate, this.publicationState, this.relatedArticle);
        }

        @Override
        public String fhirType() {
            return "Citation.medlinePubMed";
        }
    }

    @Block
    public static class CitationAlternativeFormPaginationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="pageString", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for full display of pagination", formalDefinition="Used for full display of pagination.")
        protected StringType pageString;
        @Child(name="firstPage", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for isolated representation of first page", formalDefinition="Used for isolated representation of first page.")
        protected StringType firstPage;
        @Child(name="lastPage", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for isolated representation of last page", formalDefinition="Used for isolated representation of last page.")
        protected StringType lastPage;
        private static final long serialVersionUID = -690699049L;

        public StringType getPageStringElement() {
            if (this.pageString == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormPaginationComponent.pageString");
                }
                if (Configuration.doAutoCreate()) {
                    this.pageString = new StringType();
                }
            }
            return this.pageString;
        }

        public boolean hasPageStringElement() {
            return this.pageString != null && !this.pageString.isEmpty();
        }

        public boolean hasPageString() {
            return this.pageString != null && !this.pageString.isEmpty();
        }

        public CitationAlternativeFormPaginationComponent setPageStringElement(StringType value) {
            this.pageString = value;
            return this;
        }

        public String getPageString() {
            return this.pageString == null ? null : (String)this.pageString.getValue();
        }

        public CitationAlternativeFormPaginationComponent setPageString(String value) {
            if (Utilities.noString(value)) {
                this.pageString = null;
            } else {
                if (this.pageString == null) {
                    this.pageString = new StringType();
                }
                this.pageString.setValue(value);
            }
            return this;
        }

        public StringType getFirstPageElement() {
            if (this.firstPage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormPaginationComponent.firstPage");
                }
                if (Configuration.doAutoCreate()) {
                    this.firstPage = new StringType();
                }
            }
            return this.firstPage;
        }

        public boolean hasFirstPageElement() {
            return this.firstPage != null && !this.firstPage.isEmpty();
        }

        public boolean hasFirstPage() {
            return this.firstPage != null && !this.firstPage.isEmpty();
        }

        public CitationAlternativeFormPaginationComponent setFirstPageElement(StringType value) {
            this.firstPage = value;
            return this;
        }

        public String getFirstPage() {
            return this.firstPage == null ? null : (String)this.firstPage.getValue();
        }

        public CitationAlternativeFormPaginationComponent setFirstPage(String value) {
            if (Utilities.noString(value)) {
                this.firstPage = null;
            } else {
                if (this.firstPage == null) {
                    this.firstPage = new StringType();
                }
                this.firstPage.setValue(value);
            }
            return this;
        }

        public StringType getLastPageElement() {
            if (this.lastPage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormPaginationComponent.lastPage");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastPage = new StringType();
                }
            }
            return this.lastPage;
        }

        public boolean hasLastPageElement() {
            return this.lastPage != null && !this.lastPage.isEmpty();
        }

        public boolean hasLastPage() {
            return this.lastPage != null && !this.lastPage.isEmpty();
        }

        public CitationAlternativeFormPaginationComponent setLastPageElement(StringType value) {
            this.lastPage = value;
            return this;
        }

        public String getLastPage() {
            return this.lastPage == null ? null : (String)this.lastPage.getValue();
        }

        public CitationAlternativeFormPaginationComponent setLastPage(String value) {
            if (Utilities.noString(value)) {
                this.lastPage = null;
            } else {
                if (this.lastPage == null) {
                    this.lastPage = new StringType();
                }
                this.lastPage.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("pageString", "string", "Used for full display of pagination.", 0, 1, this.pageString));
            children.add(new Property("firstPage", "string", "Used for isolated representation of first page.", 0, 1, this.firstPage));
            children.add(new Property("lastPage", "string", "Used for isolated representation of last page.", 0, 1, this.lastPage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1287145344: {
                    return new Property("pageString", "string", "Used for full display of pagination.", 0, 1, this.pageString);
                }
                case 132895071: {
                    return new Property("firstPage", "string", "Used for isolated representation of first page.", 0, 1, this.firstPage);
                }
                case -1459540411: {
                    return new Property("lastPage", "string", "Used for isolated representation of last page.", 0, 1, this.lastPage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1287145344: {
                    Base[] baseArray;
                    if (this.pageString == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.pageString;
                    }
                    return baseArray;
                }
                case 132895071: {
                    Base[] baseArray;
                    if (this.firstPage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.firstPage;
                    }
                    return baseArray;
                }
                case -1459540411: {
                    Base[] baseArray;
                    if (this.lastPage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.lastPage;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1287145344: {
                    this.pageString = TypeConvertor.castToString(value);
                    return value;
                }
                case 132895071: {
                    this.firstPage = TypeConvertor.castToString(value);
                    return value;
                }
                case -1459540411: {
                    this.lastPage = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("pageString")) {
                this.pageString = TypeConvertor.castToString(value);
            } else if (name.equals("firstPage")) {
                this.firstPage = TypeConvertor.castToString(value);
            } else if (name.equals("lastPage")) {
                this.lastPage = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1287145344: {
                    return this.getPageStringElement();
                }
                case 132895071: {
                    return this.getFirstPageElement();
                }
                case -1459540411: {
                    return this.getLastPageElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1287145344: {
                    return new String[]{"string"};
                }
                case 132895071: {
                    return new String[]{"string"};
                }
                case -1459540411: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("pageString")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.alternativeForm.pagination.pageString");
            }
            if (name.equals("firstPage")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.alternativeForm.pagination.firstPage");
            }
            if (name.equals("lastPage")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.alternativeForm.pagination.lastPage");
            }
            return super.addChild(name);
        }

        @Override
        public CitationAlternativeFormPaginationComponent copy() {
            CitationAlternativeFormPaginationComponent dst = new CitationAlternativeFormPaginationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationAlternativeFormPaginationComponent dst) {
            super.copyValues(dst);
            dst.pageString = this.pageString == null ? null : this.pageString.copy();
            dst.firstPage = this.firstPage == null ? null : this.firstPage.copy();
            dst.lastPage = this.lastPage == null ? null : this.lastPage.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeFormPaginationComponent)) {
                return false;
            }
            CitationAlternativeFormPaginationComponent o = (CitationAlternativeFormPaginationComponent)other_;
            return CitationAlternativeFormPaginationComponent.compareDeep(this.pageString, o.pageString, true) && CitationAlternativeFormPaginationComponent.compareDeep(this.firstPage, o.firstPage, true) && CitationAlternativeFormPaginationComponent.compareDeep(this.lastPage, o.lastPage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeFormPaginationComponent)) {
                return false;
            }
            CitationAlternativeFormPaginationComponent o = (CitationAlternativeFormPaginationComponent)other_;
            return CitationAlternativeFormPaginationComponent.compareValues(this.pageString, o.pageString, true) && CitationAlternativeFormPaginationComponent.compareValues(this.firstPage, o.firstPage, true) && CitationAlternativeFormPaginationComponent.compareValues(this.lastPage, o.lastPage, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.pageString, this.firstPage, this.lastPage);
        }

        @Override
        public String fhirType() {
            return "Citation.alternativeForm.pagination";
        }
    }

    @Block
    public static class CitationAlternativeFormJournalIssueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="citedMedium", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="NLM codes Internet or Print", formalDefinition="NLM codes Internet or Print.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/journal-issue-medium")
        protected CodeableConcept citedMedium;
        @Child(name="volume", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Volume number of journal in which the article is published", formalDefinition="Volume number of journal in which the article is published.")
        protected StringType volume;
        @Child(name="issue", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Issue, part or supplement of journal in which the article is published", formalDefinition="Issue, part or supplement of journal in which the article is published.")
        protected StringType issue;
        @Child(name="publicationDate", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date on which the issue of the journal was published", formalDefinition="Date on which the issue of the journal was published.")
        protected StringType publicationDate;
        private static final long serialVersionUID = -1343937439L;

        public CodeableConcept getCitedMedium() {
            if (this.citedMedium == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormJournalIssueComponent.citedMedium");
                }
                if (Configuration.doAutoCreate()) {
                    this.citedMedium = new CodeableConcept();
                }
            }
            return this.citedMedium;
        }

        public boolean hasCitedMedium() {
            return this.citedMedium != null && !this.citedMedium.isEmpty();
        }

        public CitationAlternativeFormJournalIssueComponent setCitedMedium(CodeableConcept value) {
            this.citedMedium = value;
            return this;
        }

        public StringType getVolumeElement() {
            if (this.volume == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormJournalIssueComponent.volume");
                }
                if (Configuration.doAutoCreate()) {
                    this.volume = new StringType();
                }
            }
            return this.volume;
        }

        public boolean hasVolumeElement() {
            return this.volume != null && !this.volume.isEmpty();
        }

        public boolean hasVolume() {
            return this.volume != null && !this.volume.isEmpty();
        }

        public CitationAlternativeFormJournalIssueComponent setVolumeElement(StringType value) {
            this.volume = value;
            return this;
        }

        public String getVolume() {
            return this.volume == null ? null : (String)this.volume.getValue();
        }

        public CitationAlternativeFormJournalIssueComponent setVolume(String value) {
            if (Utilities.noString(value)) {
                this.volume = null;
            } else {
                if (this.volume == null) {
                    this.volume = new StringType();
                }
                this.volume.setValue(value);
            }
            return this;
        }

        public StringType getIssueElement() {
            if (this.issue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormJournalIssueComponent.issue");
                }
                if (Configuration.doAutoCreate()) {
                    this.issue = new StringType();
                }
            }
            return this.issue;
        }

        public boolean hasIssueElement() {
            return this.issue != null && !this.issue.isEmpty();
        }

        public boolean hasIssue() {
            return this.issue != null && !this.issue.isEmpty();
        }

        public CitationAlternativeFormJournalIssueComponent setIssueElement(StringType value) {
            this.issue = value;
            return this;
        }

        public String getIssue() {
            return this.issue == null ? null : (String)this.issue.getValue();
        }

        public CitationAlternativeFormJournalIssueComponent setIssue(String value) {
            if (Utilities.noString(value)) {
                this.issue = null;
            } else {
                if (this.issue == null) {
                    this.issue = new StringType();
                }
                this.issue.setValue(value);
            }
            return this;
        }

        public StringType getPublicationDateElement() {
            if (this.publicationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormJournalIssueComponent.publicationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.publicationDate = new StringType();
                }
            }
            return this.publicationDate;
        }

        public boolean hasPublicationDateElement() {
            return this.publicationDate != null && !this.publicationDate.isEmpty();
        }

        public boolean hasPublicationDate() {
            return this.publicationDate != null && !this.publicationDate.isEmpty();
        }

        public CitationAlternativeFormJournalIssueComponent setPublicationDateElement(StringType value) {
            this.publicationDate = value;
            return this;
        }

        public String getPublicationDate() {
            return this.publicationDate == null ? null : (String)this.publicationDate.getValue();
        }

        public CitationAlternativeFormJournalIssueComponent setPublicationDate(String value) {
            if (Utilities.noString(value)) {
                this.publicationDate = null;
            } else {
                if (this.publicationDate == null) {
                    this.publicationDate = new StringType();
                }
                this.publicationDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("citedMedium", "CodeableConcept", "NLM codes Internet or Print.", 0, 1, this.citedMedium));
            children.add(new Property("volume", "string", "Volume number of journal in which the article is published.", 0, 1, this.volume));
            children.add(new Property("issue", "string", "Issue, part or supplement of journal in which the article is published.", 0, 1, this.issue));
            children.add(new Property("publicationDate", "string", "Date on which the issue of the journal was published.", 0, 1, this.publicationDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 612116418: {
                    return new Property("citedMedium", "CodeableConcept", "NLM codes Internet or Print.", 0, 1, this.citedMedium);
                }
                case -810883302: {
                    return new Property("volume", "string", "Volume number of journal in which the article is published.", 0, 1, this.volume);
                }
                case 100509913: {
                    return new Property("issue", "string", "Issue, part or supplement of journal in which the article is published.", 0, 1, this.issue);
                }
                case 1470566394: {
                    return new Property("publicationDate", "string", "Date on which the issue of the journal was published.", 0, 1, this.publicationDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    Base[] baseArray;
                    if (this.citedMedium == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.citedMedium;
                    }
                    return baseArray;
                }
                case -810883302: {
                    Base[] baseArray;
                    if (this.volume == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.volume;
                    }
                    return baseArray;
                }
                case 100509913: {
                    Base[] baseArray;
                    if (this.issue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.issue;
                    }
                    return baseArray;
                }
                case 1470566394: {
                    Base[] baseArray;
                    if (this.publicationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.publicationDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    this.citedMedium = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -810883302: {
                    this.volume = TypeConvertor.castToString(value);
                    return value;
                }
                case 100509913: {
                    this.issue = TypeConvertor.castToString(value);
                    return value;
                }
                case 1470566394: {
                    this.publicationDate = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("citedMedium")) {
                this.citedMedium = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("volume")) {
                this.volume = TypeConvertor.castToString(value);
            } else if (name.equals("issue")) {
                this.issue = TypeConvertor.castToString(value);
            } else if (name.equals("publicationDate")) {
                this.publicationDate = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    return this.getCitedMedium();
                }
                case -810883302: {
                    return this.getVolumeElement();
                }
                case 100509913: {
                    return this.getIssueElement();
                }
                case 1470566394: {
                    return this.getPublicationDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    return new String[]{"CodeableConcept"};
                }
                case -810883302: {
                    return new String[]{"string"};
                }
                case 100509913: {
                    return new String[]{"string"};
                }
                case 1470566394: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("citedMedium")) {
                this.citedMedium = new CodeableConcept();
                return this.citedMedium;
            }
            if (name.equals("volume")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.alternativeForm.journalIssue.volume");
            }
            if (name.equals("issue")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.alternativeForm.journalIssue.issue");
            }
            if (name.equals("publicationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.alternativeForm.journalIssue.publicationDate");
            }
            return super.addChild(name);
        }

        @Override
        public CitationAlternativeFormJournalIssueComponent copy() {
            CitationAlternativeFormJournalIssueComponent dst = new CitationAlternativeFormJournalIssueComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationAlternativeFormJournalIssueComponent dst) {
            super.copyValues(dst);
            dst.citedMedium = this.citedMedium == null ? null : this.citedMedium.copy();
            dst.volume = this.volume == null ? null : this.volume.copy();
            dst.issue = this.issue == null ? null : this.issue.copy();
            dst.publicationDate = this.publicationDate == null ? null : this.publicationDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeFormJournalIssueComponent)) {
                return false;
            }
            CitationAlternativeFormJournalIssueComponent o = (CitationAlternativeFormJournalIssueComponent)other_;
            return CitationAlternativeFormJournalIssueComponent.compareDeep(this.citedMedium, o.citedMedium, true) && CitationAlternativeFormJournalIssueComponent.compareDeep(this.volume, o.volume, true) && CitationAlternativeFormJournalIssueComponent.compareDeep(this.issue, o.issue, true) && CitationAlternativeFormJournalIssueComponent.compareDeep(this.publicationDate, o.publicationDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeFormJournalIssueComponent)) {
                return false;
            }
            CitationAlternativeFormJournalIssueComponent o = (CitationAlternativeFormJournalIssueComponent)other_;
            return CitationAlternativeFormJournalIssueComponent.compareValues(this.volume, o.volume, true) && CitationAlternativeFormJournalIssueComponent.compareValues(this.issue, o.issue, true) && CitationAlternativeFormJournalIssueComponent.compareValues(this.publicationDate, o.publicationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.citedMedium, this.volume, this.issue, this.publicationDate);
        }

        @Override
        public String fhirType() {
            return "Citation.alternativeForm.journalIssue";
        }
    }

    @Block
    public static class CitationAlternativeFormComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="publishingModel", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identify the medium/media in which the cited article is published, eg print, electronic or print-electronic", formalDefinition="Identify the medium/media in which the cited article is published, eg print, electronic or print-electronic.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/publishing-model-type")
        protected CodeableConcept publishingModel;
        @Child(name="language", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language in which the article is published", formalDefinition="Language in which the article is published.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        @Child(name="journalIssue", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific issue in which the cited article resides", formalDefinition="The specific issue in which the cited article resides.")
        protected CitationAlternativeFormJournalIssueComponent journalIssue;
        @Child(name="pagination", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates the inclusive pages for the article cited", formalDefinition="Indicates the inclusive pages for the article cited.")
        protected CitationAlternativeFormPaginationComponent pagination;
        private static final long serialVersionUID = -991805122L;

        public CodeableConcept getPublishingModel() {
            if (this.publishingModel == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormComponent.publishingModel");
                }
                if (Configuration.doAutoCreate()) {
                    this.publishingModel = new CodeableConcept();
                }
            }
            return this.publishingModel;
        }

        public boolean hasPublishingModel() {
            return this.publishingModel != null && !this.publishingModel.isEmpty();
        }

        public CitationAlternativeFormComponent setPublishingModel(CodeableConcept value) {
            this.publishingModel = value;
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public CitationAlternativeFormComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public CitationAlternativeFormJournalIssueComponent getJournalIssue() {
            if (this.journalIssue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormComponent.journalIssue");
                }
                if (Configuration.doAutoCreate()) {
                    this.journalIssue = new CitationAlternativeFormJournalIssueComponent();
                }
            }
            return this.journalIssue;
        }

        public boolean hasJournalIssue() {
            return this.journalIssue != null && !this.journalIssue.isEmpty();
        }

        public CitationAlternativeFormComponent setJournalIssue(CitationAlternativeFormJournalIssueComponent value) {
            this.journalIssue = value;
            return this;
        }

        public CitationAlternativeFormPaginationComponent getPagination() {
            if (this.pagination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeFormComponent.pagination");
                }
                if (Configuration.doAutoCreate()) {
                    this.pagination = new CitationAlternativeFormPaginationComponent();
                }
            }
            return this.pagination;
        }

        public boolean hasPagination() {
            return this.pagination != null && !this.pagination.isEmpty();
        }

        public CitationAlternativeFormComponent setPagination(CitationAlternativeFormPaginationComponent value) {
            this.pagination = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("publishingModel", "CodeableConcept", "Identify the medium/media in which the cited article is published, eg print, electronic or print-electronic.", 0, 1, this.publishingModel));
            children.add(new Property("language", "CodeableConcept", "Language in which the article is published.", 0, 1, this.language));
            children.add(new Property("journalIssue", "", "The specific issue in which the cited article resides.", 0, 1, this.journalIssue));
            children.add(new Property("pagination", "", "Indicates the inclusive pages for the article cited.", 0, 1, this.pagination));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 747318902: {
                    return new Property("publishingModel", "CodeableConcept", "Identify the medium/media in which the cited article is published, eg print, electronic or print-electronic.", 0, 1, this.publishingModel);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Language in which the article is published.", 0, 1, this.language);
                }
                case -716835870: {
                    return new Property("journalIssue", "", "The specific issue in which the cited article resides.", 0, 1, this.journalIssue);
                }
                case 1297692570: {
                    return new Property("pagination", "", "Indicates the inclusive pages for the article cited.", 0, 1, this.pagination);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 747318902: {
                    Base[] baseArray;
                    if (this.publishingModel == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.publishingModel;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case -716835870: {
                    Base[] baseArray;
                    if (this.journalIssue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.journalIssue;
                    }
                    return baseArray;
                }
                case 1297692570: {
                    Base[] baseArray;
                    if (this.pagination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.pagination;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 747318902: {
                    this.publishingModel = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -716835870: {
                    this.journalIssue = (CitationAlternativeFormJournalIssueComponent)value;
                    return value;
                }
                case 1297692570: {
                    this.pagination = (CitationAlternativeFormPaginationComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("publishingModel")) {
                this.publishingModel = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("journalIssue")) {
                this.journalIssue = (CitationAlternativeFormJournalIssueComponent)value;
            } else if (name.equals("pagination")) {
                this.pagination = (CitationAlternativeFormPaginationComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 747318902: {
                    return this.getPublishingModel();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
                case -716835870: {
                    return this.getJournalIssue();
                }
                case 1297692570: {
                    return this.getPagination();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 747318902: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case -716835870: {
                    return new String[0];
                }
                case 1297692570: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("publishingModel")) {
                this.publishingModel = new CodeableConcept();
                return this.publishingModel;
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("journalIssue")) {
                this.journalIssue = new CitationAlternativeFormJournalIssueComponent();
                return this.journalIssue;
            }
            if (name.equals("pagination")) {
                this.pagination = new CitationAlternativeFormPaginationComponent();
                return this.pagination;
            }
            return super.addChild(name);
        }

        @Override
        public CitationAlternativeFormComponent copy() {
            CitationAlternativeFormComponent dst = new CitationAlternativeFormComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationAlternativeFormComponent dst) {
            super.copyValues(dst);
            dst.publishingModel = this.publishingModel == null ? null : this.publishingModel.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.journalIssue = this.journalIssue == null ? null : this.journalIssue.copy();
            dst.pagination = this.pagination == null ? null : this.pagination.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeFormComponent)) {
                return false;
            }
            CitationAlternativeFormComponent o = (CitationAlternativeFormComponent)other_;
            return CitationAlternativeFormComponent.compareDeep(this.publishingModel, o.publishingModel, true) && CitationAlternativeFormComponent.compareDeep(this.language, o.language, true) && CitationAlternativeFormComponent.compareDeep(this.journalIssue, o.journalIssue, true) && CitationAlternativeFormComponent.compareDeep(this.pagination, o.pagination, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeFormComponent)) {
                return false;
            }
            CitationAlternativeFormComponent o = (CitationAlternativeFormComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.publishingModel, this.language, this.journalIssue, this.pagination);
        }

        @Override
        public String fhirType() {
            return "Citation.alternativeForm";
        }
    }

    @Block
    public static class CitationContributorListContributorAffiliationInfoComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="affiliation", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the organization", formalDefinition="Display for the organization.")
        protected StringType affiliation;
        @Child(name="role", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Role", formalDefinition="Role.")
        protected StringType role;
        @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier for the organization", formalDefinition="Identifier for the organization.")
        protected List<Identifier> identifier;
        private static final long serialVersionUID = 548335522L;

        public StringType getAffiliationElement() {
            if (this.affiliation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationContributorListContributorAffiliationInfoComponent.affiliation");
                }
                if (Configuration.doAutoCreate()) {
                    this.affiliation = new StringType();
                }
            }
            return this.affiliation;
        }

        public boolean hasAffiliationElement() {
            return this.affiliation != null && !this.affiliation.isEmpty();
        }

        public boolean hasAffiliation() {
            return this.affiliation != null && !this.affiliation.isEmpty();
        }

        public CitationContributorListContributorAffiliationInfoComponent setAffiliationElement(StringType value) {
            this.affiliation = value;
            return this;
        }

        public String getAffiliation() {
            return this.affiliation == null ? null : (String)this.affiliation.getValue();
        }

        public CitationContributorListContributorAffiliationInfoComponent setAffiliation(String value) {
            if (Utilities.noString(value)) {
                this.affiliation = null;
            } else {
                if (this.affiliation == null) {
                    this.affiliation = new StringType();
                }
                this.affiliation.setValue(value);
            }
            return this;
        }

        public StringType getRoleElement() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationContributorListContributorAffiliationInfoComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new StringType();
                }
            }
            return this.role;
        }

        public boolean hasRoleElement() {
            return this.role != null && !this.role.isEmpty();
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CitationContributorListContributorAffiliationInfoComponent setRoleElement(StringType value) {
            this.role = value;
            return this;
        }

        public String getRole() {
            return this.role == null ? null : (String)this.role.getValue();
        }

        public CitationContributorListContributorAffiliationInfoComponent setRole(String value) {
            if (Utilities.noString(value)) {
                this.role = null;
            } else {
                if (this.role == null) {
                    this.role = new StringType();
                }
                this.role.setValue(value);
            }
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationContributorListContributorAffiliationInfoComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationContributorListContributorAffiliationInfoComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("affiliation", "string", "Display for the organization.", 0, 1, this.affiliation));
            children.add(new Property("role", "string", "Role.", 0, 1, this.role));
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Identifier for the organization.", 0, Integer.MAX_VALUE, this.identifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2019918576: {
                    return new Property("affiliation", "string", "Display for the organization.", 0, 1, this.affiliation);
                }
                case 3506294: {
                    return new Property("role", "string", "Role.", 0, 1, this.role);
                }
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Identifier for the organization.", 0, Integer.MAX_VALUE, this.identifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    Base[] baseArray;
                    if (this.affiliation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.affiliation;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    this.affiliation = TypeConvertor.castToString(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToString(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("affiliation")) {
                this.affiliation = TypeConvertor.castToString(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToString(value);
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    return this.getAffiliationElement();
                }
                case 3506294: {
                    return this.getRoleElement();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    return new String[]{"string"};
                }
                case 3506294: {
                    return new String[]{"string"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("affiliation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.contributorList.contributor.affiliationInfo.affiliation");
            }
            if (name.equals("role")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.contributorList.contributor.affiliationInfo.role");
            }
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            return super.addChild(name);
        }

        @Override
        public CitationContributorListContributorAffiliationInfoComponent copy() {
            CitationContributorListContributorAffiliationInfoComponent dst = new CitationContributorListContributorAffiliationInfoComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationContributorListContributorAffiliationInfoComponent dst) {
            super.copyValues(dst);
            dst.affiliation = this.affiliation == null ? null : this.affiliation.copy();
            StringType stringType = dst.role = this.role == null ? null : this.role.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationContributorListContributorAffiliationInfoComponent)) {
                return false;
            }
            CitationContributorListContributorAffiliationInfoComponent o = (CitationContributorListContributorAffiliationInfoComponent)other_;
            return CitationContributorListContributorAffiliationInfoComponent.compareDeep(this.affiliation, o.affiliation, true) && CitationContributorListContributorAffiliationInfoComponent.compareDeep(this.role, o.role, true) && CitationContributorListContributorAffiliationInfoComponent.compareDeep(this.identifier, o.identifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationContributorListContributorAffiliationInfoComponent)) {
                return false;
            }
            CitationContributorListContributorAffiliationInfoComponent o = (CitationContributorListContributorAffiliationInfoComponent)other_;
            return CitationContributorListContributorAffiliationInfoComponent.compareValues(this.affiliation, o.affiliation, true) && CitationContributorListContributorAffiliationInfoComponent.compareValues(this.role, o.role, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.affiliation, this.role, this.identifier);
        }

        @Override
        public String fhirType() {
            return "Citation.contributorList.contributor.affiliationInfo";
        }
    }

    @Block
    public static class CitationContributorListContributorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="lastName", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Surname or single name", formalDefinition="Surname or single name.")
        protected StringType lastName;
        @Child(name="foreName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Remainder of name except for suffix", formalDefinition="Remainder of name except for suffix.")
        protected StringType foreName;
        @Child(name="suffix", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Eg 2nd, 3rd, Jr, Sr", formalDefinition="Eg 2nd, 3rd, Jr, Sr.")
        protected StringType suffix;
        @Child(name="initials", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Initials for forename", formalDefinition="Initials for forename.")
        protected StringType initials;
        @Child(name="collectiveName", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for collective or corporate name as a contributor", formalDefinition="Used for collective or corporate name as a contributor.")
        protected StringType collectiveName;
        @Child(name="identifier", type={Identifier.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contributor identifier, eg ORCID", formalDefinition="Contributor identifier, eg ORCID.")
        protected List<Identifier> identifier;
        @Child(name="contribution", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specific contributions", formalDefinition="The specific contributions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-contribution")
        protected List<CodeableConcept> contribution;
        @Child(name="affiliationInfo", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Organizational affiliation", formalDefinition="Organizational affiliation.")
        protected List<CitationContributorListContributorAffiliationInfoComponent> affiliationInfo;
        @Child(name="listOrder", type={PositiveIntType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to code order of contributors", formalDefinition="Used to code order of contributors.")
        protected PositiveIntType listOrder;
        private static final long serialVersionUID = 160410057L;

        public StringType getLastNameElement() {
            if (this.lastName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationContributorListContributorComponent.lastName");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastName = new StringType();
                }
            }
            return this.lastName;
        }

        public boolean hasLastNameElement() {
            return this.lastName != null && !this.lastName.isEmpty();
        }

        public boolean hasLastName() {
            return this.lastName != null && !this.lastName.isEmpty();
        }

        public CitationContributorListContributorComponent setLastNameElement(StringType value) {
            this.lastName = value;
            return this;
        }

        public String getLastName() {
            return this.lastName == null ? null : (String)this.lastName.getValue();
        }

        public CitationContributorListContributorComponent setLastName(String value) {
            if (Utilities.noString(value)) {
                this.lastName = null;
            } else {
                if (this.lastName == null) {
                    this.lastName = new StringType();
                }
                this.lastName.setValue(value);
            }
            return this;
        }

        public StringType getForeNameElement() {
            if (this.foreName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationContributorListContributorComponent.foreName");
                }
                if (Configuration.doAutoCreate()) {
                    this.foreName = new StringType();
                }
            }
            return this.foreName;
        }

        public boolean hasForeNameElement() {
            return this.foreName != null && !this.foreName.isEmpty();
        }

        public boolean hasForeName() {
            return this.foreName != null && !this.foreName.isEmpty();
        }

        public CitationContributorListContributorComponent setForeNameElement(StringType value) {
            this.foreName = value;
            return this;
        }

        public String getForeName() {
            return this.foreName == null ? null : (String)this.foreName.getValue();
        }

        public CitationContributorListContributorComponent setForeName(String value) {
            if (Utilities.noString(value)) {
                this.foreName = null;
            } else {
                if (this.foreName == null) {
                    this.foreName = new StringType();
                }
                this.foreName.setValue(value);
            }
            return this;
        }

        public StringType getSuffixElement() {
            if (this.suffix == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationContributorListContributorComponent.suffix");
                }
                if (Configuration.doAutoCreate()) {
                    this.suffix = new StringType();
                }
            }
            return this.suffix;
        }

        public boolean hasSuffixElement() {
            return this.suffix != null && !this.suffix.isEmpty();
        }

        public boolean hasSuffix() {
            return this.suffix != null && !this.suffix.isEmpty();
        }

        public CitationContributorListContributorComponent setSuffixElement(StringType value) {
            this.suffix = value;
            return this;
        }

        public String getSuffix() {
            return this.suffix == null ? null : (String)this.suffix.getValue();
        }

        public CitationContributorListContributorComponent setSuffix(String value) {
            if (Utilities.noString(value)) {
                this.suffix = null;
            } else {
                if (this.suffix == null) {
                    this.suffix = new StringType();
                }
                this.suffix.setValue(value);
            }
            return this;
        }

        public StringType getInitialsElement() {
            if (this.initials == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationContributorListContributorComponent.initials");
                }
                if (Configuration.doAutoCreate()) {
                    this.initials = new StringType();
                }
            }
            return this.initials;
        }

        public boolean hasInitialsElement() {
            return this.initials != null && !this.initials.isEmpty();
        }

        public boolean hasInitials() {
            return this.initials != null && !this.initials.isEmpty();
        }

        public CitationContributorListContributorComponent setInitialsElement(StringType value) {
            this.initials = value;
            return this;
        }

        public String getInitials() {
            return this.initials == null ? null : (String)this.initials.getValue();
        }

        public CitationContributorListContributorComponent setInitials(String value) {
            if (Utilities.noString(value)) {
                this.initials = null;
            } else {
                if (this.initials == null) {
                    this.initials = new StringType();
                }
                this.initials.setValue(value);
            }
            return this;
        }

        public StringType getCollectiveNameElement() {
            if (this.collectiveName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationContributorListContributorComponent.collectiveName");
                }
                if (Configuration.doAutoCreate()) {
                    this.collectiveName = new StringType();
                }
            }
            return this.collectiveName;
        }

        public boolean hasCollectiveNameElement() {
            return this.collectiveName != null && !this.collectiveName.isEmpty();
        }

        public boolean hasCollectiveName() {
            return this.collectiveName != null && !this.collectiveName.isEmpty();
        }

        public CitationContributorListContributorComponent setCollectiveNameElement(StringType value) {
            this.collectiveName = value;
            return this;
        }

        public String getCollectiveName() {
            return this.collectiveName == null ? null : (String)this.collectiveName.getValue();
        }

        public CitationContributorListContributorComponent setCollectiveName(String value) {
            if (Utilities.noString(value)) {
                this.collectiveName = null;
            } else {
                if (this.collectiveName == null) {
                    this.collectiveName = new StringType();
                }
                this.collectiveName.setValue(value);
            }
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationContributorListContributorComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationContributorListContributorComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public List<CodeableConcept> getContribution() {
            if (this.contribution == null) {
                this.contribution = new ArrayList<CodeableConcept>();
            }
            return this.contribution;
        }

        public CitationContributorListContributorComponent setContribution(List<CodeableConcept> theContribution) {
            this.contribution = theContribution;
            return this;
        }

        public boolean hasContribution() {
            if (this.contribution == null) {
                return false;
            }
            for (CodeableConcept item : this.contribution) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addContribution() {
            CodeableConcept t = new CodeableConcept();
            if (this.contribution == null) {
                this.contribution = new ArrayList<CodeableConcept>();
            }
            this.contribution.add(t);
            return t;
        }

        public CitationContributorListContributorComponent addContribution(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.contribution == null) {
                this.contribution = new ArrayList<CodeableConcept>();
            }
            this.contribution.add(t);
            return this;
        }

        public CodeableConcept getContributionFirstRep() {
            if (this.getContribution().isEmpty()) {
                this.addContribution();
            }
            return this.getContribution().get(0);
        }

        public List<CitationContributorListContributorAffiliationInfoComponent> getAffiliationInfo() {
            if (this.affiliationInfo == null) {
                this.affiliationInfo = new ArrayList<CitationContributorListContributorAffiliationInfoComponent>();
            }
            return this.affiliationInfo;
        }

        public CitationContributorListContributorComponent setAffiliationInfo(List<CitationContributorListContributorAffiliationInfoComponent> theAffiliationInfo) {
            this.affiliationInfo = theAffiliationInfo;
            return this;
        }

        public boolean hasAffiliationInfo() {
            if (this.affiliationInfo == null) {
                return false;
            }
            for (CitationContributorListContributorAffiliationInfoComponent item : this.affiliationInfo) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationContributorListContributorAffiliationInfoComponent addAffiliationInfo() {
            CitationContributorListContributorAffiliationInfoComponent t = new CitationContributorListContributorAffiliationInfoComponent();
            if (this.affiliationInfo == null) {
                this.affiliationInfo = new ArrayList<CitationContributorListContributorAffiliationInfoComponent>();
            }
            this.affiliationInfo.add(t);
            return t;
        }

        public CitationContributorListContributorComponent addAffiliationInfo(CitationContributorListContributorAffiliationInfoComponent t) {
            if (t == null) {
                return this;
            }
            if (this.affiliationInfo == null) {
                this.affiliationInfo = new ArrayList<CitationContributorListContributorAffiliationInfoComponent>();
            }
            this.affiliationInfo.add(t);
            return this;
        }

        public CitationContributorListContributorAffiliationInfoComponent getAffiliationInfoFirstRep() {
            if (this.getAffiliationInfo().isEmpty()) {
                this.addAffiliationInfo();
            }
            return this.getAffiliationInfo().get(0);
        }

        public PositiveIntType getListOrderElement() {
            if (this.listOrder == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationContributorListContributorComponent.listOrder");
                }
                if (Configuration.doAutoCreate()) {
                    this.listOrder = new PositiveIntType();
                }
            }
            return this.listOrder;
        }

        public boolean hasListOrderElement() {
            return this.listOrder != null && !this.listOrder.isEmpty();
        }

        public boolean hasListOrder() {
            return this.listOrder != null && !this.listOrder.isEmpty();
        }

        public CitationContributorListContributorComponent setListOrderElement(PositiveIntType value) {
            this.listOrder = value;
            return this;
        }

        public int getListOrder() {
            return this.listOrder == null || this.listOrder.isEmpty() ? 0 : (Integer)this.listOrder.getValue();
        }

        public CitationContributorListContributorComponent setListOrder(int value) {
            if (this.listOrder == null) {
                this.listOrder = new PositiveIntType();
            }
            this.listOrder.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("lastName", "string", "Surname or single name.", 0, 1, this.lastName));
            children.add(new Property("foreName", "string", "Remainder of name except for suffix.", 0, 1, this.foreName));
            children.add(new Property("suffix", "string", "Eg 2nd, 3rd, Jr, Sr.", 0, 1, this.suffix));
            children.add(new Property("initials", "string", "Initials for forename.", 0, 1, this.initials));
            children.add(new Property("collectiveName", "string", "Used for collective or corporate name as a contributor.", 0, 1, this.collectiveName));
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Contributor identifier, eg ORCID.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("contribution", "CodeableConcept", "The specific contributions.", 0, Integer.MAX_VALUE, this.contribution));
            children.add(new Property("affiliationInfo", "", "Organizational affiliation.", 0, Integer.MAX_VALUE, this.affiliationInfo));
            children.add(new Property("listOrder", "positiveInt", "Used to code order of contributors.", 0, 1, this.listOrder));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1459599807: {
                    return new Property("lastName", "string", "Surname or single name.", 0, 1, this.lastName);
                }
                case 466107751: {
                    return new Property("foreName", "string", "Remainder of name except for suffix.", 0, 1, this.foreName);
                }
                case -891422895: {
                    return new Property("suffix", "string", "Eg 2nd, 3rd, Jr, Sr.", 0, 1, this.suffix);
                }
                case 269062575: {
                    return new Property("initials", "string", "Initials for forename.", 0, 1, this.initials);
                }
                case 502871833: {
                    return new Property("collectiveName", "string", "Used for collective or corporate name as a contributor.", 0, 1, this.collectiveName);
                }
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Contributor identifier, eg ORCID.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 1375970320: {
                    return new Property("contribution", "CodeableConcept", "The specific contributions.", 0, Integer.MAX_VALUE, this.contribution);
                }
                case -215129154: {
                    return new Property("affiliationInfo", "", "Organizational affiliation.", 0, Integer.MAX_VALUE, this.affiliationInfo);
                }
                case -1238918832: {
                    return new Property("listOrder", "positiveInt", "Used to code order of contributors.", 0, 1, this.listOrder);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1459599807: {
                    Base[] baseArray;
                    if (this.lastName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.lastName;
                    }
                    return baseArray;
                }
                case 466107751: {
                    Base[] baseArray;
                    if (this.foreName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.foreName;
                    }
                    return baseArray;
                }
                case -891422895: {
                    Base[] baseArray;
                    if (this.suffix == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.suffix;
                    }
                    return baseArray;
                }
                case 269062575: {
                    Base[] baseArray;
                    if (this.initials == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.initials;
                    }
                    return baseArray;
                }
                case 502871833: {
                    Base[] baseArray;
                    if (this.collectiveName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.collectiveName;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 1375970320: {
                    return this.contribution == null ? new Base[]{} : this.contribution.toArray(new Base[this.contribution.size()]);
                }
                case -215129154: {
                    return this.affiliationInfo == null ? new Base[]{} : this.affiliationInfo.toArray(new Base[this.affiliationInfo.size()]);
                }
                case -1238918832: {
                    Base[] baseArray;
                    if (this.listOrder == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.listOrder;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1459599807: {
                    this.lastName = TypeConvertor.castToString(value);
                    return value;
                }
                case 466107751: {
                    this.foreName = TypeConvertor.castToString(value);
                    return value;
                }
                case -891422895: {
                    this.suffix = TypeConvertor.castToString(value);
                    return value;
                }
                case 269062575: {
                    this.initials = TypeConvertor.castToString(value);
                    return value;
                }
                case 502871833: {
                    this.collectiveName = TypeConvertor.castToString(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 1375970320: {
                    this.getContribution().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -215129154: {
                    this.getAffiliationInfo().add((CitationContributorListContributorAffiliationInfoComponent)value);
                    return value;
                }
                case -1238918832: {
                    this.listOrder = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("lastName")) {
                this.lastName = TypeConvertor.castToString(value);
            } else if (name.equals("foreName")) {
                this.foreName = TypeConvertor.castToString(value);
            } else if (name.equals("suffix")) {
                this.suffix = TypeConvertor.castToString(value);
            } else if (name.equals("initials")) {
                this.initials = TypeConvertor.castToString(value);
            } else if (name.equals("collectiveName")) {
                this.collectiveName = TypeConvertor.castToString(value);
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("contribution")) {
                this.getContribution().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("affiliationInfo")) {
                this.getAffiliationInfo().add((CitationContributorListContributorAffiliationInfoComponent)value);
            } else if (name.equals("listOrder")) {
                this.listOrder = TypeConvertor.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1459599807: {
                    return this.getLastNameElement();
                }
                case 466107751: {
                    return this.getForeNameElement();
                }
                case -891422895: {
                    return this.getSuffixElement();
                }
                case 269062575: {
                    return this.getInitialsElement();
                }
                case 502871833: {
                    return this.getCollectiveNameElement();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 1375970320: {
                    return this.addContribution();
                }
                case -215129154: {
                    return this.addAffiliationInfo();
                }
                case -1238918832: {
                    return this.getListOrderElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1459599807: {
                    return new String[]{"string"};
                }
                case 466107751: {
                    return new String[]{"string"};
                }
                case -891422895: {
                    return new String[]{"string"};
                }
                case 269062575: {
                    return new String[]{"string"};
                }
                case 502871833: {
                    return new String[]{"string"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 1375970320: {
                    return new String[]{"CodeableConcept"};
                }
                case -215129154: {
                    return new String[0];
                }
                case -1238918832: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("lastName")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.contributorList.contributor.lastName");
            }
            if (name.equals("foreName")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.contributorList.contributor.foreName");
            }
            if (name.equals("suffix")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.contributorList.contributor.suffix");
            }
            if (name.equals("initials")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.contributorList.contributor.initials");
            }
            if (name.equals("collectiveName")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.contributorList.contributor.collectiveName");
            }
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("contribution")) {
                return this.addContribution();
            }
            if (name.equals("affiliationInfo")) {
                return this.addAffiliationInfo();
            }
            if (name.equals("listOrder")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.contributorList.contributor.listOrder");
            }
            return super.addChild(name);
        }

        @Override
        public CitationContributorListContributorComponent copy() {
            CitationContributorListContributorComponent dst = new CitationContributorListContributorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationContributorListContributorComponent dst) {
            super.copyValues(dst);
            dst.lastName = this.lastName == null ? null : this.lastName.copy();
            dst.foreName = this.foreName == null ? null : this.foreName.copy();
            dst.suffix = this.suffix == null ? null : this.suffix.copy();
            dst.initials = this.initials == null ? null : this.initials.copy();
            StringType stringType = dst.collectiveName = this.collectiveName == null ? null : this.collectiveName.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            if (this.contribution != null) {
                dst.contribution = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.contribution) {
                    dst.contribution.add(codeableConcept.copy());
                }
            }
            if (this.affiliationInfo != null) {
                dst.affiliationInfo = new ArrayList<CitationContributorListContributorAffiliationInfoComponent>();
                for (CitationContributorListContributorAffiliationInfoComponent citationContributorListContributorAffiliationInfoComponent : this.affiliationInfo) {
                    dst.affiliationInfo.add(citationContributorListContributorAffiliationInfoComponent.copy());
                }
            }
            dst.listOrder = this.listOrder == null ? null : this.listOrder.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationContributorListContributorComponent)) {
                return false;
            }
            CitationContributorListContributorComponent o = (CitationContributorListContributorComponent)other_;
            return CitationContributorListContributorComponent.compareDeep(this.lastName, o.lastName, true) && CitationContributorListContributorComponent.compareDeep(this.foreName, o.foreName, true) && CitationContributorListContributorComponent.compareDeep(this.suffix, o.suffix, true) && CitationContributorListContributorComponent.compareDeep(this.initials, o.initials, true) && CitationContributorListContributorComponent.compareDeep(this.collectiveName, o.collectiveName, true) && CitationContributorListContributorComponent.compareDeep(this.identifier, o.identifier, true) && CitationContributorListContributorComponent.compareDeep(this.contribution, o.contribution, true) && CitationContributorListContributorComponent.compareDeep(this.affiliationInfo, o.affiliationInfo, true) && CitationContributorListContributorComponent.compareDeep(this.listOrder, o.listOrder, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationContributorListContributorComponent)) {
                return false;
            }
            CitationContributorListContributorComponent o = (CitationContributorListContributorComponent)other_;
            return CitationContributorListContributorComponent.compareValues(this.lastName, o.lastName, true) && CitationContributorListContributorComponent.compareValues(this.foreName, o.foreName, true) && CitationContributorListContributorComponent.compareValues(this.suffix, o.suffix, true) && CitationContributorListContributorComponent.compareValues(this.initials, o.initials, true) && CitationContributorListContributorComponent.compareValues(this.collectiveName, o.collectiveName, true) && CitationContributorListContributorComponent.compareValues(this.listOrder, o.listOrder, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.lastName, this.foreName, this.suffix, this.initials, this.collectiveName, this.identifier, this.contribution, this.affiliationInfo, this.listOrder);
        }

        @Override
        public String fhirType() {
            return "Citation.contributorList.contributor";
        }
    }

    @Block
    public static class CitationContributorListComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="complete", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates if the list includes all contributors", formalDefinition="Indicates if the list includes all contributors.")
        protected BooleanType complete;
        @Child(name="contributor", type={}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An individual entity named in the contributor list", formalDefinition="An individual entity named in the contributor list.")
        protected List<CitationContributorListContributorComponent> contributor;
        private static final long serialVersionUID = 1922271126L;

        public CitationContributorListComponent() {
        }

        public CitationContributorListComponent(CitationContributorListContributorComponent contributor) {
            this.addContributor(contributor);
        }

        public BooleanType getCompleteElement() {
            if (this.complete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationContributorListComponent.complete");
                }
                if (Configuration.doAutoCreate()) {
                    this.complete = new BooleanType();
                }
            }
            return this.complete;
        }

        public boolean hasCompleteElement() {
            return this.complete != null && !this.complete.isEmpty();
        }

        public boolean hasComplete() {
            return this.complete != null && !this.complete.isEmpty();
        }

        public CitationContributorListComponent setCompleteElement(BooleanType value) {
            this.complete = value;
            return this;
        }

        public boolean getComplete() {
            return this.complete == null || this.complete.isEmpty() ? false : (Boolean)this.complete.getValue();
        }

        public CitationContributorListComponent setComplete(boolean value) {
            if (this.complete == null) {
                this.complete = new BooleanType();
            }
            this.complete.setValue((Object)value);
            return this;
        }

        public List<CitationContributorListContributorComponent> getContributor() {
            if (this.contributor == null) {
                this.contributor = new ArrayList<CitationContributorListContributorComponent>();
            }
            return this.contributor;
        }

        public CitationContributorListComponent setContributor(List<CitationContributorListContributorComponent> theContributor) {
            this.contributor = theContributor;
            return this;
        }

        public boolean hasContributor() {
            if (this.contributor == null) {
                return false;
            }
            for (CitationContributorListContributorComponent item : this.contributor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationContributorListContributorComponent addContributor() {
            CitationContributorListContributorComponent t = new CitationContributorListContributorComponent();
            if (this.contributor == null) {
                this.contributor = new ArrayList<CitationContributorListContributorComponent>();
            }
            this.contributor.add(t);
            return t;
        }

        public CitationContributorListComponent addContributor(CitationContributorListContributorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contributor == null) {
                this.contributor = new ArrayList<CitationContributorListContributorComponent>();
            }
            this.contributor.add(t);
            return this;
        }

        public CitationContributorListContributorComponent getContributorFirstRep() {
            if (this.getContributor().isEmpty()) {
                this.addContributor();
            }
            return this.getContributor().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("complete", "boolean", "Indicates if the list includes all contributors.", 0, 1, this.complete));
            children.add(new Property("contributor", "", "An individual entity named in the contributor list.", 0, Integer.MAX_VALUE, this.contributor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -599445191: {
                    return new Property("complete", "boolean", "Indicates if the list includes all contributors.", 0, 1, this.complete);
                }
                case -1895276325: {
                    return new Property("contributor", "", "An individual entity named in the contributor list.", 0, Integer.MAX_VALUE, this.contributor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    Base[] baseArray;
                    if (this.complete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.complete;
                    }
                    return baseArray;
                }
                case -1895276325: {
                    return this.contributor == null ? new Base[]{} : this.contributor.toArray(new Base[this.contributor.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    this.complete = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1895276325: {
                    this.getContributor().add((CitationContributorListContributorComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("complete")) {
                this.complete = TypeConvertor.castToBoolean(value);
            } else if (name.equals("contributor")) {
                this.getContributor().add((CitationContributorListContributorComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    return this.getCompleteElement();
                }
                case -1895276325: {
                    return this.addContributor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    return new String[]{"boolean"};
                }
                case -1895276325: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("complete")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.contributorList.complete");
            }
            if (name.equals("contributor")) {
                return this.addContributor();
            }
            return super.addChild(name);
        }

        @Override
        public CitationContributorListComponent copy() {
            CitationContributorListComponent dst = new CitationContributorListComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationContributorListComponent dst) {
            super.copyValues(dst);
            BooleanType booleanType = dst.complete = this.complete == null ? null : this.complete.copy();
            if (this.contributor != null) {
                dst.contributor = new ArrayList<CitationContributorListContributorComponent>();
                for (CitationContributorListContributorComponent i : this.contributor) {
                    dst.contributor.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationContributorListComponent)) {
                return false;
            }
            CitationContributorListComponent o = (CitationContributorListComponent)other_;
            return CitationContributorListComponent.compareDeep(this.complete, o.complete, true) && CitationContributorListComponent.compareDeep(this.contributor, o.contributor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationContributorListComponent)) {
                return false;
            }
            CitationContributorListComponent o = (CitationContributorListComponent)other_;
            return CitationContributorListComponent.compareValues(this.complete, o.complete, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.complete, this.contributor);
        }

        @Override
        public String fhirType() {
            return "Citation.contributorList";
        }
    }

    @Block
    public static class CitationAuthorStringComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="source", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to code the producer or rule for creating the display string", formalDefinition="Used to code the producer or rule for creating the display string.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/author-string-source")
        protected CodeableConcept source;
        @Child(name="value", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The display string for the author list", formalDefinition="The display string for the author list.")
        protected StringType value;
        private static final long serialVersionUID = -1218527170L;

        public CitationAuthorStringComponent() {
        }

        public CitationAuthorStringComponent(String value) {
            this.setValue(value);
        }

        public CodeableConcept getSource() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorStringComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new CodeableConcept();
                }
            }
            return this.source;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public CitationAuthorStringComponent setSource(CodeableConcept value) {
            this.source = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorStringComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CitationAuthorStringComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CitationAuthorStringComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("source", "CodeableConcept", "Used to code the producer or rule for creating the display string.", 0, 1, this.source));
            children.add(new Property("value", "string", "The display string for the author list.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -896505829: {
                    return new Property("source", "CodeableConcept", "Used to code the producer or rule for creating the display string.", 0, 1, this.source);
                }
                case 111972721: {
                    return new Property("value", "string", "The display string for the author list.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.source;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    this.source = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("source")) {
                this.source = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return this.getSource();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("source")) {
                this.source = new CodeableConcept();
                return this.source;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorString.value");
            }
            return super.addChild(name);
        }

        @Override
        public CitationAuthorStringComponent copy() {
            CitationAuthorStringComponent dst = new CitationAuthorStringComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationAuthorStringComponent dst) {
            super.copyValues(dst);
            dst.source = this.source == null ? null : this.source.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAuthorStringComponent)) {
                return false;
            }
            CitationAuthorStringComponent o = (CitationAuthorStringComponent)other_;
            return CitationAuthorStringComponent.compareDeep(this.source, o.source, true) && CitationAuthorStringComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAuthorStringComponent)) {
                return false;
            }
            CitationAuthorStringComponent o = (CitationAuthorStringComponent)other_;
            return CitationAuthorStringComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.source, this.value);
        }

        @Override
        public String fhirType() {
            return "Citation.authorString";
        }
    }

    @Block
    public static class CitationAuthorListAuthorAffiliationInfoComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="affiliation", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the organization", formalDefinition="Display for the organization.")
        protected StringType affiliation;
        @Child(name="role", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Role", formalDefinition="Role.")
        protected StringType role;
        @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier for the organization", formalDefinition="Identifier for the organization.")
        protected List<Identifier> identifier;
        private static final long serialVersionUID = 548335522L;

        public StringType getAffiliationElement() {
            if (this.affiliation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListAuthorAffiliationInfoComponent.affiliation");
                }
                if (Configuration.doAutoCreate()) {
                    this.affiliation = new StringType();
                }
            }
            return this.affiliation;
        }

        public boolean hasAffiliationElement() {
            return this.affiliation != null && !this.affiliation.isEmpty();
        }

        public boolean hasAffiliation() {
            return this.affiliation != null && !this.affiliation.isEmpty();
        }

        public CitationAuthorListAuthorAffiliationInfoComponent setAffiliationElement(StringType value) {
            this.affiliation = value;
            return this;
        }

        public String getAffiliation() {
            return this.affiliation == null ? null : (String)this.affiliation.getValue();
        }

        public CitationAuthorListAuthorAffiliationInfoComponent setAffiliation(String value) {
            if (Utilities.noString(value)) {
                this.affiliation = null;
            } else {
                if (this.affiliation == null) {
                    this.affiliation = new StringType();
                }
                this.affiliation.setValue(value);
            }
            return this;
        }

        public StringType getRoleElement() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListAuthorAffiliationInfoComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new StringType();
                }
            }
            return this.role;
        }

        public boolean hasRoleElement() {
            return this.role != null && !this.role.isEmpty();
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CitationAuthorListAuthorAffiliationInfoComponent setRoleElement(StringType value) {
            this.role = value;
            return this;
        }

        public String getRole() {
            return this.role == null ? null : (String)this.role.getValue();
        }

        public CitationAuthorListAuthorAffiliationInfoComponent setRole(String value) {
            if (Utilities.noString(value)) {
                this.role = null;
            } else {
                if (this.role == null) {
                    this.role = new StringType();
                }
                this.role.setValue(value);
            }
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationAuthorListAuthorAffiliationInfoComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationAuthorListAuthorAffiliationInfoComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("affiliation", "string", "Display for the organization.", 0, 1, this.affiliation));
            children.add(new Property("role", "string", "Role.", 0, 1, this.role));
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Identifier for the organization.", 0, Integer.MAX_VALUE, this.identifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2019918576: {
                    return new Property("affiliation", "string", "Display for the organization.", 0, 1, this.affiliation);
                }
                case 3506294: {
                    return new Property("role", "string", "Role.", 0, 1, this.role);
                }
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Identifier for the organization.", 0, Integer.MAX_VALUE, this.identifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    Base[] baseArray;
                    if (this.affiliation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.affiliation;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    this.affiliation = TypeConvertor.castToString(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToString(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("affiliation")) {
                this.affiliation = TypeConvertor.castToString(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToString(value);
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    return this.getAffiliationElement();
                }
                case 3506294: {
                    return this.getRoleElement();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2019918576: {
                    return new String[]{"string"};
                }
                case 3506294: {
                    return new String[]{"string"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("affiliation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.affiliationInfo.affiliation");
            }
            if (name.equals("role")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.affiliationInfo.role");
            }
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            return super.addChild(name);
        }

        @Override
        public CitationAuthorListAuthorAffiliationInfoComponent copy() {
            CitationAuthorListAuthorAffiliationInfoComponent dst = new CitationAuthorListAuthorAffiliationInfoComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationAuthorListAuthorAffiliationInfoComponent dst) {
            super.copyValues(dst);
            dst.affiliation = this.affiliation == null ? null : this.affiliation.copy();
            StringType stringType = dst.role = this.role == null ? null : this.role.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAuthorListAuthorAffiliationInfoComponent)) {
                return false;
            }
            CitationAuthorListAuthorAffiliationInfoComponent o = (CitationAuthorListAuthorAffiliationInfoComponent)other_;
            return CitationAuthorListAuthorAffiliationInfoComponent.compareDeep(this.affiliation, o.affiliation, true) && CitationAuthorListAuthorAffiliationInfoComponent.compareDeep(this.role, o.role, true) && CitationAuthorListAuthorAffiliationInfoComponent.compareDeep(this.identifier, o.identifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAuthorListAuthorAffiliationInfoComponent)) {
                return false;
            }
            CitationAuthorListAuthorAffiliationInfoComponent o = (CitationAuthorListAuthorAffiliationInfoComponent)other_;
            return CitationAuthorListAuthorAffiliationInfoComponent.compareValues(this.affiliation, o.affiliation, true) && CitationAuthorListAuthorAffiliationInfoComponent.compareValues(this.role, o.role, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.affiliation, this.role, this.identifier);
        }

        @Override
        public String fhirType() {
            return "Citation.authorList.author.affiliationInfo";
        }
    }

    @Block
    public static class CitationAuthorListAuthorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="lastName", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Surname or single name", formalDefinition="Surname or single name.")
        protected StringType lastName;
        @Child(name="foreName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Remainder of name except for suffix", formalDefinition="Remainder of name except for suffix.")
        protected StringType foreName;
        @Child(name="suffix", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Eg 2nd, 3rd, Jr, Sr", formalDefinition="Eg 2nd, 3rd, Jr, Sr.")
        protected StringType suffix;
        @Child(name="initials", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Initials for forename", formalDefinition="Initials for forename.")
        protected StringType initials;
        @Child(name="collectiveName", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for collective or corporate name as an author", formalDefinition="Used for collective or corporate name as an author.")
        protected StringType collectiveName;
        @Child(name="identifier", type={Identifier.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Author identifier, eg ORCID", formalDefinition="Author identifier, eg ORCID.")
        protected List<Identifier> identifier;
        @Child(name="affiliationInfo", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Organizational affiliation", formalDefinition="Organizational affiliation.")
        protected List<CitationAuthorListAuthorAffiliationInfoComponent> affiliationInfo;
        @Child(name="address", type={StringType.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Physical mailing address for the author", formalDefinition="Physical mailing address for the author.")
        protected List<StringType> address;
        @Child(name="telecom", type={ContactPoint.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Email or telephone contact methods for the author", formalDefinition="Email or telephone contact methods for the author.")
        protected List<ContactPoint> telecom;
        @Child(name="correspondingAuthor", type={BooleanType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indication of which author is the corresponding author for the article cited", formalDefinition="Indication of which author is the corresponding author for the article cited.")
        protected BooleanType correspondingAuthor;
        @Child(name="listOrder", type={PositiveIntType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to code order of authors", formalDefinition="Used to code order of authors.")
        protected PositiveIntType listOrder;
        private static final long serialVersionUID = 1461164632L;

        public StringType getLastNameElement() {
            if (this.lastName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListAuthorComponent.lastName");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastName = new StringType();
                }
            }
            return this.lastName;
        }

        public boolean hasLastNameElement() {
            return this.lastName != null && !this.lastName.isEmpty();
        }

        public boolean hasLastName() {
            return this.lastName != null && !this.lastName.isEmpty();
        }

        public CitationAuthorListAuthorComponent setLastNameElement(StringType value) {
            this.lastName = value;
            return this;
        }

        public String getLastName() {
            return this.lastName == null ? null : (String)this.lastName.getValue();
        }

        public CitationAuthorListAuthorComponent setLastName(String value) {
            if (Utilities.noString(value)) {
                this.lastName = null;
            } else {
                if (this.lastName == null) {
                    this.lastName = new StringType();
                }
                this.lastName.setValue(value);
            }
            return this;
        }

        public StringType getForeNameElement() {
            if (this.foreName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListAuthorComponent.foreName");
                }
                if (Configuration.doAutoCreate()) {
                    this.foreName = new StringType();
                }
            }
            return this.foreName;
        }

        public boolean hasForeNameElement() {
            return this.foreName != null && !this.foreName.isEmpty();
        }

        public boolean hasForeName() {
            return this.foreName != null && !this.foreName.isEmpty();
        }

        public CitationAuthorListAuthorComponent setForeNameElement(StringType value) {
            this.foreName = value;
            return this;
        }

        public String getForeName() {
            return this.foreName == null ? null : (String)this.foreName.getValue();
        }

        public CitationAuthorListAuthorComponent setForeName(String value) {
            if (Utilities.noString(value)) {
                this.foreName = null;
            } else {
                if (this.foreName == null) {
                    this.foreName = new StringType();
                }
                this.foreName.setValue(value);
            }
            return this;
        }

        public StringType getSuffixElement() {
            if (this.suffix == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListAuthorComponent.suffix");
                }
                if (Configuration.doAutoCreate()) {
                    this.suffix = new StringType();
                }
            }
            return this.suffix;
        }

        public boolean hasSuffixElement() {
            return this.suffix != null && !this.suffix.isEmpty();
        }

        public boolean hasSuffix() {
            return this.suffix != null && !this.suffix.isEmpty();
        }

        public CitationAuthorListAuthorComponent setSuffixElement(StringType value) {
            this.suffix = value;
            return this;
        }

        public String getSuffix() {
            return this.suffix == null ? null : (String)this.suffix.getValue();
        }

        public CitationAuthorListAuthorComponent setSuffix(String value) {
            if (Utilities.noString(value)) {
                this.suffix = null;
            } else {
                if (this.suffix == null) {
                    this.suffix = new StringType();
                }
                this.suffix.setValue(value);
            }
            return this;
        }

        public StringType getInitialsElement() {
            if (this.initials == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListAuthorComponent.initials");
                }
                if (Configuration.doAutoCreate()) {
                    this.initials = new StringType();
                }
            }
            return this.initials;
        }

        public boolean hasInitialsElement() {
            return this.initials != null && !this.initials.isEmpty();
        }

        public boolean hasInitials() {
            return this.initials != null && !this.initials.isEmpty();
        }

        public CitationAuthorListAuthorComponent setInitialsElement(StringType value) {
            this.initials = value;
            return this;
        }

        public String getInitials() {
            return this.initials == null ? null : (String)this.initials.getValue();
        }

        public CitationAuthorListAuthorComponent setInitials(String value) {
            if (Utilities.noString(value)) {
                this.initials = null;
            } else {
                if (this.initials == null) {
                    this.initials = new StringType();
                }
                this.initials.setValue(value);
            }
            return this;
        }

        public StringType getCollectiveNameElement() {
            if (this.collectiveName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListAuthorComponent.collectiveName");
                }
                if (Configuration.doAutoCreate()) {
                    this.collectiveName = new StringType();
                }
            }
            return this.collectiveName;
        }

        public boolean hasCollectiveNameElement() {
            return this.collectiveName != null && !this.collectiveName.isEmpty();
        }

        public boolean hasCollectiveName() {
            return this.collectiveName != null && !this.collectiveName.isEmpty();
        }

        public CitationAuthorListAuthorComponent setCollectiveNameElement(StringType value) {
            this.collectiveName = value;
            return this;
        }

        public String getCollectiveName() {
            return this.collectiveName == null ? null : (String)this.collectiveName.getValue();
        }

        public CitationAuthorListAuthorComponent setCollectiveName(String value) {
            if (Utilities.noString(value)) {
                this.collectiveName = null;
            } else {
                if (this.collectiveName == null) {
                    this.collectiveName = new StringType();
                }
                this.collectiveName.setValue(value);
            }
            return this;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationAuthorListAuthorComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationAuthorListAuthorComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public List<CitationAuthorListAuthorAffiliationInfoComponent> getAffiliationInfo() {
            if (this.affiliationInfo == null) {
                this.affiliationInfo = new ArrayList<CitationAuthorListAuthorAffiliationInfoComponent>();
            }
            return this.affiliationInfo;
        }

        public CitationAuthorListAuthorComponent setAffiliationInfo(List<CitationAuthorListAuthorAffiliationInfoComponent> theAffiliationInfo) {
            this.affiliationInfo = theAffiliationInfo;
            return this;
        }

        public boolean hasAffiliationInfo() {
            if (this.affiliationInfo == null) {
                return false;
            }
            for (CitationAuthorListAuthorAffiliationInfoComponent item : this.affiliationInfo) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationAuthorListAuthorAffiliationInfoComponent addAffiliationInfo() {
            CitationAuthorListAuthorAffiliationInfoComponent t = new CitationAuthorListAuthorAffiliationInfoComponent();
            if (this.affiliationInfo == null) {
                this.affiliationInfo = new ArrayList<CitationAuthorListAuthorAffiliationInfoComponent>();
            }
            this.affiliationInfo.add(t);
            return t;
        }

        public CitationAuthorListAuthorComponent addAffiliationInfo(CitationAuthorListAuthorAffiliationInfoComponent t) {
            if (t == null) {
                return this;
            }
            if (this.affiliationInfo == null) {
                this.affiliationInfo = new ArrayList<CitationAuthorListAuthorAffiliationInfoComponent>();
            }
            this.affiliationInfo.add(t);
            return this;
        }

        public CitationAuthorListAuthorAffiliationInfoComponent getAffiliationInfoFirstRep() {
            if (this.getAffiliationInfo().isEmpty()) {
                this.addAffiliationInfo();
            }
            return this.getAffiliationInfo().get(0);
        }

        public List<StringType> getAddress() {
            if (this.address == null) {
                this.address = new ArrayList<StringType>();
            }
            return this.address;
        }

        public CitationAuthorListAuthorComponent setAddress(List<StringType> theAddress) {
            this.address = theAddress;
            return this;
        }

        public boolean hasAddress() {
            if (this.address == null) {
                return false;
            }
            for (StringType item : this.address) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addAddressElement() {
            StringType t = new StringType();
            if (this.address == null) {
                this.address = new ArrayList<StringType>();
            }
            this.address.add(t);
            return t;
        }

        public CitationAuthorListAuthorComponent addAddress(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.address == null) {
                this.address = new ArrayList<StringType>();
            }
            this.address.add(t);
            return this;
        }

        public boolean hasAddress(String value) {
            if (this.address == null) {
                return false;
            }
            for (StringType v : this.address) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public CitationAuthorListAuthorComponent setTelecom(List<ContactPoint> theTelecom) {
            this.telecom = theTelecom;
            return this;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public CitationAuthorListAuthorComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        public ContactPoint getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public BooleanType getCorrespondingAuthorElement() {
            if (this.correspondingAuthor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListAuthorComponent.correspondingAuthor");
                }
                if (Configuration.doAutoCreate()) {
                    this.correspondingAuthor = new BooleanType();
                }
            }
            return this.correspondingAuthor;
        }

        public boolean hasCorrespondingAuthorElement() {
            return this.correspondingAuthor != null && !this.correspondingAuthor.isEmpty();
        }

        public boolean hasCorrespondingAuthor() {
            return this.correspondingAuthor != null && !this.correspondingAuthor.isEmpty();
        }

        public CitationAuthorListAuthorComponent setCorrespondingAuthorElement(BooleanType value) {
            this.correspondingAuthor = value;
            return this;
        }

        public boolean getCorrespondingAuthor() {
            return this.correspondingAuthor == null || this.correspondingAuthor.isEmpty() ? false : (Boolean)this.correspondingAuthor.getValue();
        }

        public CitationAuthorListAuthorComponent setCorrespondingAuthor(boolean value) {
            if (this.correspondingAuthor == null) {
                this.correspondingAuthor = new BooleanType();
            }
            this.correspondingAuthor.setValue((Object)value);
            return this;
        }

        public PositiveIntType getListOrderElement() {
            if (this.listOrder == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListAuthorComponent.listOrder");
                }
                if (Configuration.doAutoCreate()) {
                    this.listOrder = new PositiveIntType();
                }
            }
            return this.listOrder;
        }

        public boolean hasListOrderElement() {
            return this.listOrder != null && !this.listOrder.isEmpty();
        }

        public boolean hasListOrder() {
            return this.listOrder != null && !this.listOrder.isEmpty();
        }

        public CitationAuthorListAuthorComponent setListOrderElement(PositiveIntType value) {
            this.listOrder = value;
            return this;
        }

        public int getListOrder() {
            return this.listOrder == null || this.listOrder.isEmpty() ? 0 : (Integer)this.listOrder.getValue();
        }

        public CitationAuthorListAuthorComponent setListOrder(int value) {
            if (this.listOrder == null) {
                this.listOrder = new PositiveIntType();
            }
            this.listOrder.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("lastName", "string", "Surname or single name.", 0, 1, this.lastName));
            children.add(new Property("foreName", "string", "Remainder of name except for suffix.", 0, 1, this.foreName));
            children.add(new Property("suffix", "string", "Eg 2nd, 3rd, Jr, Sr.", 0, 1, this.suffix));
            children.add(new Property("initials", "string", "Initials for forename.", 0, 1, this.initials));
            children.add(new Property("collectiveName", "string", "Used for collective or corporate name as an author.", 0, 1, this.collectiveName));
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Author identifier, eg ORCID.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("affiliationInfo", "", "Organizational affiliation.", 0, Integer.MAX_VALUE, this.affiliationInfo));
            children.add(new Property("address", "string", "Physical mailing address for the author.", 0, Integer.MAX_VALUE, this.address));
            children.add(new Property("telecom", "ContactPoint", "Email or telephone contact methods for the author.", 0, Integer.MAX_VALUE, this.telecom));
            children.add(new Property("correspondingAuthor", "boolean", "Indication of which author is the corresponding author for the article cited.", 0, 1, this.correspondingAuthor));
            children.add(new Property("listOrder", "positiveInt", "Used to code order of authors.", 0, 1, this.listOrder));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1459599807: {
                    return new Property("lastName", "string", "Surname or single name.", 0, 1, this.lastName);
                }
                case 466107751: {
                    return new Property("foreName", "string", "Remainder of name except for suffix.", 0, 1, this.foreName);
                }
                case -891422895: {
                    return new Property("suffix", "string", "Eg 2nd, 3rd, Jr, Sr.", 0, 1, this.suffix);
                }
                case 269062575: {
                    return new Property("initials", "string", "Initials for forename.", 0, 1, this.initials);
                }
                case 502871833: {
                    return new Property("collectiveName", "string", "Used for collective or corporate name as an author.", 0, 1, this.collectiveName);
                }
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Author identifier, eg ORCID.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case -215129154: {
                    return new Property("affiliationInfo", "", "Organizational affiliation.", 0, Integer.MAX_VALUE, this.affiliationInfo);
                }
                case -1147692044: {
                    return new Property("address", "string", "Physical mailing address for the author.", 0, Integer.MAX_VALUE, this.address);
                }
                case -1429363305: {
                    return new Property("telecom", "ContactPoint", "Email or telephone contact methods for the author.", 0, Integer.MAX_VALUE, this.telecom);
                }
                case 1413890206: {
                    return new Property("correspondingAuthor", "boolean", "Indication of which author is the corresponding author for the article cited.", 0, 1, this.correspondingAuthor);
                }
                case -1238918832: {
                    return new Property("listOrder", "positiveInt", "Used to code order of authors.", 0, 1, this.listOrder);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1459599807: {
                    Base[] baseArray;
                    if (this.lastName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.lastName;
                    }
                    return baseArray;
                }
                case 466107751: {
                    Base[] baseArray;
                    if (this.foreName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.foreName;
                    }
                    return baseArray;
                }
                case -891422895: {
                    Base[] baseArray;
                    if (this.suffix == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.suffix;
                    }
                    return baseArray;
                }
                case 269062575: {
                    Base[] baseArray;
                    if (this.initials == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.initials;
                    }
                    return baseArray;
                }
                case 502871833: {
                    Base[] baseArray;
                    if (this.collectiveName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.collectiveName;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case -215129154: {
                    return this.affiliationInfo == null ? new Base[]{} : this.affiliationInfo.toArray(new Base[this.affiliationInfo.size()]);
                }
                case -1147692044: {
                    return this.address == null ? new Base[]{} : this.address.toArray(new Base[this.address.size()]);
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
                case 1413890206: {
                    Base[] baseArray;
                    if (this.correspondingAuthor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.correspondingAuthor;
                    }
                    return baseArray;
                }
                case -1238918832: {
                    Base[] baseArray;
                    if (this.listOrder == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.listOrder;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1459599807: {
                    this.lastName = TypeConvertor.castToString(value);
                    return value;
                }
                case 466107751: {
                    this.foreName = TypeConvertor.castToString(value);
                    return value;
                }
                case -891422895: {
                    this.suffix = TypeConvertor.castToString(value);
                    return value;
                }
                case 269062575: {
                    this.initials = TypeConvertor.castToString(value);
                    return value;
                }
                case 502871833: {
                    this.collectiveName = TypeConvertor.castToString(value);
                    return value;
                }
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -215129154: {
                    this.getAffiliationInfo().add((CitationAuthorListAuthorAffiliationInfoComponent)value);
                    return value;
                }
                case -1147692044: {
                    this.getAddress().add(TypeConvertor.castToString(value));
                    return value;
                }
                case -1429363305: {
                    this.getTelecom().add(TypeConvertor.castToContactPoint(value));
                    return value;
                }
                case 1413890206: {
                    this.correspondingAuthor = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1238918832: {
                    this.listOrder = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("lastName")) {
                this.lastName = TypeConvertor.castToString(value);
            } else if (name.equals("foreName")) {
                this.foreName = TypeConvertor.castToString(value);
            } else if (name.equals("suffix")) {
                this.suffix = TypeConvertor.castToString(value);
            } else if (name.equals("initials")) {
                this.initials = TypeConvertor.castToString(value);
            } else if (name.equals("collectiveName")) {
                this.collectiveName = TypeConvertor.castToString(value);
            } else if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("affiliationInfo")) {
                this.getAffiliationInfo().add((CitationAuthorListAuthorAffiliationInfoComponent)value);
            } else if (name.equals("address")) {
                this.getAddress().add(TypeConvertor.castToString(value));
            } else if (name.equals("telecom")) {
                this.getTelecom().add(TypeConvertor.castToContactPoint(value));
            } else if (name.equals("correspondingAuthor")) {
                this.correspondingAuthor = TypeConvertor.castToBoolean(value);
            } else if (name.equals("listOrder")) {
                this.listOrder = TypeConvertor.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1459599807: {
                    return this.getLastNameElement();
                }
                case 466107751: {
                    return this.getForeNameElement();
                }
                case -891422895: {
                    return this.getSuffixElement();
                }
                case 269062575: {
                    return this.getInitialsElement();
                }
                case 502871833: {
                    return this.getCollectiveNameElement();
                }
                case -1618432855: {
                    return this.addIdentifier();
                }
                case -215129154: {
                    return this.addAffiliationInfo();
                }
                case -1147692044: {
                    return this.addAddressElement();
                }
                case -1429363305: {
                    return this.addTelecom();
                }
                case 1413890206: {
                    return this.getCorrespondingAuthorElement();
                }
                case -1238918832: {
                    return this.getListOrderElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1459599807: {
                    return new String[]{"string"};
                }
                case 466107751: {
                    return new String[]{"string"};
                }
                case -891422895: {
                    return new String[]{"string"};
                }
                case 269062575: {
                    return new String[]{"string"};
                }
                case 502871833: {
                    return new String[]{"string"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -215129154: {
                    return new String[0];
                }
                case -1147692044: {
                    return new String[]{"string"};
                }
                case -1429363305: {
                    return new String[]{"ContactPoint"};
                }
                case 1413890206: {
                    return new String[]{"boolean"};
                }
                case -1238918832: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("lastName")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.lastName");
            }
            if (name.equals("foreName")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.foreName");
            }
            if (name.equals("suffix")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.suffix");
            }
            if (name.equals("initials")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.initials");
            }
            if (name.equals("collectiveName")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.collectiveName");
            }
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("affiliationInfo")) {
                return this.addAffiliationInfo();
            }
            if (name.equals("address")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.address");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            if (name.equals("correspondingAuthor")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.correspondingAuthor");
            }
            if (name.equals("listOrder")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.author.listOrder");
            }
            return super.addChild(name);
        }

        @Override
        public CitationAuthorListAuthorComponent copy() {
            CitationAuthorListAuthorComponent dst = new CitationAuthorListAuthorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationAuthorListAuthorComponent dst) {
            super.copyValues(dst);
            dst.lastName = this.lastName == null ? null : this.lastName.copy();
            dst.foreName = this.foreName == null ? null : this.foreName.copy();
            dst.suffix = this.suffix == null ? null : this.suffix.copy();
            dst.initials = this.initials == null ? null : this.initials.copy();
            StringType stringType = dst.collectiveName = this.collectiveName == null ? null : this.collectiveName.copy();
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            if (this.affiliationInfo != null) {
                dst.affiliationInfo = new ArrayList<CitationAuthorListAuthorAffiliationInfoComponent>();
                for (CitationAuthorListAuthorAffiliationInfoComponent citationAuthorListAuthorAffiliationInfoComponent : this.affiliationInfo) {
                    dst.affiliationInfo.add(citationAuthorListAuthorAffiliationInfoComponent.copy());
                }
            }
            if (this.address != null) {
                dst.address = new ArrayList<StringType>();
                for (StringType stringType2 : this.address) {
                    dst.address.add(stringType2.copy());
                }
            }
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint contactPoint : this.telecom) {
                    dst.telecom.add(contactPoint.copy());
                }
            }
            dst.correspondingAuthor = this.correspondingAuthor == null ? null : this.correspondingAuthor.copy();
            dst.listOrder = this.listOrder == null ? null : this.listOrder.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAuthorListAuthorComponent)) {
                return false;
            }
            CitationAuthorListAuthorComponent o = (CitationAuthorListAuthorComponent)other_;
            return CitationAuthorListAuthorComponent.compareDeep(this.lastName, o.lastName, true) && CitationAuthorListAuthorComponent.compareDeep(this.foreName, o.foreName, true) && CitationAuthorListAuthorComponent.compareDeep(this.suffix, o.suffix, true) && CitationAuthorListAuthorComponent.compareDeep(this.initials, o.initials, true) && CitationAuthorListAuthorComponent.compareDeep(this.collectiveName, o.collectiveName, true) && CitationAuthorListAuthorComponent.compareDeep(this.identifier, o.identifier, true) && CitationAuthorListAuthorComponent.compareDeep(this.affiliationInfo, o.affiliationInfo, true) && CitationAuthorListAuthorComponent.compareDeep(this.address, o.address, true) && CitationAuthorListAuthorComponent.compareDeep(this.telecom, o.telecom, true) && CitationAuthorListAuthorComponent.compareDeep(this.correspondingAuthor, o.correspondingAuthor, true) && CitationAuthorListAuthorComponent.compareDeep(this.listOrder, o.listOrder, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAuthorListAuthorComponent)) {
                return false;
            }
            CitationAuthorListAuthorComponent o = (CitationAuthorListAuthorComponent)other_;
            return CitationAuthorListAuthorComponent.compareValues(this.lastName, o.lastName, true) && CitationAuthorListAuthorComponent.compareValues(this.foreName, o.foreName, true) && CitationAuthorListAuthorComponent.compareValues(this.suffix, o.suffix, true) && CitationAuthorListAuthorComponent.compareValues(this.initials, o.initials, true) && CitationAuthorListAuthorComponent.compareValues(this.collectiveName, o.collectiveName, true) && CitationAuthorListAuthorComponent.compareValues(this.address, o.address, true) && CitationAuthorListAuthorComponent.compareValues(this.correspondingAuthor, o.correspondingAuthor, true) && CitationAuthorListAuthorComponent.compareValues(this.listOrder, o.listOrder, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.lastName, this.foreName, this.suffix, this.initials, this.collectiveName, this.identifier, this.affiliationInfo, this.address, this.telecom, this.correspondingAuthor, this.listOrder);
        }

        @Override
        public String fhirType() {
            return "Citation.authorList.author";
        }
    }

    @Block
    public static class CitationAuthorListComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="complete", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates if the list includes all authors, else \u201cet al\u201d should be appended for display", formalDefinition="Indicates if the list includes all authors, else \u201cet al\u201d should be appended for display.")
        protected BooleanType complete;
        @Child(name="author", type={}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An individual entity named in the author list", formalDefinition="An individual entity named in the author list.")
        protected List<CitationAuthorListAuthorComponent> author;
        private static final long serialVersionUID = -204175482L;

        public CitationAuthorListComponent() {
        }

        public CitationAuthorListComponent(CitationAuthorListAuthorComponent author) {
            this.addAuthor(author);
        }

        public BooleanType getCompleteElement() {
            if (this.complete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAuthorListComponent.complete");
                }
                if (Configuration.doAutoCreate()) {
                    this.complete = new BooleanType();
                }
            }
            return this.complete;
        }

        public boolean hasCompleteElement() {
            return this.complete != null && !this.complete.isEmpty();
        }

        public boolean hasComplete() {
            return this.complete != null && !this.complete.isEmpty();
        }

        public CitationAuthorListComponent setCompleteElement(BooleanType value) {
            this.complete = value;
            return this;
        }

        public boolean getComplete() {
            return this.complete == null || this.complete.isEmpty() ? false : (Boolean)this.complete.getValue();
        }

        public CitationAuthorListComponent setComplete(boolean value) {
            if (this.complete == null) {
                this.complete = new BooleanType();
            }
            this.complete.setValue((Object)value);
            return this;
        }

        public List<CitationAuthorListAuthorComponent> getAuthor() {
            if (this.author == null) {
                this.author = new ArrayList<CitationAuthorListAuthorComponent>();
            }
            return this.author;
        }

        public CitationAuthorListComponent setAuthor(List<CitationAuthorListAuthorComponent> theAuthor) {
            this.author = theAuthor;
            return this;
        }

        public boolean hasAuthor() {
            if (this.author == null) {
                return false;
            }
            for (CitationAuthorListAuthorComponent item : this.author) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CitationAuthorListAuthorComponent addAuthor() {
            CitationAuthorListAuthorComponent t = new CitationAuthorListAuthorComponent();
            if (this.author == null) {
                this.author = new ArrayList<CitationAuthorListAuthorComponent>();
            }
            this.author.add(t);
            return t;
        }

        public CitationAuthorListComponent addAuthor(CitationAuthorListAuthorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.author == null) {
                this.author = new ArrayList<CitationAuthorListAuthorComponent>();
            }
            this.author.add(t);
            return this;
        }

        public CitationAuthorListAuthorComponent getAuthorFirstRep() {
            if (this.getAuthor().isEmpty()) {
                this.addAuthor();
            }
            return this.getAuthor().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("complete", "boolean", "Indicates if the list includes all authors, else \u201cet al\u201d should be appended for display.", 0, 1, this.complete));
            children.add(new Property("author", "", "An individual entity named in the author list.", 0, Integer.MAX_VALUE, this.author));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -599445191: {
                    return new Property("complete", "boolean", "Indicates if the list includes all authors, else \u201cet al\u201d should be appended for display.", 0, 1, this.complete);
                }
                case -1406328437: {
                    return new Property("author", "", "An individual entity named in the author list.", 0, Integer.MAX_VALUE, this.author);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    Base[] baseArray;
                    if (this.complete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.complete;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    this.complete = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1406328437: {
                    this.getAuthor().add((CitationAuthorListAuthorComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("complete")) {
                this.complete = TypeConvertor.castToBoolean(value);
            } else if (name.equals("author")) {
                this.getAuthor().add((CitationAuthorListAuthorComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    return this.getCompleteElement();
                }
                case -1406328437: {
                    return this.addAuthor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -599445191: {
                    return new String[]{"boolean"};
                }
                case -1406328437: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("complete")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.authorList.complete");
            }
            if (name.equals("author")) {
                return this.addAuthor();
            }
            return super.addChild(name);
        }

        @Override
        public CitationAuthorListComponent copy() {
            CitationAuthorListComponent dst = new CitationAuthorListComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationAuthorListComponent dst) {
            super.copyValues(dst);
            BooleanType booleanType = dst.complete = this.complete == null ? null : this.complete.copy();
            if (this.author != null) {
                dst.author = new ArrayList<CitationAuthorListAuthorComponent>();
                for (CitationAuthorListAuthorComponent i : this.author) {
                    dst.author.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAuthorListComponent)) {
                return false;
            }
            CitationAuthorListComponent o = (CitationAuthorListComponent)other_;
            return CitationAuthorListComponent.compareDeep(this.complete, o.complete, true) && CitationAuthorListComponent.compareDeep(this.author, o.author, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAuthorListComponent)) {
                return false;
            }
            CitationAuthorListComponent o = (CitationAuthorListComponent)other_;
            return CitationAuthorListComponent.compareValues(this.complete, o.complete, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.complete, this.author);
        }

        @Override
        public String fhirType() {
            return "Citation.authorList";
        }
    }

    @Block
    public static class CitationAlternativeAbstractComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the reason for the variant abstract, such as language", formalDefinition="Used to express the reason for the variant abstract, such as language.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/alternative-title-type")
        protected CodeableConcept type;
        @Child(name="language", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the specific language", formalDefinition="Used to express the specific language.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        @Child(name="abstract", type={MarkdownType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Full variant abstract of the article", formalDefinition="Full variant abstract of the article.")
        protected MarkdownType abstract_;
        @Child(name="abstractCopyright", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Variant abstract copyright", formalDefinition="Copyright information for the abstract text.")
        protected MarkdownType abstractCopyright;
        private static final long serialVersionUID = 1805874682L;

        public CitationAlternativeAbstractComponent() {
        }

        public CitationAlternativeAbstractComponent(String abstract_) {
            this.setAbstract(abstract_);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeAbstractComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationAlternativeAbstractComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeAbstractComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public CitationAlternativeAbstractComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public MarkdownType getAbstractElement() {
            if (this.abstract_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeAbstractComponent.abstract_");
                }
                if (Configuration.doAutoCreate()) {
                    this.abstract_ = new MarkdownType();
                }
            }
            return this.abstract_;
        }

        public boolean hasAbstractElement() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public boolean hasAbstract() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public CitationAlternativeAbstractComponent setAbstractElement(MarkdownType value) {
            this.abstract_ = value;
            return this;
        }

        public String getAbstract() {
            return this.abstract_ == null ? null : (String)this.abstract_.getValue();
        }

        public CitationAlternativeAbstractComponent setAbstract(String value) {
            if (this.abstract_ == null) {
                this.abstract_ = new MarkdownType();
            }
            this.abstract_.setValue(value);
            return this;
        }

        public MarkdownType getAbstractCopyrightElement() {
            if (this.abstractCopyright == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeAbstractComponent.abstractCopyright");
                }
                if (Configuration.doAutoCreate()) {
                    this.abstractCopyright = new MarkdownType();
                }
            }
            return this.abstractCopyright;
        }

        public boolean hasAbstractCopyrightElement() {
            return this.abstractCopyright != null && !this.abstractCopyright.isEmpty();
        }

        public boolean hasAbstractCopyright() {
            return this.abstractCopyright != null && !this.abstractCopyright.isEmpty();
        }

        public CitationAlternativeAbstractComponent setAbstractCopyrightElement(MarkdownType value) {
            this.abstractCopyright = value;
            return this;
        }

        public String getAbstractCopyright() {
            return this.abstractCopyright == null ? null : (String)this.abstractCopyright.getValue();
        }

        public CitationAlternativeAbstractComponent setAbstractCopyright(String value) {
            if (value == null) {
                this.abstractCopyright = null;
            } else {
                if (this.abstractCopyright == null) {
                    this.abstractCopyright = new MarkdownType();
                }
                this.abstractCopyright.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used to express the reason for the variant abstract, such as language.", 0, 1, this.type));
            children.add(new Property("language", "CodeableConcept", "Used to express the specific language.", 0, 1, this.language));
            children.add(new Property("abstract", "markdown", "Full variant abstract of the article.", 0, 1, this.abstract_));
            children.add(new Property("abstractCopyright", "markdown", "Copyright information for the abstract text.", 0, 1, this.abstractCopyright));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used to express the reason for the variant abstract, such as language.", 0, 1, this.type);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Used to express the specific language.", 0, 1, this.language);
                }
                case 1732898850: {
                    return new Property("abstract", "markdown", "Full variant abstract of the article.", 0, 1, this.abstract_);
                }
                case -656627259: {
                    return new Property("abstractCopyright", "markdown", "Copyright information for the abstract text.", 0, 1, this.abstractCopyright);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case 1732898850: {
                    Base[] baseArray;
                    if (this.abstract_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.abstract_;
                    }
                    return baseArray;
                }
                case -656627259: {
                    Base[] baseArray;
                    if (this.abstractCopyright == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.abstractCopyright;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1732898850: {
                    this.abstract_ = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -656627259: {
                    this.abstractCopyright = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("abstract")) {
                this.abstract_ = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("abstractCopyright")) {
                this.abstractCopyright = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
                case 1732898850: {
                    return this.getAbstractElement();
                }
                case -656627259: {
                    return this.getAbstractCopyrightElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case 1732898850: {
                    return new String[]{"markdown"};
                }
                case -656627259: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("abstract")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.alternativeAbstract.abstract");
            }
            if (name.equals("abstractCopyright")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.alternativeAbstract.abstractCopyright");
            }
            return super.addChild(name);
        }

        @Override
        public CitationAlternativeAbstractComponent copy() {
            CitationAlternativeAbstractComponent dst = new CitationAlternativeAbstractComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationAlternativeAbstractComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.abstract_ = this.abstract_ == null ? null : this.abstract_.copy();
            dst.abstractCopyright = this.abstractCopyright == null ? null : this.abstractCopyright.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeAbstractComponent)) {
                return false;
            }
            CitationAlternativeAbstractComponent o = (CitationAlternativeAbstractComponent)other_;
            return CitationAlternativeAbstractComponent.compareDeep(this.type, o.type, true) && CitationAlternativeAbstractComponent.compareDeep(this.language, o.language, true) && CitationAlternativeAbstractComponent.compareDeep(this.abstract_, o.abstract_, true) && CitationAlternativeAbstractComponent.compareDeep(this.abstractCopyright, o.abstractCopyright, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeAbstractComponent)) {
                return false;
            }
            CitationAlternativeAbstractComponent o = (CitationAlternativeAbstractComponent)other_;
            return CitationAlternativeAbstractComponent.compareValues(this.abstract_, o.abstract_, true) && CitationAlternativeAbstractComponent.compareValues(this.abstractCopyright, o.abstractCopyright, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.language, this.abstract_, this.abstractCopyright);
        }

        @Override
        public String fhirType() {
            return "Citation.alternativeAbstract";
        }
    }

    @Block
    public static class CitationArticleUrlComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code the reason for different URLs, eg abstract and full-text", formalDefinition="Code the reason for different URLs, eg abstract and full-text.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/article-url-type")
        protected CodeableConcept type;
        @Child(name="url", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific URL", formalDefinition="The specific URL.")
        protected UriType url;
        private static final long serialVersionUID = 397204034L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationArticleUrlComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationArticleUrlComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationArticleUrlComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public CitationArticleUrlComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public CitationArticleUrlComponent setUrl(String value) {
            if (Utilities.noString(value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Code the reason for different URLs, eg abstract and full-text.", 0, 1, this.type));
            children.add(new Property(Citation.SP_URL, "uri", "The specific URL.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Code the reason for different URLs, eg abstract and full-text.", 0, 1, this.type);
                }
                case 116079: {
                    return new Property(Citation.SP_URL, "uri", "The specific URL.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Citation.SP_URL)) {
                this.url = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 116079: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(Citation.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.articleUrl.url");
            }
            return super.addChild(name);
        }

        @Override
        public CitationArticleUrlComponent copy() {
            CitationArticleUrlComponent dst = new CitationArticleUrlComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationArticleUrlComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationArticleUrlComponent)) {
                return false;
            }
            CitationArticleUrlComponent o = (CitationArticleUrlComponent)other_;
            return CitationArticleUrlComponent.compareDeep(this.type, o.type, true) && CitationArticleUrlComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationArticleUrlComponent)) {
                return false;
            }
            CitationArticleUrlComponent o = (CitationArticleUrlComponent)other_;
            return CitationArticleUrlComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.url);
        }

        @Override
        public String fhirType() {
            return "Citation.articleUrl";
        }
    }

    @Block
    public static class CitationPaginationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="pageString", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for full display of pagination", formalDefinition="Used for full display of pagination.")
        protected StringType pageString;
        @Child(name="firstPage", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for isolated representation of first page", formalDefinition="Used for isolated representation of first page.")
        protected StringType firstPage;
        @Child(name="lastPage", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used for isolated representation of last page", formalDefinition="Used for isolated representation of last page.")
        protected StringType lastPage;
        private static final long serialVersionUID = -690699049L;

        public StringType getPageStringElement() {
            if (this.pageString == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationPaginationComponent.pageString");
                }
                if (Configuration.doAutoCreate()) {
                    this.pageString = new StringType();
                }
            }
            return this.pageString;
        }

        public boolean hasPageStringElement() {
            return this.pageString != null && !this.pageString.isEmpty();
        }

        public boolean hasPageString() {
            return this.pageString != null && !this.pageString.isEmpty();
        }

        public CitationPaginationComponent setPageStringElement(StringType value) {
            this.pageString = value;
            return this;
        }

        public String getPageString() {
            return this.pageString == null ? null : (String)this.pageString.getValue();
        }

        public CitationPaginationComponent setPageString(String value) {
            if (Utilities.noString(value)) {
                this.pageString = null;
            } else {
                if (this.pageString == null) {
                    this.pageString = new StringType();
                }
                this.pageString.setValue(value);
            }
            return this;
        }

        public StringType getFirstPageElement() {
            if (this.firstPage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationPaginationComponent.firstPage");
                }
                if (Configuration.doAutoCreate()) {
                    this.firstPage = new StringType();
                }
            }
            return this.firstPage;
        }

        public boolean hasFirstPageElement() {
            return this.firstPage != null && !this.firstPage.isEmpty();
        }

        public boolean hasFirstPage() {
            return this.firstPage != null && !this.firstPage.isEmpty();
        }

        public CitationPaginationComponent setFirstPageElement(StringType value) {
            this.firstPage = value;
            return this;
        }

        public String getFirstPage() {
            return this.firstPage == null ? null : (String)this.firstPage.getValue();
        }

        public CitationPaginationComponent setFirstPage(String value) {
            if (Utilities.noString(value)) {
                this.firstPage = null;
            } else {
                if (this.firstPage == null) {
                    this.firstPage = new StringType();
                }
                this.firstPage.setValue(value);
            }
            return this;
        }

        public StringType getLastPageElement() {
            if (this.lastPage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationPaginationComponent.lastPage");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastPage = new StringType();
                }
            }
            return this.lastPage;
        }

        public boolean hasLastPageElement() {
            return this.lastPage != null && !this.lastPage.isEmpty();
        }

        public boolean hasLastPage() {
            return this.lastPage != null && !this.lastPage.isEmpty();
        }

        public CitationPaginationComponent setLastPageElement(StringType value) {
            this.lastPage = value;
            return this;
        }

        public String getLastPage() {
            return this.lastPage == null ? null : (String)this.lastPage.getValue();
        }

        public CitationPaginationComponent setLastPage(String value) {
            if (Utilities.noString(value)) {
                this.lastPage = null;
            } else {
                if (this.lastPage == null) {
                    this.lastPage = new StringType();
                }
                this.lastPage.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("pageString", "string", "Used for full display of pagination.", 0, 1, this.pageString));
            children.add(new Property("firstPage", "string", "Used for isolated representation of first page.", 0, 1, this.firstPage));
            children.add(new Property("lastPage", "string", "Used for isolated representation of last page.", 0, 1, this.lastPage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1287145344: {
                    return new Property("pageString", "string", "Used for full display of pagination.", 0, 1, this.pageString);
                }
                case 132895071: {
                    return new Property("firstPage", "string", "Used for isolated representation of first page.", 0, 1, this.firstPage);
                }
                case -1459540411: {
                    return new Property("lastPage", "string", "Used for isolated representation of last page.", 0, 1, this.lastPage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1287145344: {
                    Base[] baseArray;
                    if (this.pageString == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.pageString;
                    }
                    return baseArray;
                }
                case 132895071: {
                    Base[] baseArray;
                    if (this.firstPage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.firstPage;
                    }
                    return baseArray;
                }
                case -1459540411: {
                    Base[] baseArray;
                    if (this.lastPage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.lastPage;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1287145344: {
                    this.pageString = TypeConvertor.castToString(value);
                    return value;
                }
                case 132895071: {
                    this.firstPage = TypeConvertor.castToString(value);
                    return value;
                }
                case -1459540411: {
                    this.lastPage = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("pageString")) {
                this.pageString = TypeConvertor.castToString(value);
            } else if (name.equals("firstPage")) {
                this.firstPage = TypeConvertor.castToString(value);
            } else if (name.equals("lastPage")) {
                this.lastPage = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1287145344: {
                    return this.getPageStringElement();
                }
                case 132895071: {
                    return this.getFirstPageElement();
                }
                case -1459540411: {
                    return this.getLastPageElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1287145344: {
                    return new String[]{"string"};
                }
                case 132895071: {
                    return new String[]{"string"};
                }
                case -1459540411: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("pageString")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.pagination.pageString");
            }
            if (name.equals("firstPage")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.pagination.firstPage");
            }
            if (name.equals("lastPage")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.pagination.lastPage");
            }
            return super.addChild(name);
        }

        @Override
        public CitationPaginationComponent copy() {
            CitationPaginationComponent dst = new CitationPaginationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationPaginationComponent dst) {
            super.copyValues(dst);
            dst.pageString = this.pageString == null ? null : this.pageString.copy();
            dst.firstPage = this.firstPage == null ? null : this.firstPage.copy();
            dst.lastPage = this.lastPage == null ? null : this.lastPage.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationPaginationComponent)) {
                return false;
            }
            CitationPaginationComponent o = (CitationPaginationComponent)other_;
            return CitationPaginationComponent.compareDeep(this.pageString, o.pageString, true) && CitationPaginationComponent.compareDeep(this.firstPage, o.firstPage, true) && CitationPaginationComponent.compareDeep(this.lastPage, o.lastPage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationPaginationComponent)) {
                return false;
            }
            CitationPaginationComponent o = (CitationPaginationComponent)other_;
            return CitationPaginationComponent.compareValues(this.pageString, o.pageString, true) && CitationPaginationComponent.compareValues(this.firstPage, o.firstPage, true) && CitationPaginationComponent.compareValues(this.lastPage, o.lastPage, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.pageString, this.firstPage, this.lastPage);
        }

        @Override
        public String fhirType() {
            return "Citation.pagination";
        }
    }

    @Block
    public static class CitationAlternativeTitleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the reason and specific aspect for the variant title, such as language", formalDefinition="Used to express the reason and specific aspect for the variant title, such as language and specific language.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/alternative-title-type")
        protected CodeableConcept type;
        @Child(name="language", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to express the specific language", formalDefinition="Used to express the specific language.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        @Child(name="title", type={MarkdownType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Full variant title of the article", formalDefinition="Full variant title of the article.")
        protected MarkdownType title;
        private static final long serialVersionUID = -552795869L;

        public CitationAlternativeTitleComponent() {
        }

        public CitationAlternativeTitleComponent(String title) {
            this.setTitle(title);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeTitleComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationAlternativeTitleComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeTitleComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public CitationAlternativeTitleComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public MarkdownType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationAlternativeTitleComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new MarkdownType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public CitationAlternativeTitleComponent setTitleElement(MarkdownType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public CitationAlternativeTitleComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new MarkdownType();
            }
            this.title.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used to express the reason and specific aspect for the variant title, such as language and specific language.", 0, 1, this.type));
            children.add(new Property("language", "CodeableConcept", "Used to express the specific language.", 0, 1, this.language));
            children.add(new Property("title", "markdown", "Full variant title of the article.", 0, 1, this.title));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used to express the reason and specific aspect for the variant title, such as language and specific language.", 0, 1, this.type);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Used to express the specific language.", 0, 1, this.language);
                }
                case 110371416: {
                    return new Property("title", "markdown", "Full variant title of the article.", 0, 1, this.title);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.title;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case 110371416: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.alternativeTitle.title");
            }
            return super.addChild(name);
        }

        @Override
        public CitationAlternativeTitleComponent copy() {
            CitationAlternativeTitleComponent dst = new CitationAlternativeTitleComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationAlternativeTitleComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.title = this.title == null ? null : this.title.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeTitleComponent)) {
                return false;
            }
            CitationAlternativeTitleComponent o = (CitationAlternativeTitleComponent)other_;
            return CitationAlternativeTitleComponent.compareDeep(this.type, o.type, true) && CitationAlternativeTitleComponent.compareDeep(this.language, o.language, true) && CitationAlternativeTitleComponent.compareDeep(this.title, o.title, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationAlternativeTitleComponent)) {
                return false;
            }
            CitationAlternativeTitleComponent o = (CitationAlternativeTitleComponent)other_;
            return CitationAlternativeTitleComponent.compareValues(this.title, o.title, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.language, this.title);
        }

        @Override
        public String fhirType() {
            return "Citation.alternativeTitle";
        }
    }

    @Block
    public static class CitationJournalJournalIssueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="citedMedium", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="NLM codes Internet or Print", formalDefinition="NLM codes Internet or Print.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/journal-issue-medium")
        protected CodeableConcept citedMedium;
        @Child(name="volume", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Volume number of journal in which the article is published", formalDefinition="Volume number of journal in which the article is published.")
        protected StringType volume;
        @Child(name="issue", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Issue, part or supplement of journal in which the article is published", formalDefinition="Issue, part or supplement of journal in which the article is published.")
        protected StringType issue;
        @Child(name="publicationDate", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date on which the issue of the journal was published", formalDefinition="Date on which the issue of the journal was published.")
        protected StringType publicationDate;
        private static final long serialVersionUID = -1343937439L;

        public CodeableConcept getCitedMedium() {
            if (this.citedMedium == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationJournalJournalIssueComponent.citedMedium");
                }
                if (Configuration.doAutoCreate()) {
                    this.citedMedium = new CodeableConcept();
                }
            }
            return this.citedMedium;
        }

        public boolean hasCitedMedium() {
            return this.citedMedium != null && !this.citedMedium.isEmpty();
        }

        public CitationJournalJournalIssueComponent setCitedMedium(CodeableConcept value) {
            this.citedMedium = value;
            return this;
        }

        public StringType getVolumeElement() {
            if (this.volume == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationJournalJournalIssueComponent.volume");
                }
                if (Configuration.doAutoCreate()) {
                    this.volume = new StringType();
                }
            }
            return this.volume;
        }

        public boolean hasVolumeElement() {
            return this.volume != null && !this.volume.isEmpty();
        }

        public boolean hasVolume() {
            return this.volume != null && !this.volume.isEmpty();
        }

        public CitationJournalJournalIssueComponent setVolumeElement(StringType value) {
            this.volume = value;
            return this;
        }

        public String getVolume() {
            return this.volume == null ? null : (String)this.volume.getValue();
        }

        public CitationJournalJournalIssueComponent setVolume(String value) {
            if (Utilities.noString(value)) {
                this.volume = null;
            } else {
                if (this.volume == null) {
                    this.volume = new StringType();
                }
                this.volume.setValue(value);
            }
            return this;
        }

        public StringType getIssueElement() {
            if (this.issue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationJournalJournalIssueComponent.issue");
                }
                if (Configuration.doAutoCreate()) {
                    this.issue = new StringType();
                }
            }
            return this.issue;
        }

        public boolean hasIssueElement() {
            return this.issue != null && !this.issue.isEmpty();
        }

        public boolean hasIssue() {
            return this.issue != null && !this.issue.isEmpty();
        }

        public CitationJournalJournalIssueComponent setIssueElement(StringType value) {
            this.issue = value;
            return this;
        }

        public String getIssue() {
            return this.issue == null ? null : (String)this.issue.getValue();
        }

        public CitationJournalJournalIssueComponent setIssue(String value) {
            if (Utilities.noString(value)) {
                this.issue = null;
            } else {
                if (this.issue == null) {
                    this.issue = new StringType();
                }
                this.issue.setValue(value);
            }
            return this;
        }

        public StringType getPublicationDateElement() {
            if (this.publicationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationJournalJournalIssueComponent.publicationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.publicationDate = new StringType();
                }
            }
            return this.publicationDate;
        }

        public boolean hasPublicationDateElement() {
            return this.publicationDate != null && !this.publicationDate.isEmpty();
        }

        public boolean hasPublicationDate() {
            return this.publicationDate != null && !this.publicationDate.isEmpty();
        }

        public CitationJournalJournalIssueComponent setPublicationDateElement(StringType value) {
            this.publicationDate = value;
            return this;
        }

        public String getPublicationDate() {
            return this.publicationDate == null ? null : (String)this.publicationDate.getValue();
        }

        public CitationJournalJournalIssueComponent setPublicationDate(String value) {
            if (Utilities.noString(value)) {
                this.publicationDate = null;
            } else {
                if (this.publicationDate == null) {
                    this.publicationDate = new StringType();
                }
                this.publicationDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("citedMedium", "CodeableConcept", "NLM codes Internet or Print.", 0, 1, this.citedMedium));
            children.add(new Property("volume", "string", "Volume number of journal in which the article is published.", 0, 1, this.volume));
            children.add(new Property("issue", "string", "Issue, part or supplement of journal in which the article is published.", 0, 1, this.issue));
            children.add(new Property("publicationDate", "string", "Date on which the issue of the journal was published.", 0, 1, this.publicationDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 612116418: {
                    return new Property("citedMedium", "CodeableConcept", "NLM codes Internet or Print.", 0, 1, this.citedMedium);
                }
                case -810883302: {
                    return new Property("volume", "string", "Volume number of journal in which the article is published.", 0, 1, this.volume);
                }
                case 100509913: {
                    return new Property("issue", "string", "Issue, part or supplement of journal in which the article is published.", 0, 1, this.issue);
                }
                case 1470566394: {
                    return new Property("publicationDate", "string", "Date on which the issue of the journal was published.", 0, 1, this.publicationDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    Base[] baseArray;
                    if (this.citedMedium == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.citedMedium;
                    }
                    return baseArray;
                }
                case -810883302: {
                    Base[] baseArray;
                    if (this.volume == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.volume;
                    }
                    return baseArray;
                }
                case 100509913: {
                    Base[] baseArray;
                    if (this.issue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.issue;
                    }
                    return baseArray;
                }
                case 1470566394: {
                    Base[] baseArray;
                    if (this.publicationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.publicationDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    this.citedMedium = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -810883302: {
                    this.volume = TypeConvertor.castToString(value);
                    return value;
                }
                case 100509913: {
                    this.issue = TypeConvertor.castToString(value);
                    return value;
                }
                case 1470566394: {
                    this.publicationDate = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("citedMedium")) {
                this.citedMedium = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("volume")) {
                this.volume = TypeConvertor.castToString(value);
            } else if (name.equals("issue")) {
                this.issue = TypeConvertor.castToString(value);
            } else if (name.equals("publicationDate")) {
                this.publicationDate = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    return this.getCitedMedium();
                }
                case -810883302: {
                    return this.getVolumeElement();
                }
                case 100509913: {
                    return this.getIssueElement();
                }
                case 1470566394: {
                    return this.getPublicationDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 612116418: {
                    return new String[]{"CodeableConcept"};
                }
                case -810883302: {
                    return new String[]{"string"};
                }
                case 100509913: {
                    return new String[]{"string"};
                }
                case 1470566394: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("citedMedium")) {
                this.citedMedium = new CodeableConcept();
                return this.citedMedium;
            }
            if (name.equals("volume")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.journal.journalIssue.volume");
            }
            if (name.equals("issue")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.journal.journalIssue.issue");
            }
            if (name.equals("publicationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.journal.journalIssue.publicationDate");
            }
            return super.addChild(name);
        }

        @Override
        public CitationJournalJournalIssueComponent copy() {
            CitationJournalJournalIssueComponent dst = new CitationJournalJournalIssueComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationJournalJournalIssueComponent dst) {
            super.copyValues(dst);
            dst.citedMedium = this.citedMedium == null ? null : this.citedMedium.copy();
            dst.volume = this.volume == null ? null : this.volume.copy();
            dst.issue = this.issue == null ? null : this.issue.copy();
            dst.publicationDate = this.publicationDate == null ? null : this.publicationDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationJournalJournalIssueComponent)) {
                return false;
            }
            CitationJournalJournalIssueComponent o = (CitationJournalJournalIssueComponent)other_;
            return CitationJournalJournalIssueComponent.compareDeep(this.citedMedium, o.citedMedium, true) && CitationJournalJournalIssueComponent.compareDeep(this.volume, o.volume, true) && CitationJournalJournalIssueComponent.compareDeep(this.issue, o.issue, true) && CitationJournalJournalIssueComponent.compareDeep(this.publicationDate, o.publicationDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationJournalJournalIssueComponent)) {
                return false;
            }
            CitationJournalJournalIssueComponent o = (CitationJournalJournalIssueComponent)other_;
            return CitationJournalJournalIssueComponent.compareValues(this.volume, o.volume, true) && CitationJournalJournalIssueComponent.compareValues(this.issue, o.issue, true) && CitationJournalJournalIssueComponent.compareValues(this.publicationDate, o.publicationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.citedMedium, this.volume, this.issue, this.publicationDate);
        }

        @Override
        public String fhirType() {
            return "Citation.journal.journalIssue";
        }
    }

    @Block
    public static class CitationJournalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID", formalDefinition="Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID.")
        protected List<Identifier> identifier;
        @Child(name="country", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Place of publication of the journal", formalDefinition="Place of publication of the journal.")
        protected StringType country;
        @Child(name="journalIssue", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specific issue in which the cited article resides", formalDefinition="The specific issue in which the cited article resides.")
        protected CitationJournalJournalIssueComponent journalIssue;
        @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Journal title", formalDefinition="Journal title.")
        protected StringType title;
        private static final long serialVersionUID = 565129283L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public CitationJournalComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public CitationJournalComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public StringType getCountryElement() {
            if (this.country == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationJournalComponent.country");
                }
                if (Configuration.doAutoCreate()) {
                    this.country = new StringType();
                }
            }
            return this.country;
        }

        public boolean hasCountryElement() {
            return this.country != null && !this.country.isEmpty();
        }

        public boolean hasCountry() {
            return this.country != null && !this.country.isEmpty();
        }

        public CitationJournalComponent setCountryElement(StringType value) {
            this.country = value;
            return this;
        }

        public String getCountry() {
            return this.country == null ? null : (String)this.country.getValue();
        }

        public CitationJournalComponent setCountry(String value) {
            if (Utilities.noString(value)) {
                this.country = null;
            } else {
                if (this.country == null) {
                    this.country = new StringType();
                }
                this.country.setValue(value);
            }
            return this;
        }

        public CitationJournalJournalIssueComponent getJournalIssue() {
            if (this.journalIssue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationJournalComponent.journalIssue");
                }
                if (Configuration.doAutoCreate()) {
                    this.journalIssue = new CitationJournalJournalIssueComponent();
                }
            }
            return this.journalIssue;
        }

        public boolean hasJournalIssue() {
            return this.journalIssue != null && !this.journalIssue.isEmpty();
        }

        public CitationJournalComponent setJournalIssue(CitationJournalJournalIssueComponent value) {
            this.journalIssue = value;
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationJournalComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public CitationJournalComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public CitationJournalComponent setTitle(String value) {
            if (Utilities.noString(value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Citation.SP_IDENTIFIER, "Identifier", "Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("country", "string", "Place of publication of the journal.", 0, 1, this.country));
            children.add(new Property("journalIssue", "", "The specific issue in which the cited article resides.", 0, 1, this.journalIssue));
            children.add(new Property("title", "string", "Journal title.", 0, 1, this.title));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Citation.SP_IDENTIFIER, "Identifier", "Journal identifiers include ISSN, ISO Abbreviation and NLMuniqueID.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 957831062: {
                    return new Property("country", "string", "Place of publication of the journal.", 0, 1, this.country);
                }
                case -716835870: {
                    return new Property("journalIssue", "", "The specific issue in which the cited article resides.", 0, 1, this.journalIssue);
                }
                case 110371416: {
                    return new Property("title", "string", "Journal title.", 0, 1, this.title);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 957831062: {
                    Base[] baseArray;
                    if (this.country == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.country;
                    }
                    return baseArray;
                }
                case -716835870: {
                    Base[] baseArray;
                    if (this.journalIssue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.journalIssue;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.title;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 957831062: {
                    this.country = TypeConvertor.castToString(value);
                    return value;
                }
                case -716835870: {
                    this.journalIssue = (CitationJournalJournalIssueComponent)value;
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Citation.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("country")) {
                this.country = TypeConvertor.castToString(value);
            } else if (name.equals("journalIssue")) {
                this.journalIssue = (CitationJournalJournalIssueComponent)value;
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 957831062: {
                    return this.getCountryElement();
                }
                case -716835870: {
                    return this.getJournalIssue();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 957831062: {
                    return new String[]{"string"};
                }
                case -716835870: {
                    return new String[0];
                }
                case 110371416: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Citation.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("country")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.journal.country");
            }
            if (name.equals("journalIssue")) {
                this.journalIssue = new CitationJournalJournalIssueComponent();
                return this.journalIssue;
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.journal.title");
            }
            return super.addChild(name);
        }

        @Override
        public CitationJournalComponent copy() {
            CitationJournalComponent dst = new CitationJournalComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationJournalComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
            dst.country = this.country == null ? null : this.country.copy();
            dst.journalIssue = this.journalIssue == null ? null : this.journalIssue.copy();
            dst.title = this.title == null ? null : this.title.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationJournalComponent)) {
                return false;
            }
            CitationJournalComponent o = (CitationJournalComponent)other_;
            return CitationJournalComponent.compareDeep(this.identifier, o.identifier, true) && CitationJournalComponent.compareDeep(this.country, o.country, true) && CitationJournalComponent.compareDeep(this.journalIssue, o.journalIssue, true) && CitationJournalComponent.compareDeep(this.title, o.title, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationJournalComponent)) {
                return false;
            }
            CitationJournalComponent o = (CitationJournalComponent)other_;
            return CitationJournalComponent.compareValues(this.country, o.country, true) && CitationJournalComponent.compareValues(this.title, o.title, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.country, this.journalIssue, this.title);
        }

        @Override
        public String fhirType() {
            return "Citation.journal";
        }
    }

    @Block
    public static class CitationVariantCitationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to describe the reason for the variant citation, such as version or subpart specification", formalDefinition="Used to describe the reason for the variant citation, such as version or subpart specification.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/citation-variant-type")
        protected CodeableConcept type;
        @Child(name="value", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Used to describe the specific variation, such as version number or subpart specification", formalDefinition="Used to describe the specific variation, such as version number or subpart specification.")
        protected StringType value;
        @Child(name="baseCitation", type={Citation.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Base citation", formalDefinition="Base citation.")
        protected Reference baseCitation;
        private static final long serialVersionUID = -765350500L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationVariantCitationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CitationVariantCitationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationVariantCitationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public CitationVariantCitationComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public CitationVariantCitationComponent setValue(String value) {
            if (Utilities.noString(value)) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new StringType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public Reference getBaseCitation() {
            if (this.baseCitation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CitationVariantCitationComponent.baseCitation");
                }
                if (Configuration.doAutoCreate()) {
                    this.baseCitation = new Reference();
                }
            }
            return this.baseCitation;
        }

        public boolean hasBaseCitation() {
            return this.baseCitation != null && !this.baseCitation.isEmpty();
        }

        public CitationVariantCitationComponent setBaseCitation(Reference value) {
            this.baseCitation = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Used to describe the reason for the variant citation, such as version or subpart specification.", 0, 1, this.type));
            children.add(new Property("value", "string", "Used to describe the specific variation, such as version number or subpart specification.", 0, 1, this.value));
            children.add(new Property("baseCitation", "Reference(Citation)", "Base citation.", 0, 1, this.baseCitation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Used to describe the reason for the variant citation, such as version or subpart specification.", 0, 1, this.type);
                }
                case 111972721: {
                    return new Property("value", "string", "Used to describe the specific variation, such as version number or subpart specification.", 0, 1, this.value);
                }
                case 1182995672: {
                    return new Property("baseCitation", "Reference(Citation)", "Base citation.", 0, 1, this.baseCitation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 1182995672: {
                    Base[] baseArray;
                    if (this.baseCitation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.baseCitation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
                case 1182995672: {
                    this.baseCitation = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else if (name.equals("baseCitation")) {
                this.baseCitation = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 111972721: {
                    return this.getValueElement();
                }
                case 1182995672: {
                    return this.getBaseCitation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
                case 1182995672: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type Citation.variantCitation.value");
            }
            if (name.equals("baseCitation")) {
                this.baseCitation = new Reference();
                return this.baseCitation;
            }
            return super.addChild(name);
        }

        @Override
        public CitationVariantCitationComponent copy() {
            CitationVariantCitationComponent dst = new CitationVariantCitationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CitationVariantCitationComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.baseCitation = this.baseCitation == null ? null : this.baseCitation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationVariantCitationComponent)) {
                return false;
            }
            CitationVariantCitationComponent o = (CitationVariantCitationComponent)other_;
            return CitationVariantCitationComponent.compareDeep(this.type, o.type, true) && CitationVariantCitationComponent.compareDeep(this.value, o.value, true) && CitationVariantCitationComponent.compareDeep(this.baseCitation, o.baseCitation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CitationVariantCitationComponent)) {
                return false;
            }
            CitationVariantCitationComponent o = (CitationVariantCitationComponent)other_;
            return CitationVariantCitationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value, this.baseCitation);
        }

        @Override
        public String fhirType() {
            return "Citation.variantCitation";
        }
    }
}

