/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.r5.utils.client.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;

public class TextClientLogger
implements ToolingClientLogger {
    private PrintStream file;
    private int id = 0;
    private String lastId;

    public TextClientLogger(String log) {
        if (log != null) {
            try {
                this.file = new PrintStream(new FileOutputStream(log));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void logRequest(String method, String url, List<String> headers, byte[] body) {
        if (this.file == null) {
            return;
        }
        ++this.id;
        this.lastId = Integer.toString(this.id);
        this.file.println("\r\n--- " + this.lastId + " -----------------\r\nRequest: \r\n");
        this.file.println(method + " " + url + " HTTP/1.0");
        for (String s2 : headers) {
            this.file.println(Utilities.escapeXml(s2));
        }
        if (body != null) {
            this.file.println("");
            try {
                this.file.println(Utilities.escapeXml(new String(body, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    @Override
    public void logResponse(String outcome, List<String> headers, byte[] body) {
        if (this.file == null) {
            return;
        }
        this.file.println("\r\n\r\nResponse: \r\n");
        this.file.println(outcome);
        for (String s2 : headers) {
            this.file.println(Utilities.escapeXml(s2));
        }
        if (body != null) {
            this.file.println("");
            try {
                this.file.println(Utilities.escapeXml(new String(body, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getLastId() {
        return this.lastId;
    }

    @Override
    public void clearLastId() {
        this.lastId = null;
    }
}

