/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VerificationresultCommunicationMethod {
    MANUAL,
    PORTAL,
    PULL,
    PUSH,
    NULL;


    public static VerificationresultCommunicationMethod fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("manual".equals(codeString)) {
            return MANUAL;
        }
        if ("portal".equals(codeString)) {
            return PORTAL;
        }
        if ("pull".equals(codeString)) {
            return PULL;
        }
        if ("push".equals(codeString)) {
            return PUSH;
        }
        throw new FHIRException("Unknown VerificationresultCommunicationMethod code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MANUAL: {
                return "manual";
            }
            case PORTAL: {
                return "portal";
            }
            case PULL: {
                return "pull";
            }
            case PUSH: {
                return "push";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/verificationresult-communication-method";
    }

    public String getDefinition() {
        switch (this) {
            case MANUAL: {
                return "The information is submitted/retrieved manually (e.g. by phone, fax, paper-based)";
            }
            case PORTAL: {
                return "The information is submitted/retrieved via a portal";
            }
            case PULL: {
                return "The information is retrieved (i.e. pulled) from a source (e.g. over an API)";
            }
            case PUSH: {
                return "The information is sent (i.e. pushed) from a source (e.g. over an API, asynchronously, secure messaging)";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MANUAL: {
                return "Manual";
            }
            case PORTAL: {
                return "Portal";
            }
            case PULL: {
                return "Pull";
            }
            case PUSH: {
                return "Push";
            }
        }
        return "?";
    }
}

