/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Tldc {
    DRAFT,
    PENDING,
    ACTIVE,
    REVIEW,
    CANCELLED,
    REJECTED,
    RETIRED,
    TERMINATED,
    NULL;


    public static Tldc fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("pending".equals(codeString)) {
            return PENDING;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("review".equals(codeString)) {
            return REVIEW;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("rejected".equals(codeString)) {
            return REJECTED;
        }
        if ("retired".equals(codeString)) {
            return RETIRED;
        }
        if ("terminated".equals(codeString)) {
            return TERMINATED;
        }
        throw new FHIRException("Unknown Tldc code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case PENDING: {
                return "pending";
            }
            case ACTIVE: {
                return "active";
            }
            case REVIEW: {
                return "review";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case REJECTED: {
                return "rejected";
            }
            case RETIRED: {
                return "retired";
            }
            case TERMINATED: {
                return "terminated";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "urn:oid:2.16.840.1.113883.3.1937.98.5.8";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "Design is under development (nascent).";
            }
            case PENDING: {
                return "Design is completed and is being reviewed.";
            }
            case ACTIVE: {
                return "Design has been deemed fit for the intended purpose and is published by the governance group.";
            }
            case REVIEW: {
                return "Design is active, but is under review. The review may result in a change to the design. The change may necessitate a new version to be created. This in turn may result in the prior version of the template to be retired. Alternatively, the review may result in a change to the design that does not require a new version to be created, or it may result in no change to the design at all.";
            }
            case CANCELLED: {
                return "A drafted design is determined to be erroneous or not fit for intended purpose and is discontinued before ever being published in an active state.";
            }
            case REJECTED: {
                return "A previously drafted design is determined to be erroneous or not fit for intended purpose and is discontinued before ever being published for consideration in a pending state.";
            }
            case RETIRED: {
                return "A previously active design is discontinued from use. It should no longer be used for future designs, but for historical purposes may be used to process data previously recorded using this design. A newer design may or may not exist. The design is published in the retired state.";
            }
            case TERMINATED: {
                return "A design is determined to be erroneous or not fit for the intended purpose and should no longer be used, even for historical purposes. No new designs can be developed for this template. The associated template no longer needs to be published, but if published, is shown in the terminated state.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case PENDING: {
                return "Under pre-publication review";
            }
            case ACTIVE: {
                return "active";
            }
            case REVIEW: {
                return "In Review";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case REJECTED: {
                return "Rejected";
            }
            case RETIRED: {
                return "retired";
            }
            case TERMINATED: {
                return "Terminated";
            }
        }
        return "?";
    }
}

