/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum TaskIntent {
    UNKNOWN,
    NULL;


    public static TaskIntent fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown TaskIntent code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/task-intent";
    }

    public String getDefinition() {
        switch (this) {
            case UNKNOWN: {
                return "The intent is not known.  When dealing with Task, it's not always known (or relevant) how the task was initiated - i.e. whether it was proposed, planned, ordered or just done spontaneously.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

