/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SupplyrequestStatus {
    DRAFT,
    ACTIVE,
    SUSPENDED,
    CANCELLED,
    COMPLETED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static SupplyrequestStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown SupplyrequestStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ACTIVE: {
                return "active";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/supplyrequest-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "The request has been created but is not yet complete or ready for action.";
            }
            case ACTIVE: {
                return "The request is ready to be acted upon.";
            }
            case SUSPENDED: {
                return "The authorization/request to act has been temporarily withdrawn but is expected to resume in the future.";
            }
            case CANCELLED: {
                return "The authorization/request to act has been terminated prior to the full completion of the intended actions.  No further activity should occur.";
            }
            case COMPLETED: {
                return "Activity against the request has been sufficiently completed to the satisfaction of the requester.";
            }
            case ENTEREDINERROR: {
                return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
            }
            case UNKNOWN: {
                return "The authoring/source system does not know which of the status values currently applies for this observation. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring/source system does not know which.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case ACTIVE: {
                return "Active";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

