/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ReferenceVersionRules {
    EITHER,
    INDEPENDENT,
    SPECIFIC,
    NULL;


    public static ReferenceVersionRules fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("either".equals(codeString)) {
            return EITHER;
        }
        if ("independent".equals(codeString)) {
            return INDEPENDENT;
        }
        if ("specific".equals(codeString)) {
            return SPECIFIC;
        }
        throw new FHIRException("Unknown ReferenceVersionRules code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EITHER: {
                return "either";
            }
            case INDEPENDENT: {
                return "independent";
            }
            case SPECIFIC: {
                return "specific";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/reference-version-rules";
    }

    public String getDefinition() {
        switch (this) {
            case EITHER: {
                return "The reference may be either version independent or version specific.";
            }
            case INDEPENDENT: {
                return "The reference must be version independent.";
            }
            case SPECIFIC: {
                return "The reference must be version specific.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EITHER: {
                return "Either Specific or independent";
            }
            case INDEPENDENT: {
                return "Version independent";
            }
            case SPECIFIC: {
                return "Version Specific";
            }
        }
        return "?";
    }
}

