/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.MeasurePopulation;

public class MeasurePopulationEnumFactory
implements EnumFactory<MeasurePopulation> {
    @Override
    public MeasurePopulation fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("initial-population".equals(codeString)) {
            return MeasurePopulation.INITIALPOPULATION;
        }
        if ("numerator".equals(codeString)) {
            return MeasurePopulation.NUMERATOR;
        }
        if ("numerator-exclusion".equals(codeString)) {
            return MeasurePopulation.NUMERATOREXCLUSION;
        }
        if ("denominator".equals(codeString)) {
            return MeasurePopulation.DENOMINATOR;
        }
        if ("denominator-exclusion".equals(codeString)) {
            return MeasurePopulation.DENOMINATOREXCLUSION;
        }
        if ("denominator-exception".equals(codeString)) {
            return MeasurePopulation.DENOMINATOREXCEPTION;
        }
        if ("measure-population".equals(codeString)) {
            return MeasurePopulation.MEASUREPOPULATION;
        }
        if ("measure-population-exclusion".equals(codeString)) {
            return MeasurePopulation.MEASUREPOPULATIONEXCLUSION;
        }
        if ("measure-observation".equals(codeString)) {
            return MeasurePopulation.MEASUREOBSERVATION;
        }
        throw new IllegalArgumentException("Unknown MeasurePopulation code '" + codeString + "'");
    }

    @Override
    public String toCode(MeasurePopulation code) {
        if (code == MeasurePopulation.INITIALPOPULATION) {
            return "initial-population";
        }
        if (code == MeasurePopulation.NUMERATOR) {
            return "numerator";
        }
        if (code == MeasurePopulation.NUMERATOREXCLUSION) {
            return "numerator-exclusion";
        }
        if (code == MeasurePopulation.DENOMINATOR) {
            return "denominator";
        }
        if (code == MeasurePopulation.DENOMINATOREXCLUSION) {
            return "denominator-exclusion";
        }
        if (code == MeasurePopulation.DENOMINATOREXCEPTION) {
            return "denominator-exception";
        }
        if (code == MeasurePopulation.MEASUREPOPULATION) {
            return "measure-population";
        }
        if (code == MeasurePopulation.MEASUREPOPULATIONEXCLUSION) {
            return "measure-population-exclusion";
        }
        if (code == MeasurePopulation.MEASUREOBSERVATION) {
            return "measure-observation";
        }
        return "?";
    }

    @Override
    public String toSystem(MeasurePopulation code) {
        return code.getSystem();
    }
}

