/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MapGroupTypeMode {
    NONE,
    TYPES,
    TYPEANDTYPES,
    NULL;


    public static MapGroupTypeMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("none".equals(codeString)) {
            return NONE;
        }
        if ("types".equals(codeString)) {
            return TYPES;
        }
        if ("type-and-types".equals(codeString)) {
            return TYPEANDTYPES;
        }
        throw new FHIRException("Unknown MapGroupTypeMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NONE: {
                return "none";
            }
            case TYPES: {
                return "types";
            }
            case TYPEANDTYPES: {
                return "type-and-types";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/map-group-type-mode";
    }

    public String getDefinition() {
        switch (this) {
            case NONE: {
                return "This group is not a default group for the types.";
            }
            case TYPES: {
                return "This group is a default mapping group for the specified types and for the primary source type.";
            }
            case TYPEANDTYPES: {
                return "This group is a default mapping group for the specified types.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NONE: {
                return "Not a Default";
            }
            case TYPES: {
                return "Default for Type Combination";
            }
            case TYPEANDTYPES: {
                return "Default for type + combination";
            }
        }
        return "?";
    }
}

