/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GraphCompartmentUse {
    CONDITION,
    REQUIREMENT,
    NULL;


    public static GraphCompartmentUse fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("condition".equals(codeString)) {
            return CONDITION;
        }
        if ("requirement".equals(codeString)) {
            return REQUIREMENT;
        }
        throw new FHIRException("Unknown GraphCompartmentUse code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CONDITION: {
                return "condition";
            }
            case REQUIREMENT: {
                return "requirement";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/graph-compartment-use";
    }

    public String getDefinition() {
        switch (this) {
            case CONDITION: {
                return "This compartment rule is a condition for whether the rule applies.";
            }
            case REQUIREMENT: {
                return "This compartment rule is enforced on any relationships that meet the conditions.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CONDITION: {
                return "Condition";
            }
            case REQUIREMENT: {
                return "Requirement";
            }
        }
        return "?";
    }
}

