/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EvidenceVariantState {
    LOWRISK,
    MEDIUMRISK,
    HIGHRISK,
    NULL;


    public static EvidenceVariantState fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("low-risk".equals(codeString)) {
            return LOWRISK;
        }
        if ("medium-risk".equals(codeString)) {
            return MEDIUMRISK;
        }
        if ("high-risk".equals(codeString)) {
            return HIGHRISK;
        }
        throw new FHIRException("Unknown EvidenceVariantState code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LOWRISK: {
                return "low-risk";
            }
            case MEDIUMRISK: {
                return "medium-risk";
            }
            case HIGHRISK: {
                return "high-risk";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/evidence-variant-state";
    }

    public String getDefinition() {
        switch (this) {
            case LOWRISK: {
                return "low risk estimate.";
            }
            case MEDIUMRISK: {
                return "medium risk estimate.";
            }
            case HIGHRISK: {
                return "high risk estimate.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LOWRISK: {
                return "low risk";
            }
            case MEDIUMRISK: {
                return "medium risk";
            }
            case HIGHRISK: {
                return "high risk";
            }
        }
        return "?";
    }
}

