/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EncounterStatus {
    PLANNED,
    ARRIVED,
    TRIAGED,
    INPROGRESS,
    ONLEAVE,
    FINISHED,
    CANCELLED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static EncounterStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("planned".equals(codeString)) {
            return PLANNED;
        }
        if ("arrived".equals(codeString)) {
            return ARRIVED;
        }
        if ("triaged".equals(codeString)) {
            return TRIAGED;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("onleave".equals(codeString)) {
            return ONLEAVE;
        }
        if ("finished".equals(codeString)) {
            return FINISHED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown EncounterStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PLANNED: {
                return "planned";
            }
            case ARRIVED: {
                return "arrived";
            }
            case TRIAGED: {
                return "triaged";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case ONLEAVE: {
                return "onleave";
            }
            case FINISHED: {
                return "finished";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/encounter-status";
    }

    public String getDefinition() {
        switch (this) {
            case PLANNED: {
                return "The Encounter has not yet started.";
            }
            case ARRIVED: {
                return "The Patient is present for the encounter, however is not currently meeting with a practitioner.";
            }
            case TRIAGED: {
                return "The patient has been assessed for the priority of their treatment based on the severity of their condition.";
            }
            case INPROGRESS: {
                return "The Encounter has begun and the patient is present / the practitioner and the patient are meeting.";
            }
            case ONLEAVE: {
                return "The Encounter has begun, but the patient is temporarily on leave.";
            }
            case FINISHED: {
                return "The Encounter has ended.";
            }
            case CANCELLED: {
                return "The Encounter has ended before it has begun.";
            }
            case ENTEREDINERROR: {
                return "This instance should not have been part of this patient's medical record.";
            }
            case UNKNOWN: {
                return "The encounter status is unknown. Note that \"unknown\" is a value of last resort and every attempt should be made to provide a meaningful value other than \"unknown\".";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PLANNED: {
                return "Planned";
            }
            case ARRIVED: {
                return "Arrived";
            }
            case TRIAGED: {
                return "Triaged";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case ONLEAVE: {
                return "On Leave";
            }
            case FINISHED: {
                return "Finished";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

