/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractAction {
    ACTIONA,
    ACTIONB,
    NULL;


    public static ContractAction fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("action-a".equals(codeString)) {
            return ACTIONA;
        }
        if ("action-b".equals(codeString)) {
            return ACTIONB;
        }
        throw new FHIRException("Unknown ContractAction code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIONA: {
                return "action-a";
            }
            case ACTIONB: {
                return "action-b";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/contractaction";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIONA: {
                return "Definition for Action A";
            }
            case ACTIONB: {
                return "Definition for Action B";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIONA: {
                return "Action A";
            }
            case ACTIONB: {
                return "Action B";
            }
        }
        return "?";
    }
}

