/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PaymentReconciliation", profile="http://hl7.org/fhir/StructureDefinition/PaymentReconciliation")
public class PaymentReconciliation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier for a payment reconciliation", formalDefinition="A unique identifier assigned to this payment reconciliation.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<PaymentReconciliationStatus> status;
    @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period covered", formalDefinition="The period of time for which payments have been gathered into this bulk payment for settlement.")
    protected Period period;
    @Child(name="created", type={DateTimeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the resource was created.")
    protected DateTimeType created;
    @Child(name="paymentIssuer", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Party generating payment", formalDefinition="The party who generated the payment.")
    protected Reference paymentIssuer;
    protected Organization paymentIssuerTarget;
    @Child(name="request", type={Task.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to requesting resource", formalDefinition="Original request resource reference.")
    protected Reference request;
    protected Task requestTarget;
    @Child(name="requestor", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestor;
    protected Resource requestorTarget;
    @Child(name="outcome", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="queued | complete | error | partial", formalDefinition="The outcome of a request for a reconciliation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome")
    protected Enumeration<Enumerations.RemittanceOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition message", formalDefinition="A human readable description of the status of the request for the reconciliation.")
    protected StringType disposition;
    @Child(name="paymentDate", type={DateType.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When payment issued", formalDefinition="The date of payment as indicated on the financial instrument.")
    protected DateType paymentDate;
    @Child(name="paymentAmount", type={Money.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total amount of Payment", formalDefinition="Total payment amount as indicated on the financial instrument.")
    protected Money paymentAmount;
    @Child(name="paymentIdentifier", type={Identifier.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Business identifier for the payment", formalDefinition="Issuer's unique identifier for the payment instrument.")
    protected Identifier paymentIdentifier;
    @Child(name="detail", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Settlement particulars", formalDefinition="Distribution of the payment amount for a previously acknowledged payable.")
    protected List<DetailsComponent> detail;
    @Child(name="formCode", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed form identifier", formalDefinition="A code for the form to be used for printing the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/forms")
    protected CodeableConcept formCode;
    @Child(name="processNote", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Note concerning processing", formalDefinition="A note that describes or explains the processing in a human readable form.")
    protected List<NotesComponent> processNote;
    private static final long serialVersionUID = -1620965037L;
    @SearchParamDefinition(name="identifier", path="PaymentReconciliation.identifier", description="The business identifier of the ExplanationOfBenefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="PaymentReconciliation.request", description="The reference to the claim", type="reference", target={Task.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("PaymentReconciliation:request").toLocked();
    @SearchParamDefinition(name="disposition", path="PaymentReconciliation.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");
    @SearchParamDefinition(name="created", path="PaymentReconciliation.created", description="The creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="payment-issuer", path="PaymentReconciliation.paymentIssuer", description="The organization which generated this resource", type="reference", target={Organization.class})
    public static final String SP_PAYMENT_ISSUER = "payment-issuer";
    public static final ReferenceClientParam PAYMENT_ISSUER = new ReferenceClientParam("payment-issuer");
    public static final Include INCLUDE_PAYMENT_ISSUER = new Include("PaymentReconciliation:payment-issuer").toLocked();
    @SearchParamDefinition(name="outcome", path="PaymentReconciliation.outcome", description="The processing outcome", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="requestor", path="PaymentReconciliation.requestor", description="The reference to the provider who submitted the claim", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_REQUESTOR = "requestor";
    public static final ReferenceClientParam REQUESTOR = new ReferenceClientParam("requestor");
    public static final Include INCLUDE_REQUESTOR = new Include("PaymentReconciliation:requestor").toLocked();
    @SearchParamDefinition(name="status", path="PaymentReconciliation.status", description="The status of the payment reconciliation", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public PaymentReconciliation() {
    }

    public PaymentReconciliation(Enumeration<PaymentReconciliationStatus> status, DateTimeType created, DateType paymentDate, Money paymentAmount) {
        this.status = status;
        this.created = created;
        this.paymentDate = paymentDate;
        this.paymentAmount = paymentAmount;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public PaymentReconciliation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PaymentReconciliation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<PaymentReconciliationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<PaymentReconciliationStatus>(new PaymentReconciliationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public PaymentReconciliation setStatusElement(Enumeration<PaymentReconciliationStatus> value) {
        this.status = value;
        return this;
    }

    public PaymentReconciliationStatus getStatus() {
        return this.status == null ? null : (PaymentReconciliationStatus)((Object)this.status.getValue());
    }

    public PaymentReconciliation setStatus(PaymentReconciliationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<PaymentReconciliationStatus>(new PaymentReconciliationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public PaymentReconciliation setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public PaymentReconciliation setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public PaymentReconciliation setCreated(Date value) {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        this.created.setValue(value);
        return this;
    }

    public Reference getPaymentIssuer() {
        if (this.paymentIssuer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.paymentIssuer");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentIssuer = new Reference();
            }
        }
        return this.paymentIssuer;
    }

    public boolean hasPaymentIssuer() {
        return this.paymentIssuer != null && !this.paymentIssuer.isEmpty();
    }

    public PaymentReconciliation setPaymentIssuer(Reference value) {
        this.paymentIssuer = value;
        return this;
    }

    public Organization getPaymentIssuerTarget() {
        if (this.paymentIssuerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.paymentIssuer");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentIssuerTarget = new Organization();
            }
        }
        return this.paymentIssuerTarget;
    }

    public PaymentReconciliation setPaymentIssuerTarget(Organization value) {
        this.paymentIssuerTarget = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public PaymentReconciliation setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Task getRequestTarget() {
        if (this.requestTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.request");
            }
            if (Configuration.doAutoCreate()) {
                this.requestTarget = new Task();
            }
        }
        return this.requestTarget;
    }

    public PaymentReconciliation setRequestTarget(Task value) {
        this.requestTarget = value;
        return this;
    }

    public Reference getRequestor() {
        if (this.requestor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.requestor");
            }
            if (Configuration.doAutoCreate()) {
                this.requestor = new Reference();
            }
        }
        return this.requestor;
    }

    public boolean hasRequestor() {
        return this.requestor != null && !this.requestor.isEmpty();
    }

    public PaymentReconciliation setRequestor(Reference value) {
        this.requestor = value;
        return this;
    }

    public Resource getRequestorTarget() {
        return this.requestorTarget;
    }

    public PaymentReconciliation setRequestorTarget(Resource value) {
        this.requestorTarget = value;
        return this;
    }

    public Enumeration<Enumerations.RemittanceOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public PaymentReconciliation setOutcomeElement(Enumeration<Enumerations.RemittanceOutcome> value) {
        this.outcome = value;
        return this;
    }

    public Enumerations.RemittanceOutcome getOutcome() {
        return this.outcome == null ? null : (Enumerations.RemittanceOutcome)((Object)this.outcome.getValue());
    }

    public PaymentReconciliation setOutcome(Enumerations.RemittanceOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public PaymentReconciliation setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public PaymentReconciliation setDisposition(String value) {
        if (Utilities.noString(value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public DateType getPaymentDateElement() {
        if (this.paymentDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.paymentDate");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentDate = new DateType();
            }
        }
        return this.paymentDate;
    }

    public boolean hasPaymentDateElement() {
        return this.paymentDate != null && !this.paymentDate.isEmpty();
    }

    public boolean hasPaymentDate() {
        return this.paymentDate != null && !this.paymentDate.isEmpty();
    }

    public PaymentReconciliation setPaymentDateElement(DateType value) {
        this.paymentDate = value;
        return this;
    }

    public Date getPaymentDate() {
        return this.paymentDate == null ? null : (Date)this.paymentDate.getValue();
    }

    public PaymentReconciliation setPaymentDate(Date value) {
        if (this.paymentDate == null) {
            this.paymentDate = new DateType();
        }
        this.paymentDate.setValue(value);
        return this;
    }

    public Money getPaymentAmount() {
        if (this.paymentAmount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.paymentAmount");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentAmount = new Money();
            }
        }
        return this.paymentAmount;
    }

    public boolean hasPaymentAmount() {
        return this.paymentAmount != null && !this.paymentAmount.isEmpty();
    }

    public PaymentReconciliation setPaymentAmount(Money value) {
        this.paymentAmount = value;
        return this;
    }

    public Identifier getPaymentIdentifier() {
        if (this.paymentIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.paymentIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentIdentifier = new Identifier();
            }
        }
        return this.paymentIdentifier;
    }

    public boolean hasPaymentIdentifier() {
        return this.paymentIdentifier != null && !this.paymentIdentifier.isEmpty();
    }

    public PaymentReconciliation setPaymentIdentifier(Identifier value) {
        this.paymentIdentifier = value;
        return this;
    }

    public List<DetailsComponent> getDetail() {
        if (this.detail == null) {
            this.detail = new ArrayList<DetailsComponent>();
        }
        return this.detail;
    }

    public PaymentReconciliation setDetail(List<DetailsComponent> theDetail) {
        this.detail = theDetail;
        return this;
    }

    public boolean hasDetail() {
        if (this.detail == null) {
            return false;
        }
        for (DetailsComponent item : this.detail) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DetailsComponent addDetail() {
        DetailsComponent t = new DetailsComponent();
        if (this.detail == null) {
            this.detail = new ArrayList<DetailsComponent>();
        }
        this.detail.add(t);
        return t;
    }

    public PaymentReconciliation addDetail(DetailsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.detail == null) {
            this.detail = new ArrayList<DetailsComponent>();
        }
        this.detail.add(t);
        return this;
    }

    public DetailsComponent getDetailFirstRep() {
        if (this.getDetail().isEmpty()) {
            this.addDetail();
        }
        return this.getDetail().get(0);
    }

    public CodeableConcept getFormCode() {
        if (this.formCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.formCode");
            }
            if (Configuration.doAutoCreate()) {
                this.formCode = new CodeableConcept();
            }
        }
        return this.formCode;
    }

    public boolean hasFormCode() {
        return this.formCode != null && !this.formCode.isEmpty();
    }

    public PaymentReconciliation setFormCode(CodeableConcept value) {
        this.formCode = value;
        return this;
    }

    public List<NotesComponent> getProcessNote() {
        if (this.processNote == null) {
            this.processNote = new ArrayList<NotesComponent>();
        }
        return this.processNote;
    }

    public PaymentReconciliation setProcessNote(List<NotesComponent> theProcessNote) {
        this.processNote = theProcessNote;
        return this;
    }

    public boolean hasProcessNote() {
        if (this.processNote == null) {
            return false;
        }
        for (NotesComponent item : this.processNote) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NotesComponent addProcessNote() {
        NotesComponent t = new NotesComponent();
        if (this.processNote == null) {
            this.processNote = new ArrayList<NotesComponent>();
        }
        this.processNote.add(t);
        return t;
    }

    public PaymentReconciliation addProcessNote(NotesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processNote == null) {
            this.processNote = new ArrayList<NotesComponent>();
        }
        this.processNote.add(t);
        return this;
    }

    public NotesComponent getProcessNoteFirstRep() {
        if (this.getProcessNote().isEmpty()) {
            this.addProcessNote();
        }
        return this.getProcessNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this payment reconciliation.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("period", "Period", "The period of time for which payments have been gathered into this bulk payment for settlement.", 0, 1, this.period));
        children.add(new Property(SP_CREATED, "dateTime", "The date when the resource was created.", 0, 1, this.created));
        children.add(new Property("paymentIssuer", "Reference(Organization)", "The party who generated the payment.", 0, 1, this.paymentIssuer));
        children.add(new Property(SP_REQUEST, "Reference(Task)", "Original request resource reference.", 0, 1, this.request));
        children.add(new Property(SP_REQUESTOR, "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestor));
        children.add(new Property(SP_OUTCOME, "code", "The outcome of a request for a reconciliation.", 0, 1, this.outcome));
        children.add(new Property(SP_DISPOSITION, "string", "A human readable description of the status of the request for the reconciliation.", 0, 1, this.disposition));
        children.add(new Property("paymentDate", "date", "The date of payment as indicated on the financial instrument.", 0, 1, this.paymentDate));
        children.add(new Property("paymentAmount", "Money", "Total payment amount as indicated on the financial instrument.", 0, 1, this.paymentAmount));
        children.add(new Property("paymentIdentifier", "Identifier", "Issuer's unique identifier for the payment instrument.", 0, 1, this.paymentIdentifier));
        children.add(new Property("detail", "", "Distribution of the payment amount for a previously acknowledged payable.", 0, Integer.MAX_VALUE, this.detail));
        children.add(new Property("formCode", "CodeableConcept", "A code for the form to be used for printing the content.", 0, 1, this.formCode));
        children.add(new Property("processNote", "", "A note that describes or explains the processing in a human readable form.", 0, Integer.MAX_VALUE, this.processNote));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this payment reconciliation.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case -991726143: {
                return new Property("period", "Period", "The period of time for which payments have been gathered into this bulk payment for settlement.", 0, 1, this.period);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when the resource was created.", 0, 1, this.created);
            }
            case 1144026207: {
                return new Property("paymentIssuer", "Reference(Organization)", "The party who generated the payment.", 0, 1, this.paymentIssuer);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(Task)", "Original request resource reference.", 0, 1, this.request);
            }
            case 693934258: {
                return new Property(SP_REQUESTOR, "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestor);
            }
            case -1106507950: {
                return new Property(SP_OUTCOME, "code", "The outcome of a request for a reconciliation.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property(SP_DISPOSITION, "string", "A human readable description of the status of the request for the reconciliation.", 0, 1, this.disposition);
            }
            case -1540873516: {
                return new Property("paymentDate", "date", "The date of payment as indicated on the financial instrument.", 0, 1, this.paymentDate);
            }
            case 909332990: {
                return new Property("paymentAmount", "Money", "Total payment amount as indicated on the financial instrument.", 0, 1, this.paymentAmount);
            }
            case 1555852111: {
                return new Property("paymentIdentifier", "Identifier", "Issuer's unique identifier for the payment instrument.", 0, 1, this.paymentIdentifier);
            }
            case -1335224239: {
                return new Property("detail", "", "Distribution of the payment amount for a previously acknowledged payable.", 0, Integer.MAX_VALUE, this.detail);
            }
            case 473181393: {
                return new Property("formCode", "CodeableConcept", "A code for the form to be used for printing the content.", 0, 1, this.formCode);
            }
            case 202339073: {
                return new Property("processNote", "", "A note that describes or explains the processing in a human readable form.", 0, Integer.MAX_VALUE, this.processNote);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.period;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.created;
                }
                return baseArray;
            }
            case 1144026207: {
                Base[] baseArray;
                if (this.paymentIssuer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.paymentIssuer;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.request;
                }
                return baseArray;
            }
            case 693934258: {
                Base[] baseArray;
                if (this.requestor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.requestor;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.disposition;
                }
                return baseArray;
            }
            case -1540873516: {
                Base[] baseArray;
                if (this.paymentDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.paymentDate;
                }
                return baseArray;
            }
            case 909332990: {
                Base[] baseArray;
                if (this.paymentAmount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.paymentAmount;
                }
                return baseArray;
            }
            case 1555852111: {
                Base[] baseArray;
                if (this.paymentIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.paymentIdentifier;
                }
                return baseArray;
            }
            case -1335224239: {
                return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
            }
            case 473181393: {
                Base[] baseArray;
                if (this.formCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.formCode;
                }
                return baseArray;
            }
            case 202339073: {
                return this.processNote == null ? new Base[]{} : this.processNote.toArray(new Base[this.processNote.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new PaymentReconciliationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case 1144026207: {
                this.paymentIssuer = this.castToReference(value);
                return value;
            }
            case 1095692943: {
                this.request = this.castToReference(value);
                return value;
            }
            case 693934258: {
                this.requestor = this.castToReference(value);
                return value;
            }
            case -1106507950: {
                value = new Enumerations.RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                return value;
            }
            case -1540873516: {
                this.paymentDate = this.castToDate(value);
                return value;
            }
            case 909332990: {
                this.paymentAmount = this.castToMoney(value);
                return value;
            }
            case 1555852111: {
                this.paymentIdentifier = this.castToIdentifier(value);
                return value;
            }
            case -1335224239: {
                this.getDetail().add((DetailsComponent)((Object)value));
                return value;
            }
            case 473181393: {
                this.formCode = this.castToCodeableConcept(value);
                return value;
            }
            case 202339073: {
                this.getProcessNote().add((NotesComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new PaymentReconciliationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("paymentIssuer")) {
            this.paymentIssuer = this.castToReference(value);
        } else if (name.equals(SP_REQUEST)) {
            this.request = this.castToReference(value);
        } else if (name.equals(SP_REQUESTOR)) {
            this.requestor = this.castToReference(value);
        } else if (name.equals(SP_OUTCOME)) {
            value = new Enumerations.RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
            this.outcome = value;
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = this.castToString(value);
        } else if (name.equals("paymentDate")) {
            this.paymentDate = this.castToDate(value);
        } else if (name.equals("paymentAmount")) {
            this.paymentAmount = this.castToMoney(value);
        } else if (name.equals("paymentIdentifier")) {
            this.paymentIdentifier = this.castToIdentifier(value);
        } else if (name.equals("detail")) {
            this.getDetail().add((DetailsComponent)((Object)value));
        } else if (name.equals("formCode")) {
            this.formCode = this.castToCodeableConcept(value);
        } else if (name.equals("processNote")) {
            this.getProcessNote().add((NotesComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1144026207: {
                return this.getPaymentIssuer();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case 693934258: {
                return this.getRequestor();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case -1540873516: {
                return this.getPaymentDateElement();
            }
            case 909332990: {
                return this.getPaymentAmount();
            }
            case 1555852111: {
                return this.getPaymentIdentifier();
            }
            case -1335224239: {
                return this.addDetail();
            }
            case 473181393: {
                return this.getFormCode();
            }
            case 202339073: {
                return this.addProcessNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1144026207: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case 693934258: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case -1540873516: {
                return new String[]{"date"};
            }
            case 909332990: {
                return new String[]{"Money"};
            }
            case 1555852111: {
                return new String[]{"Identifier"};
            }
            case -1335224239: {
                return new String[0];
            }
            case 473181393: {
                return new String[]{"CodeableConcept"};
            }
            case 202339073: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.status");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.created");
        }
        if (name.equals("paymentIssuer")) {
            this.paymentIssuer = new Reference();
            return this.paymentIssuer;
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_REQUESTOR)) {
            this.requestor = new Reference();
            return this.requestor;
        }
        if (name.equals(SP_OUTCOME)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.outcome");
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.disposition");
        }
        if (name.equals("paymentDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.paymentDate");
        }
        if (name.equals("paymentAmount")) {
            this.paymentAmount = new Money();
            return this.paymentAmount;
        }
        if (name.equals("paymentIdentifier")) {
            this.paymentIdentifier = new Identifier();
            return this.paymentIdentifier;
        }
        if (name.equals("detail")) {
            return this.addDetail();
        }
        if (name.equals("formCode")) {
            this.formCode = new CodeableConcept();
            return this.formCode;
        }
        if (name.equals("processNote")) {
            return this.addProcessNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PaymentReconciliation";
    }

    @Override
    public PaymentReconciliation copy() {
        PaymentReconciliation dst = new PaymentReconciliation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PaymentReconciliation dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.paymentIssuer = this.paymentIssuer == null ? null : this.paymentIssuer.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.requestor = this.requestor == null ? null : this.requestor.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.paymentDate = this.paymentDate == null ? null : this.paymentDate.copy();
        dst.paymentAmount = this.paymentAmount == null ? null : this.paymentAmount.copy();
        Identifier identifier = dst.paymentIdentifier = this.paymentIdentifier == null ? null : this.paymentIdentifier.copy();
        if (this.detail != null) {
            dst.detail = new ArrayList<DetailsComponent>();
            for (DetailsComponent detailsComponent : this.detail) {
                dst.detail.add(detailsComponent.copy());
            }
        }
        CodeableConcept codeableConcept = dst.formCode = this.formCode == null ? null : this.formCode.copy();
        if (this.processNote != null) {
            dst.processNote = new ArrayList<NotesComponent>();
            for (NotesComponent notesComponent : this.processNote) {
                dst.processNote.add(notesComponent.copy());
            }
        }
    }

    protected PaymentReconciliation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PaymentReconciliation)) {
            return false;
        }
        PaymentReconciliation o = (PaymentReconciliation)other_;
        return PaymentReconciliation.compareDeep(this.identifier, o.identifier, true) && PaymentReconciliation.compareDeep(this.status, o.status, true) && PaymentReconciliation.compareDeep(this.period, o.period, true) && PaymentReconciliation.compareDeep(this.created, o.created, true) && PaymentReconciliation.compareDeep(this.paymentIssuer, o.paymentIssuer, true) && PaymentReconciliation.compareDeep(this.request, o.request, true) && PaymentReconciliation.compareDeep(this.requestor, o.requestor, true) && PaymentReconciliation.compareDeep(this.outcome, o.outcome, true) && PaymentReconciliation.compareDeep(this.disposition, o.disposition, true) && PaymentReconciliation.compareDeep(this.paymentDate, o.paymentDate, true) && PaymentReconciliation.compareDeep(this.paymentAmount, o.paymentAmount, true) && PaymentReconciliation.compareDeep(this.paymentIdentifier, o.paymentIdentifier, true) && PaymentReconciliation.compareDeep(this.detail, o.detail, true) && PaymentReconciliation.compareDeep(this.formCode, o.formCode, true) && PaymentReconciliation.compareDeep(this.processNote, o.processNote, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PaymentReconciliation)) {
            return false;
        }
        PaymentReconciliation o = (PaymentReconciliation)other_;
        return PaymentReconciliation.compareValues(this.status, o.status, true) && PaymentReconciliation.compareValues(this.created, o.created, true) && PaymentReconciliation.compareValues(this.outcome, o.outcome, true) && PaymentReconciliation.compareValues(this.disposition, o.disposition, true) && PaymentReconciliation.compareValues(this.paymentDate, o.paymentDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.period, this.created, this.paymentIssuer, this.request, this.requestor, this.outcome, this.disposition, this.paymentDate, this.paymentAmount, this.paymentIdentifier, this.detail, this.formCode, this.processNote);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PaymentReconciliation;
    }

    @Block
    public static class NotesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The business purpose of the note text.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/note-type")
        protected Enumeration<Enumerations.NoteType> type;
        @Child(name="text", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Note explanatory text", formalDefinition="The explanation or description associated with the processing.")
        protected StringType text;
        private static final long serialVersionUID = 529250161L;

        public Enumeration<Enumerations.NoteType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NotesComponent setTypeElement(Enumeration<Enumerations.NoteType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.NoteType getType() {
            return this.type == null ? null : (Enumerations.NoteType)((Object)this.type.getValue());
        }

        public NotesComponent setType(Enumerations.NoteType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NotesComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NotesComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The business purpose of the note text.", 0, 1, this.type));
            children.add(new Property("text", "string", "The explanation or description associated with the processing.", 0, 1, this.text));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The business purpose of the note text.", 0, 1, this.type);
                }
                case 3556653: {
                    return new Property("text", "string", "The explanation or description associated with the processing.", 0, 1, this.text);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new Enumerations.NoteTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new Enumerations.NoteTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.type");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.text");
            }
            return super.addChild(name);
        }

        @Override
        public NotesComponent copy() {
            NotesComponent dst = new NotesComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NotesComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other_;
            return NotesComponent.compareDeep(this.type, o.type, true) && NotesComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other_;
            return NotesComponent.compareValues(this.type, o.type, true) && NotesComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.text);
        }

        @Override
        public String fhirType() {
            return "PaymentReconciliation.processNote";
        }
    }

    @Block
    public static class DetailsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business identifier of the payment detail", formalDefinition="Unique identifier for the current payment item for the referenced payable.")
        protected Identifier identifier;
        @Child(name="predecessor", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business identifier of the prior payment detail", formalDefinition="Unique identifier for the prior payment item for the referenced payable.")
        protected Identifier predecessor;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category of payment", formalDefinition="Code to indicate the nature of the payment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-type")
        protected CodeableConcept type;
        @Child(name="request", type={Reference.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Request giving rise to the payment", formalDefinition="A resource, such as a Claim, the evaluation of which could lead to payment.")
        protected Reference request;
        protected Resource requestTarget;
        @Child(name="submitter", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Submitter of the request", formalDefinition="The party which submitted the claim or financial transaction.")
        protected Reference submitter;
        protected Resource submitterTarget;
        @Child(name="response", type={Reference.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Response committing to a payment", formalDefinition="A resource, such as a ClaimResponse, which contains a commitment to payment.")
        protected Reference response;
        protected Resource responseTarget;
        @Child(name="date", type={DateType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date of commitment to pay", formalDefinition="The date from the response resource containing a commitment to pay.")
        protected DateType date;
        @Child(name="responsible", type={PractitionerRole.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contact for the response", formalDefinition="A reference to the individual who is responsible for inquiries regarding the response and its payment.")
        protected Reference responsible;
        protected PractitionerRole responsibleTarget;
        @Child(name="payee", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recipient of the payment", formalDefinition="The party which is receiving the payment.")
        protected Reference payee;
        protected Resource payeeTarget;
        @Child(name="amount", type={Money.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount allocated to this payable", formalDefinition="The monetary amount allocated from the total payment to the payable.")
        protected Money amount;
        private static final long serialVersionUID = -1361848619L;

        public DetailsComponent() {
        }

        public DetailsComponent(CodeableConcept type) {
            this.type = type;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public DetailsComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public Identifier getPredecessor() {
            if (this.predecessor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.predecessor");
                }
                if (Configuration.doAutoCreate()) {
                    this.predecessor = new Identifier();
                }
            }
            return this.predecessor;
        }

        public boolean hasPredecessor() {
            return this.predecessor != null && !this.predecessor.isEmpty();
        }

        public DetailsComponent setPredecessor(Identifier value) {
            this.predecessor = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DetailsComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getRequest() {
            if (this.request == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.request = new Reference();
                }
            }
            return this.request;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public DetailsComponent setRequest(Reference value) {
            this.request = value;
            return this;
        }

        public Resource getRequestTarget() {
            return this.requestTarget;
        }

        public DetailsComponent setRequestTarget(Resource value) {
            this.requestTarget = value;
            return this;
        }

        public Reference getSubmitter() {
            if (this.submitter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.submitter");
                }
                if (Configuration.doAutoCreate()) {
                    this.submitter = new Reference();
                }
            }
            return this.submitter;
        }

        public boolean hasSubmitter() {
            return this.submitter != null && !this.submitter.isEmpty();
        }

        public DetailsComponent setSubmitter(Reference value) {
            this.submitter = value;
            return this;
        }

        public Resource getSubmitterTarget() {
            return this.submitterTarget;
        }

        public DetailsComponent setSubmitterTarget(Resource value) {
            this.submitterTarget = value;
            return this;
        }

        public Reference getResponse() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new Reference();
                }
            }
            return this.response;
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public DetailsComponent setResponse(Reference value) {
            this.response = value;
            return this;
        }

        public Resource getResponseTarget() {
            return this.responseTarget;
        }

        public DetailsComponent setResponseTarget(Resource value) {
            this.responseTarget = value;
            return this;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public DetailsComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public DetailsComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Reference getResponsible() {
            if (this.responsible == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.responsible");
                }
                if (Configuration.doAutoCreate()) {
                    this.responsible = new Reference();
                }
            }
            return this.responsible;
        }

        public boolean hasResponsible() {
            return this.responsible != null && !this.responsible.isEmpty();
        }

        public DetailsComponent setResponsible(Reference value) {
            this.responsible = value;
            return this;
        }

        public PractitionerRole getResponsibleTarget() {
            if (this.responsibleTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.responsible");
                }
                if (Configuration.doAutoCreate()) {
                    this.responsibleTarget = new PractitionerRole();
                }
            }
            return this.responsibleTarget;
        }

        public DetailsComponent setResponsibleTarget(PractitionerRole value) {
            this.responsibleTarget = value;
            return this;
        }

        public Reference getPayee() {
            if (this.payee == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.payee");
                }
                if (Configuration.doAutoCreate()) {
                    this.payee = new Reference();
                }
            }
            return this.payee;
        }

        public boolean hasPayee() {
            return this.payee != null && !this.payee.isEmpty();
        }

        public DetailsComponent setPayee(Reference value) {
            this.payee = value;
            return this;
        }

        public Resource getPayeeTarget() {
            return this.payeeTarget;
        }

        public DetailsComponent setPayeeTarget(Resource value) {
            this.payeeTarget = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public DetailsComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PaymentReconciliation.SP_IDENTIFIER, "Identifier", "Unique identifier for the current payment item for the referenced payable.", 0, 1, this.identifier));
            children.add(new Property("predecessor", "Identifier", "Unique identifier for the prior payment item for the referenced payable.", 0, 1, this.predecessor));
            children.add(new Property("type", "CodeableConcept", "Code to indicate the nature of the payment.", 0, 1, this.type));
            children.add(new Property(PaymentReconciliation.SP_REQUEST, "Reference(Any)", "A resource, such as a Claim, the evaluation of which could lead to payment.", 0, 1, this.request));
            children.add(new Property("submitter", "Reference(Practitioner|PractitionerRole|Organization)", "The party which submitted the claim or financial transaction.", 0, 1, this.submitter));
            children.add(new Property("response", "Reference(Any)", "A resource, such as a ClaimResponse, which contains a commitment to payment.", 0, 1, this.response));
            children.add(new Property("date", "date", "The date from the response resource containing a commitment to pay.", 0, 1, this.date));
            children.add(new Property("responsible", "Reference(PractitionerRole)", "A reference to the individual who is responsible for inquiries regarding the response and its payment.", 0, 1, this.responsible));
            children.add(new Property("payee", "Reference(Practitioner|PractitionerRole|Organization)", "The party which is receiving the payment.", 0, 1, this.payee));
            children.add(new Property("amount", "Money", "The monetary amount allocated from the total payment to the payable.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(PaymentReconciliation.SP_IDENTIFIER, "Identifier", "Unique identifier for the current payment item for the referenced payable.", 0, 1, this.identifier);
                }
                case -1925032183: {
                    return new Property("predecessor", "Identifier", "Unique identifier for the prior payment item for the referenced payable.", 0, 1, this.predecessor);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Code to indicate the nature of the payment.", 0, 1, this.type);
                }
                case 1095692943: {
                    return new Property(PaymentReconciliation.SP_REQUEST, "Reference(Any)", "A resource, such as a Claim, the evaluation of which could lead to payment.", 0, 1, this.request);
                }
                case 348678409: {
                    return new Property("submitter", "Reference(Practitioner|PractitionerRole|Organization)", "The party which submitted the claim or financial transaction.", 0, 1, this.submitter);
                }
                case -340323263: {
                    return new Property("response", "Reference(Any)", "A resource, such as a ClaimResponse, which contains a commitment to payment.", 0, 1, this.response);
                }
                case 3076014: {
                    return new Property("date", "date", "The date from the response resource containing a commitment to pay.", 0, 1, this.date);
                }
                case 1847674614: {
                    return new Property("responsible", "Reference(PractitionerRole)", "A reference to the individual who is responsible for inquiries regarding the response and its payment.", 0, 1, this.responsible);
                }
                case 106443592: {
                    return new Property("payee", "Reference(Practitioner|PractitionerRole|Organization)", "The party which is receiving the payment.", 0, 1, this.payee);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "The monetary amount allocated from the total payment to the payable.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -1925032183: {
                    Base[] baseArray;
                    if (this.predecessor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.predecessor;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
                case 1095692943: {
                    Base[] baseArray;
                    if (this.request == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.request;
                    }
                    return baseArray;
                }
                case 348678409: {
                    Base[] baseArray;
                    if (this.submitter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.submitter;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.response;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.date;
                    }
                    return baseArray;
                }
                case 1847674614: {
                    Base[] baseArray;
                    if (this.responsible == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.responsible;
                    }
                    return baseArray;
                }
                case 106443592: {
                    Base[] baseArray;
                    if (this.payee == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.payee;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case -1925032183: {
                    this.predecessor = this.castToIdentifier(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1095692943: {
                    this.request = this.castToReference(value);
                    return value;
                }
                case 348678409: {
                    this.submitter = this.castToReference(value);
                    return value;
                }
                case -340323263: {
                    this.response = this.castToReference(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDate(value);
                    return value;
                }
                case 1847674614: {
                    this.responsible = this.castToReference(value);
                    return value;
                }
                case 106443592: {
                    this.payee = this.castToReference(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PaymentReconciliation.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("predecessor")) {
                this.predecessor = this.castToIdentifier(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals(PaymentReconciliation.SP_REQUEST)) {
                this.request = this.castToReference(value);
            } else if (name.equals("submitter")) {
                this.submitter = this.castToReference(value);
            } else if (name.equals("response")) {
                this.response = this.castToReference(value);
            } else if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("responsible")) {
                this.responsible = this.castToReference(value);
            } else if (name.equals("payee")) {
                this.payee = this.castToReference(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -1925032183: {
                    return this.getPredecessor();
                }
                case 3575610: {
                    return this.getType();
                }
                case 1095692943: {
                    return this.getRequest();
                }
                case 348678409: {
                    return this.getSubmitter();
                }
                case -340323263: {
                    return this.getResponse();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case 1847674614: {
                    return this.getResponsible();
                }
                case 106443592: {
                    return this.getPayee();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -1925032183: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1095692943: {
                    return new String[]{"Reference"};
                }
                case 348678409: {
                    return new String[]{"Reference"};
                }
                case -340323263: {
                    return new String[]{"Reference"};
                }
                case 3076014: {
                    return new String[]{"date"};
                }
                case 1847674614: {
                    return new String[]{"Reference"};
                }
                case 106443592: {
                    return new String[]{"Reference"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PaymentReconciliation.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("predecessor")) {
                this.predecessor = new Identifier();
                return this.predecessor;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(PaymentReconciliation.SP_REQUEST)) {
                this.request = new Reference();
                return this.request;
            }
            if (name.equals("submitter")) {
                this.submitter = new Reference();
                return this.submitter;
            }
            if (name.equals("response")) {
                this.response = new Reference();
                return this.response;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.date");
            }
            if (name.equals("responsible")) {
                this.responsible = new Reference();
                return this.responsible;
            }
            if (name.equals("payee")) {
                this.payee = new Reference();
                return this.payee;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public DetailsComponent copy() {
            DetailsComponent dst = new DetailsComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DetailsComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.predecessor = this.predecessor == null ? null : this.predecessor.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.submitter = this.submitter == null ? null : this.submitter.copy();
            dst.response = this.response == null ? null : this.response.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.responsible = this.responsible == null ? null : this.responsible.copy();
            dst.payee = this.payee == null ? null : this.payee.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailsComponent)) {
                return false;
            }
            DetailsComponent o = (DetailsComponent)other_;
            return DetailsComponent.compareDeep(this.identifier, o.identifier, true) && DetailsComponent.compareDeep(this.predecessor, o.predecessor, true) && DetailsComponent.compareDeep(this.type, o.type, true) && DetailsComponent.compareDeep(this.request, o.request, true) && DetailsComponent.compareDeep(this.submitter, o.submitter, true) && DetailsComponent.compareDeep(this.response, o.response, true) && DetailsComponent.compareDeep(this.date, o.date, true) && DetailsComponent.compareDeep(this.responsible, o.responsible, true) && DetailsComponent.compareDeep(this.payee, o.payee, true) && DetailsComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailsComponent)) {
                return false;
            }
            DetailsComponent o = (DetailsComponent)other_;
            return DetailsComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.predecessor, this.type, this.request, this.submitter, this.response, this.date, this.responsible, this.payee, this.amount);
        }

        @Override
        public String fhirType() {
            return "PaymentReconciliation.detail";
        }
    }

    public static class PaymentReconciliationStatusEnumFactory
    implements EnumFactory<PaymentReconciliationStatus> {
        @Override
        public PaymentReconciliationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return PaymentReconciliationStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return PaymentReconciliationStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return PaymentReconciliationStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return PaymentReconciliationStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown PaymentReconciliationStatus code '" + codeString + "'");
        }

        public Enumeration<PaymentReconciliationStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PaymentReconciliationStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<PaymentReconciliationStatus>(this, PaymentReconciliationStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<PaymentReconciliationStatus>(this, PaymentReconciliationStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<PaymentReconciliationStatus>(this, PaymentReconciliationStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<PaymentReconciliationStatus>(this, PaymentReconciliationStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown PaymentReconciliationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(PaymentReconciliationStatus code) {
            if (code == PaymentReconciliationStatus.ACTIVE) {
                return "active";
            }
            if (code == PaymentReconciliationStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == PaymentReconciliationStatus.DRAFT) {
                return "draft";
            }
            if (code == PaymentReconciliationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(PaymentReconciliationStatus code) {
            return code.getSystem();
        }
    }

    public static enum PaymentReconciliationStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static PaymentReconciliationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PaymentReconciliationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

