/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3DocumentCompletion {
    AU,
    DI,
    DO,
    IN,
    IP,
    LA,
    NU,
    PA,
    UC,
    NULL;


    public static V3DocumentCompletion fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AU".equals(codeString)) {
            return AU;
        }
        if ("DI".equals(codeString)) {
            return DI;
        }
        if ("DO".equals(codeString)) {
            return DO;
        }
        if ("IN".equals(codeString)) {
            return IN;
        }
        if ("IP".equals(codeString)) {
            return IP;
        }
        if ("LA".equals(codeString)) {
            return LA;
        }
        if ("NU".equals(codeString)) {
            return NU;
        }
        if ("PA".equals(codeString)) {
            return PA;
        }
        if ("UC".equals(codeString)) {
            return UC;
        }
        throw new FHIRException("Unknown V3DocumentCompletion code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AU: {
                return "AU";
            }
            case DI: {
                return "DI";
            }
            case DO: {
                return "DO";
            }
            case IN: {
                return "IN";
            }
            case IP: {
                return "IP";
            }
            case LA: {
                return "LA";
            }
            case NU: {
                return "NU";
            }
            case PA: {
                return "PA";
            }
            case UC: {
                return "UC";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/DocumentCompletion";
    }

    public String getDefinition() {
        switch (this) {
            case AU: {
                return "A completion status in which a document has been signed manually or electronically by one or more individuals who attest to its accuracy.  No explicit determination is made that the assigned individual has performed the authentication.  While the standard allows multiple instances of authentication, it would be typical to have a single instance of authentication, usually by the assigned individual.";
            }
            case DI: {
                return "A completion status in which information has been orally recorded but not yet transcribed.";
            }
            case DO: {
                return "A completion status in which document content, other than dictation, has been received but has not been translated into the final electronic format.  Examples include paper documents, whether hand-written or typewritten, and intermediate electronic forms, such as voice to text.";
            }
            case IN: {
                return "A completion status in which information is known to be missing from a transcribed document.";
            }
            case IP: {
                return "A workflow status where the material has been assigned to personnel to perform the task of transcription. The document remains in this state until the document is transcribed.";
            }
            case LA: {
                return "A completion status in which a document has been signed manually or electronically by the individual who is legally responsible for that document. This is the most mature state in the workflow progression.";
            }
            case NU: {
                return "A completion status in which a document was created in error or was placed in the wrong chart. The document is no longer available.";
            }
            case PA: {
                return "A completion status in which a document is transcribed but not authenticated.";
            }
            case UC: {
                return "A completion status where the document is complete and there is no expectation that the document will be signed.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AU: {
                return "authenticated";
            }
            case DI: {
                return "dictated";
            }
            case DO: {
                return "documented";
            }
            case IN: {
                return "incomplete";
            }
            case IP: {
                return "in progress";
            }
            case LA: {
                return "legally authenticated";
            }
            case NU: {
                return "nullified document";
            }
            case PA: {
                return "pre-authenticated";
            }
            case UC: {
                return "unsigned completed document";
            }
        }
        return "?";
    }
}

