/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ReferralRequestStatus {
    DRAFT,
    ACTIVE,
    CANCELLED,
    COMPLETED,
    ENTEREDINERROR,
    NULL;


    public static ReferralRequestStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown ReferralRequestStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ACTIVE: {
                return "active";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/referral-request-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "A draft referral that has yet to be send.";
            }
            case ACTIVE: {
                return "The referral is complete and is ready for fulfillment.";
            }
            case CANCELLED: {
                return "The referral has been cancelled without being completed. For example it is no longer needed.";
            }
            case COMPLETED: {
                return "The referral has been completely actioned.";
            }
            case ENTEREDINERROR: {
                return "This referral record should never have existed, though it's possible some degree of real-world activity or decisions may have been taken due to its existence";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case ACTIVE: {
                return "Active";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
        }
        return "?";
    }
}

