/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationStatus {
    ACTIVE,
    INACTIVE,
    ENTEREDINERROR,
    NULL;


    public static MedicationStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown MedicationStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case INACTIVE: {
                return "inactive";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medication-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The medication is available for use";
            }
            case INACTIVE: {
                return "The medication is not available for use";
            }
            case ENTEREDINERROR: {
                return "The medication was entered in error";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
        }
        return "?";
    }
}

