/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Base64BinaryType;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SampledData;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Task", profile="http://hl7.org/fhir/Profile/Task")
public class Task
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Task Instance Identifier", formalDefinition="The business identifier for this task.")
    protected List<Identifier> identifier;
    @Child(name="definition", type={UriType.class, ActivityDefinition.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Formal definition of task", formalDefinition="A reference to a formal or informal definition of the task.  For example, a protocol, a step within a defined workflow definition, etc.")
    protected Type definition;
    @Child(name="basedOn", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request fulfilled by this task", formalDefinition="BasedOn refers to a higher-level authorization that triggered the creation of the task.  It references a \"request\" resource such as a ProcedureRequest, MedicationRequest, ProcedureRequest, CarePlan, etc. which is distinct from the \"request\" resource the task is seeking to fulfil.  This latter resource is referenced by FocusOn.  For example, based on a ProcedureRequest (= BasedOn), a task is created to fulfil a procedureRequest ( = FocusOn ) to collect a specimen from a patient.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="groupIdentifier", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Requisition or grouper id", formalDefinition="An identifier that links together multiple tasks and other requests that were created in the same context.")
    protected Identifier groupIdentifier;
    @Child(name="partOf", type={Task.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Composite task", formalDefinition="Task that this particular task is part of.")
    protected List<Reference> partOf;
    protected List<Task> partOfTarget;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="draft | requested | received | accepted | +", formalDefinition="The current status of the task.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/task-status")
    protected Enumeration<TaskStatus> status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for current status", formalDefinition="An explanation as to why this task is held, failed, was refused, etc.")
    protected CodeableConcept statusReason;
    @Child(name="businessStatus", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="E.g. \"Specimen collected\", \"IV prepped\"", formalDefinition="Contains business-specific nuances of the business state.")
    protected CodeableConcept businessStatus;
    @Child(name="intent", type={CodeType.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="proposal | plan | order +", formalDefinition="Indicates the \"level\" of actionability associated with the Task.  I.e. Is this a proposed task, a planned task, an actionable task, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-intent")
    protected Enumeration<TaskIntent> intent;
    @Child(name="priority", type={CodeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="normal | urgent | asap | stat", formalDefinition="Indicates how quickly the Task should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<TaskPriority> priority;
    @Child(name="code", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Task Type", formalDefinition="A name or code (or both) briefly describing what the task involves.")
    protected CodeableConcept code;
    @Child(name="description", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable explanation of task", formalDefinition="A free-text description of what is to be performed.")
    protected StringType description;
    @Child(name="focus", type={Reference.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What task is acting on", formalDefinition="The request being actioned or the resource being manipulated by this task.")
    protected Reference focus;
    protected Resource focusTarget;
    @Child(name="for", type={Reference.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Beneficiary of the Task", formalDefinition="The entity who benefits from the performance of the service specified in the task (e.g., the patient).")
    protected Reference for_;
    protected Resource for_Target;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Healthcare event during which this task originated", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) during which this task was created.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="executionPeriod", type={Period.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end time of execution", formalDefinition="Identifies the time action was first taken against the task (start) and/or the time final action was taken against the task prior to marking it as completed (end).")
    protected Period executionPeriod;
    @Child(name="authoredOn", type={DateTimeType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Task Creation Date", formalDefinition="The date and time this task was created.")
    protected DateTimeType authoredOn;
    @Child(name="lastModified", type={DateTimeType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Task Last Modified Date", formalDefinition="The date and time of last modification to this task.")
    protected DateTimeType lastModified;
    @Child(name="requester", type={}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is asking for task to be done", formalDefinition="The creator of the task.")
    protected TaskRequesterComponent requester;
    @Child(name="performerType", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="requester | dispatcher | scheduler | performer | monitor | manager | acquirer | reviewer", formalDefinition="The type of participant that can execute the task.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/task-performer-type")
    protected List<CodeableConcept> performerType;
    @Child(name="owner", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible individual", formalDefinition="Individual organization or Device currently responsible for task execution.")
    protected Reference owner;
    protected Resource ownerTarget;
    @Child(name="reason", type={CodeableConcept.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why task is needed", formalDefinition="A description or code indicating why this task needs to be performed.")
    protected CodeableConcept reason;
    @Child(name="note", type={Annotation.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the task", formalDefinition="Free-text information captured about the task as it progresses.")
    protected List<Annotation> note;
    @Child(name="relevantHistory", type={Provenance.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Key events in history of the Task", formalDefinition="Links to Provenance records for past versions of this Task that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the task.")
    protected List<Reference> relevantHistory;
    protected List<Provenance> relevantHistoryTarget;
    @Child(name="restriction", type={}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Constraints on fulfillment tasks", formalDefinition="If the Task.focus is a request resource and the task is seeking fulfillment (i.e is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.")
    protected TaskRestrictionComponent restriction;
    @Child(name="input", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information used to perform task", formalDefinition="Additional information that may be needed in the execution of the task.")
    protected List<ParameterComponent> input;
    @Child(name="output", type={}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information produced as part of task", formalDefinition="Outputs produced by the Task.")
    protected List<TaskOutputComponent> output;
    private static final long serialVersionUID = 2060755798L;
    @SearchParamDefinition(name="owner", path="Task.owner", description="Search by task owner", type="reference", target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_OWNER = "owner";
    public static final ReferenceClientParam OWNER = new ReferenceClientParam("owner");
    public static final Include INCLUDE_OWNER = new Include("Task:owner").toLocked();
    @SearchParamDefinition(name="requester", path="Task.requester.agent", description="Search by task requester", type="reference", target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("Task:requester").toLocked();
    @SearchParamDefinition(name="identifier", path="Task.identifier", description="Search for a task instance by its business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="business-status", path="Task.businessStatus", description="Search by business status", type="token")
    public static final String SP_BUSINESS_STATUS = "business-status";
    public static final TokenClientParam BUSINESS_STATUS = new TokenClientParam("business-status");
    @SearchParamDefinition(name="period", path="Task.executionPeriod", description="Search by period Task is/was underway", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="code", path="Task.code", description="Search by task code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="performer", path="Task.performerType", description="Search by recommended type of performer (e.g., Requester, Performer, Scheduler).", type="token")
    public static final String SP_PERFORMER = "performer";
    public static final TokenClientParam PERFORMER = new TokenClientParam("performer");
    @SearchParamDefinition(name="subject", path="Task.for", description="Search by subject", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Task:subject").toLocked();
    @SearchParamDefinition(name="focus", path="Task.focus", description="Search by task focus", type="reference")
    public static final String SP_FOCUS = "focus";
    public static final ReferenceClientParam FOCUS = new ReferenceClientParam("focus");
    public static final Include INCLUDE_FOCUS = new Include("Task:focus").toLocked();
    @SearchParamDefinition(name="part-of", path="Task.partOf", description="Search by task this task is part of", type="reference", target={Task.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Task:part-of").toLocked();
    @SearchParamDefinition(name="priority", path="Task.priority", description="Search by task priority", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="authored-on", path="Task.authoredOn", description="Search by creation date", type="date")
    public static final String SP_AUTHORED_ON = "authored-on";
    public static final DateClientParam AUTHORED_ON = new DateClientParam("authored-on");
    @SearchParamDefinition(name="intent", path="Task.intent", description="Search by task intent", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="group-identifier", path="Task.groupIdentifier", description="Search by group identifier", type="token")
    public static final String SP_GROUP_IDENTIFIER = "group-identifier";
    public static final TokenClientParam GROUP_IDENTIFIER = new TokenClientParam("group-identifier");
    @SearchParamDefinition(name="based-on", path="Task.basedOn", description="Search by requests this task is based on", type="reference")
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Task:based-on").toLocked();
    @SearchParamDefinition(name="patient", path="Task.for", description="Search by patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Task:patient").toLocked();
    @SearchParamDefinition(name="organization", path="Task.requester.onBehalfOf", description="Search by responsible organization", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Task:organization").toLocked();
    @SearchParamDefinition(name="context", path="Task.context", description="Search by encounter or episode", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("Task:context").toLocked();
    @SearchParamDefinition(name="modified", path="Task.lastModified", description="Search by last modification date", type="date")
    public static final String SP_MODIFIED = "modified";
    public static final DateClientParam MODIFIED = new DateClientParam("modified");
    @SearchParamDefinition(name="status", path="Task.status", description="Search by task status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Task() {
    }

    public Task(Enumeration<TaskStatus> status, Enumeration<TaskIntent> intent) {
        this.status = status;
        this.intent = intent;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Task setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Task addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Type getDefinition() {
        return this.definition;
    }

    public UriType getDefinitionUriType() throws FHIRException {
        if (this.definition == null) {
            return null;
        }
        if (!(this.definition instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.definition.getClass().getName() + " was encountered");
        }
        return (UriType)this.definition;
    }

    public boolean hasDefinitionUriType() {
        return this != null && this.definition instanceof UriType;
    }

    public Reference getDefinitionReference() throws FHIRException {
        if (this.definition == null) {
            return null;
        }
        if (!(this.definition instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.definition.getClass().getName() + " was encountered");
        }
        return (Reference)this.definition;
    }

    public boolean hasDefinitionReference() {
        return this != null && this.definition instanceof Reference;
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public Task setDefinition(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof UriType) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for Task.definition[x]: " + value.fhirType());
        }
        this.definition = value;
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Task setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Task addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public Task setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public Task setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public Task addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    @Deprecated
    public List<Task> getPartOfTarget() {
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<Task>();
        }
        return this.partOfTarget;
    }

    @Deprecated
    public Task addPartOfTarget() {
        Task r = new Task();
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<Task>();
        }
        this.partOfTarget.add(r);
        return r;
    }

    public Enumeration<TaskStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<TaskStatus>(new TaskStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Task setStatusElement(Enumeration<TaskStatus> value) {
        this.status = value;
        return this;
    }

    public TaskStatus getStatus() {
        return this.status == null ? null : (TaskStatus)((Object)this.status.getValue());
    }

    public Task setStatus(TaskStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<TaskStatus>(new TaskStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableConcept();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public Task setStatusReason(CodeableConcept value) {
        this.statusReason = value;
        return this;
    }

    public CodeableConcept getBusinessStatus() {
        if (this.businessStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.businessStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.businessStatus = new CodeableConcept();
            }
        }
        return this.businessStatus;
    }

    public boolean hasBusinessStatus() {
        return this.businessStatus != null && !this.businessStatus.isEmpty();
    }

    public Task setBusinessStatus(CodeableConcept value) {
        this.businessStatus = value;
        return this;
    }

    public Enumeration<TaskIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<TaskIntent>(new TaskIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public Task setIntentElement(Enumeration<TaskIntent> value) {
        this.intent = value;
        return this;
    }

    public TaskIntent getIntent() {
        return this.intent == null ? null : (TaskIntent)((Object)this.intent.getValue());
    }

    public Task setIntent(TaskIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<TaskIntent>(new TaskIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public Enumeration<TaskPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<TaskPriority>(new TaskPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Task setPriorityElement(Enumeration<TaskPriority> value) {
        this.priority = value;
        return this;
    }

    public TaskPriority getPriority() {
        return this.priority == null ? null : (TaskPriority)((Object)this.priority.getValue());
    }

    public Task setPriority(TaskPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<TaskPriority>(new TaskPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Task setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Task setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Task setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Reference getFocus() {
        if (this.focus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.focus");
            }
            if (Configuration.doAutoCreate()) {
                this.focus = new Reference();
            }
        }
        return this.focus;
    }

    public boolean hasFocus() {
        return this.focus != null && !this.focus.isEmpty();
    }

    public Task setFocus(Reference value) {
        this.focus = value;
        return this;
    }

    public Resource getFocusTarget() {
        return this.focusTarget;
    }

    public Task setFocusTarget(Resource value) {
        this.focusTarget = value;
        return this;
    }

    public Reference getFor() {
        if (this.for_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.for_");
            }
            if (Configuration.doAutoCreate()) {
                this.for_ = new Reference();
            }
        }
        return this.for_;
    }

    public boolean hasFor() {
        return this.for_ != null && !this.for_.isEmpty();
    }

    public Task setFor(Reference value) {
        this.for_ = value;
        return this;
    }

    public Resource getForTarget() {
        return this.for_Target;
    }

    public Task setForTarget(Resource value) {
        this.for_Target = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public Task setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public Task setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Period getExecutionPeriod() {
        if (this.executionPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.executionPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.executionPeriod = new Period();
            }
        }
        return this.executionPeriod;
    }

    public boolean hasExecutionPeriod() {
        return this.executionPeriod != null && !this.executionPeriod.isEmpty();
    }

    public Task setExecutionPeriod(Period value) {
        this.executionPeriod = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public Task setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public Task setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public DateTimeType getLastModifiedElement() {
        if (this.lastModified == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.lastModified");
            }
            if (Configuration.doAutoCreate()) {
                this.lastModified = new DateTimeType();
            }
        }
        return this.lastModified;
    }

    public boolean hasLastModifiedElement() {
        return this.lastModified != null && !this.lastModified.isEmpty();
    }

    public boolean hasLastModified() {
        return this.lastModified != null && !this.lastModified.isEmpty();
    }

    public Task setLastModifiedElement(DateTimeType value) {
        this.lastModified = value;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified == null ? null : (Date)this.lastModified.getValue();
    }

    public Task setLastModified(Date value) {
        if (value == null) {
            this.lastModified = null;
        } else {
            if (this.lastModified == null) {
                this.lastModified = new DateTimeType();
            }
            this.lastModified.setValue(value);
        }
        return this;
    }

    public TaskRequesterComponent getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new TaskRequesterComponent();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public Task setRequester(TaskRequesterComponent value) {
        this.requester = value;
        return this;
    }

    public List<CodeableConcept> getPerformerType() {
        if (this.performerType == null) {
            this.performerType = new ArrayList<CodeableConcept>();
        }
        return this.performerType;
    }

    public Task setPerformerType(List<CodeableConcept> thePerformerType) {
        this.performerType = thePerformerType;
        return this;
    }

    public boolean hasPerformerType() {
        if (this.performerType == null) {
            return false;
        }
        for (CodeableConcept item : this.performerType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPerformerType() {
        CodeableConcept t = new CodeableConcept();
        if (this.performerType == null) {
            this.performerType = new ArrayList<CodeableConcept>();
        }
        this.performerType.add(t);
        return t;
    }

    public Task addPerformerType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.performerType == null) {
            this.performerType = new ArrayList<CodeableConcept>();
        }
        this.performerType.add(t);
        return this;
    }

    public CodeableConcept getPerformerTypeFirstRep() {
        if (this.getPerformerType().isEmpty()) {
            this.addPerformerType();
        }
        return this.getPerformerType().get(0);
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Task setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Resource getOwnerTarget() {
        return this.ownerTarget;
    }

    public Task setOwnerTarget(Resource value) {
        this.ownerTarget = value;
        return this;
    }

    public CodeableConcept getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new CodeableConcept();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public Task setReason(CodeableConcept value) {
        this.reason = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Task setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Task addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getRelevantHistory() {
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        return this.relevantHistory;
    }

    public Task setRelevantHistory(List<Reference> theRelevantHistory) {
        this.relevantHistory = theRelevantHistory;
        return this;
    }

    public boolean hasRelevantHistory() {
        if (this.relevantHistory == null) {
            return false;
        }
        for (Reference item : this.relevantHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelevantHistory() {
        Reference t = new Reference();
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return t;
    }

    public Task addRelevantHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return this;
    }

    public Reference getRelevantHistoryFirstRep() {
        if (this.getRelevantHistory().isEmpty()) {
            this.addRelevantHistory();
        }
        return this.getRelevantHistory().get(0);
    }

    @Deprecated
    public List<Provenance> getRelevantHistoryTarget() {
        if (this.relevantHistoryTarget == null) {
            this.relevantHistoryTarget = new ArrayList<Provenance>();
        }
        return this.relevantHistoryTarget;
    }

    @Deprecated
    public Provenance addRelevantHistoryTarget() {
        Provenance r = new Provenance();
        if (this.relevantHistoryTarget == null) {
            this.relevantHistoryTarget = new ArrayList<Provenance>();
        }
        this.relevantHistoryTarget.add(r);
        return r;
    }

    public TaskRestrictionComponent getRestriction() {
        if (this.restriction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Task.restriction");
            }
            if (Configuration.doAutoCreate()) {
                this.restriction = new TaskRestrictionComponent();
            }
        }
        return this.restriction;
    }

    public boolean hasRestriction() {
        return this.restriction != null && !this.restriction.isEmpty();
    }

    public Task setRestriction(TaskRestrictionComponent value) {
        this.restriction = value;
        return this;
    }

    public List<ParameterComponent> getInput() {
        if (this.input == null) {
            this.input = new ArrayList<ParameterComponent>();
        }
        return this.input;
    }

    public Task setInput(List<ParameterComponent> theInput) {
        this.input = theInput;
        return this;
    }

    public boolean hasInput() {
        if (this.input == null) {
            return false;
        }
        for (ParameterComponent item : this.input) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ParameterComponent addInput() {
        ParameterComponent t = new ParameterComponent();
        if (this.input == null) {
            this.input = new ArrayList<ParameterComponent>();
        }
        this.input.add(t);
        return t;
    }

    public Task addInput(ParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.input == null) {
            this.input = new ArrayList<ParameterComponent>();
        }
        this.input.add(t);
        return this;
    }

    public ParameterComponent getInputFirstRep() {
        if (this.getInput().isEmpty()) {
            this.addInput();
        }
        return this.getInput().get(0);
    }

    public List<TaskOutputComponent> getOutput() {
        if (this.output == null) {
            this.output = new ArrayList<TaskOutputComponent>();
        }
        return this.output;
    }

    public Task setOutput(List<TaskOutputComponent> theOutput) {
        this.output = theOutput;
        return this;
    }

    public boolean hasOutput() {
        if (this.output == null) {
            return false;
        }
        for (TaskOutputComponent item : this.output) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TaskOutputComponent addOutput() {
        TaskOutputComponent t = new TaskOutputComponent();
        if (this.output == null) {
            this.output = new ArrayList<TaskOutputComponent>();
        }
        this.output.add(t);
        return t;
    }

    public Task addOutput(TaskOutputComponent t) {
        if (t == null) {
            return this;
        }
        if (this.output == null) {
            this.output = new ArrayList<TaskOutputComponent>();
        }
        this.output.add(t);
        return this;
    }

    public TaskOutputComponent getOutputFirstRep() {
        if (this.getOutput().isEmpty()) {
            this.addOutput();
        }
        return this.getOutput().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The business identifier for this task.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("definition[x]", "uri|Reference(ActivityDefinition)", "A reference to a formal or informal definition of the task.  For example, a protocol, a step within a defined workflow definition, etc.", 0, 1, this.definition));
        children.add(new Property("basedOn", "Reference(Any)", "BasedOn refers to a higher-level authorization that triggered the creation of the task.  It references a \"request\" resource such as a ProcedureRequest, MedicationRequest, ProcedureRequest, CarePlan, etc. which is distinct from the \"request\" resource the task is seeking to fulfil.  This latter resource is referenced by FocusOn.  For example, based on a ProcedureRequest (= BasedOn), a task is created to fulfil a procedureRequest ( = FocusOn ) to collect a specimen from a patient.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("groupIdentifier", "Identifier", "An identifier that links together multiple tasks and other requests that were created in the same context.", 0, 1, this.groupIdentifier));
        children.add(new Property("partOf", "Reference(Task)", "Task that this particular task is part of.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "The current status of the task.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "An explanation as to why this task is held, failed, was refused, etc.", 0, 1, this.statusReason));
        children.add(new Property("businessStatus", "CodeableConcept", "Contains business-specific nuances of the business state.", 0, 1, this.businessStatus));
        children.add(new Property(SP_INTENT, SP_CODE, "Indicates the \"level\" of actionability associated with the Task.  I.e. Is this a proposed task, a planned task, an actionable task, etc.", 0, 1, this.intent));
        children.add(new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the Task should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property(SP_CODE, "CodeableConcept", "A name or code (or both) briefly describing what the task involves.", 0, 1, this.code));
        children.add(new Property("description", "string", "A free-text description of what is to be performed.", 0, 1, this.description));
        children.add(new Property(SP_FOCUS, "Reference(Any)", "The request being actioned or the resource being manipulated by this task.", 0, 1, this.focus));
        children.add(new Property("for", "Reference(Any)", "The entity who benefits from the performance of the service specified in the task (e.g., the patient).", 0, 1, this.for_));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this task was created.", 0, 1, this.context));
        children.add(new Property("executionPeriod", "Period", "Identifies the time action was first taken against the task (start) and/or the time final action was taken against the task prior to marking it as completed (end).", 0, 1, this.executionPeriod));
        children.add(new Property("authoredOn", "dateTime", "The date and time this task was created.", 0, 1, this.authoredOn));
        children.add(new Property("lastModified", "dateTime", "The date and time of last modification to this task.", 0, 1, this.lastModified));
        children.add(new Property(SP_REQUESTER, "", "The creator of the task.", 0, 1, this.requester));
        children.add(new Property("performerType", "CodeableConcept", "The type of participant that can execute the task.", 0, Integer.MAX_VALUE, this.performerType));
        children.add(new Property(SP_OWNER, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "Individual organization or Device currently responsible for task execution.", 0, 1, this.owner));
        children.add(new Property("reason", "CodeableConcept", "A description or code indicating why this task needs to be performed.", 0, 1, this.reason));
        children.add(new Property("note", "Annotation", "Free-text information captured about the task as it progresses.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("relevantHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this Task that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the task.", 0, Integer.MAX_VALUE, this.relevantHistory));
        children.add(new Property("restriction", "", "If the Task.focus is a request resource and the task is seeking fulfillment (i.e is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.", 0, 1, this.restriction));
        children.add(new Property("input", "", "Additional information that may be needed in the execution of the task.", 0, Integer.MAX_VALUE, this.input));
        children.add(new Property("output", "", "Outputs produced by the Task.", 0, Integer.MAX_VALUE, this.output));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The business identifier for this task.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1139422643: {
                return new Property("definition[x]", "uri|Reference(ActivityDefinition)", "A reference to a formal or informal definition of the task.  For example, a protocol, a step within a defined workflow definition, etc.", 0, 1, this.definition);
            }
            case -1014418093: {
                return new Property("definition[x]", "uri|Reference(ActivityDefinition)", "A reference to a formal or informal definition of the task.  For example, a protocol, a step within a defined workflow definition, etc.", 0, 1, this.definition);
            }
            case -1139428583: {
                return new Property("definition[x]", "uri|Reference(ActivityDefinition)", "A reference to a formal or informal definition of the task.  For example, a protocol, a step within a defined workflow definition, etc.", 0, 1, this.definition);
            }
            case -820021448: {
                return new Property("definition[x]", "uri|Reference(ActivityDefinition)", "A reference to a formal or informal definition of the task.  For example, a protocol, a step within a defined workflow definition, etc.", 0, 1, this.definition);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "BasedOn refers to a higher-level authorization that triggered the creation of the task.  It references a \"request\" resource such as a ProcedureRequest, MedicationRequest, ProcedureRequest, CarePlan, etc. which is distinct from the \"request\" resource the task is seeking to fulfil.  This latter resource is referenced by FocusOn.  For example, based on a ProcedureRequest (= BasedOn), a task is created to fulfil a procedureRequest ( = FocusOn ) to collect a specimen from a patient.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -445338488: {
                return new Property("groupIdentifier", "Identifier", "An identifier that links together multiple tasks and other requests that were created in the same context.", 0, 1, this.groupIdentifier);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Task)", "Task that this particular task is part of.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The current status of the task.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "An explanation as to why this task is held, failed, was refused, etc.", 0, 1, this.statusReason);
            }
            case 2008591314: {
                return new Property("businessStatus", "CodeableConcept", "Contains business-specific nuances of the business state.", 0, 1, this.businessStatus);
            }
            case -1183762788: {
                return new Property(SP_INTENT, SP_CODE, "Indicates the \"level\" of actionability associated with the Task.  I.e. Is this a proposed task, a planned task, an actionable task, etc.", 0, 1, this.intent);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the Task should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A name or code (or both) briefly describing what the task involves.", 0, 1, this.code);
            }
            case -1724546052: {
                return new Property("description", "string", "A free-text description of what is to be performed.", 0, 1, this.description);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "Reference(Any)", "The request being actioned or the resource being manipulated by this task.", 0, 1, this.focus);
            }
            case 101577: {
                return new Property("for", "Reference(Any)", "The entity who benefits from the performance of the service specified in the task (e.g., the patient).", 0, 1, this.for_);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The healthcare event  (e.g. a patient and healthcare provider interaction) during which this task was created.", 0, 1, this.context);
            }
            case 1218624249: {
                return new Property("executionPeriod", "Period", "Identifies the time action was first taken against the task (start) and/or the time final action was taken against the task prior to marking it as completed (end).", 0, 1, this.executionPeriod);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "The date and time this task was created.", 0, 1, this.authoredOn);
            }
            case 1959003007: {
                return new Property("lastModified", "dateTime", "The date and time of last modification to this task.", 0, 1, this.lastModified);
            }
            case 693933948: {
                return new Property(SP_REQUESTER, "", "The creator of the task.", 0, 1, this.requester);
            }
            case -901444568: {
                return new Property("performerType", "CodeableConcept", "The type of participant that can execute the task.", 0, Integer.MAX_VALUE, this.performerType);
            }
            case 106164915: {
                return new Property(SP_OWNER, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "Individual organization or Device currently responsible for task execution.", 0, 1, this.owner);
            }
            case -934964668: {
                return new Property("reason", "CodeableConcept", "A description or code indicating why this task needs to be performed.", 0, 1, this.reason);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Free-text information captured about the task as it progresses.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1538891575: {
                return new Property("relevantHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this Task that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the task.", 0, Integer.MAX_VALUE, this.relevantHistory);
            }
            case -1561062452: {
                return new Property("restriction", "", "If the Task.focus is a request resource and the task is seeking fulfillment (i.e is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.", 0, 1, this.restriction);
            }
            case 100358090: {
                return new Property("input", "", "Additional information that may be needed in the execution of the task.", 0, Integer.MAX_VALUE, this.input);
            }
            case -1005512447: {
                return new Property("output", "", "Outputs produced by the Task.", 0, Integer.MAX_VALUE, this.output);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                Base[] baseArray;
                if (this.definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.definition;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.statusReason;
                }
                return baseArray;
            }
            case 2008591314: {
                Base[] baseArray;
                if (this.businessStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.businessStatus;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.intent;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.priority;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.code;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case 97604824: {
                Base[] baseArray;
                if (this.focus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.focus;
                }
                return baseArray;
            }
            case 101577: {
                Base[] baseArray;
                if (this.for_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.for_;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.context;
                }
                return baseArray;
            }
            case 1218624249: {
                Base[] baseArray;
                if (this.executionPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.executionPeriod;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 1959003007: {
                Base[] baseArray;
                if (this.lastModified == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.lastModified;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.requester;
                }
                return baseArray;
            }
            case -901444568: {
                return this.performerType == null ? new Base[]{} : this.performerType.toArray(new Base[this.performerType.size()]);
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.owner;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.reason;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1538891575: {
                return this.relevantHistory == null ? new Base[]{} : this.relevantHistory.toArray(new Base[this.relevantHistory.size()]);
            }
            case -1561062452: {
                Base[] baseArray;
                if (this.restriction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.restriction;
                }
                return baseArray;
            }
            case 100358090: {
                return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
            }
            case -1005512447: {
                return this.output == null ? new Base[]{} : this.output.toArray(new Base[this.output.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.definition = this.castToType(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = this.castToIdentifier(value);
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new TaskStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = this.castToCodeableConcept(value);
                return value;
            }
            case 2008591314: {
                this.businessStatus = this.castToCodeableConcept(value);
                return value;
            }
            case -1183762788: {
                value = new TaskIntentEnumFactory().fromType(this.castToCode(value));
                this.intent = value;
                return value;
            }
            case -1165461084: {
                value = new TaskPriorityEnumFactory().fromType(this.castToCode(value));
                this.priority = value;
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case 97604824: {
                this.focus = this.castToReference(value);
                return value;
            }
            case 101577: {
                this.for_ = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case 1218624249: {
                this.executionPeriod = this.castToPeriod(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = this.castToDateTime(value);
                return value;
            }
            case 1959003007: {
                this.lastModified = this.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = (TaskRequesterComponent)((Object)value);
                return value;
            }
            case -901444568: {
                this.getPerformerType().add(this.castToCodeableConcept(value));
                return value;
            }
            case 106164915: {
                this.owner = this.castToReference(value);
                return value;
            }
            case -934964668: {
                this.reason = this.castToCodeableConcept(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case 1538891575: {
                this.getRelevantHistory().add(this.castToReference(value));
                return value;
            }
            case -1561062452: {
                this.restriction = (TaskRestrictionComponent)((Object)value);
                return value;
            }
            case 100358090: {
                this.getInput().add((ParameterComponent)((Object)value));
                return value;
            }
            case -1005512447: {
                this.getOutput().add((TaskOutputComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("definition[x]")) {
            this.definition = this.castToType(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = this.castToIdentifier(value);
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new TaskStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = this.castToCodeableConcept(value);
        } else if (name.equals("businessStatus")) {
            this.businessStatus = this.castToCodeableConcept(value);
        } else if (name.equals(SP_INTENT)) {
            value = new TaskIntentEnumFactory().fromType(this.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_PRIORITY)) {
            value = new TaskPriorityEnumFactory().fromType(this.castToCode(value));
            this.priority = value;
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals(SP_FOCUS)) {
            this.focus = this.castToReference(value);
        } else if (name.equals("for")) {
            this.for_ = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("executionPeriod")) {
            this.executionPeriod = this.castToPeriod(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = this.castToDateTime(value);
        } else if (name.equals("lastModified")) {
            this.lastModified = this.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = (TaskRequesterComponent)((Object)value);
        } else if (name.equals("performerType")) {
            this.getPerformerType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_OWNER)) {
            this.owner = this.castToReference(value);
        } else if (name.equals("reason")) {
            this.reason = this.castToCodeableConcept(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("relevantHistory")) {
            this.getRelevantHistory().add(this.castToReference(value));
        } else if (name.equals("restriction")) {
            this.restriction = (TaskRestrictionComponent)((Object)value);
        } else if (name.equals("input")) {
            this.getInput().add((ParameterComponent)((Object)value));
        } else if (name.equals("output")) {
            this.getOutput().add((TaskOutputComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1139422643: {
                return this.getDefinition();
            }
            case -1014418093: {
                return this.getDefinition();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case 2008591314: {
                return this.getBusinessStatus();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 97604824: {
                return this.getFocus();
            }
            case 101577: {
                return this.getFor();
            }
            case 951530927: {
                return this.getContext();
            }
            case 1218624249: {
                return this.getExecutionPeriod();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 1959003007: {
                return this.getLastModifiedElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -901444568: {
                return this.addPerformerType();
            }
            case 106164915: {
                return this.getOwner();
            }
            case -934964668: {
                return this.getReason();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1538891575: {
                return this.addRelevantHistory();
            }
            case -1561062452: {
                return this.getRestriction();
            }
            case 100358090: {
                return this.addInput();
            }
            case -1005512447: {
                return this.addOutput();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"uri", "Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case 2008591314: {
                return new String[]{"CodeableConcept"};
            }
            case -1183762788: {
                return new String[]{SP_CODE};
            }
            case -1165461084: {
                return new String[]{SP_CODE};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 97604824: {
                return new String[]{"Reference"};
            }
            case 101577: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 1218624249: {
                return new String[]{"Period"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 1959003007: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[0];
            }
            case -901444568: {
                return new String[]{"CodeableConcept"};
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1538891575: {
                return new String[]{"Reference"};
            }
            case -1561062452: {
                return new String[0];
            }
            case 100358090: {
                return new String[0];
            }
            case -1005512447: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("definitionUri")) {
            this.definition = new UriType();
            return this.definition;
        }
        if (name.equals("definitionReference")) {
            this.definition = new Reference();
            return this.definition;
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals("businessStatus")) {
            this.businessStatus = new CodeableConcept();
            return this.businessStatus;
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.intent");
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.priority");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.description");
        }
        if (name.equals(SP_FOCUS)) {
            this.focus = new Reference();
            return this.focus;
        }
        if (name.equals("for")) {
            this.for_ = new Reference();
            return this.for_;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("executionPeriod")) {
            this.executionPeriod = new Period();
            return this.executionPeriod;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.authoredOn");
        }
        if (name.equals("lastModified")) {
            throw new FHIRException("Cannot call addChild on a primitive type Task.lastModified");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new TaskRequesterComponent();
            return this.requester;
        }
        if (name.equals("performerType")) {
            return this.addPerformerType();
        }
        if (name.equals(SP_OWNER)) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("reason")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("relevantHistory")) {
            return this.addRelevantHistory();
        }
        if (name.equals("restriction")) {
            this.restriction = new TaskRestrictionComponent();
            return this.restriction;
        }
        if (name.equals("input")) {
            return this.addInput();
        }
        if (name.equals("output")) {
            return this.addOutput();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Task";
    }

    @Override
    public Task copy() {
        Task dst = new Task();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Type type = dst.definition = this.definition == null ? null : this.definition.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Identifier identifier = dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        dst.businessStatus = this.businessStatus == null ? null : this.businessStatus.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.focus = this.focus == null ? null : this.focus.copy();
        dst.for_ = this.for_ == null ? null : this.for_.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.executionPeriod = this.executionPeriod == null ? null : this.executionPeriod.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        dst.lastModified = this.lastModified == null ? null : this.lastModified.copy();
        TaskRequesterComponent taskRequesterComponent = dst.requester = this.requester == null ? null : this.requester.copy();
        if (this.performerType != null) {
            dst.performerType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.performerType) {
                dst.performerType.add(codeableConcept.copy());
            }
        }
        dst.owner = this.owner == null ? null : this.owner.copy();
        CodeableConcept codeableConcept = dst.reason = this.reason == null ? null : this.reason.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.relevantHistory != null) {
            dst.relevantHistory = new ArrayList<Reference>();
            for (Reference reference : this.relevantHistory) {
                dst.relevantHistory.add(reference.copy());
            }
        }
        TaskRestrictionComponent taskRestrictionComponent = dst.restriction = this.restriction == null ? null : this.restriction.copy();
        if (this.input != null) {
            dst.input = new ArrayList<ParameterComponent>();
            for (ParameterComponent parameterComponent : this.input) {
                dst.input.add(parameterComponent.copy());
            }
        }
        if (this.output != null) {
            dst.output = new ArrayList<TaskOutputComponent>();
            for (TaskOutputComponent taskOutputComponent : this.output) {
                dst.output.add(taskOutputComponent.copy());
            }
        }
        return dst;
    }

    protected Task typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Task)) {
            return false;
        }
        Task o = (Task)other_;
        return Task.compareDeep(this.identifier, o.identifier, true) && Task.compareDeep(this.definition, o.definition, true) && Task.compareDeep(this.basedOn, o.basedOn, true) && Task.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && Task.compareDeep(this.partOf, o.partOf, true) && Task.compareDeep(this.status, o.status, true) && Task.compareDeep(this.statusReason, o.statusReason, true) && Task.compareDeep(this.businessStatus, o.businessStatus, true) && Task.compareDeep(this.intent, o.intent, true) && Task.compareDeep(this.priority, o.priority, true) && Task.compareDeep(this.code, o.code, true) && Task.compareDeep(this.description, o.description, true) && Task.compareDeep(this.focus, o.focus, true) && Task.compareDeep(this.for_, o.for_, true) && Task.compareDeep(this.context, o.context, true) && Task.compareDeep(this.executionPeriod, o.executionPeriod, true) && Task.compareDeep(this.authoredOn, o.authoredOn, true) && Task.compareDeep(this.lastModified, o.lastModified, true) && Task.compareDeep(this.requester, o.requester, true) && Task.compareDeep(this.performerType, o.performerType, true) && Task.compareDeep(this.owner, o.owner, true) && Task.compareDeep(this.reason, o.reason, true) && Task.compareDeep(this.note, o.note, true) && Task.compareDeep(this.relevantHistory, o.relevantHistory, true) && Task.compareDeep(this.restriction, o.restriction, true) && Task.compareDeep(this.input, o.input, true) && Task.compareDeep(this.output, o.output, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Task)) {
            return false;
        }
        Task o = (Task)other_;
        return Task.compareValues(this.status, o.status, true) && Task.compareValues(this.intent, o.intent, true) && Task.compareValues(this.priority, o.priority, true) && Task.compareValues(this.description, o.description, true) && Task.compareValues(this.authoredOn, o.authoredOn, true) && Task.compareValues(this.lastModified, o.lastModified, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.definition, this.basedOn, this.groupIdentifier, this.partOf, this.status, this.statusReason, this.businessStatus, this.intent, this.priority, this.code, this.description, this.focus, this.for_, this.context, this.executionPeriod, this.authoredOn, this.lastModified, this.requester, this.performerType, this.owner, this.reason, this.note, this.relevantHistory, this.restriction, this.input, this.output);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Task;
    }

    @Block
    public static class TaskOutputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for output", formalDefinition="The name of the Output parameter.")
        protected CodeableConcept type;
        @Child(name="value", type={}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Result of output", formalDefinition="The value of the Output parameter as a basic type.")
        protected Type value;
        private static final long serialVersionUID = -852629026L;

        public TaskOutputComponent() {
        }

        public TaskOutputComponent(CodeableConcept type, Type value) {
            this.type = type;
            this.value = value;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskOutputComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public TaskOutputComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public TaskOutputComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The name of the Output parameter.", 0, 1, this.type));
            children.add(new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The name of the Output parameter.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -786218365: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1668687056: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410178407: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1249932027: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 26529417: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172354: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -765667124: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 944904545: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -2026205465: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -130498310: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -540985785: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1406282469: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
                case -1858636920: {
                    return new Property("value[x]", "*", "The value of the Output parameter as a basic type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"*"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public TaskOutputComponent copy() {
            TaskOutputComponent dst = new TaskOutputComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskOutputComponent)) {
                return false;
            }
            TaskOutputComponent o = (TaskOutputComponent)other_;
            return TaskOutputComponent.compareDeep(this.type, o.type, true) && TaskOutputComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskOutputComponent)) {
                return false;
            }
            TaskOutputComponent o = (TaskOutputComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value);
        }

        @Override
        public String fhirType() {
            return "Task.output";
        }
    }

    @Block
    public static class ParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for the input", formalDefinition="A code or description indicating how the input is intended to be used as part of the task execution.")
        protected CodeableConcept type;
        @Child(name="value", type={}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Content to use in performing the task", formalDefinition="The value of the input parameter as a basic type.")
        protected Type value;
        private static final long serialVersionUID = -852629026L;

        public ParameterComponent() {
        }

        public ParameterComponent(CodeableConcept type, Type value) {
            this.type = type;
            this.value = value;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ParameterComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ParameterComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ParameterComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code or description indicating how the input is intended to be used as part of the task execution.", 0, 1, this.type));
            children.add(new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code or description indicating how the input is intended to be used as part of the task execution.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -786218365: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 231604844: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1668687056: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -497880704: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410178407: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1249932027: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 26529417: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1410172354: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -765667124: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 944904545: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -2026205465: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -130498310: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -962229101: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -540985785: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1406282469: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
                case -1858636920: {
                    return new Property("value[x]", "*", "The value of the input parameter as a basic type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"*"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ParameterComponent copy() {
            ParameterComponent dst = new ParameterComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ParameterComponent)) {
                return false;
            }
            ParameterComponent o = (ParameterComponent)other_;
            return ParameterComponent.compareDeep(this.type, o.type, true) && ParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ParameterComponent)) {
                return false;
            }
            ParameterComponent o = (ParameterComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value);
        }

        @Override
        public String fhirType() {
            return "Task.input";
        }
    }

    @Block
    public static class TaskRestrictionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="repetitions", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How many times to repeat", formalDefinition="Indicates the number of times the requested action should occur.")
        protected PositiveIntType repetitions;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When fulfillment sought", formalDefinition="Over what time-period is fulfillment sought.")
        protected Period period;
        @Child(name="recipient", type={Patient.class, Practitioner.class, RelatedPerson.class, Group.class, Organization.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="For whom is fulfillment sought?", formalDefinition="For requests that are targeted to more than on potential recipient/target, for whom is fulfillment sought?")
        protected List<Reference> recipient;
        protected List<Resource> recipientTarget;
        private static final long serialVersionUID = 1503908360L;

        public PositiveIntType getRepetitionsElement() {
            if (this.repetitions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskRestrictionComponent.repetitions");
                }
                if (Configuration.doAutoCreate()) {
                    this.repetitions = new PositiveIntType();
                }
            }
            return this.repetitions;
        }

        public boolean hasRepetitionsElement() {
            return this.repetitions != null && !this.repetitions.isEmpty();
        }

        public boolean hasRepetitions() {
            return this.repetitions != null && !this.repetitions.isEmpty();
        }

        public TaskRestrictionComponent setRepetitionsElement(PositiveIntType value) {
            this.repetitions = value;
            return this;
        }

        public int getRepetitions() {
            return this.repetitions == null || this.repetitions.isEmpty() ? 0 : (Integer)this.repetitions.getValue();
        }

        public TaskRestrictionComponent setRepetitions(int value) {
            if (this.repetitions == null) {
                this.repetitions = new PositiveIntType();
            }
            this.repetitions.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskRestrictionComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public TaskRestrictionComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<Reference> getRecipient() {
            if (this.recipient == null) {
                this.recipient = new ArrayList<Reference>();
            }
            return this.recipient;
        }

        public TaskRestrictionComponent setRecipient(List<Reference> theRecipient) {
            this.recipient = theRecipient;
            return this;
        }

        public boolean hasRecipient() {
            if (this.recipient == null) {
                return false;
            }
            for (Reference item : this.recipient) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addRecipient() {
            Reference t = new Reference();
            if (this.recipient == null) {
                this.recipient = new ArrayList<Reference>();
            }
            this.recipient.add(t);
            return t;
        }

        public TaskRestrictionComponent addRecipient(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.recipient == null) {
                this.recipient = new ArrayList<Reference>();
            }
            this.recipient.add(t);
            return this;
        }

        public Reference getRecipientFirstRep() {
            if (this.getRecipient().isEmpty()) {
                this.addRecipient();
            }
            return this.getRecipient().get(0);
        }

        @Deprecated
        public List<Resource> getRecipientTarget() {
            if (this.recipientTarget == null) {
                this.recipientTarget = new ArrayList<Resource>();
            }
            return this.recipientTarget;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("repetitions", "positiveInt", "Indicates the number of times the requested action should occur.", 0, 1, this.repetitions));
            children.add(new Property(Task.SP_PERIOD, "Period", "Over what time-period is fulfillment sought.", 0, 1, this.period));
            children.add(new Property("recipient", "Reference(Patient|Practitioner|RelatedPerson|Group|Organization)", "For requests that are targeted to more than on potential recipient/target, for whom is fulfillment sought?", 0, Integer.MAX_VALUE, this.recipient));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 984367650: {
                    return new Property("repetitions", "positiveInt", "Indicates the number of times the requested action should occur.", 0, 1, this.repetitions);
                }
                case -991726143: {
                    return new Property(Task.SP_PERIOD, "Period", "Over what time-period is fulfillment sought.", 0, 1, this.period);
                }
                case 820081177: {
                    return new Property("recipient", "Reference(Patient|Practitioner|RelatedPerson|Group|Organization)", "For requests that are targeted to more than on potential recipient/target, for whom is fulfillment sought?", 0, Integer.MAX_VALUE, this.recipient);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    Base[] baseArray;
                    if (this.repetitions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.repetitions;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case 820081177: {
                    return this.recipient == null ? new Base[]{} : this.recipient.toArray(new Base[this.recipient.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    this.repetitions = this.castToPositiveInt(value);
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
                case 820081177: {
                    this.getRecipient().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("repetitions")) {
                this.repetitions = this.castToPositiveInt(value);
            } else if (name.equals(Task.SP_PERIOD)) {
                this.period = this.castToPeriod(value);
            } else if (name.equals("recipient")) {
                this.getRecipient().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    return this.getRepetitionsElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 820081177: {
                    return this.addRecipient();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 984367650: {
                    return new String[]{"positiveInt"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 820081177: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("repetitions")) {
                throw new FHIRException("Cannot call addChild on a primitive type Task.repetitions");
            }
            if (name.equals(Task.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("recipient")) {
                return this.addRecipient();
            }
            return super.addChild(name);
        }

        @Override
        public TaskRestrictionComponent copy() {
            TaskRestrictionComponent dst = new TaskRestrictionComponent();
            this.copyValues(dst);
            dst.repetitions = this.repetitions == null ? null : this.repetitions.copy();
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.recipient != null) {
                dst.recipient = new ArrayList<Reference>();
                for (Reference i : this.recipient) {
                    dst.recipient.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskRestrictionComponent)) {
                return false;
            }
            TaskRestrictionComponent o = (TaskRestrictionComponent)other_;
            return TaskRestrictionComponent.compareDeep(this.repetitions, o.repetitions, true) && TaskRestrictionComponent.compareDeep(this.period, o.period, true) && TaskRestrictionComponent.compareDeep(this.recipient, o.recipient, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskRestrictionComponent)) {
                return false;
            }
            TaskRestrictionComponent o = (TaskRestrictionComponent)other_;
            return TaskRestrictionComponent.compareValues(this.repetitions, o.repetitions, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.repetitions, this.period, this.recipient);
        }

        @Override
        public String fhirType() {
            return "Task.restriction";
        }
    }

    @Block
    public static class TaskRequesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="agent", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Individual asking for task", formalDefinition="The device, practitioner, etc. who initiated the task.")
        protected Reference agent;
        protected Resource agentTarget;
        @Child(name="onBehalfOf", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization individual is acting for", formalDefinition="The organization the device or practitioner was acting on behalf of when they initiated the task.")
        protected Reference onBehalfOf;
        protected Organization onBehalfOfTarget;
        private static final long serialVersionUID = -71453027L;

        public TaskRequesterComponent() {
        }

        public TaskRequesterComponent(Reference agent) {
            this.agent = agent;
        }

        public Reference getAgent() {
            if (this.agent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskRequesterComponent.agent");
                }
                if (Configuration.doAutoCreate()) {
                    this.agent = new Reference();
                }
            }
            return this.agent;
        }

        public boolean hasAgent() {
            return this.agent != null && !this.agent.isEmpty();
        }

        public TaskRequesterComponent setAgent(Reference value) {
            this.agent = value;
            return this;
        }

        public Resource getAgentTarget() {
            return this.agentTarget;
        }

        public TaskRequesterComponent setAgentTarget(Resource value) {
            this.agentTarget = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public TaskRequesterComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Organization getOnBehalfOfTarget() {
            if (this.onBehalfOfTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TaskRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOfTarget = new Organization();
                }
            }
            return this.onBehalfOfTarget;
        }

        public TaskRequesterComponent setOnBehalfOfTarget(Organization value) {
            this.onBehalfOfTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("agent", "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "The device, practitioner, etc. who initiated the task.", 0, 1, this.agent));
            children.add(new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of when they initiated the task.", 0, 1, this.onBehalfOf));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 92750597: {
                    return new Property("agent", "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "The device, practitioner, etc. who initiated the task.", 0, 1, this.agent);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of when they initiated the task.", 0, 1, this.onBehalfOf);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    Base[] baseArray;
                    if (this.agent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.agent;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    this.agent = this.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = this.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return this.getAgent();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = new Reference();
                return this.agent;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            return super.addChild(name);
        }

        @Override
        public TaskRequesterComponent copy() {
            TaskRequesterComponent dst = new TaskRequesterComponent();
            this.copyValues(dst);
            dst.agent = this.agent == null ? null : this.agent.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskRequesterComponent)) {
                return false;
            }
            TaskRequesterComponent o = (TaskRequesterComponent)other_;
            return TaskRequesterComponent.compareDeep(this.agent, o.agent, true) && TaskRequesterComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TaskRequesterComponent)) {
                return false;
            }
            TaskRequesterComponent o = (TaskRequesterComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.agent, this.onBehalfOf);
        }

        @Override
        public String fhirType() {
            return "Task.requester";
        }
    }

    public static class TaskPriorityEnumFactory
    implements EnumFactory<TaskPriority> {
        @Override
        public TaskPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return TaskPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return TaskPriority.URGENT;
            }
            if ("asap".equals(codeString)) {
                return TaskPriority.ASAP;
            }
            if ("stat".equals(codeString)) {
                return TaskPriority.STAT;
            }
            throw new IllegalArgumentException("Unknown TaskPriority code '" + codeString + "'");
        }

        public Enumeration<TaskPriority> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TaskPriority>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<TaskPriority>(this, TaskPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<TaskPriority>(this, TaskPriority.URGENT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<TaskPriority>(this, TaskPriority.ASAP);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<TaskPriority>(this, TaskPriority.STAT);
            }
            throw new FHIRException("Unknown TaskPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(TaskPriority code) {
            if (code == TaskPriority.ROUTINE) {
                return "routine";
            }
            if (code == TaskPriority.URGENT) {
                return "urgent";
            }
            if (code == TaskPriority.ASAP) {
                return "asap";
            }
            if (code == TaskPriority.STAT) {
                return "stat";
            }
            return "?";
        }

        @Override
        public String toSystem(TaskPriority code) {
            return code.getSystem();
        }
    }

    public static enum TaskPriority {
        ROUTINE,
        URGENT,
        ASAP,
        STAT,
        NULL;


        public static TaskPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TaskPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case ASAP: {
                    return "asap";
                }
                case STAT: {
                    return "stat";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/request-priority";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has normal priority";
                }
                case URGENT: {
                    return "The request should be actioned promptly - higher priority than routine";
                }
                case ASAP: {
                    return "The request should be actioned as soon as possible - higher priority than urgent";
                }
                case STAT: {
                    return "The request should be actioned immediately - highest possible priority.  E.g. an emergency";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case ASAP: {
                    return "ASAP";
                }
                case STAT: {
                    return "STAT";
                }
            }
            return "?";
        }
    }

    public static class TaskIntentEnumFactory
    implements EnumFactory<TaskIntent> {
        @Override
        public TaskIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return TaskIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return TaskIntent.PLAN;
            }
            if ("order".equals(codeString)) {
                return TaskIntent.ORDER;
            }
            if ("original-order".equals(codeString)) {
                return TaskIntent.ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return TaskIntent.REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return TaskIntent.FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return TaskIntent.INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return TaskIntent.OPTION;
            }
            throw new IllegalArgumentException("Unknown TaskIntent code '" + codeString + "'");
        }

        public Enumeration<TaskIntent> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TaskIntent>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.PROPOSAL);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.PLAN);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.ORDER);
            }
            if ("original-order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.ORIGINALORDER);
            }
            if ("reflex-order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.REFLEXORDER);
            }
            if ("filler-order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.FILLERORDER);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.INSTANCEORDER);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<TaskIntent>(this, TaskIntent.OPTION);
            }
            throw new FHIRException("Unknown TaskIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(TaskIntent code) {
            if (code == TaskIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == TaskIntent.PLAN) {
                return "plan";
            }
            if (code == TaskIntent.ORDER) {
                return "order";
            }
            if (code == TaskIntent.ORIGINALORDER) {
                return "original-order";
            }
            if (code == TaskIntent.REFLEXORDER) {
                return "reflex-order";
            }
            if (code == TaskIntent.FILLERORDER) {
                return "filler-order";
            }
            if (code == TaskIntent.INSTANCEORDER) {
                return "instance-order";
            }
            if (code == TaskIntent.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(TaskIntent code) {
            return code.getSystem();
        }
    }

    public static enum TaskIntent {
        PROPOSAL,
        PLAN,
        ORDER,
        ORIGINALORDER,
        REFLEXORDER,
        FILLERORDER,
        INSTANCEORDER,
        OPTION,
        NULL;


        public static TaskIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TaskIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case ORIGINALORDER: {
                    return "original-order";
                }
                case REFLEXORDER: {
                    return "reflex-order";
                }
                case FILLERORDER: {
                    return "filler-order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case OPTION: {
                    return "option";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORIGINALORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case REFLEXORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case FILLERORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/request-intent";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that doesn't have an intention to ensure it occurs and without providing an authorization to act";
                }
                case PLAN: {
                    return "The request represents an intension to ensure something occurs without providing an authorization for others to act";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action";
                }
                case ORIGINALORDER: {
                    return "The request represents an original authorization for action";
                }
                case REFLEXORDER: {
                    return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization";
                }
                case FILLERORDER: {
                    return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order";
                }
                case INSTANCEORDER: {
                    return "An order created in fulfillment of a broader order that represents the authorization for a single activity occurrence.  E.g. The administration of a single dose of a drug.";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestGroup that establishes timing, conditionality and/or other constraints among a set of requests.\n\nRefer to [[[RequestGroup]]] for additional information on how this status is used";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case ORIGINALORDER: {
                    return "Original Order";
                }
                case REFLEXORDER: {
                    return "Reflex Order";
                }
                case FILLERORDER: {
                    return "Filler Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case OPTION: {
                    return "Option";
                }
            }
            return "?";
        }
    }

    public static class TaskStatusEnumFactory
    implements EnumFactory<TaskStatus> {
        @Override
        public TaskStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return TaskStatus.DRAFT;
            }
            if ("requested".equals(codeString)) {
                return TaskStatus.REQUESTED;
            }
            if ("received".equals(codeString)) {
                return TaskStatus.RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return TaskStatus.ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return TaskStatus.REJECTED;
            }
            if ("ready".equals(codeString)) {
                return TaskStatus.READY;
            }
            if ("cancelled".equals(codeString)) {
                return TaskStatus.CANCELLED;
            }
            if ("in-progress".equals(codeString)) {
                return TaskStatus.INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return TaskStatus.ONHOLD;
            }
            if ("failed".equals(codeString)) {
                return TaskStatus.FAILED;
            }
            if ("completed".equals(codeString)) {
                return TaskStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return TaskStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown TaskStatus code '" + codeString + "'");
        }

        public Enumeration<TaskStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TaskStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.DRAFT);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.REQUESTED);
            }
            if ("received".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.RECEIVED);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.ACCEPTED);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.REJECTED);
            }
            if ("ready".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.READY);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.CANCELLED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.INPROGRESS);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.ONHOLD);
            }
            if ("failed".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.FAILED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<TaskStatus>(this, TaskStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown TaskStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(TaskStatus code) {
            if (code == TaskStatus.DRAFT) {
                return "draft";
            }
            if (code == TaskStatus.REQUESTED) {
                return "requested";
            }
            if (code == TaskStatus.RECEIVED) {
                return "received";
            }
            if (code == TaskStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == TaskStatus.REJECTED) {
                return "rejected";
            }
            if (code == TaskStatus.READY) {
                return "ready";
            }
            if (code == TaskStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == TaskStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == TaskStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == TaskStatus.FAILED) {
                return "failed";
            }
            if (code == TaskStatus.COMPLETED) {
                return "completed";
            }
            if (code == TaskStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(TaskStatus code) {
            return code.getSystem();
        }
    }

    public static enum TaskStatus {
        DRAFT,
        REQUESTED,
        RECEIVED,
        ACCEPTED,
        REJECTED,
        READY,
        CANCELLED,
        INPROGRESS,
        ONHOLD,
        FAILED,
        COMPLETED,
        ENTEREDINERROR,
        NULL;


        public static TaskStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("received".equals(codeString)) {
                return RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("ready".equals(codeString)) {
                return READY;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("failed".equals(codeString)) {
                return FAILED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TaskStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case REQUESTED: {
                    return "requested";
                }
                case RECEIVED: {
                    return "received";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case REJECTED: {
                    return "rejected";
                }
                case READY: {
                    return "ready";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case FAILED: {
                    return "failed";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/task-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case RECEIVED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case READY: {
                    return "http://hl7.org/fhir/task-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/task-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/task-status";
                }
                case FAILED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/task-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/task-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The task is not yet ready to be acted upon.";
                }
                case REQUESTED: {
                    return "The task is ready to be acted upon and action is sought.";
                }
                case RECEIVED: {
                    return "A potential performer has claimed ownership of the task and is evaluating whether to perform it.";
                }
                case ACCEPTED: {
                    return "The potential performer has agreed to execute the task but has not yet started work.";
                }
                case REJECTED: {
                    return "The potential performer who claimed ownership of the task has decided not to execute it prior to performing any action.";
                }
                case READY: {
                    return "Task is ready to be performed, but no action has yet been taken.  Used in place of requested/received/accepted/rejected when request assignment and acceptance is a given.";
                }
                case CANCELLED: {
                    return "The task was not completed.";
                }
                case INPROGRESS: {
                    return "Task has been started but is not yet complete.";
                }
                case ONHOLD: {
                    return "Task has been started but work has been paused.";
                }
                case FAILED: {
                    return "The task was attempted but could not be completed due to some error.";
                }
                case COMPLETED: {
                    return "The task has been completed.";
                }
                case ENTEREDINERROR: {
                    return "The task should never have existed and is retained only because of the possibility it may have used.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case RECEIVED: {
                    return "Received";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case READY: {
                    return "Ready";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case FAILED: {
                    return "Failed";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

