/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="SupplyRequest", profile="http://hl7.org/fhir/Profile/SupplyRequest")
public class SupplyRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier for this supply request.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | suspended +", formalDefinition="Status of the supply request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplyrequest-status")
    protected Enumeration<SupplyRequestStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The kind of supply (central, non-stock, etc.)", formalDefinition="Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplyrequest-kind")
    protected CodeableConcept category;
    @Child(name="priority", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly this SupplyRequest should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<RequestPriority> priority;
    @Child(name="orderedItem", type={}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The item being requested", formalDefinition="The item being requested.")
    protected SupplyRequestOrderedItemComponent orderedItem;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the request should be fulfilled", formalDefinition="When the request should be fulfilled.")
    protected Type occurrence;
    @Child(name="authoredOn", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the request was made", formalDefinition="When the request was made.")
    protected DateTimeType authoredOn;
    @Child(name="requester", type={}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what is requesting service", formalDefinition="The individual who initiated the request and has responsibility for its activation.")
    protected SupplyRequestRequesterComponent requester;
    @Child(name="supplier", type={Organization.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is intended to fulfill the request", formalDefinition="Who is intended to fulfill the request.")
    protected List<Reference> supplier;
    protected List<Organization> supplierTarget;
    @Child(name="reason", type={CodeableConcept.class, Reference.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why the supply item was requested", formalDefinition="Why the supply item was requested.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplyrequest-reason")
    protected Type reason;
    @Child(name="deliverFrom", type={Organization.class, Location.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The origin of the supply", formalDefinition="Where the supply is expected to come from.")
    protected Reference deliverFrom;
    protected Resource deliverFromTarget;
    @Child(name="deliverTo", type={Organization.class, Location.class, Patient.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The destination of the supply", formalDefinition="Where the supply is destined to go.")
    protected Reference deliverTo;
    protected Resource deliverToTarget;
    private static final long serialVersionUID = 43957782L;
    @SearchParamDefinition(name="requester", path="SupplyRequest.requester.agent", description="Individual making the request", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("SupplyRequest:requester").toLocked();
    @SearchParamDefinition(name="date", path="SupplyRequest.authoredOn", description="When the request was made", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="SupplyRequest.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="supplier", path="SupplyRequest.supplier", description="Who is intended to fulfill the request", type="reference", target={Organization.class})
    public static final String SP_SUPPLIER = "supplier";
    public static final ReferenceClientParam SUPPLIER = new ReferenceClientParam("supplier");
    public static final Include INCLUDE_SUPPLIER = new Include("SupplyRequest:supplier").toLocked();
    @SearchParamDefinition(name="category", path="SupplyRequest.category", description="The kind of supply (central, non-stock, etc.)", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="SupplyRequest.status", description="draft | active | suspended +", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SupplyRequest setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<SupplyRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SupplyRequestStatus>(new SupplyRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SupplyRequest setStatusElement(Enumeration<SupplyRequestStatus> value) {
        this.status = value;
        return this;
    }

    public SupplyRequestStatus getStatus() {
        return this.status == null ? null : (SupplyRequestStatus)((Object)this.status.getValue());
    }

    public SupplyRequest setStatus(SupplyRequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<SupplyRequestStatus>(new SupplyRequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public SupplyRequest setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Enumeration<RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<RequestPriority>(new RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public SupplyRequest setPriorityElement(Enumeration<RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public RequestPriority getPriority() {
        return this.priority == null ? null : (RequestPriority)((Object)this.priority.getValue());
    }

    public SupplyRequest setPriority(RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<RequestPriority>(new RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public SupplyRequestOrderedItemComponent getOrderedItem() {
        if (this.orderedItem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.orderedItem");
            }
            if (Configuration.doAutoCreate()) {
                this.orderedItem = new SupplyRequestOrderedItemComponent();
            }
        }
        return this.orderedItem;
    }

    public boolean hasOrderedItem() {
        return this.orderedItem != null && !this.orderedItem.isEmpty();
    }

    public SupplyRequest setOrderedItem(SupplyRequestOrderedItemComponent value) {
        this.orderedItem = value;
        return this;
    }

    public Type getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this != null && this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public SupplyRequest setOccurrence(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new FHIRFormatError("Not the right type for SupplyRequest.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public SupplyRequest setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public SupplyRequest setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public SupplyRequestRequesterComponent getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new SupplyRequestRequesterComponent();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public SupplyRequest setRequester(SupplyRequestRequesterComponent value) {
        this.requester = value;
        return this;
    }

    public List<Reference> getSupplier() {
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        return this.supplier;
    }

    public SupplyRequest setSupplier(List<Reference> theSupplier) {
        this.supplier = theSupplier;
        return this;
    }

    public boolean hasSupplier() {
        if (this.supplier == null) {
            return false;
        }
        for (Reference item : this.supplier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupplier() {
        Reference t = new Reference();
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        this.supplier.add(t);
        return t;
    }

    public SupplyRequest addSupplier(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        this.supplier.add(t);
        return this;
    }

    public Reference getSupplierFirstRep() {
        if (this.getSupplier().isEmpty()) {
            this.addSupplier();
        }
        return this.getSupplier().get(0);
    }

    @Deprecated
    public List<Organization> getSupplierTarget() {
        if (this.supplierTarget == null) {
            this.supplierTarget = new ArrayList<Organization>();
        }
        return this.supplierTarget;
    }

    @Deprecated
    public Organization addSupplierTarget() {
        Organization r = new Organization();
        if (this.supplierTarget == null) {
            this.supplierTarget = new ArrayList<Organization>();
        }
        this.supplierTarget.add(r);
        return r;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (this.reason == null) {
            return null;
        }
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this != null && this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (this.reason == null) {
            return null;
        }
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this != null && this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public SupplyRequest setReason(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for SupplyRequest.reason[x]: " + value.fhirType());
        }
        this.reason = value;
        return this;
    }

    public Reference getDeliverFrom() {
        if (this.deliverFrom == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.deliverFrom");
            }
            if (Configuration.doAutoCreate()) {
                this.deliverFrom = new Reference();
            }
        }
        return this.deliverFrom;
    }

    public boolean hasDeliverFrom() {
        return this.deliverFrom != null && !this.deliverFrom.isEmpty();
    }

    public SupplyRequest setDeliverFrom(Reference value) {
        this.deliverFrom = value;
        return this;
    }

    public Resource getDeliverFromTarget() {
        return this.deliverFromTarget;
    }

    public SupplyRequest setDeliverFromTarget(Resource value) {
        this.deliverFromTarget = value;
        return this;
    }

    public Reference getDeliverTo() {
        if (this.deliverTo == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.deliverTo");
            }
            if (Configuration.doAutoCreate()) {
                this.deliverTo = new Reference();
            }
        }
        return this.deliverTo;
    }

    public boolean hasDeliverTo() {
        return this.deliverTo != null && !this.deliverTo.isEmpty();
    }

    public SupplyRequest setDeliverTo(Reference value) {
        this.deliverTo = value;
        return this;
    }

    public Resource getDeliverToTarget() {
        return this.deliverToTarget;
    }

    public SupplyRequest setDeliverToTarget(Resource value) {
        this.deliverToTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this supply request.", 0, 1, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Status of the supply request.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process.", 0, 1, this.category));
        children.add(new Property("priority", "code", "Indicates how quickly this SupplyRequest should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("orderedItem", "", "The item being requested.", 0, 1, this.orderedItem));
        children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence));
        children.add(new Property("authoredOn", "dateTime", "When the request was made.", 0, 1, this.authoredOn));
        children.add(new Property(SP_REQUESTER, "", "The individual who initiated the request and has responsibility for its activation.", 0, 1, this.requester));
        children.add(new Property(SP_SUPPLIER, "Reference(Organization)", "Who is intended to fulfill the request.", 0, Integer.MAX_VALUE, this.supplier));
        children.add(new Property("reason[x]", "CodeableConcept|Reference(Any)", "Why the supply item was requested.", 0, 1, this.reason));
        children.add(new Property("deliverFrom", "Reference(Organization|Location)", "Where the supply is expected to come from.", 0, 1, this.deliverFrom));
        children.add(new Property("deliverTo", "Reference(Organization|Location|Patient)", "Where the supply is destined to go.", 0, 1, this.deliverTo));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this supply request.", 0, 1, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Status of the supply request.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process.", 0, 1, this.category);
            }
            case -1165461084: {
                return new Property("priority", "code", "Indicates how quickly this SupplyRequest should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case 2129914144: {
                return new Property("orderedItem", "", "The item being requested.", 0, 1, this.orderedItem);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "When the request was made.", 0, 1, this.authoredOn);
            }
            case 693933948: {
                return new Property(SP_REQUESTER, "", "The individual who initiated the request and has responsibility for its activation.", 0, 1, this.requester);
            }
            case -1663305268: {
                return new Property(SP_SUPPLIER, "Reference(Organization)", "Who is intended to fulfill the request.", 0, Integer.MAX_VALUE, this.supplier);
            }
            case -669418564: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Why the supply item was requested.", 0, 1, this.reason);
            }
            case -934964668: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Why the supply item was requested.", 0, 1, this.reason);
            }
            case -610155331: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Why the supply item was requested.", 0, 1, this.reason);
            }
            case -1146218137: {
                return new Property("reason[x]", "CodeableConcept|Reference(Any)", "Why the supply item was requested.", 0, 1, this.reason);
            }
            case -949323153: {
                return new Property("deliverFrom", "Reference(Organization|Location)", "Where the supply is expected to come from.", 0, 1, this.deliverFrom);
            }
            case -242327936: {
                return new Property("deliverTo", "Reference(Organization|Location|Patient)", "Where the supply is destined to go.", 0, 1, this.deliverTo);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case 2129914144: {
                Base[] baseArray;
                if (this.orderedItem == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.orderedItem;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.occurrence;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.requester;
                }
                return baseArray;
            }
            case -1663305268: {
                return this.supplier == null ? new Base[]{} : this.supplier.toArray(new Base[this.supplier.size()]);
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.reason;
                }
                return baseArray;
            }
            case -949323153: {
                Base[] baseArray;
                if (this.deliverFrom == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.deliverFrom;
                }
                return baseArray;
            }
            case -242327936: {
                Base[] baseArray;
                if (this.deliverTo == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.deliverTo;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new SupplyRequestStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                return value;
            }
            case -1165461084: {
                value = new RequestPriorityEnumFactory().fromType(this.castToCode(value));
                this.priority = value;
                return value;
            }
            case 2129914144: {
                this.orderedItem = (SupplyRequestOrderedItemComponent)((Object)value);
                return value;
            }
            case 1687874001: {
                this.occurrence = this.castToType(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = this.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = (SupplyRequestRequesterComponent)((Object)value);
                return value;
            }
            case -1663305268: {
                this.getSupplier().add(this.castToReference(value));
                return value;
            }
            case -934964668: {
                this.reason = this.castToType(value);
                return value;
            }
            case -949323153: {
                this.deliverFrom = this.castToReference(value);
                return value;
            }
            case -242327936: {
                this.deliverTo = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new SupplyRequestStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals("priority")) {
            value = new RequestPriorityEnumFactory().fromType(this.castToCode(value));
            this.priority = value;
        } else if (name.equals("orderedItem")) {
            this.orderedItem = (SupplyRequestOrderedItemComponent)((Object)value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = this.castToType(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = this.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = (SupplyRequestRequesterComponent)((Object)value);
        } else if (name.equals(SP_SUPPLIER)) {
            this.getSupplier().add(this.castToReference(value));
        } else if (name.equals("reason[x]")) {
            this.reason = this.castToType(value);
        } else if (name.equals("deliverFrom")) {
            this.deliverFrom = this.castToReference(value);
        } else if (name.equals("deliverTo")) {
            this.deliverTo = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.getCategory();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case 2129914144: {
                return this.getOrderedItem();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -1663305268: {
                return this.addSupplier();
            }
            case -669418564: {
                return this.getReason();
            }
            case -934964668: {
                return this.getReason();
            }
            case -949323153: {
                return this.getDeliverFrom();
            }
            case -242327936: {
                return this.getDeliverTo();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1165461084: {
                return new String[]{"code"};
            }
            case 2129914144: {
                return new String[0];
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[0];
            }
            case -1663305268: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case -949323153: {
                return new String[]{"Reference"};
            }
            case -242327936: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type SupplyRequest.status");
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a primitive type SupplyRequest.priority");
        }
        if (name.equals("orderedItem")) {
            this.orderedItem = new SupplyRequestOrderedItemComponent();
            return this.orderedItem;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type SupplyRequest.authoredOn");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new SupplyRequestRequesterComponent();
            return this.requester;
        }
        if (name.equals(SP_SUPPLIER)) {
            return this.addSupplier();
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals("deliverFrom")) {
            this.deliverFrom = new Reference();
            return this.deliverFrom;
        }
        if (name.equals("deliverTo")) {
            this.deliverTo = new Reference();
            return this.deliverTo;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SupplyRequest";
    }

    @Override
    public SupplyRequest copy() {
        SupplyRequest dst = new SupplyRequest();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.orderedItem = this.orderedItem == null ? null : this.orderedItem.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        SupplyRequestRequesterComponent supplyRequestRequesterComponent = dst.requester = this.requester == null ? null : this.requester.copy();
        if (this.supplier != null) {
            dst.supplier = new ArrayList<Reference>();
            for (Reference i : this.supplier) {
                dst.supplier.add(i.copy());
            }
        }
        dst.reason = this.reason == null ? null : this.reason.copy();
        dst.deliverFrom = this.deliverFrom == null ? null : this.deliverFrom.copy();
        dst.deliverTo = this.deliverTo == null ? null : this.deliverTo.copy();
        return dst;
    }

    protected SupplyRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SupplyRequest)) {
            return false;
        }
        SupplyRequest o = (SupplyRequest)other_;
        return SupplyRequest.compareDeep(this.identifier, o.identifier, true) && SupplyRequest.compareDeep(this.status, o.status, true) && SupplyRequest.compareDeep(this.category, o.category, true) && SupplyRequest.compareDeep(this.priority, o.priority, true) && SupplyRequest.compareDeep(this.orderedItem, o.orderedItem, true) && SupplyRequest.compareDeep(this.occurrence, o.occurrence, true) && SupplyRequest.compareDeep(this.authoredOn, o.authoredOn, true) && SupplyRequest.compareDeep(this.requester, o.requester, true) && SupplyRequest.compareDeep(this.supplier, o.supplier, true) && SupplyRequest.compareDeep(this.reason, o.reason, true) && SupplyRequest.compareDeep(this.deliverFrom, o.deliverFrom, true) && SupplyRequest.compareDeep(this.deliverTo, o.deliverTo, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SupplyRequest)) {
            return false;
        }
        SupplyRequest o = (SupplyRequest)other_;
        return SupplyRequest.compareValues(this.status, o.status, true) && SupplyRequest.compareValues(this.priority, o.priority, true) && SupplyRequest.compareValues(this.authoredOn, o.authoredOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.category, this.priority, this.orderedItem, this.occurrence, this.authoredOn, this.requester, this.supplier, this.reason, this.deliverFrom, this.deliverTo);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SupplyRequest;
    }

    @Block
    public static class SupplyRequestRequesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="agent", type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class, Device.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Individual making the request", formalDefinition="The device, practitioner, etc. who initiated the request.")
        protected Reference agent;
        protected Resource agentTarget;
        @Child(name="onBehalfOf", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization agent is acting for", formalDefinition="The organization the device or practitioner was acting on behalf of.")
        protected Reference onBehalfOf;
        protected Organization onBehalfOfTarget;
        private static final long serialVersionUID = -71453027L;

        public SupplyRequestRequesterComponent() {
        }

        public SupplyRequestRequesterComponent(Reference agent) {
            this.agent = agent;
        }

        public Reference getAgent() {
            if (this.agent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupplyRequestRequesterComponent.agent");
                }
                if (Configuration.doAutoCreate()) {
                    this.agent = new Reference();
                }
            }
            return this.agent;
        }

        public boolean hasAgent() {
            return this.agent != null && !this.agent.isEmpty();
        }

        public SupplyRequestRequesterComponent setAgent(Reference value) {
            this.agent = value;
            return this;
        }

        public Resource getAgentTarget() {
            return this.agentTarget;
        }

        public SupplyRequestRequesterComponent setAgentTarget(Resource value) {
            this.agentTarget = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupplyRequestRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public SupplyRequestRequesterComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Organization getOnBehalfOfTarget() {
            if (this.onBehalfOfTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupplyRequestRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOfTarget = new Organization();
                }
            }
            return this.onBehalfOfTarget;
        }

        public SupplyRequestRequesterComponent setOnBehalfOfTarget(Organization value) {
            this.onBehalfOfTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("agent", "Reference(Practitioner|Organization|Patient|RelatedPerson|Device)", "The device, practitioner, etc. who initiated the request.", 0, 1, this.agent));
            children.add(new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 92750597: {
                    return new Property("agent", "Reference(Practitioner|Organization|Patient|RelatedPerson|Device)", "The device, practitioner, etc. who initiated the request.", 0, 1, this.agent);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    Base[] baseArray;
                    if (this.agent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.agent;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    this.agent = this.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = this.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return this.getAgent();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = new Reference();
                return this.agent;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            return super.addChild(name);
        }

        @Override
        public SupplyRequestRequesterComponent copy() {
            SupplyRequestRequesterComponent dst = new SupplyRequestRequesterComponent();
            this.copyValues(dst);
            dst.agent = this.agent == null ? null : this.agent.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyRequestRequesterComponent)) {
                return false;
            }
            SupplyRequestRequesterComponent o = (SupplyRequestRequesterComponent)other_;
            return SupplyRequestRequesterComponent.compareDeep(this.agent, o.agent, true) && SupplyRequestRequesterComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyRequestRequesterComponent)) {
                return false;
            }
            SupplyRequestRequesterComponent o = (SupplyRequestRequesterComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.agent, this.onBehalfOf);
        }

        @Override
        public String fhirType() {
            return "SupplyRequest.requester";
        }
    }

    @Block
    public static class SupplyRequestOrderedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={Quantity.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The requested amount of the item indicated", formalDefinition="The amount that is being ordered of the indicated item.")
        protected Quantity quantity;
        @Child(name="item", type={CodeableConcept.class, Medication.class, Substance.class, Device.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Medication, Substance, or Device requested to be supplied", formalDefinition="The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/supply-item")
        protected Type item;
        private static final long serialVersionUID = 1628109307L;

        public SupplyRequestOrderedItemComponent() {
        }

        public SupplyRequestOrderedItemComponent(Quantity quantity) {
            this.quantity = quantity;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupplyRequestOrderedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SupplyRequestOrderedItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Type getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public SupplyRequestOrderedItemComponent setItem(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for SupplyRequest.orderedItem.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("quantity", "Quantity", "The amount that is being ordered of the indicated item.", 0, 1, this.quantity));
            children.add(new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The amount that is being ordered of the indicated item.", 0, 1, this.quantity);
                }
                case 2116201613: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case 3242771: {
                    this.item = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("item[x]")) {
                this.item = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return this.getQuantity();
                }
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 3242771: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public SupplyRequestOrderedItemComponent copy() {
            SupplyRequestOrderedItemComponent dst = new SupplyRequestOrderedItemComponent();
            this.copyValues(dst);
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.item = this.item == null ? null : this.item.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyRequestOrderedItemComponent)) {
                return false;
            }
            SupplyRequestOrderedItemComponent o = (SupplyRequestOrderedItemComponent)other_;
            return SupplyRequestOrderedItemComponent.compareDeep(this.quantity, o.quantity, true) && SupplyRequestOrderedItemComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyRequestOrderedItemComponent)) {
                return false;
            }
            SupplyRequestOrderedItemComponent o = (SupplyRequestOrderedItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.quantity, this.item);
        }

        @Override
        public String fhirType() {
            return "SupplyRequest.orderedItem";
        }
    }

    public static class RequestPriorityEnumFactory
    implements EnumFactory<RequestPriority> {
        @Override
        public RequestPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return RequestPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return RequestPriority.URGENT;
            }
            if ("asap".equals(codeString)) {
                return RequestPriority.ASAP;
            }
            if ("stat".equals(codeString)) {
                return RequestPriority.STAT;
            }
            throw new IllegalArgumentException("Unknown RequestPriority code '" + codeString + "'");
        }

        public Enumeration<RequestPriority> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestPriority>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.URGENT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ASAP);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.STAT);
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestPriority code) {
            if (code == RequestPriority.ROUTINE) {
                return "routine";
            }
            if (code == RequestPriority.URGENT) {
                return "urgent";
            }
            if (code == RequestPriority.ASAP) {
                return "asap";
            }
            if (code == RequestPriority.STAT) {
                return "stat";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestPriority code) {
            return code.getSystem();
        }
    }

    public static enum RequestPriority {
        ROUTINE,
        URGENT,
        ASAP,
        STAT,
        NULL;


        public static RequestPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case ASAP: {
                    return "asap";
                }
                case STAT: {
                    return "stat";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/request-priority";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has normal priority";
                }
                case URGENT: {
                    return "The request should be actioned promptly - higher priority than routine";
                }
                case ASAP: {
                    return "The request should be actioned as soon as possible - higher priority than urgent";
                }
                case STAT: {
                    return "The request should be actioned immediately - highest possible priority.  E.g. an emergency";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case ASAP: {
                    return "ASAP";
                }
                case STAT: {
                    return "STAT";
                }
            }
            return "?";
        }
    }

    public static class SupplyRequestStatusEnumFactory
    implements EnumFactory<SupplyRequestStatus> {
        @Override
        public SupplyRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return SupplyRequestStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return SupplyRequestStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SupplyRequestStatus.SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return SupplyRequestStatus.CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return SupplyRequestStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return SupplyRequestStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return SupplyRequestStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown SupplyRequestStatus code '" + codeString + "'");
        }

        public Enumeration<SupplyRequestStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SupplyRequestStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.DRAFT);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.SUSPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.CANCELLED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown SupplyRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SupplyRequestStatus code) {
            if (code == SupplyRequestStatus.DRAFT) {
                return "draft";
            }
            if (code == SupplyRequestStatus.ACTIVE) {
                return "active";
            }
            if (code == SupplyRequestStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == SupplyRequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == SupplyRequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == SupplyRequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == SupplyRequestStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(SupplyRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum SupplyRequestStatus {
        DRAFT,
        ACTIVE,
        SUSPENDED,
        CANCELLED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static SupplyRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SupplyRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The request has been created but is not yet complete or ready for action";
                }
                case ACTIVE: {
                    return "The request is ready to be acted upon";
                }
                case SUSPENDED: {
                    return "The authorization/request to act has been temporarily withdrawn but is expected to resume in the future";
                }
                case CANCELLED: {
                    return "The authorization/request to act has been terminated prior to the full completion of the intended actions.  No further activity should occur.";
                }
                case COMPLETED: {
                    return "Activity against the request has been sufficiently completed to the satisfaction of the requester";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

