/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Base64BinaryType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Signature")
public class Signature
extends Type
implements ICompositeType {
    @Child(name="type", type={Coding.class}, order=0, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indication of the reason the entity signed the object(s)", formalDefinition="An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/signature-type")
    protected List<Coding> type;
    @Child(name="when", type={InstantType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the signature was created", formalDefinition="When the digital signature was signed.")
    protected InstantType when;
    @Child(name="who", type={UriType.class, Practitioner.class, RelatedPerson.class, Patient.class, Device.class, Organization.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who signed", formalDefinition="A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).")
    protected Type who;
    @Child(name="onBehalfOf", type={UriType.class, Practitioner.class, RelatedPerson.class, Patient.class, Device.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The party represented", formalDefinition="A reference to an application-usable description of the identity that is represented by the signature.")
    protected Type onBehalfOf;
    @Child(name="contentType", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The technical format of the signature", formalDefinition="A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jwt for JWT, and image/* for a graphical image of a signature, etc.")
    protected CodeType contentType;
    @Child(name="blob", type={Base64BinaryType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The actual signature content (XML DigSig. JWT, picture, etc.)", formalDefinition="The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.")
    protected Base64BinaryType blob;
    private static final long serialVersionUID = 1133697310L;

    public Signature() {
    }

    public Signature(InstantType when, Type who) {
        this.when = when;
        this.who = who;
    }

    public List<Coding> getType() {
        if (this.type == null) {
            this.type = new ArrayList<Coding>();
        }
        return this.type;
    }

    public Signature setType(List<Coding> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (Coding item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addType() {
        Coding t = new Coding();
        if (this.type == null) {
            this.type = new ArrayList<Coding>();
        }
        this.type.add(t);
        return t;
    }

    public Signature addType(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<Coding>();
        }
        this.type.add(t);
        return this;
    }

    public Coding getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public InstantType getWhenElement() {
        if (this.when == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.when");
            }
            if (Configuration.doAutoCreate()) {
                this.when = new InstantType();
            }
        }
        return this.when;
    }

    public boolean hasWhenElement() {
        return this.when != null && !this.when.isEmpty();
    }

    public boolean hasWhen() {
        return this.when != null && !this.when.isEmpty();
    }

    public Signature setWhenElement(InstantType value) {
        this.when = value;
        return this;
    }

    public Date getWhen() {
        return this.when == null ? null : (Date)this.when.getValue();
    }

    public Signature setWhen(Date value) {
        if (this.when == null) {
            this.when = new InstantType();
        }
        this.when.setValue(value);
        return this;
    }

    public Type getWho() {
        return this.who;
    }

    public UriType getWhoUriType() throws FHIRException {
        if (this.who == null) {
            return null;
        }
        if (!(this.who instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.who.getClass().getName() + " was encountered");
        }
        return (UriType)this.who;
    }

    public boolean hasWhoUriType() {
        return this != null && this.who instanceof UriType;
    }

    public Reference getWhoReference() throws FHIRException {
        if (this.who == null) {
            return null;
        }
        if (!(this.who instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.who.getClass().getName() + " was encountered");
        }
        return (Reference)this.who;
    }

    public boolean hasWhoReference() {
        return this != null && this.who instanceof Reference;
    }

    public boolean hasWho() {
        return this.who != null && !this.who.isEmpty();
    }

    public Signature setWho(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof UriType) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for Signature.who[x]: " + value.fhirType());
        }
        this.who = value;
        return this;
    }

    public Type getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public UriType getOnBehalfOfUriType() throws FHIRException {
        if (this.onBehalfOf == null) {
            return null;
        }
        if (!(this.onBehalfOf instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.onBehalfOf.getClass().getName() + " was encountered");
        }
        return (UriType)this.onBehalfOf;
    }

    public boolean hasOnBehalfOfUriType() {
        return this != null && this.onBehalfOf instanceof UriType;
    }

    public Reference getOnBehalfOfReference() throws FHIRException {
        if (this.onBehalfOf == null) {
            return null;
        }
        if (!(this.onBehalfOf instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.onBehalfOf.getClass().getName() + " was encountered");
        }
        return (Reference)this.onBehalfOf;
    }

    public boolean hasOnBehalfOfReference() {
        return this != null && this.onBehalfOf instanceof Reference;
    }

    public boolean hasOnBehalfOf() {
        return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
    }

    public Signature setOnBehalfOf(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof UriType) && !(value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for Signature.onBehalfOf[x]: " + value.fhirType());
        }
        this.onBehalfOf = value;
        return this;
    }

    public CodeType getContentTypeElement() {
        if (this.contentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.contentType");
            }
            if (Configuration.doAutoCreate()) {
                this.contentType = new CodeType();
            }
        }
        return this.contentType;
    }

    public boolean hasContentTypeElement() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public boolean hasContentType() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public Signature setContentTypeElement(CodeType value) {
        this.contentType = value;
        return this;
    }

    public String getContentType() {
        return this.contentType == null ? null : (String)this.contentType.getValue();
    }

    public Signature setContentType(String value) {
        if (Utilities.noString(value)) {
            this.contentType = null;
        } else {
            if (this.contentType == null) {
                this.contentType = new CodeType();
            }
            this.contentType.setValue(value);
        }
        return this;
    }

    public Base64BinaryType getBlobElement() {
        if (this.blob == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.blob");
            }
            if (Configuration.doAutoCreate()) {
                this.blob = new Base64BinaryType();
            }
        }
        return this.blob;
    }

    public boolean hasBlobElement() {
        return this.blob != null && !this.blob.isEmpty();
    }

    public boolean hasBlob() {
        return this.blob != null && !this.blob.isEmpty();
    }

    public Signature setBlobElement(Base64BinaryType value) {
        this.blob = value;
        return this;
    }

    public byte[] getBlob() {
        return this.blob == null ? null : this.blob.getValue();
    }

    public Signature setBlob(byte[] value) {
        if (value == null) {
            this.blob = null;
        } else {
            if (this.blob == null) {
                this.blob = new Base64BinaryType();
            }
            this.blob.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "Coding", "An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("when", "instant", "When the digital signature was signed.", 0, 1, this.when));
        children.add(new Property("who[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).", 0, 1, this.who));
        children.add(new Property("onBehalfOf[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that is represented by the signature.", 0, 1, this.onBehalfOf));
        children.add(new Property("contentType", "code", "A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jwt for JWT, and image/* for a graphical image of a signature, etc.", 0, 1, this.contentType));
        children.add(new Property("blob", "base64Binary", "The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.", 0, 1, this.blob));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "Coding", "An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.", 0, Integer.MAX_VALUE, this.type);
            }
            case 3648314: {
                return new Property("when", "instant", "When the digital signature was signed.", 0, 1, this.when);
            }
            case -788654078: {
                return new Property("who[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).", 0, 1, this.who);
            }
            case 117694: {
                return new Property("who[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).", 0, 1, this.who);
            }
            case -788660018: {
                return new Property("who[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).", 0, 1, this.who);
            }
            case 1017243949: {
                return new Property("who[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).", 0, 1, this.who);
            }
            case 418120340: {
                return new Property("onBehalfOf[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that is represented by the signature.", 0, 1, this.onBehalfOf);
            }
            case -14402964: {
                return new Property("onBehalfOf[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that is represented by the signature.", 0, 1, this.onBehalfOf);
            }
            case 418114400: {
                return new Property("onBehalfOf[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that is represented by the signature.", 0, 1, this.onBehalfOf);
            }
            case -1136255425: {
                return new Property("onBehalfOf[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that is represented by the signature.", 0, 1, this.onBehalfOf);
            }
            case -389131437: {
                return new Property("contentType", "code", "A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jwt for JWT, and image/* for a graphical image of a signature, etc.", 0, 1, this.contentType);
            }
            case 3026845: {
                return new Property("blob", "base64Binary", "The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.", 0, 1, this.blob);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 3648314: {
                Base[] baseArray;
                if (this.when == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.when;
                }
                return baseArray;
            }
            case 117694: {
                Base[] baseArray;
                if (this.who == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.who;
                }
                return baseArray;
            }
            case -14402964: {
                Base[] baseArray;
                if (this.onBehalfOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.onBehalfOf;
                }
                return baseArray;
            }
            case -389131437: {
                Base[] baseArray;
                if (this.contentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.contentType;
                }
                return baseArray;
            }
            case 3026845: {
                Base[] baseArray;
                if (this.blob == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.blob;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.getType().add(this.castToCoding(value));
                return value;
            }
            case 3648314: {
                this.when = this.castToInstant(value);
                return value;
            }
            case 117694: {
                this.who = this.castToType(value);
                return value;
            }
            case -14402964: {
                this.onBehalfOf = this.castToType(value);
                return value;
            }
            case -389131437: {
                this.contentType = this.castToCode(value);
                return value;
            }
            case 3026845: {
                this.blob = this.castToBase64Binary(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            this.getType().add(this.castToCoding(value));
        } else if (name.equals("when")) {
            this.when = this.castToInstant(value);
        } else if (name.equals("who[x]")) {
            this.who = this.castToType(value);
        } else if (name.equals("onBehalfOf[x]")) {
            this.onBehalfOf = this.castToType(value);
        } else if (name.equals("contentType")) {
            this.contentType = this.castToCode(value);
        } else if (name.equals("blob")) {
            this.blob = this.castToBase64Binary(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.addType();
            }
            case 3648314: {
                return this.getWhenElement();
            }
            case -788654078: {
                return this.getWho();
            }
            case 117694: {
                return this.getWho();
            }
            case 418120340: {
                return this.getOnBehalfOf();
            }
            case -14402964: {
                return this.getOnBehalfOf();
            }
            case -389131437: {
                return this.getContentTypeElement();
            }
            case 3026845: {
                return this.getBlobElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"Coding"};
            }
            case 3648314: {
                return new String[]{"instant"};
            }
            case 117694: {
                return new String[]{"uri", "Reference"};
            }
            case -14402964: {
                return new String[]{"uri", "Reference"};
            }
            case -389131437: {
                return new String[]{"code"};
            }
            case 3026845: {
                return new String[]{"base64Binary"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals("when")) {
            throw new FHIRException("Cannot call addChild on a primitive type Signature.when");
        }
        if (name.equals("whoUri")) {
            this.who = new UriType();
            return this.who;
        }
        if (name.equals("whoReference")) {
            this.who = new Reference();
            return this.who;
        }
        if (name.equals("onBehalfOfUri")) {
            this.onBehalfOf = new UriType();
            return this.onBehalfOf;
        }
        if (name.equals("onBehalfOfReference")) {
            this.onBehalfOf = new Reference();
            return this.onBehalfOf;
        }
        if (name.equals("contentType")) {
            throw new FHIRException("Cannot call addChild on a primitive type Signature.contentType");
        }
        if (name.equals("blob")) {
            throw new FHIRException("Cannot call addChild on a primitive type Signature.blob");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Signature";
    }

    @Override
    public Signature copy() {
        Signature dst = new Signature();
        this.copyValues(dst);
        if (this.type != null) {
            dst.type = new ArrayList<Coding>();
            for (Coding i : this.type) {
                dst.type.add(i.copy());
            }
        }
        dst.when = this.when == null ? null : this.when.copy();
        dst.who = this.who == null ? null : this.who.copy();
        dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
        dst.contentType = this.contentType == null ? null : this.contentType.copy();
        dst.blob = this.blob == null ? null : this.blob.copy();
        return dst;
    }

    @Override
    protected Signature typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Signature)) {
            return false;
        }
        Signature o = (Signature)other_;
        return Signature.compareDeep(this.type, o.type, true) && Signature.compareDeep(this.when, o.when, true) && Signature.compareDeep(this.who, o.who, true) && Signature.compareDeep(this.onBehalfOf, o.onBehalfOf, true) && Signature.compareDeep(this.contentType, o.contentType, true) && Signature.compareDeep(this.blob, o.blob, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Signature)) {
            return false;
        }
        Signature o = (Signature)other_;
        return Signature.compareValues(this.when, o.when, true) && Signature.compareValues(this.contentType, o.contentType, true) && Signature.compareValues(this.blob, o.blob, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.type, this.when, this.who, this.onBehalfOf, this.contentType, this.blob);
    }
}

