/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Measure", profile="http://hl7.org/fhir/Profile/Measure")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "status", "experimental", "date", "publisher", "description", "purpose", "usage", "approvalDate", "lastReviewDate", "effectivePeriod", "useContext", "jurisdiction", "topic", "contributor", "contact", "copyright", "relatedArtifact", "library", "disclaimer", "scoring", "compositeScoring", "type", "riskAdjustment", "rateAggregation", "rationale", "clinicalRecommendationStatement", "improvementNotation", "definition", "guidance", "set", "group", "supplementalData"})
public class Measure
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the measure", formalDefinition="A formal identifier that is used to identify this measure when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="purpose", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this measure is defined", formalDefinition="Explaination of why this measure is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="usage", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the clinical usage of the measure", formalDefinition="A detailed description of how the measure is used from a clinical perspective.")
    protected StringType usage;
    @Child(name="approvalDate", type={DateType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the measure was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the measure was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval, but doesn't change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the measure is expected to be used", formalDefinition="The period during which the measure content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. Education, Treatment, Assessment, etc", formalDefinition="Descriptive topics related to the content of the measure. Topics provide a high-level categorization of the type of the measure that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="contributor", type={Contributor.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A content contributor", formalDefinition="A contributor to the content of the measure, including authors, editors, reviewers, and endorsers.")
    protected List<Contributor> contributor;
    @Child(name="copyright", type={MarkdownType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the measure and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the measure.")
    protected MarkdownType copyright;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="library", type={Library.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Logic used by the measure", formalDefinition="A reference to a Library resource containing the formal logic used by the measure.")
    protected List<Reference> library;
    protected List<Library> libraryTarget;
    @Child(name="disclaimer", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Disclaimer for use of the measure or its referenced content", formalDefinition="Notices and disclaimers regarding the use of the measure, or related to intellectual property (such as code systems) referenced by the measure.")
    protected MarkdownType disclaimer;
    @Child(name="scoring", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="proportion | ratio | continuous-variable | cohort", formalDefinition="Indicates how the calculation is performed for the measure, including proportion, ratio, continuous variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-scoring")
    protected CodeableConcept scoring;
    @Child(name="compositeScoring", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="opportunity | all-or-nothing | linear | weighted", formalDefinition="If this is a composite measure, the scoring method used to combine the component measures to determine the composite score.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/composite-measure-scoring")
    protected CodeableConcept compositeScoring;
    @Child(name="type", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="process | outcome | structure | patient-reported-outcome | composite", formalDefinition="Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-type")
    protected List<CodeableConcept> type;
    @Child(name="riskAdjustment", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How is risk adjustment applied for this measure", formalDefinition="A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.")
    protected StringType riskAdjustment;
    @Child(name="rateAggregation", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How is rate aggregation performed for this measure", formalDefinition="Describes how to combine the information calculated, based on logic in each of several populations, into one summarized result.")
    protected StringType rateAggregation;
    @Child(name="rationale", type={MarkdownType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why does this measure exist", formalDefinition="Provides a succint statement of the need for the measure. Usually includes statements pertaining to importance criterion: impact, gap in care, and evidence.")
    protected MarkdownType rationale;
    @Child(name="clinicalRecommendationStatement", type={MarkdownType.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Summary of clinical guidelines", formalDefinition="Provides a summary of relevant clinical guidelines or other clinical recommendations supporting the measure.")
    protected MarkdownType clinicalRecommendationStatement;
    @Child(name="improvementNotation", type={StringType.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Improvement notation for the measure, e.g. higher score indicates better quality", formalDefinition="Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is whthin a range).")
    protected StringType improvementNotation;
    @Child(name="definition", type={MarkdownType.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Defined terms used in the measure documentation", formalDefinition="Provides a description of an individual term used within the measure.")
    protected List<MarkdownType> definition;
    @Child(name="guidance", type={MarkdownType.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional guidance for implementers", formalDefinition="Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.")
    protected MarkdownType guidance;
    @Child(name="set", type={StringType.class}, order=22, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The measure set, e.g. Preventive Care and Screening", formalDefinition="The measure set, e.g. Preventive Care and Screening.")
    protected StringType set;
    @Child(name="group", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Population criteria group", formalDefinition="A group of population criteria for the measure.")
    protected List<MeasureGroupComponent> group;
    @Child(name="supplementalData", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What other data should be reported with the measure", formalDefinition="The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.")
    protected List<MeasureSupplementalDataComponent> supplementalData;
    private static final long serialVersionUID = -875918689L;
    @SearchParamDefinition(name="date", path="Measure.date", description="The measure publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Measure.identifier", description="External identifier for the measure", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="successor", path="Measure.relatedArtifact.where(type='successor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_SUCCESSOR = "successor";
    public static final ReferenceClientParam SUCCESSOR = new ReferenceClientParam("successor");
    public static final Include INCLUDE_SUCCESSOR = new Include("Measure:successor").toLocked();
    @SearchParamDefinition(name="jurisdiction", path="Measure.jurisdiction", description="Intended jurisdiction for the measure", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="Measure.description", description="The description of the measure", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="derived-from", path="Measure.relatedArtifact.where(type='derived-from').resource", description="What resource is being referenced", type="reference")
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("Measure:derived-from").toLocked();
    @SearchParamDefinition(name="predecessor", path="Measure.relatedArtifact.where(type='predecessor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("Measure:predecessor").toLocked();
    @SearchParamDefinition(name="title", path="Measure.title", description="The human-friendly name of the measure", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="composed-of", path="Measure.relatedArtifact.where(type='composed-of').resource", description="What resource is being referenced", type="reference")
    public static final String SP_COMPOSED_OF = "composed-of";
    public static final ReferenceClientParam COMPOSED_OF = new ReferenceClientParam("composed-of");
    public static final Include INCLUDE_COMPOSED_OF = new Include("Measure:composed-of").toLocked();
    @SearchParamDefinition(name="version", path="Measure.version", description="The business version of the measure", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="Measure.url", description="The uri that identifies the measure", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="effective", path="Measure.effectivePeriod", description="The time during which the measure is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="depends-on", path="Measure.relatedArtifact.where(type='depends-on').resource | Measure.library", description="What resource is being referenced", type="reference")
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("Measure:depends-on").toLocked();
    @SearchParamDefinition(name="name", path="Measure.name", description="Computationally friendly name of the measure", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="Measure.publisher", description="Name of the publisher of the measure", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="topic", path="Measure.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="status", path="Measure.status", description="The current status of the measure", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Measure() {
    }

    public Measure(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public Measure setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public Measure setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Measure setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Measure addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public Measure setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public Measure setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public Measure setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public Measure setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public Measure setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public Measure setTitle(String value) {
        if (Utilities.noString(value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public Measure setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public Measure setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public Measure setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public Measure setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public Measure setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public Measure setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public Measure setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public Measure setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public Measure setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public Measure setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public Measure setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public Measure setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public Measure setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public Measure setUsage(String value) {
        if (Utilities.noString(value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public Measure setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public Measure setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public Measure setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public Measure setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public Measure setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public Measure setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public Measure addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public Measure setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public Measure addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    public Measure setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    public Measure addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    public List<Contributor> getContributor() {
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        return this.contributor;
    }

    public Measure setContributor(List<Contributor> theContributor) {
        this.contributor = theContributor;
        return this;
    }

    public boolean hasContributor() {
        if (this.contributor == null) {
            return false;
        }
        for (Contributor item : this.contributor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Contributor addContributor() {
        Contributor t = new Contributor();
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        this.contributor.add(t);
        return t;
    }

    public Measure addContributor(Contributor t) {
        if (t == null) {
            return this;
        }
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        this.contributor.add(t);
        return this;
    }

    public Contributor getContributorFirstRep() {
        if (this.getContributor().isEmpty()) {
            this.addContributor();
        }
        return this.getContributor().get(0);
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public Measure setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public Measure addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public Measure setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public Measure setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public Measure setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public Measure addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<Reference> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        return this.library;
    }

    public Measure setLibrary(List<Reference> theLibrary) {
        this.library = theLibrary;
        return this;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (Reference item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLibrary() {
        Reference t = new Reference();
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return t;
    }

    public Measure addLibrary(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return this;
    }

    public Reference getLibraryFirstRep() {
        if (this.getLibrary().isEmpty()) {
            this.addLibrary();
        }
        return this.getLibrary().get(0);
    }

    @Deprecated
    public List<Library> getLibraryTarget() {
        if (this.libraryTarget == null) {
            this.libraryTarget = new ArrayList<Library>();
        }
        return this.libraryTarget;
    }

    @Deprecated
    public Library addLibraryTarget() {
        Library r = new Library();
        if (this.libraryTarget == null) {
            this.libraryTarget = new ArrayList<Library>();
        }
        this.libraryTarget.add(r);
        return r;
    }

    public MarkdownType getDisclaimerElement() {
        if (this.disclaimer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.disclaimer");
            }
            if (Configuration.doAutoCreate()) {
                this.disclaimer = new MarkdownType();
            }
        }
        return this.disclaimer;
    }

    public boolean hasDisclaimerElement() {
        return this.disclaimer != null && !this.disclaimer.isEmpty();
    }

    public boolean hasDisclaimer() {
        return this.disclaimer != null && !this.disclaimer.isEmpty();
    }

    public Measure setDisclaimerElement(MarkdownType value) {
        this.disclaimer = value;
        return this;
    }

    public String getDisclaimer() {
        return this.disclaimer == null ? null : (String)this.disclaimer.getValue();
    }

    public Measure setDisclaimer(String value) {
        if (value == null) {
            this.disclaimer = null;
        } else {
            if (this.disclaimer == null) {
                this.disclaimer = new MarkdownType();
            }
            this.disclaimer.setValue(value);
        }
        return this;
    }

    public CodeableConcept getScoring() {
        if (this.scoring == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.scoring");
            }
            if (Configuration.doAutoCreate()) {
                this.scoring = new CodeableConcept();
            }
        }
        return this.scoring;
    }

    public boolean hasScoring() {
        return this.scoring != null && !this.scoring.isEmpty();
    }

    public Measure setScoring(CodeableConcept value) {
        this.scoring = value;
        return this;
    }

    public CodeableConcept getCompositeScoring() {
        if (this.compositeScoring == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.compositeScoring");
            }
            if (Configuration.doAutoCreate()) {
                this.compositeScoring = new CodeableConcept();
            }
        }
        return this.compositeScoring;
    }

    public boolean hasCompositeScoring() {
        return this.compositeScoring != null && !this.compositeScoring.isEmpty();
    }

    public Measure setCompositeScoring(CodeableConcept value) {
        this.compositeScoring = value;
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public Measure setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Measure addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public StringType getRiskAdjustmentElement() {
        if (this.riskAdjustment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.riskAdjustment");
            }
            if (Configuration.doAutoCreate()) {
                this.riskAdjustment = new StringType();
            }
        }
        return this.riskAdjustment;
    }

    public boolean hasRiskAdjustmentElement() {
        return this.riskAdjustment != null && !this.riskAdjustment.isEmpty();
    }

    public boolean hasRiskAdjustment() {
        return this.riskAdjustment != null && !this.riskAdjustment.isEmpty();
    }

    public Measure setRiskAdjustmentElement(StringType value) {
        this.riskAdjustment = value;
        return this;
    }

    public String getRiskAdjustment() {
        return this.riskAdjustment == null ? null : (String)this.riskAdjustment.getValue();
    }

    public Measure setRiskAdjustment(String value) {
        if (Utilities.noString(value)) {
            this.riskAdjustment = null;
        } else {
            if (this.riskAdjustment == null) {
                this.riskAdjustment = new StringType();
            }
            this.riskAdjustment.setValue(value);
        }
        return this;
    }

    public StringType getRateAggregationElement() {
        if (this.rateAggregation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.rateAggregation");
            }
            if (Configuration.doAutoCreate()) {
                this.rateAggregation = new StringType();
            }
        }
        return this.rateAggregation;
    }

    public boolean hasRateAggregationElement() {
        return this.rateAggregation != null && !this.rateAggregation.isEmpty();
    }

    public boolean hasRateAggregation() {
        return this.rateAggregation != null && !this.rateAggregation.isEmpty();
    }

    public Measure setRateAggregationElement(StringType value) {
        this.rateAggregation = value;
        return this;
    }

    public String getRateAggregation() {
        return this.rateAggregation == null ? null : (String)this.rateAggregation.getValue();
    }

    public Measure setRateAggregation(String value) {
        if (Utilities.noString(value)) {
            this.rateAggregation = null;
        } else {
            if (this.rateAggregation == null) {
                this.rateAggregation = new StringType();
            }
            this.rateAggregation.setValue(value);
        }
        return this;
    }

    public MarkdownType getRationaleElement() {
        if (this.rationale == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.rationale");
            }
            if (Configuration.doAutoCreate()) {
                this.rationale = new MarkdownType();
            }
        }
        return this.rationale;
    }

    public boolean hasRationaleElement() {
        return this.rationale != null && !this.rationale.isEmpty();
    }

    public boolean hasRationale() {
        return this.rationale != null && !this.rationale.isEmpty();
    }

    public Measure setRationaleElement(MarkdownType value) {
        this.rationale = value;
        return this;
    }

    public String getRationale() {
        return this.rationale == null ? null : (String)this.rationale.getValue();
    }

    public Measure setRationale(String value) {
        if (value == null) {
            this.rationale = null;
        } else {
            if (this.rationale == null) {
                this.rationale = new MarkdownType();
            }
            this.rationale.setValue(value);
        }
        return this;
    }

    public MarkdownType getClinicalRecommendationStatementElement() {
        if (this.clinicalRecommendationStatement == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.clinicalRecommendationStatement");
            }
            if (Configuration.doAutoCreate()) {
                this.clinicalRecommendationStatement = new MarkdownType();
            }
        }
        return this.clinicalRecommendationStatement;
    }

    public boolean hasClinicalRecommendationStatementElement() {
        return this.clinicalRecommendationStatement != null && !this.clinicalRecommendationStatement.isEmpty();
    }

    public boolean hasClinicalRecommendationStatement() {
        return this.clinicalRecommendationStatement != null && !this.clinicalRecommendationStatement.isEmpty();
    }

    public Measure setClinicalRecommendationStatementElement(MarkdownType value) {
        this.clinicalRecommendationStatement = value;
        return this;
    }

    public String getClinicalRecommendationStatement() {
        return this.clinicalRecommendationStatement == null ? null : (String)this.clinicalRecommendationStatement.getValue();
    }

    public Measure setClinicalRecommendationStatement(String value) {
        if (value == null) {
            this.clinicalRecommendationStatement = null;
        } else {
            if (this.clinicalRecommendationStatement == null) {
                this.clinicalRecommendationStatement = new MarkdownType();
            }
            this.clinicalRecommendationStatement.setValue(value);
        }
        return this;
    }

    public StringType getImprovementNotationElement() {
        if (this.improvementNotation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.improvementNotation");
            }
            if (Configuration.doAutoCreate()) {
                this.improvementNotation = new StringType();
            }
        }
        return this.improvementNotation;
    }

    public boolean hasImprovementNotationElement() {
        return this.improvementNotation != null && !this.improvementNotation.isEmpty();
    }

    public boolean hasImprovementNotation() {
        return this.improvementNotation != null && !this.improvementNotation.isEmpty();
    }

    public Measure setImprovementNotationElement(StringType value) {
        this.improvementNotation = value;
        return this;
    }

    public String getImprovementNotation() {
        return this.improvementNotation == null ? null : (String)this.improvementNotation.getValue();
    }

    public Measure setImprovementNotation(String value) {
        if (Utilities.noString(value)) {
            this.improvementNotation = null;
        } else {
            if (this.improvementNotation == null) {
                this.improvementNotation = new StringType();
            }
            this.improvementNotation.setValue(value);
        }
        return this;
    }

    public List<MarkdownType> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<MarkdownType>();
        }
        return this.definition;
    }

    public Measure setDefinition(List<MarkdownType> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (MarkdownType item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarkdownType addDefinitionElement() {
        MarkdownType t = new MarkdownType();
        if (this.definition == null) {
            this.definition = new ArrayList<MarkdownType>();
        }
        this.definition.add(t);
        return t;
    }

    public Measure addDefinition(String value) {
        MarkdownType t = new MarkdownType();
        t.setValue(value);
        if (this.definition == null) {
            this.definition = new ArrayList<MarkdownType>();
        }
        this.definition.add(t);
        return this;
    }

    public boolean hasDefinition(String value) {
        if (this.definition == null) {
            return false;
        }
        for (MarkdownType v : this.definition) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public MarkdownType getGuidanceElement() {
        if (this.guidance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.guidance");
            }
            if (Configuration.doAutoCreate()) {
                this.guidance = new MarkdownType();
            }
        }
        return this.guidance;
    }

    public boolean hasGuidanceElement() {
        return this.guidance != null && !this.guidance.isEmpty();
    }

    public boolean hasGuidance() {
        return this.guidance != null && !this.guidance.isEmpty();
    }

    public Measure setGuidanceElement(MarkdownType value) {
        this.guidance = value;
        return this;
    }

    public String getGuidance() {
        return this.guidance == null ? null : (String)this.guidance.getValue();
    }

    public Measure setGuidance(String value) {
        if (value == null) {
            this.guidance = null;
        } else {
            if (this.guidance == null) {
                this.guidance = new MarkdownType();
            }
            this.guidance.setValue(value);
        }
        return this;
    }

    public StringType getSetElement() {
        if (this.set == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.set");
            }
            if (Configuration.doAutoCreate()) {
                this.set = new StringType();
            }
        }
        return this.set;
    }

    public boolean hasSetElement() {
        return this.set != null && !this.set.isEmpty();
    }

    public boolean hasSet() {
        return this.set != null && !this.set.isEmpty();
    }

    public Measure setSetElement(StringType value) {
        this.set = value;
        return this;
    }

    public String getSet() {
        return this.set == null ? null : (String)this.set.getValue();
    }

    public Measure setSet(String value) {
        if (Utilities.noString(value)) {
            this.set = null;
        } else {
            if (this.set == null) {
                this.set = new StringType();
            }
            this.set.setValue(value);
        }
        return this;
    }

    public List<MeasureGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroupComponent>();
        }
        return this.group;
    }

    public Measure setGroup(List<MeasureGroupComponent> theGroup) {
        this.group = theGroup;
        return this;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (MeasureGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MeasureGroupComponent addGroup() {
        MeasureGroupComponent t = new MeasureGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public Measure addGroup(MeasureGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public MeasureGroupComponent getGroupFirstRep() {
        if (this.getGroup().isEmpty()) {
            this.addGroup();
        }
        return this.getGroup().get(0);
    }

    public List<MeasureSupplementalDataComponent> getSupplementalData() {
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
        }
        return this.supplementalData;
    }

    public Measure setSupplementalData(List<MeasureSupplementalDataComponent> theSupplementalData) {
        this.supplementalData = theSupplementalData;
        return this;
    }

    public boolean hasSupplementalData() {
        if (this.supplementalData == null) {
            return false;
        }
        for (MeasureSupplementalDataComponent item : this.supplementalData) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MeasureSupplementalDataComponent addSupplementalData() {
        MeasureSupplementalDataComponent t = new MeasureSupplementalDataComponent();
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
        }
        this.supplementalData.add(t);
        return t;
    }

    public Measure addSupplementalData(MeasureSupplementalDataComponent t) {
        if (t == null) {
            return this;
        }
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
        }
        this.supplementalData.add(t);
        return this;
    }

    public MeasureSupplementalDataComponent getSupplementalDataFirstRep() {
        if (this.getSupplementalData().isEmpty()) {
            this.addSupplementalData();
        }
        return this.getSupplementalData().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this measure when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this measure is (or will be) published. The URL SHOULD include the major version of the measure. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this measure when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the measure when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the measure author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the measure. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the measure.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this measure. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A boolean value to indicate that this measure is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the measure was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the measure changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the measure.", 0, 1, this.publisher));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the measure from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("purpose", "markdown", "Explaination of why this measure is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("usage", "string", "A detailed description of how the measure is used from a clinical perspective.", 0, 1, this.usage));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval, but doesn't change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the measure content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate measure instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the measure is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the measure. Topics provide a high-level categorization of the type of the measure that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("contributor", "Contributor", "A contributor to the content of the measure, including authors, editors, reviewers, and endorsers.", 0, Integer.MAX_VALUE, this.contributor));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the measure and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the measure.", 0, 1, this.copyright));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("library", "Reference(Library)", "A reference to a Library resource containing the formal logic used by the measure.", 0, Integer.MAX_VALUE, this.library));
        children.add(new Property("disclaimer", "markdown", "Notices and disclaimers regarding the use of the measure, or related to intellectual property (such as code systems) referenced by the measure.", 0, 1, this.disclaimer));
        children.add(new Property("scoring", "CodeableConcept", "Indicates how the calculation is performed for the measure, including proportion, ratio, continuous variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.", 0, 1, this.scoring));
        children.add(new Property("compositeScoring", "CodeableConcept", "If this is a composite measure, the scoring method used to combine the component measures to determine the composite score.", 0, 1, this.compositeScoring));
        children.add(new Property("type", "CodeableConcept", "Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("riskAdjustment", "string", "A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.", 0, 1, this.riskAdjustment));
        children.add(new Property("rateAggregation", "string", "Describes how to combine the information calculated, based on logic in each of several populations, into one summarized result.", 0, 1, this.rateAggregation));
        children.add(new Property("rationale", "markdown", "Provides a succint statement of the need for the measure. Usually includes statements pertaining to importance criterion: impact, gap in care, and evidence.", 0, 1, this.rationale));
        children.add(new Property("clinicalRecommendationStatement", "markdown", "Provides a summary of relevant clinical guidelines or other clinical recommendations supporting the measure.", 0, 1, this.clinicalRecommendationStatement));
        children.add(new Property("improvementNotation", "string", "Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is whthin a range).", 0, 1, this.improvementNotation));
        children.add(new Property("definition", "markdown", "Provides a description of an individual term used within the measure.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("guidance", "markdown", "Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.", 0, 1, this.guidance));
        children.add(new Property("set", "string", "The measure set, e.g. Preventive Care and Screening.", 0, 1, this.set));
        children.add(new Property("group", "", "A group of population criteria for the measure.", 0, Integer.MAX_VALUE, this.group));
        children.add(new Property("supplementalData", "", "The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.supplementalData));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this measure when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this measure is (or will be) published. The URL SHOULD include the major version of the measure. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this measure when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the measure when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the measure author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the measure. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the measure.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this measure. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A boolean value to indicate that this measure is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the measure was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the measure changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the measure.", 0, 1, this.publisher);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the measure from a consumer's perspective.", 0, 1, this.description);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explaination of why this measure is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 111574433: {
                return new Property("usage", "string", "A detailed description of how the measure is used from a clinical perspective.", 0, 1, this.usage);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval, but doesn't change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the measure content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate measure instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the measure is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the measure. Topics provide a high-level categorization of the type of the measure that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1895276325: {
                return new Property("contributor", "Contributor", "A contributor to the content of the measure, including authors, editors, reviewers, and endorsers.", 0, Integer.MAX_VALUE, this.contributor);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the measure and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the measure.", 0, 1, this.copyright);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 166208699: {
                return new Property("library", "Reference(Library)", "A reference to a Library resource containing the formal logic used by the measure.", 0, Integer.MAX_VALUE, this.library);
            }
            case 432371099: {
                return new Property("disclaimer", "markdown", "Notices and disclaimers regarding the use of the measure, or related to intellectual property (such as code systems) referenced by the measure.", 0, 1, this.disclaimer);
            }
            case 1924005583: {
                return new Property("scoring", "CodeableConcept", "Indicates how the calculation is performed for the measure, including proportion, ratio, continuous variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.", 0, 1, this.scoring);
            }
            case 569347656: {
                return new Property("compositeScoring", "CodeableConcept", "If this is a composite measure, the scoring method used to combine the component measures to determine the composite score.", 0, 1, this.compositeScoring);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.", 0, Integer.MAX_VALUE, this.type);
            }
            case 93273500: {
                return new Property("riskAdjustment", "string", "A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.", 0, 1, this.riskAdjustment);
            }
            case 1254503906: {
                return new Property("rateAggregation", "string", "Describes how to combine the information calculated, based on logic in each of several populations, into one summarized result.", 0, 1, this.rateAggregation);
            }
            case 345689335: {
                return new Property("rationale", "markdown", "Provides a succint statement of the need for the measure. Usually includes statements pertaining to importance criterion: impact, gap in care, and evidence.", 0, 1, this.rationale);
            }
            case -18631389: {
                return new Property("clinicalRecommendationStatement", "markdown", "Provides a summary of relevant clinical guidelines or other clinical recommendations supporting the measure.", 0, 1, this.clinicalRecommendationStatement);
            }
            case -2085456136: {
                return new Property("improvementNotation", "string", "Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is whthin a range).", 0, 1, this.improvementNotation);
            }
            case -1014418093: {
                return new Property("definition", "markdown", "Provides a description of an individual term used within the measure.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -1314002088: {
                return new Property("guidance", "markdown", "Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.", 0, 1, this.guidance);
            }
            case 113762: {
                return new Property("set", "string", "The measure set, e.g. Preventive Care and Screening.", 0, 1, this.set);
            }
            case 98629247: {
                return new Property("group", "", "A group of population criteria for the measure.", 0, Integer.MAX_VALUE, this.group);
            }
            case 1447496814: {
                return new Property("supplementalData", "", "The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.supplementalData);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.usage;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1895276325: {
                return this.contributor == null ? new Base[]{} : this.contributor.toArray(new Base[this.contributor.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.copyright;
                }
                return baseArray;
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case 432371099: {
                Base[] baseArray;
                if (this.disclaimer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.disclaimer;
                }
                return baseArray;
            }
            case 1924005583: {
                Base[] baseArray;
                if (this.scoring == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.scoring;
                }
                return baseArray;
            }
            case 569347656: {
                Base[] baseArray;
                if (this.compositeScoring == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.compositeScoring;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 93273500: {
                Base[] baseArray;
                if (this.riskAdjustment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.riskAdjustment;
                }
                return baseArray;
            }
            case 1254503906: {
                Base[] baseArray;
                if (this.rateAggregation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.rateAggregation;
                }
                return baseArray;
            }
            case 345689335: {
                Base[] baseArray;
                if (this.rationale == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.rationale;
                }
                return baseArray;
            }
            case -18631389: {
                Base[] baseArray;
                if (this.clinicalRecommendationStatement == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.clinicalRecommendationStatement;
                }
                return baseArray;
            }
            case -2085456136: {
                Base[] baseArray;
                if (this.improvementNotation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray24 = new Base[1];
                    baseArray = baseArray24;
                    baseArray24[0] = this.improvementNotation;
                }
                return baseArray;
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -1314002088: {
                Base[] baseArray;
                if (this.guidance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray25 = new Base[1];
                    baseArray = baseArray25;
                    baseArray25[0] = this.guidance;
                }
                return baseArray;
            }
            case 113762: {
                Base[] baseArray;
                if (this.set == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray26 = new Base[1];
                    baseArray = baseArray26;
                    baseArray26[0] = this.set;
                }
                return baseArray;
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
            case 1447496814: {
                return this.supplementalData == null ? new Base[]{} : this.supplementalData.toArray(new Base[this.supplementalData.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 111574433: {
                this.usage = this.castToString(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1895276325: {
                this.getContributor().add(this.castToContributor(value));
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case 166208699: {
                this.getLibrary().add(this.castToReference(value));
                return value;
            }
            case 432371099: {
                this.disclaimer = this.castToMarkdown(value);
                return value;
            }
            case 1924005583: {
                this.scoring = this.castToCodeableConcept(value);
                return value;
            }
            case 569347656: {
                this.compositeScoring = this.castToCodeableConcept(value);
                return value;
            }
            case 3575610: {
                this.getType().add(this.castToCodeableConcept(value));
                return value;
            }
            case 93273500: {
                this.riskAdjustment = this.castToString(value);
                return value;
            }
            case 1254503906: {
                this.rateAggregation = this.castToString(value);
                return value;
            }
            case 345689335: {
                this.rationale = this.castToMarkdown(value);
                return value;
            }
            case -18631389: {
                this.clinicalRecommendationStatement = this.castToMarkdown(value);
                return value;
            }
            case -2085456136: {
                this.improvementNotation = this.castToString(value);
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToMarkdown(value));
                return value;
            }
            case -1314002088: {
                this.guidance = this.castToMarkdown(value);
                return value;
            }
            case 113762: {
                this.set = this.castToString(value);
                return value;
            }
            case 98629247: {
                this.getGroup().add((MeasureGroupComponent)((Object)value));
                return value;
            }
            case 1447496814: {
                this.getSupplementalData().add((MeasureSupplementalDataComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("usage")) {
            this.usage = this.castToString(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(this.castToCodeableConcept(value));
        } else if (name.equals("contributor")) {
            this.getContributor().add(this.castToContributor(value));
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals("library")) {
            this.getLibrary().add(this.castToReference(value));
        } else if (name.equals("disclaimer")) {
            this.disclaimer = this.castToMarkdown(value);
        } else if (name.equals("scoring")) {
            this.scoring = this.castToCodeableConcept(value);
        } else if (name.equals("compositeScoring")) {
            this.compositeScoring = this.castToCodeableConcept(value);
        } else if (name.equals("type")) {
            this.getType().add(this.castToCodeableConcept(value));
        } else if (name.equals("riskAdjustment")) {
            this.riskAdjustment = this.castToString(value);
        } else if (name.equals("rateAggregation")) {
            this.rateAggregation = this.castToString(value);
        } else if (name.equals("rationale")) {
            this.rationale = this.castToMarkdown(value);
        } else if (name.equals("clinicalRecommendationStatement")) {
            this.clinicalRecommendationStatement = this.castToMarkdown(value);
        } else if (name.equals("improvementNotation")) {
            this.improvementNotation = this.castToString(value);
        } else if (name.equals("definition")) {
            this.getDefinition().add(this.castToMarkdown(value));
        } else if (name.equals("guidance")) {
            this.guidance = this.castToMarkdown(value);
        } else if (name.equals("set")) {
            this.set = this.castToString(value);
        } else if (name.equals("group")) {
            this.getGroup().add((MeasureGroupComponent)((Object)value));
        } else if (name.equals("supplementalData")) {
            this.getSupplementalData().add((MeasureSupplementalDataComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 111574433: {
                return this.getUsageElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1895276325: {
                return this.addContributor();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 166208699: {
                return this.addLibrary();
            }
            case 432371099: {
                return this.getDisclaimerElement();
            }
            case 1924005583: {
                return this.getScoring();
            }
            case 569347656: {
                return this.getCompositeScoring();
            }
            case 3575610: {
                return this.addType();
            }
            case 93273500: {
                return this.getRiskAdjustmentElement();
            }
            case 1254503906: {
                return this.getRateAggregationElement();
            }
            case 345689335: {
                return this.getRationaleElement();
            }
            case -18631389: {
                return this.getClinicalRecommendationStatementElement();
            }
            case -2085456136: {
                return this.getImprovementNotationElement();
            }
            case -1014418093: {
                return this.addDefinitionElement();
            }
            case -1314002088: {
                return this.getGuidanceElement();
            }
            case 113762: {
                return this.getSetElement();
            }
            case 98629247: {
                return this.addGroup();
            }
            case 1447496814: {
                return this.addSupplementalData();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 111574433: {
                return new String[]{"string"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1895276325: {
                return new String[]{"Contributor"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 166208699: {
                return new String[]{"Reference"};
            }
            case 432371099: {
                return new String[]{"markdown"};
            }
            case 1924005583: {
                return new String[]{"CodeableConcept"};
            }
            case 569347656: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 93273500: {
                return new String[]{"string"};
            }
            case 1254503906: {
                return new String[]{"string"};
            }
            case 345689335: {
                return new String[]{"markdown"};
            }
            case -18631389: {
                return new String[]{"markdown"};
            }
            case -2085456136: {
                return new String[]{"string"};
            }
            case -1014418093: {
                return new String[]{"markdown"};
            }
            case -1314002088: {
                return new String[]{"markdown"};
            }
            case 113762: {
                return new String[]{"string"};
            }
            case 98629247: {
                return new String[0];
            }
            case 1447496814: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.publisher");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.description");
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.purpose");
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.usage");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("contributor")) {
            return this.addContributor();
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.copyright");
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("library")) {
            return this.addLibrary();
        }
        if (name.equals("disclaimer")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.disclaimer");
        }
        if (name.equals("scoring")) {
            this.scoring = new CodeableConcept();
            return this.scoring;
        }
        if (name.equals("compositeScoring")) {
            this.compositeScoring = new CodeableConcept();
            return this.compositeScoring;
        }
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals("riskAdjustment")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.riskAdjustment");
        }
        if (name.equals("rateAggregation")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.rateAggregation");
        }
        if (name.equals("rationale")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.rationale");
        }
        if (name.equals("clinicalRecommendationStatement")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.clinicalRecommendationStatement");
        }
        if (name.equals("improvementNotation")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.improvementNotation");
        }
        if (name.equals("definition")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.definition");
        }
        if (name.equals("guidance")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.guidance");
        }
        if (name.equals("set")) {
            throw new FHIRException("Cannot call addChild on a primitive type Measure.set");
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        if (name.equals("supplementalData")) {
            return this.addSupplementalData();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Measure";
    }

    @Override
    public Measure copy() {
        Measure dst = new Measure();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.publisher = this.publisher == null ? null : this.publisher.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.usage = this.usage == null ? null : this.usage.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.contributor != null) {
            dst.contributor = new ArrayList<Contributor>();
            for (Contributor contributor : this.contributor) {
                dst.contributor.add(contributor.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.library != null) {
            dst.library = new ArrayList<Reference>();
            for (Reference reference : this.library) {
                dst.library.add(reference.copy());
            }
        }
        dst.disclaimer = this.disclaimer == null ? null : this.disclaimer.copy();
        dst.scoring = this.scoring == null ? null : this.scoring.copy();
        CodeableConcept codeableConcept = dst.compositeScoring = this.compositeScoring == null ? null : this.compositeScoring.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.type) {
                dst.type.add(codeableConcept2.copy());
            }
        }
        dst.riskAdjustment = this.riskAdjustment == null ? null : this.riskAdjustment.copy();
        dst.rateAggregation = this.rateAggregation == null ? null : this.rateAggregation.copy();
        dst.rationale = this.rationale == null ? null : this.rationale.copy();
        dst.clinicalRecommendationStatement = this.clinicalRecommendationStatement == null ? null : this.clinicalRecommendationStatement.copy();
        StringType stringType = dst.improvementNotation = this.improvementNotation == null ? null : this.improvementNotation.copy();
        if (this.definition != null) {
            dst.definition = new ArrayList<MarkdownType>();
            for (MarkdownType markdownType2 : this.definition) {
                dst.definition.add(markdownType2.copy());
            }
        }
        dst.guidance = this.guidance == null ? null : this.guidance.copy();
        StringType stringType2 = dst.set = this.set == null ? null : this.set.copy();
        if (this.group != null) {
            dst.group = new ArrayList<MeasureGroupComponent>();
            for (MeasureGroupComponent measureGroupComponent : this.group) {
                dst.group.add(measureGroupComponent.copy());
            }
        }
        if (this.supplementalData != null) {
            dst.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
            for (MeasureSupplementalDataComponent measureSupplementalDataComponent : this.supplementalData) {
                dst.supplementalData.add(measureSupplementalDataComponent.copy());
            }
        }
        return dst;
    }

    protected Measure typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Measure)) {
            return false;
        }
        Measure o = (Measure)other_;
        return Measure.compareDeep(this.identifier, o.identifier, true) && Measure.compareDeep(this.purpose, o.purpose, true) && Measure.compareDeep(this.usage, o.usage, true) && Measure.compareDeep(this.approvalDate, o.approvalDate, true) && Measure.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && Measure.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && Measure.compareDeep(this.topic, o.topic, true) && Measure.compareDeep(this.contributor, o.contributor, true) && Measure.compareDeep(this.copyright, o.copyright, true) && Measure.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && Measure.compareDeep(this.library, o.library, true) && Measure.compareDeep(this.disclaimer, o.disclaimer, true) && Measure.compareDeep(this.scoring, o.scoring, true) && Measure.compareDeep(this.compositeScoring, o.compositeScoring, true) && Measure.compareDeep(this.type, o.type, true) && Measure.compareDeep(this.riskAdjustment, o.riskAdjustment, true) && Measure.compareDeep(this.rateAggregation, o.rateAggregation, true) && Measure.compareDeep(this.rationale, o.rationale, true) && Measure.compareDeep(this.clinicalRecommendationStatement, o.clinicalRecommendationStatement, true) && Measure.compareDeep(this.improvementNotation, o.improvementNotation, true) && Measure.compareDeep(this.definition, o.definition, true) && Measure.compareDeep(this.guidance, o.guidance, true) && Measure.compareDeep(this.set, o.set, true) && Measure.compareDeep(this.group, o.group, true) && Measure.compareDeep(this.supplementalData, o.supplementalData, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Measure)) {
            return false;
        }
        Measure o = (Measure)other_;
        return Measure.compareValues(this.purpose, o.purpose, true) && Measure.compareValues(this.usage, o.usage, true) && Measure.compareValues(this.approvalDate, o.approvalDate, true) && Measure.compareValues(this.lastReviewDate, o.lastReviewDate, true) && Measure.compareValues(this.copyright, o.copyright, true) && Measure.compareValues(this.disclaimer, o.disclaimer, true) && Measure.compareValues(this.riskAdjustment, o.riskAdjustment, true) && Measure.compareValues(this.rateAggregation, o.rateAggregation, true) && Measure.compareValues(this.rationale, o.rationale, true) && Measure.compareValues(this.clinicalRecommendationStatement, o.clinicalRecommendationStatement, true) && Measure.compareValues(this.improvementNotation, o.improvementNotation, true) && Measure.compareValues(this.definition, o.definition, true) && Measure.compareValues(this.guidance, o.guidance, true) && Measure.compareValues(this.set, o.set, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.purpose, this.usage, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.contributor, this.copyright, this.relatedArtifact, this.library, this.disclaimer, this.scoring, this.compositeScoring, this.type, this.riskAdjustment, this.rateAggregation, this.rationale, this.clinicalRecommendationStatement, this.improvementNotation, this.definition, this.guidance, this.set, this.group, this.supplementalData);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Measure;
    }

    @Block
    public static class MeasureSupplementalDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier, unique within the measure", formalDefinition="An identifier for the supplemental data.")
        protected Identifier identifier;
        @Child(name="usage", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="supplemental-data | risk-adjustment-factor", formalDefinition="An indicator of the intended usage for the supplemental data element. Supplemental data indicates the data is additional information requested to augment the measure information. Risk adjustment factor indicates the data is additional information used to calculate risk adjustment factors when applying a risk model to the measure calculation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-data-usage")
        protected List<CodeableConcept> usage;
        @Child(name="criteria", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Expression describing additional data to be reported", formalDefinition="The criteria for the supplemental data. This must be the name of a valid expression defined within a referenced library, and defines the data to be returned for this element.")
        protected StringType criteria;
        @Child(name="path", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Path to the supplemental data element", formalDefinition="The supplemental data to be supplied as part of the measure response, specified as a valid FHIR Resource Path.")
        protected StringType path;
        private static final long serialVersionUID = -101576770L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureSupplementalDataComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureSupplementalDataComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public List<CodeableConcept> getUsage() {
            if (this.usage == null) {
                this.usage = new ArrayList<CodeableConcept>();
            }
            return this.usage;
        }

        public MeasureSupplementalDataComponent setUsage(List<CodeableConcept> theUsage) {
            this.usage = theUsage;
            return this;
        }

        public boolean hasUsage() {
            if (this.usage == null) {
                return false;
            }
            for (CodeableConcept item : this.usage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addUsage() {
            CodeableConcept t = new CodeableConcept();
            if (this.usage == null) {
                this.usage = new ArrayList<CodeableConcept>();
            }
            this.usage.add(t);
            return t;
        }

        public MeasureSupplementalDataComponent addUsage(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.usage == null) {
                this.usage = new ArrayList<CodeableConcept>();
            }
            this.usage.add(t);
            return this;
        }

        public CodeableConcept getUsageFirstRep() {
            if (this.getUsage().isEmpty()) {
                this.addUsage();
            }
            return this.getUsage().get(0);
        }

        public StringType getCriteriaElement() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureSupplementalDataComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new StringType();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteriaElement() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureSupplementalDataComponent setCriteriaElement(StringType value) {
            this.criteria = value;
            return this;
        }

        public String getCriteria() {
            return this.criteria == null ? null : (String)this.criteria.getValue();
        }

        public MeasureSupplementalDataComponent setCriteria(String value) {
            if (Utilities.noString(value)) {
                this.criteria = null;
            } else {
                if (this.criteria == null) {
                    this.criteria = new StringType();
                }
                this.criteria.setValue(value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureSupplementalDataComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public MeasureSupplementalDataComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public MeasureSupplementalDataComponent setPath(String value) {
            if (Utilities.noString(value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Measure.SP_IDENTIFIER, "Identifier", "An identifier for the supplemental data.", 0, 1, this.identifier));
            children.add(new Property("usage", "CodeableConcept", "An indicator of the intended usage for the supplemental data element. Supplemental data indicates the data is additional information requested to augment the measure information. Risk adjustment factor indicates the data is additional information used to calculate risk adjustment factors when applying a risk model to the measure calculation.", 0, Integer.MAX_VALUE, this.usage));
            children.add(new Property("criteria", "string", "The criteria for the supplemental data. This must be the name of a valid expression defined within a referenced library, and defines the data to be returned for this element.", 0, 1, this.criteria));
            children.add(new Property("path", "string", "The supplemental data to be supplied as part of the measure response, specified as a valid FHIR Resource Path.", 0, 1, this.path));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Measure.SP_IDENTIFIER, "Identifier", "An identifier for the supplemental data.", 0, 1, this.identifier);
                }
                case 111574433: {
                    return new Property("usage", "CodeableConcept", "An indicator of the intended usage for the supplemental data element. Supplemental data indicates the data is additional information requested to augment the measure information. Risk adjustment factor indicates the data is additional information used to calculate risk adjustment factors when applying a risk model to the measure calculation.", 0, Integer.MAX_VALUE, this.usage);
                }
                case 1952046943: {
                    return new Property("criteria", "string", "The criteria for the supplemental data. This must be the name of a valid expression defined within a referenced library, and defines the data to be returned for this element.", 0, 1, this.criteria);
                }
                case 3433509: {
                    return new Property("path", "string", "The supplemental data to be supplied as part of the measure response, specified as a valid FHIR Resource Path.", 0, 1, this.path);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 111574433: {
                    return this.usage == null ? new Base[]{} : this.usage.toArray(new Base[this.usage.size()]);
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.criteria;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.path;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 111574433: {
                    this.getUsage().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1952046943: {
                    this.criteria = this.castToString(value);
                    return value;
                }
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("usage")) {
                this.getUsage().add(this.castToCodeableConcept(value));
            } else if (name.equals("criteria")) {
                this.criteria = this.castToString(value);
            } else if (name.equals("path")) {
                this.path = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 111574433: {
                    return this.addUsage();
                }
                case 1952046943: {
                    return this.getCriteriaElement();
                }
                case 3433509: {
                    return this.getPathElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 111574433: {
                    return new String[]{"CodeableConcept"};
                }
                case 1952046943: {
                    return new String[]{"string"};
                }
                case 3433509: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("usage")) {
                return this.addUsage();
            }
            if (name.equals("criteria")) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.criteria");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.path");
            }
            return super.addChild(name);
        }

        @Override
        public MeasureSupplementalDataComponent copy() {
            MeasureSupplementalDataComponent dst = new MeasureSupplementalDataComponent();
            this.copyValues(dst);
            Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
            if (this.usage != null) {
                dst.usage = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.usage) {
                    dst.usage.add(i.copy());
                }
            }
            dst.criteria = this.criteria == null ? null : this.criteria.copy();
            dst.path = this.path == null ? null : this.path.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureSupplementalDataComponent)) {
                return false;
            }
            MeasureSupplementalDataComponent o = (MeasureSupplementalDataComponent)other_;
            return MeasureSupplementalDataComponent.compareDeep(this.identifier, o.identifier, true) && MeasureSupplementalDataComponent.compareDeep(this.usage, o.usage, true) && MeasureSupplementalDataComponent.compareDeep(this.criteria, o.criteria, true) && MeasureSupplementalDataComponent.compareDeep(this.path, o.path, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureSupplementalDataComponent)) {
                return false;
            }
            MeasureSupplementalDataComponent o = (MeasureSupplementalDataComponent)other_;
            return MeasureSupplementalDataComponent.compareValues(this.criteria, o.criteria, true) && MeasureSupplementalDataComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.usage, this.criteria, this.path);
        }

        @Override
        public String fhirType() {
            return "Measure.supplementalData";
        }
    }

    @Block
    public static class MeasureGroupStratifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The identifier for the stratifier used to coordinate the reported data back to this stratifier", formalDefinition="The identifier for the stratifier used to coordinate the reported data back to this stratifier.")
        protected Identifier identifier;
        @Child(name="criteria", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the measure should be stratified", formalDefinition="The criteria for the stratifier. This must be the name of an expression defined within a referenced library.")
        protected StringType criteria;
        @Child(name="path", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Path to the stratifier", formalDefinition="The path to an element that defines the stratifier, specified as a valid FHIR resource path.")
        protected StringType path;
        private static final long serialVersionUID = -196134448L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureGroupStratifierComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getCriteriaElement() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new StringType();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteriaElement() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureGroupStratifierComponent setCriteriaElement(StringType value) {
            this.criteria = value;
            return this;
        }

        public String getCriteria() {
            return this.criteria == null ? null : (String)this.criteria.getValue();
        }

        public MeasureGroupStratifierComponent setCriteria(String value) {
            if (Utilities.noString(value)) {
                this.criteria = null;
            } else {
                if (this.criteria == null) {
                    this.criteria = new StringType();
                }
                this.criteria.setValue(value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public MeasureGroupStratifierComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public MeasureGroupStratifierComponent setPath(String value) {
            if (Utilities.noString(value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Measure.SP_IDENTIFIER, "Identifier", "The identifier for the stratifier used to coordinate the reported data back to this stratifier.", 0, 1, this.identifier));
            children.add(new Property("criteria", "string", "The criteria for the stratifier. This must be the name of an expression defined within a referenced library.", 0, 1, this.criteria));
            children.add(new Property("path", "string", "The path to an element that defines the stratifier, specified as a valid FHIR resource path.", 0, 1, this.path));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Measure.SP_IDENTIFIER, "Identifier", "The identifier for the stratifier used to coordinate the reported data back to this stratifier.", 0, 1, this.identifier);
                }
                case 1952046943: {
                    return new Property("criteria", "string", "The criteria for the stratifier. This must be the name of an expression defined within a referenced library.", 0, 1, this.criteria);
                }
                case 3433509: {
                    return new Property("path", "string", "The path to an element that defines the stratifier, specified as a valid FHIR resource path.", 0, 1, this.path);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.criteria;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.path;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 1952046943: {
                    this.criteria = this.castToString(value);
                    return value;
                }
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("criteria")) {
                this.criteria = this.castToString(value);
            } else if (name.equals("path")) {
                this.path = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 1952046943: {
                    return this.getCriteriaElement();
                }
                case 3433509: {
                    return this.getPathElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 1952046943: {
                    return new String[]{"string"};
                }
                case 3433509: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("criteria")) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.criteria");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.path");
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupStratifierComponent copy() {
            MeasureGroupStratifierComponent dst = new MeasureGroupStratifierComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.criteria = this.criteria == null ? null : this.criteria.copy();
            dst.path = this.path == null ? null : this.path.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupStratifierComponent)) {
                return false;
            }
            MeasureGroupStratifierComponent o = (MeasureGroupStratifierComponent)other_;
            return MeasureGroupStratifierComponent.compareDeep(this.identifier, o.identifier, true) && MeasureGroupStratifierComponent.compareDeep(this.criteria, o.criteria, true) && MeasureGroupStratifierComponent.compareDeep(this.path, o.path, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupStratifierComponent)) {
                return false;
            }
            MeasureGroupStratifierComponent o = (MeasureGroupStratifierComponent)other_;
            return MeasureGroupStratifierComponent.compareValues(this.criteria, o.criteria, true) && MeasureGroupStratifierComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.criteria, this.path);
        }

        @Override
        public String fhirType() {
            return "Measure.group.stratifier";
        }
    }

    @Block
    public static class MeasureGroupPopulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Unique identifier", formalDefinition="A unique identifier for the population criteria. This identifier is used to report data against this criteria within the measure report.")
        protected Identifier identifier;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="initial-population | numerator | numerator-exclusion | denominator | denominator-exclusion | denominator-exception | measure-population | measure-population-exclusion | measure-observation", formalDefinition="The type of population criteria.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/measure-population")
        protected CodeableConcept code;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short name", formalDefinition="Optional name or short description of this population.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The human readable description of this population criteria", formalDefinition="The human readable description of this population criteria.")
        protected StringType description;
        @Child(name="criteria", type={StringType.class}, order=5, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The name of a valid referenced CQL expression (may be namespaced) that defines this population criteria", formalDefinition="The name of a valid referenced CQL expression (may be namespaced) that defines this population criteria.")
        protected StringType criteria;
        private static final long serialVersionUID = -561575429L;

        public MeasureGroupPopulationComponent() {
        }

        public MeasureGroupPopulationComponent(StringType criteria) {
            this.criteria = criteria;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureGroupPopulationComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MeasureGroupPopulationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MeasureGroupPopulationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MeasureGroupPopulationComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public MeasureGroupPopulationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public MeasureGroupPopulationComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getCriteriaElement() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new StringType();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteriaElement() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureGroupPopulationComponent setCriteriaElement(StringType value) {
            this.criteria = value;
            return this;
        }

        public String getCriteria() {
            return this.criteria == null ? null : (String)this.criteria.getValue();
        }

        public MeasureGroupPopulationComponent setCriteria(String value) {
            if (this.criteria == null) {
                this.criteria = new StringType();
            }
            this.criteria.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Measure.SP_IDENTIFIER, "Identifier", "A unique identifier for the population criteria. This identifier is used to report data against this criteria within the measure report.", 0, 1, this.identifier));
            children.add(new Property("code", "CodeableConcept", "The type of population criteria.", 0, 1, this.code));
            children.add(new Property(Measure.SP_NAME, "string", "Optional name or short description of this population.", 0, 1, this.name));
            children.add(new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population criteria.", 0, 1, this.description));
            children.add(new Property("criteria", "string", "The name of a valid referenced CQL expression (may be namespaced) that defines this population criteria.", 0, 1, this.criteria));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Measure.SP_IDENTIFIER, "Identifier", "A unique identifier for the population criteria. This identifier is used to report data against this criteria within the measure report.", 0, 1, this.identifier);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The type of population criteria.", 0, 1, this.code);
                }
                case 3373707: {
                    return new Property(Measure.SP_NAME, "string", "Optional name or short description of this population.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population criteria.", 0, 1, this.description);
                }
                case 1952046943: {
                    return new Property("criteria", "string", "The name of a valid referenced CQL expression (may be namespaced) that defines this population criteria.", 0, 1, this.criteria);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.criteria;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 1952046943: {
                    this.criteria = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals(Measure.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(Measure.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("criteria")) {
                this.criteria = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 1952046943: {
                    return this.getCriteriaElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 1952046943: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals(Measure.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.name");
            }
            if (name.equals(Measure.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.description");
            }
            if (name.equals("criteria")) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.criteria");
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupPopulationComponent copy() {
            MeasureGroupPopulationComponent dst = new MeasureGroupPopulationComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.criteria = this.criteria == null ? null : this.criteria.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupPopulationComponent)) {
                return false;
            }
            MeasureGroupPopulationComponent o = (MeasureGroupPopulationComponent)other_;
            return MeasureGroupPopulationComponent.compareDeep(this.identifier, o.identifier, true) && MeasureGroupPopulationComponent.compareDeep(this.code, o.code, true) && MeasureGroupPopulationComponent.compareDeep(this.name, o.name, true) && MeasureGroupPopulationComponent.compareDeep(this.description, o.description, true) && MeasureGroupPopulationComponent.compareDeep(this.criteria, o.criteria, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupPopulationComponent)) {
                return false;
            }
            MeasureGroupPopulationComponent o = (MeasureGroupPopulationComponent)other_;
            return MeasureGroupPopulationComponent.compareValues(this.name, o.name, true) && MeasureGroupPopulationComponent.compareValues(this.description, o.description, true) && MeasureGroupPopulationComponent.compareValues(this.criteria, o.criteria, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.code, this.name, this.description, this.criteria);
        }

        @Override
        public String fhirType() {
            return "Measure.group.population";
        }
    }

    @Block
    public static class MeasureGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Unique identifier", formalDefinition="A unique identifier for the group. This identifier will used to report data for the group in the measure report.")
        protected Identifier identifier;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short name", formalDefinition="Optional name or short description of this group.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Summary description", formalDefinition="The human readable description of this population group.")
        protected StringType description;
        @Child(name="population", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Population criteria", formalDefinition="A population criteria for the measure.")
        protected List<MeasureGroupPopulationComponent> population;
        @Child(name="stratifier", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Stratifier criteria for the measure", formalDefinition="The stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library, or a valid FHIR Resource Path.")
        protected List<MeasureGroupStratifierComponent> stratifier;
        private static final long serialVersionUID = 1287622059L;

        public MeasureGroupComponent() {
        }

        public MeasureGroupComponent(Identifier identifier) {
            this.identifier = identifier;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureGroupComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MeasureGroupComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MeasureGroupComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public MeasureGroupComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public MeasureGroupComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<MeasureGroupPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<MeasureGroupPopulationComponent>();
            }
            return this.population;
        }

        public MeasureGroupComponent setPopulation(List<MeasureGroupPopulationComponent> thePopulation) {
            this.population = thePopulation;
            return this;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (MeasureGroupPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureGroupPopulationComponent addPopulation() {
            MeasureGroupPopulationComponent t = new MeasureGroupPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<MeasureGroupPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public MeasureGroupComponent addPopulation(MeasureGroupPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<MeasureGroupPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public MeasureGroupPopulationComponent getPopulationFirstRep() {
            if (this.getPopulation().isEmpty()) {
                this.addPopulation();
            }
            return this.getPopulation().get(0);
        }

        public List<MeasureGroupStratifierComponent> getStratifier() {
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
            }
            return this.stratifier;
        }

        public MeasureGroupComponent setStratifier(List<MeasureGroupStratifierComponent> theStratifier) {
            this.stratifier = theStratifier;
            return this;
        }

        public boolean hasStratifier() {
            if (this.stratifier == null) {
                return false;
            }
            for (MeasureGroupStratifierComponent item : this.stratifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureGroupStratifierComponent addStratifier() {
            MeasureGroupStratifierComponent t = new MeasureGroupStratifierComponent();
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return t;
        }

        public MeasureGroupComponent addStratifier(MeasureGroupStratifierComponent t) {
            if (t == null) {
                return this;
            }
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return this;
        }

        public MeasureGroupStratifierComponent getStratifierFirstRep() {
            if (this.getStratifier().isEmpty()) {
                this.addStratifier();
            }
            return this.getStratifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Measure.SP_IDENTIFIER, "Identifier", "A unique identifier for the group. This identifier will used to report data for the group in the measure report.", 0, 1, this.identifier));
            children.add(new Property(Measure.SP_NAME, "string", "Optional name or short description of this group.", 0, 1, this.name));
            children.add(new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population group.", 0, 1, this.description));
            children.add(new Property("population", "", "A population criteria for the measure.", 0, Integer.MAX_VALUE, this.population));
            children.add(new Property("stratifier", "", "The stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library, or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.stratifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(Measure.SP_IDENTIFIER, "Identifier", "A unique identifier for the group. This identifier will used to report data for the group in the measure report.", 0, 1, this.identifier);
                }
                case 3373707: {
                    return new Property(Measure.SP_NAME, "string", "Optional name or short description of this group.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population group.", 0, 1, this.description);
                }
                case -2023558323: {
                    return new Property("population", "", "A population criteria for the measure.", 0, Integer.MAX_VALUE, this.population);
                }
                case 90983669: {
                    return new Property("stratifier", "", "The stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library, or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.stratifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
                case 90983669: {
                    return this.stratifier == null ? new Base[]{} : this.stratifier.toArray(new Base[this.stratifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -2023558323: {
                    this.getPopulation().add((MeasureGroupPopulationComponent)value);
                    return value;
                }
                case 90983669: {
                    this.getStratifier().add((MeasureGroupStratifierComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals(Measure.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(Measure.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("population")) {
                this.getPopulation().add((MeasureGroupPopulationComponent)value);
            } else if (name.equals("stratifier")) {
                this.getStratifier().add((MeasureGroupStratifierComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -2023558323: {
                    return this.addPopulation();
                }
                case 90983669: {
                    return this.addStratifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -2023558323: {
                    return new String[0];
                }
                case 90983669: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(Measure.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.name");
            }
            if (name.equals(Measure.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type Measure.description");
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            if (name.equals("stratifier")) {
                return this.addStratifier();
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupComponent copy() {
            MeasureGroupComponent dst = new MeasureGroupComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.population != null) {
                dst.population = new ArrayList<MeasureGroupPopulationComponent>();
                for (MeasureGroupPopulationComponent measureGroupPopulationComponent : this.population) {
                    dst.population.add(measureGroupPopulationComponent.copy());
                }
            }
            if (this.stratifier != null) {
                dst.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
                for (MeasureGroupStratifierComponent measureGroupStratifierComponent : this.stratifier) {
                    dst.stratifier.add(measureGroupStratifierComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupComponent)) {
                return false;
            }
            MeasureGroupComponent o = (MeasureGroupComponent)other_;
            return MeasureGroupComponent.compareDeep(this.identifier, o.identifier, true) && MeasureGroupComponent.compareDeep(this.name, o.name, true) && MeasureGroupComponent.compareDeep(this.description, o.description, true) && MeasureGroupComponent.compareDeep(this.population, o.population, true) && MeasureGroupComponent.compareDeep(this.stratifier, o.stratifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MeasureGroupComponent)) {
                return false;
            }
            MeasureGroupComponent o = (MeasureGroupComponent)other_;
            return MeasureGroupComponent.compareValues(this.name, o.name, true) && MeasureGroupComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.name, this.description, this.population, this.stratifier);
        }

        @Override
        public String fhirType() {
            return "Measure.group";
        }
    }
}

