/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Age;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.ClinicalImpression;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DiagnosticReport;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Condition", profile="http://hl7.org/fhir/Profile/Condition")
public class Condition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this condition", formalDefinition="This records identifiers associated with this condition that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="clinicalStatus", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | recurrence | inactive | remission | resolved", formalDefinition="The clinical status of the condition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-clinical")
    protected Enumeration<ConditionClinicalStatus> clinicalStatus;
    @Child(name="verificationStatus", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="provisional | differential | confirmed | refuted | entered-in-error | unknown", formalDefinition="The verification status to support the clinical status of the condition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-ver-status")
    protected Enumeration<ConditionVerificationStatus> verificationStatus;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="problem-list-item | encounter-diagnosis", formalDefinition="A category assigned to the condition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-category")
    protected List<CodeableConcept> category;
    @Child(name="severity", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subjective severity of condition", formalDefinition="A subjective assessment of the severity of the condition as evaluated by the clinician.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-severity")
    protected CodeableConcept severity;
    @Child(name="code", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identification of the condition, problem or diagnosis", formalDefinition="Identification of the condition, problem or diagnosis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected CodeableConcept code;
    @Child(name="bodySite", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Anatomical location, if relevant", formalDefinition="The anatomical location where this condition manifests itself.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableConcept> bodySite;
    @Child(name="subject", type={Patient.class, Group.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who has the condition?", formalDefinition="Indicates the patient or group who the condition record is associated with.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter or episode when condition first asserted", formalDefinition="Encounter during which the condition was first asserted.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="onset", type={DateTimeType.class, Age.class, Period.class, Range.class, StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Estimated or actual date,  date-time, or age", formalDefinition="Estimated or actual date or date-time  the condition began, in the opinion of the clinician.")
    protected Type onset;
    @Child(name="abatement", type={DateTimeType.class, Age.class, BooleanType.class, Period.class, Range.class, StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="If/when in resolution/remission", formalDefinition="The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.")
    protected Type abatement;
    @Child(name="assertedDate", type={DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date record was believed accurate", formalDefinition="The date on which the existance of the Condition was first asserted or acknowledged.")
    protected DateTimeType assertedDate;
    @Child(name="asserter", type={Practitioner.class, Patient.class, RelatedPerson.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Person who asserts this condition", formalDefinition="Individual who is making the condition statement.")
    protected Reference asserter;
    protected Resource asserterTarget;
    @Child(name="stage", type={}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Stage/grade, usually assessed formally", formalDefinition="Clinical stage or grade of a condition. May include formal severity assessments.")
    protected ConditionStageComponent stage;
    @Child(name="evidence", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Supporting evidence", formalDefinition="Supporting Evidence / manifestations that are the basis on which this condition is suspected or confirmed.")
    protected List<ConditionEvidenceComponent> evidence;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information about the Condition", formalDefinition="Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -585250376L;
    @SearchParamDefinition(name="severity", path="Condition.severity", description="The severity of the condition", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="evidence-detail", path="Condition.evidence.detail", description="Supporting information found elsewhere", type="reference")
    public static final String SP_EVIDENCE_DETAIL = "evidence-detail";
    public static final ReferenceClientParam EVIDENCE_DETAIL = new ReferenceClientParam("evidence-detail");
    public static final Include INCLUDE_EVIDENCE_DETAIL = new Include("Condition:evidence-detail").toLocked();
    @SearchParamDefinition(name="identifier", path="Condition.identifier", description="A unique identifier of the condition record", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="onset-info", path="Condition.onset.as(string)", description="Onsets as a string", type="string")
    public static final String SP_ONSET_INFO = "onset-info";
    public static final StringClientParam ONSET_INFO = new StringClientParam("onset-info");
    @SearchParamDefinition(name="code", path="Condition.code", description="Code for the condition", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="evidence", path="Condition.evidence.code", description="Manifestation/symptom", type="token")
    public static final String SP_EVIDENCE = "evidence";
    public static final TokenClientParam EVIDENCE = new TokenClientParam("evidence");
    @SearchParamDefinition(name="subject", path="Condition.subject", description="Who has the condition?", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Condition:subject").toLocked();
    @SearchParamDefinition(name="verification-status", path="Condition.verificationStatus", description="provisional | differential | confirmed | refuted | entered-in-error | unknown", type="token")
    public static final String SP_VERIFICATION_STATUS = "verification-status";
    public static final TokenClientParam VERIFICATION_STATUS = new TokenClientParam("verification-status");
    @SearchParamDefinition(name="clinical-status", path="Condition.clinicalStatus", description="The clinical status of the condition", type="token")
    public static final String SP_CLINICAL_STATUS = "clinical-status";
    public static final TokenClientParam CLINICAL_STATUS = new TokenClientParam("clinical-status");
    @SearchParamDefinition(name="encounter", path="Condition.context", description="Encounter when condition first asserted", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Condition:encounter").toLocked();
    @SearchParamDefinition(name="abatement-boolean", path="Condition.abatement.as(boolean) | Condition.abatement.is(dateTime) | Condition.abatement.is(Age) | Condition.abatement.is(Period) | Condition.abatement.is(Range) | Condition.abatement.is(string)", description="Abatement boolean (boolean is true or non-boolean values are present)", type="token")
    public static final String SP_ABATEMENT_BOOLEAN = "abatement-boolean";
    public static final TokenClientParam ABATEMENT_BOOLEAN = new TokenClientParam("abatement-boolean");
    @SearchParamDefinition(name="onset-date", path="Condition.onset.as(dateTime) | Condition.onset.as(Period)", description="Date related onsets (dateTime and Period)", type="date")
    public static final String SP_ONSET_DATE = "onset-date";
    public static final DateClientParam ONSET_DATE = new DateClientParam("onset-date");
    @SearchParamDefinition(name="abatement-date", path="Condition.abatement.as(dateTime) | Condition.abatement.as(Period)", description="Date-related abatements (dateTime and period)", type="date")
    public static final String SP_ABATEMENT_DATE = "abatement-date";
    public static final DateClientParam ABATEMENT_DATE = new DateClientParam("abatement-date");
    @SearchParamDefinition(name="asserter", path="Condition.asserter", description="Person who asserts this condition", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_ASSERTER = "asserter";
    public static final ReferenceClientParam ASSERTER = new ReferenceClientParam("asserter");
    public static final Include INCLUDE_ASSERTER = new Include("Condition:asserter").toLocked();
    @SearchParamDefinition(name="stage", path="Condition.stage.summary", description="Simple summary (disease specific)", type="token")
    public static final String SP_STAGE = "stage";
    public static final TokenClientParam STAGE = new TokenClientParam("stage");
    @SearchParamDefinition(name="abatement-string", path="Condition.abatement.as(string)", description="Abatement as a string", type="string")
    public static final String SP_ABATEMENT_STRING = "abatement-string";
    public static final StringClientParam ABATEMENT_STRING = new StringClientParam("abatement-string");
    @SearchParamDefinition(name="patient", path="Condition.subject", description="Who has the condition?", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Condition:patient").toLocked();
    @SearchParamDefinition(name="context", path="Condition.context", description="Encounter or episode when condition first asserted", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("Condition:context").toLocked();
    @SearchParamDefinition(name="onset-age", path="Condition.onset.as(Age) | Condition.onset.as(Range)", description="Onsets as age or age range", type="quantity")
    public static final String SP_ONSET_AGE = "onset-age";
    public static final QuantityClientParam ONSET_AGE = new QuantityClientParam("onset-age");
    @SearchParamDefinition(name="abatement-age", path="Condition.abatement.as(Age) | Condition.abatement.as(Range) | Condition.abatement.as(Age)", description="Abatement as age or age range", type="quantity")
    public static final String SP_ABATEMENT_AGE = "abatement-age";
    public static final QuantityClientParam ABATEMENT_AGE = new QuantityClientParam("abatement-age");
    @SearchParamDefinition(name="asserted-date", path="Condition.assertedDate", description="Date record was believed accurate", type="date")
    public static final String SP_ASSERTED_DATE = "asserted-date";
    public static final DateClientParam ASSERTED_DATE = new DateClientParam("asserted-date");
    @SearchParamDefinition(name="category", path="Condition.category", description="The category of the condition", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="body-site", path="Condition.bodySite", description="Anatomical location, if relevant", type="token")
    public static final String SP_BODY_SITE = "body-site";
    public static final TokenClientParam BODY_SITE = new TokenClientParam("body-site");

    public Condition() {
    }

    public Condition(Reference subject) {
        this.subject = subject;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Condition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Condition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ConditionClinicalStatus> getClinicalStatusElement() {
        if (this.clinicalStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.clinicalStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.clinicalStatus = new Enumeration<ConditionClinicalStatus>(new ConditionClinicalStatusEnumFactory());
            }
        }
        return this.clinicalStatus;
    }

    public boolean hasClinicalStatusElement() {
        return this.clinicalStatus != null && !this.clinicalStatus.isEmpty();
    }

    public boolean hasClinicalStatus() {
        return this.clinicalStatus != null && !this.clinicalStatus.isEmpty();
    }

    public Condition setClinicalStatusElement(Enumeration<ConditionClinicalStatus> value) {
        this.clinicalStatus = value;
        return this;
    }

    public ConditionClinicalStatus getClinicalStatus() {
        return this.clinicalStatus == null ? null : (ConditionClinicalStatus)((Object)this.clinicalStatus.getValue());
    }

    public Condition setClinicalStatus(ConditionClinicalStatus value) {
        if (value == null) {
            this.clinicalStatus = null;
        } else {
            if (this.clinicalStatus == null) {
                this.clinicalStatus = new Enumeration<ConditionClinicalStatus>(new ConditionClinicalStatusEnumFactory());
            }
            this.clinicalStatus.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<ConditionVerificationStatus> getVerificationStatusElement() {
        if (this.verificationStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.verificationStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.verificationStatus = new Enumeration<ConditionVerificationStatus>(new ConditionVerificationStatusEnumFactory());
            }
        }
        return this.verificationStatus;
    }

    public boolean hasVerificationStatusElement() {
        return this.verificationStatus != null && !this.verificationStatus.isEmpty();
    }

    public boolean hasVerificationStatus() {
        return this.verificationStatus != null && !this.verificationStatus.isEmpty();
    }

    public Condition setVerificationStatusElement(Enumeration<ConditionVerificationStatus> value) {
        this.verificationStatus = value;
        return this;
    }

    public ConditionVerificationStatus getVerificationStatus() {
        return this.verificationStatus == null ? null : (ConditionVerificationStatus)((Object)this.verificationStatus.getValue());
    }

    public Condition setVerificationStatus(ConditionVerificationStatus value) {
        if (value == null) {
            this.verificationStatus = null;
        } else {
            if (this.verificationStatus == null) {
                this.verificationStatus = new Enumeration<ConditionVerificationStatus>(new ConditionVerificationStatusEnumFactory());
            }
            this.verificationStatus.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Condition setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Condition addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getSeverity() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new CodeableConcept();
            }
        }
        return this.severity;
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public Condition setSeverity(CodeableConcept value) {
        this.severity = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Condition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public Condition setBodySite(List<CodeableConcept> theBodySite) {
        this.bodySite = theBodySite;
        return this;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public Condition addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public CodeableConcept getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Condition setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Condition setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public Condition setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public Condition setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Type getOnset() {
        return this.onset;
    }

    public DateTimeType getOnsetDateTimeType() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.onset;
    }

    public boolean hasOnsetDateTimeType() {
        return this != null && this.onset instanceof DateTimeType;
    }

    public Age getOnsetAge() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Age)this.onset;
    }

    public boolean hasOnsetAge() {
        return this != null && this.onset instanceof Age;
    }

    public Period getOnsetPeriod() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Period)this.onset;
    }

    public boolean hasOnsetPeriod() {
        return this != null && this.onset instanceof Period;
    }

    public Range getOnsetRange() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Range)this.onset;
    }

    public boolean hasOnsetRange() {
        return this != null && this.onset instanceof Range;
    }

    public StringType getOnsetStringType() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (StringType)this.onset;
    }

    public boolean hasOnsetStringType() {
        return this != null && this.onset instanceof StringType;
    }

    public boolean hasOnset() {
        return this.onset != null && !this.onset.isEmpty();
    }

    public Condition setOnset(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof DateTimeType || value instanceof Age || value instanceof Period || value instanceof Range || value instanceof StringType)) {
            throw new FHIRFormatError("Not the right type for Condition.onset[x]: " + value.fhirType());
        }
        this.onset = value;
        return this;
    }

    public Type getAbatement() {
        return this.abatement;
    }

    public DateTimeType getAbatementDateTimeType() throws FHIRException {
        if (this.abatement == null) {
            return null;
        }
        if (!(this.abatement instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.abatement;
    }

    public boolean hasAbatementDateTimeType() {
        return this != null && this.abatement instanceof DateTimeType;
    }

    public Age getAbatementAge() throws FHIRException {
        if (this.abatement == null) {
            return null;
        }
        if (!(this.abatement instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (Age)this.abatement;
    }

    public boolean hasAbatementAge() {
        return this != null && this.abatement instanceof Age;
    }

    public BooleanType getAbatementBooleanType() throws FHIRException {
        if (this.abatement == null) {
            return null;
        }
        if (!(this.abatement instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.abatement;
    }

    public boolean hasAbatementBooleanType() {
        return this != null && this.abatement instanceof BooleanType;
    }

    public Period getAbatementPeriod() throws FHIRException {
        if (this.abatement == null) {
            return null;
        }
        if (!(this.abatement instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (Period)this.abatement;
    }

    public boolean hasAbatementPeriod() {
        return this != null && this.abatement instanceof Period;
    }

    public Range getAbatementRange() throws FHIRException {
        if (this.abatement == null) {
            return null;
        }
        if (!(this.abatement instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (Range)this.abatement;
    }

    public boolean hasAbatementRange() {
        return this != null && this.abatement instanceof Range;
    }

    public StringType getAbatementStringType() throws FHIRException {
        if (this.abatement == null) {
            return null;
        }
        if (!(this.abatement instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.abatement.getClass().getName() + " was encountered");
        }
        return (StringType)this.abatement;
    }

    public boolean hasAbatementStringType() {
        return this != null && this.abatement instanceof StringType;
    }

    public boolean hasAbatement() {
        return this.abatement != null && !this.abatement.isEmpty();
    }

    public Condition setAbatement(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof DateTimeType || value instanceof Age || value instanceof BooleanType || value instanceof Period || value instanceof Range || value instanceof StringType)) {
            throw new FHIRFormatError("Not the right type for Condition.abatement[x]: " + value.fhirType());
        }
        this.abatement = value;
        return this;
    }

    public DateTimeType getAssertedDateElement() {
        if (this.assertedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.assertedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.assertedDate = new DateTimeType();
            }
        }
        return this.assertedDate;
    }

    public boolean hasAssertedDateElement() {
        return this.assertedDate != null && !this.assertedDate.isEmpty();
    }

    public boolean hasAssertedDate() {
        return this.assertedDate != null && !this.assertedDate.isEmpty();
    }

    public Condition setAssertedDateElement(DateTimeType value) {
        this.assertedDate = value;
        return this;
    }

    public Date getAssertedDate() {
        return this.assertedDate == null ? null : (Date)this.assertedDate.getValue();
    }

    public Condition setAssertedDate(Date value) {
        if (value == null) {
            this.assertedDate = null;
        } else {
            if (this.assertedDate == null) {
                this.assertedDate = new DateTimeType();
            }
            this.assertedDate.setValue(value);
        }
        return this;
    }

    public Reference getAsserter() {
        if (this.asserter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.asserter");
            }
            if (Configuration.doAutoCreate()) {
                this.asserter = new Reference();
            }
        }
        return this.asserter;
    }

    public boolean hasAsserter() {
        return this.asserter != null && !this.asserter.isEmpty();
    }

    public Condition setAsserter(Reference value) {
        this.asserter = value;
        return this;
    }

    public Resource getAsserterTarget() {
        return this.asserterTarget;
    }

    public Condition setAsserterTarget(Resource value) {
        this.asserterTarget = value;
        return this;
    }

    public ConditionStageComponent getStage() {
        if (this.stage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Condition.stage");
            }
            if (Configuration.doAutoCreate()) {
                this.stage = new ConditionStageComponent();
            }
        }
        return this.stage;
    }

    public boolean hasStage() {
        return this.stage != null && !this.stage.isEmpty();
    }

    public Condition setStage(ConditionStageComponent value) {
        this.stage = value;
        return this;
    }

    public List<ConditionEvidenceComponent> getEvidence() {
        if (this.evidence == null) {
            this.evidence = new ArrayList<ConditionEvidenceComponent>();
        }
        return this.evidence;
    }

    public Condition setEvidence(List<ConditionEvidenceComponent> theEvidence) {
        this.evidence = theEvidence;
        return this;
    }

    public boolean hasEvidence() {
        if (this.evidence == null) {
            return false;
        }
        for (ConditionEvidenceComponent item : this.evidence) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionEvidenceComponent addEvidence() {
        ConditionEvidenceComponent t = new ConditionEvidenceComponent();
        if (this.evidence == null) {
            this.evidence = new ArrayList<ConditionEvidenceComponent>();
        }
        this.evidence.add(t);
        return t;
    }

    public Condition addEvidence(ConditionEvidenceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.evidence == null) {
            this.evidence = new ArrayList<ConditionEvidenceComponent>();
        }
        this.evidence.add(t);
        return this;
    }

    public ConditionEvidenceComponent getEvidenceFirstRep() {
        if (this.getEvidence().isEmpty()) {
            this.addEvidence();
        }
        return this.getEvidence().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Condition setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Condition addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this condition that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("clinicalStatus", SP_CODE, "The clinical status of the condition.", 0, 1, this.clinicalStatus));
        children.add(new Property("verificationStatus", SP_CODE, "The verification status to support the clinical status of the condition.", 0, 1, this.verificationStatus));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A category assigned to the condition.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_SEVERITY, "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, 1, this.severity));
        children.add(new Property(SP_CODE, "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, 1, this.code));
        children.add(new Property("bodySite", "CodeableConcept", "The anatomical location where this condition manifests itself.", 0, Integer.MAX_VALUE, this.bodySite));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "Indicates the patient or group who the condition record is associated with.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "Encounter during which the condition was first asserted.", 0, 1, this.context));
        children.add(new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset));
        children.add(new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, 1, this.abatement));
        children.add(new Property("assertedDate", "dateTime", "The date on which the existance of the Condition was first asserted or acknowledged.", 0, 1, this.assertedDate));
        children.add(new Property(SP_ASSERTER, "Reference(Practitioner|Patient|RelatedPerson)", "Individual who is making the condition statement.", 0, 1, this.asserter));
        children.add(new Property(SP_STAGE, "", "Clinical stage or grade of a condition. May include formal severity assessments.", 0, 1, this.stage));
        children.add(new Property(SP_EVIDENCE, "", "Supporting Evidence / manifestations that are the basis on which this condition is suspected or confirmed.", 0, Integer.MAX_VALUE, this.evidence));
        children.add(new Property("note", "Annotation", "Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this condition that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -462853915: {
                return new Property("clinicalStatus", SP_CODE, "The clinical status of the condition.", 0, 1, this.clinicalStatus);
            }
            case -842509843: {
                return new Property("verificationStatus", SP_CODE, "The verification status to support the clinical status of the condition.", 0, 1, this.verificationStatus);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A category assigned to the condition.", 0, Integer.MAX_VALUE, this.category);
            }
            case 1478300413: {
                return new Property(SP_SEVERITY, "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, 1, this.severity);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, 1, this.code);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "The anatomical location where this condition manifests itself.", 0, Integer.MAX_VALUE, this.bodySite);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "Indicates the patient or group who the condition record is associated with.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "Encounter during which the condition was first asserted.", 0, 1, this.context);
            }
            case -1886216323: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case 105901603: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -1701663010: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -1886241828: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -1545082428: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -186664742: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -1445342188: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date or date-time  the condition began, in the opinion of the clinician.", 0, 1, this.onset);
            }
            case -584196495: {
                return new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -921554001: {
                return new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case 44869738: {
                return new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -584222000: {
                return new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -2069881479: {
                return new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -922036656: {
                return new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case 1218906830: {
                return new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -822296416: {
                return new Property("abatement[x]", "dateTime|Age|boolean|Period|Range|string", "The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.", 0, 1, this.abatement);
            }
            case -174231629: {
                return new Property("assertedDate", "dateTime", "The date on which the existance of the Condition was first asserted or acknowledged.", 0, 1, this.assertedDate);
            }
            case -373242253: {
                return new Property(SP_ASSERTER, "Reference(Practitioner|Patient|RelatedPerson)", "Individual who is making the condition statement.", 0, 1, this.asserter);
            }
            case 109757182: {
                return new Property(SP_STAGE, "", "Clinical stage or grade of a condition. May include formal severity assessments.", 0, 1, this.stage);
            }
            case 382967383: {
                return new Property(SP_EVIDENCE, "", "Supporting Evidence / manifestations that are the basis on which this condition is suspected or confirmed.", 0, Integer.MAX_VALUE, this.evidence);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -462853915: {
                Base[] baseArray;
                if (this.clinicalStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.clinicalStatus;
                }
                return baseArray;
            }
            case -842509843: {
                Base[] baseArray;
                if (this.verificationStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.verificationStatus;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.severity;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.code;
                }
                return baseArray;
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.context;
                }
                return baseArray;
            }
            case 105901603: {
                Base[] baseArray;
                if (this.onset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.onset;
                }
                return baseArray;
            }
            case -921554001: {
                Base[] baseArray;
                if (this.abatement == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.abatement;
                }
                return baseArray;
            }
            case -174231629: {
                Base[] baseArray;
                if (this.assertedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.assertedDate;
                }
                return baseArray;
            }
            case -373242253: {
                Base[] baseArray;
                if (this.asserter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.asserter;
                }
                return baseArray;
            }
            case 109757182: {
                Base[] baseArray;
                if (this.stage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.stage;
                }
                return baseArray;
            }
            case 382967383: {
                return this.evidence == null ? new Base[]{} : this.evidence.toArray(new Base[this.evidence.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -462853915: {
                value = new ConditionClinicalStatusEnumFactory().fromType(this.castToCode(value));
                this.clinicalStatus = value;
                return value;
            }
            case -842509843: {
                value = new ConditionVerificationStatusEnumFactory().fromType(this.castToCode(value));
                this.verificationStatus = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1478300413: {
                this.severity = this.castToCodeableConcept(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case 1702620169: {
                this.getBodySite().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case 105901603: {
                this.onset = this.castToType(value);
                return value;
            }
            case -921554001: {
                this.abatement = this.castToType(value);
                return value;
            }
            case -174231629: {
                this.assertedDate = this.castToDateTime(value);
                return value;
            }
            case -373242253: {
                this.asserter = this.castToReference(value);
                return value;
            }
            case 109757182: {
                this.stage = (ConditionStageComponent)((Object)value);
                return value;
            }
            case 382967383: {
                this.getEvidence().add((ConditionEvidenceComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("clinicalStatus")) {
            value = new ConditionClinicalStatusEnumFactory().fromType(this.castToCode(value));
            this.clinicalStatus = value;
        } else if (name.equals("verificationStatus")) {
            value = new ConditionVerificationStatusEnumFactory().fromType(this.castToCode(value));
            this.verificationStatus = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_SEVERITY)) {
            this.severity = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("onset[x]")) {
            this.onset = this.castToType(value);
        } else if (name.equals("abatement[x]")) {
            this.abatement = this.castToType(value);
        } else if (name.equals("assertedDate")) {
            this.assertedDate = this.castToDateTime(value);
        } else if (name.equals(SP_ASSERTER)) {
            this.asserter = this.castToReference(value);
        } else if (name.equals(SP_STAGE)) {
            this.stage = (ConditionStageComponent)((Object)value);
        } else if (name.equals(SP_EVIDENCE)) {
            this.getEvidence().add((ConditionEvidenceComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -462853915: {
                return this.getClinicalStatusElement();
            }
            case -842509843: {
                return this.getVerificationStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 1478300413: {
                return this.getSeverity();
            }
            case 3059181: {
                return this.getCode();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -1886216323: {
                return this.getOnset();
            }
            case 105901603: {
                return this.getOnset();
            }
            case -584196495: {
                return this.getAbatement();
            }
            case -921554001: {
                return this.getAbatement();
            }
            case -174231629: {
                return this.getAssertedDateElement();
            }
            case -373242253: {
                return this.getAsserter();
            }
            case 109757182: {
                return this.getStage();
            }
            case 382967383: {
                return this.addEvidence();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -462853915: {
                return new String[]{SP_CODE};
            }
            case -842509843: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 1478300413: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 105901603: {
                return new String[]{"dateTime", "Age", "Period", "Range", "string"};
            }
            case -921554001: {
                return new String[]{"dateTime", "Age", "boolean", "Period", "Range", "string"};
            }
            case -174231629: {
                return new String[]{"dateTime"};
            }
            case -373242253: {
                return new String[]{"Reference"};
            }
            case 109757182: {
                return new String[0];
            }
            case 382967383: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("clinicalStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type Condition.clinicalStatus");
        }
        if (name.equals("verificationStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type Condition.verificationStatus");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_SEVERITY)) {
            this.severity = new CodeableConcept();
            return this.severity;
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("onsetDateTime")) {
            this.onset = new DateTimeType();
            return this.onset;
        }
        if (name.equals("onsetAge")) {
            this.onset = new Age();
            return this.onset;
        }
        if (name.equals("onsetPeriod")) {
            this.onset = new Period();
            return this.onset;
        }
        if (name.equals("onsetRange")) {
            this.onset = new Range();
            return this.onset;
        }
        if (name.equals("onsetString")) {
            this.onset = new StringType();
            return this.onset;
        }
        if (name.equals("abatementDateTime")) {
            this.abatement = new DateTimeType();
            return this.abatement;
        }
        if (name.equals("abatementAge")) {
            this.abatement = new Age();
            return this.abatement;
        }
        if (name.equals("abatementBoolean")) {
            this.abatement = new BooleanType();
            return this.abatement;
        }
        if (name.equals("abatementPeriod")) {
            this.abatement = new Period();
            return this.abatement;
        }
        if (name.equals("abatementRange")) {
            this.abatement = new Range();
            return this.abatement;
        }
        if (name.equals("abatementString")) {
            this.abatement = new StringType();
            return this.abatement;
        }
        if (name.equals("assertedDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Condition.assertedDate");
        }
        if (name.equals(SP_ASSERTER)) {
            this.asserter = new Reference();
            return this.asserter;
        }
        if (name.equals(SP_STAGE)) {
            this.stage = new ConditionStageComponent();
            return this.stage;
        }
        if (name.equals(SP_EVIDENCE)) {
            return this.addEvidence();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Condition";
    }

    @Override
    public Condition copy() {
        Condition dst = new Condition();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.clinicalStatus = this.clinicalStatus == null ? null : this.clinicalStatus.copy();
        Enumeration<ConditionVerificationStatus> enumeration = dst.verificationStatus = this.verificationStatus == null ? null : this.verificationStatus.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.severity = this.severity == null ? null : this.severity.copy();
        CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.bodySite) {
                dst.bodySite.add(codeableConcept2.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.onset = this.onset == null ? null : this.onset.copy();
        dst.abatement = this.abatement == null ? null : this.abatement.copy();
        dst.assertedDate = this.assertedDate == null ? null : this.assertedDate.copy();
        dst.asserter = this.asserter == null ? null : this.asserter.copy();
        ConditionStageComponent conditionStageComponent = dst.stage = this.stage == null ? null : this.stage.copy();
        if (this.evidence != null) {
            dst.evidence = new ArrayList<ConditionEvidenceComponent>();
            for (ConditionEvidenceComponent conditionEvidenceComponent : this.evidence) {
                dst.evidence.add(conditionEvidenceComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        return dst;
    }

    protected Condition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Condition)) {
            return false;
        }
        Condition o = (Condition)other_;
        return Condition.compareDeep(this.identifier, o.identifier, true) && Condition.compareDeep(this.clinicalStatus, o.clinicalStatus, true) && Condition.compareDeep(this.verificationStatus, o.verificationStatus, true) && Condition.compareDeep(this.category, o.category, true) && Condition.compareDeep(this.severity, o.severity, true) && Condition.compareDeep(this.code, o.code, true) && Condition.compareDeep(this.bodySite, o.bodySite, true) && Condition.compareDeep(this.subject, o.subject, true) && Condition.compareDeep(this.context, o.context, true) && Condition.compareDeep(this.onset, o.onset, true) && Condition.compareDeep(this.abatement, o.abatement, true) && Condition.compareDeep(this.assertedDate, o.assertedDate, true) && Condition.compareDeep(this.asserter, o.asserter, true) && Condition.compareDeep(this.stage, o.stage, true) && Condition.compareDeep(this.evidence, o.evidence, true) && Condition.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Condition)) {
            return false;
        }
        Condition o = (Condition)other_;
        return Condition.compareValues(this.clinicalStatus, o.clinicalStatus, true) && Condition.compareValues(this.verificationStatus, o.verificationStatus, true) && Condition.compareValues(this.assertedDate, o.assertedDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.clinicalStatus, this.verificationStatus, this.category, this.severity, this.code, this.bodySite, this.subject, this.context, this.onset, this.abatement, this.assertedDate, this.asserter, this.stage, this.evidence, this.note);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Condition;
    }

    @Block
    public static class ConditionEvidenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Manifestation/symptom", formalDefinition="A manifestation or symptom that led to the recording of this condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/manifestation-or-symptom")
        protected List<CodeableConcept> code;
        @Child(name="detail", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting information found elsewhere", formalDefinition="Links to other relevant information, including pathology reports.")
        protected List<Reference> detail;
        protected List<Resource> detailTarget;
        private static final long serialVersionUID = 1135831276L;

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public ConditionEvidenceComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public ConditionEvidenceComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public List<Reference> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            return this.detail;
        }

        public ConditionEvidenceComponent setDetail(List<Reference> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (Reference item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDetail() {
            Reference t = new Reference();
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return t;
        }

        public ConditionEvidenceComponent addDetail(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return this;
        }

        public Reference getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Deprecated
        public List<Resource> getDetailTarget() {
            if (this.detailTarget == null) {
                this.detailTarget = new ArrayList<Resource>();
            }
            return this.detailTarget;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Condition.SP_CODE, "CodeableConcept", "A manifestation or symptom that led to the recording of this condition.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("detail", "Reference(Any)", "Links to other relevant information, including pathology reports.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(Condition.SP_CODE, "CodeableConcept", "A manifestation or symptom that led to the recording of this condition.", 0, Integer.MAX_VALUE, this.code);
                }
                case -1335224239: {
                    return new Property("detail", "Reference(Any)", "Links to other relevant information, including pathology reports.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.getCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Condition.SP_CODE)) {
                this.getCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("detail")) {
                this.getDetail().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.addCode();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335224239: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Condition.SP_CODE)) {
                return this.addCode();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ConditionEvidenceComponent copy() {
            ConditionEvidenceComponent dst = new ConditionEvidenceComponent();
            this.copyValues(dst);
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<Reference>();
                for (Reference reference : this.detail) {
                    dst.detail.add(reference.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionEvidenceComponent)) {
                return false;
            }
            ConditionEvidenceComponent o = (ConditionEvidenceComponent)other_;
            return ConditionEvidenceComponent.compareDeep(this.code, o.code, true) && ConditionEvidenceComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionEvidenceComponent)) {
                return false;
            }
            ConditionEvidenceComponent o = (ConditionEvidenceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.detail);
        }

        @Override
        public String fhirType() {
            return "Condition.evidence";
        }
    }

    @Block
    public static class ConditionStageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="summary", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Simple summary (disease specific)", formalDefinition="A simple summary of the stage such as \"Stage 3\". The determination of the stage is disease-specific.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-stage")
        protected CodeableConcept summary;
        @Child(name="assessment", type={ClinicalImpression.class, DiagnosticReport.class, Observation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Formal record of assessment", formalDefinition="Reference to a formal record of the evidence on which the staging assessment is based.")
        protected List<Reference> assessment;
        protected List<Resource> assessmentTarget;
        private static final long serialVersionUID = -1961530405L;

        public CodeableConcept getSummary() {
            if (this.summary == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionStageComponent.summary");
                }
                if (Configuration.doAutoCreate()) {
                    this.summary = new CodeableConcept();
                }
            }
            return this.summary;
        }

        public boolean hasSummary() {
            return this.summary != null && !this.summary.isEmpty();
        }

        public ConditionStageComponent setSummary(CodeableConcept value) {
            this.summary = value;
            return this;
        }

        public List<Reference> getAssessment() {
            if (this.assessment == null) {
                this.assessment = new ArrayList<Reference>();
            }
            return this.assessment;
        }

        public ConditionStageComponent setAssessment(List<Reference> theAssessment) {
            this.assessment = theAssessment;
            return this;
        }

        public boolean hasAssessment() {
            if (this.assessment == null) {
                return false;
            }
            for (Reference item : this.assessment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAssessment() {
            Reference t = new Reference();
            if (this.assessment == null) {
                this.assessment = new ArrayList<Reference>();
            }
            this.assessment.add(t);
            return t;
        }

        public ConditionStageComponent addAssessment(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.assessment == null) {
                this.assessment = new ArrayList<Reference>();
            }
            this.assessment.add(t);
            return this;
        }

        public Reference getAssessmentFirstRep() {
            if (this.getAssessment().isEmpty()) {
                this.addAssessment();
            }
            return this.getAssessment().get(0);
        }

        @Deprecated
        public List<Resource> getAssessmentTarget() {
            if (this.assessmentTarget == null) {
                this.assessmentTarget = new ArrayList<Resource>();
            }
            return this.assessmentTarget;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("summary", "CodeableConcept", "A simple summary of the stage such as \"Stage 3\". The determination of the stage is disease-specific.", 0, 1, this.summary));
            children.add(new Property("assessment", "Reference(ClinicalImpression|DiagnosticReport|Observation)", "Reference to a formal record of the evidence on which the staging assessment is based.", 0, Integer.MAX_VALUE, this.assessment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1857640538: {
                    return new Property("summary", "CodeableConcept", "A simple summary of the stage such as \"Stage 3\". The determination of the stage is disease-specific.", 0, 1, this.summary);
                }
                case 2119382722: {
                    return new Property("assessment", "Reference(ClinicalImpression|DiagnosticReport|Observation)", "Reference to a formal record of the evidence on which the staging assessment is based.", 0, Integer.MAX_VALUE, this.assessment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    Base[] baseArray;
                    if (this.summary == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.summary;
                    }
                    return baseArray;
                }
                case 2119382722: {
                    return this.assessment == null ? new Base[]{} : this.assessment.toArray(new Base[this.assessment.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    this.summary = this.castToCodeableConcept(value);
                    return value;
                }
                case 2119382722: {
                    this.getAssessment().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("summary")) {
                this.summary = this.castToCodeableConcept(value);
            } else if (name.equals("assessment")) {
                this.getAssessment().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    return this.getSummary();
                }
                case 2119382722: {
                    return this.addAssessment();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1857640538: {
                    return new String[]{"CodeableConcept"};
                }
                case 2119382722: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("summary")) {
                this.summary = new CodeableConcept();
                return this.summary;
            }
            if (name.equals("assessment")) {
                return this.addAssessment();
            }
            return super.addChild(name);
        }

        @Override
        public ConditionStageComponent copy() {
            ConditionStageComponent dst = new ConditionStageComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.summary = this.summary == null ? null : this.summary.copy();
            if (this.assessment != null) {
                dst.assessment = new ArrayList<Reference>();
                for (Reference i : this.assessment) {
                    dst.assessment.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionStageComponent)) {
                return false;
            }
            ConditionStageComponent o = (ConditionStageComponent)other_;
            return ConditionStageComponent.compareDeep(this.summary, o.summary, true) && ConditionStageComponent.compareDeep(this.assessment, o.assessment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionStageComponent)) {
                return false;
            }
            ConditionStageComponent o = (ConditionStageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.summary, this.assessment);
        }

        @Override
        public String fhirType() {
            return "Condition.stage";
        }
    }

    public static class ConditionVerificationStatusEnumFactory
    implements EnumFactory<ConditionVerificationStatus> {
        @Override
        public ConditionVerificationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("provisional".equals(codeString)) {
                return ConditionVerificationStatus.PROVISIONAL;
            }
            if ("differential".equals(codeString)) {
                return ConditionVerificationStatus.DIFFERENTIAL;
            }
            if ("confirmed".equals(codeString)) {
                return ConditionVerificationStatus.CONFIRMED;
            }
            if ("refuted".equals(codeString)) {
                return ConditionVerificationStatus.REFUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ConditionVerificationStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ConditionVerificationStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ConditionVerificationStatus code '" + codeString + "'");
        }

        public Enumeration<ConditionVerificationStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConditionVerificationStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("provisional".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.PROVISIONAL);
            }
            if ("differential".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.DIFFERENTIAL);
            }
            if ("confirmed".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.CONFIRMED);
            }
            if ("refuted".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.REFUTED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ConditionVerificationStatus>(this, ConditionVerificationStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ConditionVerificationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionVerificationStatus code) {
            if (code == ConditionVerificationStatus.PROVISIONAL) {
                return "provisional";
            }
            if (code == ConditionVerificationStatus.DIFFERENTIAL) {
                return "differential";
            }
            if (code == ConditionVerificationStatus.CONFIRMED) {
                return "confirmed";
            }
            if (code == ConditionVerificationStatus.REFUTED) {
                return "refuted";
            }
            if (code == ConditionVerificationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ConditionVerificationStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ConditionVerificationStatus code) {
            return code.getSystem();
        }
    }

    public static enum ConditionVerificationStatus {
        PROVISIONAL,
        DIFFERENTIAL,
        CONFIRMED,
        REFUTED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ConditionVerificationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("provisional".equals(codeString)) {
                return PROVISIONAL;
            }
            if ("differential".equals(codeString)) {
                return DIFFERENTIAL;
            }
            if ("confirmed".equals(codeString)) {
                return CONFIRMED;
            }
            if ("refuted".equals(codeString)) {
                return REFUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConditionVerificationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROVISIONAL: {
                    return "provisional";
                }
                case DIFFERENTIAL: {
                    return "differential";
                }
                case CONFIRMED: {
                    return "confirmed";
                }
                case REFUTED: {
                    return "refuted";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROVISIONAL: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case DIFFERENTIAL: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case CONFIRMED: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case REFUTED: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/condition-ver-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROVISIONAL: {
                    return "This is a tentative diagnosis - still a candidate that is under consideration.";
                }
                case DIFFERENTIAL: {
                    return "One of a set of potential (and typically mutually exclusive) diagnoses asserted to further guide the diagnostic process and preliminary treatment.";
                }
                case CONFIRMED: {
                    return "There is sufficient diagnostic and/or clinical evidence to treat this as a confirmed condition.";
                }
                case REFUTED: {
                    return "This condition has been ruled out by diagnostic and clinical evidence.";
                }
                case ENTEREDINERROR: {
                    return "The statement was entered in error and is not valid.";
                }
                case UNKNOWN: {
                    return "The condition status is unknown.  Note that \"unknown\" is a value of last resort and every attempt should be made to provide a meaningful value other than \"unknown\".";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROVISIONAL: {
                    return "Provisional";
                }
                case DIFFERENTIAL: {
                    return "Differential";
                }
                case CONFIRMED: {
                    return "Confirmed";
                }
                case REFUTED: {
                    return "Refuted";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }

    public static class ConditionClinicalStatusEnumFactory
    implements EnumFactory<ConditionClinicalStatus> {
        @Override
        public ConditionClinicalStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ConditionClinicalStatus.ACTIVE;
            }
            if ("recurrence".equals(codeString)) {
                return ConditionClinicalStatus.RECURRENCE;
            }
            if ("inactive".equals(codeString)) {
                return ConditionClinicalStatus.INACTIVE;
            }
            if ("remission".equals(codeString)) {
                return ConditionClinicalStatus.REMISSION;
            }
            if ("resolved".equals(codeString)) {
                return ConditionClinicalStatus.RESOLVED;
            }
            throw new IllegalArgumentException("Unknown ConditionClinicalStatus code '" + codeString + "'");
        }

        public Enumeration<ConditionClinicalStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConditionClinicalStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ConditionClinicalStatus>(this, ConditionClinicalStatus.ACTIVE);
            }
            if ("recurrence".equals(codeString)) {
                return new Enumeration<ConditionClinicalStatus>(this, ConditionClinicalStatus.RECURRENCE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<ConditionClinicalStatus>(this, ConditionClinicalStatus.INACTIVE);
            }
            if ("remission".equals(codeString)) {
                return new Enumeration<ConditionClinicalStatus>(this, ConditionClinicalStatus.REMISSION);
            }
            if ("resolved".equals(codeString)) {
                return new Enumeration<ConditionClinicalStatus>(this, ConditionClinicalStatus.RESOLVED);
            }
            throw new FHIRException("Unknown ConditionClinicalStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionClinicalStatus code) {
            if (code == ConditionClinicalStatus.ACTIVE) {
                return "active";
            }
            if (code == ConditionClinicalStatus.RECURRENCE) {
                return "recurrence";
            }
            if (code == ConditionClinicalStatus.INACTIVE) {
                return "inactive";
            }
            if (code == ConditionClinicalStatus.REMISSION) {
                return "remission";
            }
            if (code == ConditionClinicalStatus.RESOLVED) {
                return "resolved";
            }
            return "?";
        }

        @Override
        public String toSystem(ConditionClinicalStatus code) {
            return code.getSystem();
        }
    }

    public static enum ConditionClinicalStatus {
        ACTIVE,
        RECURRENCE,
        INACTIVE,
        REMISSION,
        RESOLVED,
        NULL;


        public static ConditionClinicalStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("recurrence".equals(codeString)) {
                return RECURRENCE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("remission".equals(codeString)) {
                return REMISSION;
            }
            if ("resolved".equals(codeString)) {
                return RESOLVED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConditionClinicalStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case RECURRENCE: {
                    return "recurrence";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case REMISSION: {
                    return "remission";
                }
                case RESOLVED: {
                    return "resolved";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/condition-clinical";
                }
                case RECURRENCE: {
                    return "http://hl7.org/fhir/condition-clinical";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/condition-clinical";
                }
                case REMISSION: {
                    return "http://hl7.org/fhir/condition-clinical";
                }
                case RESOLVED: {
                    return "http://hl7.org/fhir/condition-clinical";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The subject is currently experiencing the symptoms of the condition or there is evidence of the condition.";
                }
                case RECURRENCE: {
                    return "The subject is having a relapse or re-experiencing the condition after a period of remission or presumed resolution.";
                }
                case INACTIVE: {
                    return "The subject is no longer experiencing the symptoms of the condition or there is no longer evidence of the condition.";
                }
                case REMISSION: {
                    return "The subject is no longer experiencing the symptoms of the condition, but there is a risk of the symptoms returning.";
                }
                case RESOLVED: {
                    return "The subject is no longer experiencing the symptoms of the condition and there is a negligible perceived risk of the symptoms returning.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case RECURRENCE: {
                    return "Recurrence";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case REMISSION: {
                    return "Remission";
                }
                case RESOLVED: {
                    return "Resolved";
                }
            }
            return "?";
        }
    }
}

