/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.DataElement;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.Extension;
import org.hl7.fhir.dstu2016may.model.ExtensionHelper;
import org.hl7.fhir.dstu2016may.model.Factory;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.MarkdownType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ToolingExtensions {
    public static final String EXT_SUBSUMES = "http://hl7.org/fhir/StructureDefinition/codesystem-subsumes";
    private static final String EXT_OID = "http://hl7.org/fhir/StructureDefinition/valueset-oid";
    public static final String EXT_DEFINITION = "http://hl7.org/fhir/StructureDefinition/valueset-definition";
    public static final String EXT_COMMENT = "http://hl7.org/fhir/StructureDefinition/valueset-comments";
    private static final String EXT_IDENTIFIER = "http://hl7.org/fhir/StructureDefinition/identifier";
    private static final String EXT_TRANSLATION = "http://hl7.org/fhir/StructureDefinition/translation";
    public static final String EXT_ISSUE_SOURCE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source";
    public static final String EXT_DISPLAY_HINT = "http://hl7.org/fhir/StructureDefinition/structuredefinition-display-hint";
    public static final String EXT_REPLACED_BY = "http://hl7.org/fhir/StructureDefinition/valueset-replacedby";
    public static final String EXT_JSON_TYPE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-json-type";
    public static final String EXT_XML_TYPE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-type";
    public static final String EXT_REGEX = "http://hl7.org/fhir/StructureDefinition/structuredefinition-regex";
    public static final String EXT_CONTROL = "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl";
    public static final String EXT_MINOCCURS = "http://hl7.org/fhir/StructureDefinition/questionnaire-minOccurs";
    public static final String EXT_MAXOCCURS = "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs";
    public static final String EXT_ALLOWEDRESOURCE = "http://hl7.org/fhir/StructureDefinition/questionnaire-allowedResource";
    public static final String EXT_REFERENCEFILTER = "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceFilter";
    private static final String EXT_FHIRTYPE = "http://hl7.org/fhir/StructureDefinition/questionnaire-fhirType";
    private static final String EXT_ALLOWABLE_UNITS = "http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits";
    public static final String EXT_CIMI_REFERENCE = "http://hl7.org/fhir/StructureDefinition/cimi-reference";
    public static final String EXT_UNCLOSED = "http://hl7.org/fhir/StructureDefinition/valueset-unclosed";
    public static final String EXT_FMM_LEVEL = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm";

    public static Extension makeIssueSource(ValidationMessage.Source source) {
        Extension ex = new Extension();
        ex.setUrl(EXT_ISSUE_SOURCE);
        CodeType c = new CodeType();
        c.setValue(source.toString());
        ex.setValue(c);
        return ex;
    }

    public static boolean hasExtension(DomainResource de, String url) {
        return ToolingExtensions.getExtension(de, url) != null;
    }

    public static boolean hasExtension(Element e, String url) {
        return ToolingExtensions.getExtension(e, url) != null;
    }

    public static void addStringExtension(DomainResource dr, String url, String content) {
        if (!StringUtils.isBlank(content)) {
            Extension ex = ToolingExtensions.getExtension(dr, url);
            if (ex != null) {
                ex.setValue(new StringType(content));
            } else {
                dr.getExtension().add(Factory.newExtension(url, new StringType(content), true));
            }
        }
    }

    public static void addMarkdownExtension(DomainResource dr, String url, String content) {
        if (!StringUtils.isBlank(content)) {
            Extension ex = ToolingExtensions.getExtension(dr, url);
            if (ex != null) {
                ex.setValue(new StringType(content));
            } else {
                dr.getExtension().add(Factory.newExtension(url, new MarkdownType(content), true));
            }
        }
    }

    public static void addStringExtension(Element e, String url, String content) {
        if (!StringUtils.isBlank(content)) {
            Extension ex = ToolingExtensions.getExtension(e, url);
            if (ex != null) {
                ex.setValue(new StringType(content));
            } else {
                e.getExtension().add(Factory.newExtension(url, new StringType(content), true));
            }
        }
    }

    public static void addIntegerExtension(DomainResource dr, String url, int value) {
        Extension ex = ToolingExtensions.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new IntegerType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new IntegerType(value), true));
        }
    }

    public static void addComment(Element nc, String comment) {
        if (!StringUtils.isBlank(comment)) {
            nc.getExtension().add(Factory.newExtension(EXT_COMMENT, Factory.newString_(comment), true));
        }
    }

    public static void addSubsumes(CodeSystem.ConceptDefinitionComponent nc, String code) {
        nc.getModifierExtension().add(Factory.newExtension(EXT_SUBSUMES, Factory.newCode(code), true));
    }

    public static void addDefinition(Element nc, String definition) {
        if (!StringUtils.isBlank(definition)) {
            nc.getExtension().add(Factory.newExtension(EXT_DEFINITION, Factory.newString_(definition), true));
        }
    }

    public static void addDisplayHint(Element def, String hint) {
        if (!StringUtils.isBlank(hint)) {
            def.getExtension().add(Factory.newExtension(EXT_DISPLAY_HINT, Factory.newString_(hint), true));
        }
    }

    public static String getDisplayHint(Element def) {
        return ToolingExtensions.readStringExtension(def, EXT_DISPLAY_HINT);
    }

    public static String readStringExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (ex.getValue() instanceof UriType) {
            return (String)((UriType)ex.getValue()).getValue();
        }
        if (!(ex.getValue() instanceof StringType)) {
            return null;
        }
        return (String)((StringType)ex.getValue()).getValue();
    }

    public static String readStringExtension(DomainResource c, String uri) {
        Extension ex = ToolingExtensions.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (ex.getValue() instanceof StringType) {
            return (String)((StringType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof UriType) {
            return (String)((UriType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof MarkdownType) {
            return (String)((MarkdownType)ex.getValue()).getValue();
        }
        return null;
    }

    public static PrimitiveType<Type> readPrimitiveExtension(DomainResource c, String uri) {
        Extension ex = ToolingExtensions.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        return (PrimitiveType)ex.getValue();
    }

    public static boolean findStringExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        if (!(ex.getValue() instanceof StringType)) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)((StringType)ex.getValue()).getValue());
    }

    public static Boolean readBooleanExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return null;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean findBooleanExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        return ex.getValue() instanceof BooleanType;
    }

    public static String getComment(CodeSystem.ConceptDefinitionComponent c) {
        return ToolingExtensions.readStringExtension(c, EXT_COMMENT);
    }

    public static boolean hasComment(CodeSystem.ConceptDefinitionComponent c) {
        return ToolingExtensions.findStringExtension(c, EXT_COMMENT);
    }

    public static List<CodeType> getSubsumes(CodeSystem.ConceptDefinitionComponent c) {
        ArrayList<CodeType> res = new ArrayList<CodeType>();
        for (Extension e : c.getExtension()) {
            if (!EXT_SUBSUMES.equals(e.getUrl())) continue;
            res.add((CodeType)e.getValue());
        }
        return res;
    }

    public static void addFlyOver(Questionnaire.QuestionnaireItemComponent item, String text) {
        if (!StringUtils.isBlank(text)) {
            Questionnaire.QuestionnaireItemComponent display = item.addItem();
            display.setType(Questionnaire.QuestionnaireItemType.DISPLAY);
            display.setText(text);
            display.getExtension().add(Factory.newExtension(EXT_CONTROL, Factory.newCodeableConcept("flyover", "http://hl7.org/fhir/questionnaire-item-control", "Fly-over"), true));
        }
    }

    public static void addMin(Questionnaire.QuestionnaireItemComponent item, int min2) {
        item.getExtension().add(Factory.newExtension(EXT_MINOCCURS, Factory.newInteger(min2), true));
    }

    public static void addMax(Questionnaire.QuestionnaireItemComponent item, int max) {
        item.getExtension().add(Factory.newExtension(EXT_MAXOCCURS, Factory.newInteger(max), true));
    }

    public static void addFhirType(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension(EXT_FHIRTYPE, Factory.newString_(value), true));
    }

    public static void addControl(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension(EXT_CONTROL, Factory.newCodeableConcept(value, "http://hl7.org/fhir/questionnaire-item-control", value), true));
    }

    public static void addAllowedResource(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension(EXT_ALLOWEDRESOURCE, Factory.newCode(value), true));
    }

    public static void addReferenceFilter(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension(EXT_REFERENCEFILTER, Factory.newString_(value), true));
    }

    public static void addIdentifier(Element element, Identifier value) {
        element.getExtension().add(Factory.newExtension(EXT_IDENTIFIER, value, true));
    }

    public static Extension getExtension(DomainResource resource, String name) {
        if (name == null) {
            return null;
        }
        if (!resource.hasExtension()) {
            return null;
        }
        for (Extension e : resource.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return e;
        }
        return null;
    }

    public static Extension getExtension(Element el, String name) {
        if (name == null) {
            return null;
        }
        if (!el.hasExtension()) {
            return null;
        }
        for (Extension e : el.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return e;
        }
        return null;
    }

    public static void setStringExtension(DomainResource resource, String uri, String value) {
        Extension ext = ToolingExtensions.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new StringType(value));
        } else {
            resource.getExtension().add(new Extension(new UriType(uri)).setValue(new StringType(value)));
        }
    }

    public static String getOID(CodeSystem define) {
        return ToolingExtensions.readStringExtension(define, EXT_OID);
    }

    public static String getOID(ValueSet vs) {
        return ToolingExtensions.readStringExtension(vs, EXT_OID);
    }

    public static void setOID(CodeSystem define, String oid) throws FHIRFormatError, URISyntaxException {
        if (!oid.startsWith("urn:oid:")) {
            throw new FHIRFormatError("Error in OID format");
        }
        if (oid.startsWith("urn:oid:urn:oid:")) {
            throw new FHIRFormatError("Error in OID format");
        }
        if (!ToolingExtensions.hasExtension(define, EXT_OID)) {
            define.getExtension().add(Factory.newExtension(EXT_OID, Factory.newUri(oid), false));
        } else if (!oid.equals(ToolingExtensions.readStringExtension(define, EXT_OID))) {
            throw new Error("Attempt to assign multiple OIDs to a code system");
        }
    }

    public static void setOID(ValueSet vs, String oid) throws FHIRFormatError, URISyntaxException {
        if (!oid.startsWith("urn:oid:")) {
            throw new FHIRFormatError("Error in OID format");
        }
        if (oid.startsWith("urn:oid:urn:oid:")) {
            throw new FHIRFormatError("Error in OID format");
        }
        if (!ToolingExtensions.hasExtension(vs, EXT_OID)) {
            vs.getExtension().add(Factory.newExtension(EXT_OID, Factory.newUri(oid), false));
        } else if (!oid.equals(ToolingExtensions.readStringExtension(vs, EXT_OID))) {
            throw new Error("Attempt to assign multiple OIDs to value set " + vs.getName() + " (" + vs.getUrl() + "). Has " + ToolingExtensions.readStringExtension(vs, EXT_OID) + ", trying to add " + oid);
        }
    }

    public static boolean hasLanguageTranslation(Element element, String lang) {
        for (Extension e : element.getExtension()) {
            Extension e1;
            if (!e.getUrl().equals(EXT_TRANSLATION) || (e1 = ExtensionHelper.getExtension(e, "lang")) == null || !(e1.getValue() instanceof CodeType) || !((String)((CodeType)e.getValue()).getValue()).equals(lang)) continue;
            return true;
        }
        return false;
    }

    public static String getLanguageTranslation(Element element, String lang) {
        for (Extension e : element.getExtension()) {
            Extension e1;
            if (!e.getUrl().equals(EXT_TRANSLATION) || (e1 = ExtensionHelper.getExtension(e, "lang")) == null || !(e1.getValue() instanceof CodeType) || !((String)((CodeType)e.getValue()).getValue()).equals(lang)) continue;
            e1 = ExtensionHelper.getExtension(e, "content");
            return (String)((StringType)e.getValue()).getValue();
        }
        return null;
    }

    public static void addLanguageTranslation(Element element, String lang, String value) {
        Extension extension = new Extension().setUrl(EXT_TRANSLATION);
        extension.addExtension().setUrl("lang").setValue(new StringType(lang));
        extension.addExtension().setUrl("content").setValue(new StringType(value));
        element.getExtension().add(extension);
    }

    public static Type getAllowedUnits(ElementDefinition eld) {
        for (Extension e : eld.getExtension()) {
            if (!e.getUrl().equals(EXT_ALLOWABLE_UNITS)) continue;
            return e.getValue();
        }
        return null;
    }

    public static void setAllowableUnits(ElementDefinition eld, CodeableConcept cc) {
        for (Extension e : eld.getExtension()) {
            if (!e.getUrl().equals(EXT_ALLOWABLE_UNITS)) continue;
            e.setValue(cc);
            return;
        }
        eld.getExtension().add(new Extension().setUrl(EXT_ALLOWABLE_UNITS).setValue(cc));
    }

    public static List<Extension> getExtensions(Element element, String url) {
        ArrayList<Extension> results = new ArrayList<Extension>();
        for (Extension ex : element.getExtension()) {
            if (!ex.getUrl().equals(url)) continue;
            results.add(ex);
        }
        return results;
    }

    public static List<Extension> getExtensions(DomainResource resource, String url) {
        ArrayList<Extension> results = new ArrayList<Extension>();
        for (Extension ex : resource.getExtension()) {
            if (!ex.getUrl().equals(url)) continue;
            results.add(ex);
        }
        return results;
    }

    public static void addDEReference(DataElement de, String value) {
        for (Extension e : de.getExtension()) {
            if (!e.getUrl().equals(EXT_CIMI_REFERENCE)) continue;
            e.setValue(new UriType(value));
            return;
        }
        de.getExtension().add(new Extension().setUrl(EXT_CIMI_REFERENCE).setValue(new UriType(value)));
    }

    public static void setExtension(Element focus, String url, Coding c) {
        for (Extension e : focus.getExtension()) {
            if (!e.getUrl().equals(url)) continue;
            e.setValue(c);
            return;
        }
        focus.getExtension().add(new Extension().setUrl(url).setValue(c));
    }

    public static void removeExtension(DomainResource focus, String url) {
        Iterator<Extension> i = focus.getExtension().iterator();
        while (i.hasNext()) {
            Extension e = i.next();
            if (!e.getUrl().equals(url)) continue;
            i.remove();
        }
    }

    public static void removeExtension(Element focus, String url) {
        Iterator<Extension> i = focus.getExtension().iterator();
        while (i.hasNext()) {
            Extension e = i.next();
            if (!e.getUrl().equals(url)) continue;
            i.remove();
        }
    }

    public static boolean hasOID(ValueSet vs) {
        return ToolingExtensions.hasExtension(vs, EXT_OID);
    }

    public static void setStringExtension(Element element, String uri, String value) {
        Extension ext = ToolingExtensions.getExtension(element, uri);
        if (ext != null) {
            ext.setValue(new StringType(value));
        } else {
            element.getExtension().add(new Extension(new UriType(uri)).setValue(new StringType(value)));
        }
    }
}

