/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Parameters;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpansionCache;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.dstu2016may.utils.client.FHIRToolingClient;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.I18nBase;

public abstract class BaseWorkerContext
extends I18nBase
implements IWorkerContext {
    protected Map<String, CodeSystem> codeSystems = new HashMap<String, CodeSystem>();
    protected Set<String> nonSupportedCodeSystems = new HashSet<String>();
    protected Map<String, ValueSet> valueSets = new HashMap<String, ValueSet>();
    protected Map<String, ConceptMap> maps = new HashMap<String, ConceptMap>();
    protected ValueSetExpanderFactory expansionCache = new ValueSetExpansionCache(this);
    protected boolean cacheValidation;
    private Set<String> failed = new HashSet<String>();
    protected Map<String, Map<String, IWorkerContext.ValidationResult>> validationCache = new HashMap<String, Map<String, IWorkerContext.ValidationResult>>();
    protected FHIRToolingClient txServer;
    private Bundle bndCodeSystems;
    private Locale locale;
    private ResourceBundle i18Nmessages;

    @Override
    public CodeSystem fetchCodeSystem(String system) {
        return this.codeSystems.get(system);
    }

    @Override
    public boolean supportsSystem(String system) {
        CodeSystem cs;
        if (this.codeSystems.containsKey(system)) {
            return true;
        }
        if (this.nonSupportedCodeSystems.contains(system)) {
            return false;
        }
        if (system.startsWith("http://example.org") || system.startsWith("http://acme.com") || system.startsWith("http://hl7.org/fhir/valueset-") || system.startsWith("urn:oid:")) {
            return false;
        }
        System.out.println("check system " + system);
        if (this.bndCodeSystems == null) {
            this.bndCodeSystems = this.txServer.fetchFeed(this.txServer.getAddress() + "/CodeSystem?content=not-present&_summary=true&_count=1000");
        }
        for (Bundle.BundleEntryComponent be : this.bndCodeSystems.getEntry()) {
            cs = (CodeSystem)be.getResource();
            if (this.codeSystems.containsKey(cs.getUrl())) continue;
            this.codeSystems.put(cs.getUrl(), null);
        }
        for (Bundle.BundleEntryComponent be : this.bndCodeSystems.getEntry()) {
            cs = (CodeSystem)be.getResource();
            if (!system.equals(cs.getUrl())) continue;
            return true;
        }
        this.nonSupportedCodeSystems.add(system);
        return false;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("_limit", "10000");
            params.put("_incomplete", "true");
            params.put("profile", "http://www.healthintersections.com.au/fhir/expansion/no-details");
            ValueSet result = this.txServer.expandValueset(vs, params);
            return new ValueSetExpander.ValueSetExpansionOutcome(result);
        }
        catch (Exception e) {
            return new ValueSetExpander.ValueSetExpansionOutcome("Error expanding ValueSet \"" + vs.getUrl() + ": " + e.getMessage());
        }
    }

    private IWorkerContext.ValidationResult handleByCache(ValueSet vs, Coding coding, boolean tryCache) {
        String cacheId = this.cacheId(coding);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        if (cache == null) {
            cache = new HashMap<String, IWorkerContext.ValidationResult>();
            this.validationCache.put(vs.getUrl(), cache);
        }
        if (cache.containsKey(cacheId)) {
            return cache.get(cacheId);
        }
        if (!tryCache) {
            return null;
        }
        if (!this.cacheValidation) {
            return null;
        }
        if (this.failed.contains(vs.getUrl())) {
            return null;
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true);
        if (vse.getValueset() == null || this.notcomplete(vse.getValueset())) {
            this.failed.add(vs.getUrl());
            return null;
        }
        IWorkerContext.ValidationResult res = this.validateCode(coding, vse.getValueset());
        cache.put(cacheId, res);
        return res;
    }

    private boolean notcomplete(ValueSet vs) {
        if (!vs.hasExpansion()) {
            return true;
        }
        if (!vs.getExpansion().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-unclosed").isEmpty()) {
            return true;
        }
        return !vs.getExpansion().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-toocostly").isEmpty();
    }

    private IWorkerContext.ValidationResult handleByCache(ValueSet vs, CodeableConcept concept, boolean tryCache) {
        String cacheId = this.cacheId(concept);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        if (cache == null) {
            cache = new HashMap<String, IWorkerContext.ValidationResult>();
            this.validationCache.put(vs.getUrl(), cache);
        }
        if (cache.containsKey(cacheId)) {
            return cache.get(cacheId);
        }
        if (this.validationCache.containsKey(vs.getUrl()) && this.validationCache.get(vs.getUrl()).containsKey(cacheId)) {
            return this.validationCache.get(vs.getUrl()).get(cacheId);
        }
        if (!tryCache) {
            return null;
        }
        if (!this.cacheValidation) {
            return null;
        }
        if (this.failed.contains(vs.getUrl())) {
            return null;
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true);
        if (vse.getValueset() == null || this.notcomplete(vse.getValueset())) {
            this.failed.add(vs.getUrl());
            return null;
        }
        IWorkerContext.ValidationResult res = this.validateCode(concept, vse.getValueset());
        cache.put(cacheId, res);
        return res;
    }

    private String cacheId(Coding coding) {
        return "|" + coding.getSystem() + "|" + coding.getVersion() + "|" + coding.getCode() + "|" + coding.getDisplay();
    }

    private String cacheId(CodeableConcept cc) {
        StringBuilder b = new StringBuilder();
        for (Coding c : cc.getCoding()) {
            b.append("#");
            b.append(this.cacheId(c));
        }
        return b.toString();
    }

    private IWorkerContext.ValidationResult verifyCodeExternal(ValueSet vs, Coding coding, boolean tryCache) {
        IWorkerContext.ValidationResult res;
        IWorkerContext.ValidationResult validationResult = res = vs == null ? null : this.handleByCache(vs, coding, tryCache);
        if (res != null) {
            return res;
        }
        Parameters pin = new Parameters();
        pin.addParameter().setName("coding").setValue(coding);
        if (vs != null) {
            pin.addParameter().setName("valueSet").setResource(vs);
        }
        res = this.serverValidateCode(pin);
        if (vs != null) {
            Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
            cache.put(this.cacheId(coding), res);
        }
        return res;
    }

    private IWorkerContext.ValidationResult verifyCodeExternal(ValueSet vs, CodeableConcept cc, boolean tryCache) {
        IWorkerContext.ValidationResult res = this.handleByCache(vs, cc, tryCache);
        if (res != null) {
            return res;
        }
        Parameters pin = new Parameters();
        pin.addParameter().setName("codeableConcept").setValue(cc);
        pin.addParameter().setName("valueSet").setResource(vs);
        res = this.serverValidateCode(pin);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        cache.put(this.cacheId(cc), res);
        return res;
    }

    private IWorkerContext.ValidationResult serverValidateCode(Parameters pin) {
        Parameters pout = this.txServer.operateType(ValueSet.class, "validate-code", pin);
        boolean ok = false;
        String message = "No Message returned";
        String display = null;
        for (Parameters.ParametersParameterComponent p : pout.getParameter()) {
            if (p.getName().equals("result")) {
                ok = (Boolean)((BooleanType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("message")) {
                message = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (!p.getName().equals("display")) continue;
            display = (String)((StringType)p.getValue()).getValue();
        }
        if (!ok) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.ERROR, message);
        }
        if (display != null) {
            return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setDisplay(display));
        }
        return new IWorkerContext.ValidationResult(null);
    }

    @Override
    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent inc) {
        ValueSet vs = new ValueSet();
        vs.setCompose(new ValueSet.ValueSetComposeComponent());
        vs.getCompose().getInclude().add(inc);
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true);
        return vse.getValueset().getExpansion();
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display) {
        try {
            if (this.codeSystems.containsKey(system) && this.codeSystems.get(system) != null) {
                return this.verifyCodeInCodeSystem(this.codeSystems.get(system), system, code, display);
            }
            return this.verifyCodeExternal(null, new Coding().setSystem(system).setCode(code).setDisplay(display), false);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + system + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(Coding code, ValueSet vs) {
        try {
            if (this.codeSystems.containsKey(code.getSystem()) && this.codeSystems.get(code.getSystem()) != null) {
                return this.verifyCodeInCodeSystem(this.codeSystems.get(code.getSystem()), code.getSystem(), code.getCode(), code.getDisplay());
            }
            if (vs.hasExpansion()) {
                return this.verifyCodeInternal(vs, code.getSystem(), code.getCode(), code.getDisplay());
            }
            return this.verifyCodeExternal(vs, code, true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + code.getSystem() + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(CodeableConcept code, ValueSet vs) {
        try {
            if (vs.hasExpansion()) {
                return this.verifyCodeInternal(vs, code);
            }
            return this.verifyCodeExternal(vs, code, true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.FATAL, "Error validating code \"" + code.toString() + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display, ValueSet vs) {
        try {
            if (system == null && display == null) {
                return this.verifyCodeInternal(vs, code);
            }
            if (this.codeSystems.containsKey(system) && this.codeSystems.get(system) != null || vs.hasExpansion()) {
                return this.verifyCodeInternal(vs, system, code, display);
            }
            return this.verifyCodeExternal(vs, new Coding().setSystem(system).setCode(code).setDisplay(display), true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + system + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display, ValueSet.ConceptSetComponent vsi) {
        try {
            ValueSet vs = new ValueSet().setUrl(Utilities.makeUuidUrn());
            vs.getCompose().addInclude(vsi);
            return this.verifyCodeExternal(vs, new Coding().setSystem(system).setCode(code).setDisplay(display), true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + system + "\": " + e.getMessage());
        }
    }

    @Override
    public List<ConceptMap> findMapsForSource(String url) {
        ArrayList<ConceptMap> res = new ArrayList<ConceptMap>();
        for (ConceptMap map : this.maps.values()) {
            if (!((Reference)map.getSource()).getReference().equals(url)) continue;
            res.add(map);
        }
        return res;
    }

    private IWorkerContext.ValidationResult verifyCodeInternal(ValueSet vs, CodeableConcept code) throws FileNotFoundException, ValueSetExpander.ETooCostly, IOException {
        for (Coding c : code.getCoding()) {
            IWorkerContext.ValidationResult res = this.verifyCodeInternal(vs, c.getSystem(), c.getCode(), c.getDisplay());
            if (!res.isOk()) continue;
            return res;
        }
        if (code.getCoding().isEmpty()) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.ERROR, "None code provided");
        }
        return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.ERROR, "None of the codes are in the specified value set");
    }

    private IWorkerContext.ValidationResult verifyCodeInternal(ValueSet vs, String system, String code, String display) throws FileNotFoundException, ValueSetExpander.ETooCostly, IOException {
        if (vs.hasExpansion()) {
            return this.verifyCodeInExpansion(vs, system, code, display);
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expansionCache.getExpander().expand(vs);
        if (vse.getValueset() != null) {
            return this.verifyCodeExternal(vs, new Coding().setSystem(system).setCode(code).setDisplay(display), false);
        }
        return this.verifyCodeInExpansion(vse.getValueset(), system, code, display);
    }

    private IWorkerContext.ValidationResult verifyCodeInternal(ValueSet vs, String code) throws FileNotFoundException, ValueSetExpander.ETooCostly, IOException {
        if (vs.hasExpansion()) {
            return this.verifyCodeInExpansion(vs, code);
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expansionCache.getExpander().expand(vs);
        return this.verifyCodeInExpansion(vse.getValueset(), code);
    }

    private IWorkerContext.ValidationResult verifyCodeInCodeSystem(CodeSystem cs, String system, String code, String display) {
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code);
        if (cc == null) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.ERROR, "Unknown Code " + code + " in " + cs.getUrl());
        }
        if (display == null) {
            return new IWorkerContext.ValidationResult(cc);
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (cc.hasDisplay()) {
            b.append(cc.getDisplay());
            if (display.equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(cc);
            }
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent ds : cc.getDesignation()) {
            b.append(ds.getValue());
            if (!display.equalsIgnoreCase(ds.getValue())) continue;
            return new IWorkerContext.ValidationResult(cc);
        }
        return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.ERROR, "Display Name for " + code + " must be one of '" + b.toString() + "'");
    }

    private IWorkerContext.ValidationResult verifyCodeInExpansion(ValueSet vs, String system, String code, String display) {
        ValueSet.ValueSetExpansionContainsComponent cc = this.findCode(vs.getExpansion().getContains(), code);
        if (cc == null) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.ERROR, "Unknown Code " + code + " in " + vs.getUrl());
        }
        if (display == null) {
            return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setCode(code).setDisplay(cc.getDisplay()));
        }
        if (cc.hasDisplay()) {
            if (display.equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setCode(code).setDisplay(cc.getDisplay()));
            }
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.ERROR, "Display Name for " + code + " must be '" + cc.getDisplay() + "'");
        }
        return null;
    }

    private IWorkerContext.ValidationResult verifyCodeInExpansion(ValueSet vs, String code) {
        ValueSet.ValueSetExpansionContainsComponent cc = this.findCode(vs.getExpansion().getContains(), code);
        if (cc == null) {
            return new IWorkerContext.ValidationResult(OperationOutcome.IssueSeverity.ERROR, "Unknown Code " + code + " in " + vs.getUrl());
        }
        return null;
    }

    private ValueSet.ValueSetExpansionContainsComponent findCode(List<ValueSet.ValueSetExpansionContainsComponent> contains, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            ValueSet.ValueSetExpansionContainsComponent c = this.findCode(cc.getContains(), code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(List<CodeSystem.ConceptDefinitionComponent> concept, String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCodeInConcept(cc.getConcept(), code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public Set<String> getNonSupportedCodeSystems() {
        return this.nonSupportedCodeSystems;
    }

    @Override
    public StructureDefinition fetchTypeDefinition(String typeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }
}

