/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum TestscriptProfileDestinationTypes {
    FHIRSERVER,
    FHIRSDCFORMMANAGER,
    FHIRSDCFORMPROCESSOR,
    FHIRSDCFORMRECEIVER,
    NULL;


    public static TestscriptProfileDestinationTypes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("FHIR-Server".equals(codeString)) {
            return FHIRSERVER;
        }
        if ("FHIR-SDC-FormManager".equals(codeString)) {
            return FHIRSDCFORMMANAGER;
        }
        if ("FHIR-SDC-FormProcessor".equals(codeString)) {
            return FHIRSDCFORMPROCESSOR;
        }
        if ("FHIR-SDC-FormReceiver".equals(codeString)) {
            return FHIRSDCFORMRECEIVER;
        }
        throw new FHIRException("Unknown TestscriptProfileDestinationTypes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FHIRSERVER: {
                return "FHIR-Server";
            }
            case FHIRSDCFORMMANAGER: {
                return "FHIR-SDC-FormManager";
            }
            case FHIRSDCFORMPROCESSOR: {
                return "FHIR-SDC-FormProcessor";
            }
            case FHIRSDCFORMRECEIVER: {
                return "FHIR-SDC-FormReceiver";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/testscript-profile-destination-types";
    }

    public String getDefinition() {
        switch (this) {
            case FHIRSERVER: {
                return "General FHIR server used to respond to operations sent from a FHIR client.";
            }
            case FHIRSDCFORMMANAGER: {
                return "A FHIR server acting as a Structured Data Capture Form Manager.";
            }
            case FHIRSDCFORMPROCESSOR: {
                return "A FHIR server acting as a Structured Data Capture Form Processor.";
            }
            case FHIRSDCFORMRECEIVER: {
                return "A FHIR server acting as a Structured Data Capture Form Receiver.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FHIRSERVER: {
                return "FHIR Server";
            }
            case FHIRSDCFORMMANAGER: {
                return "FHIR SDC FormManager";
            }
            case FHIRSDCFORMPROCESSOR: {
                return "FHIR SDC FormProcessor";
            }
            case FHIRSDCFORMRECEIVER: {
                return "FHIR SDC FormReceiver";
            }
        }
        return "?";
    }
}

