/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.SubscriptionChannelType;

public class SubscriptionChannelTypeEnumFactory
implements EnumFactory<SubscriptionChannelType> {
    @Override
    public SubscriptionChannelType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("rest-hook".equals(codeString)) {
            return SubscriptionChannelType.RESTHOOK;
        }
        if ("websocket".equals(codeString)) {
            return SubscriptionChannelType.WEBSOCKET;
        }
        if ("email".equals(codeString)) {
            return SubscriptionChannelType.EMAIL;
        }
        if ("sms".equals(codeString)) {
            return SubscriptionChannelType.SMS;
        }
        if ("message".equals(codeString)) {
            return SubscriptionChannelType.MESSAGE;
        }
        throw new IllegalArgumentException("Unknown SubscriptionChannelType code '" + codeString + "'");
    }

    @Override
    public String toCode(SubscriptionChannelType code) {
        if (code == SubscriptionChannelType.RESTHOOK) {
            return "rest-hook";
        }
        if (code == SubscriptionChannelType.WEBSOCKET) {
            return "websocket";
        }
        if (code == SubscriptionChannelType.EMAIL) {
            return "email";
        }
        if (code == SubscriptionChannelType.SMS) {
            return "sms";
        }
        if (code == SubscriptionChannelType.MESSAGE) {
            return "message";
        }
        return "?";
    }

    @Override
    public String toSystem(SubscriptionChannelType code) {
        return code.getSystem();
    }
}

