/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaNehtaPerforationType {
    THROUGHTUMOURPRIORTOSURGERY,
    THROUGHTUMOURDURINGSURGERYMOBILISATION,
    AWAYFROMTUMOUR,
    NULL;


    public static NehtaNehtaPerforationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("through_tumour_prior_to_surgery".equals(codeString)) {
            return THROUGHTUMOURPRIORTOSURGERY;
        }
        if ("through_tumour_during_surgery_mobilisation".equals(codeString)) {
            return THROUGHTUMOURDURINGSURGERYMOBILISATION;
        }
        if ("away_from_tumour".equals(codeString)) {
            return AWAYFROMTUMOUR;
        }
        throw new FHIRException("Unknown NehtaNehtaPerforationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case THROUGHTUMOURPRIORTOSURGERY: {
                return "through_tumour_prior_to_surgery";
            }
            case THROUGHTUMOURDURINGSURGERYMOBILISATION: {
                return "through_tumour_during_surgery_mobilisation";
            }
            case AWAYFROMTUMOUR: {
                return "away_from_tumour";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nehta-nature-of-perforation";
    }

    public String getDefinition() {
        switch (this) {
            case THROUGHTUMOURPRIORTOSURGERY: {
                return "The perforation was through tumour prior to surgery";
            }
            case THROUGHTUMOURDURINGSURGERYMOBILISATION: {
                return "The perforation was through tumour during surgery mobilisation";
            }
            case AWAYFROMTUMOUR: {
                return "The perforation was away from the tumour";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case THROUGHTUMOURPRIORTOSURGERY: {
                return "Through tumour prior to surgery";
            }
            case THROUGHTUMOURDURINGSURGERYMOBILISATION: {
                return "Through tumour during surgery mobilisation";
            }
            case AWAYFROMTUMOUR: {
                return "Away from tumour";
            }
        }
        return "?";
    }
}

