/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ModuleMetadataStatus {
    DRAFT,
    ACTIVE,
    INACTIVE,
    NULL;


    public static ModuleMetadataStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        throw new FHIRException("Unknown ModuleMetadataStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ACTIVE: {
                return "active";
            }
            case INACTIVE: {
                return "inactive";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/module-metadata-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "The module is in draft state";
            }
            case ACTIVE: {
                return "The module is active";
            }
            case INACTIVE: {
                return "The module is inactive, either rejected before publication, or retired after publication";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case ACTIVE: {
                return "Active";
            }
            case INACTIVE: {
                return "Inactive";
            }
        }
        return "?";
    }
}

