/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.MapModelMode;

public class MapModelModeEnumFactory
implements EnumFactory<MapModelMode> {
    @Override
    public MapModelMode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("source".equals(codeString)) {
            return MapModelMode.SOURCE;
        }
        if ("queried".equals(codeString)) {
            return MapModelMode.QUERIED;
        }
        if ("target".equals(codeString)) {
            return MapModelMode.TARGET;
        }
        if ("produced".equals(codeString)) {
            return MapModelMode.PRODUCED;
        }
        throw new IllegalArgumentException("Unknown MapModelMode code '" + codeString + "'");
    }

    @Override
    public String toCode(MapModelMode code) {
        if (code == MapModelMode.SOURCE) {
            return "source";
        }
        if (code == MapModelMode.QUERIED) {
            return "queried";
        }
        if (code == MapModelMode.TARGET) {
            return "target";
        }
        if (code == MapModelMode.PRODUCED) {
            return "produced";
        }
        return "?";
    }

    @Override
    public String toSystem(MapModelMode code) {
        return code.getSystem();
    }
}

