/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcPatientTelecomSystem {
    FAX,
    EMAIL,
    PHONE,
    NULL;


    public static HspcPatientTelecomSystem fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("fax".equals(codeString)) {
            return FAX;
        }
        if ("email".equals(codeString)) {
            return EMAIL;
        }
        if ("phone".equals(codeString)) {
            return PHONE;
        }
        throw new FHIRException("Unknown HspcPatientTelecomSystem code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FAX: {
                return "fax";
            }
            case EMAIL: {
                return "email";
            }
            case PHONE: {
                return "phone";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/patient-hspc-telecomSystem";
    }

    public String getDefinition() {
        switch (this) {
            case FAX: {
                return "Method of communication which uses telephone lines to send and receive printed documents between facsimile devices.";
            }
            case EMAIL: {
                return "Electronic mail.";
            }
            case PHONE: {
                return "Telephone.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FAX: {
                return "fax";
            }
            case EMAIL: {
                return "email";
            }
            case PHONE: {
                return "phone";
            }
        }
        return "?";
    }
}

