/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcAbnIntNumericNom {
    HIGHER,
    LOWER,
    NULL;


    public static HspcAbnIntNumericNom fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("higher".equals(codeString)) {
            return HIGHER;
        }
        if ("lower".equals(codeString)) {
            return LOWER;
        }
        throw new FHIRException("Unknown HspcAbnIntNumericNom code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HIGHER: {
                return "higher";
            }
            case LOWER: {
                return "lower";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://healthcaresoa.org/fhir/hspc-abnInt-NumericNom";
    }

    public String getDefinition() {
        switch (this) {
            case HIGHER: {
                return "The results were lower than the technical limits of the test procedure";
            }
            case LOWER: {
                return "The results were higher than the technical limits of the test procedure";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HIGHER: {
                return "Higher than technical";
            }
            case LOWER: {
                return "Lower than technical";
            }
        }
        return "?";
    }
}

