/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.EncounterPriority;

public class EncounterPriorityEnumFactory
implements EnumFactory<EncounterPriority> {
    @Override
    public EncounterPriority fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("imm".equals(codeString)) {
            return EncounterPriority.IMM;
        }
        if ("emg".equals(codeString)) {
            return EncounterPriority.EMG;
        }
        if ("urg".equals(codeString)) {
            return EncounterPriority.URG;
        }
        if ("s-urg".equals(codeString)) {
            return EncounterPriority.SURG;
        }
        if ("no-urg".equals(codeString)) {
            return EncounterPriority.NOURG;
        }
        throw new IllegalArgumentException("Unknown EncounterPriority code '" + codeString + "'");
    }

    @Override
    public String toCode(EncounterPriority code) {
        if (code == EncounterPriority.IMM) {
            return "imm";
        }
        if (code == EncounterPriority.EMG) {
            return "emg";
        }
        if (code == EncounterPriority.URG) {
            return "urg";
        }
        if (code == EncounterPriority.SURG) {
            return "s-urg";
        }
        if (code == EncounterPriority.NOURG) {
            return "no-urg";
        }
        return "?";
    }

    @Override
    public String toSystem(EncounterPriority code) {
        return code.getSystem();
    }
}

