/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.DigitalMediaType;

public class DigitalMediaTypeEnumFactory
implements EnumFactory<DigitalMediaType> {
    @Override
    public DigitalMediaType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("photo".equals(codeString)) {
            return DigitalMediaType.PHOTO;
        }
        if ("video".equals(codeString)) {
            return DigitalMediaType.VIDEO;
        }
        if ("audio".equals(codeString)) {
            return DigitalMediaType.AUDIO;
        }
        throw new IllegalArgumentException("Unknown DigitalMediaType code '" + codeString + "'");
    }

    @Override
    public String toCode(DigitalMediaType code) {
        if (code == DigitalMediaType.PHOTO) {
            return "photo";
        }
        if (code == DigitalMediaType.VIDEO) {
            return "video";
        }
        if (code == DigitalMediaType.AUDIO) {
            return "audio";
        }
        return "?";
    }

    @Override
    public String toSystem(DigitalMediaType code) {
        return code.getSystem();
    }
}

