/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClaimUseLink {
    COMPLETE,
    PROPOSED,
    EXPLORATORY,
    OTHER,
    NULL;


    public static ClaimUseLink fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        if ("proposed".equals(codeString)) {
            return PROPOSED;
        }
        if ("exploratory".equals(codeString)) {
            return EXPLORATORY;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown ClaimUseLink code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COMPLETE: {
                return "complete";
            }
            case PROPOSED: {
                return "proposed";
            }
            case EXPLORATORY: {
                return "exploratory";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/claim-use-link";
    }

    public String getDefinition() {
        switch (this) {
            case COMPLETE: {
                return "The treatment is complete and this represents a Claim for the services.";
            }
            case PROPOSED: {
                return "The treatment is proposed and this represents a Pre-authorization for the services.";
            }
            case EXPLORATORY: {
                return "The treatment is proposed and this represents a Pre-determination for the services.";
            }
            case OTHER: {
                return "A locally defined or otherwise resolved status.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COMPLETE: {
                return "Complete";
            }
            case PROPOSED: {
                return "Proposed";
            }
            case EXPLORATORY: {
                return "Exploratory";
            }
            case OTHER: {
                return "Other";
            }
        }
        return "?";
    }
}

